/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.medias;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.medias.VlTNTChannel;
import org.videolan.vlma.common.medias.VlFilesChannel;
import org.videolan.vlma.common.programs.VlProgram;

public class MediasProgramAddFormController extends SimpleFormController {

    private IVlData data;
    
    private String successViewMedias;
    
    private String successViewFiles;

    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }
    
    public String getSuccessViewMedias() {
        return successViewMedias;
    }
    
    public void setSuccessViewMedias(String successViewMedias) {
        this.successViewMedias = successViewMedias;
    }
    
    public String getSuccessViewFiles() {
        return successViewFiles;
    }    
    
    public void setSuccessViewFiles(String successViewFiles) {
        this.successViewFiles = successViewFiles;
    }
    
    public ModelAndView onSubmit(Object command) throws ServletException,
            MalformedURLException, IOException {
        MediasProgramAdd mediasProgramAdd = (MediasProgramAdd) command;
        
        int mediaId = mediasProgramAdd.getMediaId();
        IVlMedia media = data.getMedia(mediaId);
        
        VlProgram program = data.addMediaProgram(mediaId);
        program.setPriority(Integer.parseInt(mediasProgramAdd.getPriority()));
        program.setSapName(mediasProgramAdd.getSap());
        data.updateMediaProgram(mediasProgramAdd.getMediaId(), program);
        
        //Determine the success view with the media class
        String successView = new String();
        if (media.getClass() == VlFilesChannel.class) {
            successView = getSuccessViewFiles();
        }
        else {
            successView = getSuccessViewMedias();
        }
        
        return new ModelAndView(new RedirectView(successView));
    }

    protected Object formBackingObject(HttpServletRequest request)
            throws ServletException {
        MediasProgramAdd mediasProgramAdd = new MediasProgramAdd();
        int mediaId = Integer.parseInt(request.getParameter("media"));
        IVlMedia media = data.getMedia(mediaId);
        mediasProgramAdd.setPriority("10");
        if (media.getClass() == VlSatChannel.class){
            String country = new String(((VlSatChannel)media).getCountry());  
            if ( country != "")
                mediasProgramAdd.setSap("[" + country + "] " + media.getName());
            else
                mediasProgramAdd.setSap(media.getName());
        }
            mediasProgramAdd.setSap(media.getName());
            
        mediasProgramAdd.setMediaId(mediaId);
        mediasProgramAdd.setData(data);
        return mediasProgramAdd;
    }

    @Override
    protected ModelAndView showForm(HttpServletRequest arg0,
            HttpServletResponse arg1, BindException arg2, Map arg3)
            throws Exception {
        int mediaId = Integer.parseInt(arg0.getParameter("media"));
        Map<String, Object> m = new HashMap<String, Object>();
        m.put("media", data.getMedia(mediaId));
        return super.showForm(arg0, arg1, arg2, m);
    }

}
