/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Copyright (C) 2024 PHYTEC Messtechnik GmbH
 * Author: Wadim Egorov <w.egorov@phytec.de>
 */

#ifndef PHYCORE_DDR_DATA
#define PHYCORE_DDR_DATA

#include "../common/k3/k3_ddrss_patch.h"

/* 1 GB variant delta */
struct ddr_reg ddr_1gb_ctl_regs[] = {
	{ 55, 0x0400DB60 },
	{ 58, 0x0400DB60 },
	{ 61, 0x0400DB60 },
	{ 73, 0x00001860 },
	{ 75, 0x00001860 },
	{ 77, 0x00001860 },
	{ 119, 0x00061800 },
	{ 120, 0x00061800 },
	{ 121, 0x00061800 },
	{ 122, 0x00061800 },
	{ 123, 0x00061800 },
	{ 125, 0x0000AAA0 },
	{ 126, 0x00061800 },
	{ 127, 0x00061800 },
	{ 128, 0x00061800 },
	{ 129, 0x00061800 },
	{ 130, 0x00061800 },
	{ 132, 0x0000AAA0 },
	{ 133, 0x00061800 },
	{ 134, 0x00061800 },
	{ 135, 0x00061800 },
	{ 136, 0x00061800 },
	{ 137, 0x00061800 },
	{ 139, 0x0000AAA0 },
	{ 206, 0x00000000 },
	{ 209, 0x00000000 },
	{ 212, 0x00000000 },
	{ 215, 0x00000000 },
	{ 218, 0x00000000 },
	{ 221, 0x00000000 },
	{ 230, 0x00000000 },
	{ 231, 0x00000000 },
	{ 232, 0x00000000 },
	{ 233, 0x00000000 },
	{ 234, 0x00000000 },
	{ 235, 0x00000000 },
	{ 316, 0x01010000 },
	{ 318, 0x3FFF0000 },
	{ 327, 0x00000C01 },
	{ 328, 0x00000000 },
	{ 385, 0x000030C0 },
	{ 390, 0x0000DB60 },
	{ 391, 0x0001E780 },
	{ 394, 0x000030C0 },
	{ 399, 0x0000DB60 },
	{ 400, 0x0001E780 },
	{ 403, 0x000030C0 },
	{ 408, 0x0000DB60 },
	{ 409, 0x0001E780 }
};

struct ddr_reg ddr_1gb_pi_regs[] = {
	{ 77, 0x04000100 },
	{ 176, 0x00001860 },
	{ 178, 0x00001860 },
	{ 180, 0x04001860 },
	{ 233, 0x0000C570 },
	{ 238, 0x0000C570 },
	{ 243, 0x0000C570 },
	{ 247, 0x000030C0 },
	{ 248, 0x0001E780 },
	{ 249, 0x000030C0 },
	{ 250, 0x0001E780 },
	{ 251, 0x000030C0 },
	{ 252, 0x0001E780 },
	{ 299, 0x00000000 },
	{ 301, 0x00000000 },
	{ 307, 0x00000000 },
	{ 309, 0x00000000 },
	{ 315, 0x00000000 },
	{ 317, 0x00000000 },
	{ 323, 0x00000000 },
	{ 325, 0x00000000 },
	{ 331, 0x00000000 },
	{ 333, 0x00000000 },
	{ 339, 0x00000000 },
	{ 341, 0x00000000 }
};

struct ddr_reg ddr_1gb_phy_regs[] = {
	{ 1371, 0x0001F7C2 },
};

/* 4 GB variant delta */
struct ddr_reg ddr_4gb_ctl_regs[] = {
	{ 55, 0x0400DB60 },
	{ 58, 0x0400DB60 },
	{ 61, 0x0400DB60 },
	{ 73, 0x00001860 },
	{ 75, 0x00001860 },
	{ 77, 0x00001860 },
	{ 119, 0x00061800 },
	{ 120, 0x00061800 },
	{ 121, 0x00061800 },
	{ 122, 0x00061800 },
	{ 123, 0x00061800 },
	{ 125, 0x0000AAA0 },
	{ 126, 0x00061800 },
	{ 127, 0x00061800 },
	{ 128, 0x00061800 },
	{ 129, 0x00061800 },
	{ 130, 0x00061800 },
	{ 132, 0x0000AAA0 },
	{ 133, 0x00061800 },
	{ 134, 0x00061800 },
	{ 135, 0x00061800 },
	{ 136, 0x00061800 },
	{ 137, 0x00061800 },
	{ 139, 0x0000AAA0 },
	{ 206, 0x00000000 },
	{ 209, 0x00000000 },
	{ 212, 0x00000000 },
	{ 215, 0x00000000 },
	{ 218, 0x00000000 },
	{ 221, 0x00000000 },
	{ 230, 0x00000000 },
	{ 231, 0x00000000 },
	{ 232, 0x00000000 },
	{ 233, 0x00000000 },
	{ 234, 0x00000000 },
	{ 235, 0x00000000 },
	{ 316, 0x00000000 },
	{ 318, 0x7FFF0000 },
	{ 327, 0x01000C01 },
	{ 328, 0x00000001 },
	{ 385, 0x000030C0 },
	{ 390, 0x0000DB60 },
	{ 391, 0x0001E780 },
	{ 394, 0x000030C0 },
	{ 399, 0x0000DB60 },
	{ 400, 0x0001E780 },
	{ 403, 0x000030C0 },
	{ 408, 0x0000DB60 },
	{ 409, 0x0001E780 }
};

struct ddr_reg ddr_4gb_pi_regs[] = {
	{ 77, 0x04000000 },
	{ 176, 0x00001860 },
	{ 178, 0x00001860 },
	{ 180, 0x04001860 },
	{ 233, 0x0000C570 },
	{ 238, 0x0000C570 },
	{ 243, 0x0000C570 },
	{ 247, 0x000030C0 },
	{ 248, 0x0001E780 },
	{ 249, 0x000030C0 },
	{ 250, 0x0001E780 },
	{ 251, 0x000030C0 },
	{ 252, 0x0001E780 },
	{ 299, 0x00000000 },
	{ 301, 0x00000000 },
	{ 307, 0x00000000 },
	{ 309, 0x00000000 },
	{ 315, 0x00000000 },
	{ 317, 0x00000000 },
	{ 323, 0x00000000 },
	{ 325, 0x00000000 },
	{ 331, 0x00000000 },
	{ 333, 0x00000000 },
	{ 339, 0x00000000 },
	{ 341, 0x00000000 }
};

struct ddr_reg ddr_4gb_phy_regs[] = {
	{ 1371, 0x0001F7C2 },
};

enum {
	PHYCORE_1GB,
	PHYCORE_4GB,
};

struct ddrss phycore_ddrss_data[] = {
	[PHYCORE_1GB] = {
		.ctl_regs = &ddr_1gb_ctl_regs[0],
		.ctl_regs_num = ARRAY_SIZE(ddr_1gb_ctl_regs),
		.pi_regs = &ddr_1gb_pi_regs[0],
		.pi_regs_num = ARRAY_SIZE(ddr_1gb_pi_regs),
		.phy_regs = &ddr_1gb_phy_regs[0],
		.phy_regs_num = ARRAY_SIZE(ddr_1gb_phy_regs),
	},
	[PHYCORE_4GB] = {
		.ctl_regs = &ddr_4gb_ctl_regs[0],
		.ctl_regs_num = ARRAY_SIZE(ddr_4gb_ctl_regs),
		.pi_regs = &ddr_4gb_pi_regs[0],
		.pi_regs_num = ARRAY_SIZE(ddr_4gb_pi_regs),
		.phy_regs = &ddr_4gb_phy_regs[0],
		.phy_regs_num = ARRAY_SIZE(ddr_4gb_phy_regs),
	},
};

#endif /* PHYCORE_DDR_DATA */
