// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2015 Realtek Semiconductor Corp. All rights reserved.
 *
  */
#include <common.h>
#include <dm.h>
#include <errno.h>
#include <linux/bitops.h>
#include <linux/delay.h>
#include "usb_ether.h"
#include "r8152.h"

static u8 r8152b_pla_patch_a[] = {
	0x08, 0xe0, 0x40, 0xe0, 0x78, 0xe0, 0x85, 0xe0,
	0x5d, 0xe1, 0xa1, 0xe1, 0xa3, 0xe1, 0xab, 0xe1,
	0x31, 0xc3, 0x60, 0x72, 0xa0, 0x49, 0x10, 0xf0,
	0xa4, 0x49, 0x0e, 0xf0, 0x2c, 0xc3, 0x62, 0x72,
	0x26, 0x70, 0x80, 0x49, 0x05, 0xf0, 0x2f, 0x48,
	0x62, 0x9a, 0x24, 0x70, 0x60, 0x98, 0x24, 0xc3,
	0x60, 0x99, 0x23, 0xc3, 0x00, 0xbb, 0x2c, 0x75,
	0xdc, 0x21, 0xbc, 0x25, 0x04, 0x13, 0x0a, 0xf0,
	0x03, 0x13, 0x08, 0xf0, 0x02, 0x13, 0x06, 0xf0,
	0x01, 0x13, 0x04, 0xf0, 0x08, 0x13, 0x02, 0xf0,
	0x03, 0xe0, 0xd4, 0x49, 0x04, 0xf1, 0x14, 0xc2,
	0x12, 0xc3, 0x00, 0xbb, 0x12, 0xc3, 0x60, 0x75,
	0xd0, 0x49, 0x05, 0xf1, 0x50, 0x48, 0x60, 0x9d,
	0x09, 0xc6, 0x00, 0xbe, 0xd0, 0x48, 0x60, 0x9d,
	0xf3, 0xe7, 0xc2, 0xc0, 0x38, 0xd2, 0xc6, 0xd2,
	0x84, 0x17, 0xa2, 0x13, 0x0c, 0x17, 0xbc, 0xc0,
	0xa2, 0xd1, 0x33, 0xc5, 0xa0, 0x74, 0xc0, 0x49,
	0x1f, 0xf0, 0x30, 0xc5, 0xa0, 0x73, 0x00, 0x13,
	0x04, 0xf1, 0xa2, 0x73, 0x00, 0x13, 0x14, 0xf0,
	0x28, 0xc5, 0xa0, 0x74, 0xc8, 0x49, 0x1b, 0xf1,
	0x26, 0xc5, 0xa0, 0x76, 0xa2, 0x74, 0x01, 0x06,
	0x20, 0x37, 0xa0, 0x9e, 0xa2, 0x9c, 0x1e, 0xc5,
	0xa2, 0x73, 0x23, 0x40, 0x10, 0xf8, 0x04, 0xf3,
	0xa0, 0x73, 0x33, 0x40, 0x0c, 0xf8, 0x15, 0xc5,
	0xa0, 0x74, 0x41, 0x48, 0xa0, 0x9c, 0x14, 0xc5,
	0xa0, 0x76, 0x62, 0x48, 0xe0, 0x48, 0xa0, 0x9e,
	0x10, 0xc6, 0x00, 0xbe, 0x0a, 0xc5, 0xa0, 0x74,
	0x48, 0x48, 0xa0, 0x9c, 0x0b, 0xc5, 0x20, 0x1e,
	0xa0, 0x9e, 0xe5, 0x48, 0xa0, 0x9e, 0xf0, 0xe7,
	0xbc, 0xc0, 0xc8, 0xd2, 0xcc, 0xd2, 0x28, 0xe4,
	0x22, 0x02, 0xf0, 0xc0, 0x0b, 0xc0, 0x00, 0x71,
	0x0a, 0xc0, 0x00, 0x72, 0xa0, 0x49, 0x04, 0xf0,
	0xa4, 0x49, 0x02, 0xf0, 0x93, 0x48, 0x04, 0xc0,
	0x00, 0xb8, 0x00, 0xe4, 0xc2, 0xc0, 0x8c, 0x09,
	0x14, 0xc2, 0x40, 0x73, 0xba, 0x48, 0x40, 0x9b,
	0x11, 0xc2, 0x40, 0x73, 0xb0, 0x49, 0x17, 0xf0,
	0xbf, 0x49, 0x03, 0xf1, 0x09, 0xc5, 0x00, 0xbd,
	0xb1, 0x49, 0x11, 0xf0, 0xb1, 0x48, 0x40, 0x9b,
	0x02, 0xc2, 0x00, 0xba, 0x82, 0x18, 0x00, 0xa0,
	0x1e, 0xfc, 0xbc, 0xc0, 0xf0, 0xc0, 0xde, 0xe8,
	0x00, 0x80, 0x00, 0x60, 0x2c, 0x75, 0xd4, 0x49,
	0x12, 0xf1, 0x29, 0xe0, 0xf8, 0xc2, 0x46, 0x71,
	0xf7, 0xc2, 0x40, 0x73, 0xbe, 0x49, 0x03, 0xf1,
	0xf5, 0xc7, 0x02, 0xe0, 0xf2, 0xc7, 0x4f, 0x30,
	0x26, 0x62, 0xa1, 0x49, 0xf0, 0xf1, 0x22, 0x72,
	0xa0, 0x49, 0xed, 0xf1, 0x25, 0x25, 0x18, 0x1f,
	0x97, 0x30, 0x91, 0x30, 0x36, 0x9a, 0x2c, 0x75,
	0x32, 0xc3, 0x60, 0x73, 0xb1, 0x49, 0x0d, 0xf1,
	0xdc, 0x21, 0xbc, 0x25, 0x27, 0xc6, 0xc0, 0x77,
	0x04, 0x13, 0x18, 0xf0, 0x03, 0x13, 0x19, 0xf0,
	0x02, 0x13, 0x1a, 0xf0, 0x01, 0x13, 0x1b, 0xf0,
	0xd4, 0x49, 0x03, 0xf1, 0x1c, 0xc5, 0x00, 0xbd,
	0xcd, 0xc6, 0xc6, 0x67, 0x2e, 0x75, 0xd7, 0x22,
	0xdd, 0x26, 0x05, 0x15, 0x1a, 0xf0, 0x14, 0xc6,
	0x00, 0xbe, 0x13, 0xc5, 0x00, 0xbd, 0x12, 0xc5,
	0x00, 0xbd, 0xf1, 0x49, 0xfb, 0xf1, 0xef, 0xe7,
	0xf4, 0x49, 0xfa, 0xf1, 0xec, 0xe7, 0xf3, 0x49,
	0xf7, 0xf1, 0xe9, 0xe7, 0xf2, 0x49, 0xf4, 0xf1,
	0xe6, 0xe7, 0xb6, 0xc0, 0x6a, 0x14, 0xac, 0x13,
	0xd6, 0x13, 0xfa, 0x14, 0xa0, 0xd1, 0x00, 0x00,
	0xc0, 0x75, 0xd0, 0x49, 0x46, 0xf0, 0x26, 0x72,
	0xa7, 0x49, 0x43, 0xf0, 0x22, 0x72, 0x25, 0x25,
	0x20, 0x1f, 0x97, 0x30, 0x91, 0x30, 0x40, 0x73,
	0xf3, 0xc4, 0x1c, 0x40, 0x04, 0xf0, 0xd7, 0x49,
	0x05, 0xf1, 0x37, 0xe0, 0x53, 0x48, 0xc0, 0x9d,
	0x08, 0x02, 0x40, 0x66, 0x64, 0x27, 0x06, 0x16,
	0x30, 0xf1, 0x46, 0x63, 0x3b, 0x13, 0x2d, 0xf1,
	0x34, 0x9b, 0x18, 0x1b, 0x93, 0x30, 0x2b, 0xc3,
	0x10, 0x1c, 0x2b, 0xe8, 0x01, 0x14, 0x25, 0xf1,
	0x00, 0x1d, 0x26, 0x1a, 0x8a, 0x30, 0x22, 0x73,
	0xb5, 0x25, 0x0e, 0x0b, 0x00, 0x1c, 0x2c, 0xe8,
	0x1f, 0xc7, 0x27, 0x40, 0x1a, 0xf1, 0x38, 0xe8,
	0x32, 0x1f, 0x8f, 0x30, 0x08, 0x1b, 0x24, 0xe8,
	0x36, 0x72, 0x46, 0x77, 0x00, 0x17, 0x0d, 0xf0,
	0x13, 0xc3, 0x1f, 0x40, 0x03, 0xf1, 0x00, 0x1f,
	0x46, 0x9f, 0x44, 0x77, 0x9f, 0x44, 0x5f, 0x44,
	0x17, 0xe8, 0x0a, 0xc7, 0x27, 0x40, 0x05, 0xf1,
	0x02, 0xc3, 0x00, 0xbb, 0x50, 0x1a, 0x06, 0x1a,
	0xff, 0xc7, 0x00, 0xbf, 0xb8, 0xcd, 0xff, 0xff,
	0x02, 0x0c, 0x54, 0xa5, 0xdc, 0xa5, 0x2f, 0x40,
	0x05, 0xf1, 0x00, 0x14, 0xfa, 0xf1, 0x01, 0x1c,
	0x02, 0xe0, 0x00, 0x1c, 0x80, 0xff, 0xb0, 0x49,
	0x04, 0xf0, 0x01, 0x0b, 0xd3, 0xa1, 0x03, 0xe0,
	0x02, 0x0b, 0xd3, 0xa5, 0x27, 0x31, 0x20, 0x37,
	0x02, 0x0b, 0xd3, 0xa5, 0x27, 0x31, 0x20, 0x37,
	0x00, 0x13, 0xfb, 0xf1, 0x80, 0xff, 0x22, 0x73,
	0xb5, 0x25, 0x18, 0x1e, 0xde, 0x30, 0xd9, 0x30,
	0x64, 0x72, 0x11, 0x1e, 0x68, 0x23, 0x16, 0x31,
	0x80, 0xff, 0xd4, 0x49, 0x28, 0xf0, 0x02, 0xb4,
	0x2a, 0xc4, 0x00, 0x1d, 0x2e, 0xe8, 0xe0, 0x73,
	0xb9, 0x21, 0xbd, 0x25, 0x04, 0x13, 0x02, 0xf0,
	0x1a, 0xe0, 0x22, 0xc4, 0x23, 0xc3, 0x2f, 0xe8,
	0x23, 0xc3, 0x2d, 0xe8, 0x00, 0x1d, 0x21, 0xe8,
	0xe2, 0x73, 0xbb, 0x49, 0xfc, 0xf0, 0xe0, 0x73,
	0xb7, 0x48, 0x03, 0xb4, 0x81, 0x1d, 0x19, 0xe8,
	0x40, 0x1a, 0x84, 0x1d, 0x16, 0xe8, 0x12, 0xc3,
	0x1e, 0xe8, 0x03, 0xb0, 0x81, 0x1d, 0x11, 0xe8,
	0x0e, 0xc3, 0x19, 0xe8, 0x02, 0xb0, 0x06, 0xc7,
	0x04, 0x1e, 0xe0, 0x9e, 0x02, 0xc6, 0x00, 0xbe,
	0x22, 0x02, 0x20, 0xe4, 0x04, 0xb8, 0x34, 0xb0,
	0x00, 0x02, 0x00, 0x03, 0x00, 0x0e, 0x00, 0x0c,
	0x09, 0xc7, 0xe0, 0x9b, 0xe2, 0x9a, 0xe4, 0x9c,
	0xe6, 0x8d, 0xe6, 0x76, 0xef, 0x49, 0xfe, 0xf1,
	0x80, 0xff, 0x08, 0xea, 0x82, 0x1d, 0xf5, 0xef,
	0x00, 0x1a, 0x88, 0x1d, 0xf2, 0xef, 0xed, 0xc2,
	0xf0, 0xef, 0x80, 0xff, 0x02, 0xc6, 0x00, 0xbe,
	0x46, 0x06, 0x08, 0xc2, 0x40, 0x73, 0x3a, 0x48,
	0x40, 0x9b, 0x06, 0xff, 0x02, 0xc6, 0x00, 0xbe,
	0x86, 0x17, 0x1e, 0xfc, 0x36, 0xf0, 0x08, 0x1c,
	0xea, 0x8c, 0xe3, 0x64, 0xc7, 0x49, 0x25, 0xf1,
	0xe0, 0x75, 0xff, 0x1b, 0xeb, 0x47, 0xff, 0x1b,
	0x6b, 0x47, 0xe0, 0x9d, 0x15, 0xc3, 0x60, 0x75,
	0xd8, 0x49, 0x04, 0xf0, 0x81, 0x1d, 0xe2, 0x8d,
	0x05, 0xe0, 0xe2, 0x63, 0x81, 0x1d, 0xdd, 0x47,
	0xe2, 0x8b, 0x0b, 0xc3, 0x00, 0x1d, 0x61, 0x8d,
	0x3c, 0x03, 0x60, 0x75, 0xd8, 0x49, 0x06, 0xf1,
	0xdf, 0x48, 0x61, 0x95, 0x16, 0xe0, 0x4e, 0xe8,
	0x12, 0xe8, 0x21, 0xc5, 0xa0, 0x73, 0xb0, 0x49,
	0x03, 0xf0, 0x31, 0x48, 0xa0, 0x9b, 0x0d, 0xe0,
	0xc0, 0x49, 0x0b, 0xf1, 0xe2, 0x63, 0x7e, 0x1d,
	0xdd, 0x46, 0xe2, 0x8b, 0xe0, 0x75, 0x83, 0x1b,
	0xeb, 0x46, 0xfe, 0x1b, 0x6b, 0x46, 0xe0, 0x9d,
	0xe4, 0x49, 0x11, 0xf0, 0x10, 0x1d, 0xea, 0x8d,
	0xe3, 0x64, 0xc6, 0x49, 0x09, 0xf1, 0x07, 0xc5,
	0xa0, 0x73, 0xb1, 0x48, 0xa0, 0x9b, 0x02, 0xc5,
	0x00, 0xbd, 0xe6, 0x04, 0xa0, 0xd1, 0x02, 0xc5,
	0x00, 0xbd, 0xfe, 0x04, 0x02, 0xc5, 0x00, 0xbd,
	0x30, 0x05, 0x00, 0x00 };

static u16 r8152b_ram_code1[] = {
	0x9700, 0x7fe0, 0x4c00, 0x4007, 0x4400, 0x4800, 0x7c1f, 0x4c00,
	0x5310, 0x6000, 0x7c07, 0x6800, 0x673e, 0x0000, 0x0000, 0x571f,
	0x5ffb, 0xaa05, 0x5b58, 0x7d80, 0x6100, 0x3019, 0x5b64, 0x7d80,
	0x6080, 0xa6f8, 0xdcdb, 0x0015, 0xb915, 0xb511, 0xd16b, 0x000f,
	0xb40f, 0xd06b, 0x000d, 0xb206, 0x7c01, 0x5800, 0x7c04, 0x5c00,
	0x3011, 0x7c01, 0x5801, 0x7c04, 0x5c04, 0x3019, 0x30a5, 0x3127,
	0x31d5, 0x7fe0, 0x4c60, 0x7c07, 0x6803, 0x7d00, 0x6900, 0x65a0,
	0x0000, 0x0000, 0xaf03, 0x6015, 0x303e, 0x6017, 0x57e0, 0x580c,
	0x588c, 0x7fdd, 0x5fa2, 0x4827, 0x7c1f, 0x4c00, 0x7c1f, 0x4c10,
	0x8400, 0x7c30, 0x6020, 0x48bf, 0x7c1f, 0x4c00, 0x7c1f, 0x4c01,
	0x7c07, 0x6803, 0xb806, 0x7c08, 0x6800, 0x0000, 0x0000, 0x305c,
	0x7c08, 0x6808, 0x0000, 0x0000, 0xae06, 0x7c02, 0x5c02, 0x0000,
	0x0000, 0x3067, 0x8e05, 0x7c02, 0x5c00, 0x0000, 0x0000, 0xad06,
	0x7c20, 0x5c20, 0x0000, 0x0000, 0x3072, 0x8d05, 0x7c20, 0x5c00,
	0x0000, 0x0000, 0xa008, 0x7c07, 0x6800, 0xb8db, 0x7c07, 0x6803,
	0xd9b3, 0x00d7, 0x7fe0, 0x4c80, 0x7c08, 0x6800, 0x0000, 0x0000,
	0x7c23, 0x5c23, 0x481d, 0x7c1f, 0x4c00, 0x7c1f, 0x4c02, 0x5310,
	0x81ff, 0x30f5, 0x7fe0, 0x4d00, 0x4832, 0x7c1f, 0x4c00, 0x7c1f,
	0x4c10, 0x7c08, 0x6000, 0xa49e, 0x7c07, 0x6800, 0xb89b, 0x7c07,
	0x6803, 0xd9b3, 0x00f9, 0x7fe0, 0x4d20, 0x7e00, 0x6200, 0x3001,
	0x7fe0, 0x4dc0, 0xd09d, 0x0002, 0xb4fe, 0x7fe0, 0x4d80, 0x7c04,
	0x6004, 0x7c07, 0x6802, 0x6728, 0x0000, 0x0000, 0x7c08, 0x6000,
	0x486c, 0x7c1f, 0x4c00, 0x7c1f, 0x4c01, 0x9503, 0x7e00, 0x6200,
	0x571f, 0x5fbb, 0xaa05, 0x5b58, 0x7d80, 0x6100, 0x30c2, 0x5b64,
	0x7d80, 0x6080, 0xcdab, 0x0063, 0xcd8d, 0x0061, 0xd96b, 0x005f,
	0xd0a0, 0x00d7, 0xcba0, 0x0003, 0x80ec, 0x30cf, 0x30dc, 0x7fe0,
	0x4ce0, 0x4832, 0x7c1f, 0x4c00, 0x7c1f, 0x4c08, 0x7c08, 0x6008,
	0x8300, 0xb902, 0x30a5, 0x308a, 0x7fe0, 0x4da0, 0x65a8, 0x0000,
	0x0000, 0x56a0, 0x590c, 0x7ffd, 0x5fa2, 0xae06, 0x7c02, 0x5c02,
	0x0000, 0x0000, 0x30f0, 0x8e05, 0x7c02, 0x5c00, 0x0000, 0x0000,
	0xcba4, 0x0004, 0xcd8d, 0x0002, 0x80f1, 0x7fe0, 0x4ca0, 0x7c08,
	0x6408, 0x0000, 0x0000, 0x7d00, 0x6800, 0xb603, 0x7c10, 0x6010,
	0x7d1f, 0x551f, 0x5fb3, 0xaa07, 0x7c80, 0x5800, 0x5b58, 0x7d80,
	0x6100, 0x310f, 0x7c80, 0x5800, 0x5b64, 0x7d80, 0x6080, 0x4827,
	0x7c1f, 0x4c00, 0x7c1f, 0x4c10, 0x8400, 0x7c10, 0x6000, 0x7fe0,
	0x4cc0, 0x5fbb, 0x4824, 0x7c1f, 0x4c00, 0x7c1f, 0x4c04, 0x8200,
	0x7ce0, 0x5400, 0x6728, 0x0000, 0x0000, 0x30cf, 0x3001, 0x7fe0,
	0x4e00, 0x4007, 0x4400, 0x5310, 0x7c07, 0x6800, 0x673e, 0x0000,
	0x0000, 0x570f, 0x5fff, 0xaa05, 0x585b, 0x7d80, 0x6100, 0x313b,
	0x5867, 0x7d80, 0x6080, 0x9403, 0x7e00, 0x6200, 0xcda3, 0x00e7,
	0xcd85, 0x00e5, 0xd96b, 0x00e3, 0x96e3, 0x7c07, 0x6800, 0x673e,
	0x0000, 0x0000, 0x7fe0, 0x4e20, 0x96db, 0x8b04, 0x7c08, 0x5008,
	0xab03, 0x7c08, 0x5000, 0x7c07, 0x6801, 0x677e, 0x0000, 0x0000,
	0xdb7c, 0x00ec, 0x0000, 0x7fe1, 0x4f40, 0x4837, 0x4418, 0x41c7,
	0x7fe0, 0x4e40, 0x7c40, 0x5400, 0x7c1f, 0x4c01, 0x7c1f, 0x4c01,
	0x8fbf, 0xd2a0, 0x004b, 0x9204, 0xa042, 0x3168, 0x3127, 0x7fe1,
	0x4f60, 0x489c, 0x4628, 0x7fe0, 0x4e60, 0x7e28, 0x4628, 0x7c40,
	0x5400, 0x7c01, 0x5800, 0x7c04, 0x5c00, 0x41e8, 0x7c1f, 0x4c01,
	0x7c1f, 0x4c01, 0x8fa5, 0xb241, 0xa02a, 0x3182, 0x7fe0, 0x4ea0,
	0x7c02, 0x4402, 0x4448, 0x4894, 0x7c1f, 0x4c01, 0x7c1f, 0x4c03,
	0x4824, 0x7c1f, 0x4c07, 0x41ef, 0x41ff, 0x4891, 0x7c1f, 0x4c07,
	0x7c1f, 0x4c17, 0x8400, 0x8ef8, 0x41c7, 0x8f8a, 0x92d5, 0xa10f,
	0xd480, 0x0008, 0xd580, 0x00b8, 0xa202, 0x319d, 0x7c04, 0x4404,
	0x319d, 0xd484, 0x00f3, 0xd484, 0x00f1, 0x3127, 0x7fe0, 0x4ee0,
	0x7c40, 0x5400, 0x4488, 0x41cf, 0x3127, 0x7fe0, 0x4ec0, 0x48f3,
	0x7c1f, 0x4c01, 0x7c1f, 0x4c09, 0x4508, 0x41c7, 0x8fb0, 0xd218,
	0x00ae, 0xd2a4, 0x009e, 0x31be, 0x7fe0, 0x4e80, 0x4832, 0x7c1f,
	0x4c01, 0x7c1f, 0x4c11, 0x4428, 0x7c40, 0x5440, 0x7c01, 0x5801,
	0x7c04, 0x5c04, 0x41e8, 0xa4b3, 0x31d3, 0x7fe0, 0x4f20, 0x7c07,
	0x6800, 0x673e, 0x0000, 0x0000, 0x570f, 0x5fff, 0xaa04, 0x585b,
	0x6100, 0x31e4, 0x5867, 0x6080, 0xbcf1, 0x3001 };

static u16 r8152b_pla_patch_a_bp[] = {
	0xfc26, 0x8000, 0xfc28, 0x170b, 0xfc2a, 0x01e1, 0xfc2c, 0x0989,
	0xfc2e, 0x1349, 0xfc30, 0x01b7, 0xfc32, 0x061d, 0xe422, 0x0020,
	0xe420, 0x0018, 0xfc34, 0x1785, 0xfc36, 0x047b };

static u8 r8152b_pla_patch_a2[] = {
	0x08, 0xe0, 0x1a, 0xe0, 0xf2, 0xe0, 0xfa, 0xe0,
	0x32, 0xe1, 0x34, 0xe1, 0x36, 0xe1, 0x38, 0xe1,
	0x2c, 0x75, 0xdc, 0x21, 0xbc, 0x25, 0x04, 0x13,
	0x0b, 0xf0, 0x03, 0x13, 0x09, 0xf0, 0x02, 0x13,
	0x07, 0xf0, 0x01, 0x13, 0x05, 0xf0, 0x08, 0x13,
	0x03, 0xf0, 0x04, 0xc3, 0x00, 0xbb, 0x03, 0xc3,
	0x00, 0xbb, 0xd2, 0x17, 0xbc, 0x17, 0x14, 0xc2,
	0x40, 0x73, 0xba, 0x48, 0x40, 0x9b, 0x11, 0xc2,
	0x40, 0x73, 0xb0, 0x49, 0x17, 0xf0, 0xbf, 0x49,
	0x03, 0xf1, 0x09, 0xc5, 0x00, 0xbd, 0xb1, 0x49,
	0x11, 0xf0, 0xb1, 0x48, 0x40, 0x9b, 0x02, 0xc2,
	0x00, 0xba, 0x4e, 0x19, 0x00, 0xa0, 0x1e, 0xfc,
	0xbc, 0xc0, 0xf0, 0xc0, 0xde, 0xe8, 0x00, 0x80,
	0x00, 0x60, 0x2c, 0x75, 0xd4, 0x49, 0x12, 0xf1,
	0x29, 0xe0, 0xf8, 0xc2, 0x46, 0x71, 0xf7, 0xc2,
	0x40, 0x73, 0xbe, 0x49, 0x03, 0xf1, 0xf5, 0xc7,
	0x02, 0xe0, 0xf2, 0xc7, 0x4f, 0x30, 0x26, 0x62,
	0xa1, 0x49, 0xf0, 0xf1, 0x22, 0x72, 0xa0, 0x49,
	0xed, 0xf1, 0x25, 0x25, 0x18, 0x1f, 0x97, 0x30,
	0x91, 0x30, 0x36, 0x9a, 0x2c, 0x75, 0x32, 0xc3,
	0x60, 0x73, 0xb1, 0x49, 0x0d, 0xf1, 0xdc, 0x21,
	0xbc, 0x25, 0x27, 0xc6, 0xc0, 0x77, 0x04, 0x13,
	0x18, 0xf0, 0x03, 0x13, 0x19, 0xf0, 0x02, 0x13,
	0x1a, 0xf0, 0x01, 0x13, 0x1b, 0xf0, 0xd4, 0x49,
	0x03, 0xf1, 0x1c, 0xc5, 0x00, 0xbd, 0xcd, 0xc6,
	0xc6, 0x67, 0x2e, 0x75, 0xd7, 0x22, 0xdd, 0x26,
	0x05, 0x15, 0x1a, 0xf0, 0x14, 0xc6, 0x00, 0xbe,
	0x13, 0xc5, 0x00, 0xbd, 0x12, 0xc5, 0x00, 0xbd,
	0xf1, 0x49, 0xfb, 0xf1, 0xef, 0xe7, 0xf4, 0x49,
	0xfa, 0xf1, 0xec, 0xe7, 0xf3, 0x49, 0xf7, 0xf1,
	0xe9, 0xe7, 0xf2, 0x49, 0xf4, 0xf1, 0xe6, 0xe7,
	0xb6, 0xc0, 0xf6, 0x14, 0x36, 0x14, 0x62, 0x14,
	0x86, 0x15, 0xa0, 0xd1, 0x00, 0x00, 0xc0, 0x75,
	0xd0, 0x49, 0x46, 0xf0, 0x26, 0x72, 0xa7, 0x49,
	0x43, 0xf0, 0x22, 0x72, 0x25, 0x25, 0x20, 0x1f,
	0x97, 0x30, 0x91, 0x30, 0x40, 0x73, 0xf3, 0xc4,
	0x1c, 0x40, 0x04, 0xf0, 0xd7, 0x49, 0x05, 0xf1,
	0x37, 0xe0, 0x53, 0x48, 0xc0, 0x9d, 0x08, 0x02,
	0x40, 0x66, 0x64, 0x27, 0x06, 0x16, 0x30, 0xf1,
	0x46, 0x63, 0x3b, 0x13, 0x2d, 0xf1, 0x34, 0x9b,
	0x18, 0x1b, 0x93, 0x30, 0x2b, 0xc3, 0x10, 0x1c,
	0x2b, 0xe8, 0x01, 0x14, 0x25, 0xf1, 0x00, 0x1d,
	0x26, 0x1a, 0x8a, 0x30, 0x22, 0x73, 0xb5, 0x25,
	0x0e, 0x0b, 0x00, 0x1c, 0x2c, 0xe8, 0x1f, 0xc7,
	0x27, 0x40, 0x1a, 0xf1, 0x38, 0xe8, 0x32, 0x1f,
	0x8f, 0x30, 0x08, 0x1b, 0x24, 0xe8, 0x36, 0x72,
	0x46, 0x77, 0x00, 0x17, 0x0d, 0xf0, 0x13, 0xc3,
	0x1f, 0x40, 0x03, 0xf1, 0x00, 0x1f, 0x46, 0x9f,
	0x44, 0x77, 0x9f, 0x44, 0x5f, 0x44, 0x17, 0xe8,
	0x0a, 0xc7, 0x27, 0x40, 0x05, 0xf1, 0x02, 0xc3,
	0x00, 0xbb, 0x1c, 0x1b, 0xd2, 0x1a, 0xff, 0xc7,
	0x00, 0xbf, 0xb8, 0xcd, 0xff, 0xff, 0x02, 0x0c,
	0x54, 0xa5, 0xdc, 0xa5, 0x2f, 0x40, 0x05, 0xf1,
	0x00, 0x14, 0xfa, 0xf1, 0x01, 0x1c, 0x02, 0xe0,
	0x00, 0x1c, 0x80, 0xff, 0xb0, 0x49, 0x04, 0xf0,
	0x01, 0x0b, 0xd3, 0xa1, 0x03, 0xe0, 0x02, 0x0b,
	0xd3, 0xa5, 0x27, 0x31, 0x20, 0x37, 0x02, 0x0b,
	0xd3, 0xa5, 0x27, 0x31, 0x20, 0x37, 0x00, 0x13,
	0xfb, 0xf1, 0x80, 0xff, 0x22, 0x73, 0xb5, 0x25,
	0x18, 0x1e, 0xde, 0x30, 0xd9, 0x30, 0x64, 0x72,
	0x11, 0x1e, 0x68, 0x23, 0x16, 0x31, 0x80, 0xff,
	0x08, 0xc2, 0x40, 0x73, 0x3a, 0x48, 0x40, 0x9b,
	0x06, 0xff, 0x02, 0xc6, 0x00, 0xbe, 0x4e, 0x18,
	0x1e, 0xfc, 0x33, 0xc5, 0xa0, 0x74, 0xc0, 0x49,
	0x1f, 0xf0, 0x30, 0xc5, 0xa0, 0x73, 0x00, 0x13,
	0x04, 0xf1, 0xa2, 0x73, 0x00, 0x13, 0x14, 0xf0,
	0x28, 0xc5, 0xa0, 0x74, 0xc8, 0x49, 0x1b, 0xf1,
	0x26, 0xc5, 0xa0, 0x76, 0xa2, 0x74, 0x01, 0x06,
	0x20, 0x37, 0xa0, 0x9e, 0xa2, 0x9c, 0x1e, 0xc5,
	0xa2, 0x73, 0x23, 0x40, 0x10, 0xf8, 0x04, 0xf3,
	0xa0, 0x73, 0x33, 0x40, 0x0c, 0xf8, 0x15, 0xc5,
	0xa0, 0x74, 0x41, 0x48, 0xa0, 0x9c, 0x14, 0xc5,
	0xa0, 0x76, 0x62, 0x48, 0xe0, 0x48, 0xa0, 0x9e,
	0x10, 0xc6, 0x00, 0xbe, 0x0a, 0xc5, 0xa0, 0x74,
	0x48, 0x48, 0xa0, 0x9c, 0x0b, 0xc5, 0x20, 0x1e,
	0xa0, 0x9e, 0xe5, 0x48, 0xa0, 0x9e, 0xf0, 0xe7,
	0xbc, 0xc0, 0xc8, 0xd2, 0xcc, 0xd2, 0x28, 0xe4,
	0x22, 0x02, 0xf0, 0xc0, 0x02, 0xc6, 0x00, 0xbe,
	0x00, 0x00, 0x02, 0xc6, 0x00, 0xbe, 0x00, 0x00,
	0x02, 0xc6, 0x00, 0xbe, 0x00, 0x00, 0x02, 0xc6,
	0x00, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static u16 r8152b_pla_patch_a2_bp[] = {
	0xfc28, 0x8000, 0xfc28, 0x17a5, 0xfc2a, 0x13ad,
	0xfc2c, 0x184d, 0xfc2e, 0x01e1 };

static u16 r8153_ram_code_a[] = {
	0xE86C, 0xA000, 0xB436, 0xB820, 0xB438, 0x0290, 0xB436, 0xA012,
	0xB438, 0x0000, 0xB436, 0xA014, 0xB438, 0x2c04, 0xB438, 0x2c18,
	0xB438, 0x2c45, 0xB438, 0x2c45, 0xB438, 0xd502, 0xB438, 0x8301,
	0xB438, 0x8306, 0xB438, 0xd500, 0xB438, 0x8208, 0xB438, 0xd501,
	0xB438, 0xe018, 0xB438, 0x0308, 0xB438, 0x60f2, 0xB438, 0x8404,
	0xB438, 0x607d, 0xB438, 0xc117, 0xB438, 0x2c16, 0xB438, 0xc116,
	0xB438, 0x2c16, 0xB438, 0x607d, 0xB438, 0xc117, 0xB438, 0xa404,
	0xB438, 0xd500, 0xB438, 0x0800, 0xB438, 0xd501, 0xB438, 0x62d2,
	0xB438, 0x615d, 0xB438, 0xc115, 0xB438, 0xa404, 0xB438, 0xc307,
	0xB438, 0xd502, 0xB438, 0x8301, 0xB438, 0x8306, 0xB438, 0xd500,
	0xB438, 0x8208, 0xB438, 0x2c42, 0xB438, 0xc114, 0xB438, 0x8404,
	0xB438, 0xc317, 0xB438, 0xd701, 0xB438, 0x435d, 0xB438, 0xd500,
	0xB438, 0xa208, 0xB438, 0xd502, 0xB438, 0xa306, 0xB438, 0xa301,
	0xB438, 0x2c42, 0xB438, 0x8404, 0xB438, 0x613d, 0xB438, 0xc115,
	0xB438, 0xc307, 0xB438, 0xd502, 0xB438, 0x8301, 0xB438, 0x8306,
	0xB438, 0xd500, 0xB438, 0x8208, 0xB438, 0x2c42, 0xB438, 0xc114,
	0xB438, 0xc317, 0xB438, 0xd701, 0xB438, 0x40dd, 0xB438, 0xd500,
	0xB438, 0xa208, 0xB438, 0xd502, 0xB438, 0xa306, 0xB438, 0xa301,
	0xB438, 0xd500, 0xB438, 0xd702, 0xB438, 0x0800, 0xB436, 0xA01A,
	0xB438, 0x0000, 0xB436, 0xA006, 0xB438, 0x0fff, 0xB436, 0xA004,
	0xB438, 0x0fff, 0xB436, 0xA002, 0xB438, 0x05a3, 0xB436, 0xA000,
	0xB438, 0x3591, 0xB436, 0xB820, 0xB438, 0x0210 };

static u8 r8153_usb_patch_c[] = {
	0x08, 0xe0, 0x0a, 0xe0, 0x14, 0xe0, 0x2e, 0xe0,
	0x37, 0xe0, 0x3e, 0xe0, 0x6d, 0xe0, 0x78, 0xe0,
	0x02, 0xc5, 0x00, 0xbd, 0x38, 0x3b, 0xdb, 0x49,
	0x04, 0xf1, 0x06, 0xc3, 0x00, 0xbb, 0x5a, 0x02,
	0x05, 0xc4, 0x03, 0xc3, 0x00, 0xbb, 0xa4, 0x04,
	0x7e, 0x02, 0x30, 0xd4, 0x30, 0x18, 0x18, 0xc1,
	0x0c, 0xe8, 0x17, 0xc6, 0xc7, 0x65, 0xd0, 0x49,
	0x05, 0xf0, 0x32, 0x48, 0x02, 0xc2, 0x00, 0xba,
	0x3e, 0x16, 0x02, 0xc2, 0x00, 0xba, 0x48, 0x16,
	0x02, 0xb4, 0x09, 0xc2, 0x40, 0x99, 0x0e, 0x48,
	0x42, 0x98, 0x42, 0x70, 0x8e, 0x49, 0xfe, 0xf1,
	0x02, 0xb0, 0x80, 0xff, 0xc0, 0xd4, 0xe4, 0x40,
	0x20, 0xd4, 0xb0, 0x49, 0x04, 0xf0, 0x30, 0x18,
	0x06, 0xc1, 0xef, 0xef, 0xfa, 0xc7, 0x02, 0xc0,
	0x00, 0xb8, 0xd0, 0x10, 0xe4, 0x4b, 0x07, 0xc3,
	0x70, 0x61, 0x12, 0x48, 0x70, 0x89, 0x02, 0xc3,
	0x00, 0xbb, 0x9c, 0x15, 0x20, 0xd4, 0x2b, 0xc5,
	0xa0, 0x77, 0x00, 0x1c, 0xa0, 0x9c, 0x28, 0xc5,
	0xa0, 0x64, 0xc0, 0x48, 0xc1, 0x48, 0xc2, 0x48,
	0xa0, 0x8c, 0xb1, 0x64, 0xc0, 0x48, 0xb1, 0x8c,
	0x20, 0xc5, 0xa0, 0x64, 0x40, 0x48, 0x41, 0x48,
	0xc2, 0x48, 0xa0, 0x8c, 0x19, 0xc5, 0xa4, 0x64,
	0x44, 0x48, 0xa4, 0x8c, 0xb1, 0x64, 0x40, 0x48,
	0xb1, 0x8c, 0x14, 0xc4, 0x80, 0x73, 0x13, 0xc4,
	0x82, 0x9b, 0x11, 0x1b, 0x80, 0x9b, 0x0c, 0xc5,
	0xa0, 0x64, 0x40, 0x48, 0x41, 0x48, 0x42, 0x48,
	0xa0, 0x8c, 0x05, 0xc5, 0xa0, 0x9f, 0x02, 0xc5,
	0x00, 0xbd, 0x6c, 0x3a, 0x1e, 0xfc, 0x10, 0xd8,
	0x86, 0xd4, 0xf8, 0xcb, 0x20, 0xe4, 0x0a, 0xc0,
	0x16, 0x61, 0x91, 0x48, 0x16, 0x89, 0x07, 0xc0,
	0x11, 0x19, 0x0c, 0x89, 0x02, 0xc1, 0x00, 0xb9,
	0x02, 0x06, 0x00, 0xd4, 0x40, 0xb4, 0xfe, 0xc0,
	0x16, 0x61, 0x91, 0x48, 0x16, 0x89, 0xfb, 0xc0,
	0x11, 0x19, 0x0c, 0x89, 0x02, 0xc1, 0x00, 0xb9,
	0xd2, 0x05, 0x00, 0x00 };

static u16 r8153_usb_patch_c_bp[] = {
	0xfc26, 0xa000, 0xfc28, 0x3b34, 0xfc2a, 0x027c, 0xfc2c, 0x162c,
	0xfc2e, 0x10ce, 0xfc30, 0x0000, 0xfc32, 0x3a28, 0xfc34, 0x05f8,
	0xfc36, 0x05c8 };

static u8 r8153_pla_patch_c[] = {
	0x08, 0xe0, 0xea, 0xe0, 0xf2, 0xe0, 0x04, 0xe1,
	0x06, 0xe1, 0x08, 0xe1, 0x40, 0xe1, 0xf1, 0xe1,
	0x14, 0xc2, 0x40, 0x73, 0xba, 0x48, 0x40, 0x9b,
	0x11, 0xc2, 0x40, 0x73, 0xb0, 0x49, 0x17, 0xf0,
	0xbf, 0x49, 0x03, 0xf1, 0x09, 0xc5, 0x00, 0xbd,
	0xb1, 0x49, 0x11, 0xf0, 0xb1, 0x48, 0x40, 0x9b,
	0x02, 0xc2, 0x00, 0xba, 0xde, 0x18, 0x00, 0xe0,
	0x1e, 0xfc, 0xbc, 0xc0, 0xf0, 0xc0, 0xde, 0xe8,
	0x00, 0x80, 0x00, 0x20, 0x2c, 0x75, 0xd4, 0x49,
	0x12, 0xf1, 0x32, 0xe0, 0xf8, 0xc2, 0x46, 0x71,
	0xf7, 0xc2, 0x40, 0x73, 0xbe, 0x49, 0x03, 0xf1,
	0xf5, 0xc7, 0x02, 0xe0, 0xf2, 0xc7, 0x4f, 0x30,
	0x26, 0x62, 0xa1, 0x49, 0xf0, 0xf1, 0x22, 0x72,
	0xa0, 0x49, 0xed, 0xf1, 0x25, 0x25, 0x18, 0x1f,
	0x97, 0x30, 0x91, 0x30, 0x36, 0x9a, 0x2c, 0x75,
	0x3c, 0xc3, 0x60, 0x73, 0xb1, 0x49, 0x0d, 0xf1,
	0xdc, 0x21, 0xbc, 0x25, 0x30, 0xc6, 0xc0, 0x77,
	0x04, 0x13, 0x21, 0xf0, 0x03, 0x13, 0x22, 0xf0,
	0x02, 0x13, 0x23, 0xf0, 0x01, 0x13, 0x24, 0xf0,
	0x08, 0x13, 0x08, 0xf1, 0x2e, 0x73, 0xba, 0x21,
	0xbd, 0x25, 0x05, 0x13, 0x03, 0xf1, 0x24, 0xc5,
	0x00, 0xbd, 0xd4, 0x49, 0x03, 0xf1, 0x1c, 0xc5,
	0x00, 0xbd, 0xc4, 0xc6, 0xc6, 0x67, 0x2e, 0x75,
	0xd7, 0x22, 0xdd, 0x26, 0x05, 0x15, 0x1b, 0xf0,
	0x14, 0xc6, 0x00, 0xbe, 0x13, 0xc5, 0x00, 0xbd,
	0x12, 0xc5, 0x00, 0xbd, 0xf1, 0x49, 0xfb, 0xf1,
	0xef, 0xe7, 0xf4, 0x49, 0xfa, 0xf1, 0xec, 0xe7,
	0xf3, 0x49, 0xf7, 0xf1, 0xe9, 0xe7, 0xf2, 0x49,
	0xf4, 0xf1, 0xe6, 0xe7, 0xb6, 0xc0, 0x50, 0x14,
	0x90, 0x13, 0xbc, 0x13, 0xf2, 0x14, 0x00, 0xa0,
	0xa0, 0xd1, 0x00, 0x00, 0xc0, 0x75, 0xd0, 0x49,
	0x46, 0xf0, 0x26, 0x72, 0xa7, 0x49, 0x43, 0xf0,
	0x22, 0x72, 0x25, 0x25, 0x20, 0x1f, 0x97, 0x30,
	0x91, 0x30, 0x40, 0x73, 0xf3, 0xc4, 0x1c, 0x40,
	0x04, 0xf0, 0xd7, 0x49, 0x05, 0xf1, 0x37, 0xe0,
	0x53, 0x48, 0xc0, 0x9d, 0x08, 0x02, 0x40, 0x66,
	0x64, 0x27, 0x06, 0x16, 0x30, 0xf1, 0x46, 0x63,
	0x3b, 0x13, 0x2d, 0xf1, 0x34, 0x9b, 0x18, 0x1b,
	0x93, 0x30, 0x2b, 0xc3, 0x10, 0x1c, 0x2b, 0xe8,
	0x01, 0x14, 0x25, 0xf1, 0x00, 0x1d, 0x26, 0x1a,
	0x8a, 0x30, 0x22, 0x73, 0xb5, 0x25, 0x0e, 0x0b,
	0x00, 0x1c, 0x2c, 0xe8, 0x1f, 0xc7, 0x27, 0x40,
	0x1a, 0xf1, 0x38, 0xe8, 0x32, 0x1f, 0x8f, 0x30,
	0x08, 0x1b, 0x24, 0xe8, 0x36, 0x72, 0x46, 0x77,
	0x00, 0x17, 0x0d, 0xf0, 0x13, 0xc3, 0x1f, 0x40,
	0x03, 0xf1, 0x00, 0x1f, 0x46, 0x9f, 0x44, 0x77,
	0x9f, 0x44, 0x5f, 0x44, 0x17, 0xe8, 0x0a, 0xc7,
	0x27, 0x40, 0x05, 0xf1, 0x02, 0xc3, 0x00, 0xbb,
	0xbe, 0x1a, 0x74, 0x14, 0xff, 0xc7, 0x00, 0xbf,
	0xb8, 0xcd, 0xff, 0xff, 0x02, 0x0c, 0x54, 0xa5,
	0xdc, 0xa5, 0x2f, 0x40, 0x05, 0xf1, 0x00, 0x14,
	0xfa, 0xf1, 0x01, 0x1c, 0x02, 0xe0, 0x00, 0x1c,
	0x80, 0xff, 0xb0, 0x49, 0x04, 0xf0, 0x01, 0x0b,
	0xd3, 0xa1, 0x03, 0xe0, 0x02, 0x0b, 0xd3, 0xa5,
	0x27, 0x31, 0x20, 0x37, 0x02, 0x0b, 0xd3, 0xa5,
	0x27, 0x31, 0x20, 0x37, 0x00, 0x13, 0xfb, 0xf1,
	0x80, 0xff, 0x22, 0x73, 0xb5, 0x25, 0x18, 0x1e,
	0xde, 0x30, 0xd9, 0x30, 0x64, 0x72, 0x11, 0x1e,
	0x68, 0x23, 0x16, 0x31, 0x80, 0xff, 0x08, 0xc2,
	0x40, 0x73, 0x3a, 0x48, 0x40, 0x9b, 0x06, 0xff,
	0x02, 0xc6, 0x00, 0xbe, 0xcc, 0x17, 0x1e, 0xfc,
	0x2c, 0x75, 0xdc, 0x21, 0xbc, 0x25, 0x04, 0x13,
	0x0b, 0xf0, 0x03, 0x13, 0x09, 0xf0, 0x02, 0x13,
	0x07, 0xf0, 0x01, 0x13, 0x05, 0xf0, 0x08, 0x13,
	0x03, 0xf0, 0x04, 0xc3, 0x00, 0xbb, 0x03, 0xc3,
	0x00, 0xbb, 0x50, 0x17, 0x3a, 0x17, 0x02, 0xc6,
	0x00, 0xbe, 0x00, 0x00, 0x02, 0xc6, 0x00, 0xbe,
	0x00, 0x00, 0x33, 0xc5, 0xa0, 0x74, 0xc0, 0x49,
	0x1f, 0xf0, 0x30, 0xc5, 0xa0, 0x73, 0x00, 0x13,
	0x04, 0xf1, 0xa2, 0x73, 0x00, 0x13, 0x14, 0xf0,
	0x28, 0xc5, 0xa0, 0x74, 0xc8, 0x49, 0x1b, 0xf1,
	0x26, 0xc5, 0xa0, 0x76, 0xa2, 0x74, 0x01, 0x06,
	0x20, 0x37, 0xa0, 0x9e, 0xa2, 0x9c, 0x1e, 0xc5,
	0xa2, 0x73, 0x23, 0x40, 0x10, 0xf8, 0x04, 0xf3,
	0xa0, 0x73, 0x33, 0x40, 0x0c, 0xf8, 0x15, 0xc5,
	0xa0, 0x74, 0x41, 0x48, 0xa0, 0x9c, 0x14, 0xc5,
	0xa0, 0x76, 0x62, 0x48, 0xe0, 0x48, 0xa0, 0x9e,
	0x10, 0xc6, 0x00, 0xbe, 0x0a, 0xc5, 0xa0, 0x74,
	0x48, 0x48, 0xa0, 0x9c, 0x0b, 0xc5, 0x20, 0x1e,
	0xa0, 0x9e, 0xe5, 0x48, 0xa0, 0x9e, 0xf0, 0xe7,
	0xbc, 0xc0, 0xc8, 0xd2, 0xcc, 0xd2, 0x28, 0xe4,
	0xfa, 0x01, 0xf0, 0xc0, 0x18, 0x89, 0x00, 0x1d,
	0x43, 0xc3, 0x62, 0x62, 0xa0, 0x49, 0x06, 0xf0,
	0x41, 0xc0, 0x02, 0x71, 0x60, 0x99, 0x3f, 0xc1,
	0x03, 0xe0, 0x3c, 0xc0, 0x3d, 0xc1, 0x02, 0x99,
	0x00, 0x61, 0x67, 0x11, 0x3d, 0xf1, 0x69, 0x33,
	0x34, 0xc0, 0x28, 0x40, 0xf7, 0xf1, 0x35, 0xc0,
	0x00, 0x19, 0x81, 0x1b, 0x89, 0xe8, 0x32, 0xc0,
	0x04, 0x1a, 0x84, 0x1b, 0x85, 0xe8, 0x7a, 0xe8,
	0xa3, 0x49, 0xfe, 0xf0, 0x2c, 0xc0, 0x76, 0xe8,
	0xa1, 0x48, 0x29, 0xc0, 0x84, 0x1b, 0x7c, 0xe8,
	0x00, 0x1d, 0x69, 0x33, 0x00, 0x1e, 0x01, 0x06,
	0xff, 0x18, 0x30, 0x40, 0xfd, 0xf1, 0x7f, 0xc0,
	0x00, 0x76, 0x2e, 0x40, 0xf7, 0xf1, 0x21, 0x48,
	0x1a, 0xc0, 0x84, 0x1b, 0x6d, 0xe8, 0x76, 0xc0,
	0x61, 0xe8, 0xa1, 0x49, 0xfd, 0xf0, 0x12, 0xc0,
	0x00, 0x1a, 0x84, 0x1b, 0x65, 0xe8, 0x5a, 0xe8,
	0xa5, 0x49, 0xfe, 0xf0, 0x0a, 0xc0, 0x01, 0x19,
	0x81, 0x1b, 0x5e, 0xe8, 0x48, 0xe0, 0x8c, 0xd3,
	0xb8, 0x0b, 0x50, 0xe8, 0x83, 0x00, 0x82, 0x00,
	0x20, 0xb4, 0x10, 0xd8, 0x84, 0xd4, 0xfa, 0xc0,
	0x00, 0x61, 0x9c, 0x20, 0x9c, 0x24, 0x06, 0x11,
	0x06, 0xf1, 0x5d, 0xc0, 0x00, 0x61, 0x11, 0x48,
	0x00, 0x89, 0x35, 0xe0, 0x00, 0x11, 0x02, 0xf1,
	0x03, 0xe0, 0x04, 0x11, 0x06, 0xf1, 0x53, 0xc0,
	0x00, 0x61, 0x92, 0x48, 0x00, 0x89, 0x2b, 0xe0,
	0x05, 0x11, 0x08, 0xf1, 0x4c, 0xc0, 0x00, 0x61,
	0x91, 0x49, 0x04, 0xf0, 0x91, 0x48, 0x00, 0x89,
	0x11, 0xe0, 0xdc, 0xc0, 0x00, 0x61, 0x98, 0x20,
	0x98, 0x24, 0x25, 0x11, 0x1c, 0xf1, 0x40, 0xc0,
	0x25, 0xe8, 0x95, 0x49, 0x18, 0xf0, 0xd2, 0xc0,
	0x00, 0x61, 0x98, 0x20, 0x98, 0x24, 0x25, 0x11,
	0x12, 0xf1, 0x35, 0xc0, 0x00, 0x61, 0x92, 0x49,
	0x0e, 0xf1, 0x12, 0x48, 0x00, 0x89, 0x2d, 0xc0,
	0x00, 0x19, 0x00, 0x89, 0x2b, 0xc0, 0x01, 0x89,
	0x27, 0xc0, 0x10, 0xe8, 0x25, 0xc0, 0x12, 0x48,
	0x81, 0x1b, 0x16, 0xe8, 0xb9, 0xc3, 0x62, 0x62,
	0xa0, 0x49, 0x05, 0xf0, 0xb5, 0xc3, 0x60, 0x71,
	0xb5, 0xc0, 0x02, 0x99, 0x02, 0xc0, 0x00, 0xb8,
	0xd6, 0x07, 0x13, 0xc4, 0x84, 0x98, 0x00, 0x1b,
	0x86, 0x8b, 0x86, 0x73, 0xbf, 0x49, 0xfe, 0xf1,
	0x80, 0x71, 0x82, 0x72, 0x80, 0xff, 0x09, 0xc4,
	0x84, 0x98, 0x80, 0x99, 0x82, 0x9a, 0x86, 0x8b,
	0x86, 0x73, 0xbf, 0x49, 0xfe, 0xf1, 0x80, 0xff,
	0x08, 0xea, 0x10, 0xd4, 0x88, 0xd3, 0x30, 0xd4,
	0x10, 0xc0, 0x12, 0xe8, 0x8a, 0xd3, 0x00, 0xd8,
	0x02, 0xc0, 0x00, 0xb8, 0xe0, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static u16 r8153_pla_patch_c_bp[] = {
	0xfc26, 0x8000, 0xfc28, 0x1306, 0xfc2a, 0x17ca, 0xfc2c, 0x171e,
	0xfc2e, 0x0000, 0xfc30, 0x0000, 0xfc32, 0x01b4, 0xfc34, 0x07d4,
	0xfc36, 0x0894, 0xfc38, 0x00e7 };

static u16 r8153_ram_code_bc[] = {
	0xB436, 0xB820, 0xB438, 0x0290, 0xB436, 0xA012, 0xB438, 0x0000,
	0xB436, 0xA014, 0xB438, 0x2c04, 0xB438, 0x2c07, 0xB438, 0x2c0a,
	0xB438, 0x2c0d, 0xB438, 0xa240, 0xB438, 0xa104, 0xB438, 0x292d,
	0xB438, 0x8620, 0xB438, 0xa480, 0xB438, 0x2a2c, 0xB438, 0x8480,
	0xB438, 0xa101, 0xB438, 0x2a36, 0xB438, 0xd056, 0xB438, 0x2223,
	0xB436, 0xA01A, 0xB438, 0x0000, 0xB436, 0xA006, 0xB438, 0x0222,
	0xB436, 0xA004, 0xB438, 0x0a35, 0xB436, 0xA002, 0xB438, 0x0a2b,
	0xB436, 0xA000, 0xB438, 0xf92c, 0xB436, 0xB820, 0xB438, 0x0210 };

static u8 r8153_usb_patch_b[] = {
	0x08, 0xe0, 0x0f, 0xe0, 0x18, 0xe0, 0x24, 0xe0,
	0x26, 0xe0, 0x3a, 0xe0, 0x84, 0xe0, 0x9c, 0xe0,
	0xc2, 0x49, 0x04, 0xf0, 0x02, 0xc0, 0x00, 0xb8,
	0x14, 0x18, 0x02, 0xc0, 0x00, 0xb8, 0x2e, 0x18,
	0x06, 0x89, 0x08, 0xc0, 0x0c, 0x61, 0x92, 0x48,
	0x93, 0x48, 0x0c, 0x89, 0x02, 0xc0, 0x00, 0xb8,
	0x08, 0x05, 0x40, 0xb4, 0x16, 0x89, 0x6d, 0xc0,
	0x00, 0x61, 0x95, 0x49, 0x06, 0xf0, 0xfa, 0xc0,
	0x0c, 0x61, 0x92, 0x48, 0x93, 0x48, 0x0c, 0x89,
	0x02, 0xc0, 0x00, 0xb8, 0xe2, 0x04, 0x02, 0xc2,
	0x00, 0xba, 0xec, 0x11, 0x60, 0x60, 0x85, 0x49,
	0x0d, 0xf1, 0x11, 0xc6, 0xd2, 0x61, 0x91, 0x49,
	0xfd, 0xf0, 0x74, 0x60, 0x04, 0x48, 0x74, 0x88,
	0x08, 0xc6, 0x08, 0xc0, 0xc4, 0x98, 0x01, 0x18,
	0xc0, 0x88, 0x02, 0xc0, 0x00, 0xb8, 0x6e, 0x12,
	0x04, 0xe4, 0x0d, 0x00, 0x00, 0xd4, 0xd1, 0x49,
	0x3c, 0xf1, 0xd2, 0x49, 0x16, 0xf1, 0xd3, 0x49,
	0x18, 0xf1, 0xd4, 0x49, 0x19, 0xf1, 0xd5, 0x49,
	0x1a, 0xf1, 0xd6, 0x49, 0x1b, 0xf1, 0xd7, 0x49,
	0x1c, 0xf1, 0xd8, 0x49, 0x1d, 0xf1, 0xd9, 0x49,
	0x20, 0xf1, 0xda, 0x49, 0x23, 0xf1, 0xdb, 0x49,
	0x24, 0xf1, 0x02, 0xc4, 0x00, 0xbc, 0x20, 0x04,
	0xe5, 0x8e, 0x02, 0xc4, 0x00, 0xbc, 0x14, 0x02,
	0x02, 0xc4, 0x00, 0xbc, 0x16, 0x02, 0x02, 0xc4,
	0x00, 0xbc, 0x18, 0x02, 0x02, 0xc4, 0x00, 0xbc,
	0x1a, 0x02, 0x02, 0xc4, 0x00, 0xbc, 0x1c, 0x02,
	0x02, 0xc4, 0x00, 0xbc, 0x94, 0x02, 0x10, 0xc7,
	0xe0, 0x8e, 0x02, 0xc4, 0x00, 0xbc, 0x8a, 0x02,
	0x0b, 0xc7, 0xe4, 0x8e, 0x02, 0xc4, 0x00, 0xbc,
	0x88, 0x02, 0x02, 0xc4, 0x00, 0xbc, 0x6e, 0x02,
	0x02, 0xc4, 0x00, 0xbc, 0x5a, 0x02, 0x30, 0xe4,
	0x0c, 0xc3, 0x60, 0x64, 0xc5, 0x49, 0x04, 0xf1,
	0x74, 0x64, 0xc4, 0x48, 0x74, 0x8c, 0x06, 0xc3,
	0x64, 0x8e, 0x02, 0xc4, 0x00, 0xbc, 0x20, 0x04,
	0x00, 0xd8, 0x00, 0xe4, 0xb2, 0xc0, 0x00, 0x61,
	0x90, 0x49, 0x09, 0xf1, 0x8b, 0xc6, 0xca, 0x61,
	0x94, 0x49, 0x0e, 0xf1, 0xf6, 0xc6, 0xda, 0x60,
	0x81, 0x49, 0x0a, 0xf0, 0x65, 0x60, 0x03, 0x48,
	0x65, 0x88, 0xef, 0xc6, 0xdc, 0x60, 0x80, 0x48,
	0xdc, 0x88, 0x05, 0xc6, 0x00, 0xbe, 0x02, 0xc6,
	0x00, 0xbe, 0x36, 0x13, 0x4c, 0x17, 0x99, 0xc4,
	0x80, 0x65, 0xd0, 0x49, 0x04, 0xf1, 0xfa, 0x75,
	0x04, 0xc4, 0x00, 0xbc, 0x03, 0xc4, 0x00, 0xbc,
	0x9a, 0x00, 0xee, 0x01 };

static u16 r8153_usb_patch_b_bp[] = {
	0xfc26, 0xa000, 0xfc28, 0x180c, 0xfc2a, 0x0506, 0xfc2c, 0x04E0,
	0xfc2e, 0x11E4, 0xfc30, 0x125C, 0xfc32, 0x0232, 0xfc34, 0x131E,
	0xfc36, 0x0098, 0xfc38, 0x00FF };

static u8 r8153_pla_patch_b[] = {
	0x08, 0xe0, 0xea, 0xe0, 0xf2, 0xe0, 0x04, 0xe1,
	0x09, 0xe1, 0x0e, 0xe1, 0x46, 0xe1, 0xf3, 0xe1,
	0x14, 0xc2, 0x40, 0x73, 0xba, 0x48, 0x40, 0x9b,
	0x11, 0xc2, 0x40, 0x73, 0xb0, 0x49, 0x17, 0xf0,
	0xbf, 0x49, 0x03, 0xf1, 0x09, 0xc5, 0x00, 0xbd,
	0xb1, 0x49, 0x11, 0xf0, 0xb1, 0x48, 0x40, 0x9b,
	0x02, 0xc2, 0x00, 0xba, 0x1a, 0x17, 0x00, 0xe0,
	0x1e, 0xfc, 0xbc, 0xc0, 0xf0, 0xc0, 0xde, 0xe8,
	0x00, 0x80, 0x00, 0x20, 0x2c, 0x75, 0xd4, 0x49,
	0x12, 0xf1, 0x32, 0xe0, 0xf8, 0xc2, 0x46, 0x71,
	0xf7, 0xc2, 0x40, 0x73, 0xbe, 0x49, 0x03, 0xf1,
	0xf5, 0xc7, 0x02, 0xe0, 0xf2, 0xc7, 0x4f, 0x30,
	0x26, 0x62, 0xa1, 0x49, 0xf0, 0xf1, 0x22, 0x72,
	0xa0, 0x49, 0xed, 0xf1, 0x25, 0x25, 0x18, 0x1f,
	0x97, 0x30, 0x91, 0x30, 0x36, 0x9a, 0x2c, 0x75,
	0x3c, 0xc3, 0x60, 0x73, 0xb1, 0x49, 0x0d, 0xf1,
	0xdc, 0x21, 0xbc, 0x25, 0x30, 0xc6, 0xc0, 0x77,
	0x04, 0x13, 0x21, 0xf0, 0x03, 0x13, 0x22, 0xf0,
	0x02, 0x13, 0x23, 0xf0, 0x01, 0x13, 0x24, 0xf0,
	0x08, 0x13, 0x08, 0xf1, 0x2e, 0x73, 0xba, 0x21,
	0xbd, 0x25, 0x05, 0x13, 0x03, 0xf1, 0x24, 0xc5,
	0x00, 0xbd, 0xd4, 0x49, 0x03, 0xf1, 0x1c, 0xc5,
	0x00, 0xbd, 0xc4, 0xc6, 0xc6, 0x67, 0x2e, 0x75,
	0xd7, 0x22, 0xdd, 0x26, 0x05, 0x15, 0x1b, 0xf0,
	0x14, 0xc6, 0x00, 0xbe, 0x13, 0xc5, 0x00, 0xbd,
	0x12, 0xc5, 0x00, 0xbd, 0xf1, 0x49, 0xfb, 0xf1,
	0xef, 0xe7, 0xf4, 0x49, 0xfa, 0xf1, 0xec, 0xe7,
	0xf3, 0x49, 0xf7, 0xf1, 0xe9, 0xe7, 0xf2, 0x49,
	0xf4, 0xf1, 0xe6, 0xe7, 0xb6, 0xc0, 0x9e, 0x12,
	0xde, 0x11, 0x0a, 0x12, 0x3c, 0x13, 0x00, 0xa0,
	0xa0, 0xd1, 0x00, 0x00, 0xc0, 0x75, 0xd0, 0x49,
	0x46, 0xf0, 0x26, 0x72, 0xa7, 0x49, 0x43, 0xf0,
	0x22, 0x72, 0x25, 0x25, 0x20, 0x1f, 0x97, 0x30,
	0x91, 0x30, 0x40, 0x73, 0xf3, 0xc4, 0x1c, 0x40,
	0x04, 0xf0, 0xd7, 0x49, 0x05, 0xf1, 0x37, 0xe0,
	0x53, 0x48, 0xc0, 0x9d, 0x08, 0x02, 0x40, 0x66,
	0x64, 0x27, 0x06, 0x16, 0x30, 0xf1, 0x46, 0x63,
	0x3b, 0x13, 0x2d, 0xf1, 0x34, 0x9b, 0x18, 0x1b,
	0x93, 0x30, 0x2b, 0xc3, 0x10, 0x1c, 0x2b, 0xe8,
	0x01, 0x14, 0x25, 0xf1, 0x00, 0x1d, 0x26, 0x1a,
	0x8a, 0x30, 0x22, 0x73, 0xb5, 0x25, 0x0e, 0x0b,
	0x00, 0x1c, 0x2c, 0xe8, 0x1f, 0xc7, 0x27, 0x40,
	0x1a, 0xf1, 0x38, 0xe8, 0x32, 0x1f, 0x8f, 0x30,
	0x08, 0x1b, 0x24, 0xe8, 0x36, 0x72, 0x46, 0x77,
	0x00, 0x17, 0x0d, 0xf0, 0x13, 0xc3, 0x1f, 0x40,
	0x03, 0xf1, 0x00, 0x1f, 0x46, 0x9f, 0x44, 0x77,
	0x9f, 0x44, 0x5f, 0x44, 0x17, 0xe8, 0x0a, 0xc7,
	0x27, 0x40, 0x05, 0xf1, 0x02, 0xc3, 0x00, 0xbb,
	0xfa, 0x18, 0xb0, 0x18, 0xff, 0xc7, 0x00, 0xbf,
	0xb8, 0xcd, 0xff, 0xff, 0x02, 0x0c, 0x54, 0xa5,
	0xdc, 0xa5, 0x2f, 0x40, 0x05, 0xf1, 0x00, 0x14,
	0xfa, 0xf1, 0x01, 0x1c, 0x02, 0xe0, 0x00, 0x1c,
	0x80, 0xff, 0xb0, 0x49, 0x04, 0xf0, 0x01, 0x0b,
	0xd3, 0xa1, 0x03, 0xe0, 0x02, 0x0b, 0xd3, 0xa5,
	0x27, 0x31, 0x20, 0x37, 0x02, 0x0b, 0xd3, 0xa5,
	0x27, 0x31, 0x20, 0x37, 0x00, 0x13, 0xfb, 0xf1,
	0x80, 0xff, 0x22, 0x73, 0xb5, 0x25, 0x18, 0x1e,
	0xde, 0x30, 0xd9, 0x30, 0x64, 0x72, 0x11, 0x1e,
	0x68, 0x23, 0x16, 0x31, 0x80, 0xff, 0x08, 0xc2,
	0x40, 0x73, 0x3a, 0x48, 0x40, 0x9b, 0x06, 0xff,
	0x02, 0xc6, 0x00, 0xbe, 0x08, 0x16, 0x1e, 0xfc,
	0x2c, 0x75, 0xdc, 0x21, 0xbc, 0x25, 0x04, 0x13,
	0x0b, 0xf0, 0x03, 0x13, 0x09, 0xf0, 0x02, 0x13,
	0x07, 0xf0, 0x01, 0x13, 0x05, 0xf0, 0x08, 0x13,
	0x03, 0xf0, 0x04, 0xc3, 0x00, 0xbb, 0x03, 0xc3,
	0x00, 0xbb, 0x8c, 0x15, 0x76, 0x15, 0xa0, 0x64,
	0x40, 0x48, 0xa0, 0x8c, 0x02, 0xc4, 0x00, 0xbc,
	0x82, 0x00, 0xa0, 0x62, 0x21, 0x48, 0xa0, 0x8a,
	0x02, 0xc2, 0x00, 0xba, 0x40, 0x03, 0x33, 0xc5,
	0xa0, 0x74, 0xc0, 0x49, 0x1f, 0xf0, 0x30, 0xc5,
	0xa0, 0x73, 0x00, 0x13, 0x04, 0xf1, 0xa2, 0x73,
	0x00, 0x13, 0x14, 0xf0, 0x28, 0xc5, 0xa0, 0x74,
	0xc8, 0x49, 0x1b, 0xf1, 0x26, 0xc5, 0xa0, 0x76,
	0xa2, 0x74, 0x01, 0x06, 0x20, 0x37, 0xa0, 0x9e,
	0xa2, 0x9c, 0x1e, 0xc5, 0xa2, 0x73, 0x23, 0x40,
	0x10, 0xf8, 0x04, 0xf3, 0xa0, 0x73, 0x33, 0x40,
	0x0c, 0xf8, 0x15, 0xc5, 0xa0, 0x74, 0x41, 0x48,
	0xa0, 0x9c, 0x14, 0xc5, 0xa0, 0x76, 0x62, 0x48,
	0xe0, 0x48, 0xa0, 0x9e, 0x10, 0xc6, 0x00, 0xbe,
	0x0a, 0xc5, 0xa0, 0x74, 0x48, 0x48, 0xa0, 0x9c,
	0x0b, 0xc5, 0x20, 0x1e, 0xa0, 0x9e, 0xe5, 0x48,
	0xa0, 0x9e, 0xf0, 0xe7, 0xbc, 0xc0, 0xc8, 0xd2,
	0xcc, 0xd2, 0x28, 0xe4, 0xe6, 0x01, 0xf0, 0xc0,
	0x18, 0x89, 0x00, 0x1d, 0x3c, 0xc3, 0x60, 0x71,
	0x3c, 0xc0, 0x02, 0x99, 0x00, 0x61, 0x67, 0x11,
	0x3c, 0xf1, 0x69, 0x33, 0x35, 0xc0, 0x28, 0x40,
	0xf6, 0xf1, 0x34, 0xc0, 0x00, 0x19, 0x81, 0x1b,
	0x8c, 0xe8, 0x31, 0xc0, 0x04, 0x1a, 0x84, 0x1b,
	0x88, 0xe8, 0x7d, 0xe8, 0xa3, 0x49, 0xfe, 0xf0,
	0x2b, 0xc0, 0x79, 0xe8, 0xa1, 0x48, 0x28, 0xc0,
	0x84, 0x1b, 0x7f, 0xe8, 0x00, 0x1d, 0x69, 0x33,
	0x00, 0x1e, 0x01, 0x06, 0xff, 0x18, 0x30, 0x40,
	0xfd, 0xf1, 0x18, 0xc0, 0x00, 0x76, 0x2e, 0x40,
	0xf7, 0xf1, 0x21, 0x48, 0x19, 0xc0, 0x84, 0x1b,
	0x70, 0xe8, 0x79, 0xc0, 0x64, 0xe8, 0xa1, 0x49,
	0xfd, 0xf0, 0x11, 0xc0, 0x00, 0x1a, 0x84, 0x1b,
	0x68, 0xe8, 0x5d, 0xe8, 0xa5, 0x49, 0xfe, 0xf0,
	0x09, 0xc0, 0x01, 0x19, 0x81, 0x1b, 0x61, 0xe8,
	0x4f, 0xe0, 0x88, 0xd3, 0x8c, 0xd3, 0xb8, 0x0b,
	0x50, 0xe8, 0x20, 0xb4, 0x10, 0xd8, 0x84, 0xd4,
	0xfc, 0xc0, 0x00, 0x61, 0x9c, 0x20, 0x9c, 0x24,
	0x06, 0x11, 0x06, 0xf1, 0x60, 0xc0, 0x00, 0x61,
	0x11, 0x48, 0x00, 0x89, 0x3d, 0xe0, 0x00, 0x11,
	0x02, 0xf1, 0x03, 0xe0, 0x04, 0x11, 0x06, 0xf1,
	0x56, 0xc0, 0x00, 0x61, 0x92, 0x48, 0x00, 0x89,
	0x33, 0xe0, 0x05, 0x11, 0x08, 0xf1, 0x4f, 0xc0,
	0x00, 0x61, 0x91, 0x49, 0x04, 0xf0, 0x91, 0x48,
	0x00, 0x89, 0x11, 0xe0, 0xde, 0xc0, 0x00, 0x61,
	0x98, 0x20, 0x98, 0x24, 0x25, 0x11, 0x24, 0xf1,
	0x45, 0xc0, 0x29, 0xe8, 0x95, 0x49, 0x20, 0xf0,
	0xd4, 0xc0, 0x00, 0x61, 0x98, 0x20, 0x98, 0x24,
	0x25, 0x11, 0x1a, 0xf1, 0x38, 0xc0, 0x00, 0x61,
	0x92, 0x49, 0x16, 0xf1, 0x12, 0x48, 0x00, 0x89,
	0x30, 0xc0, 0x00, 0x19, 0x00, 0x89, 0x2e, 0xc0,
	0x01, 0x89, 0x2e, 0xc0, 0x04, 0x19, 0x81, 0x1b,
	0x1c, 0xe8, 0x2b, 0xc0, 0x14, 0x19, 0x81, 0x1b,
	0x18, 0xe8, 0x22, 0xc0, 0x0c, 0xe8, 0x20, 0xc0,
	0x12, 0x48, 0x81, 0x1b, 0x12, 0xe8, 0xb3, 0xc3,
	0x62, 0x71, 0xb3, 0xc0, 0x02, 0x99, 0x02, 0xc0,
	0x00, 0xb8, 0x96, 0x07, 0x13, 0xc4, 0x84, 0x98,
	0x00, 0x1b, 0x86, 0x8b, 0x86, 0x73, 0xbf, 0x49,
	0xfe, 0xf1, 0x80, 0x71, 0x82, 0x72, 0x80, 0xff,
	0x09, 0xc4, 0x84, 0x98, 0x80, 0x99, 0x82, 0x9a,
	0x86, 0x8b, 0x86, 0x73, 0xbf, 0x49, 0xfe, 0xf1,
	0x80, 0xff, 0x08, 0xea, 0x10, 0xd4, 0x30, 0xd4,
	0x10, 0xc0, 0x12, 0xe8, 0x8a, 0xd3, 0x28, 0xe4,
	0x2c, 0xe4, 0x00, 0xd8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static u16 r8153_pla_patch_b_bp[] = {
	0xfc26, 0x8000, 0xfc28, 0x1154, 0xfc2a, 0x1606, 0xfc2c, 0x155a,
	0xfc2e, 0x0080, 0xfc30, 0x033c, 0xfc32, 0x01a0, 0xfc34, 0x0794,
	0xfc36, 0x0000, 0xfc38, 0x007f };

static u16 r8153_ram_code_d[] = {
	0xa436, 0xb820, 0xa438, 0x0290, 0xa436, 0xa012, 0xa438, 0x0000,
	0xa436, 0xa014, 0xa438, 0x2c04, 0xb438, 0x2c07, 0xb438, 0x2c07,
	0xb438, 0x2c07, 0xb438, 0xa240, 0xb438, 0xa104, 0xb438, 0x2944,
	0xa436, 0xa01a, 0xa438, 0x0000, 0xa436, 0xa006, 0xa438, 0x0fff,
	0xa436, 0xa004, 0xa438, 0x0fff, 0xa436, 0xa002, 0xa438, 0x0fff,
	0xa436, 0xa000, 0xa438, 0x1943, 0xa436, 0xb820, 0xa438, 0x0210 };

static u8 usb_patch_d[] = {
	0x08, 0xe0, 0x0a, 0xe0, 0x0c, 0xe0, 0x1f, 0xe0,
	0x28, 0xe0, 0x2a, 0xe0, 0x2c, 0xe0, 0x2e, 0xe0,
	0x02, 0xc5, 0x00, 0xbd, 0x00, 0x00, 0x02, 0xc3,
	0x00, 0xbb, 0x00, 0x00, 0x30, 0x18, 0x11, 0xc1,
	0x05, 0xe8, 0x10, 0xc6, 0x02, 0xc2, 0x00, 0xba,
	0x94, 0x17, 0x02, 0xb4, 0x09, 0xc2, 0x40, 0x99,
	0x0e, 0x48, 0x42, 0x98, 0x42, 0x70, 0x8e, 0x49,
	0xfe, 0xf1, 0x02, 0xb0, 0x80, 0xff, 0xc0, 0xd4,
	0xe4, 0x40, 0x20, 0xd4, 0xb0, 0x49, 0x04, 0xf0,
	0x30, 0x18, 0x06, 0xc1, 0xef, 0xef, 0xfa, 0xc7,
	0x02, 0xc0, 0x00, 0xb8, 0x38, 0x12, 0xe4, 0x4b,
	0x02, 0xc3, 0x00, 0xbb, 0x00, 0x00, 0x02, 0xc5,
	0x00, 0xbd, 0x00, 0x00, 0x02, 0xc1, 0x00, 0xb9,
	0x00, 0x00, 0x02, 0xc1, 0x00, 0xb9, 0x00, 0x00 };

static u16 r8153_usb_patch_d_bp[] = {
	0xfc26, 0xa000, 0xfc28, 0x0000, 0xfc2a, 0x0000, 0xfc2c, 0x1792,
	0xfc2e, 0x1236, 0xfc30, 0x0000, 0xfc32, 0x0000, 0xfc34, 0x0000,
	0xfc36, 0x0000, 0xfc38, 0x000c };

static void rtl_clear_bp(struct r8152 *tp)
{
	ocp_write_dword(tp, MCU_TYPE_PLA, PLA_BP_0, 0);
	ocp_write_dword(tp, MCU_TYPE_PLA, PLA_BP_2, 0);
	ocp_write_dword(tp, MCU_TYPE_PLA, PLA_BP_4, 0);
	ocp_write_dword(tp, MCU_TYPE_PLA, PLA_BP_6, 0);
	ocp_write_dword(tp, MCU_TYPE_USB, USB_BP_0, 0);
	ocp_write_dword(tp, MCU_TYPE_USB, USB_BP_2, 0);
	ocp_write_dword(tp, MCU_TYPE_USB, USB_BP_4, 0);
	ocp_write_dword(tp, MCU_TYPE_USB, USB_BP_6, 0);

	mdelay(6);

	ocp_write_word(tp, MCU_TYPE_PLA, PLA_BP_BA, 0);
	ocp_write_word(tp, MCU_TYPE_USB, USB_BP_BA, 0);
}

static void r8153_clear_bp(struct r8152 *tp)
{
	ocp_write_byte(tp, MCU_TYPE_PLA, PLA_BP_EN, 0);
	ocp_write_byte(tp, MCU_TYPE_USB, USB_BP_EN, 0);
	rtl_clear_bp(tp);
}

static void r8152b_set_dq_desc(struct r8152 *tp)
{
	u8 data;

	data = ocp_read_byte(tp, MCU_TYPE_USB, 0xd429);
	data |= 0x80;
	ocp_write_byte(tp, MCU_TYPE_USB, 0xd429, data);
	ocp_write_word(tp, MCU_TYPE_USB, 0xc0ce, 0x0210);
	data = ocp_read_byte(tp, MCU_TYPE_USB, 0xd429);
	data &= ~0x80;
	ocp_write_byte(tp, MCU_TYPE_USB, 0xd429, data);
}

static int r8153_pre_ram_code(struct r8152 *tp, u16 patch_key)
{
	u16 data;
	int i;

	data = ocp_reg_read(tp, 0xb820);
	data |= 0x0010;
	ocp_reg_write(tp, 0xb820, data);

	for (i = 0, data = 0; !data && i < 5000; i++) {
		mdelay(2);
		data = ocp_reg_read(tp, 0xb800) & 0x0040;
	}

	sram_write(tp, 0x8146, patch_key);
	sram_write(tp, 0xb82e, 0x0001);

	return -EBUSY;
}

static int r8153_post_ram_code(struct r8152 *tp)
{
	u16 data;

	sram_write(tp, 0x0000, 0x0000);

	data = ocp_reg_read(tp, 0xb82e);
	data &= ~0x0001;
	ocp_reg_write(tp, 0xb82e, data);

	sram_write(tp, 0x8146, 0x0000);

	data = ocp_reg_read(tp, 0xb820);
	data &= ~0x0010;
	ocp_reg_write(tp, 0xb820, data);

	ocp_write_word(tp, MCU_TYPE_PLA, PLA_OCP_GPHY_BASE, tp->ocp_base);

	return 0;
}

static void r8153_wdt1_end(struct r8152 *tp)
{
	int i;

	for (i = 0; i < 104; i++) {
		if (!(ocp_read_byte(tp, MCU_TYPE_USB, 0xe404) & 1))
			break;
		mdelay(2);
	}
}

void r8152b_firmware(struct r8152 *tp)
{
	int i;

	if (tp->version == RTL_VER_01) {
		int i;

		r8152b_set_dq_desc(tp);
		rtl_clear_bp(tp);

		generic_ocp_write(tp, 0xf800, 0x3f,
				  sizeof(r8152b_pla_patch_a),
				  r8152b_pla_patch_a, MCU_TYPE_PLA);

		for (i = 0; i < ARRAY_SIZE(r8152b_pla_patch_a_bp); i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8152b_pla_patch_a_bp[i],
				       r8152b_pla_patch_a_bp[i+1]);

		ocp_write_word(tp, MCU_TYPE_PLA, PLA_OCP_GPHY_BASE, 0x2000);
		ocp_write_word(tp, MCU_TYPE_PLA, 0xb092, 0x7070);
		ocp_write_word(tp, MCU_TYPE_PLA, 0xb098, 0x0600);
		for (i = 0; i < ARRAY_SIZE(r8152b_ram_code1); i++)
			ocp_write_word(tp, MCU_TYPE_PLA, 0xb09a,
				       r8152b_ram_code1[i]);

		ocp_write_word(tp, MCU_TYPE_PLA, 0xb098, 0x0200);
		ocp_write_word(tp, MCU_TYPE_PLA, 0xb092, 0x7030);
	} else if (tp->version == RTL_VER_02) {
		rtl_clear_bp(tp);

		generic_ocp_write(tp, 0xf800, 0xff,
				  sizeof(r8152b_pla_patch_a2),
				  r8152b_pla_patch_a2, MCU_TYPE_PLA);

		for (i = 0; i < ARRAY_SIZE(r8152b_pla_patch_a2_bp);
		     i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8152b_pla_patch_a2_bp[i],
				       r8152b_pla_patch_a2_bp[i+1]);
	}
}

void r8153_firmware(struct r8152 *tp)
{
	int i;

	if (tp->version == RTL_VER_03) {
		r8153_clear_bp(tp);

		r8153_pre_ram_code(tp, 0x7000);

		for (i = 0; i < ARRAY_SIZE(r8153_ram_code_a); i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8153_ram_code_a[i],
				       r8153_ram_code_a[i+1]);

		r8153_post_ram_code(tp);
	} else if (tp->version == RTL_VER_04) {
		r8153_pre_ram_code(tp, 0x7001);

		for (i = 0; i < ARRAY_SIZE(r8153_ram_code_bc); i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8153_ram_code_bc[i],
				       r8153_ram_code_bc[i+1]);

		r8153_post_ram_code(tp);

		r8153_wdt1_end(tp);
		r8153_clear_bp(tp);

		ocp_write_word(tp, MCU_TYPE_USB, USB_BP_EN, 0x0000);
		generic_ocp_write(tp, 0xf800, 0xff,
				  sizeof(r8153_usb_patch_b),
				  r8153_usb_patch_b, MCU_TYPE_USB);

		for (i = 0; i < ARRAY_SIZE(r8153_usb_patch_b_bp); i += 2)
			ocp_write_word(tp, MCU_TYPE_USB,
				       r8153_usb_patch_b_bp[i],
				       r8153_usb_patch_b_bp[i+1]);

		if (!(ocp_read_word(tp, MCU_TYPE_PLA, 0xd38e) & BIT(0))) {
			ocp_write_word(tp, MCU_TYPE_PLA, 0xd38c, 0x0082);
			ocp_write_word(tp, MCU_TYPE_PLA, 0xd38e, 0x0082);
		}

		ocp_write_word(tp, MCU_TYPE_PLA, PLA_BP_EN, 0x0000);
		generic_ocp_write(tp, 0xf800, 0xff,
				  sizeof(r8153_pla_patch_b),
				  r8153_pla_patch_b, MCU_TYPE_PLA);

		for (i = 0; i < ARRAY_SIZE(r8153_pla_patch_b_bp); i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8153_pla_patch_b_bp[i],
				       r8153_pla_patch_b_bp[i+1]);

		ocp_write_word(tp, MCU_TYPE_PLA, 0xd388, 0x08ca);
	} else if (tp->version == RTL_VER_05) {
		u32 ocp_data;

		ocp_data = ocp_read_word(tp, MCU_TYPE_USB, 0xcfca);
		ocp_data &= ~0x4000;
		ocp_write_word(tp, MCU_TYPE_USB, 0xcfca, ocp_data);

		r8153_pre_ram_code(tp, 0x7001);

		for (i = 0; i < ARRAY_SIZE(r8153_ram_code_bc); i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8153_ram_code_bc[i],
				       r8153_ram_code_bc[i+1]);

		r8153_post_ram_code(tp);

		r8153_wdt1_end(tp);
		r8153_clear_bp(tp);

		ocp_write_word(tp, MCU_TYPE_USB, USB_BP_EN, 0x0000);
		generic_ocp_write(tp, 0xf800, 0xff,
				  sizeof(r8153_usb_patch_c),
				  r8153_usb_patch_c, MCU_TYPE_USB);

		for (i = 0; i < ARRAY_SIZE(r8153_usb_patch_c_bp); i += 2)
			ocp_write_word(tp, MCU_TYPE_USB,
				       r8153_usb_patch_c_bp[i],
				       r8153_usb_patch_c_bp[i+1]);

		if (ocp_read_byte(tp, MCU_TYPE_USB, 0xcfef) & 1) {
			ocp_write_word(tp, MCU_TYPE_USB, 0xfc30, 0x1578);
			ocp_write_word(tp, MCU_TYPE_USB, USB_BP_EN, 0x00ff);
		} else {
			ocp_write_word(tp, MCU_TYPE_USB, USB_BP_EN, 0x00ef);
		}

		ocp_write_word(tp, MCU_TYPE_PLA, PLA_BP_EN, 0x0000);
		generic_ocp_write(tp, 0xf800, 0xff,
				  sizeof(r8153_pla_patch_c),
				  r8153_pla_patch_c, MCU_TYPE_PLA);

		for (i = 0; i < ARRAY_SIZE(r8153_pla_patch_c_bp); i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8153_pla_patch_c_bp[i],
				       r8153_pla_patch_c_bp[i+1]);

		ocp_write_word(tp, MCU_TYPE_PLA, 0xd388, 0x08ca);

		ocp_data = ocp_read_word(tp, MCU_TYPE_USB, 0xcfca);
		ocp_data |= 0x4000;
		ocp_write_word(tp, MCU_TYPE_USB, 0xcfca, ocp_data);
	} else if (tp->version == RTL_VER_06) {
		r8153_pre_ram_code(tp, 0x7002);

		for (i = 0; i < ARRAY_SIZE(r8153_ram_code_d); i += 2)
			ocp_write_word(tp, MCU_TYPE_PLA,
				       r8153_ram_code_d[i],
				       r8153_ram_code_d[i+1]);

		r8153_post_ram_code(tp);

		r8153_clear_bp(tp);

		ocp_write_word(tp, MCU_TYPE_USB, USB_BP_EN, 0x0000);
		generic_ocp_write(tp, 0xf800, 0xff, sizeof(usb_patch_d),
				  usb_patch_d, MCU_TYPE_USB);

		for (i = 0; i < ARRAY_SIZE(r8153_usb_patch_d_bp); i += 2)
			ocp_write_word(tp, MCU_TYPE_USB,
				       r8153_usb_patch_d_bp[i],
				       r8153_usb_patch_d_bp[i+1]);
	}
}
