/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Cortina PHY drivers
 *
 * Copyright 2014 Freescale Semiconductor, Inc.
 */

#ifndef _CORTINA_H_
#define _CORTINA_H_

#define VILLA_GLOBAL_CHIP_ID_LSB     0x000
#define VILLA_GLOBAL_CHIP_ID_MSB     0x001
#define VILLA_GLOBAL_BIST_CONTROL    0x002
#define VILLA_GLOBAL_BIST_STATUS     0x003
#define VILLA_GLOBAL_LINE_SOFT_RESET 0x007
#define VILLA_GLOBAL_HOST_SOFT_RESET 0x008
#define VILLA_GLOBAL_DWNLD_CHECKSUM_CTRL 0x00A
#define VILLA_GLOBAL_DWNLD_CHECKSUM_STATUS 0x00B
#define VILLA_GLOBAL_MSEQCLKCTRL 0x00E
#define VILLA_MSEQ_OPTIONS       0x1D0
#define VILLA_MSEQ_PC		 0x1D3
#define VILLA_MSEQ_BANKSELECT    0x1DF
#define VILLA_DSP_SDS_DSP_COEF_DFE0_SELECT     0x2DB
#define VILLA_DSP_SDS_SERDES_SRX_DFE0_SELECT   0x36E
#define VILLA_LINE_SDS_COMMON_SRX0_RX_LOOP_FILTER   0x403
#define VILLA_LINE_SDS_COMMON_SRX0_RX_CPA	0x404
#define VILLA_LINE_SDS_COMMON_SRX0_RX_CPB	0x405
#define VILLA_DSP_SDS_SERDES_SRX_FFE_DELAY_CTRL	0x369
#define VILLA_MSEQ_ENABLE_MSB	0x194
#define VILLA_MSEQ_SPARE21_LSB	0x226
#define VILLA_MSEQ_RESET_COUNT_LSB  0x1E0
#define VILLA_MSEQ_SPARE12_MSB  0x215
#define VILLA_MSEQ_SPARE2_LSB   0x200
#define VILLA_MSEQ_SPARE7_LSB   0x20A
#define VILLA_MSEQ_SPARE9_LSB   0x20E
#define VILLA_MSEQ_SPARE3_LSB   0x202
#define VILLA_MSEQ_SPARE3_MSB   0x203
#define VILLA_MSEQ_SPARE8_LSB   0x20C
#define VILLA_MSEQ_SPARE8_MSB   0x20D
#define VILLA_MSEQ_COEF8_FFE0_LSB 0x1E2
#define VILLA_MSEQ_COEF8_FFE1_LSB 0x1E4
#define VILLA_MSEQ_COEF8_FFE2_LSB 0x1E6
#define VILLA_MSEQ_COEF8_FFE3_LSB 0x1E8
#define VILLA_MSEQ_COEF8_FFE4_LSB 0x1EA
#define VILLA_MSEQ_COEF8_FFE5_LSB 0x1EC
#define VILLA_MSEQ_COEF8_DFE0_LSB 0x1F0
#define VILLA_MSEQ_COEF8_DFE0N_LSB 0x1EE
#define VILLA_MSEQ_COEF8_DFE1_LSB  0x1F2
#define VILLA_DSP_SDS_DSP_COEF_LARGE_LEAK 0x2E2
#define VILLA_DSP_SDS_SERDES_SRX_DAC_ENABLEB_LSB 0x360
#define VILLA_MSEQ_POWER_DOWN_LSB  0x198
#define VILLA_MSEQ_POWER_DOWN_MSB  0x199
#define VILLA_MSEQ_CAL_RX_SLICER   0x1B8
#define VILLA_DSP_SDS_SERDES_SRX_DAC_BIAS_SELECT1_MSB 0x365
#define VILLA_MSEQ_COEF_INIT_SEL  0x1AE
#define VILLA_DSP_SDS_DSP_PRECODEDINITFFE21 0x26A
#define VILLA_MSEQ_SERDES_PARAM_LSB 0x195
#define VILLA_MSEQ_SPARE25_LSB	0x22E
#define VILLA_MSEQ_SPARE23_LSB	0x22A
#define VILLA_MSEQ_CAL_RX_DFE_EQ 0x1BA
#define VILLA_GLOBAL_VILLA2_COMPATIBLE      0x030
#define VILLA_HOST_SDS_COMMON_STX0_TX_OUTPUT_CTRLA  0x812
#define VILLA_HOST_SDS_COMMON_STX0_TX_OUTPUT_CTRLB  0x813
#define VILLA_LINE_SDS_COMMON_STX0_TX_OUTPUT_CTRLA 0x427
#define VILLA_LINE_SDS_COMMON_STX0_TX_OUTPUT_CTRLB 0x428

#define mseq_edc_bist_done (0x1<<0)
#define mseq_edc_bist_fail (0x1<<8)

struct cortina_reg_config {
	unsigned short reg_addr;
	unsigned short reg_value;
};
#endif
