/*
 * Copyright (C) 2014-2015 Masahiro Yamada <yamada.masahiro@socionext.com>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <spl.h>
#include <linux/io.h>
#include <mach/boot-device.h>
#include <mach/sg-regs.h>
#include <mach/sbc-regs.h>

struct boot_device_info boot_device_table[] = {
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "External Master"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_MMC1, "eMMC (3.3V, Boot Oparation)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_MMC1, "eMMC (1.8V, Boot Oparation)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_MMC1, "eMMC (3.3V, Normal)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_MMC1, "eMMC (1.8V, Normal)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC  8, EraseSize 128KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC  8, EraseSize 256KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC  8, EraseSize 512KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC 16, EraseSize 128KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC 16, EraseSize 256KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC 16, EraseSize 512KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 4, ECC 24, EraseSize   1MB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC  8, EraseSize 128KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC  8, EraseSize 256KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC  8, EraseSize 512KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC 16, EraseSize 128KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC 16, EraseSize 256KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC 16, EraseSize 512KB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC 24, EraseSize   1MB, Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC  8, ONFI,            Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 1, ECC 16, ONFI,            Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 4, ECC 24, ONFI,            Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC  8, ONFI,            Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC 16, ONFI,            Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NAND, "NAND (Mirror 8, ECC 24, ONFI,            Addr 5)"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{BOOT_DEVICE_NONE, "Reserved"},
	{ /* sentinel */ }
};

int get_boot_mode_sel(void)
{
	return readl(SG_PINMON0) & 0x3f;
}

u32 spl_boot_device(void)
{
	int boot_mode;

	if (boot_is_swapped())
		return BOOT_DEVICE_NOR;

	boot_mode = get_boot_mode_sel();

	return boot_device_table[boot_mode].type;
}
