/*
 * Copyright 2014, Freescale Semiconductor
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _ASM_ARMV8_FSL_LSCH3_CONFIG_
#define _ASM_ARMV8_FSL_LSCH3_CONFIG_

#include <fsl_ddrc_version.h>

#define CONFIG_SYS_FSL_OCRAM_BASE	0x18000000	/* initial RAM */
/* Link Definitions */
#define CONFIG_SYS_INIT_SP_ADDR		(CONFIG_SYS_FSL_OCRAM_BASE + 0xfff0)

#define CONFIG_SYS_IMMR				0x01000000
#define CONFIG_SYS_FSL_DDR_ADDR			(CONFIG_SYS_IMMR + 0x00080000)
#define CONFIG_SYS_FSL_DDR2_ADDR		(CONFIG_SYS_IMMR + 0x00090000)
#define CONFIG_SYS_FSL_GUTS_ADDR		(CONFIG_SYS_IMMR + 0x00E00000)
#define CONFIG_SYS_FSL_PMU_ADDR			(CONFIG_SYS_IMMR + 0x00E30000)
#define CONFIG_SYS_FSL_CH3_CLK_GRPA_ADDR	(CONFIG_SYS_IMMR + 0x00300000)
#define CONFIG_SYS_FSL_CH3_CLK_GRPB_ADDR	(CONFIG_SYS_IMMR + 0x00310000)
#define CONFIG_SYS_FSL_CH3_CLK_CTRL_ADDR	(CONFIG_SYS_IMMR + 0x00370000)
#define CONFIG_SYS_IFC_ADDR			(CONFIG_SYS_IMMR + 0x01240000)
#define CONFIG_SYS_NS16550_COM1			(CONFIG_SYS_IMMR + 0x011C0500)
#define CONFIG_SYS_NS16550_COM2			(CONFIG_SYS_IMMR + 0x011C0600)
#define CONFIG_SYS_FSL_TIMER_ADDR		0x023d0000
#define CONFIG_SYS_FSL_PMU_CLTBENR		(CONFIG_SYS_FSL_PMU_ADDR + \
						 0x18A0)

#define I2C1_BASE_ADDR				(CONFIG_SYS_IMMR + 0x01000000)
#define I2C2_BASE_ADDR				(CONFIG_SYS_IMMR + 0x01010000)
#define I2C3_BASE_ADDR				(CONFIG_SYS_IMMR + 0x01020000)
#define I2C4_BASE_ADDR				(CONFIG_SYS_IMMR + 0x01030000)

/* Generic Interrupt Controller Definitions */
#define GICD_BASE		0x06000000
#define GICR_BASE		0x06100000

/* SMMU Defintions */
#define SMMU_BASE		0x05000000 /* GR0 Base */

/* DDR */
#define CONFIG_SYS_FSL_DDR_LE
#define CONFIG_VERY_BIG_RAM
#define CONFIG_SYS_FSL_DDRC_ARM_GEN3	/* Enable Freescale ARM DDR3 driver */
#define CONFIG_SYS_FSL_DDR		/* Freescale DDR driver */
#define CONFIG_SYS_LS2_DDR_BLOCK1_SIZE	((phys_size_t)2 << 30)
#define CONFIG_MAX_MEM_MAPPED		CONFIG_SYS_LS2_DDR_BLOCK1_SIZE
#define CONFIG_SYS_FSL_DDR_VER		FSL_DDR_VER_5_0


/* IFC */
#define CONFIG_SYS_FSL_IFC_LE

#ifdef CONFIG_LS2085A
#define CONFIG_MAX_CPUS				16
#define CONFIG_SYS_FSL_IFC_BANK_COUNT		8
#define CONFIG_NUM_DDR_CONTROLLERS		2
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS		{ 1, 1, 4, 4 }
#else
#error SoC not defined
#endif

#endif /* _ASM_ARMV8_FSL_LSCH3_CONFIG_ */
