/*
 * Copyright (C) 2013 Gabor Juhos <juhosg@openwrt.org>
 * Copyright (C) 2013 Imagination Technologies
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef _MIPS_ASM_MALTA_H
#define _MIPS_ASM_MALTA_H

#define MALTA_GT_BASE			0x1be00000
#define MALTA_GT_PCIIO_BASE		0x18000000
#define MALTA_GT_UART0_BASE		(MALTA_GT_PCIIO_BASE + 0x3f8)

#define MALTA_MSC01_BIU_BASE		0x1bc80000
#define MALTA_MSC01_PCI_BASE		0x1bd00000
#define MALTA_MSC01_PBC_BASE		0x1bd40000
#define MALTA_MSC01_IP1_BASE		0x1bc00000
#define MALTA_MSC01_IP1_SIZE		0x00400000
#define MALTA_MSC01_IP2_BASE1		0x10000000
#define MALTA_MSC01_IP2_SIZE1		0x08000000
#define MALTA_MSC01_IP2_BASE2		0x18000000
#define MALTA_MSC01_IP2_SIZE2		0x04000000
#define MALTA_MSC01_IP3_BASE		0x1c000000
#define MALTA_MSC01_IP3_SIZE		0x04000000
#define MALTA_MSC01_PCIMEM_BASE		0x10000000
#define MALTA_MSC01_PCIMEM_SIZE		0x10000000
#define MALTA_MSC01_PCIMEM_MAP		0x10000000
#define MALTA_MSC01_PCIIO_BASE		0x1b000000
#define MALTA_MSC01_PCIIO_SIZE		0x00800000
#define MALTA_MSC01_PCIIO_MAP		0x00000000
#define MALTA_MSC01_UART0_BASE		(MALTA_MSC01_PCIIO_BASE + 0x3f8)

#define MALTA_ASCIIWORD			0x1f000410
#define MALTA_ASCIIPOS0			0x1f000418
#define MALTA_ASCIIPOS1			0x1f000420
#define MALTA_ASCIIPOS2			0x1f000428
#define MALTA_ASCIIPOS3			0x1f000430
#define MALTA_ASCIIPOS4			0x1f000438
#define MALTA_ASCIIPOS5			0x1f000440
#define MALTA_ASCIIPOS6			0x1f000448
#define MALTA_ASCIIPOS7			0x1f000450

#define MALTA_RESET_BASE		0x1f000500
#define GORESET				0x42

#define MALTA_FLASH_BASE		0x1e000000

#define MALTA_REVISION			0x1fc00010
#define MALTA_REVISION_CORID_SHF	10
#define MALTA_REVISION_CORID_MSK	(0x3f << MALTA_REVISION_CORID_SHF)
#define MALTA_REVISION_CORID_CORE_LV		1
#define MALTA_REVISION_CORID_CORE_FPGA6		14

#define PCI_CFG_PIIX4_PIRQRCA		0x60
#define PCI_CFG_PIIX4_PIRQRCB		0x61
#define PCI_CFG_PIIX4_PIRQRCC		0x62
#define PCI_CFG_PIIX4_PIRQRCD		0x63

#endif /* _MIPS_ASM_MALTA_H */
