/*
 *  Single source autogenerated distributable for Duktape 1.4.1.
 *
 *  Git commit 70315eded64ade7852680433e4becbfa28afe8e2 (v1.4.1).
 *  Git branch HEAD.
 *
 *  See Duktape AUTHORS.rst and LICENSE.txt for copyright and
 *  licensing information.
 */

/* LICENSE.txt */
/*
*  ===============
*  Duktape license
*  ===============
*
*  (http://opensource.org/licenses/MIT)
*
*  Copyright (c) 2013-2016 by Duktape authors (see AUTHORS.rst)
*
*  Permission is hereby granted, free of charge, to any person obtaining a copy
*  of this software and associated documentation files (the "Software"), to deal
*  in the Software without restriction, including without limitation the rights
*  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*  copies of the Software, and to permit persons to whom the Software is
*  furnished to do so, subject to the following conditions:
*
*  The above copyright notice and this permission notice shall be included in
*  all copies or substantial portions of the Software.
*
*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*  THE SOFTWARE.
*/
/* AUTHORS.rst */
/*
*  ===============
*  Duktape authors
*  ===============
*
*  Copyright
*  =========
*
*  Duktape copyrights are held by its authors.  Each author has a copyright
*  to their contribution, and agrees to irrevocably license the contribution
*  under the Duktape ``LICENSE.txt``.
*
*  Authors
*  =======
*
*  Please include an e-mail address, a link to your GitHub profile, or something
*  similar to allow your contribution to be identified accurately.
*
*  The following people have contributed code, website contents, or Wiki contents,
*  and agreed to irrevocably license their contributions under the Duktape
*  ``LICENSE.txt`` (in order of appearance):
*
*  * Sami Vaarala <sami.vaarala@iki.fi>
*  * Niki Dobrev
*  * Andreas \u00d6man <andreas@lonelycoder.com>
*  * L\u00e1szl\u00f3 Lang\u00f3 <llango.u-szeged@partner.samsung.com>
*  * Legimet <legimet.calc@gmail.com>
*  * Karl Skomski <karl@skomski.com>
*  * Bruce Pascoe <fatcerberus1@gmail.com>
*  * Ren\u00e9 Hollander <rene@rene8888.at>
*
*  Other contributions
*  ===================
*
*  The following people have contributed something other than code (e.g. reported
*  bugs, provided ideas, etc; roughly in order of appearance):
*
*  * Greg Burns
*  * Anthony Rabine
*  * Carlos Costa
*  * Aur\u00e9lien Bouilland
*  * Preet Desai (Pris Matic)
*  * judofyr (http://www.reddit.com/user/judofyr)
*  * Jason Woofenden
*  * Micha\u0142 Przyby\u015b
*  * Anthony Howe
*  * Conrad Pankoff
*  * Jim Schimpf
*  * Rajaran Gaunker (https://github.com/zimbabao)
*  * Andreas \u00d6man
*  * Doug Sanden
*  * Josh Engebretson (https://github.com/JoshEngebretson)
*  * Remo Eichenberger (https://github.com/remoe)
*  * Mamod Mehyar (https://github.com/mamod)
*  * David Demelier (https://github.com/markand)
*  * Tim Caswell (https://github.com/creationix)
*  * Mitchell Blank Jr (https://github.com/mitchblank)
*  * https://github.com/yushli
*  * Seo Sanghyeon (https://github.com/sanxiyn)
*  * Han ChoongWoo (https://github.com/tunz)
*  * Joshua Peek (https://github.com/josh)
*  * Bruce E. Pascoe (https://github.com/fatcerberus)
*  * https://github.com/Kelledin
*  * https://github.com/sstruchtrup
*  * Michael Drake (https://github.com/tlsa)
*  * https://github.com/chris-y
*  * Laurent Zubiaur (https://github.com/lzubiaur)
*
*  If you are accidentally missing from this list, send me an e-mail
*  (``sami.vaarala@iki.fi``) and I'll fix the omission.
*/
#line 1 "duk_internal.h"
/*
 *  Top-level include file to be used for all (internal) source files.
 *
 *  Source files should not include individual header files, as they
 *  have not been designed to be individually included.
 */

#ifndef DUK_INTERNAL_H_INCLUDED
#define DUK_INTERNAL_H_INCLUDED

/*
 *  The 'duktape.h' header provides the public API, but also handles all
 *  compiler and platform specific feature detection, Duktape feature
 *  resolution, inclusion of system headers, etc.  These have been merged
 *  because the public API is also dependent on e.g. detecting appropriate
 *  C types which is quite platform/compiler specific especially for a non-C99
 *  build.  The public API is also dependent on the resolved feature set.
 *
 *  Some actions taken by the merged header (such as including system headers)
 *  are not appropriate for building a user application.  The define
 *  DUK_COMPILING_DUKTAPE allows the merged header to skip/include some
 *  sections depending on what is being built.
 */

#define DUK_COMPILING_DUKTAPE
#include "duktape.h"

/*
 *  User declarations, e.g. prototypes for user functions used by Duktape
 *  macros.  Concretely, if DUK_USE_PANIC_HANDLER is used and the macro
 *  value calls a user function, it needs to be declared for Duktape
 *  compilation to avoid warnings.
 */

DUK_USE_USER_DECLARE()

/*
 *  Duktape includes (other than duk_features.h)
 *
 *  The header files expect to be included in an order which satisfies header
 *  dependencies correctly (the headers themselves don't include any other
 *  includes).  Forward declarations are used to break circular struct/typedef
 *  dependencies.
 */

#line 1 "duk_replacements.h"
#ifndef DUK_REPLACEMENTS_H_INCLUDED
#define DUK_REPLACEMENTS_H_INCLUDED

#if defined(DUK_USE_COMPUTED_INFINITY)
DUK_INTERNAL_DECL double duk_computed_infinity;
#endif

#if defined(DUK_USE_COMPUTED_NAN)
DUK_INTERNAL_DECL double duk_computed_nan;
#endif

#if defined(DUK_USE_REPL_FPCLASSIFY)
DUK_INTERNAL_DECL int duk_repl_fpclassify(double x);
#endif

#if defined(DUK_USE_REPL_SIGNBIT)
DUK_INTERNAL_DECL int duk_repl_signbit(double x);
#endif

#if defined(DUK_USE_REPL_ISFINITE)
DUK_INTERNAL_DECL int duk_repl_isfinite(double x);
#endif

#if defined(DUK_USE_REPL_ISNAN)
DUK_INTERNAL_DECL int duk_repl_isnan(double x);
#endif

#if defined(DUK_USE_REPL_ISINF)
DUK_INTERNAL_DECL int duk_repl_isinf(double x);
#endif

#endif  /* DUK_REPLACEMENTS_H_INCLUDED */
#line 1 "duk_jmpbuf.h"
/*
 *  Wrapper for jmp_buf.
 *
 *  This is used because jmp_buf is an array type for backward compatibility.
 *  Wrapping jmp_buf in a struct makes pointer references, sizeof, etc,
 *  behave more intuitively.
 *
 *  http://en.wikipedia.org/wiki/Setjmp.h#Member_types
 */

#ifndef DUK_JMPBUF_H_INCLUDED
#define DUK_JMPBUF_H_INCLUDED

#if !defined(DUK_USE_CPP_EXCEPTIONS)
struct duk_jmpbuf {
#if defined(DUK_USE_SETJMP) || defined(DUK_USE_UNDERSCORE_SETJMP)
	jmp_buf jb;
#elif defined(DUK_USE_SIGSETJMP)
	sigjmp_buf jb;
#else
#error internal error, no long control transfer provider
#endif
};
#endif

#endif  /* DUK_JMPBUF_H_INCLUDED */
#line 1 "duk_exception.h"
/*
 *  Exception for Duktape internal throws when C++ exceptions are used
 *  for long control transfers.
 *
 *  Doesn't inherit from any exception base class to minimize the chance
 *  that user code would accidentally catch this exception.
 */

#ifndef DUK_EXCEPTION_H_INCLUDED
#define DUK_EXCEPTION_H_INCLUDED

#if defined(DUK_USE_CPP_EXCEPTIONS)
class duk_internal_exception {
	/* intentionally empty */
};
#endif

#endif  /* DUK_EXCEPTION_H_INCLUDED */
#line 1 "duk_forwdecl.h"
/*
 *  Forward declarations for all Duktape structures.
 */

#ifndef DUK_FORWDECL_H_INCLUDED
#define DUK_FORWDECL_H_INCLUDED

/*
 *  Forward declarations
 */

#if defined(DUK_USE_CPP_EXCEPTIONS)
class duk_internal_exception;
#else
struct duk_jmpbuf;
#endif

/* duk_tval intentionally skipped */
struct duk_heaphdr;
struct duk_heaphdr_string;
struct duk_hstring;
struct duk_hstring_external;
struct duk_hobject;
struct duk_hcompiledfunction;
struct duk_hnativefunction;
struct duk_hthread;
struct duk_hbufferobject;
struct duk_hbuffer;
struct duk_hbuffer_fixed;
struct duk_hbuffer_dynamic;
struct duk_hbuffer_external;

struct duk_propaccessor;
union duk_propvalue;
struct duk_propdesc;

struct duk_heap;
struct duk_breakpoint;

struct duk_activation;
struct duk_catcher;
struct duk_strcache;
struct duk_ljstate;
struct duk_strtab_entry;

#ifdef DUK_USE_DEBUG
struct duk_fixedbuffer;
#endif

struct duk_bitdecoder_ctx;
struct duk_bitencoder_ctx;
struct duk_bufwriter_ctx;

struct duk_token;
struct duk_re_token;
struct duk_lexer_point;
struct duk_lexer_ctx;
struct duk_lexer_codepoint;

struct duk_compiler_instr;
struct duk_compiler_func;
struct duk_compiler_ctx;

struct duk_re_matcher_ctx;
struct duk_re_compiler_ctx;

#if defined(DUK_USE_CPP_EXCEPTIONS)
/* no typedef */
#else
typedef struct duk_jmpbuf duk_jmpbuf;
#endif

/* duk_tval intentionally skipped */
typedef struct duk_heaphdr duk_heaphdr;
typedef struct duk_heaphdr_string duk_heaphdr_string;
typedef struct duk_hstring duk_hstring;
typedef struct duk_hstring_external duk_hstring_external;
typedef struct duk_hobject duk_hobject;
typedef struct duk_hcompiledfunction duk_hcompiledfunction;
typedef struct duk_hnativefunction duk_hnativefunction;
typedef struct duk_hbufferobject duk_hbufferobject;
typedef struct duk_hthread duk_hthread;
typedef struct duk_hbuffer duk_hbuffer;
typedef struct duk_hbuffer_fixed duk_hbuffer_fixed;
typedef struct duk_hbuffer_dynamic duk_hbuffer_dynamic;
typedef struct duk_hbuffer_external duk_hbuffer_external;

typedef struct duk_propaccessor duk_propaccessor;
typedef union duk_propvalue duk_propvalue;
typedef struct duk_propdesc duk_propdesc;

typedef struct duk_heap duk_heap;
typedef struct duk_breakpoint duk_breakpoint;

typedef struct duk_activation duk_activation;
typedef struct duk_catcher duk_catcher;
typedef struct duk_strcache duk_strcache;
typedef struct duk_ljstate duk_ljstate;
typedef struct duk_strtab_entry duk_strtab_entry;

#ifdef DUK_USE_DEBUG
typedef struct duk_fixedbuffer duk_fixedbuffer;
#endif

typedef struct duk_bitdecoder_ctx duk_bitdecoder_ctx;
typedef struct duk_bitencoder_ctx duk_bitencoder_ctx;
typedef struct duk_bufwriter_ctx duk_bufwriter_ctx;

typedef struct duk_token duk_token;
typedef struct duk_re_token duk_re_token;
typedef struct duk_lexer_point duk_lexer_point;
typedef struct duk_lexer_ctx duk_lexer_ctx;
typedef struct duk_lexer_codepoint duk_lexer_codepoint;

typedef struct duk_compiler_instr duk_compiler_instr;
typedef struct duk_compiler_func duk_compiler_func;
typedef struct duk_compiler_ctx duk_compiler_ctx;

typedef struct duk_re_matcher_ctx duk_re_matcher_ctx;
typedef struct duk_re_compiler_ctx duk_re_compiler_ctx;

#endif  /* DUK_FORWDECL_H_INCLUDED */
#line 1 "duk_builtins.h"
/*
 *  Automatically generated by genbuiltins.py, do not edit!
 */

#ifndef DUK_BUILTINS_H_INCLUDED
#define DUK_BUILTINS_H_INCLUDED

#if defined(DUK_USE_DOUBLE_LE)
#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const duk_uint8_t duk_strings_data[2624];
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STRDATA_DATA_LENGTH                                       2624
#define DUK_STRDATA_MAX_STRLEN                                        24

#define DUK_STRIDX_UC_LOGGER                                          0                              /* 'Logger' */
#define DUK_STRIDX_UC_THREAD                                          1                              /* 'Thread' */
#define DUK_STRIDX_UC_POINTER                                         2                              /* 'Pointer' */
#define DUK_STRIDX_DEC_ENV                                            3                              /* 'DecEnv' */
#define DUK_STRIDX_OBJ_ENV                                            4                              /* 'ObjEnv' */
#define DUK_STRIDX_FLOAT64_ARRAY                                      5                              /* 'Float64Array' */
#define DUK_STRIDX_FLOAT32_ARRAY                                      6                              /* 'Float32Array' */
#define DUK_STRIDX_UINT32_ARRAY                                       7                              /* 'Uint32Array' */
#define DUK_STRIDX_INT32_ARRAY                                        8                              /* 'Int32Array' */
#define DUK_STRIDX_UINT16_ARRAY                                       9                              /* 'Uint16Array' */
#define DUK_STRIDX_INT16_ARRAY                                        10                             /* 'Int16Array' */
#define DUK_STRIDX_UINT8_CLAMPED_ARRAY                                11                             /* 'Uint8ClampedArray' */
#define DUK_STRIDX_UINT8_ARRAY                                        12                             /* 'Uint8Array' */
#define DUK_STRIDX_INT8_ARRAY                                         13                             /* 'Int8Array' */
#define DUK_STRIDX_DATA_VIEW                                          14                             /* 'DataView' */
#define DUK_STRIDX_ARRAY_BUFFER                                       15                             /* 'ArrayBuffer' */
#define DUK_STRIDX_UC_BUFFER                                          16                             /* 'Buffer' */
#define DUK_STRIDX_EMPTY_STRING                                       17                             /* '' */
#define DUK_STRIDX_GLOBAL                                             18                             /* 'global' */
#define DUK_STRIDX_UC_ARGUMENTS                                       19                             /* 'Arguments' */
#define DUK_STRIDX_JSON                                               20                             /* 'JSON' */
#define DUK_STRIDX_MATH                                               21                             /* 'Math' */
#define DUK_STRIDX_UC_ERROR                                           22                             /* 'Error' */
#define DUK_STRIDX_REG_EXP                                            23                             /* 'RegExp' */
#define DUK_STRIDX_DATE                                               24                             /* 'Date' */
#define DUK_STRIDX_UC_NUMBER                                          25                             /* 'Number' */
#define DUK_STRIDX_UC_BOOLEAN                                         26                             /* 'Boolean' */
#define DUK_STRIDX_UC_STRING                                          27                             /* 'String' */
#define DUK_STRIDX_ARRAY                                              28                             /* 'Array' */
#define DUK_STRIDX_UC_FUNCTION                                        29                             /* 'Function' */
#define DUK_STRIDX_UC_OBJECT                                          30                             /* 'Object' */
#define DUK_STRIDX_UC_NULL                                            31                             /* 'Null' */
#define DUK_STRIDX_UC_UNDEFINED                                       32                             /* 'Undefined' */
#define DUK_STRIDX_JSON_EXT_FUNCTION2                                 33                             /* '{_func:true}' */
#define DUK_STRIDX_JSON_EXT_FUNCTION1                                 34                             /* '{"_func":true}' */
#define DUK_STRIDX_JSON_EXT_NEGINF                                    35                             /* '{"_ninf":true}' */
#define DUK_STRIDX_JSON_EXT_POSINF                                    36                             /* '{"_inf":true}' */
#define DUK_STRIDX_JSON_EXT_NAN                                       37                             /* '{"_nan":true}' */
#define DUK_STRIDX_JSON_EXT_UNDEFINED                                 38                             /* '{"_undef":true}' */
#define DUK_STRIDX_TO_LOG_STRING                                      39                             /* 'toLogString' */
#define DUK_STRIDX_CLOG                                               40                             /* 'clog' */
#define DUK_STRIDX_LC_L                                               41                             /* 'l' */
#define DUK_STRIDX_LC_N                                               42                             /* 'n' */
#define DUK_STRIDX_LC_FATAL                                           43                             /* 'fatal' */
#define DUK_STRIDX_LC_ERROR                                           44                             /* 'error' */
#define DUK_STRIDX_LC_WARN                                            45                             /* 'warn' */
#define DUK_STRIDX_LC_DEBUG                                           46                             /* 'debug' */
#define DUK_STRIDX_LC_TRACE                                           47                             /* 'trace' */
#define DUK_STRIDX_RAW                                                48                             /* 'raw' */
#define DUK_STRIDX_FMT                                                49                             /* 'fmt' */
#define DUK_STRIDX_CURRENT                                            50                             /* 'current' */
#define DUK_STRIDX_RESUME                                             51                             /* 'resume' */
#define DUK_STRIDX_COMPACT                                            52                             /* 'compact' */
#define DUK_STRIDX_JC                                                 53                             /* 'jc' */
#define DUK_STRIDX_JX                                                 54                             /* 'jx' */
#define DUK_STRIDX_BASE64                                             55                             /* 'base64' */
#define DUK_STRIDX_HEX                                                56                             /* 'hex' */
#define DUK_STRIDX_DEC                                                57                             /* 'dec' */
#define DUK_STRIDX_ENC                                                58                             /* 'enc' */
#define DUK_STRIDX_FIN                                                59                             /* 'fin' */
#define DUK_STRIDX_GC                                                 60                             /* 'gc' */
#define DUK_STRIDX_ACT                                                61                             /* 'act' */
#define DUK_STRIDX_LC_INFO                                            62                             /* 'info' */
#define DUK_STRIDX_VERSION                                            63                             /* 'version' */
#define DUK_STRIDX_ENV                                                64                             /* 'env' */
#define DUK_STRIDX_MOD_LOADED                                         65                             /* 'modLoaded' */
#define DUK_STRIDX_MOD_SEARCH                                         66                             /* 'modSearch' */
#define DUK_STRIDX_ERR_THROW                                          67                             /* 'errThrow' */
#define DUK_STRIDX_ERR_CREATE                                         68                             /* 'errCreate' */
#define DUK_STRIDX_COMPILE                                            69                             /* 'compile' */
#define DUK_STRIDX_INT_REGBASE                                        70                             /* '\x00Regbase' */
#define DUK_STRIDX_INT_THREAD                                         71                             /* '\x00Thread' */
#define DUK_STRIDX_INT_HANDLER                                        72                             /* '\x00Handler' */
#define DUK_STRIDX_INT_FINALIZER                                      73                             /* '\x00Finalizer' */
#define DUK_STRIDX_INT_CALLEE                                         74                             /* '\x00Callee' */
#define DUK_STRIDX_INT_MAP                                            75                             /* '\x00Map' */
#define DUK_STRIDX_INT_ARGS                                           76                             /* '\x00Args' */
#define DUK_STRIDX_INT_THIS                                           77                             /* '\x00This' */
#define DUK_STRIDX_INT_PC2LINE                                        78                             /* '\x00Pc2line' */
#define DUK_STRIDX_INT_SOURCE                                         79                             /* '\x00Source' */
#define DUK_STRIDX_INT_VARENV                                         80                             /* '\x00Varenv' */
#define DUK_STRIDX_INT_LEXENV                                         81                             /* '\x00Lexenv' */
#define DUK_STRIDX_INT_VARMAP                                         82                             /* '\x00Varmap' */
#define DUK_STRIDX_INT_FORMALS                                        83                             /* '\x00Formals' */
#define DUK_STRIDX_INT_BYTECODE                                       84                             /* '\x00Bytecode' */
#define DUK_STRIDX_INT_NEXT                                           85                             /* '\x00Next' */
#define DUK_STRIDX_INT_TARGET                                         86                             /* '\x00Target' */
#define DUK_STRIDX_INT_VALUE                                          87                             /* '\x00Value' */
#define DUK_STRIDX_LC_POINTER                                         88                             /* 'pointer' */
#define DUK_STRIDX_INT_TRACEDATA                                      89                             /* '\x00Tracedata' */
#define DUK_STRIDX_LINE_NUMBER                                        90                             /* 'lineNumber' */
#define DUK_STRIDX_FILE_NAME                                          91                             /* 'fileName' */
#define DUK_STRIDX_PC                                                 92                             /* 'pc' */
#define DUK_STRIDX_STACK                                              93                             /* 'stack' */
#define DUK_STRIDX_THROW_TYPE_ERROR                                   94                             /* 'ThrowTypeError' */
#define DUK_STRIDX_DUKTAPE                                            95                             /* 'Duktape' */
#define DUK_STRIDX_SET_FLOAT64                                        96                             /* 'setFloat64' */
#define DUK_STRIDX_SET_FLOAT32                                        97                             /* 'setFloat32' */
#define DUK_STRIDX_SET_UINT32                                         98                             /* 'setUint32' */
#define DUK_STRIDX_SET_INT32                                          99                             /* 'setInt32' */
#define DUK_STRIDX_SET_UINT16                                         100                            /* 'setUint16' */
#define DUK_STRIDX_SET_INT16                                          101                            /* 'setInt16' */
#define DUK_STRIDX_SET_UINT8                                          102                            /* 'setUint8' */
#define DUK_STRIDX_SET_INT8                                           103                            /* 'setInt8' */
#define DUK_STRIDX_GET_FLOAT64                                        104                            /* 'getFloat64' */
#define DUK_STRIDX_GET_FLOAT32                                        105                            /* 'getFloat32' */
#define DUK_STRIDX_GET_UINT32                                         106                            /* 'getUint32' */
#define DUK_STRIDX_GET_INT32                                          107                            /* 'getInt32' */
#define DUK_STRIDX_GET_UINT16                                         108                            /* 'getUint16' */
#define DUK_STRIDX_GET_INT16                                          109                            /* 'getInt16' */
#define DUK_STRIDX_GET_UINT8                                          110                            /* 'getUint8' */
#define DUK_STRIDX_GET_INT8                                           111                            /* 'getInt8' */
#define DUK_STRIDX_SUBARRAY                                           112                            /* 'subarray' */
#define DUK_STRIDX_BYTES_PER_ELEMENT                                  113                            /* 'BYTES_PER_ELEMENT' */
#define DUK_STRIDX_BYTE_OFFSET                                        114                            /* 'byteOffset' */
#define DUK_STRIDX_LC_BUFFER                                          115                            /* 'buffer' */
#define DUK_STRIDX_IS_VIEW                                            116                            /* 'isView' */
#define DUK_STRIDX_DATA                                               117                            /* 'data' */
#define DUK_STRIDX_TYPE                                               118                            /* 'type' */
#define DUK_STRIDX_WRITE_INT_BE                                       119                            /* 'writeIntBE' */
#define DUK_STRIDX_WRITE_INT_LE                                       120                            /* 'writeIntLE' */
#define DUK_STRIDX_WRITE_UINT_BE                                      121                            /* 'writeUIntBE' */
#define DUK_STRIDX_WRITE_UINT_LE                                      122                            /* 'writeUIntLE' */
#define DUK_STRIDX_WRITE_DOUBLE_BE                                    123                            /* 'writeDoubleBE' */
#define DUK_STRIDX_WRITE_DOUBLE_LE                                    124                            /* 'writeDoubleLE' */
#define DUK_STRIDX_WRITE_FLOAT_BE                                     125                            /* 'writeFloatBE' */
#define DUK_STRIDX_WRITE_FLOAT_LE                                     126                            /* 'writeFloatLE' */
#define DUK_STRIDX_WRITE_INT32_BE                                     127                            /* 'writeInt32BE' */
#define DUK_STRIDX_WRITE_INT32_LE                                     128                            /* 'writeInt32LE' */
#define DUK_STRIDX_WRITE_UINT32_BE                                    129                            /* 'writeUInt32BE' */
#define DUK_STRIDX_WRITE_UINT32_LE                                    130                            /* 'writeUInt32LE' */
#define DUK_STRIDX_WRITE_INT16_BE                                     131                            /* 'writeInt16BE' */
#define DUK_STRIDX_WRITE_INT16_LE                                     132                            /* 'writeInt16LE' */
#define DUK_STRIDX_WRITE_UINT16_BE                                    133                            /* 'writeUInt16BE' */
#define DUK_STRIDX_WRITE_UINT16_LE                                    134                            /* 'writeUInt16LE' */
#define DUK_STRIDX_WRITE_INT8                                         135                            /* 'writeInt8' */
#define DUK_STRIDX_WRITE_UINT8                                        136                            /* 'writeUInt8' */
#define DUK_STRIDX_READ_INT_BE                                        137                            /* 'readIntBE' */
#define DUK_STRIDX_READ_INT_LE                                        138                            /* 'readIntLE' */
#define DUK_STRIDX_READ_UINT_BE                                       139                            /* 'readUIntBE' */
#define DUK_STRIDX_READ_UINT_LE                                       140                            /* 'readUIntLE' */
#define DUK_STRIDX_READ_DOUBLE_BE                                     141                            /* 'readDoubleBE' */
#define DUK_STRIDX_READ_DOUBLE_LE                                     142                            /* 'readDoubleLE' */
#define DUK_STRIDX_READ_FLOAT_BE                                      143                            /* 'readFloatBE' */
#define DUK_STRIDX_READ_FLOAT_LE                                      144                            /* 'readFloatLE' */
#define DUK_STRIDX_READ_INT32_BE                                      145                            /* 'readInt32BE' */
#define DUK_STRIDX_READ_INT32_LE                                      146                            /* 'readInt32LE' */
#define DUK_STRIDX_READ_UINT32_BE                                     147                            /* 'readUInt32BE' */
#define DUK_STRIDX_READ_UINT32_LE                                     148                            /* 'readUInt32LE' */
#define DUK_STRIDX_READ_INT16_BE                                      149                            /* 'readInt16BE' */
#define DUK_STRIDX_READ_INT16_LE                                      150                            /* 'readInt16LE' */
#define DUK_STRIDX_READ_UINT16_BE                                     151                            /* 'readUInt16BE' */
#define DUK_STRIDX_READ_UINT16_LE                                     152                            /* 'readUInt16LE' */
#define DUK_STRIDX_READ_INT8                                          153                            /* 'readInt8' */
#define DUK_STRIDX_READ_UINT8                                         154                            /* 'readUInt8' */
#define DUK_STRIDX_COPY                                               155                            /* 'copy' */
#define DUK_STRIDX_EQUALS                                             156                            /* 'equals' */
#define DUK_STRIDX_FILL                                               157                            /* 'fill' */
#define DUK_STRIDX_WRITE                                              158                            /* 'write' */
#define DUK_STRIDX_COMPARE                                            159                            /* 'compare' */
#define DUK_STRIDX_BYTE_LENGTH                                        160                            /* 'byteLength' */
#define DUK_STRIDX_IS_BUFFER                                          161                            /* 'isBuffer' */
#define DUK_STRIDX_IS_ENCODING                                        162                            /* 'isEncoding' */
#define DUK_STRIDX_EXPORTS                                            163                            /* 'exports' */
#define DUK_STRIDX_ID                                                 164                            /* 'id' */
#define DUK_STRIDX_REQUIRE                                            165                            /* 'require' */
#define DUK_STRIDX___PROTO__                                          166                            /* '__proto__' */
#define DUK_STRIDX_SET_PROTOTYPE_OF                                   167                            /* 'setPrototypeOf' */
#define DUK_STRIDX_OWN_KEYS                                           168                            /* 'ownKeys' */
#define DUK_STRIDX_ENUMERATE                                          169                            /* 'enumerate' */
#define DUK_STRIDX_DELETE_PROPERTY                                    170                            /* 'deleteProperty' */
#define DUK_STRIDX_HAS                                                171                            /* 'has' */
#define DUK_STRIDX_PROXY                                              172                            /* 'Proxy' */
#define DUK_STRIDX_CALLEE                                             173                            /* 'callee' */
#define DUK_STRIDX_INVALID_DATE                                       174                            /* 'Invalid Date' */
#define DUK_STRIDX_BRACKETED_ELLIPSIS                                 175                            /* '[...]' */
#define DUK_STRIDX_NEWLINE_TAB                                        176                            /* '\n\t' */
#define DUK_STRIDX_SPACE                                              177                            /* ' ' */
#define DUK_STRIDX_COMMA                                              178                            /* ',' */
#define DUK_STRIDX_MINUS_ZERO                                         179                            /* '-0' */
#define DUK_STRIDX_PLUS_ZERO                                          180                            /* '+0' */
#define DUK_STRIDX_ZERO                                               181                            /* '0' */
#define DUK_STRIDX_MINUS_INFINITY                                     182                            /* '-Infinity' */
#define DUK_STRIDX_PLUS_INFINITY                                      183                            /* '+Infinity' */
#define DUK_STRIDX_INFINITY                                           184                            /* 'Infinity' */
#define DUK_STRIDX_LC_OBJECT                                          185                            /* 'object' */
#define DUK_STRIDX_LC_STRING                                          186                            /* 'string' */
#define DUK_STRIDX_LC_NUMBER                                          187                            /* 'number' */
#define DUK_STRIDX_LC_BOOLEAN                                         188                            /* 'boolean' */
#define DUK_STRIDX_LC_UNDEFINED                                       189                            /* 'undefined' */
#define DUK_STRIDX_STRINGIFY                                          190                            /* 'stringify' */
#define DUK_STRIDX_TAN                                                191                            /* 'tan' */
#define DUK_STRIDX_SQRT                                               192                            /* 'sqrt' */
#define DUK_STRIDX_SIN                                                193                            /* 'sin' */
#define DUK_STRIDX_ROUND                                              194                            /* 'round' */
#define DUK_STRIDX_RANDOM                                             195                            /* 'random' */
#define DUK_STRIDX_POW                                                196                            /* 'pow' */
#define DUK_STRIDX_MIN                                                197                            /* 'min' */
#define DUK_STRIDX_MAX                                                198                            /* 'max' */
#define DUK_STRIDX_LOG                                                199                            /* 'log' */
#define DUK_STRIDX_FLOOR                                              200                            /* 'floor' */
#define DUK_STRIDX_EXP                                                201                            /* 'exp' */
#define DUK_STRIDX_COS                                                202                            /* 'cos' */
#define DUK_STRIDX_CEIL                                               203                            /* 'ceil' */
#define DUK_STRIDX_ATAN2                                              204                            /* 'atan2' */
#define DUK_STRIDX_ATAN                                               205                            /* 'atan' */
#define DUK_STRIDX_ASIN                                               206                            /* 'asin' */
#define DUK_STRIDX_ACOS                                               207                            /* 'acos' */
#define DUK_STRIDX_ABS                                                208                            /* 'abs' */
#define DUK_STRIDX_SQRT2                                              209                            /* 'SQRT2' */
#define DUK_STRIDX_SQRT1_2                                            210                            /* 'SQRT1_2' */
#define DUK_STRIDX_PI                                                 211                            /* 'PI' */
#define DUK_STRIDX_LOG10E                                             212                            /* 'LOG10E' */
#define DUK_STRIDX_LOG2E                                              213                            /* 'LOG2E' */
#define DUK_STRIDX_LN2                                                214                            /* 'LN2' */
#define DUK_STRIDX_LN10                                               215                            /* 'LN10' */
#define DUK_STRIDX_E                                                  216                            /* 'E' */
#define DUK_STRIDX_MESSAGE                                            217                            /* 'message' */
#define DUK_STRIDX_NAME                                               218                            /* 'name' */
#define DUK_STRIDX_INPUT                                              219                            /* 'input' */
#define DUK_STRIDX_INDEX                                              220                            /* 'index' */
#define DUK_STRIDX_ESCAPED_EMPTY_REGEXP                               221                            /* '(?:)' */
#define DUK_STRIDX_LAST_INDEX                                         222                            /* 'lastIndex' */
#define DUK_STRIDX_MULTILINE                                          223                            /* 'multiline' */
#define DUK_STRIDX_IGNORE_CASE                                        224                            /* 'ignoreCase' */
#define DUK_STRIDX_SOURCE                                             225                            /* 'source' */
#define DUK_STRIDX_TEST                                               226                            /* 'test' */
#define DUK_STRIDX_EXEC                                               227                            /* 'exec' */
#define DUK_STRIDX_TO_GMT_STRING                                      228                            /* 'toGMTString' */
#define DUK_STRIDX_SET_YEAR                                           229                            /* 'setYear' */
#define DUK_STRIDX_GET_YEAR                                           230                            /* 'getYear' */
#define DUK_STRIDX_TO_JSON                                            231                            /* 'toJSON' */
#define DUK_STRIDX_TO_ISO_STRING                                      232                            /* 'toISOString' */
#define DUK_STRIDX_TO_UTC_STRING                                      233                            /* 'toUTCString' */
#define DUK_STRIDX_SET_UTC_FULL_YEAR                                  234                            /* 'setUTCFullYear' */
#define DUK_STRIDX_SET_FULL_YEAR                                      235                            /* 'setFullYear' */
#define DUK_STRIDX_SET_UTC_MONTH                                      236                            /* 'setUTCMonth' */
#define DUK_STRIDX_SET_MONTH                                          237                            /* 'setMonth' */
#define DUK_STRIDX_SET_UTC_DATE                                       238                            /* 'setUTCDate' */
#define DUK_STRIDX_SET_DATE                                           239                            /* 'setDate' */
#define DUK_STRIDX_SET_UTC_HOURS                                      240                            /* 'setUTCHours' */
#define DUK_STRIDX_SET_HOURS                                          241                            /* 'setHours' */
#define DUK_STRIDX_SET_UTC_MINUTES                                    242                            /* 'setUTCMinutes' */
#define DUK_STRIDX_SET_MINUTES                                        243                            /* 'setMinutes' */
#define DUK_STRIDX_SET_UTC_SECONDS                                    244                            /* 'setUTCSeconds' */
#define DUK_STRIDX_SET_SECONDS                                        245                            /* 'setSeconds' */
#define DUK_STRIDX_SET_UTC_MILLISECONDS                               246                            /* 'setUTCMilliseconds' */
#define DUK_STRIDX_SET_MILLISECONDS                                   247                            /* 'setMilliseconds' */
#define DUK_STRIDX_SET_TIME                                           248                            /* 'setTime' */
#define DUK_STRIDX_GET_TIMEZONE_OFFSET                                249                            /* 'getTimezoneOffset' */
#define DUK_STRIDX_GET_UTC_MILLISECONDS                               250                            /* 'getUTCMilliseconds' */
#define DUK_STRIDX_GET_MILLISECONDS                                   251                            /* 'getMilliseconds' */
#define DUK_STRIDX_GET_UTC_SECONDS                                    252                            /* 'getUTCSeconds' */
#define DUK_STRIDX_GET_SECONDS                                        253                            /* 'getSeconds' */
#define DUK_STRIDX_GET_UTC_MINUTES                                    254                            /* 'getUTCMinutes' */
#define DUK_STRIDX_GET_MINUTES                                        255                            /* 'getMinutes' */
#define DUK_STRIDX_GET_UTC_HOURS                                      256                            /* 'getUTCHours' */
#define DUK_STRIDX_GET_HOURS                                          257                            /* 'getHours' */
#define DUK_STRIDX_GET_UTC_DAY                                        258                            /* 'getUTCDay' */
#define DUK_STRIDX_GET_DAY                                            259                            /* 'getDay' */
#define DUK_STRIDX_GET_UTC_DATE                                       260                            /* 'getUTCDate' */
#define DUK_STRIDX_GET_DATE                                           261                            /* 'getDate' */
#define DUK_STRIDX_GET_UTC_MONTH                                      262                            /* 'getUTCMonth' */
#define DUK_STRIDX_GET_MONTH                                          263                            /* 'getMonth' */
#define DUK_STRIDX_GET_UTC_FULL_YEAR                                  264                            /* 'getUTCFullYear' */
#define DUK_STRIDX_GET_FULL_YEAR                                      265                            /* 'getFullYear' */
#define DUK_STRIDX_GET_TIME                                           266                            /* 'getTime' */
#define DUK_STRIDX_TO_LOCALE_TIME_STRING                              267                            /* 'toLocaleTimeString' */
#define DUK_STRIDX_TO_LOCALE_DATE_STRING                              268                            /* 'toLocaleDateString' */
#define DUK_STRIDX_TO_TIME_STRING                                     269                            /* 'toTimeString' */
#define DUK_STRIDX_TO_DATE_STRING                                     270                            /* 'toDateString' */
#define DUK_STRIDX_NOW                                                271                            /* 'now' */
#define DUK_STRIDX_UTC                                                272                            /* 'UTC' */
#define DUK_STRIDX_PARSE                                              273                            /* 'parse' */
#define DUK_STRIDX_TO_PRECISION                                       274                            /* 'toPrecision' */
#define DUK_STRIDX_TO_EXPONENTIAL                                     275                            /* 'toExponential' */
#define DUK_STRIDX_TO_FIXED                                           276                            /* 'toFixed' */
#define DUK_STRIDX_POSITIVE_INFINITY                                  277                            /* 'POSITIVE_INFINITY' */
#define DUK_STRIDX_NEGATIVE_INFINITY                                  278                            /* 'NEGATIVE_INFINITY' */
#define DUK_STRIDX_NAN                                                279                            /* 'NaN' */
#define DUK_STRIDX_MIN_VALUE                                          280                            /* 'MIN_VALUE' */
#define DUK_STRIDX_MAX_VALUE                                          281                            /* 'MAX_VALUE' */
#define DUK_STRIDX_SUBSTR                                             282                            /* 'substr' */
#define DUK_STRIDX_TRIM                                               283                            /* 'trim' */
#define DUK_STRIDX_TO_LOCALE_UPPER_CASE                               284                            /* 'toLocaleUpperCase' */
#define DUK_STRIDX_TO_UPPER_CASE                                      285                            /* 'toUpperCase' */
#define DUK_STRIDX_TO_LOCALE_LOWER_CASE                               286                            /* 'toLocaleLowerCase' */
#define DUK_STRIDX_TO_LOWER_CASE                                      287                            /* 'toLowerCase' */
#define DUK_STRIDX_SUBSTRING                                          288                            /* 'substring' */
#define DUK_STRIDX_SPLIT                                              289                            /* 'split' */
#define DUK_STRIDX_SEARCH                                             290                            /* 'search' */
#define DUK_STRIDX_REPLACE                                            291                            /* 'replace' */
#define DUK_STRIDX_MATCH                                              292                            /* 'match' */
#define DUK_STRIDX_LOCALE_COMPARE                                     293                            /* 'localeCompare' */
#define DUK_STRIDX_CHAR_CODE_AT                                       294                            /* 'charCodeAt' */
#define DUK_STRIDX_CHAR_AT                                            295                            /* 'charAt' */
#define DUK_STRIDX_FROM_CHAR_CODE                                     296                            /* 'fromCharCode' */
#define DUK_STRIDX_REDUCE_RIGHT                                       297                            /* 'reduceRight' */
#define DUK_STRIDX_REDUCE                                             298                            /* 'reduce' */
#define DUK_STRIDX_FILTER                                             299                            /* 'filter' */
#define DUK_STRIDX_MAP                                                300                            /* 'map' */
#define DUK_STRIDX_FOR_EACH                                           301                            /* 'forEach' */
#define DUK_STRIDX_SOME                                               302                            /* 'some' */
#define DUK_STRIDX_EVERY                                              303                            /* 'every' */
#define DUK_STRIDX_LAST_INDEX_OF                                      304                            /* 'lastIndexOf' */
#define DUK_STRIDX_INDEX_OF                                           305                            /* 'indexOf' */
#define DUK_STRIDX_UNSHIFT                                            306                            /* 'unshift' */
#define DUK_STRIDX_SPLICE                                             307                            /* 'splice' */
#define DUK_STRIDX_SORT                                               308                            /* 'sort' */
#define DUK_STRIDX_SLICE                                              309                            /* 'slice' */
#define DUK_STRIDX_SHIFT                                              310                            /* 'shift' */
#define DUK_STRIDX_REVERSE                                            311                            /* 'reverse' */
#define DUK_STRIDX_PUSH                                               312                            /* 'push' */
#define DUK_STRIDX_POP                                                313                            /* 'pop' */
#define DUK_STRIDX_JOIN                                               314                            /* 'join' */
#define DUK_STRIDX_CONCAT                                             315                            /* 'concat' */
#define DUK_STRIDX_IS_ARRAY                                           316                            /* 'isArray' */
#define DUK_STRIDX_LC_ARGUMENTS                                       317                            /* 'arguments' */
#define DUK_STRIDX_CALLER                                             318                            /* 'caller' */
#define DUK_STRIDX_BIND                                               319                            /* 'bind' */
#define DUK_STRIDX_CALL                                               320                            /* 'call' */
#define DUK_STRIDX_APPLY                                              321                            /* 'apply' */
#define DUK_STRIDX_PROPERTY_IS_ENUMERABLE                             322                            /* 'propertyIsEnumerable' */
#define DUK_STRIDX_IS_PROTOTYPE_OF                                    323                            /* 'isPrototypeOf' */
#define DUK_STRIDX_HAS_OWN_PROPERTY                                   324                            /* 'hasOwnProperty' */
#define DUK_STRIDX_VALUE_OF                                           325                            /* 'valueOf' */
#define DUK_STRIDX_TO_LOCALE_STRING                                   326                            /* 'toLocaleString' */
#define DUK_STRIDX_TO_STRING                                          327                            /* 'toString' */
#define DUK_STRIDX_CONSTRUCTOR                                        328                            /* 'constructor' */
#define DUK_STRIDX_SET                                                329                            /* 'set' */
#define DUK_STRIDX_GET                                                330                            /* 'get' */
#define DUK_STRIDX_ENUMERABLE                                         331                            /* 'enumerable' */
#define DUK_STRIDX_CONFIGURABLE                                       332                            /* 'configurable' */
#define DUK_STRIDX_WRITABLE                                           333                            /* 'writable' */
#define DUK_STRIDX_VALUE                                              334                            /* 'value' */
#define DUK_STRIDX_KEYS                                               335                            /* 'keys' */
#define DUK_STRIDX_IS_EXTENSIBLE                                      336                            /* 'isExtensible' */
#define DUK_STRIDX_IS_FROZEN                                          337                            /* 'isFrozen' */
#define DUK_STRIDX_IS_SEALED                                          338                            /* 'isSealed' */
#define DUK_STRIDX_PREVENT_EXTENSIONS                                 339                            /* 'preventExtensions' */
#define DUK_STRIDX_FREEZE                                             340                            /* 'freeze' */
#define DUK_STRIDX_SEAL                                               341                            /* 'seal' */
#define DUK_STRIDX_DEFINE_PROPERTIES                                  342                            /* 'defineProperties' */
#define DUK_STRIDX_DEFINE_PROPERTY                                    343                            /* 'defineProperty' */
#define DUK_STRIDX_CREATE                                             344                            /* 'create' */
#define DUK_STRIDX_GET_OWN_PROPERTY_NAMES                             345                            /* 'getOwnPropertyNames' */
#define DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR                        346                            /* 'getOwnPropertyDescriptor' */
#define DUK_STRIDX_GET_PROTOTYPE_OF                                   347                            /* 'getPrototypeOf' */
#define DUK_STRIDX_PROTOTYPE                                          348                            /* 'prototype' */
#define DUK_STRIDX_LENGTH                                             349                            /* 'length' */
#define DUK_STRIDX_ALERT                                              350                            /* 'alert' */
#define DUK_STRIDX_PRINT                                              351                            /* 'print' */
#define DUK_STRIDX_UNESCAPE                                           352                            /* 'unescape' */
#define DUK_STRIDX_ESCAPE                                             353                            /* 'escape' */
#define DUK_STRIDX_ENCODE_URI_COMPONENT                               354                            /* 'encodeURIComponent' */
#define DUK_STRIDX_ENCODE_URI                                         355                            /* 'encodeURI' */
#define DUK_STRIDX_DECODE_URI_COMPONENT                               356                            /* 'decodeURIComponent' */
#define DUK_STRIDX_DECODE_URI                                         357                            /* 'decodeURI' */
#define DUK_STRIDX_IS_FINITE                                          358                            /* 'isFinite' */
#define DUK_STRIDX_IS_NAN                                             359                            /* 'isNaN' */
#define DUK_STRIDX_PARSE_FLOAT                                        360                            /* 'parseFloat' */
#define DUK_STRIDX_PARSE_INT                                          361                            /* 'parseInt' */
#define DUK_STRIDX_EVAL                                               362                            /* 'eval' */
#define DUK_STRIDX_URI_ERROR                                          363                            /* 'URIError' */
#define DUK_STRIDX_TYPE_ERROR                                         364                            /* 'TypeError' */
#define DUK_STRIDX_SYNTAX_ERROR                                       365                            /* 'SyntaxError' */
#define DUK_STRIDX_REFERENCE_ERROR                                    366                            /* 'ReferenceError' */
#define DUK_STRIDX_RANGE_ERROR                                        367                            /* 'RangeError' */
#define DUK_STRIDX_EVAL_ERROR                                         368                            /* 'EvalError' */
#define DUK_STRIDX_BREAK                                              369                            /* 'break' */
#define DUK_STRIDX_CASE                                               370                            /* 'case' */
#define DUK_STRIDX_CATCH                                              371                            /* 'catch' */
#define DUK_STRIDX_CONTINUE                                           372                            /* 'continue' */
#define DUK_STRIDX_DEBUGGER                                           373                            /* 'debugger' */
#define DUK_STRIDX_DEFAULT                                            374                            /* 'default' */
#define DUK_STRIDX_DELETE                                             375                            /* 'delete' */
#define DUK_STRIDX_DO                                                 376                            /* 'do' */
#define DUK_STRIDX_ELSE                                               377                            /* 'else' */
#define DUK_STRIDX_FINALLY                                            378                            /* 'finally' */
#define DUK_STRIDX_FOR                                                379                            /* 'for' */
#define DUK_STRIDX_LC_FUNCTION                                        380                            /* 'function' */
#define DUK_STRIDX_IF                                                 381                            /* 'if' */
#define DUK_STRIDX_IN                                                 382                            /* 'in' */
#define DUK_STRIDX_INSTANCEOF                                         383                            /* 'instanceof' */
#define DUK_STRIDX_NEW                                                384                            /* 'new' */
#define DUK_STRIDX_RETURN                                             385                            /* 'return' */
#define DUK_STRIDX_SWITCH                                             386                            /* 'switch' */
#define DUK_STRIDX_THIS                                               387                            /* 'this' */
#define DUK_STRIDX_THROW                                              388                            /* 'throw' */
#define DUK_STRIDX_TRY                                                389                            /* 'try' */
#define DUK_STRIDX_TYPEOF                                             390                            /* 'typeof' */
#define DUK_STRIDX_VAR                                                391                            /* 'var' */
#define DUK_STRIDX_CONST                                              392                            /* 'const' */
#define DUK_STRIDX_VOID                                               393                            /* 'void' */
#define DUK_STRIDX_WHILE                                              394                            /* 'while' */
#define DUK_STRIDX_WITH                                               395                            /* 'with' */
#define DUK_STRIDX_CLASS                                              396                            /* 'class' */
#define DUK_STRIDX_ENUM                                               397                            /* 'enum' */
#define DUK_STRIDX_EXPORT                                             398                            /* 'export' */
#define DUK_STRIDX_EXTENDS                                            399                            /* 'extends' */
#define DUK_STRIDX_IMPORT                                             400                            /* 'import' */
#define DUK_STRIDX_SUPER                                              401                            /* 'super' */
#define DUK_STRIDX_LC_NULL                                            402                            /* 'null' */
#define DUK_STRIDX_TRUE                                               403                            /* 'true' */
#define DUK_STRIDX_FALSE                                              404                            /* 'false' */
#define DUK_STRIDX_IMPLEMENTS                                         405                            /* 'implements' */
#define DUK_STRIDX_INTERFACE                                          406                            /* 'interface' */
#define DUK_STRIDX_LET                                                407                            /* 'let' */
#define DUK_STRIDX_PACKAGE                                            408                            /* 'package' */
#define DUK_STRIDX_PRIVATE                                            409                            /* 'private' */
#define DUK_STRIDX_PROTECTED                                          410                            /* 'protected' */
#define DUK_STRIDX_PUBLIC                                             411                            /* 'public' */
#define DUK_STRIDX_STATIC                                             412                            /* 'static' */
#define DUK_STRIDX_YIELD                                              413                            /* 'yield' */

#define DUK_HEAP_STRING_UC_LOGGER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_LOGGER)
#define DUK_HTHREAD_STRING_UC_LOGGER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_LOGGER)
#define DUK_HEAP_STRING_UC_THREAD(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_THREAD)
#define DUK_HTHREAD_STRING_UC_THREAD(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_THREAD)
#define DUK_HEAP_STRING_UC_POINTER(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_POINTER)
#define DUK_HTHREAD_STRING_UC_POINTER(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_POINTER)
#define DUK_HEAP_STRING_DEC_ENV(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEC_ENV)
#define DUK_HTHREAD_STRING_DEC_ENV(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEC_ENV)
#define DUK_HEAP_STRING_OBJ_ENV(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_OBJ_ENV)
#define DUK_HTHREAD_STRING_OBJ_ENV(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_OBJ_ENV)
#define DUK_HEAP_STRING_FLOAT64_ARRAY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOAT64_ARRAY)
#define DUK_HTHREAD_STRING_FLOAT64_ARRAY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOAT64_ARRAY)
#define DUK_HEAP_STRING_FLOAT32_ARRAY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOAT32_ARRAY)
#define DUK_HTHREAD_STRING_FLOAT32_ARRAY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOAT32_ARRAY)
#define DUK_HEAP_STRING_UINT32_ARRAY(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT32_ARRAY)
#define DUK_HTHREAD_STRING_UINT32_ARRAY(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT32_ARRAY)
#define DUK_HEAP_STRING_INT32_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT32_ARRAY)
#define DUK_HTHREAD_STRING_INT32_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT32_ARRAY)
#define DUK_HEAP_STRING_UINT16_ARRAY(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT16_ARRAY)
#define DUK_HTHREAD_STRING_UINT16_ARRAY(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT16_ARRAY)
#define DUK_HEAP_STRING_INT16_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT16_ARRAY)
#define DUK_HTHREAD_STRING_INT16_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT16_ARRAY)
#define DUK_HEAP_STRING_UINT8_CLAMPED_ARRAY(heap)                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT8_CLAMPED_ARRAY)
#define DUK_HTHREAD_STRING_UINT8_CLAMPED_ARRAY(thr)                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT8_CLAMPED_ARRAY)
#define DUK_HEAP_STRING_UINT8_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT8_ARRAY)
#define DUK_HTHREAD_STRING_UINT8_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT8_ARRAY)
#define DUK_HEAP_STRING_INT8_ARRAY(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT8_ARRAY)
#define DUK_HTHREAD_STRING_INT8_ARRAY(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT8_ARRAY)
#define DUK_HEAP_STRING_DATA_VIEW(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATA_VIEW)
#define DUK_HTHREAD_STRING_DATA_VIEW(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATA_VIEW)
#define DUK_HEAP_STRING_ARRAY_BUFFER(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ARRAY_BUFFER)
#define DUK_HTHREAD_STRING_ARRAY_BUFFER(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ARRAY_BUFFER)
#define DUK_HEAP_STRING_UC_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_BUFFER)
#define DUK_HTHREAD_STRING_UC_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_BUFFER)
#define DUK_HEAP_STRING_EMPTY_STRING(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EMPTY_STRING)
#define DUK_HTHREAD_STRING_EMPTY_STRING(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EMPTY_STRING)
#define DUK_HEAP_STRING_GLOBAL(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GLOBAL)
#define DUK_HTHREAD_STRING_GLOBAL(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GLOBAL)
#define DUK_HEAP_STRING_UC_ARGUMENTS(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_ARGUMENTS)
#define DUK_HTHREAD_STRING_UC_ARGUMENTS(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_ARGUMENTS)
#define DUK_HEAP_STRING_JSON(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON)
#define DUK_HTHREAD_STRING_JSON(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON)
#define DUK_HEAP_STRING_MATH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MATH)
#define DUK_HTHREAD_STRING_MATH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MATH)
#define DUK_HEAP_STRING_UC_ERROR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_ERROR)
#define DUK_HTHREAD_STRING_UC_ERROR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_ERROR)
#define DUK_HEAP_STRING_REG_EXP(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REG_EXP)
#define DUK_HTHREAD_STRING_REG_EXP(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REG_EXP)
#define DUK_HEAP_STRING_DATE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATE)
#define DUK_HTHREAD_STRING_DATE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATE)
#define DUK_HEAP_STRING_UC_NUMBER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_NUMBER)
#define DUK_HTHREAD_STRING_UC_NUMBER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_NUMBER)
#define DUK_HEAP_STRING_UC_BOOLEAN(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_BOOLEAN)
#define DUK_HTHREAD_STRING_UC_BOOLEAN(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_BOOLEAN)
#define DUK_HEAP_STRING_UC_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_STRING)
#define DUK_HTHREAD_STRING_UC_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_STRING)
#define DUK_HEAP_STRING_ARRAY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ARRAY)
#define DUK_HTHREAD_STRING_ARRAY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ARRAY)
#define DUK_HEAP_STRING_UC_FUNCTION(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_FUNCTION)
#define DUK_HTHREAD_STRING_UC_FUNCTION(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_FUNCTION)
#define DUK_HEAP_STRING_UC_OBJECT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_OBJECT)
#define DUK_HTHREAD_STRING_UC_OBJECT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_OBJECT)
#define DUK_HEAP_STRING_UC_NULL(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_NULL)
#define DUK_HTHREAD_STRING_UC_NULL(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_NULL)
#define DUK_HEAP_STRING_UC_UNDEFINED(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_UNDEFINED)
#define DUK_HTHREAD_STRING_UC_UNDEFINED(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_UNDEFINED)
#define DUK_HEAP_STRING_JSON_EXT_FUNCTION2(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_FUNCTION2)
#define DUK_HTHREAD_STRING_JSON_EXT_FUNCTION2(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_FUNCTION2)
#define DUK_HEAP_STRING_JSON_EXT_FUNCTION1(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_FUNCTION1)
#define DUK_HTHREAD_STRING_JSON_EXT_FUNCTION1(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_FUNCTION1)
#define DUK_HEAP_STRING_JSON_EXT_NEGINF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_NEGINF)
#define DUK_HTHREAD_STRING_JSON_EXT_NEGINF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_NEGINF)
#define DUK_HEAP_STRING_JSON_EXT_POSINF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_POSINF)
#define DUK_HTHREAD_STRING_JSON_EXT_POSINF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_POSINF)
#define DUK_HEAP_STRING_JSON_EXT_NAN(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_NAN)
#define DUK_HTHREAD_STRING_JSON_EXT_NAN(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_NAN)
#define DUK_HEAP_STRING_JSON_EXT_UNDEFINED(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_UNDEFINED)
#define DUK_HTHREAD_STRING_JSON_EXT_UNDEFINED(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_UNDEFINED)
#define DUK_HEAP_STRING_TO_LOG_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOG_STRING)
#define DUK_HTHREAD_STRING_TO_LOG_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOG_STRING)
#define DUK_HEAP_STRING_CLOG(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CLOG)
#define DUK_HTHREAD_STRING_CLOG(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CLOG)
#define DUK_HEAP_STRING_LC_L(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_L)
#define DUK_HTHREAD_STRING_LC_L(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_L)
#define DUK_HEAP_STRING_LC_N(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_N)
#define DUK_HTHREAD_STRING_LC_N(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_N)
#define DUK_HEAP_STRING_LC_FATAL(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_FATAL)
#define DUK_HTHREAD_STRING_LC_FATAL(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_FATAL)
#define DUK_HEAP_STRING_LC_ERROR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_ERROR)
#define DUK_HTHREAD_STRING_LC_ERROR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_ERROR)
#define DUK_HEAP_STRING_LC_WARN(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_WARN)
#define DUK_HTHREAD_STRING_LC_WARN(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_WARN)
#define DUK_HEAP_STRING_LC_DEBUG(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_DEBUG)
#define DUK_HTHREAD_STRING_LC_DEBUG(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_DEBUG)
#define DUK_HEAP_STRING_LC_TRACE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_TRACE)
#define DUK_HTHREAD_STRING_LC_TRACE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_TRACE)
#define DUK_HEAP_STRING_RAW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RAW)
#define DUK_HTHREAD_STRING_RAW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RAW)
#define DUK_HEAP_STRING_FMT(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FMT)
#define DUK_HTHREAD_STRING_FMT(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FMT)
#define DUK_HEAP_STRING_CURRENT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CURRENT)
#define DUK_HTHREAD_STRING_CURRENT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CURRENT)
#define DUK_HEAP_STRING_RESUME(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RESUME)
#define DUK_HTHREAD_STRING_RESUME(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RESUME)
#define DUK_HEAP_STRING_COMPACT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPACT)
#define DUK_HTHREAD_STRING_COMPACT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPACT)
#define DUK_HEAP_STRING_JC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JC)
#define DUK_HTHREAD_STRING_JC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JC)
#define DUK_HEAP_STRING_JX(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JX)
#define DUK_HTHREAD_STRING_JX(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JX)
#define DUK_HEAP_STRING_BASE64(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BASE64)
#define DUK_HTHREAD_STRING_BASE64(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BASE64)
#define DUK_HEAP_STRING_HEX(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HEX)
#define DUK_HTHREAD_STRING_HEX(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HEX)
#define DUK_HEAP_STRING_DEC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEC)
#define DUK_HTHREAD_STRING_DEC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEC)
#define DUK_HEAP_STRING_ENC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENC)
#define DUK_HTHREAD_STRING_ENC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENC)
#define DUK_HEAP_STRING_FIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FIN)
#define DUK_HTHREAD_STRING_FIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FIN)
#define DUK_HEAP_STRING_GC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GC)
#define DUK_HTHREAD_STRING_GC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GC)
#define DUK_HEAP_STRING_ACT(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ACT)
#define DUK_HTHREAD_STRING_ACT(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ACT)
#define DUK_HEAP_STRING_LC_INFO(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_INFO)
#define DUK_HTHREAD_STRING_LC_INFO(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_INFO)
#define DUK_HEAP_STRING_VERSION(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VERSION)
#define DUK_HTHREAD_STRING_VERSION(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VERSION)
#define DUK_HEAP_STRING_ENV(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENV)
#define DUK_HTHREAD_STRING_ENV(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENV)
#define DUK_HEAP_STRING_MOD_LOADED(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MOD_LOADED)
#define DUK_HTHREAD_STRING_MOD_LOADED(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MOD_LOADED)
#define DUK_HEAP_STRING_MOD_SEARCH(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MOD_SEARCH)
#define DUK_HTHREAD_STRING_MOD_SEARCH(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MOD_SEARCH)
#define DUK_HEAP_STRING_ERR_THROW(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ERR_THROW)
#define DUK_HTHREAD_STRING_ERR_THROW(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ERR_THROW)
#define DUK_HEAP_STRING_ERR_CREATE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ERR_CREATE)
#define DUK_HTHREAD_STRING_ERR_CREATE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ERR_CREATE)
#define DUK_HEAP_STRING_COMPILE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPILE)
#define DUK_HTHREAD_STRING_COMPILE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPILE)
#define DUK_HEAP_STRING_INT_REGBASE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_REGBASE)
#define DUK_HTHREAD_STRING_INT_REGBASE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_REGBASE)
#define DUK_HEAP_STRING_INT_THREAD(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_THREAD)
#define DUK_HTHREAD_STRING_INT_THREAD(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_THREAD)
#define DUK_HEAP_STRING_INT_HANDLER(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_HANDLER)
#define DUK_HTHREAD_STRING_INT_HANDLER(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_HANDLER)
#define DUK_HEAP_STRING_INT_FINALIZER(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_FINALIZER)
#define DUK_HTHREAD_STRING_INT_FINALIZER(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_FINALIZER)
#define DUK_HEAP_STRING_INT_CALLEE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_CALLEE)
#define DUK_HTHREAD_STRING_INT_CALLEE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_CALLEE)
#define DUK_HEAP_STRING_INT_MAP(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_MAP)
#define DUK_HTHREAD_STRING_INT_MAP(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_MAP)
#define DUK_HEAP_STRING_INT_ARGS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_ARGS)
#define DUK_HTHREAD_STRING_INT_ARGS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_ARGS)
#define DUK_HEAP_STRING_INT_THIS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_THIS)
#define DUK_HTHREAD_STRING_INT_THIS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_THIS)
#define DUK_HEAP_STRING_INT_PC2LINE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_PC2LINE)
#define DUK_HTHREAD_STRING_INT_PC2LINE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_PC2LINE)
#define DUK_HEAP_STRING_INT_SOURCE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_SOURCE)
#define DUK_HTHREAD_STRING_INT_SOURCE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_SOURCE)
#define DUK_HEAP_STRING_INT_VARENV(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VARENV)
#define DUK_HTHREAD_STRING_INT_VARENV(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VARENV)
#define DUK_HEAP_STRING_INT_LEXENV(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_LEXENV)
#define DUK_HTHREAD_STRING_INT_LEXENV(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_LEXENV)
#define DUK_HEAP_STRING_INT_VARMAP(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VARMAP)
#define DUK_HTHREAD_STRING_INT_VARMAP(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VARMAP)
#define DUK_HEAP_STRING_INT_FORMALS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_FORMALS)
#define DUK_HTHREAD_STRING_INT_FORMALS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_FORMALS)
#define DUK_HEAP_STRING_INT_BYTECODE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_BYTECODE)
#define DUK_HTHREAD_STRING_INT_BYTECODE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_BYTECODE)
#define DUK_HEAP_STRING_INT_NEXT(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_NEXT)
#define DUK_HTHREAD_STRING_INT_NEXT(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_NEXT)
#define DUK_HEAP_STRING_INT_TARGET(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_TARGET)
#define DUK_HTHREAD_STRING_INT_TARGET(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_TARGET)
#define DUK_HEAP_STRING_INT_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VALUE)
#define DUK_HTHREAD_STRING_INT_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VALUE)
#define DUK_HEAP_STRING_LC_POINTER(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_POINTER)
#define DUK_HTHREAD_STRING_LC_POINTER(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_POINTER)
#define DUK_HEAP_STRING_INT_TRACEDATA(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_TRACEDATA)
#define DUK_HTHREAD_STRING_INT_TRACEDATA(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_TRACEDATA)
#define DUK_HEAP_STRING_LINE_NUMBER(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LINE_NUMBER)
#define DUK_HTHREAD_STRING_LINE_NUMBER(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LINE_NUMBER)
#define DUK_HEAP_STRING_FILE_NAME(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILE_NAME)
#define DUK_HTHREAD_STRING_FILE_NAME(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILE_NAME)
#define DUK_HEAP_STRING_PC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PC)
#define DUK_HTHREAD_STRING_PC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PC)
#define DUK_HEAP_STRING_STACK(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STACK)
#define DUK_HTHREAD_STRING_STACK(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STACK)
#define DUK_HEAP_STRING_THROW_TYPE_ERROR(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THROW_TYPE_ERROR)
#define DUK_HTHREAD_STRING_THROW_TYPE_ERROR(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THROW_TYPE_ERROR)
#define DUK_HEAP_STRING_DUKTAPE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DUKTAPE)
#define DUK_HTHREAD_STRING_DUKTAPE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DUKTAPE)
#define DUK_HEAP_STRING_SET_FLOAT64(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FLOAT64)
#define DUK_HTHREAD_STRING_SET_FLOAT64(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FLOAT64)
#define DUK_HEAP_STRING_SET_FLOAT32(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FLOAT32)
#define DUK_HTHREAD_STRING_SET_FLOAT32(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FLOAT32)
#define DUK_HEAP_STRING_SET_UINT32(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT32)
#define DUK_HTHREAD_STRING_SET_UINT32(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT32)
#define DUK_HEAP_STRING_SET_INT32(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT32)
#define DUK_HTHREAD_STRING_SET_INT32(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT32)
#define DUK_HEAP_STRING_SET_UINT16(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT16)
#define DUK_HTHREAD_STRING_SET_UINT16(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT16)
#define DUK_HEAP_STRING_SET_INT16(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT16)
#define DUK_HTHREAD_STRING_SET_INT16(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT16)
#define DUK_HEAP_STRING_SET_UINT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT8)
#define DUK_HTHREAD_STRING_SET_UINT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT8)
#define DUK_HEAP_STRING_SET_INT8(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT8)
#define DUK_HTHREAD_STRING_SET_INT8(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT8)
#define DUK_HEAP_STRING_GET_FLOAT64(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FLOAT64)
#define DUK_HTHREAD_STRING_GET_FLOAT64(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FLOAT64)
#define DUK_HEAP_STRING_GET_FLOAT32(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FLOAT32)
#define DUK_HTHREAD_STRING_GET_FLOAT32(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FLOAT32)
#define DUK_HEAP_STRING_GET_UINT32(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT32)
#define DUK_HTHREAD_STRING_GET_UINT32(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT32)
#define DUK_HEAP_STRING_GET_INT32(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT32)
#define DUK_HTHREAD_STRING_GET_INT32(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT32)
#define DUK_HEAP_STRING_GET_UINT16(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT16)
#define DUK_HTHREAD_STRING_GET_UINT16(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT16)
#define DUK_HEAP_STRING_GET_INT16(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT16)
#define DUK_HTHREAD_STRING_GET_INT16(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT16)
#define DUK_HEAP_STRING_GET_UINT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT8)
#define DUK_HTHREAD_STRING_GET_UINT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT8)
#define DUK_HEAP_STRING_GET_INT8(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT8)
#define DUK_HTHREAD_STRING_GET_INT8(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT8)
#define DUK_HEAP_STRING_SUBARRAY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBARRAY)
#define DUK_HTHREAD_STRING_SUBARRAY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBARRAY)
#define DUK_HEAP_STRING_BYTES_PER_ELEMENT(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTES_PER_ELEMENT)
#define DUK_HTHREAD_STRING_BYTES_PER_ELEMENT(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTES_PER_ELEMENT)
#define DUK_HEAP_STRING_BYTE_OFFSET(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTE_OFFSET)
#define DUK_HTHREAD_STRING_BYTE_OFFSET(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTE_OFFSET)
#define DUK_HEAP_STRING_LC_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_BUFFER)
#define DUK_HTHREAD_STRING_LC_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_BUFFER)
#define DUK_HEAP_STRING_IS_VIEW(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_VIEW)
#define DUK_HTHREAD_STRING_IS_VIEW(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_VIEW)
#define DUK_HEAP_STRING_DATA(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATA)
#define DUK_HTHREAD_STRING_DATA(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATA)
#define DUK_HEAP_STRING_TYPE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPE)
#define DUK_HTHREAD_STRING_TYPE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPE)
#define DUK_HEAP_STRING_WRITE_INT_BE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT_BE)
#define DUK_HTHREAD_STRING_WRITE_INT_BE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT_BE)
#define DUK_HEAP_STRING_WRITE_INT_LE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT_LE)
#define DUK_HTHREAD_STRING_WRITE_INT_LE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT_LE)
#define DUK_HEAP_STRING_WRITE_UINT_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT_BE)
#define DUK_HEAP_STRING_WRITE_UINT_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT_LE)
#define DUK_HEAP_STRING_WRITE_DOUBLE_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_DOUBLE_BE)
#define DUK_HTHREAD_STRING_WRITE_DOUBLE_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_DOUBLE_BE)
#define DUK_HEAP_STRING_WRITE_DOUBLE_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_DOUBLE_LE)
#define DUK_HTHREAD_STRING_WRITE_DOUBLE_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_DOUBLE_LE)
#define DUK_HEAP_STRING_WRITE_FLOAT_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_FLOAT_BE)
#define DUK_HTHREAD_STRING_WRITE_FLOAT_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_FLOAT_BE)
#define DUK_HEAP_STRING_WRITE_FLOAT_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_FLOAT_LE)
#define DUK_HTHREAD_STRING_WRITE_FLOAT_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_FLOAT_LE)
#define DUK_HEAP_STRING_WRITE_INT32_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT32_BE)
#define DUK_HTHREAD_STRING_WRITE_INT32_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT32_BE)
#define DUK_HEAP_STRING_WRITE_INT32_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT32_LE)
#define DUK_HTHREAD_STRING_WRITE_INT32_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT32_LE)
#define DUK_HEAP_STRING_WRITE_UINT32_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT32_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT32_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT32_BE)
#define DUK_HEAP_STRING_WRITE_UINT32_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT32_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT32_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT32_LE)
#define DUK_HEAP_STRING_WRITE_INT16_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT16_BE)
#define DUK_HTHREAD_STRING_WRITE_INT16_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT16_BE)
#define DUK_HEAP_STRING_WRITE_INT16_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT16_LE)
#define DUK_HTHREAD_STRING_WRITE_INT16_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT16_LE)
#define DUK_HEAP_STRING_WRITE_UINT16_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT16_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT16_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT16_BE)
#define DUK_HEAP_STRING_WRITE_UINT16_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT16_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT16_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT16_LE)
#define DUK_HEAP_STRING_WRITE_INT8(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT8)
#define DUK_HTHREAD_STRING_WRITE_INT8(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT8)
#define DUK_HEAP_STRING_WRITE_UINT8(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT8)
#define DUK_HTHREAD_STRING_WRITE_UINT8(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT8)
#define DUK_HEAP_STRING_READ_INT_BE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT_BE)
#define DUK_HTHREAD_STRING_READ_INT_BE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT_BE)
#define DUK_HEAP_STRING_READ_INT_LE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT_LE)
#define DUK_HTHREAD_STRING_READ_INT_LE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT_LE)
#define DUK_HEAP_STRING_READ_UINT_BE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT_BE)
#define DUK_HTHREAD_STRING_READ_UINT_BE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT_BE)
#define DUK_HEAP_STRING_READ_UINT_LE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT_LE)
#define DUK_HTHREAD_STRING_READ_UINT_LE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT_LE)
#define DUK_HEAP_STRING_READ_DOUBLE_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_DOUBLE_BE)
#define DUK_HTHREAD_STRING_READ_DOUBLE_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_DOUBLE_BE)
#define DUK_HEAP_STRING_READ_DOUBLE_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_DOUBLE_LE)
#define DUK_HTHREAD_STRING_READ_DOUBLE_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_DOUBLE_LE)
#define DUK_HEAP_STRING_READ_FLOAT_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_FLOAT_BE)
#define DUK_HTHREAD_STRING_READ_FLOAT_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_FLOAT_BE)
#define DUK_HEAP_STRING_READ_FLOAT_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_FLOAT_LE)
#define DUK_HTHREAD_STRING_READ_FLOAT_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_FLOAT_LE)
#define DUK_HEAP_STRING_READ_INT32_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT32_BE)
#define DUK_HTHREAD_STRING_READ_INT32_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT32_BE)
#define DUK_HEAP_STRING_READ_INT32_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT32_LE)
#define DUK_HTHREAD_STRING_READ_INT32_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT32_LE)
#define DUK_HEAP_STRING_READ_UINT32_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT32_BE)
#define DUK_HTHREAD_STRING_READ_UINT32_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT32_BE)
#define DUK_HEAP_STRING_READ_UINT32_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT32_LE)
#define DUK_HTHREAD_STRING_READ_UINT32_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT32_LE)
#define DUK_HEAP_STRING_READ_INT16_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT16_BE)
#define DUK_HTHREAD_STRING_READ_INT16_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT16_BE)
#define DUK_HEAP_STRING_READ_INT16_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT16_LE)
#define DUK_HTHREAD_STRING_READ_INT16_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT16_LE)
#define DUK_HEAP_STRING_READ_UINT16_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT16_BE)
#define DUK_HTHREAD_STRING_READ_UINT16_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT16_BE)
#define DUK_HEAP_STRING_READ_UINT16_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT16_LE)
#define DUK_HTHREAD_STRING_READ_UINT16_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT16_LE)
#define DUK_HEAP_STRING_READ_INT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT8)
#define DUK_HTHREAD_STRING_READ_INT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT8)
#define DUK_HEAP_STRING_READ_UINT8(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT8)
#define DUK_HTHREAD_STRING_READ_UINT8(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT8)
#define DUK_HEAP_STRING_COPY(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COPY)
#define DUK_HTHREAD_STRING_COPY(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COPY)
#define DUK_HEAP_STRING_EQUALS(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EQUALS)
#define DUK_HTHREAD_STRING_EQUALS(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EQUALS)
#define DUK_HEAP_STRING_FILL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILL)
#define DUK_HTHREAD_STRING_FILL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILL)
#define DUK_HEAP_STRING_WRITE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE)
#define DUK_HTHREAD_STRING_WRITE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE)
#define DUK_HEAP_STRING_COMPARE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPARE)
#define DUK_HTHREAD_STRING_COMPARE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPARE)
#define DUK_HEAP_STRING_BYTE_LENGTH(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTE_LENGTH)
#define DUK_HTHREAD_STRING_BYTE_LENGTH(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTE_LENGTH)
#define DUK_HEAP_STRING_IS_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_BUFFER)
#define DUK_HTHREAD_STRING_IS_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_BUFFER)
#define DUK_HEAP_STRING_IS_ENCODING(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_ENCODING)
#define DUK_HTHREAD_STRING_IS_ENCODING(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_ENCODING)
#define DUK_HEAP_STRING_EXPORTS(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXPORTS)
#define DUK_HTHREAD_STRING_EXPORTS(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXPORTS)
#define DUK_HEAP_STRING_ID(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ID)
#define DUK_HTHREAD_STRING_ID(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ID)
#define DUK_HEAP_STRING_REQUIRE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REQUIRE)
#define DUK_HTHREAD_STRING_REQUIRE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REQUIRE)
#define DUK_HEAP_STRING___PROTO__(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX___PROTO__)
#define DUK_HTHREAD_STRING___PROTO__(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX___PROTO__)
#define DUK_HEAP_STRING_SET_PROTOTYPE_OF(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_SET_PROTOTYPE_OF(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_PROTOTYPE_OF)
#define DUK_HEAP_STRING_OWN_KEYS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_OWN_KEYS)
#define DUK_HTHREAD_STRING_OWN_KEYS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_OWN_KEYS)
#define DUK_HEAP_STRING_ENUMERATE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUMERATE)
#define DUK_HTHREAD_STRING_ENUMERATE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUMERATE)
#define DUK_HEAP_STRING_DELETE_PROPERTY(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DELETE_PROPERTY)
#define DUK_HTHREAD_STRING_DELETE_PROPERTY(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DELETE_PROPERTY)
#define DUK_HEAP_STRING_HAS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HAS)
#define DUK_HTHREAD_STRING_HAS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HAS)
#define DUK_HEAP_STRING_PROXY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROXY)
#define DUK_HTHREAD_STRING_PROXY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROXY)
#define DUK_HEAP_STRING_CALLEE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALLEE)
#define DUK_HTHREAD_STRING_CALLEE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALLEE)
#define DUK_HEAP_STRING_INVALID_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INVALID_DATE)
#define DUK_HTHREAD_STRING_INVALID_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INVALID_DATE)
#define DUK_HEAP_STRING_BRACKETED_ELLIPSIS(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BRACKETED_ELLIPSIS)
#define DUK_HTHREAD_STRING_BRACKETED_ELLIPSIS(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BRACKETED_ELLIPSIS)
#define DUK_HEAP_STRING_NEWLINE_TAB(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEWLINE_TAB)
#define DUK_HTHREAD_STRING_NEWLINE_TAB(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEWLINE_TAB)
#define DUK_HEAP_STRING_SPACE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPACE)
#define DUK_HTHREAD_STRING_SPACE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPACE)
#define DUK_HEAP_STRING_COMMA(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMMA)
#define DUK_HTHREAD_STRING_COMMA(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMMA)
#define DUK_HEAP_STRING_MINUS_ZERO(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MINUS_ZERO)
#define DUK_HTHREAD_STRING_MINUS_ZERO(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MINUS_ZERO)
#define DUK_HEAP_STRING_PLUS_ZERO(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PLUS_ZERO)
#define DUK_HTHREAD_STRING_PLUS_ZERO(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PLUS_ZERO)
#define DUK_HEAP_STRING_ZERO(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ZERO)
#define DUK_HTHREAD_STRING_ZERO(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ZERO)
#define DUK_HEAP_STRING_MINUS_INFINITY(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MINUS_INFINITY)
#define DUK_HTHREAD_STRING_MINUS_INFINITY(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MINUS_INFINITY)
#define DUK_HEAP_STRING_PLUS_INFINITY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PLUS_INFINITY)
#define DUK_HTHREAD_STRING_PLUS_INFINITY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PLUS_INFINITY)
#define DUK_HEAP_STRING_INFINITY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INFINITY)
#define DUK_HTHREAD_STRING_INFINITY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INFINITY)
#define DUK_HEAP_STRING_LC_OBJECT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_OBJECT)
#define DUK_HTHREAD_STRING_LC_OBJECT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_OBJECT)
#define DUK_HEAP_STRING_LC_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_STRING)
#define DUK_HTHREAD_STRING_LC_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_STRING)
#define DUK_HEAP_STRING_LC_NUMBER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_NUMBER)
#define DUK_HTHREAD_STRING_LC_NUMBER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_NUMBER)
#define DUK_HEAP_STRING_LC_BOOLEAN(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_BOOLEAN)
#define DUK_HTHREAD_STRING_LC_BOOLEAN(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_BOOLEAN)
#define DUK_HEAP_STRING_LC_UNDEFINED(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_UNDEFINED)
#define DUK_HTHREAD_STRING_LC_UNDEFINED(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_UNDEFINED)
#define DUK_HEAP_STRING_STRINGIFY(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STRINGIFY)
#define DUK_HTHREAD_STRING_STRINGIFY(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STRINGIFY)
#define DUK_HEAP_STRING_TAN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TAN)
#define DUK_HTHREAD_STRING_TAN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TAN)
#define DUK_HEAP_STRING_SQRT(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT)
#define DUK_HTHREAD_STRING_SQRT(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT)
#define DUK_HEAP_STRING_SIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SIN)
#define DUK_HTHREAD_STRING_SIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SIN)
#define DUK_HEAP_STRING_ROUND(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ROUND)
#define DUK_HTHREAD_STRING_ROUND(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ROUND)
#define DUK_HEAP_STRING_RANDOM(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RANDOM)
#define DUK_HTHREAD_STRING_RANDOM(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RANDOM)
#define DUK_HEAP_STRING_POW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POW)
#define DUK_HTHREAD_STRING_POW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POW)
#define DUK_HEAP_STRING_MIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MIN)
#define DUK_HTHREAD_STRING_MIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MIN)
#define DUK_HEAP_STRING_MAX(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAX)
#define DUK_HTHREAD_STRING_MAX(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAX)
#define DUK_HEAP_STRING_LOG(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG)
#define DUK_HTHREAD_STRING_LOG(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG)
#define DUK_HEAP_STRING_FLOOR(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOOR)
#define DUK_HTHREAD_STRING_FLOOR(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOOR)
#define DUK_HEAP_STRING_EXP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXP)
#define DUK_HTHREAD_STRING_EXP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXP)
#define DUK_HEAP_STRING_COS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COS)
#define DUK_HTHREAD_STRING_COS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COS)
#define DUK_HEAP_STRING_CEIL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CEIL)
#define DUK_HTHREAD_STRING_CEIL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CEIL)
#define DUK_HEAP_STRING_ATAN2(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ATAN2)
#define DUK_HTHREAD_STRING_ATAN2(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ATAN2)
#define DUK_HEAP_STRING_ATAN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ATAN)
#define DUK_HTHREAD_STRING_ATAN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ATAN)
#define DUK_HEAP_STRING_ASIN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ASIN)
#define DUK_HTHREAD_STRING_ASIN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ASIN)
#define DUK_HEAP_STRING_ACOS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ACOS)
#define DUK_HTHREAD_STRING_ACOS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ACOS)
#define DUK_HEAP_STRING_ABS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ABS)
#define DUK_HTHREAD_STRING_ABS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ABS)
#define DUK_HEAP_STRING_SQRT2(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT2)
#define DUK_HTHREAD_STRING_SQRT2(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT2)
#define DUK_HEAP_STRING_SQRT1_2(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT1_2)
#define DUK_HTHREAD_STRING_SQRT1_2(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT1_2)
#define DUK_HEAP_STRING_PI(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PI)
#define DUK_HTHREAD_STRING_PI(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PI)
#define DUK_HEAP_STRING_LOG10E(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG10E)
#define DUK_HTHREAD_STRING_LOG10E(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG10E)
#define DUK_HEAP_STRING_LOG2E(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG2E)
#define DUK_HTHREAD_STRING_LOG2E(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG2E)
#define DUK_HEAP_STRING_LN2(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LN2)
#define DUK_HTHREAD_STRING_LN2(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LN2)
#define DUK_HEAP_STRING_LN10(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LN10)
#define DUK_HTHREAD_STRING_LN10(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LN10)
#define DUK_HEAP_STRING_E(heap)                                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_E)
#define DUK_HTHREAD_STRING_E(thr)                                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_E)
#define DUK_HEAP_STRING_MESSAGE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MESSAGE)
#define DUK_HTHREAD_STRING_MESSAGE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MESSAGE)
#define DUK_HEAP_STRING_NAME(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NAME)
#define DUK_HTHREAD_STRING_NAME(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NAME)
#define DUK_HEAP_STRING_INPUT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INPUT)
#define DUK_HTHREAD_STRING_INPUT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INPUT)
#define DUK_HEAP_STRING_INDEX(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INDEX)
#define DUK_HTHREAD_STRING_INDEX(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INDEX)
#define DUK_HEAP_STRING_ESCAPED_EMPTY_REGEXP(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ESCAPED_EMPTY_REGEXP)
#define DUK_HTHREAD_STRING_ESCAPED_EMPTY_REGEXP(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ESCAPED_EMPTY_REGEXP)
#define DUK_HEAP_STRING_LAST_INDEX(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LAST_INDEX)
#define DUK_HTHREAD_STRING_LAST_INDEX(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LAST_INDEX)
#define DUK_HEAP_STRING_MULTILINE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MULTILINE)
#define DUK_HTHREAD_STRING_MULTILINE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MULTILINE)
#define DUK_HEAP_STRING_IGNORE_CASE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IGNORE_CASE)
#define DUK_HTHREAD_STRING_IGNORE_CASE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IGNORE_CASE)
#define DUK_HEAP_STRING_SOURCE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SOURCE)
#define DUK_HTHREAD_STRING_SOURCE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SOURCE)
#define DUK_HEAP_STRING_TEST(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TEST)
#define DUK_HTHREAD_STRING_TEST(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TEST)
#define DUK_HEAP_STRING_EXEC(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXEC)
#define DUK_HTHREAD_STRING_EXEC(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXEC)
#define DUK_HEAP_STRING_TO_GMT_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_GMT_STRING)
#define DUK_HTHREAD_STRING_TO_GMT_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_GMT_STRING)
#define DUK_HEAP_STRING_SET_YEAR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_YEAR)
#define DUK_HTHREAD_STRING_SET_YEAR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_YEAR)
#define DUK_HEAP_STRING_GET_YEAR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_YEAR)
#define DUK_HTHREAD_STRING_GET_YEAR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_YEAR)
#define DUK_HEAP_STRING_TO_JSON(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_JSON)
#define DUK_HTHREAD_STRING_TO_JSON(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_JSON)
#define DUK_HEAP_STRING_TO_ISO_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_ISO_STRING)
#define DUK_HTHREAD_STRING_TO_ISO_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_ISO_STRING)
#define DUK_HEAP_STRING_TO_UTC_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_UTC_STRING)
#define DUK_HTHREAD_STRING_TO_UTC_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_UTC_STRING)
#define DUK_HEAP_STRING_SET_UTC_FULL_YEAR(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_FULL_YEAR)
#define DUK_HTHREAD_STRING_SET_UTC_FULL_YEAR(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_FULL_YEAR)
#define DUK_HEAP_STRING_SET_FULL_YEAR(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FULL_YEAR)
#define DUK_HTHREAD_STRING_SET_FULL_YEAR(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FULL_YEAR)
#define DUK_HEAP_STRING_SET_UTC_MONTH(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MONTH)
#define DUK_HTHREAD_STRING_SET_UTC_MONTH(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MONTH)
#define DUK_HEAP_STRING_SET_MONTH(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MONTH)
#define DUK_HTHREAD_STRING_SET_MONTH(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MONTH)
#define DUK_HEAP_STRING_SET_UTC_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_DATE)
#define DUK_HTHREAD_STRING_SET_UTC_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_DATE)
#define DUK_HEAP_STRING_SET_DATE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_DATE)
#define DUK_HTHREAD_STRING_SET_DATE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_DATE)
#define DUK_HEAP_STRING_SET_UTC_HOURS(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_HOURS)
#define DUK_HTHREAD_STRING_SET_UTC_HOURS(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_HOURS)
#define DUK_HEAP_STRING_SET_HOURS(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_HOURS)
#define DUK_HTHREAD_STRING_SET_HOURS(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_HOURS)
#define DUK_HEAP_STRING_SET_UTC_MINUTES(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MINUTES)
#define DUK_HTHREAD_STRING_SET_UTC_MINUTES(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MINUTES)
#define DUK_HEAP_STRING_SET_MINUTES(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MINUTES)
#define DUK_HTHREAD_STRING_SET_MINUTES(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MINUTES)
#define DUK_HEAP_STRING_SET_UTC_SECONDS(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_SECONDS)
#define DUK_HTHREAD_STRING_SET_UTC_SECONDS(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_SECONDS)
#define DUK_HEAP_STRING_SET_SECONDS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_SECONDS)
#define DUK_HTHREAD_STRING_SET_SECONDS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_SECONDS)
#define DUK_HEAP_STRING_SET_UTC_MILLISECONDS(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MILLISECONDS)
#define DUK_HTHREAD_STRING_SET_UTC_MILLISECONDS(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MILLISECONDS)
#define DUK_HEAP_STRING_SET_MILLISECONDS(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MILLISECONDS)
#define DUK_HTHREAD_STRING_SET_MILLISECONDS(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MILLISECONDS)
#define DUK_HEAP_STRING_SET_TIME(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_TIME)
#define DUK_HTHREAD_STRING_SET_TIME(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_TIME)
#define DUK_HEAP_STRING_GET_TIMEZONE_OFFSET(heap)                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_TIMEZONE_OFFSET)
#define DUK_HTHREAD_STRING_GET_TIMEZONE_OFFSET(thr)                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_TIMEZONE_OFFSET)
#define DUK_HEAP_STRING_GET_UTC_MILLISECONDS(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MILLISECONDS)
#define DUK_HTHREAD_STRING_GET_UTC_MILLISECONDS(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MILLISECONDS)
#define DUK_HEAP_STRING_GET_MILLISECONDS(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MILLISECONDS)
#define DUK_HTHREAD_STRING_GET_MILLISECONDS(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MILLISECONDS)
#define DUK_HEAP_STRING_GET_UTC_SECONDS(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_SECONDS)
#define DUK_HTHREAD_STRING_GET_UTC_SECONDS(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_SECONDS)
#define DUK_HEAP_STRING_GET_SECONDS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_SECONDS)
#define DUK_HTHREAD_STRING_GET_SECONDS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_SECONDS)
#define DUK_HEAP_STRING_GET_UTC_MINUTES(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MINUTES)
#define DUK_HTHREAD_STRING_GET_UTC_MINUTES(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MINUTES)
#define DUK_HEAP_STRING_GET_MINUTES(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MINUTES)
#define DUK_HTHREAD_STRING_GET_MINUTES(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MINUTES)
#define DUK_HEAP_STRING_GET_UTC_HOURS(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_HOURS)
#define DUK_HTHREAD_STRING_GET_UTC_HOURS(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_HOURS)
#define DUK_HEAP_STRING_GET_HOURS(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_HOURS)
#define DUK_HTHREAD_STRING_GET_HOURS(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_HOURS)
#define DUK_HEAP_STRING_GET_UTC_DAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_DAY)
#define DUK_HTHREAD_STRING_GET_UTC_DAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_DAY)
#define DUK_HEAP_STRING_GET_DAY(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_DAY)
#define DUK_HTHREAD_STRING_GET_DAY(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_DAY)
#define DUK_HEAP_STRING_GET_UTC_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_DATE)
#define DUK_HTHREAD_STRING_GET_UTC_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_DATE)
#define DUK_HEAP_STRING_GET_DATE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_DATE)
#define DUK_HTHREAD_STRING_GET_DATE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_DATE)
#define DUK_HEAP_STRING_GET_UTC_MONTH(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MONTH)
#define DUK_HTHREAD_STRING_GET_UTC_MONTH(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MONTH)
#define DUK_HEAP_STRING_GET_MONTH(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MONTH)
#define DUK_HTHREAD_STRING_GET_MONTH(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MONTH)
#define DUK_HEAP_STRING_GET_UTC_FULL_YEAR(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_FULL_YEAR)
#define DUK_HTHREAD_STRING_GET_UTC_FULL_YEAR(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_FULL_YEAR)
#define DUK_HEAP_STRING_GET_FULL_YEAR(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FULL_YEAR)
#define DUK_HTHREAD_STRING_GET_FULL_YEAR(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FULL_YEAR)
#define DUK_HEAP_STRING_GET_TIME(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_TIME)
#define DUK_HTHREAD_STRING_GET_TIME(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_TIME)
#define DUK_HEAP_STRING_TO_LOCALE_TIME_STRING(heap)                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_TIME_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_TIME_STRING(thr)                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_TIME_STRING)
#define DUK_HEAP_STRING_TO_LOCALE_DATE_STRING(heap)                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_DATE_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_DATE_STRING(thr)                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_DATE_STRING)
#define DUK_HEAP_STRING_TO_TIME_STRING(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_TIME_STRING)
#define DUK_HTHREAD_STRING_TO_TIME_STRING(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_TIME_STRING)
#define DUK_HEAP_STRING_TO_DATE_STRING(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_DATE_STRING)
#define DUK_HTHREAD_STRING_TO_DATE_STRING(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_DATE_STRING)
#define DUK_HEAP_STRING_NOW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NOW)
#define DUK_HTHREAD_STRING_NOW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NOW)
#define DUK_HEAP_STRING_UTC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UTC)
#define DUK_HTHREAD_STRING_UTC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UTC)
#define DUK_HEAP_STRING_PARSE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE)
#define DUK_HTHREAD_STRING_PARSE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE)
#define DUK_HEAP_STRING_TO_PRECISION(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_PRECISION)
#define DUK_HTHREAD_STRING_TO_PRECISION(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_PRECISION)
#define DUK_HEAP_STRING_TO_EXPONENTIAL(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_EXPONENTIAL)
#define DUK_HTHREAD_STRING_TO_EXPONENTIAL(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_EXPONENTIAL)
#define DUK_HEAP_STRING_TO_FIXED(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_FIXED)
#define DUK_HTHREAD_STRING_TO_FIXED(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_FIXED)
#define DUK_HEAP_STRING_POSITIVE_INFINITY(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POSITIVE_INFINITY)
#define DUK_HTHREAD_STRING_POSITIVE_INFINITY(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POSITIVE_INFINITY)
#define DUK_HEAP_STRING_NEGATIVE_INFINITY(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEGATIVE_INFINITY)
#define DUK_HTHREAD_STRING_NEGATIVE_INFINITY(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEGATIVE_INFINITY)
#define DUK_HEAP_STRING_NAN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NAN)
#define DUK_HTHREAD_STRING_NAN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NAN)
#define DUK_HEAP_STRING_MIN_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MIN_VALUE)
#define DUK_HTHREAD_STRING_MIN_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MIN_VALUE)
#define DUK_HEAP_STRING_MAX_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAX_VALUE)
#define DUK_HTHREAD_STRING_MAX_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAX_VALUE)
#define DUK_HEAP_STRING_SUBSTR(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBSTR)
#define DUK_HTHREAD_STRING_SUBSTR(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBSTR)
#define DUK_HEAP_STRING_TRIM(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRIM)
#define DUK_HTHREAD_STRING_TRIM(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRIM)
#define DUK_HEAP_STRING_TO_LOCALE_UPPER_CASE(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_UPPER_CASE)
#define DUK_HTHREAD_STRING_TO_LOCALE_UPPER_CASE(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_UPPER_CASE)
#define DUK_HEAP_STRING_TO_UPPER_CASE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_UPPER_CASE)
#define DUK_HTHREAD_STRING_TO_UPPER_CASE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_UPPER_CASE)
#define DUK_HEAP_STRING_TO_LOCALE_LOWER_CASE(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_LOWER_CASE)
#define DUK_HTHREAD_STRING_TO_LOCALE_LOWER_CASE(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_LOWER_CASE)
#define DUK_HEAP_STRING_TO_LOWER_CASE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOWER_CASE)
#define DUK_HTHREAD_STRING_TO_LOWER_CASE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOWER_CASE)
#define DUK_HEAP_STRING_SUBSTRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBSTRING)
#define DUK_HTHREAD_STRING_SUBSTRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBSTRING)
#define DUK_HEAP_STRING_SPLIT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPLIT)
#define DUK_HTHREAD_STRING_SPLIT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPLIT)
#define DUK_HEAP_STRING_SEARCH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SEARCH)
#define DUK_HTHREAD_STRING_SEARCH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SEARCH)
#define DUK_HEAP_STRING_REPLACE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REPLACE)
#define DUK_HTHREAD_STRING_REPLACE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REPLACE)
#define DUK_HEAP_STRING_MATCH(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MATCH)
#define DUK_HTHREAD_STRING_MATCH(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MATCH)
#define DUK_HEAP_STRING_LOCALE_COMPARE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOCALE_COMPARE)
#define DUK_HTHREAD_STRING_LOCALE_COMPARE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOCALE_COMPARE)
#define DUK_HEAP_STRING_CHAR_CODE_AT(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CHAR_CODE_AT)
#define DUK_HTHREAD_STRING_CHAR_CODE_AT(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CHAR_CODE_AT)
#define DUK_HEAP_STRING_CHAR_AT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CHAR_AT)
#define DUK_HTHREAD_STRING_CHAR_AT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CHAR_AT)
#define DUK_HEAP_STRING_FROM_CHAR_CODE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FROM_CHAR_CODE)
#define DUK_HTHREAD_STRING_FROM_CHAR_CODE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FROM_CHAR_CODE)
#define DUK_HEAP_STRING_REDUCE_RIGHT(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REDUCE_RIGHT)
#define DUK_HTHREAD_STRING_REDUCE_RIGHT(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REDUCE_RIGHT)
#define DUK_HEAP_STRING_REDUCE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REDUCE)
#define DUK_HTHREAD_STRING_REDUCE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REDUCE)
#define DUK_HEAP_STRING_FILTER(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILTER)
#define DUK_HTHREAD_STRING_FILTER(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILTER)
#define DUK_HEAP_STRING_MAP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAP)
#define DUK_HTHREAD_STRING_MAP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAP)
#define DUK_HEAP_STRING_FOR_EACH(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FOR_EACH)
#define DUK_HTHREAD_STRING_FOR_EACH(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FOR_EACH)
#define DUK_HEAP_STRING_SOME(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SOME)
#define DUK_HTHREAD_STRING_SOME(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SOME)
#define DUK_HEAP_STRING_EVERY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVERY)
#define DUK_HTHREAD_STRING_EVERY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVERY)
#define DUK_HEAP_STRING_LAST_INDEX_OF(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LAST_INDEX_OF)
#define DUK_HTHREAD_STRING_LAST_INDEX_OF(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LAST_INDEX_OF)
#define DUK_HEAP_STRING_INDEX_OF(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INDEX_OF)
#define DUK_HTHREAD_STRING_INDEX_OF(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INDEX_OF)
#define DUK_HEAP_STRING_UNSHIFT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UNSHIFT)
#define DUK_HTHREAD_STRING_UNSHIFT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UNSHIFT)
#define DUK_HEAP_STRING_SPLICE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPLICE)
#define DUK_HTHREAD_STRING_SPLICE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPLICE)
#define DUK_HEAP_STRING_SORT(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SORT)
#define DUK_HTHREAD_STRING_SORT(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SORT)
#define DUK_HEAP_STRING_SLICE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SLICE)
#define DUK_HTHREAD_STRING_SLICE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SLICE)
#define DUK_HEAP_STRING_SHIFT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SHIFT)
#define DUK_HTHREAD_STRING_SHIFT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SHIFT)
#define DUK_HEAP_STRING_REVERSE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REVERSE)
#define DUK_HTHREAD_STRING_REVERSE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REVERSE)
#define DUK_HEAP_STRING_PUSH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PUSH)
#define DUK_HTHREAD_STRING_PUSH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PUSH)
#define DUK_HEAP_STRING_POP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POP)
#define DUK_HTHREAD_STRING_POP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POP)
#define DUK_HEAP_STRING_JOIN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JOIN)
#define DUK_HTHREAD_STRING_JOIN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JOIN)
#define DUK_HEAP_STRING_CONCAT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONCAT)
#define DUK_HTHREAD_STRING_CONCAT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONCAT)
#define DUK_HEAP_STRING_IS_ARRAY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_ARRAY)
#define DUK_HTHREAD_STRING_IS_ARRAY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_ARRAY)
#define DUK_HEAP_STRING_LC_ARGUMENTS(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_ARGUMENTS)
#define DUK_HTHREAD_STRING_LC_ARGUMENTS(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_ARGUMENTS)
#define DUK_HEAP_STRING_CALLER(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALLER)
#define DUK_HTHREAD_STRING_CALLER(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALLER)
#define DUK_HEAP_STRING_BIND(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BIND)
#define DUK_HTHREAD_STRING_BIND(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BIND)
#define DUK_HEAP_STRING_CALL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALL)
#define DUK_HTHREAD_STRING_CALL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALL)
#define DUK_HEAP_STRING_APPLY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_APPLY)
#define DUK_HTHREAD_STRING_APPLY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_APPLY)
#define DUK_HEAP_STRING_PROPERTY_IS_ENUMERABLE(heap)                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROPERTY_IS_ENUMERABLE)
#define DUK_HTHREAD_STRING_PROPERTY_IS_ENUMERABLE(thr)                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROPERTY_IS_ENUMERABLE)
#define DUK_HEAP_STRING_IS_PROTOTYPE_OF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_IS_PROTOTYPE_OF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_PROTOTYPE_OF)
#define DUK_HEAP_STRING_HAS_OWN_PROPERTY(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HAS_OWN_PROPERTY)
#define DUK_HTHREAD_STRING_HAS_OWN_PROPERTY(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HAS_OWN_PROPERTY)
#define DUK_HEAP_STRING_VALUE_OF(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VALUE_OF)
#define DUK_HTHREAD_STRING_VALUE_OF(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VALUE_OF)
#define DUK_HEAP_STRING_TO_LOCALE_STRING(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_STRING(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_STRING)
#define DUK_HEAP_STRING_TO_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_STRING)
#define DUK_HTHREAD_STRING_TO_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_STRING)
#define DUK_HEAP_STRING_CONSTRUCTOR(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONSTRUCTOR)
#define DUK_HTHREAD_STRING_CONSTRUCTOR(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONSTRUCTOR)
#define DUK_HEAP_STRING_SET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET)
#define DUK_HTHREAD_STRING_SET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET)
#define DUK_HEAP_STRING_GET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET)
#define DUK_HTHREAD_STRING_GET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET)
#define DUK_HEAP_STRING_ENUMERABLE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUMERABLE)
#define DUK_HTHREAD_STRING_ENUMERABLE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUMERABLE)
#define DUK_HEAP_STRING_CONFIGURABLE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONFIGURABLE)
#define DUK_HTHREAD_STRING_CONFIGURABLE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONFIGURABLE)
#define DUK_HEAP_STRING_WRITABLE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITABLE)
#define DUK_HTHREAD_STRING_WRITABLE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITABLE)
#define DUK_HEAP_STRING_VALUE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VALUE)
#define DUK_HTHREAD_STRING_VALUE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VALUE)
#define DUK_HEAP_STRING_KEYS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_KEYS)
#define DUK_HTHREAD_STRING_KEYS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_KEYS)
#define DUK_HEAP_STRING_IS_EXTENSIBLE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_EXTENSIBLE)
#define DUK_HTHREAD_STRING_IS_EXTENSIBLE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_EXTENSIBLE)
#define DUK_HEAP_STRING_IS_FROZEN(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_FROZEN)
#define DUK_HTHREAD_STRING_IS_FROZEN(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_FROZEN)
#define DUK_HEAP_STRING_IS_SEALED(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_SEALED)
#define DUK_HTHREAD_STRING_IS_SEALED(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_SEALED)
#define DUK_HEAP_STRING_PREVENT_EXTENSIONS(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PREVENT_EXTENSIONS)
#define DUK_HTHREAD_STRING_PREVENT_EXTENSIONS(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PREVENT_EXTENSIONS)
#define DUK_HEAP_STRING_FREEZE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FREEZE)
#define DUK_HTHREAD_STRING_FREEZE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FREEZE)
#define DUK_HEAP_STRING_SEAL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SEAL)
#define DUK_HTHREAD_STRING_SEAL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SEAL)
#define DUK_HEAP_STRING_DEFINE_PROPERTIES(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFINE_PROPERTIES)
#define DUK_HTHREAD_STRING_DEFINE_PROPERTIES(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFINE_PROPERTIES)
#define DUK_HEAP_STRING_DEFINE_PROPERTY(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFINE_PROPERTY)
#define DUK_HTHREAD_STRING_DEFINE_PROPERTY(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFINE_PROPERTY)
#define DUK_HEAP_STRING_CREATE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CREATE)
#define DUK_HTHREAD_STRING_CREATE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CREATE)
#define DUK_HEAP_STRING_GET_OWN_PROPERTY_NAMES(heap)                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_OWN_PROPERTY_NAMES)
#define DUK_HTHREAD_STRING_GET_OWN_PROPERTY_NAMES(thr)                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_OWN_PROPERTY_NAMES)
#define DUK_HEAP_STRING_GET_OWN_PROPERTY_DESCRIPTOR(heap)             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR)
#define DUK_HTHREAD_STRING_GET_OWN_PROPERTY_DESCRIPTOR(thr)           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR)
#define DUK_HEAP_STRING_GET_PROTOTYPE_OF(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_GET_PROTOTYPE_OF(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_PROTOTYPE_OF)
#define DUK_HEAP_STRING_PROTOTYPE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROTOTYPE)
#define DUK_HTHREAD_STRING_PROTOTYPE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROTOTYPE)
#define DUK_HEAP_STRING_LENGTH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LENGTH)
#define DUK_HTHREAD_STRING_LENGTH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LENGTH)
#define DUK_HEAP_STRING_ALERT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ALERT)
#define DUK_HTHREAD_STRING_ALERT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ALERT)
#define DUK_HEAP_STRING_PRINT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PRINT)
#define DUK_HTHREAD_STRING_PRINT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PRINT)
#define DUK_HEAP_STRING_UNESCAPE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UNESCAPE)
#define DUK_HTHREAD_STRING_UNESCAPE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UNESCAPE)
#define DUK_HEAP_STRING_ESCAPE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ESCAPE)
#define DUK_HTHREAD_STRING_ESCAPE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ESCAPE)
#define DUK_HEAP_STRING_ENCODE_URI_COMPONENT(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENCODE_URI_COMPONENT)
#define DUK_HTHREAD_STRING_ENCODE_URI_COMPONENT(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENCODE_URI_COMPONENT)
#define DUK_HEAP_STRING_ENCODE_URI(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENCODE_URI)
#define DUK_HTHREAD_STRING_ENCODE_URI(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENCODE_URI)
#define DUK_HEAP_STRING_DECODE_URI_COMPONENT(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DECODE_URI_COMPONENT)
#define DUK_HTHREAD_STRING_DECODE_URI_COMPONENT(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DECODE_URI_COMPONENT)
#define DUK_HEAP_STRING_DECODE_URI(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DECODE_URI)
#define DUK_HTHREAD_STRING_DECODE_URI(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DECODE_URI)
#define DUK_HEAP_STRING_IS_FINITE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_FINITE)
#define DUK_HTHREAD_STRING_IS_FINITE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_FINITE)
#define DUK_HEAP_STRING_IS_NAN(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_NAN)
#define DUK_HTHREAD_STRING_IS_NAN(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_NAN)
#define DUK_HEAP_STRING_PARSE_FLOAT(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE_FLOAT)
#define DUK_HTHREAD_STRING_PARSE_FLOAT(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE_FLOAT)
#define DUK_HEAP_STRING_PARSE_INT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE_INT)
#define DUK_HTHREAD_STRING_PARSE_INT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE_INT)
#define DUK_HEAP_STRING_EVAL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVAL)
#define DUK_HTHREAD_STRING_EVAL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVAL)
#define DUK_HEAP_STRING_URI_ERROR(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_URI_ERROR)
#define DUK_HTHREAD_STRING_URI_ERROR(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_URI_ERROR)
#define DUK_HEAP_STRING_TYPE_ERROR(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPE_ERROR)
#define DUK_HTHREAD_STRING_TYPE_ERROR(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPE_ERROR)
#define DUK_HEAP_STRING_SYNTAX_ERROR(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SYNTAX_ERROR)
#define DUK_HTHREAD_STRING_SYNTAX_ERROR(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SYNTAX_ERROR)
#define DUK_HEAP_STRING_REFERENCE_ERROR(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REFERENCE_ERROR)
#define DUK_HTHREAD_STRING_REFERENCE_ERROR(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REFERENCE_ERROR)
#define DUK_HEAP_STRING_RANGE_ERROR(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RANGE_ERROR)
#define DUK_HTHREAD_STRING_RANGE_ERROR(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RANGE_ERROR)
#define DUK_HEAP_STRING_EVAL_ERROR(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVAL_ERROR)
#define DUK_HTHREAD_STRING_EVAL_ERROR(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVAL_ERROR)
#define DUK_HEAP_STRING_BREAK(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BREAK)
#define DUK_HTHREAD_STRING_BREAK(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BREAK)
#define DUK_HEAP_STRING_CASE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CASE)
#define DUK_HTHREAD_STRING_CASE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CASE)
#define DUK_HEAP_STRING_CATCH(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CATCH)
#define DUK_HTHREAD_STRING_CATCH(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CATCH)
#define DUK_HEAP_STRING_CONTINUE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONTINUE)
#define DUK_HTHREAD_STRING_CONTINUE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONTINUE)
#define DUK_HEAP_STRING_DEBUGGER(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEBUGGER)
#define DUK_HTHREAD_STRING_DEBUGGER(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEBUGGER)
#define DUK_HEAP_STRING_DEFAULT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFAULT)
#define DUK_HTHREAD_STRING_DEFAULT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFAULT)
#define DUK_HEAP_STRING_DELETE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DELETE)
#define DUK_HTHREAD_STRING_DELETE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DELETE)
#define DUK_HEAP_STRING_DO(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DO)
#define DUK_HTHREAD_STRING_DO(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DO)
#define DUK_HEAP_STRING_ELSE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ELSE)
#define DUK_HTHREAD_STRING_ELSE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ELSE)
#define DUK_HEAP_STRING_FINALLY(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FINALLY)
#define DUK_HTHREAD_STRING_FINALLY(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FINALLY)
#define DUK_HEAP_STRING_FOR(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FOR)
#define DUK_HTHREAD_STRING_FOR(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FOR)
#define DUK_HEAP_STRING_LC_FUNCTION(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_FUNCTION)
#define DUK_HTHREAD_STRING_LC_FUNCTION(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_FUNCTION)
#define DUK_HEAP_STRING_IF(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IF)
#define DUK_HTHREAD_STRING_IF(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IF)
#define DUK_HEAP_STRING_IN(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IN)
#define DUK_HTHREAD_STRING_IN(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IN)
#define DUK_HEAP_STRING_INSTANCEOF(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INSTANCEOF)
#define DUK_HTHREAD_STRING_INSTANCEOF(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INSTANCEOF)
#define DUK_HEAP_STRING_NEW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEW)
#define DUK_HTHREAD_STRING_NEW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEW)
#define DUK_HEAP_STRING_RETURN(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RETURN)
#define DUK_HTHREAD_STRING_RETURN(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RETURN)
#define DUK_HEAP_STRING_SWITCH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SWITCH)
#define DUK_HTHREAD_STRING_SWITCH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SWITCH)
#define DUK_HEAP_STRING_THIS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THIS)
#define DUK_HTHREAD_STRING_THIS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THIS)
#define DUK_HEAP_STRING_THROW(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THROW)
#define DUK_HTHREAD_STRING_THROW(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THROW)
#define DUK_HEAP_STRING_TRY(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRY)
#define DUK_HTHREAD_STRING_TRY(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRY)
#define DUK_HEAP_STRING_TYPEOF(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPEOF)
#define DUK_HTHREAD_STRING_TYPEOF(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPEOF)
#define DUK_HEAP_STRING_VAR(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VAR)
#define DUK_HTHREAD_STRING_VAR(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VAR)
#define DUK_HEAP_STRING_CONST(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONST)
#define DUK_HTHREAD_STRING_CONST(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONST)
#define DUK_HEAP_STRING_VOID(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VOID)
#define DUK_HTHREAD_STRING_VOID(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VOID)
#define DUK_HEAP_STRING_WHILE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WHILE)
#define DUK_HTHREAD_STRING_WHILE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WHILE)
#define DUK_HEAP_STRING_WITH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WITH)
#define DUK_HTHREAD_STRING_WITH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WITH)
#define DUK_HEAP_STRING_CLASS(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CLASS)
#define DUK_HTHREAD_STRING_CLASS(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CLASS)
#define DUK_HEAP_STRING_ENUM(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUM)
#define DUK_HTHREAD_STRING_ENUM(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUM)
#define DUK_HEAP_STRING_EXPORT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXPORT)
#define DUK_HTHREAD_STRING_EXPORT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXPORT)
#define DUK_HEAP_STRING_EXTENDS(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXTENDS)
#define DUK_HTHREAD_STRING_EXTENDS(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXTENDS)
#define DUK_HEAP_STRING_IMPORT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IMPORT)
#define DUK_HTHREAD_STRING_IMPORT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IMPORT)
#define DUK_HEAP_STRING_SUPER(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUPER)
#define DUK_HTHREAD_STRING_SUPER(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUPER)
#define DUK_HEAP_STRING_LC_NULL(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_NULL)
#define DUK_HTHREAD_STRING_LC_NULL(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_NULL)
#define DUK_HEAP_STRING_TRUE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRUE)
#define DUK_HTHREAD_STRING_TRUE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRUE)
#define DUK_HEAP_STRING_FALSE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FALSE)
#define DUK_HTHREAD_STRING_FALSE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FALSE)
#define DUK_HEAP_STRING_IMPLEMENTS(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IMPLEMENTS)
#define DUK_HTHREAD_STRING_IMPLEMENTS(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IMPLEMENTS)
#define DUK_HEAP_STRING_INTERFACE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INTERFACE)
#define DUK_HTHREAD_STRING_INTERFACE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INTERFACE)
#define DUK_HEAP_STRING_LET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LET)
#define DUK_HTHREAD_STRING_LET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LET)
#define DUK_HEAP_STRING_PACKAGE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PACKAGE)
#define DUK_HTHREAD_STRING_PACKAGE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PACKAGE)
#define DUK_HEAP_STRING_PRIVATE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PRIVATE)
#define DUK_HTHREAD_STRING_PRIVATE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PRIVATE)
#define DUK_HEAP_STRING_PROTECTED(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROTECTED)
#define DUK_HTHREAD_STRING_PROTECTED(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROTECTED)
#define DUK_HEAP_STRING_PUBLIC(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PUBLIC)
#define DUK_HTHREAD_STRING_PUBLIC(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PUBLIC)
#define DUK_HEAP_STRING_STATIC(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STATIC)
#define DUK_HTHREAD_STRING_STATIC(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STATIC)
#define DUK_HEAP_STRING_YIELD(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_YIELD)
#define DUK_HTHREAD_STRING_YIELD(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_YIELD)

#define DUK_HEAP_NUM_STRINGS                                          414

#define DUK_STRIDX_START_RESERVED                                     369
#define DUK_STRIDX_START_STRICT_RESERVED                              405
#define DUK_STRIDX_END_RESERVED                                       414                            /* exclusive endpoint */

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const duk_c_function duk_bi_native_functions[149];
DUK_INTERNAL_DECL const duk_uint8_t duk_builtins_data[1955];
#ifdef DUK_USE_BUILTIN_INITJS
DUK_INTERNAL_DECL const duk_uint8_t duk_initjs_data[187];
#endif  /* DUK_USE_BUILTIN_INITJS */
#endif  /* !DUK_SINGLE_FILE */

#define DUK_BUILTINS_DATA_LENGTH                                      1955
#ifdef DUK_USE_BUILTIN_INITJS
#define DUK_BUILTIN_INITJS_DATA_LENGTH                                187
#endif  /* DUK_USE_BUILTIN_INITJS */

#define DUK_BIDX_GLOBAL                                               0
#define DUK_BIDX_GLOBAL_ENV                                           1
#define DUK_BIDX_OBJECT_CONSTRUCTOR                                   2
#define DUK_BIDX_OBJECT_PROTOTYPE                                     3
#define DUK_BIDX_FUNCTION_CONSTRUCTOR                                 4
#define DUK_BIDX_FUNCTION_PROTOTYPE                                   5
#define DUK_BIDX_ARRAY_CONSTRUCTOR                                    6
#define DUK_BIDX_ARRAY_PROTOTYPE                                      7
#define DUK_BIDX_STRING_CONSTRUCTOR                                   8
#define DUK_BIDX_STRING_PROTOTYPE                                     9
#define DUK_BIDX_BOOLEAN_CONSTRUCTOR                                  10
#define DUK_BIDX_BOOLEAN_PROTOTYPE                                    11
#define DUK_BIDX_NUMBER_CONSTRUCTOR                                   12
#define DUK_BIDX_NUMBER_PROTOTYPE                                     13
#define DUK_BIDX_DATE_CONSTRUCTOR                                     14
#define DUK_BIDX_DATE_PROTOTYPE                                       15
#define DUK_BIDX_REGEXP_CONSTRUCTOR                                   16
#define DUK_BIDX_REGEXP_PROTOTYPE                                     17
#define DUK_BIDX_ERROR_CONSTRUCTOR                                    18
#define DUK_BIDX_ERROR_PROTOTYPE                                      19
#define DUK_BIDX_EVAL_ERROR_CONSTRUCTOR                               20
#define DUK_BIDX_EVAL_ERROR_PROTOTYPE                                 21
#define DUK_BIDX_RANGE_ERROR_CONSTRUCTOR                              22
#define DUK_BIDX_RANGE_ERROR_PROTOTYPE                                23
#define DUK_BIDX_REFERENCE_ERROR_CONSTRUCTOR                          24
#define DUK_BIDX_REFERENCE_ERROR_PROTOTYPE                            25
#define DUK_BIDX_SYNTAX_ERROR_CONSTRUCTOR                             26
#define DUK_BIDX_SYNTAX_ERROR_PROTOTYPE                               27
#define DUK_BIDX_TYPE_ERROR_CONSTRUCTOR                               28
#define DUK_BIDX_TYPE_ERROR_PROTOTYPE                                 29
#define DUK_BIDX_URI_ERROR_CONSTRUCTOR                                30
#define DUK_BIDX_URI_ERROR_PROTOTYPE                                  31
#define DUK_BIDX_MATH                                                 32
#define DUK_BIDX_JSON                                                 33
#define DUK_BIDX_TYPE_ERROR_THROWER                                   34
#define DUK_BIDX_PROXY_CONSTRUCTOR                                    35
#define DUK_BIDX_DUKTAPE                                              36
#define DUK_BIDX_THREAD_CONSTRUCTOR                                   37
#define DUK_BIDX_THREAD_PROTOTYPE                                     38
#define DUK_BIDX_BUFFER_CONSTRUCTOR                                   39
#define DUK_BIDX_BUFFER_PROTOTYPE                                     40
#define DUK_BIDX_POINTER_CONSTRUCTOR                                  41
#define DUK_BIDX_POINTER_PROTOTYPE                                    42
#define DUK_BIDX_LOGGER_CONSTRUCTOR                                   43
#define DUK_BIDX_LOGGER_PROTOTYPE                                     44
#define DUK_BIDX_DOUBLE_ERROR                                         45
#define DUK_BIDX_ARRAYBUFFER_CONSTRUCTOR                              46
#define DUK_BIDX_ARRAYBUFFER_PROTOTYPE                                47
#define DUK_BIDX_DATAVIEW_CONSTRUCTOR                                 48
#define DUK_BIDX_DATAVIEW_PROTOTYPE                                   49
#define DUK_BIDX_TYPEDARRAY_PROTOTYPE                                 50
#define DUK_BIDX_INT8ARRAY_CONSTRUCTOR                                51
#define DUK_BIDX_INT8ARRAY_PROTOTYPE                                  52
#define DUK_BIDX_UINT8ARRAY_CONSTRUCTOR                               53
#define DUK_BIDX_UINT8ARRAY_PROTOTYPE                                 54
#define DUK_BIDX_UINT8CLAMPEDARRAY_CONSTRUCTOR                        55
#define DUK_BIDX_UINT8CLAMPEDARRAY_PROTOTYPE                          56
#define DUK_BIDX_INT16ARRAY_CONSTRUCTOR                               57
#define DUK_BIDX_INT16ARRAY_PROTOTYPE                                 58
#define DUK_BIDX_UINT16ARRAY_CONSTRUCTOR                              59
#define DUK_BIDX_UINT16ARRAY_PROTOTYPE                                60
#define DUK_BIDX_INT32ARRAY_CONSTRUCTOR                               61
#define DUK_BIDX_INT32ARRAY_PROTOTYPE                                 62
#define DUK_BIDX_UINT32ARRAY_CONSTRUCTOR                              63
#define DUK_BIDX_UINT32ARRAY_PROTOTYPE                                64
#define DUK_BIDX_FLOAT32ARRAY_CONSTRUCTOR                             65
#define DUK_BIDX_FLOAT32ARRAY_PROTOTYPE                               66
#define DUK_BIDX_FLOAT64ARRAY_CONSTRUCTOR                             67
#define DUK_BIDX_FLOAT64ARRAY_PROTOTYPE                               68
#define DUK_BIDX_NODEJS_BUFFER_CONSTRUCTOR                            69
#define DUK_BIDX_NODEJS_BUFFER_PROTOTYPE                              70

#define DUK_NUM_BUILTINS                                              71

#elif defined(DUK_USE_DOUBLE_BE)
#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const duk_uint8_t duk_strings_data[2624];
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STRDATA_DATA_LENGTH                                       2624
#define DUK_STRDATA_MAX_STRLEN                                        24

#define DUK_STRIDX_UC_LOGGER                                          0                              /* 'Logger' */
#define DUK_STRIDX_UC_THREAD                                          1                              /* 'Thread' */
#define DUK_STRIDX_UC_POINTER                                         2                              /* 'Pointer' */
#define DUK_STRIDX_DEC_ENV                                            3                              /* 'DecEnv' */
#define DUK_STRIDX_OBJ_ENV                                            4                              /* 'ObjEnv' */
#define DUK_STRIDX_FLOAT64_ARRAY                                      5                              /* 'Float64Array' */
#define DUK_STRIDX_FLOAT32_ARRAY                                      6                              /* 'Float32Array' */
#define DUK_STRIDX_UINT32_ARRAY                                       7                              /* 'Uint32Array' */
#define DUK_STRIDX_INT32_ARRAY                                        8                              /* 'Int32Array' */
#define DUK_STRIDX_UINT16_ARRAY                                       9                              /* 'Uint16Array' */
#define DUK_STRIDX_INT16_ARRAY                                        10                             /* 'Int16Array' */
#define DUK_STRIDX_UINT8_CLAMPED_ARRAY                                11                             /* 'Uint8ClampedArray' */
#define DUK_STRIDX_UINT8_ARRAY                                        12                             /* 'Uint8Array' */
#define DUK_STRIDX_INT8_ARRAY                                         13                             /* 'Int8Array' */
#define DUK_STRIDX_DATA_VIEW                                          14                             /* 'DataView' */
#define DUK_STRIDX_ARRAY_BUFFER                                       15                             /* 'ArrayBuffer' */
#define DUK_STRIDX_UC_BUFFER                                          16                             /* 'Buffer' */
#define DUK_STRIDX_EMPTY_STRING                                       17                             /* '' */
#define DUK_STRIDX_GLOBAL                                             18                             /* 'global' */
#define DUK_STRIDX_UC_ARGUMENTS                                       19                             /* 'Arguments' */
#define DUK_STRIDX_JSON                                               20                             /* 'JSON' */
#define DUK_STRIDX_MATH                                               21                             /* 'Math' */
#define DUK_STRIDX_UC_ERROR                                           22                             /* 'Error' */
#define DUK_STRIDX_REG_EXP                                            23                             /* 'RegExp' */
#define DUK_STRIDX_DATE                                               24                             /* 'Date' */
#define DUK_STRIDX_UC_NUMBER                                          25                             /* 'Number' */
#define DUK_STRIDX_UC_BOOLEAN                                         26                             /* 'Boolean' */
#define DUK_STRIDX_UC_STRING                                          27                             /* 'String' */
#define DUK_STRIDX_ARRAY                                              28                             /* 'Array' */
#define DUK_STRIDX_UC_FUNCTION                                        29                             /* 'Function' */
#define DUK_STRIDX_UC_OBJECT                                          30                             /* 'Object' */
#define DUK_STRIDX_UC_NULL                                            31                             /* 'Null' */
#define DUK_STRIDX_UC_UNDEFINED                                       32                             /* 'Undefined' */
#define DUK_STRIDX_JSON_EXT_FUNCTION2                                 33                             /* '{_func:true}' */
#define DUK_STRIDX_JSON_EXT_FUNCTION1                                 34                             /* '{"_func":true}' */
#define DUK_STRIDX_JSON_EXT_NEGINF                                    35                             /* '{"_ninf":true}' */
#define DUK_STRIDX_JSON_EXT_POSINF                                    36                             /* '{"_inf":true}' */
#define DUK_STRIDX_JSON_EXT_NAN                                       37                             /* '{"_nan":true}' */
#define DUK_STRIDX_JSON_EXT_UNDEFINED                                 38                             /* '{"_undef":true}' */
#define DUK_STRIDX_TO_LOG_STRING                                      39                             /* 'toLogString' */
#define DUK_STRIDX_CLOG                                               40                             /* 'clog' */
#define DUK_STRIDX_LC_L                                               41                             /* 'l' */
#define DUK_STRIDX_LC_N                                               42                             /* 'n' */
#define DUK_STRIDX_LC_FATAL                                           43                             /* 'fatal' */
#define DUK_STRIDX_LC_ERROR                                           44                             /* 'error' */
#define DUK_STRIDX_LC_WARN                                            45                             /* 'warn' */
#define DUK_STRIDX_LC_DEBUG                                           46                             /* 'debug' */
#define DUK_STRIDX_LC_TRACE                                           47                             /* 'trace' */
#define DUK_STRIDX_RAW                                                48                             /* 'raw' */
#define DUK_STRIDX_FMT                                                49                             /* 'fmt' */
#define DUK_STRIDX_CURRENT                                            50                             /* 'current' */
#define DUK_STRIDX_RESUME                                             51                             /* 'resume' */
#define DUK_STRIDX_COMPACT                                            52                             /* 'compact' */
#define DUK_STRIDX_JC                                                 53                             /* 'jc' */
#define DUK_STRIDX_JX                                                 54                             /* 'jx' */
#define DUK_STRIDX_BASE64                                             55                             /* 'base64' */
#define DUK_STRIDX_HEX                                                56                             /* 'hex' */
#define DUK_STRIDX_DEC                                                57                             /* 'dec' */
#define DUK_STRIDX_ENC                                                58                             /* 'enc' */
#define DUK_STRIDX_FIN                                                59                             /* 'fin' */
#define DUK_STRIDX_GC                                                 60                             /* 'gc' */
#define DUK_STRIDX_ACT                                                61                             /* 'act' */
#define DUK_STRIDX_LC_INFO                                            62                             /* 'info' */
#define DUK_STRIDX_VERSION                                            63                             /* 'version' */
#define DUK_STRIDX_ENV                                                64                             /* 'env' */
#define DUK_STRIDX_MOD_LOADED                                         65                             /* 'modLoaded' */
#define DUK_STRIDX_MOD_SEARCH                                         66                             /* 'modSearch' */
#define DUK_STRIDX_ERR_THROW                                          67                             /* 'errThrow' */
#define DUK_STRIDX_ERR_CREATE                                         68                             /* 'errCreate' */
#define DUK_STRIDX_COMPILE                                            69                             /* 'compile' */
#define DUK_STRIDX_INT_REGBASE                                        70                             /* '\x00Regbase' */
#define DUK_STRIDX_INT_THREAD                                         71                             /* '\x00Thread' */
#define DUK_STRIDX_INT_HANDLER                                        72                             /* '\x00Handler' */
#define DUK_STRIDX_INT_FINALIZER                                      73                             /* '\x00Finalizer' */
#define DUK_STRIDX_INT_CALLEE                                         74                             /* '\x00Callee' */
#define DUK_STRIDX_INT_MAP                                            75                             /* '\x00Map' */
#define DUK_STRIDX_INT_ARGS                                           76                             /* '\x00Args' */
#define DUK_STRIDX_INT_THIS                                           77                             /* '\x00This' */
#define DUK_STRIDX_INT_PC2LINE                                        78                             /* '\x00Pc2line' */
#define DUK_STRIDX_INT_SOURCE                                         79                             /* '\x00Source' */
#define DUK_STRIDX_INT_VARENV                                         80                             /* '\x00Varenv' */
#define DUK_STRIDX_INT_LEXENV                                         81                             /* '\x00Lexenv' */
#define DUK_STRIDX_INT_VARMAP                                         82                             /* '\x00Varmap' */
#define DUK_STRIDX_INT_FORMALS                                        83                             /* '\x00Formals' */
#define DUK_STRIDX_INT_BYTECODE                                       84                             /* '\x00Bytecode' */
#define DUK_STRIDX_INT_NEXT                                           85                             /* '\x00Next' */
#define DUK_STRIDX_INT_TARGET                                         86                             /* '\x00Target' */
#define DUK_STRIDX_INT_VALUE                                          87                             /* '\x00Value' */
#define DUK_STRIDX_LC_POINTER                                         88                             /* 'pointer' */
#define DUK_STRIDX_INT_TRACEDATA                                      89                             /* '\x00Tracedata' */
#define DUK_STRIDX_LINE_NUMBER                                        90                             /* 'lineNumber' */
#define DUK_STRIDX_FILE_NAME                                          91                             /* 'fileName' */
#define DUK_STRIDX_PC                                                 92                             /* 'pc' */
#define DUK_STRIDX_STACK                                              93                             /* 'stack' */
#define DUK_STRIDX_THROW_TYPE_ERROR                                   94                             /* 'ThrowTypeError' */
#define DUK_STRIDX_DUKTAPE                                            95                             /* 'Duktape' */
#define DUK_STRIDX_SET_FLOAT64                                        96                             /* 'setFloat64' */
#define DUK_STRIDX_SET_FLOAT32                                        97                             /* 'setFloat32' */
#define DUK_STRIDX_SET_UINT32                                         98                             /* 'setUint32' */
#define DUK_STRIDX_SET_INT32                                          99                             /* 'setInt32' */
#define DUK_STRIDX_SET_UINT16                                         100                            /* 'setUint16' */
#define DUK_STRIDX_SET_INT16                                          101                            /* 'setInt16' */
#define DUK_STRIDX_SET_UINT8                                          102                            /* 'setUint8' */
#define DUK_STRIDX_SET_INT8                                           103                            /* 'setInt8' */
#define DUK_STRIDX_GET_FLOAT64                                        104                            /* 'getFloat64' */
#define DUK_STRIDX_GET_FLOAT32                                        105                            /* 'getFloat32' */
#define DUK_STRIDX_GET_UINT32                                         106                            /* 'getUint32' */
#define DUK_STRIDX_GET_INT32                                          107                            /* 'getInt32' */
#define DUK_STRIDX_GET_UINT16                                         108                            /* 'getUint16' */
#define DUK_STRIDX_GET_INT16                                          109                            /* 'getInt16' */
#define DUK_STRIDX_GET_UINT8                                          110                            /* 'getUint8' */
#define DUK_STRIDX_GET_INT8                                           111                            /* 'getInt8' */
#define DUK_STRIDX_SUBARRAY                                           112                            /* 'subarray' */
#define DUK_STRIDX_BYTES_PER_ELEMENT                                  113                            /* 'BYTES_PER_ELEMENT' */
#define DUK_STRIDX_BYTE_OFFSET                                        114                            /* 'byteOffset' */
#define DUK_STRIDX_LC_BUFFER                                          115                            /* 'buffer' */
#define DUK_STRIDX_IS_VIEW                                            116                            /* 'isView' */
#define DUK_STRIDX_DATA                                               117                            /* 'data' */
#define DUK_STRIDX_TYPE                                               118                            /* 'type' */
#define DUK_STRIDX_WRITE_INT_BE                                       119                            /* 'writeIntBE' */
#define DUK_STRIDX_WRITE_INT_LE                                       120                            /* 'writeIntLE' */
#define DUK_STRIDX_WRITE_UINT_BE                                      121                            /* 'writeUIntBE' */
#define DUK_STRIDX_WRITE_UINT_LE                                      122                            /* 'writeUIntLE' */
#define DUK_STRIDX_WRITE_DOUBLE_BE                                    123                            /* 'writeDoubleBE' */
#define DUK_STRIDX_WRITE_DOUBLE_LE                                    124                            /* 'writeDoubleLE' */
#define DUK_STRIDX_WRITE_FLOAT_BE                                     125                            /* 'writeFloatBE' */
#define DUK_STRIDX_WRITE_FLOAT_LE                                     126                            /* 'writeFloatLE' */
#define DUK_STRIDX_WRITE_INT32_BE                                     127                            /* 'writeInt32BE' */
#define DUK_STRIDX_WRITE_INT32_LE                                     128                            /* 'writeInt32LE' */
#define DUK_STRIDX_WRITE_UINT32_BE                                    129                            /* 'writeUInt32BE' */
#define DUK_STRIDX_WRITE_UINT32_LE                                    130                            /* 'writeUInt32LE' */
#define DUK_STRIDX_WRITE_INT16_BE                                     131                            /* 'writeInt16BE' */
#define DUK_STRIDX_WRITE_INT16_LE                                     132                            /* 'writeInt16LE' */
#define DUK_STRIDX_WRITE_UINT16_BE                                    133                            /* 'writeUInt16BE' */
#define DUK_STRIDX_WRITE_UINT16_LE                                    134                            /* 'writeUInt16LE' */
#define DUK_STRIDX_WRITE_INT8                                         135                            /* 'writeInt8' */
#define DUK_STRIDX_WRITE_UINT8                                        136                            /* 'writeUInt8' */
#define DUK_STRIDX_READ_INT_BE                                        137                            /* 'readIntBE' */
#define DUK_STRIDX_READ_INT_LE                                        138                            /* 'readIntLE' */
#define DUK_STRIDX_READ_UINT_BE                                       139                            /* 'readUIntBE' */
#define DUK_STRIDX_READ_UINT_LE                                       140                            /* 'readUIntLE' */
#define DUK_STRIDX_READ_DOUBLE_BE                                     141                            /* 'readDoubleBE' */
#define DUK_STRIDX_READ_DOUBLE_LE                                     142                            /* 'readDoubleLE' */
#define DUK_STRIDX_READ_FLOAT_BE                                      143                            /* 'readFloatBE' */
#define DUK_STRIDX_READ_FLOAT_LE                                      144                            /* 'readFloatLE' */
#define DUK_STRIDX_READ_INT32_BE                                      145                            /* 'readInt32BE' */
#define DUK_STRIDX_READ_INT32_LE                                      146                            /* 'readInt32LE' */
#define DUK_STRIDX_READ_UINT32_BE                                     147                            /* 'readUInt32BE' */
#define DUK_STRIDX_READ_UINT32_LE                                     148                            /* 'readUInt32LE' */
#define DUK_STRIDX_READ_INT16_BE                                      149                            /* 'readInt16BE' */
#define DUK_STRIDX_READ_INT16_LE                                      150                            /* 'readInt16LE' */
#define DUK_STRIDX_READ_UINT16_BE                                     151                            /* 'readUInt16BE' */
#define DUK_STRIDX_READ_UINT16_LE                                     152                            /* 'readUInt16LE' */
#define DUK_STRIDX_READ_INT8                                          153                            /* 'readInt8' */
#define DUK_STRIDX_READ_UINT8                                         154                            /* 'readUInt8' */
#define DUK_STRIDX_COPY                                               155                            /* 'copy' */
#define DUK_STRIDX_EQUALS                                             156                            /* 'equals' */
#define DUK_STRIDX_FILL                                               157                            /* 'fill' */
#define DUK_STRIDX_WRITE                                              158                            /* 'write' */
#define DUK_STRIDX_COMPARE                                            159                            /* 'compare' */
#define DUK_STRIDX_BYTE_LENGTH                                        160                            /* 'byteLength' */
#define DUK_STRIDX_IS_BUFFER                                          161                            /* 'isBuffer' */
#define DUK_STRIDX_IS_ENCODING                                        162                            /* 'isEncoding' */
#define DUK_STRIDX_EXPORTS                                            163                            /* 'exports' */
#define DUK_STRIDX_ID                                                 164                            /* 'id' */
#define DUK_STRIDX_REQUIRE                                            165                            /* 'require' */
#define DUK_STRIDX___PROTO__                                          166                            /* '__proto__' */
#define DUK_STRIDX_SET_PROTOTYPE_OF                                   167                            /* 'setPrototypeOf' */
#define DUK_STRIDX_OWN_KEYS                                           168                            /* 'ownKeys' */
#define DUK_STRIDX_ENUMERATE                                          169                            /* 'enumerate' */
#define DUK_STRIDX_DELETE_PROPERTY                                    170                            /* 'deleteProperty' */
#define DUK_STRIDX_HAS                                                171                            /* 'has' */
#define DUK_STRIDX_PROXY                                              172                            /* 'Proxy' */
#define DUK_STRIDX_CALLEE                                             173                            /* 'callee' */
#define DUK_STRIDX_INVALID_DATE                                       174                            /* 'Invalid Date' */
#define DUK_STRIDX_BRACKETED_ELLIPSIS                                 175                            /* '[...]' */
#define DUK_STRIDX_NEWLINE_TAB                                        176                            /* '\n\t' */
#define DUK_STRIDX_SPACE                                              177                            /* ' ' */
#define DUK_STRIDX_COMMA                                              178                            /* ',' */
#define DUK_STRIDX_MINUS_ZERO                                         179                            /* '-0' */
#define DUK_STRIDX_PLUS_ZERO                                          180                            /* '+0' */
#define DUK_STRIDX_ZERO                                               181                            /* '0' */
#define DUK_STRIDX_MINUS_INFINITY                                     182                            /* '-Infinity' */
#define DUK_STRIDX_PLUS_INFINITY                                      183                            /* '+Infinity' */
#define DUK_STRIDX_INFINITY                                           184                            /* 'Infinity' */
#define DUK_STRIDX_LC_OBJECT                                          185                            /* 'object' */
#define DUK_STRIDX_LC_STRING                                          186                            /* 'string' */
#define DUK_STRIDX_LC_NUMBER                                          187                            /* 'number' */
#define DUK_STRIDX_LC_BOOLEAN                                         188                            /* 'boolean' */
#define DUK_STRIDX_LC_UNDEFINED                                       189                            /* 'undefined' */
#define DUK_STRIDX_STRINGIFY                                          190                            /* 'stringify' */
#define DUK_STRIDX_TAN                                                191                            /* 'tan' */
#define DUK_STRIDX_SQRT                                               192                            /* 'sqrt' */
#define DUK_STRIDX_SIN                                                193                            /* 'sin' */
#define DUK_STRIDX_ROUND                                              194                            /* 'round' */
#define DUK_STRIDX_RANDOM                                             195                            /* 'random' */
#define DUK_STRIDX_POW                                                196                            /* 'pow' */
#define DUK_STRIDX_MIN                                                197                            /* 'min' */
#define DUK_STRIDX_MAX                                                198                            /* 'max' */
#define DUK_STRIDX_LOG                                                199                            /* 'log' */
#define DUK_STRIDX_FLOOR                                              200                            /* 'floor' */
#define DUK_STRIDX_EXP                                                201                            /* 'exp' */
#define DUK_STRIDX_COS                                                202                            /* 'cos' */
#define DUK_STRIDX_CEIL                                               203                            /* 'ceil' */
#define DUK_STRIDX_ATAN2                                              204                            /* 'atan2' */
#define DUK_STRIDX_ATAN                                               205                            /* 'atan' */
#define DUK_STRIDX_ASIN                                               206                            /* 'asin' */
#define DUK_STRIDX_ACOS                                               207                            /* 'acos' */
#define DUK_STRIDX_ABS                                                208                            /* 'abs' */
#define DUK_STRIDX_SQRT2                                              209                            /* 'SQRT2' */
#define DUK_STRIDX_SQRT1_2                                            210                            /* 'SQRT1_2' */
#define DUK_STRIDX_PI                                                 211                            /* 'PI' */
#define DUK_STRIDX_LOG10E                                             212                            /* 'LOG10E' */
#define DUK_STRIDX_LOG2E                                              213                            /* 'LOG2E' */
#define DUK_STRIDX_LN2                                                214                            /* 'LN2' */
#define DUK_STRIDX_LN10                                               215                            /* 'LN10' */
#define DUK_STRIDX_E                                                  216                            /* 'E' */
#define DUK_STRIDX_MESSAGE                                            217                            /* 'message' */
#define DUK_STRIDX_NAME                                               218                            /* 'name' */
#define DUK_STRIDX_INPUT                                              219                            /* 'input' */
#define DUK_STRIDX_INDEX                                              220                            /* 'index' */
#define DUK_STRIDX_ESCAPED_EMPTY_REGEXP                               221                            /* '(?:)' */
#define DUK_STRIDX_LAST_INDEX                                         222                            /* 'lastIndex' */
#define DUK_STRIDX_MULTILINE                                          223                            /* 'multiline' */
#define DUK_STRIDX_IGNORE_CASE                                        224                            /* 'ignoreCase' */
#define DUK_STRIDX_SOURCE                                             225                            /* 'source' */
#define DUK_STRIDX_TEST                                               226                            /* 'test' */
#define DUK_STRIDX_EXEC                                               227                            /* 'exec' */
#define DUK_STRIDX_TO_GMT_STRING                                      228                            /* 'toGMTString' */
#define DUK_STRIDX_SET_YEAR                                           229                            /* 'setYear' */
#define DUK_STRIDX_GET_YEAR                                           230                            /* 'getYear' */
#define DUK_STRIDX_TO_JSON                                            231                            /* 'toJSON' */
#define DUK_STRIDX_TO_ISO_STRING                                      232                            /* 'toISOString' */
#define DUK_STRIDX_TO_UTC_STRING                                      233                            /* 'toUTCString' */
#define DUK_STRIDX_SET_UTC_FULL_YEAR                                  234                            /* 'setUTCFullYear' */
#define DUK_STRIDX_SET_FULL_YEAR                                      235                            /* 'setFullYear' */
#define DUK_STRIDX_SET_UTC_MONTH                                      236                            /* 'setUTCMonth' */
#define DUK_STRIDX_SET_MONTH                                          237                            /* 'setMonth' */
#define DUK_STRIDX_SET_UTC_DATE                                       238                            /* 'setUTCDate' */
#define DUK_STRIDX_SET_DATE                                           239                            /* 'setDate' */
#define DUK_STRIDX_SET_UTC_HOURS                                      240                            /* 'setUTCHours' */
#define DUK_STRIDX_SET_HOURS                                          241                            /* 'setHours' */
#define DUK_STRIDX_SET_UTC_MINUTES                                    242                            /* 'setUTCMinutes' */
#define DUK_STRIDX_SET_MINUTES                                        243                            /* 'setMinutes' */
#define DUK_STRIDX_SET_UTC_SECONDS                                    244                            /* 'setUTCSeconds' */
#define DUK_STRIDX_SET_SECONDS                                        245                            /* 'setSeconds' */
#define DUK_STRIDX_SET_UTC_MILLISECONDS                               246                            /* 'setUTCMilliseconds' */
#define DUK_STRIDX_SET_MILLISECONDS                                   247                            /* 'setMilliseconds' */
#define DUK_STRIDX_SET_TIME                                           248                            /* 'setTime' */
#define DUK_STRIDX_GET_TIMEZONE_OFFSET                                249                            /* 'getTimezoneOffset' */
#define DUK_STRIDX_GET_UTC_MILLISECONDS                               250                            /* 'getUTCMilliseconds' */
#define DUK_STRIDX_GET_MILLISECONDS                                   251                            /* 'getMilliseconds' */
#define DUK_STRIDX_GET_UTC_SECONDS                                    252                            /* 'getUTCSeconds' */
#define DUK_STRIDX_GET_SECONDS                                        253                            /* 'getSeconds' */
#define DUK_STRIDX_GET_UTC_MINUTES                                    254                            /* 'getUTCMinutes' */
#define DUK_STRIDX_GET_MINUTES                                        255                            /* 'getMinutes' */
#define DUK_STRIDX_GET_UTC_HOURS                                      256                            /* 'getUTCHours' */
#define DUK_STRIDX_GET_HOURS                                          257                            /* 'getHours' */
#define DUK_STRIDX_GET_UTC_DAY                                        258                            /* 'getUTCDay' */
#define DUK_STRIDX_GET_DAY                                            259                            /* 'getDay' */
#define DUK_STRIDX_GET_UTC_DATE                                       260                            /* 'getUTCDate' */
#define DUK_STRIDX_GET_DATE                                           261                            /* 'getDate' */
#define DUK_STRIDX_GET_UTC_MONTH                                      262                            /* 'getUTCMonth' */
#define DUK_STRIDX_GET_MONTH                                          263                            /* 'getMonth' */
#define DUK_STRIDX_GET_UTC_FULL_YEAR                                  264                            /* 'getUTCFullYear' */
#define DUK_STRIDX_GET_FULL_YEAR                                      265                            /* 'getFullYear' */
#define DUK_STRIDX_GET_TIME                                           266                            /* 'getTime' */
#define DUK_STRIDX_TO_LOCALE_TIME_STRING                              267                            /* 'toLocaleTimeString' */
#define DUK_STRIDX_TO_LOCALE_DATE_STRING                              268                            /* 'toLocaleDateString' */
#define DUK_STRIDX_TO_TIME_STRING                                     269                            /* 'toTimeString' */
#define DUK_STRIDX_TO_DATE_STRING                                     270                            /* 'toDateString' */
#define DUK_STRIDX_NOW                                                271                            /* 'now' */
#define DUK_STRIDX_UTC                                                272                            /* 'UTC' */
#define DUK_STRIDX_PARSE                                              273                            /* 'parse' */
#define DUK_STRIDX_TO_PRECISION                                       274                            /* 'toPrecision' */
#define DUK_STRIDX_TO_EXPONENTIAL                                     275                            /* 'toExponential' */
#define DUK_STRIDX_TO_FIXED                                           276                            /* 'toFixed' */
#define DUK_STRIDX_POSITIVE_INFINITY                                  277                            /* 'POSITIVE_INFINITY' */
#define DUK_STRIDX_NEGATIVE_INFINITY                                  278                            /* 'NEGATIVE_INFINITY' */
#define DUK_STRIDX_NAN                                                279                            /* 'NaN' */
#define DUK_STRIDX_MIN_VALUE                                          280                            /* 'MIN_VALUE' */
#define DUK_STRIDX_MAX_VALUE                                          281                            /* 'MAX_VALUE' */
#define DUK_STRIDX_SUBSTR                                             282                            /* 'substr' */
#define DUK_STRIDX_TRIM                                               283                            /* 'trim' */
#define DUK_STRIDX_TO_LOCALE_UPPER_CASE                               284                            /* 'toLocaleUpperCase' */
#define DUK_STRIDX_TO_UPPER_CASE                                      285                            /* 'toUpperCase' */
#define DUK_STRIDX_TO_LOCALE_LOWER_CASE                               286                            /* 'toLocaleLowerCase' */
#define DUK_STRIDX_TO_LOWER_CASE                                      287                            /* 'toLowerCase' */
#define DUK_STRIDX_SUBSTRING                                          288                            /* 'substring' */
#define DUK_STRIDX_SPLIT                                              289                            /* 'split' */
#define DUK_STRIDX_SEARCH                                             290                            /* 'search' */
#define DUK_STRIDX_REPLACE                                            291                            /* 'replace' */
#define DUK_STRIDX_MATCH                                              292                            /* 'match' */
#define DUK_STRIDX_LOCALE_COMPARE                                     293                            /* 'localeCompare' */
#define DUK_STRIDX_CHAR_CODE_AT                                       294                            /* 'charCodeAt' */
#define DUK_STRIDX_CHAR_AT                                            295                            /* 'charAt' */
#define DUK_STRIDX_FROM_CHAR_CODE                                     296                            /* 'fromCharCode' */
#define DUK_STRIDX_REDUCE_RIGHT                                       297                            /* 'reduceRight' */
#define DUK_STRIDX_REDUCE                                             298                            /* 'reduce' */
#define DUK_STRIDX_FILTER                                             299                            /* 'filter' */
#define DUK_STRIDX_MAP                                                300                            /* 'map' */
#define DUK_STRIDX_FOR_EACH                                           301                            /* 'forEach' */
#define DUK_STRIDX_SOME                                               302                            /* 'some' */
#define DUK_STRIDX_EVERY                                              303                            /* 'every' */
#define DUK_STRIDX_LAST_INDEX_OF                                      304                            /* 'lastIndexOf' */
#define DUK_STRIDX_INDEX_OF                                           305                            /* 'indexOf' */
#define DUK_STRIDX_UNSHIFT                                            306                            /* 'unshift' */
#define DUK_STRIDX_SPLICE                                             307                            /* 'splice' */
#define DUK_STRIDX_SORT                                               308                            /* 'sort' */
#define DUK_STRIDX_SLICE                                              309                            /* 'slice' */
#define DUK_STRIDX_SHIFT                                              310                            /* 'shift' */
#define DUK_STRIDX_REVERSE                                            311                            /* 'reverse' */
#define DUK_STRIDX_PUSH                                               312                            /* 'push' */
#define DUK_STRIDX_POP                                                313                            /* 'pop' */
#define DUK_STRIDX_JOIN                                               314                            /* 'join' */
#define DUK_STRIDX_CONCAT                                             315                            /* 'concat' */
#define DUK_STRIDX_IS_ARRAY                                           316                            /* 'isArray' */
#define DUK_STRIDX_LC_ARGUMENTS                                       317                            /* 'arguments' */
#define DUK_STRIDX_CALLER                                             318                            /* 'caller' */
#define DUK_STRIDX_BIND                                               319                            /* 'bind' */
#define DUK_STRIDX_CALL                                               320                            /* 'call' */
#define DUK_STRIDX_APPLY                                              321                            /* 'apply' */
#define DUK_STRIDX_PROPERTY_IS_ENUMERABLE                             322                            /* 'propertyIsEnumerable' */
#define DUK_STRIDX_IS_PROTOTYPE_OF                                    323                            /* 'isPrototypeOf' */
#define DUK_STRIDX_HAS_OWN_PROPERTY                                   324                            /* 'hasOwnProperty' */
#define DUK_STRIDX_VALUE_OF                                           325                            /* 'valueOf' */
#define DUK_STRIDX_TO_LOCALE_STRING                                   326                            /* 'toLocaleString' */
#define DUK_STRIDX_TO_STRING                                          327                            /* 'toString' */
#define DUK_STRIDX_CONSTRUCTOR                                        328                            /* 'constructor' */
#define DUK_STRIDX_SET                                                329                            /* 'set' */
#define DUK_STRIDX_GET                                                330                            /* 'get' */
#define DUK_STRIDX_ENUMERABLE                                         331                            /* 'enumerable' */
#define DUK_STRIDX_CONFIGURABLE                                       332                            /* 'configurable' */
#define DUK_STRIDX_WRITABLE                                           333                            /* 'writable' */
#define DUK_STRIDX_VALUE                                              334                            /* 'value' */
#define DUK_STRIDX_KEYS                                               335                            /* 'keys' */
#define DUK_STRIDX_IS_EXTENSIBLE                                      336                            /* 'isExtensible' */
#define DUK_STRIDX_IS_FROZEN                                          337                            /* 'isFrozen' */
#define DUK_STRIDX_IS_SEALED                                          338                            /* 'isSealed' */
#define DUK_STRIDX_PREVENT_EXTENSIONS                                 339                            /* 'preventExtensions' */
#define DUK_STRIDX_FREEZE                                             340                            /* 'freeze' */
#define DUK_STRIDX_SEAL                                               341                            /* 'seal' */
#define DUK_STRIDX_DEFINE_PROPERTIES                                  342                            /* 'defineProperties' */
#define DUK_STRIDX_DEFINE_PROPERTY                                    343                            /* 'defineProperty' */
#define DUK_STRIDX_CREATE                                             344                            /* 'create' */
#define DUK_STRIDX_GET_OWN_PROPERTY_NAMES                             345                            /* 'getOwnPropertyNames' */
#define DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR                        346                            /* 'getOwnPropertyDescriptor' */
#define DUK_STRIDX_GET_PROTOTYPE_OF                                   347                            /* 'getPrototypeOf' */
#define DUK_STRIDX_PROTOTYPE                                          348                            /* 'prototype' */
#define DUK_STRIDX_LENGTH                                             349                            /* 'length' */
#define DUK_STRIDX_ALERT                                              350                            /* 'alert' */
#define DUK_STRIDX_PRINT                                              351                            /* 'print' */
#define DUK_STRIDX_UNESCAPE                                           352                            /* 'unescape' */
#define DUK_STRIDX_ESCAPE                                             353                            /* 'escape' */
#define DUK_STRIDX_ENCODE_URI_COMPONENT                               354                            /* 'encodeURIComponent' */
#define DUK_STRIDX_ENCODE_URI                                         355                            /* 'encodeURI' */
#define DUK_STRIDX_DECODE_URI_COMPONENT                               356                            /* 'decodeURIComponent' */
#define DUK_STRIDX_DECODE_URI                                         357                            /* 'decodeURI' */
#define DUK_STRIDX_IS_FINITE                                          358                            /* 'isFinite' */
#define DUK_STRIDX_IS_NAN                                             359                            /* 'isNaN' */
#define DUK_STRIDX_PARSE_FLOAT                                        360                            /* 'parseFloat' */
#define DUK_STRIDX_PARSE_INT                                          361                            /* 'parseInt' */
#define DUK_STRIDX_EVAL                                               362                            /* 'eval' */
#define DUK_STRIDX_URI_ERROR                                          363                            /* 'URIError' */
#define DUK_STRIDX_TYPE_ERROR                                         364                            /* 'TypeError' */
#define DUK_STRIDX_SYNTAX_ERROR                                       365                            /* 'SyntaxError' */
#define DUK_STRIDX_REFERENCE_ERROR                                    366                            /* 'ReferenceError' */
#define DUK_STRIDX_RANGE_ERROR                                        367                            /* 'RangeError' */
#define DUK_STRIDX_EVAL_ERROR                                         368                            /* 'EvalError' */
#define DUK_STRIDX_BREAK                                              369                            /* 'break' */
#define DUK_STRIDX_CASE                                               370                            /* 'case' */
#define DUK_STRIDX_CATCH                                              371                            /* 'catch' */
#define DUK_STRIDX_CONTINUE                                           372                            /* 'continue' */
#define DUK_STRIDX_DEBUGGER                                           373                            /* 'debugger' */
#define DUK_STRIDX_DEFAULT                                            374                            /* 'default' */
#define DUK_STRIDX_DELETE                                             375                            /* 'delete' */
#define DUK_STRIDX_DO                                                 376                            /* 'do' */
#define DUK_STRIDX_ELSE                                               377                            /* 'else' */
#define DUK_STRIDX_FINALLY                                            378                            /* 'finally' */
#define DUK_STRIDX_FOR                                                379                            /* 'for' */
#define DUK_STRIDX_LC_FUNCTION                                        380                            /* 'function' */
#define DUK_STRIDX_IF                                                 381                            /* 'if' */
#define DUK_STRIDX_IN                                                 382                            /* 'in' */
#define DUK_STRIDX_INSTANCEOF                                         383                            /* 'instanceof' */
#define DUK_STRIDX_NEW                                                384                            /* 'new' */
#define DUK_STRIDX_RETURN                                             385                            /* 'return' */
#define DUK_STRIDX_SWITCH                                             386                            /* 'switch' */
#define DUK_STRIDX_THIS                                               387                            /* 'this' */
#define DUK_STRIDX_THROW                                              388                            /* 'throw' */
#define DUK_STRIDX_TRY                                                389                            /* 'try' */
#define DUK_STRIDX_TYPEOF                                             390                            /* 'typeof' */
#define DUK_STRIDX_VAR                                                391                            /* 'var' */
#define DUK_STRIDX_CONST                                              392                            /* 'const' */
#define DUK_STRIDX_VOID                                               393                            /* 'void' */
#define DUK_STRIDX_WHILE                                              394                            /* 'while' */
#define DUK_STRIDX_WITH                                               395                            /* 'with' */
#define DUK_STRIDX_CLASS                                              396                            /* 'class' */
#define DUK_STRIDX_ENUM                                               397                            /* 'enum' */
#define DUK_STRIDX_EXPORT                                             398                            /* 'export' */
#define DUK_STRIDX_EXTENDS                                            399                            /* 'extends' */
#define DUK_STRIDX_IMPORT                                             400                            /* 'import' */
#define DUK_STRIDX_SUPER                                              401                            /* 'super' */
#define DUK_STRIDX_LC_NULL                                            402                            /* 'null' */
#define DUK_STRIDX_TRUE                                               403                            /* 'true' */
#define DUK_STRIDX_FALSE                                              404                            /* 'false' */
#define DUK_STRIDX_IMPLEMENTS                                         405                            /* 'implements' */
#define DUK_STRIDX_INTERFACE                                          406                            /* 'interface' */
#define DUK_STRIDX_LET                                                407                            /* 'let' */
#define DUK_STRIDX_PACKAGE                                            408                            /* 'package' */
#define DUK_STRIDX_PRIVATE                                            409                            /* 'private' */
#define DUK_STRIDX_PROTECTED                                          410                            /* 'protected' */
#define DUK_STRIDX_PUBLIC                                             411                            /* 'public' */
#define DUK_STRIDX_STATIC                                             412                            /* 'static' */
#define DUK_STRIDX_YIELD                                              413                            /* 'yield' */

#define DUK_HEAP_STRING_UC_LOGGER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_LOGGER)
#define DUK_HTHREAD_STRING_UC_LOGGER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_LOGGER)
#define DUK_HEAP_STRING_UC_THREAD(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_THREAD)
#define DUK_HTHREAD_STRING_UC_THREAD(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_THREAD)
#define DUK_HEAP_STRING_UC_POINTER(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_POINTER)
#define DUK_HTHREAD_STRING_UC_POINTER(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_POINTER)
#define DUK_HEAP_STRING_DEC_ENV(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEC_ENV)
#define DUK_HTHREAD_STRING_DEC_ENV(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEC_ENV)
#define DUK_HEAP_STRING_OBJ_ENV(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_OBJ_ENV)
#define DUK_HTHREAD_STRING_OBJ_ENV(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_OBJ_ENV)
#define DUK_HEAP_STRING_FLOAT64_ARRAY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOAT64_ARRAY)
#define DUK_HTHREAD_STRING_FLOAT64_ARRAY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOAT64_ARRAY)
#define DUK_HEAP_STRING_FLOAT32_ARRAY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOAT32_ARRAY)
#define DUK_HTHREAD_STRING_FLOAT32_ARRAY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOAT32_ARRAY)
#define DUK_HEAP_STRING_UINT32_ARRAY(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT32_ARRAY)
#define DUK_HTHREAD_STRING_UINT32_ARRAY(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT32_ARRAY)
#define DUK_HEAP_STRING_INT32_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT32_ARRAY)
#define DUK_HTHREAD_STRING_INT32_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT32_ARRAY)
#define DUK_HEAP_STRING_UINT16_ARRAY(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT16_ARRAY)
#define DUK_HTHREAD_STRING_UINT16_ARRAY(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT16_ARRAY)
#define DUK_HEAP_STRING_INT16_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT16_ARRAY)
#define DUK_HTHREAD_STRING_INT16_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT16_ARRAY)
#define DUK_HEAP_STRING_UINT8_CLAMPED_ARRAY(heap)                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT8_CLAMPED_ARRAY)
#define DUK_HTHREAD_STRING_UINT8_CLAMPED_ARRAY(thr)                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT8_CLAMPED_ARRAY)
#define DUK_HEAP_STRING_UINT8_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT8_ARRAY)
#define DUK_HTHREAD_STRING_UINT8_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT8_ARRAY)
#define DUK_HEAP_STRING_INT8_ARRAY(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT8_ARRAY)
#define DUK_HTHREAD_STRING_INT8_ARRAY(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT8_ARRAY)
#define DUK_HEAP_STRING_DATA_VIEW(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATA_VIEW)
#define DUK_HTHREAD_STRING_DATA_VIEW(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATA_VIEW)
#define DUK_HEAP_STRING_ARRAY_BUFFER(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ARRAY_BUFFER)
#define DUK_HTHREAD_STRING_ARRAY_BUFFER(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ARRAY_BUFFER)
#define DUK_HEAP_STRING_UC_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_BUFFER)
#define DUK_HTHREAD_STRING_UC_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_BUFFER)
#define DUK_HEAP_STRING_EMPTY_STRING(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EMPTY_STRING)
#define DUK_HTHREAD_STRING_EMPTY_STRING(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EMPTY_STRING)
#define DUK_HEAP_STRING_GLOBAL(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GLOBAL)
#define DUK_HTHREAD_STRING_GLOBAL(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GLOBAL)
#define DUK_HEAP_STRING_UC_ARGUMENTS(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_ARGUMENTS)
#define DUK_HTHREAD_STRING_UC_ARGUMENTS(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_ARGUMENTS)
#define DUK_HEAP_STRING_JSON(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON)
#define DUK_HTHREAD_STRING_JSON(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON)
#define DUK_HEAP_STRING_MATH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MATH)
#define DUK_HTHREAD_STRING_MATH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MATH)
#define DUK_HEAP_STRING_UC_ERROR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_ERROR)
#define DUK_HTHREAD_STRING_UC_ERROR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_ERROR)
#define DUK_HEAP_STRING_REG_EXP(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REG_EXP)
#define DUK_HTHREAD_STRING_REG_EXP(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REG_EXP)
#define DUK_HEAP_STRING_DATE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATE)
#define DUK_HTHREAD_STRING_DATE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATE)
#define DUK_HEAP_STRING_UC_NUMBER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_NUMBER)
#define DUK_HTHREAD_STRING_UC_NUMBER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_NUMBER)
#define DUK_HEAP_STRING_UC_BOOLEAN(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_BOOLEAN)
#define DUK_HTHREAD_STRING_UC_BOOLEAN(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_BOOLEAN)
#define DUK_HEAP_STRING_UC_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_STRING)
#define DUK_HTHREAD_STRING_UC_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_STRING)
#define DUK_HEAP_STRING_ARRAY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ARRAY)
#define DUK_HTHREAD_STRING_ARRAY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ARRAY)
#define DUK_HEAP_STRING_UC_FUNCTION(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_FUNCTION)
#define DUK_HTHREAD_STRING_UC_FUNCTION(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_FUNCTION)
#define DUK_HEAP_STRING_UC_OBJECT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_OBJECT)
#define DUK_HTHREAD_STRING_UC_OBJECT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_OBJECT)
#define DUK_HEAP_STRING_UC_NULL(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_NULL)
#define DUK_HTHREAD_STRING_UC_NULL(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_NULL)
#define DUK_HEAP_STRING_UC_UNDEFINED(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_UNDEFINED)
#define DUK_HTHREAD_STRING_UC_UNDEFINED(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_UNDEFINED)
#define DUK_HEAP_STRING_JSON_EXT_FUNCTION2(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_FUNCTION2)
#define DUK_HTHREAD_STRING_JSON_EXT_FUNCTION2(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_FUNCTION2)
#define DUK_HEAP_STRING_JSON_EXT_FUNCTION1(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_FUNCTION1)
#define DUK_HTHREAD_STRING_JSON_EXT_FUNCTION1(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_FUNCTION1)
#define DUK_HEAP_STRING_JSON_EXT_NEGINF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_NEGINF)
#define DUK_HTHREAD_STRING_JSON_EXT_NEGINF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_NEGINF)
#define DUK_HEAP_STRING_JSON_EXT_POSINF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_POSINF)
#define DUK_HTHREAD_STRING_JSON_EXT_POSINF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_POSINF)
#define DUK_HEAP_STRING_JSON_EXT_NAN(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_NAN)
#define DUK_HTHREAD_STRING_JSON_EXT_NAN(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_NAN)
#define DUK_HEAP_STRING_JSON_EXT_UNDEFINED(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_UNDEFINED)
#define DUK_HTHREAD_STRING_JSON_EXT_UNDEFINED(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_UNDEFINED)
#define DUK_HEAP_STRING_TO_LOG_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOG_STRING)
#define DUK_HTHREAD_STRING_TO_LOG_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOG_STRING)
#define DUK_HEAP_STRING_CLOG(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CLOG)
#define DUK_HTHREAD_STRING_CLOG(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CLOG)
#define DUK_HEAP_STRING_LC_L(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_L)
#define DUK_HTHREAD_STRING_LC_L(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_L)
#define DUK_HEAP_STRING_LC_N(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_N)
#define DUK_HTHREAD_STRING_LC_N(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_N)
#define DUK_HEAP_STRING_LC_FATAL(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_FATAL)
#define DUK_HTHREAD_STRING_LC_FATAL(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_FATAL)
#define DUK_HEAP_STRING_LC_ERROR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_ERROR)
#define DUK_HTHREAD_STRING_LC_ERROR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_ERROR)
#define DUK_HEAP_STRING_LC_WARN(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_WARN)
#define DUK_HTHREAD_STRING_LC_WARN(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_WARN)
#define DUK_HEAP_STRING_LC_DEBUG(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_DEBUG)
#define DUK_HTHREAD_STRING_LC_DEBUG(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_DEBUG)
#define DUK_HEAP_STRING_LC_TRACE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_TRACE)
#define DUK_HTHREAD_STRING_LC_TRACE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_TRACE)
#define DUK_HEAP_STRING_RAW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RAW)
#define DUK_HTHREAD_STRING_RAW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RAW)
#define DUK_HEAP_STRING_FMT(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FMT)
#define DUK_HTHREAD_STRING_FMT(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FMT)
#define DUK_HEAP_STRING_CURRENT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CURRENT)
#define DUK_HTHREAD_STRING_CURRENT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CURRENT)
#define DUK_HEAP_STRING_RESUME(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RESUME)
#define DUK_HTHREAD_STRING_RESUME(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RESUME)
#define DUK_HEAP_STRING_COMPACT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPACT)
#define DUK_HTHREAD_STRING_COMPACT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPACT)
#define DUK_HEAP_STRING_JC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JC)
#define DUK_HTHREAD_STRING_JC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JC)
#define DUK_HEAP_STRING_JX(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JX)
#define DUK_HTHREAD_STRING_JX(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JX)
#define DUK_HEAP_STRING_BASE64(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BASE64)
#define DUK_HTHREAD_STRING_BASE64(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BASE64)
#define DUK_HEAP_STRING_HEX(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HEX)
#define DUK_HTHREAD_STRING_HEX(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HEX)
#define DUK_HEAP_STRING_DEC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEC)
#define DUK_HTHREAD_STRING_DEC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEC)
#define DUK_HEAP_STRING_ENC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENC)
#define DUK_HTHREAD_STRING_ENC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENC)
#define DUK_HEAP_STRING_FIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FIN)
#define DUK_HTHREAD_STRING_FIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FIN)
#define DUK_HEAP_STRING_GC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GC)
#define DUK_HTHREAD_STRING_GC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GC)
#define DUK_HEAP_STRING_ACT(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ACT)
#define DUK_HTHREAD_STRING_ACT(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ACT)
#define DUK_HEAP_STRING_LC_INFO(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_INFO)
#define DUK_HTHREAD_STRING_LC_INFO(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_INFO)
#define DUK_HEAP_STRING_VERSION(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VERSION)
#define DUK_HTHREAD_STRING_VERSION(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VERSION)
#define DUK_HEAP_STRING_ENV(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENV)
#define DUK_HTHREAD_STRING_ENV(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENV)
#define DUK_HEAP_STRING_MOD_LOADED(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MOD_LOADED)
#define DUK_HTHREAD_STRING_MOD_LOADED(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MOD_LOADED)
#define DUK_HEAP_STRING_MOD_SEARCH(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MOD_SEARCH)
#define DUK_HTHREAD_STRING_MOD_SEARCH(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MOD_SEARCH)
#define DUK_HEAP_STRING_ERR_THROW(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ERR_THROW)
#define DUK_HTHREAD_STRING_ERR_THROW(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ERR_THROW)
#define DUK_HEAP_STRING_ERR_CREATE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ERR_CREATE)
#define DUK_HTHREAD_STRING_ERR_CREATE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ERR_CREATE)
#define DUK_HEAP_STRING_COMPILE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPILE)
#define DUK_HTHREAD_STRING_COMPILE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPILE)
#define DUK_HEAP_STRING_INT_REGBASE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_REGBASE)
#define DUK_HTHREAD_STRING_INT_REGBASE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_REGBASE)
#define DUK_HEAP_STRING_INT_THREAD(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_THREAD)
#define DUK_HTHREAD_STRING_INT_THREAD(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_THREAD)
#define DUK_HEAP_STRING_INT_HANDLER(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_HANDLER)
#define DUK_HTHREAD_STRING_INT_HANDLER(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_HANDLER)
#define DUK_HEAP_STRING_INT_FINALIZER(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_FINALIZER)
#define DUK_HTHREAD_STRING_INT_FINALIZER(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_FINALIZER)
#define DUK_HEAP_STRING_INT_CALLEE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_CALLEE)
#define DUK_HTHREAD_STRING_INT_CALLEE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_CALLEE)
#define DUK_HEAP_STRING_INT_MAP(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_MAP)
#define DUK_HTHREAD_STRING_INT_MAP(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_MAP)
#define DUK_HEAP_STRING_INT_ARGS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_ARGS)
#define DUK_HTHREAD_STRING_INT_ARGS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_ARGS)
#define DUK_HEAP_STRING_INT_THIS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_THIS)
#define DUK_HTHREAD_STRING_INT_THIS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_THIS)
#define DUK_HEAP_STRING_INT_PC2LINE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_PC2LINE)
#define DUK_HTHREAD_STRING_INT_PC2LINE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_PC2LINE)
#define DUK_HEAP_STRING_INT_SOURCE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_SOURCE)
#define DUK_HTHREAD_STRING_INT_SOURCE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_SOURCE)
#define DUK_HEAP_STRING_INT_VARENV(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VARENV)
#define DUK_HTHREAD_STRING_INT_VARENV(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VARENV)
#define DUK_HEAP_STRING_INT_LEXENV(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_LEXENV)
#define DUK_HTHREAD_STRING_INT_LEXENV(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_LEXENV)
#define DUK_HEAP_STRING_INT_VARMAP(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VARMAP)
#define DUK_HTHREAD_STRING_INT_VARMAP(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VARMAP)
#define DUK_HEAP_STRING_INT_FORMALS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_FORMALS)
#define DUK_HTHREAD_STRING_INT_FORMALS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_FORMALS)
#define DUK_HEAP_STRING_INT_BYTECODE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_BYTECODE)
#define DUK_HTHREAD_STRING_INT_BYTECODE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_BYTECODE)
#define DUK_HEAP_STRING_INT_NEXT(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_NEXT)
#define DUK_HTHREAD_STRING_INT_NEXT(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_NEXT)
#define DUK_HEAP_STRING_INT_TARGET(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_TARGET)
#define DUK_HTHREAD_STRING_INT_TARGET(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_TARGET)
#define DUK_HEAP_STRING_INT_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VALUE)
#define DUK_HTHREAD_STRING_INT_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VALUE)
#define DUK_HEAP_STRING_LC_POINTER(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_POINTER)
#define DUK_HTHREAD_STRING_LC_POINTER(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_POINTER)
#define DUK_HEAP_STRING_INT_TRACEDATA(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_TRACEDATA)
#define DUK_HTHREAD_STRING_INT_TRACEDATA(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_TRACEDATA)
#define DUK_HEAP_STRING_LINE_NUMBER(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LINE_NUMBER)
#define DUK_HTHREAD_STRING_LINE_NUMBER(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LINE_NUMBER)
#define DUK_HEAP_STRING_FILE_NAME(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILE_NAME)
#define DUK_HTHREAD_STRING_FILE_NAME(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILE_NAME)
#define DUK_HEAP_STRING_PC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PC)
#define DUK_HTHREAD_STRING_PC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PC)
#define DUK_HEAP_STRING_STACK(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STACK)
#define DUK_HTHREAD_STRING_STACK(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STACK)
#define DUK_HEAP_STRING_THROW_TYPE_ERROR(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THROW_TYPE_ERROR)
#define DUK_HTHREAD_STRING_THROW_TYPE_ERROR(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THROW_TYPE_ERROR)
#define DUK_HEAP_STRING_DUKTAPE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DUKTAPE)
#define DUK_HTHREAD_STRING_DUKTAPE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DUKTAPE)
#define DUK_HEAP_STRING_SET_FLOAT64(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FLOAT64)
#define DUK_HTHREAD_STRING_SET_FLOAT64(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FLOAT64)
#define DUK_HEAP_STRING_SET_FLOAT32(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FLOAT32)
#define DUK_HTHREAD_STRING_SET_FLOAT32(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FLOAT32)
#define DUK_HEAP_STRING_SET_UINT32(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT32)
#define DUK_HTHREAD_STRING_SET_UINT32(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT32)
#define DUK_HEAP_STRING_SET_INT32(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT32)
#define DUK_HTHREAD_STRING_SET_INT32(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT32)
#define DUK_HEAP_STRING_SET_UINT16(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT16)
#define DUK_HTHREAD_STRING_SET_UINT16(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT16)
#define DUK_HEAP_STRING_SET_INT16(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT16)
#define DUK_HTHREAD_STRING_SET_INT16(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT16)
#define DUK_HEAP_STRING_SET_UINT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT8)
#define DUK_HTHREAD_STRING_SET_UINT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT8)
#define DUK_HEAP_STRING_SET_INT8(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT8)
#define DUK_HTHREAD_STRING_SET_INT8(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT8)
#define DUK_HEAP_STRING_GET_FLOAT64(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FLOAT64)
#define DUK_HTHREAD_STRING_GET_FLOAT64(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FLOAT64)
#define DUK_HEAP_STRING_GET_FLOAT32(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FLOAT32)
#define DUK_HTHREAD_STRING_GET_FLOAT32(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FLOAT32)
#define DUK_HEAP_STRING_GET_UINT32(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT32)
#define DUK_HTHREAD_STRING_GET_UINT32(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT32)
#define DUK_HEAP_STRING_GET_INT32(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT32)
#define DUK_HTHREAD_STRING_GET_INT32(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT32)
#define DUK_HEAP_STRING_GET_UINT16(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT16)
#define DUK_HTHREAD_STRING_GET_UINT16(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT16)
#define DUK_HEAP_STRING_GET_INT16(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT16)
#define DUK_HTHREAD_STRING_GET_INT16(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT16)
#define DUK_HEAP_STRING_GET_UINT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT8)
#define DUK_HTHREAD_STRING_GET_UINT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT8)
#define DUK_HEAP_STRING_GET_INT8(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT8)
#define DUK_HTHREAD_STRING_GET_INT8(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT8)
#define DUK_HEAP_STRING_SUBARRAY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBARRAY)
#define DUK_HTHREAD_STRING_SUBARRAY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBARRAY)
#define DUK_HEAP_STRING_BYTES_PER_ELEMENT(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTES_PER_ELEMENT)
#define DUK_HTHREAD_STRING_BYTES_PER_ELEMENT(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTES_PER_ELEMENT)
#define DUK_HEAP_STRING_BYTE_OFFSET(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTE_OFFSET)
#define DUK_HTHREAD_STRING_BYTE_OFFSET(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTE_OFFSET)
#define DUK_HEAP_STRING_LC_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_BUFFER)
#define DUK_HTHREAD_STRING_LC_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_BUFFER)
#define DUK_HEAP_STRING_IS_VIEW(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_VIEW)
#define DUK_HTHREAD_STRING_IS_VIEW(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_VIEW)
#define DUK_HEAP_STRING_DATA(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATA)
#define DUK_HTHREAD_STRING_DATA(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATA)
#define DUK_HEAP_STRING_TYPE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPE)
#define DUK_HTHREAD_STRING_TYPE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPE)
#define DUK_HEAP_STRING_WRITE_INT_BE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT_BE)
#define DUK_HTHREAD_STRING_WRITE_INT_BE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT_BE)
#define DUK_HEAP_STRING_WRITE_INT_LE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT_LE)
#define DUK_HTHREAD_STRING_WRITE_INT_LE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT_LE)
#define DUK_HEAP_STRING_WRITE_UINT_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT_BE)
#define DUK_HEAP_STRING_WRITE_UINT_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT_LE)
#define DUK_HEAP_STRING_WRITE_DOUBLE_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_DOUBLE_BE)
#define DUK_HTHREAD_STRING_WRITE_DOUBLE_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_DOUBLE_BE)
#define DUK_HEAP_STRING_WRITE_DOUBLE_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_DOUBLE_LE)
#define DUK_HTHREAD_STRING_WRITE_DOUBLE_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_DOUBLE_LE)
#define DUK_HEAP_STRING_WRITE_FLOAT_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_FLOAT_BE)
#define DUK_HTHREAD_STRING_WRITE_FLOAT_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_FLOAT_BE)
#define DUK_HEAP_STRING_WRITE_FLOAT_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_FLOAT_LE)
#define DUK_HTHREAD_STRING_WRITE_FLOAT_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_FLOAT_LE)
#define DUK_HEAP_STRING_WRITE_INT32_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT32_BE)
#define DUK_HTHREAD_STRING_WRITE_INT32_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT32_BE)
#define DUK_HEAP_STRING_WRITE_INT32_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT32_LE)
#define DUK_HTHREAD_STRING_WRITE_INT32_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT32_LE)
#define DUK_HEAP_STRING_WRITE_UINT32_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT32_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT32_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT32_BE)
#define DUK_HEAP_STRING_WRITE_UINT32_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT32_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT32_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT32_LE)
#define DUK_HEAP_STRING_WRITE_INT16_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT16_BE)
#define DUK_HTHREAD_STRING_WRITE_INT16_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT16_BE)
#define DUK_HEAP_STRING_WRITE_INT16_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT16_LE)
#define DUK_HTHREAD_STRING_WRITE_INT16_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT16_LE)
#define DUK_HEAP_STRING_WRITE_UINT16_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT16_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT16_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT16_BE)
#define DUK_HEAP_STRING_WRITE_UINT16_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT16_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT16_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT16_LE)
#define DUK_HEAP_STRING_WRITE_INT8(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT8)
#define DUK_HTHREAD_STRING_WRITE_INT8(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT8)
#define DUK_HEAP_STRING_WRITE_UINT8(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT8)
#define DUK_HTHREAD_STRING_WRITE_UINT8(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT8)
#define DUK_HEAP_STRING_READ_INT_BE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT_BE)
#define DUK_HTHREAD_STRING_READ_INT_BE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT_BE)
#define DUK_HEAP_STRING_READ_INT_LE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT_LE)
#define DUK_HTHREAD_STRING_READ_INT_LE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT_LE)
#define DUK_HEAP_STRING_READ_UINT_BE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT_BE)
#define DUK_HTHREAD_STRING_READ_UINT_BE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT_BE)
#define DUK_HEAP_STRING_READ_UINT_LE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT_LE)
#define DUK_HTHREAD_STRING_READ_UINT_LE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT_LE)
#define DUK_HEAP_STRING_READ_DOUBLE_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_DOUBLE_BE)
#define DUK_HTHREAD_STRING_READ_DOUBLE_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_DOUBLE_BE)
#define DUK_HEAP_STRING_READ_DOUBLE_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_DOUBLE_LE)
#define DUK_HTHREAD_STRING_READ_DOUBLE_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_DOUBLE_LE)
#define DUK_HEAP_STRING_READ_FLOAT_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_FLOAT_BE)
#define DUK_HTHREAD_STRING_READ_FLOAT_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_FLOAT_BE)
#define DUK_HEAP_STRING_READ_FLOAT_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_FLOAT_LE)
#define DUK_HTHREAD_STRING_READ_FLOAT_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_FLOAT_LE)
#define DUK_HEAP_STRING_READ_INT32_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT32_BE)
#define DUK_HTHREAD_STRING_READ_INT32_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT32_BE)
#define DUK_HEAP_STRING_READ_INT32_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT32_LE)
#define DUK_HTHREAD_STRING_READ_INT32_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT32_LE)
#define DUK_HEAP_STRING_READ_UINT32_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT32_BE)
#define DUK_HTHREAD_STRING_READ_UINT32_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT32_BE)
#define DUK_HEAP_STRING_READ_UINT32_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT32_LE)
#define DUK_HTHREAD_STRING_READ_UINT32_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT32_LE)
#define DUK_HEAP_STRING_READ_INT16_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT16_BE)
#define DUK_HTHREAD_STRING_READ_INT16_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT16_BE)
#define DUK_HEAP_STRING_READ_INT16_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT16_LE)
#define DUK_HTHREAD_STRING_READ_INT16_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT16_LE)
#define DUK_HEAP_STRING_READ_UINT16_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT16_BE)
#define DUK_HTHREAD_STRING_READ_UINT16_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT16_BE)
#define DUK_HEAP_STRING_READ_UINT16_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT16_LE)
#define DUK_HTHREAD_STRING_READ_UINT16_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT16_LE)
#define DUK_HEAP_STRING_READ_INT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT8)
#define DUK_HTHREAD_STRING_READ_INT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT8)
#define DUK_HEAP_STRING_READ_UINT8(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT8)
#define DUK_HTHREAD_STRING_READ_UINT8(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT8)
#define DUK_HEAP_STRING_COPY(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COPY)
#define DUK_HTHREAD_STRING_COPY(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COPY)
#define DUK_HEAP_STRING_EQUALS(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EQUALS)
#define DUK_HTHREAD_STRING_EQUALS(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EQUALS)
#define DUK_HEAP_STRING_FILL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILL)
#define DUK_HTHREAD_STRING_FILL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILL)
#define DUK_HEAP_STRING_WRITE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE)
#define DUK_HTHREAD_STRING_WRITE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE)
#define DUK_HEAP_STRING_COMPARE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPARE)
#define DUK_HTHREAD_STRING_COMPARE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPARE)
#define DUK_HEAP_STRING_BYTE_LENGTH(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTE_LENGTH)
#define DUK_HTHREAD_STRING_BYTE_LENGTH(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTE_LENGTH)
#define DUK_HEAP_STRING_IS_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_BUFFER)
#define DUK_HTHREAD_STRING_IS_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_BUFFER)
#define DUK_HEAP_STRING_IS_ENCODING(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_ENCODING)
#define DUK_HTHREAD_STRING_IS_ENCODING(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_ENCODING)
#define DUK_HEAP_STRING_EXPORTS(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXPORTS)
#define DUK_HTHREAD_STRING_EXPORTS(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXPORTS)
#define DUK_HEAP_STRING_ID(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ID)
#define DUK_HTHREAD_STRING_ID(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ID)
#define DUK_HEAP_STRING_REQUIRE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REQUIRE)
#define DUK_HTHREAD_STRING_REQUIRE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REQUIRE)
#define DUK_HEAP_STRING___PROTO__(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX___PROTO__)
#define DUK_HTHREAD_STRING___PROTO__(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX___PROTO__)
#define DUK_HEAP_STRING_SET_PROTOTYPE_OF(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_SET_PROTOTYPE_OF(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_PROTOTYPE_OF)
#define DUK_HEAP_STRING_OWN_KEYS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_OWN_KEYS)
#define DUK_HTHREAD_STRING_OWN_KEYS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_OWN_KEYS)
#define DUK_HEAP_STRING_ENUMERATE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUMERATE)
#define DUK_HTHREAD_STRING_ENUMERATE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUMERATE)
#define DUK_HEAP_STRING_DELETE_PROPERTY(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DELETE_PROPERTY)
#define DUK_HTHREAD_STRING_DELETE_PROPERTY(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DELETE_PROPERTY)
#define DUK_HEAP_STRING_HAS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HAS)
#define DUK_HTHREAD_STRING_HAS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HAS)
#define DUK_HEAP_STRING_PROXY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROXY)
#define DUK_HTHREAD_STRING_PROXY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROXY)
#define DUK_HEAP_STRING_CALLEE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALLEE)
#define DUK_HTHREAD_STRING_CALLEE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALLEE)
#define DUK_HEAP_STRING_INVALID_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INVALID_DATE)
#define DUK_HTHREAD_STRING_INVALID_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INVALID_DATE)
#define DUK_HEAP_STRING_BRACKETED_ELLIPSIS(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BRACKETED_ELLIPSIS)
#define DUK_HTHREAD_STRING_BRACKETED_ELLIPSIS(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BRACKETED_ELLIPSIS)
#define DUK_HEAP_STRING_NEWLINE_TAB(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEWLINE_TAB)
#define DUK_HTHREAD_STRING_NEWLINE_TAB(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEWLINE_TAB)
#define DUK_HEAP_STRING_SPACE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPACE)
#define DUK_HTHREAD_STRING_SPACE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPACE)
#define DUK_HEAP_STRING_COMMA(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMMA)
#define DUK_HTHREAD_STRING_COMMA(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMMA)
#define DUK_HEAP_STRING_MINUS_ZERO(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MINUS_ZERO)
#define DUK_HTHREAD_STRING_MINUS_ZERO(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MINUS_ZERO)
#define DUK_HEAP_STRING_PLUS_ZERO(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PLUS_ZERO)
#define DUK_HTHREAD_STRING_PLUS_ZERO(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PLUS_ZERO)
#define DUK_HEAP_STRING_ZERO(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ZERO)
#define DUK_HTHREAD_STRING_ZERO(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ZERO)
#define DUK_HEAP_STRING_MINUS_INFINITY(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MINUS_INFINITY)
#define DUK_HTHREAD_STRING_MINUS_INFINITY(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MINUS_INFINITY)
#define DUK_HEAP_STRING_PLUS_INFINITY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PLUS_INFINITY)
#define DUK_HTHREAD_STRING_PLUS_INFINITY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PLUS_INFINITY)
#define DUK_HEAP_STRING_INFINITY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INFINITY)
#define DUK_HTHREAD_STRING_INFINITY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INFINITY)
#define DUK_HEAP_STRING_LC_OBJECT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_OBJECT)
#define DUK_HTHREAD_STRING_LC_OBJECT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_OBJECT)
#define DUK_HEAP_STRING_LC_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_STRING)
#define DUK_HTHREAD_STRING_LC_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_STRING)
#define DUK_HEAP_STRING_LC_NUMBER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_NUMBER)
#define DUK_HTHREAD_STRING_LC_NUMBER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_NUMBER)
#define DUK_HEAP_STRING_LC_BOOLEAN(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_BOOLEAN)
#define DUK_HTHREAD_STRING_LC_BOOLEAN(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_BOOLEAN)
#define DUK_HEAP_STRING_LC_UNDEFINED(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_UNDEFINED)
#define DUK_HTHREAD_STRING_LC_UNDEFINED(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_UNDEFINED)
#define DUK_HEAP_STRING_STRINGIFY(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STRINGIFY)
#define DUK_HTHREAD_STRING_STRINGIFY(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STRINGIFY)
#define DUK_HEAP_STRING_TAN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TAN)
#define DUK_HTHREAD_STRING_TAN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TAN)
#define DUK_HEAP_STRING_SQRT(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT)
#define DUK_HTHREAD_STRING_SQRT(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT)
#define DUK_HEAP_STRING_SIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SIN)
#define DUK_HTHREAD_STRING_SIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SIN)
#define DUK_HEAP_STRING_ROUND(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ROUND)
#define DUK_HTHREAD_STRING_ROUND(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ROUND)
#define DUK_HEAP_STRING_RANDOM(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RANDOM)
#define DUK_HTHREAD_STRING_RANDOM(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RANDOM)
#define DUK_HEAP_STRING_POW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POW)
#define DUK_HTHREAD_STRING_POW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POW)
#define DUK_HEAP_STRING_MIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MIN)
#define DUK_HTHREAD_STRING_MIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MIN)
#define DUK_HEAP_STRING_MAX(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAX)
#define DUK_HTHREAD_STRING_MAX(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAX)
#define DUK_HEAP_STRING_LOG(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG)
#define DUK_HTHREAD_STRING_LOG(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG)
#define DUK_HEAP_STRING_FLOOR(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOOR)
#define DUK_HTHREAD_STRING_FLOOR(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOOR)
#define DUK_HEAP_STRING_EXP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXP)
#define DUK_HTHREAD_STRING_EXP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXP)
#define DUK_HEAP_STRING_COS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COS)
#define DUK_HTHREAD_STRING_COS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COS)
#define DUK_HEAP_STRING_CEIL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CEIL)
#define DUK_HTHREAD_STRING_CEIL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CEIL)
#define DUK_HEAP_STRING_ATAN2(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ATAN2)
#define DUK_HTHREAD_STRING_ATAN2(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ATAN2)
#define DUK_HEAP_STRING_ATAN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ATAN)
#define DUK_HTHREAD_STRING_ATAN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ATAN)
#define DUK_HEAP_STRING_ASIN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ASIN)
#define DUK_HTHREAD_STRING_ASIN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ASIN)
#define DUK_HEAP_STRING_ACOS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ACOS)
#define DUK_HTHREAD_STRING_ACOS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ACOS)
#define DUK_HEAP_STRING_ABS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ABS)
#define DUK_HTHREAD_STRING_ABS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ABS)
#define DUK_HEAP_STRING_SQRT2(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT2)
#define DUK_HTHREAD_STRING_SQRT2(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT2)
#define DUK_HEAP_STRING_SQRT1_2(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT1_2)
#define DUK_HTHREAD_STRING_SQRT1_2(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT1_2)
#define DUK_HEAP_STRING_PI(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PI)
#define DUK_HTHREAD_STRING_PI(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PI)
#define DUK_HEAP_STRING_LOG10E(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG10E)
#define DUK_HTHREAD_STRING_LOG10E(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG10E)
#define DUK_HEAP_STRING_LOG2E(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG2E)
#define DUK_HTHREAD_STRING_LOG2E(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG2E)
#define DUK_HEAP_STRING_LN2(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LN2)
#define DUK_HTHREAD_STRING_LN2(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LN2)
#define DUK_HEAP_STRING_LN10(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LN10)
#define DUK_HTHREAD_STRING_LN10(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LN10)
#define DUK_HEAP_STRING_E(heap)                                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_E)
#define DUK_HTHREAD_STRING_E(thr)                                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_E)
#define DUK_HEAP_STRING_MESSAGE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MESSAGE)
#define DUK_HTHREAD_STRING_MESSAGE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MESSAGE)
#define DUK_HEAP_STRING_NAME(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NAME)
#define DUK_HTHREAD_STRING_NAME(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NAME)
#define DUK_HEAP_STRING_INPUT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INPUT)
#define DUK_HTHREAD_STRING_INPUT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INPUT)
#define DUK_HEAP_STRING_INDEX(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INDEX)
#define DUK_HTHREAD_STRING_INDEX(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INDEX)
#define DUK_HEAP_STRING_ESCAPED_EMPTY_REGEXP(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ESCAPED_EMPTY_REGEXP)
#define DUK_HTHREAD_STRING_ESCAPED_EMPTY_REGEXP(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ESCAPED_EMPTY_REGEXP)
#define DUK_HEAP_STRING_LAST_INDEX(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LAST_INDEX)
#define DUK_HTHREAD_STRING_LAST_INDEX(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LAST_INDEX)
#define DUK_HEAP_STRING_MULTILINE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MULTILINE)
#define DUK_HTHREAD_STRING_MULTILINE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MULTILINE)
#define DUK_HEAP_STRING_IGNORE_CASE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IGNORE_CASE)
#define DUK_HTHREAD_STRING_IGNORE_CASE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IGNORE_CASE)
#define DUK_HEAP_STRING_SOURCE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SOURCE)
#define DUK_HTHREAD_STRING_SOURCE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SOURCE)
#define DUK_HEAP_STRING_TEST(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TEST)
#define DUK_HTHREAD_STRING_TEST(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TEST)
#define DUK_HEAP_STRING_EXEC(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXEC)
#define DUK_HTHREAD_STRING_EXEC(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXEC)
#define DUK_HEAP_STRING_TO_GMT_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_GMT_STRING)
#define DUK_HTHREAD_STRING_TO_GMT_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_GMT_STRING)
#define DUK_HEAP_STRING_SET_YEAR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_YEAR)
#define DUK_HTHREAD_STRING_SET_YEAR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_YEAR)
#define DUK_HEAP_STRING_GET_YEAR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_YEAR)
#define DUK_HTHREAD_STRING_GET_YEAR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_YEAR)
#define DUK_HEAP_STRING_TO_JSON(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_JSON)
#define DUK_HTHREAD_STRING_TO_JSON(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_JSON)
#define DUK_HEAP_STRING_TO_ISO_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_ISO_STRING)
#define DUK_HTHREAD_STRING_TO_ISO_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_ISO_STRING)
#define DUK_HEAP_STRING_TO_UTC_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_UTC_STRING)
#define DUK_HTHREAD_STRING_TO_UTC_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_UTC_STRING)
#define DUK_HEAP_STRING_SET_UTC_FULL_YEAR(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_FULL_YEAR)
#define DUK_HTHREAD_STRING_SET_UTC_FULL_YEAR(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_FULL_YEAR)
#define DUK_HEAP_STRING_SET_FULL_YEAR(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FULL_YEAR)
#define DUK_HTHREAD_STRING_SET_FULL_YEAR(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FULL_YEAR)
#define DUK_HEAP_STRING_SET_UTC_MONTH(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MONTH)
#define DUK_HTHREAD_STRING_SET_UTC_MONTH(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MONTH)
#define DUK_HEAP_STRING_SET_MONTH(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MONTH)
#define DUK_HTHREAD_STRING_SET_MONTH(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MONTH)
#define DUK_HEAP_STRING_SET_UTC_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_DATE)
#define DUK_HTHREAD_STRING_SET_UTC_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_DATE)
#define DUK_HEAP_STRING_SET_DATE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_DATE)
#define DUK_HTHREAD_STRING_SET_DATE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_DATE)
#define DUK_HEAP_STRING_SET_UTC_HOURS(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_HOURS)
#define DUK_HTHREAD_STRING_SET_UTC_HOURS(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_HOURS)
#define DUK_HEAP_STRING_SET_HOURS(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_HOURS)
#define DUK_HTHREAD_STRING_SET_HOURS(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_HOURS)
#define DUK_HEAP_STRING_SET_UTC_MINUTES(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MINUTES)
#define DUK_HTHREAD_STRING_SET_UTC_MINUTES(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MINUTES)
#define DUK_HEAP_STRING_SET_MINUTES(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MINUTES)
#define DUK_HTHREAD_STRING_SET_MINUTES(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MINUTES)
#define DUK_HEAP_STRING_SET_UTC_SECONDS(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_SECONDS)
#define DUK_HTHREAD_STRING_SET_UTC_SECONDS(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_SECONDS)
#define DUK_HEAP_STRING_SET_SECONDS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_SECONDS)
#define DUK_HTHREAD_STRING_SET_SECONDS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_SECONDS)
#define DUK_HEAP_STRING_SET_UTC_MILLISECONDS(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MILLISECONDS)
#define DUK_HTHREAD_STRING_SET_UTC_MILLISECONDS(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MILLISECONDS)
#define DUK_HEAP_STRING_SET_MILLISECONDS(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MILLISECONDS)
#define DUK_HTHREAD_STRING_SET_MILLISECONDS(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MILLISECONDS)
#define DUK_HEAP_STRING_SET_TIME(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_TIME)
#define DUK_HTHREAD_STRING_SET_TIME(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_TIME)
#define DUK_HEAP_STRING_GET_TIMEZONE_OFFSET(heap)                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_TIMEZONE_OFFSET)
#define DUK_HTHREAD_STRING_GET_TIMEZONE_OFFSET(thr)                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_TIMEZONE_OFFSET)
#define DUK_HEAP_STRING_GET_UTC_MILLISECONDS(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MILLISECONDS)
#define DUK_HTHREAD_STRING_GET_UTC_MILLISECONDS(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MILLISECONDS)
#define DUK_HEAP_STRING_GET_MILLISECONDS(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MILLISECONDS)
#define DUK_HTHREAD_STRING_GET_MILLISECONDS(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MILLISECONDS)
#define DUK_HEAP_STRING_GET_UTC_SECONDS(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_SECONDS)
#define DUK_HTHREAD_STRING_GET_UTC_SECONDS(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_SECONDS)
#define DUK_HEAP_STRING_GET_SECONDS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_SECONDS)
#define DUK_HTHREAD_STRING_GET_SECONDS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_SECONDS)
#define DUK_HEAP_STRING_GET_UTC_MINUTES(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MINUTES)
#define DUK_HTHREAD_STRING_GET_UTC_MINUTES(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MINUTES)
#define DUK_HEAP_STRING_GET_MINUTES(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MINUTES)
#define DUK_HTHREAD_STRING_GET_MINUTES(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MINUTES)
#define DUK_HEAP_STRING_GET_UTC_HOURS(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_HOURS)
#define DUK_HTHREAD_STRING_GET_UTC_HOURS(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_HOURS)
#define DUK_HEAP_STRING_GET_HOURS(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_HOURS)
#define DUK_HTHREAD_STRING_GET_HOURS(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_HOURS)
#define DUK_HEAP_STRING_GET_UTC_DAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_DAY)
#define DUK_HTHREAD_STRING_GET_UTC_DAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_DAY)
#define DUK_HEAP_STRING_GET_DAY(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_DAY)
#define DUK_HTHREAD_STRING_GET_DAY(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_DAY)
#define DUK_HEAP_STRING_GET_UTC_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_DATE)
#define DUK_HTHREAD_STRING_GET_UTC_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_DATE)
#define DUK_HEAP_STRING_GET_DATE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_DATE)
#define DUK_HTHREAD_STRING_GET_DATE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_DATE)
#define DUK_HEAP_STRING_GET_UTC_MONTH(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MONTH)
#define DUK_HTHREAD_STRING_GET_UTC_MONTH(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MONTH)
#define DUK_HEAP_STRING_GET_MONTH(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MONTH)
#define DUK_HTHREAD_STRING_GET_MONTH(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MONTH)
#define DUK_HEAP_STRING_GET_UTC_FULL_YEAR(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_FULL_YEAR)
#define DUK_HTHREAD_STRING_GET_UTC_FULL_YEAR(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_FULL_YEAR)
#define DUK_HEAP_STRING_GET_FULL_YEAR(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FULL_YEAR)
#define DUK_HTHREAD_STRING_GET_FULL_YEAR(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FULL_YEAR)
#define DUK_HEAP_STRING_GET_TIME(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_TIME)
#define DUK_HTHREAD_STRING_GET_TIME(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_TIME)
#define DUK_HEAP_STRING_TO_LOCALE_TIME_STRING(heap)                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_TIME_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_TIME_STRING(thr)                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_TIME_STRING)
#define DUK_HEAP_STRING_TO_LOCALE_DATE_STRING(heap)                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_DATE_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_DATE_STRING(thr)                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_DATE_STRING)
#define DUK_HEAP_STRING_TO_TIME_STRING(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_TIME_STRING)
#define DUK_HTHREAD_STRING_TO_TIME_STRING(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_TIME_STRING)
#define DUK_HEAP_STRING_TO_DATE_STRING(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_DATE_STRING)
#define DUK_HTHREAD_STRING_TO_DATE_STRING(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_DATE_STRING)
#define DUK_HEAP_STRING_NOW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NOW)
#define DUK_HTHREAD_STRING_NOW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NOW)
#define DUK_HEAP_STRING_UTC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UTC)
#define DUK_HTHREAD_STRING_UTC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UTC)
#define DUK_HEAP_STRING_PARSE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE)
#define DUK_HTHREAD_STRING_PARSE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE)
#define DUK_HEAP_STRING_TO_PRECISION(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_PRECISION)
#define DUK_HTHREAD_STRING_TO_PRECISION(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_PRECISION)
#define DUK_HEAP_STRING_TO_EXPONENTIAL(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_EXPONENTIAL)
#define DUK_HTHREAD_STRING_TO_EXPONENTIAL(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_EXPONENTIAL)
#define DUK_HEAP_STRING_TO_FIXED(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_FIXED)
#define DUK_HTHREAD_STRING_TO_FIXED(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_FIXED)
#define DUK_HEAP_STRING_POSITIVE_INFINITY(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POSITIVE_INFINITY)
#define DUK_HTHREAD_STRING_POSITIVE_INFINITY(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POSITIVE_INFINITY)
#define DUK_HEAP_STRING_NEGATIVE_INFINITY(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEGATIVE_INFINITY)
#define DUK_HTHREAD_STRING_NEGATIVE_INFINITY(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEGATIVE_INFINITY)
#define DUK_HEAP_STRING_NAN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NAN)
#define DUK_HTHREAD_STRING_NAN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NAN)
#define DUK_HEAP_STRING_MIN_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MIN_VALUE)
#define DUK_HTHREAD_STRING_MIN_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MIN_VALUE)
#define DUK_HEAP_STRING_MAX_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAX_VALUE)
#define DUK_HTHREAD_STRING_MAX_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAX_VALUE)
#define DUK_HEAP_STRING_SUBSTR(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBSTR)
#define DUK_HTHREAD_STRING_SUBSTR(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBSTR)
#define DUK_HEAP_STRING_TRIM(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRIM)
#define DUK_HTHREAD_STRING_TRIM(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRIM)
#define DUK_HEAP_STRING_TO_LOCALE_UPPER_CASE(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_UPPER_CASE)
#define DUK_HTHREAD_STRING_TO_LOCALE_UPPER_CASE(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_UPPER_CASE)
#define DUK_HEAP_STRING_TO_UPPER_CASE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_UPPER_CASE)
#define DUK_HTHREAD_STRING_TO_UPPER_CASE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_UPPER_CASE)
#define DUK_HEAP_STRING_TO_LOCALE_LOWER_CASE(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_LOWER_CASE)
#define DUK_HTHREAD_STRING_TO_LOCALE_LOWER_CASE(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_LOWER_CASE)
#define DUK_HEAP_STRING_TO_LOWER_CASE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOWER_CASE)
#define DUK_HTHREAD_STRING_TO_LOWER_CASE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOWER_CASE)
#define DUK_HEAP_STRING_SUBSTRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBSTRING)
#define DUK_HTHREAD_STRING_SUBSTRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBSTRING)
#define DUK_HEAP_STRING_SPLIT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPLIT)
#define DUK_HTHREAD_STRING_SPLIT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPLIT)
#define DUK_HEAP_STRING_SEARCH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SEARCH)
#define DUK_HTHREAD_STRING_SEARCH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SEARCH)
#define DUK_HEAP_STRING_REPLACE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REPLACE)
#define DUK_HTHREAD_STRING_REPLACE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REPLACE)
#define DUK_HEAP_STRING_MATCH(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MATCH)
#define DUK_HTHREAD_STRING_MATCH(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MATCH)
#define DUK_HEAP_STRING_LOCALE_COMPARE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOCALE_COMPARE)
#define DUK_HTHREAD_STRING_LOCALE_COMPARE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOCALE_COMPARE)
#define DUK_HEAP_STRING_CHAR_CODE_AT(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CHAR_CODE_AT)
#define DUK_HTHREAD_STRING_CHAR_CODE_AT(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CHAR_CODE_AT)
#define DUK_HEAP_STRING_CHAR_AT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CHAR_AT)
#define DUK_HTHREAD_STRING_CHAR_AT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CHAR_AT)
#define DUK_HEAP_STRING_FROM_CHAR_CODE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FROM_CHAR_CODE)
#define DUK_HTHREAD_STRING_FROM_CHAR_CODE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FROM_CHAR_CODE)
#define DUK_HEAP_STRING_REDUCE_RIGHT(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REDUCE_RIGHT)
#define DUK_HTHREAD_STRING_REDUCE_RIGHT(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REDUCE_RIGHT)
#define DUK_HEAP_STRING_REDUCE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REDUCE)
#define DUK_HTHREAD_STRING_REDUCE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REDUCE)
#define DUK_HEAP_STRING_FILTER(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILTER)
#define DUK_HTHREAD_STRING_FILTER(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILTER)
#define DUK_HEAP_STRING_MAP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAP)
#define DUK_HTHREAD_STRING_MAP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAP)
#define DUK_HEAP_STRING_FOR_EACH(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FOR_EACH)
#define DUK_HTHREAD_STRING_FOR_EACH(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FOR_EACH)
#define DUK_HEAP_STRING_SOME(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SOME)
#define DUK_HTHREAD_STRING_SOME(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SOME)
#define DUK_HEAP_STRING_EVERY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVERY)
#define DUK_HTHREAD_STRING_EVERY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVERY)
#define DUK_HEAP_STRING_LAST_INDEX_OF(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LAST_INDEX_OF)
#define DUK_HTHREAD_STRING_LAST_INDEX_OF(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LAST_INDEX_OF)
#define DUK_HEAP_STRING_INDEX_OF(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INDEX_OF)
#define DUK_HTHREAD_STRING_INDEX_OF(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INDEX_OF)
#define DUK_HEAP_STRING_UNSHIFT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UNSHIFT)
#define DUK_HTHREAD_STRING_UNSHIFT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UNSHIFT)
#define DUK_HEAP_STRING_SPLICE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPLICE)
#define DUK_HTHREAD_STRING_SPLICE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPLICE)
#define DUK_HEAP_STRING_SORT(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SORT)
#define DUK_HTHREAD_STRING_SORT(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SORT)
#define DUK_HEAP_STRING_SLICE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SLICE)
#define DUK_HTHREAD_STRING_SLICE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SLICE)
#define DUK_HEAP_STRING_SHIFT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SHIFT)
#define DUK_HTHREAD_STRING_SHIFT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SHIFT)
#define DUK_HEAP_STRING_REVERSE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REVERSE)
#define DUK_HTHREAD_STRING_REVERSE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REVERSE)
#define DUK_HEAP_STRING_PUSH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PUSH)
#define DUK_HTHREAD_STRING_PUSH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PUSH)
#define DUK_HEAP_STRING_POP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POP)
#define DUK_HTHREAD_STRING_POP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POP)
#define DUK_HEAP_STRING_JOIN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JOIN)
#define DUK_HTHREAD_STRING_JOIN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JOIN)
#define DUK_HEAP_STRING_CONCAT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONCAT)
#define DUK_HTHREAD_STRING_CONCAT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONCAT)
#define DUK_HEAP_STRING_IS_ARRAY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_ARRAY)
#define DUK_HTHREAD_STRING_IS_ARRAY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_ARRAY)
#define DUK_HEAP_STRING_LC_ARGUMENTS(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_ARGUMENTS)
#define DUK_HTHREAD_STRING_LC_ARGUMENTS(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_ARGUMENTS)
#define DUK_HEAP_STRING_CALLER(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALLER)
#define DUK_HTHREAD_STRING_CALLER(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALLER)
#define DUK_HEAP_STRING_BIND(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BIND)
#define DUK_HTHREAD_STRING_BIND(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BIND)
#define DUK_HEAP_STRING_CALL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALL)
#define DUK_HTHREAD_STRING_CALL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALL)
#define DUK_HEAP_STRING_APPLY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_APPLY)
#define DUK_HTHREAD_STRING_APPLY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_APPLY)
#define DUK_HEAP_STRING_PROPERTY_IS_ENUMERABLE(heap)                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROPERTY_IS_ENUMERABLE)
#define DUK_HTHREAD_STRING_PROPERTY_IS_ENUMERABLE(thr)                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROPERTY_IS_ENUMERABLE)
#define DUK_HEAP_STRING_IS_PROTOTYPE_OF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_IS_PROTOTYPE_OF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_PROTOTYPE_OF)
#define DUK_HEAP_STRING_HAS_OWN_PROPERTY(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HAS_OWN_PROPERTY)
#define DUK_HTHREAD_STRING_HAS_OWN_PROPERTY(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HAS_OWN_PROPERTY)
#define DUK_HEAP_STRING_VALUE_OF(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VALUE_OF)
#define DUK_HTHREAD_STRING_VALUE_OF(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VALUE_OF)
#define DUK_HEAP_STRING_TO_LOCALE_STRING(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_STRING(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_STRING)
#define DUK_HEAP_STRING_TO_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_STRING)
#define DUK_HTHREAD_STRING_TO_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_STRING)
#define DUK_HEAP_STRING_CONSTRUCTOR(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONSTRUCTOR)
#define DUK_HTHREAD_STRING_CONSTRUCTOR(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONSTRUCTOR)
#define DUK_HEAP_STRING_SET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET)
#define DUK_HTHREAD_STRING_SET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET)
#define DUK_HEAP_STRING_GET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET)
#define DUK_HTHREAD_STRING_GET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET)
#define DUK_HEAP_STRING_ENUMERABLE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUMERABLE)
#define DUK_HTHREAD_STRING_ENUMERABLE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUMERABLE)
#define DUK_HEAP_STRING_CONFIGURABLE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONFIGURABLE)
#define DUK_HTHREAD_STRING_CONFIGURABLE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONFIGURABLE)
#define DUK_HEAP_STRING_WRITABLE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITABLE)
#define DUK_HTHREAD_STRING_WRITABLE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITABLE)
#define DUK_HEAP_STRING_VALUE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VALUE)
#define DUK_HTHREAD_STRING_VALUE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VALUE)
#define DUK_HEAP_STRING_KEYS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_KEYS)
#define DUK_HTHREAD_STRING_KEYS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_KEYS)
#define DUK_HEAP_STRING_IS_EXTENSIBLE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_EXTENSIBLE)
#define DUK_HTHREAD_STRING_IS_EXTENSIBLE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_EXTENSIBLE)
#define DUK_HEAP_STRING_IS_FROZEN(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_FROZEN)
#define DUK_HTHREAD_STRING_IS_FROZEN(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_FROZEN)
#define DUK_HEAP_STRING_IS_SEALED(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_SEALED)
#define DUK_HTHREAD_STRING_IS_SEALED(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_SEALED)
#define DUK_HEAP_STRING_PREVENT_EXTENSIONS(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PREVENT_EXTENSIONS)
#define DUK_HTHREAD_STRING_PREVENT_EXTENSIONS(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PREVENT_EXTENSIONS)
#define DUK_HEAP_STRING_FREEZE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FREEZE)
#define DUK_HTHREAD_STRING_FREEZE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FREEZE)
#define DUK_HEAP_STRING_SEAL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SEAL)
#define DUK_HTHREAD_STRING_SEAL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SEAL)
#define DUK_HEAP_STRING_DEFINE_PROPERTIES(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFINE_PROPERTIES)
#define DUK_HTHREAD_STRING_DEFINE_PROPERTIES(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFINE_PROPERTIES)
#define DUK_HEAP_STRING_DEFINE_PROPERTY(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFINE_PROPERTY)
#define DUK_HTHREAD_STRING_DEFINE_PROPERTY(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFINE_PROPERTY)
#define DUK_HEAP_STRING_CREATE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CREATE)
#define DUK_HTHREAD_STRING_CREATE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CREATE)
#define DUK_HEAP_STRING_GET_OWN_PROPERTY_NAMES(heap)                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_OWN_PROPERTY_NAMES)
#define DUK_HTHREAD_STRING_GET_OWN_PROPERTY_NAMES(thr)                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_OWN_PROPERTY_NAMES)
#define DUK_HEAP_STRING_GET_OWN_PROPERTY_DESCRIPTOR(heap)             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR)
#define DUK_HTHREAD_STRING_GET_OWN_PROPERTY_DESCRIPTOR(thr)           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR)
#define DUK_HEAP_STRING_GET_PROTOTYPE_OF(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_GET_PROTOTYPE_OF(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_PROTOTYPE_OF)
#define DUK_HEAP_STRING_PROTOTYPE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROTOTYPE)
#define DUK_HTHREAD_STRING_PROTOTYPE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROTOTYPE)
#define DUK_HEAP_STRING_LENGTH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LENGTH)
#define DUK_HTHREAD_STRING_LENGTH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LENGTH)
#define DUK_HEAP_STRING_ALERT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ALERT)
#define DUK_HTHREAD_STRING_ALERT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ALERT)
#define DUK_HEAP_STRING_PRINT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PRINT)
#define DUK_HTHREAD_STRING_PRINT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PRINT)
#define DUK_HEAP_STRING_UNESCAPE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UNESCAPE)
#define DUK_HTHREAD_STRING_UNESCAPE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UNESCAPE)
#define DUK_HEAP_STRING_ESCAPE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ESCAPE)
#define DUK_HTHREAD_STRING_ESCAPE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ESCAPE)
#define DUK_HEAP_STRING_ENCODE_URI_COMPONENT(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENCODE_URI_COMPONENT)
#define DUK_HTHREAD_STRING_ENCODE_URI_COMPONENT(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENCODE_URI_COMPONENT)
#define DUK_HEAP_STRING_ENCODE_URI(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENCODE_URI)
#define DUK_HTHREAD_STRING_ENCODE_URI(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENCODE_URI)
#define DUK_HEAP_STRING_DECODE_URI_COMPONENT(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DECODE_URI_COMPONENT)
#define DUK_HTHREAD_STRING_DECODE_URI_COMPONENT(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DECODE_URI_COMPONENT)
#define DUK_HEAP_STRING_DECODE_URI(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DECODE_URI)
#define DUK_HTHREAD_STRING_DECODE_URI(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DECODE_URI)
#define DUK_HEAP_STRING_IS_FINITE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_FINITE)
#define DUK_HTHREAD_STRING_IS_FINITE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_FINITE)
#define DUK_HEAP_STRING_IS_NAN(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_NAN)
#define DUK_HTHREAD_STRING_IS_NAN(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_NAN)
#define DUK_HEAP_STRING_PARSE_FLOAT(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE_FLOAT)
#define DUK_HTHREAD_STRING_PARSE_FLOAT(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE_FLOAT)
#define DUK_HEAP_STRING_PARSE_INT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE_INT)
#define DUK_HTHREAD_STRING_PARSE_INT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE_INT)
#define DUK_HEAP_STRING_EVAL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVAL)
#define DUK_HTHREAD_STRING_EVAL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVAL)
#define DUK_HEAP_STRING_URI_ERROR(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_URI_ERROR)
#define DUK_HTHREAD_STRING_URI_ERROR(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_URI_ERROR)
#define DUK_HEAP_STRING_TYPE_ERROR(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPE_ERROR)
#define DUK_HTHREAD_STRING_TYPE_ERROR(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPE_ERROR)
#define DUK_HEAP_STRING_SYNTAX_ERROR(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SYNTAX_ERROR)
#define DUK_HTHREAD_STRING_SYNTAX_ERROR(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SYNTAX_ERROR)
#define DUK_HEAP_STRING_REFERENCE_ERROR(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REFERENCE_ERROR)
#define DUK_HTHREAD_STRING_REFERENCE_ERROR(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REFERENCE_ERROR)
#define DUK_HEAP_STRING_RANGE_ERROR(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RANGE_ERROR)
#define DUK_HTHREAD_STRING_RANGE_ERROR(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RANGE_ERROR)
#define DUK_HEAP_STRING_EVAL_ERROR(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVAL_ERROR)
#define DUK_HTHREAD_STRING_EVAL_ERROR(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVAL_ERROR)
#define DUK_HEAP_STRING_BREAK(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BREAK)
#define DUK_HTHREAD_STRING_BREAK(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BREAK)
#define DUK_HEAP_STRING_CASE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CASE)
#define DUK_HTHREAD_STRING_CASE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CASE)
#define DUK_HEAP_STRING_CATCH(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CATCH)
#define DUK_HTHREAD_STRING_CATCH(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CATCH)
#define DUK_HEAP_STRING_CONTINUE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONTINUE)
#define DUK_HTHREAD_STRING_CONTINUE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONTINUE)
#define DUK_HEAP_STRING_DEBUGGER(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEBUGGER)
#define DUK_HTHREAD_STRING_DEBUGGER(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEBUGGER)
#define DUK_HEAP_STRING_DEFAULT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFAULT)
#define DUK_HTHREAD_STRING_DEFAULT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFAULT)
#define DUK_HEAP_STRING_DELETE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DELETE)
#define DUK_HTHREAD_STRING_DELETE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DELETE)
#define DUK_HEAP_STRING_DO(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DO)
#define DUK_HTHREAD_STRING_DO(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DO)
#define DUK_HEAP_STRING_ELSE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ELSE)
#define DUK_HTHREAD_STRING_ELSE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ELSE)
#define DUK_HEAP_STRING_FINALLY(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FINALLY)
#define DUK_HTHREAD_STRING_FINALLY(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FINALLY)
#define DUK_HEAP_STRING_FOR(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FOR)
#define DUK_HTHREAD_STRING_FOR(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FOR)
#define DUK_HEAP_STRING_LC_FUNCTION(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_FUNCTION)
#define DUK_HTHREAD_STRING_LC_FUNCTION(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_FUNCTION)
#define DUK_HEAP_STRING_IF(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IF)
#define DUK_HTHREAD_STRING_IF(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IF)
#define DUK_HEAP_STRING_IN(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IN)
#define DUK_HTHREAD_STRING_IN(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IN)
#define DUK_HEAP_STRING_INSTANCEOF(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INSTANCEOF)
#define DUK_HTHREAD_STRING_INSTANCEOF(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INSTANCEOF)
#define DUK_HEAP_STRING_NEW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEW)
#define DUK_HTHREAD_STRING_NEW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEW)
#define DUK_HEAP_STRING_RETURN(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RETURN)
#define DUK_HTHREAD_STRING_RETURN(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RETURN)
#define DUK_HEAP_STRING_SWITCH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SWITCH)
#define DUK_HTHREAD_STRING_SWITCH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SWITCH)
#define DUK_HEAP_STRING_THIS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THIS)
#define DUK_HTHREAD_STRING_THIS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THIS)
#define DUK_HEAP_STRING_THROW(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THROW)
#define DUK_HTHREAD_STRING_THROW(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THROW)
#define DUK_HEAP_STRING_TRY(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRY)
#define DUK_HTHREAD_STRING_TRY(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRY)
#define DUK_HEAP_STRING_TYPEOF(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPEOF)
#define DUK_HTHREAD_STRING_TYPEOF(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPEOF)
#define DUK_HEAP_STRING_VAR(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VAR)
#define DUK_HTHREAD_STRING_VAR(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VAR)
#define DUK_HEAP_STRING_CONST(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONST)
#define DUK_HTHREAD_STRING_CONST(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONST)
#define DUK_HEAP_STRING_VOID(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VOID)
#define DUK_HTHREAD_STRING_VOID(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VOID)
#define DUK_HEAP_STRING_WHILE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WHILE)
#define DUK_HTHREAD_STRING_WHILE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WHILE)
#define DUK_HEAP_STRING_WITH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WITH)
#define DUK_HTHREAD_STRING_WITH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WITH)
#define DUK_HEAP_STRING_CLASS(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CLASS)
#define DUK_HTHREAD_STRING_CLASS(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CLASS)
#define DUK_HEAP_STRING_ENUM(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUM)
#define DUK_HTHREAD_STRING_ENUM(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUM)
#define DUK_HEAP_STRING_EXPORT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXPORT)
#define DUK_HTHREAD_STRING_EXPORT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXPORT)
#define DUK_HEAP_STRING_EXTENDS(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXTENDS)
#define DUK_HTHREAD_STRING_EXTENDS(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXTENDS)
#define DUK_HEAP_STRING_IMPORT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IMPORT)
#define DUK_HTHREAD_STRING_IMPORT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IMPORT)
#define DUK_HEAP_STRING_SUPER(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUPER)
#define DUK_HTHREAD_STRING_SUPER(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUPER)
#define DUK_HEAP_STRING_LC_NULL(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_NULL)
#define DUK_HTHREAD_STRING_LC_NULL(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_NULL)
#define DUK_HEAP_STRING_TRUE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRUE)
#define DUK_HTHREAD_STRING_TRUE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRUE)
#define DUK_HEAP_STRING_FALSE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FALSE)
#define DUK_HTHREAD_STRING_FALSE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FALSE)
#define DUK_HEAP_STRING_IMPLEMENTS(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IMPLEMENTS)
#define DUK_HTHREAD_STRING_IMPLEMENTS(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IMPLEMENTS)
#define DUK_HEAP_STRING_INTERFACE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INTERFACE)
#define DUK_HTHREAD_STRING_INTERFACE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INTERFACE)
#define DUK_HEAP_STRING_LET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LET)
#define DUK_HTHREAD_STRING_LET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LET)
#define DUK_HEAP_STRING_PACKAGE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PACKAGE)
#define DUK_HTHREAD_STRING_PACKAGE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PACKAGE)
#define DUK_HEAP_STRING_PRIVATE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PRIVATE)
#define DUK_HTHREAD_STRING_PRIVATE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PRIVATE)
#define DUK_HEAP_STRING_PROTECTED(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROTECTED)
#define DUK_HTHREAD_STRING_PROTECTED(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROTECTED)
#define DUK_HEAP_STRING_PUBLIC(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PUBLIC)
#define DUK_HTHREAD_STRING_PUBLIC(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PUBLIC)
#define DUK_HEAP_STRING_STATIC(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STATIC)
#define DUK_HTHREAD_STRING_STATIC(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STATIC)
#define DUK_HEAP_STRING_YIELD(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_YIELD)
#define DUK_HTHREAD_STRING_YIELD(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_YIELD)

#define DUK_HEAP_NUM_STRINGS                                          414

#define DUK_STRIDX_START_RESERVED                                     369
#define DUK_STRIDX_START_STRICT_RESERVED                              405
#define DUK_STRIDX_END_RESERVED                                       414                            /* exclusive endpoint */

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const duk_c_function duk_bi_native_functions[149];
DUK_INTERNAL_DECL const duk_uint8_t duk_builtins_data[1955];
#ifdef DUK_USE_BUILTIN_INITJS
DUK_INTERNAL_DECL const duk_uint8_t duk_initjs_data[187];
#endif  /* DUK_USE_BUILTIN_INITJS */
#endif  /* !DUK_SINGLE_FILE */

#define DUK_BUILTINS_DATA_LENGTH                                      1955
#ifdef DUK_USE_BUILTIN_INITJS
#define DUK_BUILTIN_INITJS_DATA_LENGTH                                187
#endif  /* DUK_USE_BUILTIN_INITJS */

#define DUK_BIDX_GLOBAL                                               0
#define DUK_BIDX_GLOBAL_ENV                                           1
#define DUK_BIDX_OBJECT_CONSTRUCTOR                                   2
#define DUK_BIDX_OBJECT_PROTOTYPE                                     3
#define DUK_BIDX_FUNCTION_CONSTRUCTOR                                 4
#define DUK_BIDX_FUNCTION_PROTOTYPE                                   5
#define DUK_BIDX_ARRAY_CONSTRUCTOR                                    6
#define DUK_BIDX_ARRAY_PROTOTYPE                                      7
#define DUK_BIDX_STRING_CONSTRUCTOR                                   8
#define DUK_BIDX_STRING_PROTOTYPE                                     9
#define DUK_BIDX_BOOLEAN_CONSTRUCTOR                                  10
#define DUK_BIDX_BOOLEAN_PROTOTYPE                                    11
#define DUK_BIDX_NUMBER_CONSTRUCTOR                                   12
#define DUK_BIDX_NUMBER_PROTOTYPE                                     13
#define DUK_BIDX_DATE_CONSTRUCTOR                                     14
#define DUK_BIDX_DATE_PROTOTYPE                                       15
#define DUK_BIDX_REGEXP_CONSTRUCTOR                                   16
#define DUK_BIDX_REGEXP_PROTOTYPE                                     17
#define DUK_BIDX_ERROR_CONSTRUCTOR                                    18
#define DUK_BIDX_ERROR_PROTOTYPE                                      19
#define DUK_BIDX_EVAL_ERROR_CONSTRUCTOR                               20
#define DUK_BIDX_EVAL_ERROR_PROTOTYPE                                 21
#define DUK_BIDX_RANGE_ERROR_CONSTRUCTOR                              22
#define DUK_BIDX_RANGE_ERROR_PROTOTYPE                                23
#define DUK_BIDX_REFERENCE_ERROR_CONSTRUCTOR                          24
#define DUK_BIDX_REFERENCE_ERROR_PROTOTYPE                            25
#define DUK_BIDX_SYNTAX_ERROR_CONSTRUCTOR                             26
#define DUK_BIDX_SYNTAX_ERROR_PROTOTYPE                               27
#define DUK_BIDX_TYPE_ERROR_CONSTRUCTOR                               28
#define DUK_BIDX_TYPE_ERROR_PROTOTYPE                                 29
#define DUK_BIDX_URI_ERROR_CONSTRUCTOR                                30
#define DUK_BIDX_URI_ERROR_PROTOTYPE                                  31
#define DUK_BIDX_MATH                                                 32
#define DUK_BIDX_JSON                                                 33
#define DUK_BIDX_TYPE_ERROR_THROWER                                   34
#define DUK_BIDX_PROXY_CONSTRUCTOR                                    35
#define DUK_BIDX_DUKTAPE                                              36
#define DUK_BIDX_THREAD_CONSTRUCTOR                                   37
#define DUK_BIDX_THREAD_PROTOTYPE                                     38
#define DUK_BIDX_BUFFER_CONSTRUCTOR                                   39
#define DUK_BIDX_BUFFER_PROTOTYPE                                     40
#define DUK_BIDX_POINTER_CONSTRUCTOR                                  41
#define DUK_BIDX_POINTER_PROTOTYPE                                    42
#define DUK_BIDX_LOGGER_CONSTRUCTOR                                   43
#define DUK_BIDX_LOGGER_PROTOTYPE                                     44
#define DUK_BIDX_DOUBLE_ERROR                                         45
#define DUK_BIDX_ARRAYBUFFER_CONSTRUCTOR                              46
#define DUK_BIDX_ARRAYBUFFER_PROTOTYPE                                47
#define DUK_BIDX_DATAVIEW_CONSTRUCTOR                                 48
#define DUK_BIDX_DATAVIEW_PROTOTYPE                                   49
#define DUK_BIDX_TYPEDARRAY_PROTOTYPE                                 50
#define DUK_BIDX_INT8ARRAY_CONSTRUCTOR                                51
#define DUK_BIDX_INT8ARRAY_PROTOTYPE                                  52
#define DUK_BIDX_UINT8ARRAY_CONSTRUCTOR                               53
#define DUK_BIDX_UINT8ARRAY_PROTOTYPE                                 54
#define DUK_BIDX_UINT8CLAMPEDARRAY_CONSTRUCTOR                        55
#define DUK_BIDX_UINT8CLAMPEDARRAY_PROTOTYPE                          56
#define DUK_BIDX_INT16ARRAY_CONSTRUCTOR                               57
#define DUK_BIDX_INT16ARRAY_PROTOTYPE                                 58
#define DUK_BIDX_UINT16ARRAY_CONSTRUCTOR                              59
#define DUK_BIDX_UINT16ARRAY_PROTOTYPE                                60
#define DUK_BIDX_INT32ARRAY_CONSTRUCTOR                               61
#define DUK_BIDX_INT32ARRAY_PROTOTYPE                                 62
#define DUK_BIDX_UINT32ARRAY_CONSTRUCTOR                              63
#define DUK_BIDX_UINT32ARRAY_PROTOTYPE                                64
#define DUK_BIDX_FLOAT32ARRAY_CONSTRUCTOR                             65
#define DUK_BIDX_FLOAT32ARRAY_PROTOTYPE                               66
#define DUK_BIDX_FLOAT64ARRAY_CONSTRUCTOR                             67
#define DUK_BIDX_FLOAT64ARRAY_PROTOTYPE                               68
#define DUK_BIDX_NODEJS_BUFFER_CONSTRUCTOR                            69
#define DUK_BIDX_NODEJS_BUFFER_PROTOTYPE                              70

#define DUK_NUM_BUILTINS                                              71

#elif defined(DUK_USE_DOUBLE_ME)
#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const duk_uint8_t duk_strings_data[2624];
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STRDATA_DATA_LENGTH                                       2624
#define DUK_STRDATA_MAX_STRLEN                                        24

#define DUK_STRIDX_UC_LOGGER                                          0                              /* 'Logger' */
#define DUK_STRIDX_UC_THREAD                                          1                              /* 'Thread' */
#define DUK_STRIDX_UC_POINTER                                         2                              /* 'Pointer' */
#define DUK_STRIDX_DEC_ENV                                            3                              /* 'DecEnv' */
#define DUK_STRIDX_OBJ_ENV                                            4                              /* 'ObjEnv' */
#define DUK_STRIDX_FLOAT64_ARRAY                                      5                              /* 'Float64Array' */
#define DUK_STRIDX_FLOAT32_ARRAY                                      6                              /* 'Float32Array' */
#define DUK_STRIDX_UINT32_ARRAY                                       7                              /* 'Uint32Array' */
#define DUK_STRIDX_INT32_ARRAY                                        8                              /* 'Int32Array' */
#define DUK_STRIDX_UINT16_ARRAY                                       9                              /* 'Uint16Array' */
#define DUK_STRIDX_INT16_ARRAY                                        10                             /* 'Int16Array' */
#define DUK_STRIDX_UINT8_CLAMPED_ARRAY                                11                             /* 'Uint8ClampedArray' */
#define DUK_STRIDX_UINT8_ARRAY                                        12                             /* 'Uint8Array' */
#define DUK_STRIDX_INT8_ARRAY                                         13                             /* 'Int8Array' */
#define DUK_STRIDX_DATA_VIEW                                          14                             /* 'DataView' */
#define DUK_STRIDX_ARRAY_BUFFER                                       15                             /* 'ArrayBuffer' */
#define DUK_STRIDX_UC_BUFFER                                          16                             /* 'Buffer' */
#define DUK_STRIDX_EMPTY_STRING                                       17                             /* '' */
#define DUK_STRIDX_GLOBAL                                             18                             /* 'global' */
#define DUK_STRIDX_UC_ARGUMENTS                                       19                             /* 'Arguments' */
#define DUK_STRIDX_JSON                                               20                             /* 'JSON' */
#define DUK_STRIDX_MATH                                               21                             /* 'Math' */
#define DUK_STRIDX_UC_ERROR                                           22                             /* 'Error' */
#define DUK_STRIDX_REG_EXP                                            23                             /* 'RegExp' */
#define DUK_STRIDX_DATE                                               24                             /* 'Date' */
#define DUK_STRIDX_UC_NUMBER                                          25                             /* 'Number' */
#define DUK_STRIDX_UC_BOOLEAN                                         26                             /* 'Boolean' */
#define DUK_STRIDX_UC_STRING                                          27                             /* 'String' */
#define DUK_STRIDX_ARRAY                                              28                             /* 'Array' */
#define DUK_STRIDX_UC_FUNCTION                                        29                             /* 'Function' */
#define DUK_STRIDX_UC_OBJECT                                          30                             /* 'Object' */
#define DUK_STRIDX_UC_NULL                                            31                             /* 'Null' */
#define DUK_STRIDX_UC_UNDEFINED                                       32                             /* 'Undefined' */
#define DUK_STRIDX_JSON_EXT_FUNCTION2                                 33                             /* '{_func:true}' */
#define DUK_STRIDX_JSON_EXT_FUNCTION1                                 34                             /* '{"_func":true}' */
#define DUK_STRIDX_JSON_EXT_NEGINF                                    35                             /* '{"_ninf":true}' */
#define DUK_STRIDX_JSON_EXT_POSINF                                    36                             /* '{"_inf":true}' */
#define DUK_STRIDX_JSON_EXT_NAN                                       37                             /* '{"_nan":true}' */
#define DUK_STRIDX_JSON_EXT_UNDEFINED                                 38                             /* '{"_undef":true}' */
#define DUK_STRIDX_TO_LOG_STRING                                      39                             /* 'toLogString' */
#define DUK_STRIDX_CLOG                                               40                             /* 'clog' */
#define DUK_STRIDX_LC_L                                               41                             /* 'l' */
#define DUK_STRIDX_LC_N                                               42                             /* 'n' */
#define DUK_STRIDX_LC_FATAL                                           43                             /* 'fatal' */
#define DUK_STRIDX_LC_ERROR                                           44                             /* 'error' */
#define DUK_STRIDX_LC_WARN                                            45                             /* 'warn' */
#define DUK_STRIDX_LC_DEBUG                                           46                             /* 'debug' */
#define DUK_STRIDX_LC_TRACE                                           47                             /* 'trace' */
#define DUK_STRIDX_RAW                                                48                             /* 'raw' */
#define DUK_STRIDX_FMT                                                49                             /* 'fmt' */
#define DUK_STRIDX_CURRENT                                            50                             /* 'current' */
#define DUK_STRIDX_RESUME                                             51                             /* 'resume' */
#define DUK_STRIDX_COMPACT                                            52                             /* 'compact' */
#define DUK_STRIDX_JC                                                 53                             /* 'jc' */
#define DUK_STRIDX_JX                                                 54                             /* 'jx' */
#define DUK_STRIDX_BASE64                                             55                             /* 'base64' */
#define DUK_STRIDX_HEX                                                56                             /* 'hex' */
#define DUK_STRIDX_DEC                                                57                             /* 'dec' */
#define DUK_STRIDX_ENC                                                58                             /* 'enc' */
#define DUK_STRIDX_FIN                                                59                             /* 'fin' */
#define DUK_STRIDX_GC                                                 60                             /* 'gc' */
#define DUK_STRIDX_ACT                                                61                             /* 'act' */
#define DUK_STRIDX_LC_INFO                                            62                             /* 'info' */
#define DUK_STRIDX_VERSION                                            63                             /* 'version' */
#define DUK_STRIDX_ENV                                                64                             /* 'env' */
#define DUK_STRIDX_MOD_LOADED                                         65                             /* 'modLoaded' */
#define DUK_STRIDX_MOD_SEARCH                                         66                             /* 'modSearch' */
#define DUK_STRIDX_ERR_THROW                                          67                             /* 'errThrow' */
#define DUK_STRIDX_ERR_CREATE                                         68                             /* 'errCreate' */
#define DUK_STRIDX_COMPILE                                            69                             /* 'compile' */
#define DUK_STRIDX_INT_REGBASE                                        70                             /* '\x00Regbase' */
#define DUK_STRIDX_INT_THREAD                                         71                             /* '\x00Thread' */
#define DUK_STRIDX_INT_HANDLER                                        72                             /* '\x00Handler' */
#define DUK_STRIDX_INT_FINALIZER                                      73                             /* '\x00Finalizer' */
#define DUK_STRIDX_INT_CALLEE                                         74                             /* '\x00Callee' */
#define DUK_STRIDX_INT_MAP                                            75                             /* '\x00Map' */
#define DUK_STRIDX_INT_ARGS                                           76                             /* '\x00Args' */
#define DUK_STRIDX_INT_THIS                                           77                             /* '\x00This' */
#define DUK_STRIDX_INT_PC2LINE                                        78                             /* '\x00Pc2line' */
#define DUK_STRIDX_INT_SOURCE                                         79                             /* '\x00Source' */
#define DUK_STRIDX_INT_VARENV                                         80                             /* '\x00Varenv' */
#define DUK_STRIDX_INT_LEXENV                                         81                             /* '\x00Lexenv' */
#define DUK_STRIDX_INT_VARMAP                                         82                             /* '\x00Varmap' */
#define DUK_STRIDX_INT_FORMALS                                        83                             /* '\x00Formals' */
#define DUK_STRIDX_INT_BYTECODE                                       84                             /* '\x00Bytecode' */
#define DUK_STRIDX_INT_NEXT                                           85                             /* '\x00Next' */
#define DUK_STRIDX_INT_TARGET                                         86                             /* '\x00Target' */
#define DUK_STRIDX_INT_VALUE                                          87                             /* '\x00Value' */
#define DUK_STRIDX_LC_POINTER                                         88                             /* 'pointer' */
#define DUK_STRIDX_INT_TRACEDATA                                      89                             /* '\x00Tracedata' */
#define DUK_STRIDX_LINE_NUMBER                                        90                             /* 'lineNumber' */
#define DUK_STRIDX_FILE_NAME                                          91                             /* 'fileName' */
#define DUK_STRIDX_PC                                                 92                             /* 'pc' */
#define DUK_STRIDX_STACK                                              93                             /* 'stack' */
#define DUK_STRIDX_THROW_TYPE_ERROR                                   94                             /* 'ThrowTypeError' */
#define DUK_STRIDX_DUKTAPE                                            95                             /* 'Duktape' */
#define DUK_STRIDX_SET_FLOAT64                                        96                             /* 'setFloat64' */
#define DUK_STRIDX_SET_FLOAT32                                        97                             /* 'setFloat32' */
#define DUK_STRIDX_SET_UINT32                                         98                             /* 'setUint32' */
#define DUK_STRIDX_SET_INT32                                          99                             /* 'setInt32' */
#define DUK_STRIDX_SET_UINT16                                         100                            /* 'setUint16' */
#define DUK_STRIDX_SET_INT16                                          101                            /* 'setInt16' */
#define DUK_STRIDX_SET_UINT8                                          102                            /* 'setUint8' */
#define DUK_STRIDX_SET_INT8                                           103                            /* 'setInt8' */
#define DUK_STRIDX_GET_FLOAT64                                        104                            /* 'getFloat64' */
#define DUK_STRIDX_GET_FLOAT32                                        105                            /* 'getFloat32' */
#define DUK_STRIDX_GET_UINT32                                         106                            /* 'getUint32' */
#define DUK_STRIDX_GET_INT32                                          107                            /* 'getInt32' */
#define DUK_STRIDX_GET_UINT16                                         108                            /* 'getUint16' */
#define DUK_STRIDX_GET_INT16                                          109                            /* 'getInt16' */
#define DUK_STRIDX_GET_UINT8                                          110                            /* 'getUint8' */
#define DUK_STRIDX_GET_INT8                                           111                            /* 'getInt8' */
#define DUK_STRIDX_SUBARRAY                                           112                            /* 'subarray' */
#define DUK_STRIDX_BYTES_PER_ELEMENT                                  113                            /* 'BYTES_PER_ELEMENT' */
#define DUK_STRIDX_BYTE_OFFSET                                        114                            /* 'byteOffset' */
#define DUK_STRIDX_LC_BUFFER                                          115                            /* 'buffer' */
#define DUK_STRIDX_IS_VIEW                                            116                            /* 'isView' */
#define DUK_STRIDX_DATA                                               117                            /* 'data' */
#define DUK_STRIDX_TYPE                                               118                            /* 'type' */
#define DUK_STRIDX_WRITE_INT_BE                                       119                            /* 'writeIntBE' */
#define DUK_STRIDX_WRITE_INT_LE                                       120                            /* 'writeIntLE' */
#define DUK_STRIDX_WRITE_UINT_BE                                      121                            /* 'writeUIntBE' */
#define DUK_STRIDX_WRITE_UINT_LE                                      122                            /* 'writeUIntLE' */
#define DUK_STRIDX_WRITE_DOUBLE_BE                                    123                            /* 'writeDoubleBE' */
#define DUK_STRIDX_WRITE_DOUBLE_LE                                    124                            /* 'writeDoubleLE' */
#define DUK_STRIDX_WRITE_FLOAT_BE                                     125                            /* 'writeFloatBE' */
#define DUK_STRIDX_WRITE_FLOAT_LE                                     126                            /* 'writeFloatLE' */
#define DUK_STRIDX_WRITE_INT32_BE                                     127                            /* 'writeInt32BE' */
#define DUK_STRIDX_WRITE_INT32_LE                                     128                            /* 'writeInt32LE' */
#define DUK_STRIDX_WRITE_UINT32_BE                                    129                            /* 'writeUInt32BE' */
#define DUK_STRIDX_WRITE_UINT32_LE                                    130                            /* 'writeUInt32LE' */
#define DUK_STRIDX_WRITE_INT16_BE                                     131                            /* 'writeInt16BE' */
#define DUK_STRIDX_WRITE_INT16_LE                                     132                            /* 'writeInt16LE' */
#define DUK_STRIDX_WRITE_UINT16_BE                                    133                            /* 'writeUInt16BE' */
#define DUK_STRIDX_WRITE_UINT16_LE                                    134                            /* 'writeUInt16LE' */
#define DUK_STRIDX_WRITE_INT8                                         135                            /* 'writeInt8' */
#define DUK_STRIDX_WRITE_UINT8                                        136                            /* 'writeUInt8' */
#define DUK_STRIDX_READ_INT_BE                                        137                            /* 'readIntBE' */
#define DUK_STRIDX_READ_INT_LE                                        138                            /* 'readIntLE' */
#define DUK_STRIDX_READ_UINT_BE                                       139                            /* 'readUIntBE' */
#define DUK_STRIDX_READ_UINT_LE                                       140                            /* 'readUIntLE' */
#define DUK_STRIDX_READ_DOUBLE_BE                                     141                            /* 'readDoubleBE' */
#define DUK_STRIDX_READ_DOUBLE_LE                                     142                            /* 'readDoubleLE' */
#define DUK_STRIDX_READ_FLOAT_BE                                      143                            /* 'readFloatBE' */
#define DUK_STRIDX_READ_FLOAT_LE                                      144                            /* 'readFloatLE' */
#define DUK_STRIDX_READ_INT32_BE                                      145                            /* 'readInt32BE' */
#define DUK_STRIDX_READ_INT32_LE                                      146                            /* 'readInt32LE' */
#define DUK_STRIDX_READ_UINT32_BE                                     147                            /* 'readUInt32BE' */
#define DUK_STRIDX_READ_UINT32_LE                                     148                            /* 'readUInt32LE' */
#define DUK_STRIDX_READ_INT16_BE                                      149                            /* 'readInt16BE' */
#define DUK_STRIDX_READ_INT16_LE                                      150                            /* 'readInt16LE' */
#define DUK_STRIDX_READ_UINT16_BE                                     151                            /* 'readUInt16BE' */
#define DUK_STRIDX_READ_UINT16_LE                                     152                            /* 'readUInt16LE' */
#define DUK_STRIDX_READ_INT8                                          153                            /* 'readInt8' */
#define DUK_STRIDX_READ_UINT8                                         154                            /* 'readUInt8' */
#define DUK_STRIDX_COPY                                               155                            /* 'copy' */
#define DUK_STRIDX_EQUALS                                             156                            /* 'equals' */
#define DUK_STRIDX_FILL                                               157                            /* 'fill' */
#define DUK_STRIDX_WRITE                                              158                            /* 'write' */
#define DUK_STRIDX_COMPARE                                            159                            /* 'compare' */
#define DUK_STRIDX_BYTE_LENGTH                                        160                            /* 'byteLength' */
#define DUK_STRIDX_IS_BUFFER                                          161                            /* 'isBuffer' */
#define DUK_STRIDX_IS_ENCODING                                        162                            /* 'isEncoding' */
#define DUK_STRIDX_EXPORTS                                            163                            /* 'exports' */
#define DUK_STRIDX_ID                                                 164                            /* 'id' */
#define DUK_STRIDX_REQUIRE                                            165                            /* 'require' */
#define DUK_STRIDX___PROTO__                                          166                            /* '__proto__' */
#define DUK_STRIDX_SET_PROTOTYPE_OF                                   167                            /* 'setPrototypeOf' */
#define DUK_STRIDX_OWN_KEYS                                           168                            /* 'ownKeys' */
#define DUK_STRIDX_ENUMERATE                                          169                            /* 'enumerate' */
#define DUK_STRIDX_DELETE_PROPERTY                                    170                            /* 'deleteProperty' */
#define DUK_STRIDX_HAS                                                171                            /* 'has' */
#define DUK_STRIDX_PROXY                                              172                            /* 'Proxy' */
#define DUK_STRIDX_CALLEE                                             173                            /* 'callee' */
#define DUK_STRIDX_INVALID_DATE                                       174                            /* 'Invalid Date' */
#define DUK_STRIDX_BRACKETED_ELLIPSIS                                 175                            /* '[...]' */
#define DUK_STRIDX_NEWLINE_TAB                                        176                            /* '\n\t' */
#define DUK_STRIDX_SPACE                                              177                            /* ' ' */
#define DUK_STRIDX_COMMA                                              178                            /* ',' */
#define DUK_STRIDX_MINUS_ZERO                                         179                            /* '-0' */
#define DUK_STRIDX_PLUS_ZERO                                          180                            /* '+0' */
#define DUK_STRIDX_ZERO                                               181                            /* '0' */
#define DUK_STRIDX_MINUS_INFINITY                                     182                            /* '-Infinity' */
#define DUK_STRIDX_PLUS_INFINITY                                      183                            /* '+Infinity' */
#define DUK_STRIDX_INFINITY                                           184                            /* 'Infinity' */
#define DUK_STRIDX_LC_OBJECT                                          185                            /* 'object' */
#define DUK_STRIDX_LC_STRING                                          186                            /* 'string' */
#define DUK_STRIDX_LC_NUMBER                                          187                            /* 'number' */
#define DUK_STRIDX_LC_BOOLEAN                                         188                            /* 'boolean' */
#define DUK_STRIDX_LC_UNDEFINED                                       189                            /* 'undefined' */
#define DUK_STRIDX_STRINGIFY                                          190                            /* 'stringify' */
#define DUK_STRIDX_TAN                                                191                            /* 'tan' */
#define DUK_STRIDX_SQRT                                               192                            /* 'sqrt' */
#define DUK_STRIDX_SIN                                                193                            /* 'sin' */
#define DUK_STRIDX_ROUND                                              194                            /* 'round' */
#define DUK_STRIDX_RANDOM                                             195                            /* 'random' */
#define DUK_STRIDX_POW                                                196                            /* 'pow' */
#define DUK_STRIDX_MIN                                                197                            /* 'min' */
#define DUK_STRIDX_MAX                                                198                            /* 'max' */
#define DUK_STRIDX_LOG                                                199                            /* 'log' */
#define DUK_STRIDX_FLOOR                                              200                            /* 'floor' */
#define DUK_STRIDX_EXP                                                201                            /* 'exp' */
#define DUK_STRIDX_COS                                                202                            /* 'cos' */
#define DUK_STRIDX_CEIL                                               203                            /* 'ceil' */
#define DUK_STRIDX_ATAN2                                              204                            /* 'atan2' */
#define DUK_STRIDX_ATAN                                               205                            /* 'atan' */
#define DUK_STRIDX_ASIN                                               206                            /* 'asin' */
#define DUK_STRIDX_ACOS                                               207                            /* 'acos' */
#define DUK_STRIDX_ABS                                                208                            /* 'abs' */
#define DUK_STRIDX_SQRT2                                              209                            /* 'SQRT2' */
#define DUK_STRIDX_SQRT1_2                                            210                            /* 'SQRT1_2' */
#define DUK_STRIDX_PI                                                 211                            /* 'PI' */
#define DUK_STRIDX_LOG10E                                             212                            /* 'LOG10E' */
#define DUK_STRIDX_LOG2E                                              213                            /* 'LOG2E' */
#define DUK_STRIDX_LN2                                                214                            /* 'LN2' */
#define DUK_STRIDX_LN10                                               215                            /* 'LN10' */
#define DUK_STRIDX_E                                                  216                            /* 'E' */
#define DUK_STRIDX_MESSAGE                                            217                            /* 'message' */
#define DUK_STRIDX_NAME                                               218                            /* 'name' */
#define DUK_STRIDX_INPUT                                              219                            /* 'input' */
#define DUK_STRIDX_INDEX                                              220                            /* 'index' */
#define DUK_STRIDX_ESCAPED_EMPTY_REGEXP                               221                            /* '(?:)' */
#define DUK_STRIDX_LAST_INDEX                                         222                            /* 'lastIndex' */
#define DUK_STRIDX_MULTILINE                                          223                            /* 'multiline' */
#define DUK_STRIDX_IGNORE_CASE                                        224                            /* 'ignoreCase' */
#define DUK_STRIDX_SOURCE                                             225                            /* 'source' */
#define DUK_STRIDX_TEST                                               226                            /* 'test' */
#define DUK_STRIDX_EXEC                                               227                            /* 'exec' */
#define DUK_STRIDX_TO_GMT_STRING                                      228                            /* 'toGMTString' */
#define DUK_STRIDX_SET_YEAR                                           229                            /* 'setYear' */
#define DUK_STRIDX_GET_YEAR                                           230                            /* 'getYear' */
#define DUK_STRIDX_TO_JSON                                            231                            /* 'toJSON' */
#define DUK_STRIDX_TO_ISO_STRING                                      232                            /* 'toISOString' */
#define DUK_STRIDX_TO_UTC_STRING                                      233                            /* 'toUTCString' */
#define DUK_STRIDX_SET_UTC_FULL_YEAR                                  234                            /* 'setUTCFullYear' */
#define DUK_STRIDX_SET_FULL_YEAR                                      235                            /* 'setFullYear' */
#define DUK_STRIDX_SET_UTC_MONTH                                      236                            /* 'setUTCMonth' */
#define DUK_STRIDX_SET_MONTH                                          237                            /* 'setMonth' */
#define DUK_STRIDX_SET_UTC_DATE                                       238                            /* 'setUTCDate' */
#define DUK_STRIDX_SET_DATE                                           239                            /* 'setDate' */
#define DUK_STRIDX_SET_UTC_HOURS                                      240                            /* 'setUTCHours' */
#define DUK_STRIDX_SET_HOURS                                          241                            /* 'setHours' */
#define DUK_STRIDX_SET_UTC_MINUTES                                    242                            /* 'setUTCMinutes' */
#define DUK_STRIDX_SET_MINUTES                                        243                            /* 'setMinutes' */
#define DUK_STRIDX_SET_UTC_SECONDS                                    244                            /* 'setUTCSeconds' */
#define DUK_STRIDX_SET_SECONDS                                        245                            /* 'setSeconds' */
#define DUK_STRIDX_SET_UTC_MILLISECONDS                               246                            /* 'setUTCMilliseconds' */
#define DUK_STRIDX_SET_MILLISECONDS                                   247                            /* 'setMilliseconds' */
#define DUK_STRIDX_SET_TIME                                           248                            /* 'setTime' */
#define DUK_STRIDX_GET_TIMEZONE_OFFSET                                249                            /* 'getTimezoneOffset' */
#define DUK_STRIDX_GET_UTC_MILLISECONDS                               250                            /* 'getUTCMilliseconds' */
#define DUK_STRIDX_GET_MILLISECONDS                                   251                            /* 'getMilliseconds' */
#define DUK_STRIDX_GET_UTC_SECONDS                                    252                            /* 'getUTCSeconds' */
#define DUK_STRIDX_GET_SECONDS                                        253                            /* 'getSeconds' */
#define DUK_STRIDX_GET_UTC_MINUTES                                    254                            /* 'getUTCMinutes' */
#define DUK_STRIDX_GET_MINUTES                                        255                            /* 'getMinutes' */
#define DUK_STRIDX_GET_UTC_HOURS                                      256                            /* 'getUTCHours' */
#define DUK_STRIDX_GET_HOURS                                          257                            /* 'getHours' */
#define DUK_STRIDX_GET_UTC_DAY                                        258                            /* 'getUTCDay' */
#define DUK_STRIDX_GET_DAY                                            259                            /* 'getDay' */
#define DUK_STRIDX_GET_UTC_DATE                                       260                            /* 'getUTCDate' */
#define DUK_STRIDX_GET_DATE                                           261                            /* 'getDate' */
#define DUK_STRIDX_GET_UTC_MONTH                                      262                            /* 'getUTCMonth' */
#define DUK_STRIDX_GET_MONTH                                          263                            /* 'getMonth' */
#define DUK_STRIDX_GET_UTC_FULL_YEAR                                  264                            /* 'getUTCFullYear' */
#define DUK_STRIDX_GET_FULL_YEAR                                      265                            /* 'getFullYear' */
#define DUK_STRIDX_GET_TIME                                           266                            /* 'getTime' */
#define DUK_STRIDX_TO_LOCALE_TIME_STRING                              267                            /* 'toLocaleTimeString' */
#define DUK_STRIDX_TO_LOCALE_DATE_STRING                              268                            /* 'toLocaleDateString' */
#define DUK_STRIDX_TO_TIME_STRING                                     269                            /* 'toTimeString' */
#define DUK_STRIDX_TO_DATE_STRING                                     270                            /* 'toDateString' */
#define DUK_STRIDX_NOW                                                271                            /* 'now' */
#define DUK_STRIDX_UTC                                                272                            /* 'UTC' */
#define DUK_STRIDX_PARSE                                              273                            /* 'parse' */
#define DUK_STRIDX_TO_PRECISION                                       274                            /* 'toPrecision' */
#define DUK_STRIDX_TO_EXPONENTIAL                                     275                            /* 'toExponential' */
#define DUK_STRIDX_TO_FIXED                                           276                            /* 'toFixed' */
#define DUK_STRIDX_POSITIVE_INFINITY                                  277                            /* 'POSITIVE_INFINITY' */
#define DUK_STRIDX_NEGATIVE_INFINITY                                  278                            /* 'NEGATIVE_INFINITY' */
#define DUK_STRIDX_NAN                                                279                            /* 'NaN' */
#define DUK_STRIDX_MIN_VALUE                                          280                            /* 'MIN_VALUE' */
#define DUK_STRIDX_MAX_VALUE                                          281                            /* 'MAX_VALUE' */
#define DUK_STRIDX_SUBSTR                                             282                            /* 'substr' */
#define DUK_STRIDX_TRIM                                               283                            /* 'trim' */
#define DUK_STRIDX_TO_LOCALE_UPPER_CASE                               284                            /* 'toLocaleUpperCase' */
#define DUK_STRIDX_TO_UPPER_CASE                                      285                            /* 'toUpperCase' */
#define DUK_STRIDX_TO_LOCALE_LOWER_CASE                               286                            /* 'toLocaleLowerCase' */
#define DUK_STRIDX_TO_LOWER_CASE                                      287                            /* 'toLowerCase' */
#define DUK_STRIDX_SUBSTRING                                          288                            /* 'substring' */
#define DUK_STRIDX_SPLIT                                              289                            /* 'split' */
#define DUK_STRIDX_SEARCH                                             290                            /* 'search' */
#define DUK_STRIDX_REPLACE                                            291                            /* 'replace' */
#define DUK_STRIDX_MATCH                                              292                            /* 'match' */
#define DUK_STRIDX_LOCALE_COMPARE                                     293                            /* 'localeCompare' */
#define DUK_STRIDX_CHAR_CODE_AT                                       294                            /* 'charCodeAt' */
#define DUK_STRIDX_CHAR_AT                                            295                            /* 'charAt' */
#define DUK_STRIDX_FROM_CHAR_CODE                                     296                            /* 'fromCharCode' */
#define DUK_STRIDX_REDUCE_RIGHT                                       297                            /* 'reduceRight' */
#define DUK_STRIDX_REDUCE                                             298                            /* 'reduce' */
#define DUK_STRIDX_FILTER                                             299                            /* 'filter' */
#define DUK_STRIDX_MAP                                                300                            /* 'map' */
#define DUK_STRIDX_FOR_EACH                                           301                            /* 'forEach' */
#define DUK_STRIDX_SOME                                               302                            /* 'some' */
#define DUK_STRIDX_EVERY                                              303                            /* 'every' */
#define DUK_STRIDX_LAST_INDEX_OF                                      304                            /* 'lastIndexOf' */
#define DUK_STRIDX_INDEX_OF                                           305                            /* 'indexOf' */
#define DUK_STRIDX_UNSHIFT                                            306                            /* 'unshift' */
#define DUK_STRIDX_SPLICE                                             307                            /* 'splice' */
#define DUK_STRIDX_SORT                                               308                            /* 'sort' */
#define DUK_STRIDX_SLICE                                              309                            /* 'slice' */
#define DUK_STRIDX_SHIFT                                              310                            /* 'shift' */
#define DUK_STRIDX_REVERSE                                            311                            /* 'reverse' */
#define DUK_STRIDX_PUSH                                               312                            /* 'push' */
#define DUK_STRIDX_POP                                                313                            /* 'pop' */
#define DUK_STRIDX_JOIN                                               314                            /* 'join' */
#define DUK_STRIDX_CONCAT                                             315                            /* 'concat' */
#define DUK_STRIDX_IS_ARRAY                                           316                            /* 'isArray' */
#define DUK_STRIDX_LC_ARGUMENTS                                       317                            /* 'arguments' */
#define DUK_STRIDX_CALLER                                             318                            /* 'caller' */
#define DUK_STRIDX_BIND                                               319                            /* 'bind' */
#define DUK_STRIDX_CALL                                               320                            /* 'call' */
#define DUK_STRIDX_APPLY                                              321                            /* 'apply' */
#define DUK_STRIDX_PROPERTY_IS_ENUMERABLE                             322                            /* 'propertyIsEnumerable' */
#define DUK_STRIDX_IS_PROTOTYPE_OF                                    323                            /* 'isPrototypeOf' */
#define DUK_STRIDX_HAS_OWN_PROPERTY                                   324                            /* 'hasOwnProperty' */
#define DUK_STRIDX_VALUE_OF                                           325                            /* 'valueOf' */
#define DUK_STRIDX_TO_LOCALE_STRING                                   326                            /* 'toLocaleString' */
#define DUK_STRIDX_TO_STRING                                          327                            /* 'toString' */
#define DUK_STRIDX_CONSTRUCTOR                                        328                            /* 'constructor' */
#define DUK_STRIDX_SET                                                329                            /* 'set' */
#define DUK_STRIDX_GET                                                330                            /* 'get' */
#define DUK_STRIDX_ENUMERABLE                                         331                            /* 'enumerable' */
#define DUK_STRIDX_CONFIGURABLE                                       332                            /* 'configurable' */
#define DUK_STRIDX_WRITABLE                                           333                            /* 'writable' */
#define DUK_STRIDX_VALUE                                              334                            /* 'value' */
#define DUK_STRIDX_KEYS                                               335                            /* 'keys' */
#define DUK_STRIDX_IS_EXTENSIBLE                                      336                            /* 'isExtensible' */
#define DUK_STRIDX_IS_FROZEN                                          337                            /* 'isFrozen' */
#define DUK_STRIDX_IS_SEALED                                          338                            /* 'isSealed' */
#define DUK_STRIDX_PREVENT_EXTENSIONS                                 339                            /* 'preventExtensions' */
#define DUK_STRIDX_FREEZE                                             340                            /* 'freeze' */
#define DUK_STRIDX_SEAL                                               341                            /* 'seal' */
#define DUK_STRIDX_DEFINE_PROPERTIES                                  342                            /* 'defineProperties' */
#define DUK_STRIDX_DEFINE_PROPERTY                                    343                            /* 'defineProperty' */
#define DUK_STRIDX_CREATE                                             344                            /* 'create' */
#define DUK_STRIDX_GET_OWN_PROPERTY_NAMES                             345                            /* 'getOwnPropertyNames' */
#define DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR                        346                            /* 'getOwnPropertyDescriptor' */
#define DUK_STRIDX_GET_PROTOTYPE_OF                                   347                            /* 'getPrototypeOf' */
#define DUK_STRIDX_PROTOTYPE                                          348                            /* 'prototype' */
#define DUK_STRIDX_LENGTH                                             349                            /* 'length' */
#define DUK_STRIDX_ALERT                                              350                            /* 'alert' */
#define DUK_STRIDX_PRINT                                              351                            /* 'print' */
#define DUK_STRIDX_UNESCAPE                                           352                            /* 'unescape' */
#define DUK_STRIDX_ESCAPE                                             353                            /* 'escape' */
#define DUK_STRIDX_ENCODE_URI_COMPONENT                               354                            /* 'encodeURIComponent' */
#define DUK_STRIDX_ENCODE_URI                                         355                            /* 'encodeURI' */
#define DUK_STRIDX_DECODE_URI_COMPONENT                               356                            /* 'decodeURIComponent' */
#define DUK_STRIDX_DECODE_URI                                         357                            /* 'decodeURI' */
#define DUK_STRIDX_IS_FINITE                                          358                            /* 'isFinite' */
#define DUK_STRIDX_IS_NAN                                             359                            /* 'isNaN' */
#define DUK_STRIDX_PARSE_FLOAT                                        360                            /* 'parseFloat' */
#define DUK_STRIDX_PARSE_INT                                          361                            /* 'parseInt' */
#define DUK_STRIDX_EVAL                                               362                            /* 'eval' */
#define DUK_STRIDX_URI_ERROR                                          363                            /* 'URIError' */
#define DUK_STRIDX_TYPE_ERROR                                         364                            /* 'TypeError' */
#define DUK_STRIDX_SYNTAX_ERROR                                       365                            /* 'SyntaxError' */
#define DUK_STRIDX_REFERENCE_ERROR                                    366                            /* 'ReferenceError' */
#define DUK_STRIDX_RANGE_ERROR                                        367                            /* 'RangeError' */
#define DUK_STRIDX_EVAL_ERROR                                         368                            /* 'EvalError' */
#define DUK_STRIDX_BREAK                                              369                            /* 'break' */
#define DUK_STRIDX_CASE                                               370                            /* 'case' */
#define DUK_STRIDX_CATCH                                              371                            /* 'catch' */
#define DUK_STRIDX_CONTINUE                                           372                            /* 'continue' */
#define DUK_STRIDX_DEBUGGER                                           373                            /* 'debugger' */
#define DUK_STRIDX_DEFAULT                                            374                            /* 'default' */
#define DUK_STRIDX_DELETE                                             375                            /* 'delete' */
#define DUK_STRIDX_DO                                                 376                            /* 'do' */
#define DUK_STRIDX_ELSE                                               377                            /* 'else' */
#define DUK_STRIDX_FINALLY                                            378                            /* 'finally' */
#define DUK_STRIDX_FOR                                                379                            /* 'for' */
#define DUK_STRIDX_LC_FUNCTION                                        380                            /* 'function' */
#define DUK_STRIDX_IF                                                 381                            /* 'if' */
#define DUK_STRIDX_IN                                                 382                            /* 'in' */
#define DUK_STRIDX_INSTANCEOF                                         383                            /* 'instanceof' */
#define DUK_STRIDX_NEW                                                384                            /* 'new' */
#define DUK_STRIDX_RETURN                                             385                            /* 'return' */
#define DUK_STRIDX_SWITCH                                             386                            /* 'switch' */
#define DUK_STRIDX_THIS                                               387                            /* 'this' */
#define DUK_STRIDX_THROW                                              388                            /* 'throw' */
#define DUK_STRIDX_TRY                                                389                            /* 'try' */
#define DUK_STRIDX_TYPEOF                                             390                            /* 'typeof' */
#define DUK_STRIDX_VAR                                                391                            /* 'var' */
#define DUK_STRIDX_CONST                                              392                            /* 'const' */
#define DUK_STRIDX_VOID                                               393                            /* 'void' */
#define DUK_STRIDX_WHILE                                              394                            /* 'while' */
#define DUK_STRIDX_WITH                                               395                            /* 'with' */
#define DUK_STRIDX_CLASS                                              396                            /* 'class' */
#define DUK_STRIDX_ENUM                                               397                            /* 'enum' */
#define DUK_STRIDX_EXPORT                                             398                            /* 'export' */
#define DUK_STRIDX_EXTENDS                                            399                            /* 'extends' */
#define DUK_STRIDX_IMPORT                                             400                            /* 'import' */
#define DUK_STRIDX_SUPER                                              401                            /* 'super' */
#define DUK_STRIDX_LC_NULL                                            402                            /* 'null' */
#define DUK_STRIDX_TRUE                                               403                            /* 'true' */
#define DUK_STRIDX_FALSE                                              404                            /* 'false' */
#define DUK_STRIDX_IMPLEMENTS                                         405                            /* 'implements' */
#define DUK_STRIDX_INTERFACE                                          406                            /* 'interface' */
#define DUK_STRIDX_LET                                                407                            /* 'let' */
#define DUK_STRIDX_PACKAGE                                            408                            /* 'package' */
#define DUK_STRIDX_PRIVATE                                            409                            /* 'private' */
#define DUK_STRIDX_PROTECTED                                          410                            /* 'protected' */
#define DUK_STRIDX_PUBLIC                                             411                            /* 'public' */
#define DUK_STRIDX_STATIC                                             412                            /* 'static' */
#define DUK_STRIDX_YIELD                                              413                            /* 'yield' */

#define DUK_HEAP_STRING_UC_LOGGER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_LOGGER)
#define DUK_HTHREAD_STRING_UC_LOGGER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_LOGGER)
#define DUK_HEAP_STRING_UC_THREAD(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_THREAD)
#define DUK_HTHREAD_STRING_UC_THREAD(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_THREAD)
#define DUK_HEAP_STRING_UC_POINTER(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_POINTER)
#define DUK_HTHREAD_STRING_UC_POINTER(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_POINTER)
#define DUK_HEAP_STRING_DEC_ENV(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEC_ENV)
#define DUK_HTHREAD_STRING_DEC_ENV(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEC_ENV)
#define DUK_HEAP_STRING_OBJ_ENV(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_OBJ_ENV)
#define DUK_HTHREAD_STRING_OBJ_ENV(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_OBJ_ENV)
#define DUK_HEAP_STRING_FLOAT64_ARRAY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOAT64_ARRAY)
#define DUK_HTHREAD_STRING_FLOAT64_ARRAY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOAT64_ARRAY)
#define DUK_HEAP_STRING_FLOAT32_ARRAY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOAT32_ARRAY)
#define DUK_HTHREAD_STRING_FLOAT32_ARRAY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOAT32_ARRAY)
#define DUK_HEAP_STRING_UINT32_ARRAY(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT32_ARRAY)
#define DUK_HTHREAD_STRING_UINT32_ARRAY(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT32_ARRAY)
#define DUK_HEAP_STRING_INT32_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT32_ARRAY)
#define DUK_HTHREAD_STRING_INT32_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT32_ARRAY)
#define DUK_HEAP_STRING_UINT16_ARRAY(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT16_ARRAY)
#define DUK_HTHREAD_STRING_UINT16_ARRAY(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT16_ARRAY)
#define DUK_HEAP_STRING_INT16_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT16_ARRAY)
#define DUK_HTHREAD_STRING_INT16_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT16_ARRAY)
#define DUK_HEAP_STRING_UINT8_CLAMPED_ARRAY(heap)                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT8_CLAMPED_ARRAY)
#define DUK_HTHREAD_STRING_UINT8_CLAMPED_ARRAY(thr)                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT8_CLAMPED_ARRAY)
#define DUK_HEAP_STRING_UINT8_ARRAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UINT8_ARRAY)
#define DUK_HTHREAD_STRING_UINT8_ARRAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UINT8_ARRAY)
#define DUK_HEAP_STRING_INT8_ARRAY(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT8_ARRAY)
#define DUK_HTHREAD_STRING_INT8_ARRAY(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT8_ARRAY)
#define DUK_HEAP_STRING_DATA_VIEW(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATA_VIEW)
#define DUK_HTHREAD_STRING_DATA_VIEW(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATA_VIEW)
#define DUK_HEAP_STRING_ARRAY_BUFFER(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ARRAY_BUFFER)
#define DUK_HTHREAD_STRING_ARRAY_BUFFER(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ARRAY_BUFFER)
#define DUK_HEAP_STRING_UC_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_BUFFER)
#define DUK_HTHREAD_STRING_UC_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_BUFFER)
#define DUK_HEAP_STRING_EMPTY_STRING(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EMPTY_STRING)
#define DUK_HTHREAD_STRING_EMPTY_STRING(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EMPTY_STRING)
#define DUK_HEAP_STRING_GLOBAL(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GLOBAL)
#define DUK_HTHREAD_STRING_GLOBAL(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GLOBAL)
#define DUK_HEAP_STRING_UC_ARGUMENTS(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_ARGUMENTS)
#define DUK_HTHREAD_STRING_UC_ARGUMENTS(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_ARGUMENTS)
#define DUK_HEAP_STRING_JSON(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON)
#define DUK_HTHREAD_STRING_JSON(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON)
#define DUK_HEAP_STRING_MATH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MATH)
#define DUK_HTHREAD_STRING_MATH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MATH)
#define DUK_HEAP_STRING_UC_ERROR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_ERROR)
#define DUK_HTHREAD_STRING_UC_ERROR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_ERROR)
#define DUK_HEAP_STRING_REG_EXP(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REG_EXP)
#define DUK_HTHREAD_STRING_REG_EXP(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REG_EXP)
#define DUK_HEAP_STRING_DATE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATE)
#define DUK_HTHREAD_STRING_DATE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATE)
#define DUK_HEAP_STRING_UC_NUMBER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_NUMBER)
#define DUK_HTHREAD_STRING_UC_NUMBER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_NUMBER)
#define DUK_HEAP_STRING_UC_BOOLEAN(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_BOOLEAN)
#define DUK_HTHREAD_STRING_UC_BOOLEAN(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_BOOLEAN)
#define DUK_HEAP_STRING_UC_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_STRING)
#define DUK_HTHREAD_STRING_UC_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_STRING)
#define DUK_HEAP_STRING_ARRAY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ARRAY)
#define DUK_HTHREAD_STRING_ARRAY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ARRAY)
#define DUK_HEAP_STRING_UC_FUNCTION(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_FUNCTION)
#define DUK_HTHREAD_STRING_UC_FUNCTION(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_FUNCTION)
#define DUK_HEAP_STRING_UC_OBJECT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_OBJECT)
#define DUK_HTHREAD_STRING_UC_OBJECT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_OBJECT)
#define DUK_HEAP_STRING_UC_NULL(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_NULL)
#define DUK_HTHREAD_STRING_UC_NULL(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_NULL)
#define DUK_HEAP_STRING_UC_UNDEFINED(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UC_UNDEFINED)
#define DUK_HTHREAD_STRING_UC_UNDEFINED(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UC_UNDEFINED)
#define DUK_HEAP_STRING_JSON_EXT_FUNCTION2(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_FUNCTION2)
#define DUK_HTHREAD_STRING_JSON_EXT_FUNCTION2(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_FUNCTION2)
#define DUK_HEAP_STRING_JSON_EXT_FUNCTION1(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_FUNCTION1)
#define DUK_HTHREAD_STRING_JSON_EXT_FUNCTION1(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_FUNCTION1)
#define DUK_HEAP_STRING_JSON_EXT_NEGINF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_NEGINF)
#define DUK_HTHREAD_STRING_JSON_EXT_NEGINF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_NEGINF)
#define DUK_HEAP_STRING_JSON_EXT_POSINF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_POSINF)
#define DUK_HTHREAD_STRING_JSON_EXT_POSINF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_POSINF)
#define DUK_HEAP_STRING_JSON_EXT_NAN(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_NAN)
#define DUK_HTHREAD_STRING_JSON_EXT_NAN(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_NAN)
#define DUK_HEAP_STRING_JSON_EXT_UNDEFINED(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JSON_EXT_UNDEFINED)
#define DUK_HTHREAD_STRING_JSON_EXT_UNDEFINED(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JSON_EXT_UNDEFINED)
#define DUK_HEAP_STRING_TO_LOG_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOG_STRING)
#define DUK_HTHREAD_STRING_TO_LOG_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOG_STRING)
#define DUK_HEAP_STRING_CLOG(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CLOG)
#define DUK_HTHREAD_STRING_CLOG(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CLOG)
#define DUK_HEAP_STRING_LC_L(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_L)
#define DUK_HTHREAD_STRING_LC_L(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_L)
#define DUK_HEAP_STRING_LC_N(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_N)
#define DUK_HTHREAD_STRING_LC_N(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_N)
#define DUK_HEAP_STRING_LC_FATAL(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_FATAL)
#define DUK_HTHREAD_STRING_LC_FATAL(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_FATAL)
#define DUK_HEAP_STRING_LC_ERROR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_ERROR)
#define DUK_HTHREAD_STRING_LC_ERROR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_ERROR)
#define DUK_HEAP_STRING_LC_WARN(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_WARN)
#define DUK_HTHREAD_STRING_LC_WARN(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_WARN)
#define DUK_HEAP_STRING_LC_DEBUG(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_DEBUG)
#define DUK_HTHREAD_STRING_LC_DEBUG(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_DEBUG)
#define DUK_HEAP_STRING_LC_TRACE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_TRACE)
#define DUK_HTHREAD_STRING_LC_TRACE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_TRACE)
#define DUK_HEAP_STRING_RAW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RAW)
#define DUK_HTHREAD_STRING_RAW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RAW)
#define DUK_HEAP_STRING_FMT(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FMT)
#define DUK_HTHREAD_STRING_FMT(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FMT)
#define DUK_HEAP_STRING_CURRENT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CURRENT)
#define DUK_HTHREAD_STRING_CURRENT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CURRENT)
#define DUK_HEAP_STRING_RESUME(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RESUME)
#define DUK_HTHREAD_STRING_RESUME(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RESUME)
#define DUK_HEAP_STRING_COMPACT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPACT)
#define DUK_HTHREAD_STRING_COMPACT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPACT)
#define DUK_HEAP_STRING_JC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JC)
#define DUK_HTHREAD_STRING_JC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JC)
#define DUK_HEAP_STRING_JX(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JX)
#define DUK_HTHREAD_STRING_JX(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JX)
#define DUK_HEAP_STRING_BASE64(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BASE64)
#define DUK_HTHREAD_STRING_BASE64(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BASE64)
#define DUK_HEAP_STRING_HEX(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HEX)
#define DUK_HTHREAD_STRING_HEX(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HEX)
#define DUK_HEAP_STRING_DEC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEC)
#define DUK_HTHREAD_STRING_DEC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEC)
#define DUK_HEAP_STRING_ENC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENC)
#define DUK_HTHREAD_STRING_ENC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENC)
#define DUK_HEAP_STRING_FIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FIN)
#define DUK_HTHREAD_STRING_FIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FIN)
#define DUK_HEAP_STRING_GC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GC)
#define DUK_HTHREAD_STRING_GC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GC)
#define DUK_HEAP_STRING_ACT(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ACT)
#define DUK_HTHREAD_STRING_ACT(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ACT)
#define DUK_HEAP_STRING_LC_INFO(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_INFO)
#define DUK_HTHREAD_STRING_LC_INFO(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_INFO)
#define DUK_HEAP_STRING_VERSION(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VERSION)
#define DUK_HTHREAD_STRING_VERSION(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VERSION)
#define DUK_HEAP_STRING_ENV(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENV)
#define DUK_HTHREAD_STRING_ENV(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENV)
#define DUK_HEAP_STRING_MOD_LOADED(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MOD_LOADED)
#define DUK_HTHREAD_STRING_MOD_LOADED(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MOD_LOADED)
#define DUK_HEAP_STRING_MOD_SEARCH(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MOD_SEARCH)
#define DUK_HTHREAD_STRING_MOD_SEARCH(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MOD_SEARCH)
#define DUK_HEAP_STRING_ERR_THROW(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ERR_THROW)
#define DUK_HTHREAD_STRING_ERR_THROW(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ERR_THROW)
#define DUK_HEAP_STRING_ERR_CREATE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ERR_CREATE)
#define DUK_HTHREAD_STRING_ERR_CREATE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ERR_CREATE)
#define DUK_HEAP_STRING_COMPILE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPILE)
#define DUK_HTHREAD_STRING_COMPILE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPILE)
#define DUK_HEAP_STRING_INT_REGBASE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_REGBASE)
#define DUK_HTHREAD_STRING_INT_REGBASE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_REGBASE)
#define DUK_HEAP_STRING_INT_THREAD(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_THREAD)
#define DUK_HTHREAD_STRING_INT_THREAD(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_THREAD)
#define DUK_HEAP_STRING_INT_HANDLER(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_HANDLER)
#define DUK_HTHREAD_STRING_INT_HANDLER(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_HANDLER)
#define DUK_HEAP_STRING_INT_FINALIZER(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_FINALIZER)
#define DUK_HTHREAD_STRING_INT_FINALIZER(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_FINALIZER)
#define DUK_HEAP_STRING_INT_CALLEE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_CALLEE)
#define DUK_HTHREAD_STRING_INT_CALLEE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_CALLEE)
#define DUK_HEAP_STRING_INT_MAP(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_MAP)
#define DUK_HTHREAD_STRING_INT_MAP(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_MAP)
#define DUK_HEAP_STRING_INT_ARGS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_ARGS)
#define DUK_HTHREAD_STRING_INT_ARGS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_ARGS)
#define DUK_HEAP_STRING_INT_THIS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_THIS)
#define DUK_HTHREAD_STRING_INT_THIS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_THIS)
#define DUK_HEAP_STRING_INT_PC2LINE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_PC2LINE)
#define DUK_HTHREAD_STRING_INT_PC2LINE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_PC2LINE)
#define DUK_HEAP_STRING_INT_SOURCE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_SOURCE)
#define DUK_HTHREAD_STRING_INT_SOURCE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_SOURCE)
#define DUK_HEAP_STRING_INT_VARENV(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VARENV)
#define DUK_HTHREAD_STRING_INT_VARENV(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VARENV)
#define DUK_HEAP_STRING_INT_LEXENV(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_LEXENV)
#define DUK_HTHREAD_STRING_INT_LEXENV(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_LEXENV)
#define DUK_HEAP_STRING_INT_VARMAP(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VARMAP)
#define DUK_HTHREAD_STRING_INT_VARMAP(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VARMAP)
#define DUK_HEAP_STRING_INT_FORMALS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_FORMALS)
#define DUK_HTHREAD_STRING_INT_FORMALS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_FORMALS)
#define DUK_HEAP_STRING_INT_BYTECODE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_BYTECODE)
#define DUK_HTHREAD_STRING_INT_BYTECODE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_BYTECODE)
#define DUK_HEAP_STRING_INT_NEXT(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_NEXT)
#define DUK_HTHREAD_STRING_INT_NEXT(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_NEXT)
#define DUK_HEAP_STRING_INT_TARGET(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_TARGET)
#define DUK_HTHREAD_STRING_INT_TARGET(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_TARGET)
#define DUK_HEAP_STRING_INT_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_VALUE)
#define DUK_HTHREAD_STRING_INT_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_VALUE)
#define DUK_HEAP_STRING_LC_POINTER(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_POINTER)
#define DUK_HTHREAD_STRING_LC_POINTER(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_POINTER)
#define DUK_HEAP_STRING_INT_TRACEDATA(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INT_TRACEDATA)
#define DUK_HTHREAD_STRING_INT_TRACEDATA(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INT_TRACEDATA)
#define DUK_HEAP_STRING_LINE_NUMBER(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LINE_NUMBER)
#define DUK_HTHREAD_STRING_LINE_NUMBER(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LINE_NUMBER)
#define DUK_HEAP_STRING_FILE_NAME(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILE_NAME)
#define DUK_HTHREAD_STRING_FILE_NAME(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILE_NAME)
#define DUK_HEAP_STRING_PC(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PC)
#define DUK_HTHREAD_STRING_PC(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PC)
#define DUK_HEAP_STRING_STACK(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STACK)
#define DUK_HTHREAD_STRING_STACK(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STACK)
#define DUK_HEAP_STRING_THROW_TYPE_ERROR(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THROW_TYPE_ERROR)
#define DUK_HTHREAD_STRING_THROW_TYPE_ERROR(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THROW_TYPE_ERROR)
#define DUK_HEAP_STRING_DUKTAPE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DUKTAPE)
#define DUK_HTHREAD_STRING_DUKTAPE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DUKTAPE)
#define DUK_HEAP_STRING_SET_FLOAT64(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FLOAT64)
#define DUK_HTHREAD_STRING_SET_FLOAT64(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FLOAT64)
#define DUK_HEAP_STRING_SET_FLOAT32(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FLOAT32)
#define DUK_HTHREAD_STRING_SET_FLOAT32(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FLOAT32)
#define DUK_HEAP_STRING_SET_UINT32(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT32)
#define DUK_HTHREAD_STRING_SET_UINT32(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT32)
#define DUK_HEAP_STRING_SET_INT32(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT32)
#define DUK_HTHREAD_STRING_SET_INT32(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT32)
#define DUK_HEAP_STRING_SET_UINT16(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT16)
#define DUK_HTHREAD_STRING_SET_UINT16(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT16)
#define DUK_HEAP_STRING_SET_INT16(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT16)
#define DUK_HTHREAD_STRING_SET_INT16(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT16)
#define DUK_HEAP_STRING_SET_UINT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UINT8)
#define DUK_HTHREAD_STRING_SET_UINT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UINT8)
#define DUK_HEAP_STRING_SET_INT8(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_INT8)
#define DUK_HTHREAD_STRING_SET_INT8(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_INT8)
#define DUK_HEAP_STRING_GET_FLOAT64(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FLOAT64)
#define DUK_HTHREAD_STRING_GET_FLOAT64(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FLOAT64)
#define DUK_HEAP_STRING_GET_FLOAT32(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FLOAT32)
#define DUK_HTHREAD_STRING_GET_FLOAT32(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FLOAT32)
#define DUK_HEAP_STRING_GET_UINT32(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT32)
#define DUK_HTHREAD_STRING_GET_UINT32(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT32)
#define DUK_HEAP_STRING_GET_INT32(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT32)
#define DUK_HTHREAD_STRING_GET_INT32(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT32)
#define DUK_HEAP_STRING_GET_UINT16(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT16)
#define DUK_HTHREAD_STRING_GET_UINT16(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT16)
#define DUK_HEAP_STRING_GET_INT16(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT16)
#define DUK_HTHREAD_STRING_GET_INT16(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT16)
#define DUK_HEAP_STRING_GET_UINT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UINT8)
#define DUK_HTHREAD_STRING_GET_UINT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UINT8)
#define DUK_HEAP_STRING_GET_INT8(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_INT8)
#define DUK_HTHREAD_STRING_GET_INT8(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_INT8)
#define DUK_HEAP_STRING_SUBARRAY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBARRAY)
#define DUK_HTHREAD_STRING_SUBARRAY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBARRAY)
#define DUK_HEAP_STRING_BYTES_PER_ELEMENT(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTES_PER_ELEMENT)
#define DUK_HTHREAD_STRING_BYTES_PER_ELEMENT(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTES_PER_ELEMENT)
#define DUK_HEAP_STRING_BYTE_OFFSET(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTE_OFFSET)
#define DUK_HTHREAD_STRING_BYTE_OFFSET(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTE_OFFSET)
#define DUK_HEAP_STRING_LC_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_BUFFER)
#define DUK_HTHREAD_STRING_LC_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_BUFFER)
#define DUK_HEAP_STRING_IS_VIEW(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_VIEW)
#define DUK_HTHREAD_STRING_IS_VIEW(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_VIEW)
#define DUK_HEAP_STRING_DATA(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DATA)
#define DUK_HTHREAD_STRING_DATA(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DATA)
#define DUK_HEAP_STRING_TYPE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPE)
#define DUK_HTHREAD_STRING_TYPE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPE)
#define DUK_HEAP_STRING_WRITE_INT_BE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT_BE)
#define DUK_HTHREAD_STRING_WRITE_INT_BE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT_BE)
#define DUK_HEAP_STRING_WRITE_INT_LE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT_LE)
#define DUK_HTHREAD_STRING_WRITE_INT_LE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT_LE)
#define DUK_HEAP_STRING_WRITE_UINT_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT_BE)
#define DUK_HEAP_STRING_WRITE_UINT_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT_LE)
#define DUK_HEAP_STRING_WRITE_DOUBLE_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_DOUBLE_BE)
#define DUK_HTHREAD_STRING_WRITE_DOUBLE_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_DOUBLE_BE)
#define DUK_HEAP_STRING_WRITE_DOUBLE_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_DOUBLE_LE)
#define DUK_HTHREAD_STRING_WRITE_DOUBLE_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_DOUBLE_LE)
#define DUK_HEAP_STRING_WRITE_FLOAT_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_FLOAT_BE)
#define DUK_HTHREAD_STRING_WRITE_FLOAT_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_FLOAT_BE)
#define DUK_HEAP_STRING_WRITE_FLOAT_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_FLOAT_LE)
#define DUK_HTHREAD_STRING_WRITE_FLOAT_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_FLOAT_LE)
#define DUK_HEAP_STRING_WRITE_INT32_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT32_BE)
#define DUK_HTHREAD_STRING_WRITE_INT32_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT32_BE)
#define DUK_HEAP_STRING_WRITE_INT32_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT32_LE)
#define DUK_HTHREAD_STRING_WRITE_INT32_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT32_LE)
#define DUK_HEAP_STRING_WRITE_UINT32_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT32_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT32_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT32_BE)
#define DUK_HEAP_STRING_WRITE_UINT32_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT32_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT32_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT32_LE)
#define DUK_HEAP_STRING_WRITE_INT16_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT16_BE)
#define DUK_HTHREAD_STRING_WRITE_INT16_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT16_BE)
#define DUK_HEAP_STRING_WRITE_INT16_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT16_LE)
#define DUK_HTHREAD_STRING_WRITE_INT16_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT16_LE)
#define DUK_HEAP_STRING_WRITE_UINT16_BE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT16_BE)
#define DUK_HTHREAD_STRING_WRITE_UINT16_BE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT16_BE)
#define DUK_HEAP_STRING_WRITE_UINT16_LE(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT16_LE)
#define DUK_HTHREAD_STRING_WRITE_UINT16_LE(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT16_LE)
#define DUK_HEAP_STRING_WRITE_INT8(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_INT8)
#define DUK_HTHREAD_STRING_WRITE_INT8(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_INT8)
#define DUK_HEAP_STRING_WRITE_UINT8(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE_UINT8)
#define DUK_HTHREAD_STRING_WRITE_UINT8(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE_UINT8)
#define DUK_HEAP_STRING_READ_INT_BE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT_BE)
#define DUK_HTHREAD_STRING_READ_INT_BE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT_BE)
#define DUK_HEAP_STRING_READ_INT_LE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT_LE)
#define DUK_HTHREAD_STRING_READ_INT_LE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT_LE)
#define DUK_HEAP_STRING_READ_UINT_BE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT_BE)
#define DUK_HTHREAD_STRING_READ_UINT_BE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT_BE)
#define DUK_HEAP_STRING_READ_UINT_LE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT_LE)
#define DUK_HTHREAD_STRING_READ_UINT_LE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT_LE)
#define DUK_HEAP_STRING_READ_DOUBLE_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_DOUBLE_BE)
#define DUK_HTHREAD_STRING_READ_DOUBLE_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_DOUBLE_BE)
#define DUK_HEAP_STRING_READ_DOUBLE_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_DOUBLE_LE)
#define DUK_HTHREAD_STRING_READ_DOUBLE_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_DOUBLE_LE)
#define DUK_HEAP_STRING_READ_FLOAT_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_FLOAT_BE)
#define DUK_HTHREAD_STRING_READ_FLOAT_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_FLOAT_BE)
#define DUK_HEAP_STRING_READ_FLOAT_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_FLOAT_LE)
#define DUK_HTHREAD_STRING_READ_FLOAT_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_FLOAT_LE)
#define DUK_HEAP_STRING_READ_INT32_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT32_BE)
#define DUK_HTHREAD_STRING_READ_INT32_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT32_BE)
#define DUK_HEAP_STRING_READ_INT32_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT32_LE)
#define DUK_HTHREAD_STRING_READ_INT32_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT32_LE)
#define DUK_HEAP_STRING_READ_UINT32_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT32_BE)
#define DUK_HTHREAD_STRING_READ_UINT32_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT32_BE)
#define DUK_HEAP_STRING_READ_UINT32_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT32_LE)
#define DUK_HTHREAD_STRING_READ_UINT32_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT32_LE)
#define DUK_HEAP_STRING_READ_INT16_BE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT16_BE)
#define DUK_HTHREAD_STRING_READ_INT16_BE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT16_BE)
#define DUK_HEAP_STRING_READ_INT16_LE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT16_LE)
#define DUK_HTHREAD_STRING_READ_INT16_LE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT16_LE)
#define DUK_HEAP_STRING_READ_UINT16_BE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT16_BE)
#define DUK_HTHREAD_STRING_READ_UINT16_BE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT16_BE)
#define DUK_HEAP_STRING_READ_UINT16_LE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT16_LE)
#define DUK_HTHREAD_STRING_READ_UINT16_LE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT16_LE)
#define DUK_HEAP_STRING_READ_INT8(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_INT8)
#define DUK_HTHREAD_STRING_READ_INT8(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_INT8)
#define DUK_HEAP_STRING_READ_UINT8(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_READ_UINT8)
#define DUK_HTHREAD_STRING_READ_UINT8(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_READ_UINT8)
#define DUK_HEAP_STRING_COPY(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COPY)
#define DUK_HTHREAD_STRING_COPY(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COPY)
#define DUK_HEAP_STRING_EQUALS(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EQUALS)
#define DUK_HTHREAD_STRING_EQUALS(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EQUALS)
#define DUK_HEAP_STRING_FILL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILL)
#define DUK_HTHREAD_STRING_FILL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILL)
#define DUK_HEAP_STRING_WRITE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITE)
#define DUK_HTHREAD_STRING_WRITE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITE)
#define DUK_HEAP_STRING_COMPARE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMPARE)
#define DUK_HTHREAD_STRING_COMPARE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMPARE)
#define DUK_HEAP_STRING_BYTE_LENGTH(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BYTE_LENGTH)
#define DUK_HTHREAD_STRING_BYTE_LENGTH(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BYTE_LENGTH)
#define DUK_HEAP_STRING_IS_BUFFER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_BUFFER)
#define DUK_HTHREAD_STRING_IS_BUFFER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_BUFFER)
#define DUK_HEAP_STRING_IS_ENCODING(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_ENCODING)
#define DUK_HTHREAD_STRING_IS_ENCODING(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_ENCODING)
#define DUK_HEAP_STRING_EXPORTS(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXPORTS)
#define DUK_HTHREAD_STRING_EXPORTS(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXPORTS)
#define DUK_HEAP_STRING_ID(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ID)
#define DUK_HTHREAD_STRING_ID(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ID)
#define DUK_HEAP_STRING_REQUIRE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REQUIRE)
#define DUK_HTHREAD_STRING_REQUIRE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REQUIRE)
#define DUK_HEAP_STRING___PROTO__(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX___PROTO__)
#define DUK_HTHREAD_STRING___PROTO__(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX___PROTO__)
#define DUK_HEAP_STRING_SET_PROTOTYPE_OF(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_SET_PROTOTYPE_OF(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_PROTOTYPE_OF)
#define DUK_HEAP_STRING_OWN_KEYS(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_OWN_KEYS)
#define DUK_HTHREAD_STRING_OWN_KEYS(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_OWN_KEYS)
#define DUK_HEAP_STRING_ENUMERATE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUMERATE)
#define DUK_HTHREAD_STRING_ENUMERATE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUMERATE)
#define DUK_HEAP_STRING_DELETE_PROPERTY(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DELETE_PROPERTY)
#define DUK_HTHREAD_STRING_DELETE_PROPERTY(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DELETE_PROPERTY)
#define DUK_HEAP_STRING_HAS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HAS)
#define DUK_HTHREAD_STRING_HAS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HAS)
#define DUK_HEAP_STRING_PROXY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROXY)
#define DUK_HTHREAD_STRING_PROXY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROXY)
#define DUK_HEAP_STRING_CALLEE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALLEE)
#define DUK_HTHREAD_STRING_CALLEE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALLEE)
#define DUK_HEAP_STRING_INVALID_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INVALID_DATE)
#define DUK_HTHREAD_STRING_INVALID_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INVALID_DATE)
#define DUK_HEAP_STRING_BRACKETED_ELLIPSIS(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BRACKETED_ELLIPSIS)
#define DUK_HTHREAD_STRING_BRACKETED_ELLIPSIS(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BRACKETED_ELLIPSIS)
#define DUK_HEAP_STRING_NEWLINE_TAB(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEWLINE_TAB)
#define DUK_HTHREAD_STRING_NEWLINE_TAB(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEWLINE_TAB)
#define DUK_HEAP_STRING_SPACE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPACE)
#define DUK_HTHREAD_STRING_SPACE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPACE)
#define DUK_HEAP_STRING_COMMA(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COMMA)
#define DUK_HTHREAD_STRING_COMMA(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COMMA)
#define DUK_HEAP_STRING_MINUS_ZERO(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MINUS_ZERO)
#define DUK_HTHREAD_STRING_MINUS_ZERO(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MINUS_ZERO)
#define DUK_HEAP_STRING_PLUS_ZERO(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PLUS_ZERO)
#define DUK_HTHREAD_STRING_PLUS_ZERO(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PLUS_ZERO)
#define DUK_HEAP_STRING_ZERO(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ZERO)
#define DUK_HTHREAD_STRING_ZERO(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ZERO)
#define DUK_HEAP_STRING_MINUS_INFINITY(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MINUS_INFINITY)
#define DUK_HTHREAD_STRING_MINUS_INFINITY(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MINUS_INFINITY)
#define DUK_HEAP_STRING_PLUS_INFINITY(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PLUS_INFINITY)
#define DUK_HTHREAD_STRING_PLUS_INFINITY(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PLUS_INFINITY)
#define DUK_HEAP_STRING_INFINITY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INFINITY)
#define DUK_HTHREAD_STRING_INFINITY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INFINITY)
#define DUK_HEAP_STRING_LC_OBJECT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_OBJECT)
#define DUK_HTHREAD_STRING_LC_OBJECT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_OBJECT)
#define DUK_HEAP_STRING_LC_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_STRING)
#define DUK_HTHREAD_STRING_LC_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_STRING)
#define DUK_HEAP_STRING_LC_NUMBER(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_NUMBER)
#define DUK_HTHREAD_STRING_LC_NUMBER(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_NUMBER)
#define DUK_HEAP_STRING_LC_BOOLEAN(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_BOOLEAN)
#define DUK_HTHREAD_STRING_LC_BOOLEAN(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_BOOLEAN)
#define DUK_HEAP_STRING_LC_UNDEFINED(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_UNDEFINED)
#define DUK_HTHREAD_STRING_LC_UNDEFINED(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_UNDEFINED)
#define DUK_HEAP_STRING_STRINGIFY(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STRINGIFY)
#define DUK_HTHREAD_STRING_STRINGIFY(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STRINGIFY)
#define DUK_HEAP_STRING_TAN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TAN)
#define DUK_HTHREAD_STRING_TAN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TAN)
#define DUK_HEAP_STRING_SQRT(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT)
#define DUK_HTHREAD_STRING_SQRT(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT)
#define DUK_HEAP_STRING_SIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SIN)
#define DUK_HTHREAD_STRING_SIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SIN)
#define DUK_HEAP_STRING_ROUND(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ROUND)
#define DUK_HTHREAD_STRING_ROUND(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ROUND)
#define DUK_HEAP_STRING_RANDOM(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RANDOM)
#define DUK_HTHREAD_STRING_RANDOM(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RANDOM)
#define DUK_HEAP_STRING_POW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POW)
#define DUK_HTHREAD_STRING_POW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POW)
#define DUK_HEAP_STRING_MIN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MIN)
#define DUK_HTHREAD_STRING_MIN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MIN)
#define DUK_HEAP_STRING_MAX(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAX)
#define DUK_HTHREAD_STRING_MAX(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAX)
#define DUK_HEAP_STRING_LOG(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG)
#define DUK_HTHREAD_STRING_LOG(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG)
#define DUK_HEAP_STRING_FLOOR(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FLOOR)
#define DUK_HTHREAD_STRING_FLOOR(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FLOOR)
#define DUK_HEAP_STRING_EXP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXP)
#define DUK_HTHREAD_STRING_EXP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXP)
#define DUK_HEAP_STRING_COS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_COS)
#define DUK_HTHREAD_STRING_COS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_COS)
#define DUK_HEAP_STRING_CEIL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CEIL)
#define DUK_HTHREAD_STRING_CEIL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CEIL)
#define DUK_HEAP_STRING_ATAN2(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ATAN2)
#define DUK_HTHREAD_STRING_ATAN2(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ATAN2)
#define DUK_HEAP_STRING_ATAN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ATAN)
#define DUK_HTHREAD_STRING_ATAN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ATAN)
#define DUK_HEAP_STRING_ASIN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ASIN)
#define DUK_HTHREAD_STRING_ASIN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ASIN)
#define DUK_HEAP_STRING_ACOS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ACOS)
#define DUK_HTHREAD_STRING_ACOS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ACOS)
#define DUK_HEAP_STRING_ABS(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ABS)
#define DUK_HTHREAD_STRING_ABS(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ABS)
#define DUK_HEAP_STRING_SQRT2(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT2)
#define DUK_HTHREAD_STRING_SQRT2(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT2)
#define DUK_HEAP_STRING_SQRT1_2(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SQRT1_2)
#define DUK_HTHREAD_STRING_SQRT1_2(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SQRT1_2)
#define DUK_HEAP_STRING_PI(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PI)
#define DUK_HTHREAD_STRING_PI(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PI)
#define DUK_HEAP_STRING_LOG10E(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG10E)
#define DUK_HTHREAD_STRING_LOG10E(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG10E)
#define DUK_HEAP_STRING_LOG2E(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOG2E)
#define DUK_HTHREAD_STRING_LOG2E(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOG2E)
#define DUK_HEAP_STRING_LN2(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LN2)
#define DUK_HTHREAD_STRING_LN2(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LN2)
#define DUK_HEAP_STRING_LN10(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LN10)
#define DUK_HTHREAD_STRING_LN10(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LN10)
#define DUK_HEAP_STRING_E(heap)                                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_E)
#define DUK_HTHREAD_STRING_E(thr)                                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_E)
#define DUK_HEAP_STRING_MESSAGE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MESSAGE)
#define DUK_HTHREAD_STRING_MESSAGE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MESSAGE)
#define DUK_HEAP_STRING_NAME(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NAME)
#define DUK_HTHREAD_STRING_NAME(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NAME)
#define DUK_HEAP_STRING_INPUT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INPUT)
#define DUK_HTHREAD_STRING_INPUT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INPUT)
#define DUK_HEAP_STRING_INDEX(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INDEX)
#define DUK_HTHREAD_STRING_INDEX(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INDEX)
#define DUK_HEAP_STRING_ESCAPED_EMPTY_REGEXP(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ESCAPED_EMPTY_REGEXP)
#define DUK_HTHREAD_STRING_ESCAPED_EMPTY_REGEXP(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ESCAPED_EMPTY_REGEXP)
#define DUK_HEAP_STRING_LAST_INDEX(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LAST_INDEX)
#define DUK_HTHREAD_STRING_LAST_INDEX(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LAST_INDEX)
#define DUK_HEAP_STRING_MULTILINE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MULTILINE)
#define DUK_HTHREAD_STRING_MULTILINE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MULTILINE)
#define DUK_HEAP_STRING_IGNORE_CASE(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IGNORE_CASE)
#define DUK_HTHREAD_STRING_IGNORE_CASE(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IGNORE_CASE)
#define DUK_HEAP_STRING_SOURCE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SOURCE)
#define DUK_HTHREAD_STRING_SOURCE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SOURCE)
#define DUK_HEAP_STRING_TEST(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TEST)
#define DUK_HTHREAD_STRING_TEST(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TEST)
#define DUK_HEAP_STRING_EXEC(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXEC)
#define DUK_HTHREAD_STRING_EXEC(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXEC)
#define DUK_HEAP_STRING_TO_GMT_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_GMT_STRING)
#define DUK_HTHREAD_STRING_TO_GMT_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_GMT_STRING)
#define DUK_HEAP_STRING_SET_YEAR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_YEAR)
#define DUK_HTHREAD_STRING_SET_YEAR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_YEAR)
#define DUK_HEAP_STRING_GET_YEAR(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_YEAR)
#define DUK_HTHREAD_STRING_GET_YEAR(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_YEAR)
#define DUK_HEAP_STRING_TO_JSON(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_JSON)
#define DUK_HTHREAD_STRING_TO_JSON(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_JSON)
#define DUK_HEAP_STRING_TO_ISO_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_ISO_STRING)
#define DUK_HTHREAD_STRING_TO_ISO_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_ISO_STRING)
#define DUK_HEAP_STRING_TO_UTC_STRING(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_UTC_STRING)
#define DUK_HTHREAD_STRING_TO_UTC_STRING(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_UTC_STRING)
#define DUK_HEAP_STRING_SET_UTC_FULL_YEAR(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_FULL_YEAR)
#define DUK_HTHREAD_STRING_SET_UTC_FULL_YEAR(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_FULL_YEAR)
#define DUK_HEAP_STRING_SET_FULL_YEAR(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_FULL_YEAR)
#define DUK_HTHREAD_STRING_SET_FULL_YEAR(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_FULL_YEAR)
#define DUK_HEAP_STRING_SET_UTC_MONTH(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MONTH)
#define DUK_HTHREAD_STRING_SET_UTC_MONTH(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MONTH)
#define DUK_HEAP_STRING_SET_MONTH(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MONTH)
#define DUK_HTHREAD_STRING_SET_MONTH(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MONTH)
#define DUK_HEAP_STRING_SET_UTC_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_DATE)
#define DUK_HTHREAD_STRING_SET_UTC_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_DATE)
#define DUK_HEAP_STRING_SET_DATE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_DATE)
#define DUK_HTHREAD_STRING_SET_DATE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_DATE)
#define DUK_HEAP_STRING_SET_UTC_HOURS(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_HOURS)
#define DUK_HTHREAD_STRING_SET_UTC_HOURS(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_HOURS)
#define DUK_HEAP_STRING_SET_HOURS(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_HOURS)
#define DUK_HTHREAD_STRING_SET_HOURS(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_HOURS)
#define DUK_HEAP_STRING_SET_UTC_MINUTES(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MINUTES)
#define DUK_HTHREAD_STRING_SET_UTC_MINUTES(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MINUTES)
#define DUK_HEAP_STRING_SET_MINUTES(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MINUTES)
#define DUK_HTHREAD_STRING_SET_MINUTES(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MINUTES)
#define DUK_HEAP_STRING_SET_UTC_SECONDS(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_SECONDS)
#define DUK_HTHREAD_STRING_SET_UTC_SECONDS(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_SECONDS)
#define DUK_HEAP_STRING_SET_SECONDS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_SECONDS)
#define DUK_HTHREAD_STRING_SET_SECONDS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_SECONDS)
#define DUK_HEAP_STRING_SET_UTC_MILLISECONDS(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_UTC_MILLISECONDS)
#define DUK_HTHREAD_STRING_SET_UTC_MILLISECONDS(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_UTC_MILLISECONDS)
#define DUK_HEAP_STRING_SET_MILLISECONDS(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_MILLISECONDS)
#define DUK_HTHREAD_STRING_SET_MILLISECONDS(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_MILLISECONDS)
#define DUK_HEAP_STRING_SET_TIME(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET_TIME)
#define DUK_HTHREAD_STRING_SET_TIME(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET_TIME)
#define DUK_HEAP_STRING_GET_TIMEZONE_OFFSET(heap)                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_TIMEZONE_OFFSET)
#define DUK_HTHREAD_STRING_GET_TIMEZONE_OFFSET(thr)                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_TIMEZONE_OFFSET)
#define DUK_HEAP_STRING_GET_UTC_MILLISECONDS(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MILLISECONDS)
#define DUK_HTHREAD_STRING_GET_UTC_MILLISECONDS(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MILLISECONDS)
#define DUK_HEAP_STRING_GET_MILLISECONDS(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MILLISECONDS)
#define DUK_HTHREAD_STRING_GET_MILLISECONDS(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MILLISECONDS)
#define DUK_HEAP_STRING_GET_UTC_SECONDS(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_SECONDS)
#define DUK_HTHREAD_STRING_GET_UTC_SECONDS(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_SECONDS)
#define DUK_HEAP_STRING_GET_SECONDS(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_SECONDS)
#define DUK_HTHREAD_STRING_GET_SECONDS(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_SECONDS)
#define DUK_HEAP_STRING_GET_UTC_MINUTES(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MINUTES)
#define DUK_HTHREAD_STRING_GET_UTC_MINUTES(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MINUTES)
#define DUK_HEAP_STRING_GET_MINUTES(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MINUTES)
#define DUK_HTHREAD_STRING_GET_MINUTES(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MINUTES)
#define DUK_HEAP_STRING_GET_UTC_HOURS(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_HOURS)
#define DUK_HTHREAD_STRING_GET_UTC_HOURS(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_HOURS)
#define DUK_HEAP_STRING_GET_HOURS(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_HOURS)
#define DUK_HTHREAD_STRING_GET_HOURS(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_HOURS)
#define DUK_HEAP_STRING_GET_UTC_DAY(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_DAY)
#define DUK_HTHREAD_STRING_GET_UTC_DAY(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_DAY)
#define DUK_HEAP_STRING_GET_DAY(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_DAY)
#define DUK_HTHREAD_STRING_GET_DAY(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_DAY)
#define DUK_HEAP_STRING_GET_UTC_DATE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_DATE)
#define DUK_HTHREAD_STRING_GET_UTC_DATE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_DATE)
#define DUK_HEAP_STRING_GET_DATE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_DATE)
#define DUK_HTHREAD_STRING_GET_DATE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_DATE)
#define DUK_HEAP_STRING_GET_UTC_MONTH(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_MONTH)
#define DUK_HTHREAD_STRING_GET_UTC_MONTH(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_MONTH)
#define DUK_HEAP_STRING_GET_MONTH(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_MONTH)
#define DUK_HTHREAD_STRING_GET_MONTH(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_MONTH)
#define DUK_HEAP_STRING_GET_UTC_FULL_YEAR(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_UTC_FULL_YEAR)
#define DUK_HTHREAD_STRING_GET_UTC_FULL_YEAR(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_UTC_FULL_YEAR)
#define DUK_HEAP_STRING_GET_FULL_YEAR(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_FULL_YEAR)
#define DUK_HTHREAD_STRING_GET_FULL_YEAR(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_FULL_YEAR)
#define DUK_HEAP_STRING_GET_TIME(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_TIME)
#define DUK_HTHREAD_STRING_GET_TIME(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_TIME)
#define DUK_HEAP_STRING_TO_LOCALE_TIME_STRING(heap)                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_TIME_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_TIME_STRING(thr)                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_TIME_STRING)
#define DUK_HEAP_STRING_TO_LOCALE_DATE_STRING(heap)                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_DATE_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_DATE_STRING(thr)                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_DATE_STRING)
#define DUK_HEAP_STRING_TO_TIME_STRING(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_TIME_STRING)
#define DUK_HTHREAD_STRING_TO_TIME_STRING(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_TIME_STRING)
#define DUK_HEAP_STRING_TO_DATE_STRING(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_DATE_STRING)
#define DUK_HTHREAD_STRING_TO_DATE_STRING(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_DATE_STRING)
#define DUK_HEAP_STRING_NOW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NOW)
#define DUK_HTHREAD_STRING_NOW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NOW)
#define DUK_HEAP_STRING_UTC(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UTC)
#define DUK_HTHREAD_STRING_UTC(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UTC)
#define DUK_HEAP_STRING_PARSE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE)
#define DUK_HTHREAD_STRING_PARSE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE)
#define DUK_HEAP_STRING_TO_PRECISION(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_PRECISION)
#define DUK_HTHREAD_STRING_TO_PRECISION(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_PRECISION)
#define DUK_HEAP_STRING_TO_EXPONENTIAL(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_EXPONENTIAL)
#define DUK_HTHREAD_STRING_TO_EXPONENTIAL(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_EXPONENTIAL)
#define DUK_HEAP_STRING_TO_FIXED(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_FIXED)
#define DUK_HTHREAD_STRING_TO_FIXED(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_FIXED)
#define DUK_HEAP_STRING_POSITIVE_INFINITY(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POSITIVE_INFINITY)
#define DUK_HTHREAD_STRING_POSITIVE_INFINITY(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POSITIVE_INFINITY)
#define DUK_HEAP_STRING_NEGATIVE_INFINITY(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEGATIVE_INFINITY)
#define DUK_HTHREAD_STRING_NEGATIVE_INFINITY(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEGATIVE_INFINITY)
#define DUK_HEAP_STRING_NAN(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NAN)
#define DUK_HTHREAD_STRING_NAN(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NAN)
#define DUK_HEAP_STRING_MIN_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MIN_VALUE)
#define DUK_HTHREAD_STRING_MIN_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MIN_VALUE)
#define DUK_HEAP_STRING_MAX_VALUE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAX_VALUE)
#define DUK_HTHREAD_STRING_MAX_VALUE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAX_VALUE)
#define DUK_HEAP_STRING_SUBSTR(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBSTR)
#define DUK_HTHREAD_STRING_SUBSTR(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBSTR)
#define DUK_HEAP_STRING_TRIM(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRIM)
#define DUK_HTHREAD_STRING_TRIM(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRIM)
#define DUK_HEAP_STRING_TO_LOCALE_UPPER_CASE(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_UPPER_CASE)
#define DUK_HTHREAD_STRING_TO_LOCALE_UPPER_CASE(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_UPPER_CASE)
#define DUK_HEAP_STRING_TO_UPPER_CASE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_UPPER_CASE)
#define DUK_HTHREAD_STRING_TO_UPPER_CASE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_UPPER_CASE)
#define DUK_HEAP_STRING_TO_LOCALE_LOWER_CASE(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_LOWER_CASE)
#define DUK_HTHREAD_STRING_TO_LOCALE_LOWER_CASE(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_LOWER_CASE)
#define DUK_HEAP_STRING_TO_LOWER_CASE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOWER_CASE)
#define DUK_HTHREAD_STRING_TO_LOWER_CASE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOWER_CASE)
#define DUK_HEAP_STRING_SUBSTRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUBSTRING)
#define DUK_HTHREAD_STRING_SUBSTRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUBSTRING)
#define DUK_HEAP_STRING_SPLIT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPLIT)
#define DUK_HTHREAD_STRING_SPLIT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPLIT)
#define DUK_HEAP_STRING_SEARCH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SEARCH)
#define DUK_HTHREAD_STRING_SEARCH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SEARCH)
#define DUK_HEAP_STRING_REPLACE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REPLACE)
#define DUK_HTHREAD_STRING_REPLACE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REPLACE)
#define DUK_HEAP_STRING_MATCH(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MATCH)
#define DUK_HTHREAD_STRING_MATCH(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MATCH)
#define DUK_HEAP_STRING_LOCALE_COMPARE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LOCALE_COMPARE)
#define DUK_HTHREAD_STRING_LOCALE_COMPARE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LOCALE_COMPARE)
#define DUK_HEAP_STRING_CHAR_CODE_AT(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CHAR_CODE_AT)
#define DUK_HTHREAD_STRING_CHAR_CODE_AT(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CHAR_CODE_AT)
#define DUK_HEAP_STRING_CHAR_AT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CHAR_AT)
#define DUK_HTHREAD_STRING_CHAR_AT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CHAR_AT)
#define DUK_HEAP_STRING_FROM_CHAR_CODE(heap)                          DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FROM_CHAR_CODE)
#define DUK_HTHREAD_STRING_FROM_CHAR_CODE(thr)                        DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FROM_CHAR_CODE)
#define DUK_HEAP_STRING_REDUCE_RIGHT(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REDUCE_RIGHT)
#define DUK_HTHREAD_STRING_REDUCE_RIGHT(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REDUCE_RIGHT)
#define DUK_HEAP_STRING_REDUCE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REDUCE)
#define DUK_HTHREAD_STRING_REDUCE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REDUCE)
#define DUK_HEAP_STRING_FILTER(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FILTER)
#define DUK_HTHREAD_STRING_FILTER(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FILTER)
#define DUK_HEAP_STRING_MAP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_MAP)
#define DUK_HTHREAD_STRING_MAP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_MAP)
#define DUK_HEAP_STRING_FOR_EACH(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FOR_EACH)
#define DUK_HTHREAD_STRING_FOR_EACH(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FOR_EACH)
#define DUK_HEAP_STRING_SOME(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SOME)
#define DUK_HTHREAD_STRING_SOME(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SOME)
#define DUK_HEAP_STRING_EVERY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVERY)
#define DUK_HTHREAD_STRING_EVERY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVERY)
#define DUK_HEAP_STRING_LAST_INDEX_OF(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LAST_INDEX_OF)
#define DUK_HTHREAD_STRING_LAST_INDEX_OF(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LAST_INDEX_OF)
#define DUK_HEAP_STRING_INDEX_OF(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INDEX_OF)
#define DUK_HTHREAD_STRING_INDEX_OF(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INDEX_OF)
#define DUK_HEAP_STRING_UNSHIFT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UNSHIFT)
#define DUK_HTHREAD_STRING_UNSHIFT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UNSHIFT)
#define DUK_HEAP_STRING_SPLICE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SPLICE)
#define DUK_HTHREAD_STRING_SPLICE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SPLICE)
#define DUK_HEAP_STRING_SORT(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SORT)
#define DUK_HTHREAD_STRING_SORT(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SORT)
#define DUK_HEAP_STRING_SLICE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SLICE)
#define DUK_HTHREAD_STRING_SLICE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SLICE)
#define DUK_HEAP_STRING_SHIFT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SHIFT)
#define DUK_HTHREAD_STRING_SHIFT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SHIFT)
#define DUK_HEAP_STRING_REVERSE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REVERSE)
#define DUK_HTHREAD_STRING_REVERSE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REVERSE)
#define DUK_HEAP_STRING_PUSH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PUSH)
#define DUK_HTHREAD_STRING_PUSH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PUSH)
#define DUK_HEAP_STRING_POP(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_POP)
#define DUK_HTHREAD_STRING_POP(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_POP)
#define DUK_HEAP_STRING_JOIN(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_JOIN)
#define DUK_HTHREAD_STRING_JOIN(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_JOIN)
#define DUK_HEAP_STRING_CONCAT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONCAT)
#define DUK_HTHREAD_STRING_CONCAT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONCAT)
#define DUK_HEAP_STRING_IS_ARRAY(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_ARRAY)
#define DUK_HTHREAD_STRING_IS_ARRAY(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_ARRAY)
#define DUK_HEAP_STRING_LC_ARGUMENTS(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_ARGUMENTS)
#define DUK_HTHREAD_STRING_LC_ARGUMENTS(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_ARGUMENTS)
#define DUK_HEAP_STRING_CALLER(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALLER)
#define DUK_HTHREAD_STRING_CALLER(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALLER)
#define DUK_HEAP_STRING_BIND(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BIND)
#define DUK_HTHREAD_STRING_BIND(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BIND)
#define DUK_HEAP_STRING_CALL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CALL)
#define DUK_HTHREAD_STRING_CALL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CALL)
#define DUK_HEAP_STRING_APPLY(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_APPLY)
#define DUK_HTHREAD_STRING_APPLY(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_APPLY)
#define DUK_HEAP_STRING_PROPERTY_IS_ENUMERABLE(heap)                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROPERTY_IS_ENUMERABLE)
#define DUK_HTHREAD_STRING_PROPERTY_IS_ENUMERABLE(thr)                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROPERTY_IS_ENUMERABLE)
#define DUK_HEAP_STRING_IS_PROTOTYPE_OF(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_IS_PROTOTYPE_OF(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_PROTOTYPE_OF)
#define DUK_HEAP_STRING_HAS_OWN_PROPERTY(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_HAS_OWN_PROPERTY)
#define DUK_HTHREAD_STRING_HAS_OWN_PROPERTY(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_HAS_OWN_PROPERTY)
#define DUK_HEAP_STRING_VALUE_OF(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VALUE_OF)
#define DUK_HTHREAD_STRING_VALUE_OF(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VALUE_OF)
#define DUK_HEAP_STRING_TO_LOCALE_STRING(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_LOCALE_STRING)
#define DUK_HTHREAD_STRING_TO_LOCALE_STRING(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_LOCALE_STRING)
#define DUK_HEAP_STRING_TO_STRING(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TO_STRING)
#define DUK_HTHREAD_STRING_TO_STRING(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TO_STRING)
#define DUK_HEAP_STRING_CONSTRUCTOR(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONSTRUCTOR)
#define DUK_HTHREAD_STRING_CONSTRUCTOR(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONSTRUCTOR)
#define DUK_HEAP_STRING_SET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SET)
#define DUK_HTHREAD_STRING_SET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SET)
#define DUK_HEAP_STRING_GET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET)
#define DUK_HTHREAD_STRING_GET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET)
#define DUK_HEAP_STRING_ENUMERABLE(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUMERABLE)
#define DUK_HTHREAD_STRING_ENUMERABLE(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUMERABLE)
#define DUK_HEAP_STRING_CONFIGURABLE(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONFIGURABLE)
#define DUK_HTHREAD_STRING_CONFIGURABLE(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONFIGURABLE)
#define DUK_HEAP_STRING_WRITABLE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WRITABLE)
#define DUK_HTHREAD_STRING_WRITABLE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WRITABLE)
#define DUK_HEAP_STRING_VALUE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VALUE)
#define DUK_HTHREAD_STRING_VALUE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VALUE)
#define DUK_HEAP_STRING_KEYS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_KEYS)
#define DUK_HTHREAD_STRING_KEYS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_KEYS)
#define DUK_HEAP_STRING_IS_EXTENSIBLE(heap)                           DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_EXTENSIBLE)
#define DUK_HTHREAD_STRING_IS_EXTENSIBLE(thr)                         DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_EXTENSIBLE)
#define DUK_HEAP_STRING_IS_FROZEN(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_FROZEN)
#define DUK_HTHREAD_STRING_IS_FROZEN(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_FROZEN)
#define DUK_HEAP_STRING_IS_SEALED(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_SEALED)
#define DUK_HTHREAD_STRING_IS_SEALED(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_SEALED)
#define DUK_HEAP_STRING_PREVENT_EXTENSIONS(heap)                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PREVENT_EXTENSIONS)
#define DUK_HTHREAD_STRING_PREVENT_EXTENSIONS(thr)                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PREVENT_EXTENSIONS)
#define DUK_HEAP_STRING_FREEZE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FREEZE)
#define DUK_HTHREAD_STRING_FREEZE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FREEZE)
#define DUK_HEAP_STRING_SEAL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SEAL)
#define DUK_HTHREAD_STRING_SEAL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SEAL)
#define DUK_HEAP_STRING_DEFINE_PROPERTIES(heap)                       DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFINE_PROPERTIES)
#define DUK_HTHREAD_STRING_DEFINE_PROPERTIES(thr)                     DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFINE_PROPERTIES)
#define DUK_HEAP_STRING_DEFINE_PROPERTY(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFINE_PROPERTY)
#define DUK_HTHREAD_STRING_DEFINE_PROPERTY(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFINE_PROPERTY)
#define DUK_HEAP_STRING_CREATE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CREATE)
#define DUK_HTHREAD_STRING_CREATE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CREATE)
#define DUK_HEAP_STRING_GET_OWN_PROPERTY_NAMES(heap)                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_OWN_PROPERTY_NAMES)
#define DUK_HTHREAD_STRING_GET_OWN_PROPERTY_NAMES(thr)                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_OWN_PROPERTY_NAMES)
#define DUK_HEAP_STRING_GET_OWN_PROPERTY_DESCRIPTOR(heap)             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR)
#define DUK_HTHREAD_STRING_GET_OWN_PROPERTY_DESCRIPTOR(thr)           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_OWN_PROPERTY_DESCRIPTOR)
#define DUK_HEAP_STRING_GET_PROTOTYPE_OF(heap)                        DUK_HEAP_GET_STRING((heap),DUK_STRIDX_GET_PROTOTYPE_OF)
#define DUK_HTHREAD_STRING_GET_PROTOTYPE_OF(thr)                      DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_GET_PROTOTYPE_OF)
#define DUK_HEAP_STRING_PROTOTYPE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROTOTYPE)
#define DUK_HTHREAD_STRING_PROTOTYPE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROTOTYPE)
#define DUK_HEAP_STRING_LENGTH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LENGTH)
#define DUK_HTHREAD_STRING_LENGTH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LENGTH)
#define DUK_HEAP_STRING_ALERT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ALERT)
#define DUK_HTHREAD_STRING_ALERT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ALERT)
#define DUK_HEAP_STRING_PRINT(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PRINT)
#define DUK_HTHREAD_STRING_PRINT(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PRINT)
#define DUK_HEAP_STRING_UNESCAPE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_UNESCAPE)
#define DUK_HTHREAD_STRING_UNESCAPE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_UNESCAPE)
#define DUK_HEAP_STRING_ESCAPE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ESCAPE)
#define DUK_HTHREAD_STRING_ESCAPE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ESCAPE)
#define DUK_HEAP_STRING_ENCODE_URI_COMPONENT(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENCODE_URI_COMPONENT)
#define DUK_HTHREAD_STRING_ENCODE_URI_COMPONENT(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENCODE_URI_COMPONENT)
#define DUK_HEAP_STRING_ENCODE_URI(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENCODE_URI)
#define DUK_HTHREAD_STRING_ENCODE_URI(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENCODE_URI)
#define DUK_HEAP_STRING_DECODE_URI_COMPONENT(heap)                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DECODE_URI_COMPONENT)
#define DUK_HTHREAD_STRING_DECODE_URI_COMPONENT(thr)                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DECODE_URI_COMPONENT)
#define DUK_HEAP_STRING_DECODE_URI(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DECODE_URI)
#define DUK_HTHREAD_STRING_DECODE_URI(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DECODE_URI)
#define DUK_HEAP_STRING_IS_FINITE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_FINITE)
#define DUK_HTHREAD_STRING_IS_FINITE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_FINITE)
#define DUK_HEAP_STRING_IS_NAN(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IS_NAN)
#define DUK_HTHREAD_STRING_IS_NAN(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IS_NAN)
#define DUK_HEAP_STRING_PARSE_FLOAT(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE_FLOAT)
#define DUK_HTHREAD_STRING_PARSE_FLOAT(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE_FLOAT)
#define DUK_HEAP_STRING_PARSE_INT(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PARSE_INT)
#define DUK_HTHREAD_STRING_PARSE_INT(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PARSE_INT)
#define DUK_HEAP_STRING_EVAL(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVAL)
#define DUK_HTHREAD_STRING_EVAL(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVAL)
#define DUK_HEAP_STRING_URI_ERROR(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_URI_ERROR)
#define DUK_HTHREAD_STRING_URI_ERROR(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_URI_ERROR)
#define DUK_HEAP_STRING_TYPE_ERROR(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPE_ERROR)
#define DUK_HTHREAD_STRING_TYPE_ERROR(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPE_ERROR)
#define DUK_HEAP_STRING_SYNTAX_ERROR(heap)                            DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SYNTAX_ERROR)
#define DUK_HTHREAD_STRING_SYNTAX_ERROR(thr)                          DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SYNTAX_ERROR)
#define DUK_HEAP_STRING_REFERENCE_ERROR(heap)                         DUK_HEAP_GET_STRING((heap),DUK_STRIDX_REFERENCE_ERROR)
#define DUK_HTHREAD_STRING_REFERENCE_ERROR(thr)                       DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_REFERENCE_ERROR)
#define DUK_HEAP_STRING_RANGE_ERROR(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RANGE_ERROR)
#define DUK_HTHREAD_STRING_RANGE_ERROR(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RANGE_ERROR)
#define DUK_HEAP_STRING_EVAL_ERROR(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EVAL_ERROR)
#define DUK_HTHREAD_STRING_EVAL_ERROR(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EVAL_ERROR)
#define DUK_HEAP_STRING_BREAK(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_BREAK)
#define DUK_HTHREAD_STRING_BREAK(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_BREAK)
#define DUK_HEAP_STRING_CASE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CASE)
#define DUK_HTHREAD_STRING_CASE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CASE)
#define DUK_HEAP_STRING_CATCH(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CATCH)
#define DUK_HTHREAD_STRING_CATCH(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CATCH)
#define DUK_HEAP_STRING_CONTINUE(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONTINUE)
#define DUK_HTHREAD_STRING_CONTINUE(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONTINUE)
#define DUK_HEAP_STRING_DEBUGGER(heap)                                DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEBUGGER)
#define DUK_HTHREAD_STRING_DEBUGGER(thr)                              DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEBUGGER)
#define DUK_HEAP_STRING_DEFAULT(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DEFAULT)
#define DUK_HTHREAD_STRING_DEFAULT(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DEFAULT)
#define DUK_HEAP_STRING_DELETE(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DELETE)
#define DUK_HTHREAD_STRING_DELETE(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DELETE)
#define DUK_HEAP_STRING_DO(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_DO)
#define DUK_HTHREAD_STRING_DO(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_DO)
#define DUK_HEAP_STRING_ELSE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ELSE)
#define DUK_HTHREAD_STRING_ELSE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ELSE)
#define DUK_HEAP_STRING_FINALLY(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FINALLY)
#define DUK_HTHREAD_STRING_FINALLY(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FINALLY)
#define DUK_HEAP_STRING_FOR(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FOR)
#define DUK_HTHREAD_STRING_FOR(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FOR)
#define DUK_HEAP_STRING_LC_FUNCTION(heap)                             DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_FUNCTION)
#define DUK_HTHREAD_STRING_LC_FUNCTION(thr)                           DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_FUNCTION)
#define DUK_HEAP_STRING_IF(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IF)
#define DUK_HTHREAD_STRING_IF(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IF)
#define DUK_HEAP_STRING_IN(heap)                                      DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IN)
#define DUK_HTHREAD_STRING_IN(thr)                                    DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IN)
#define DUK_HEAP_STRING_INSTANCEOF(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INSTANCEOF)
#define DUK_HTHREAD_STRING_INSTANCEOF(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INSTANCEOF)
#define DUK_HEAP_STRING_NEW(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_NEW)
#define DUK_HTHREAD_STRING_NEW(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_NEW)
#define DUK_HEAP_STRING_RETURN(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_RETURN)
#define DUK_HTHREAD_STRING_RETURN(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_RETURN)
#define DUK_HEAP_STRING_SWITCH(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SWITCH)
#define DUK_HTHREAD_STRING_SWITCH(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SWITCH)
#define DUK_HEAP_STRING_THIS(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THIS)
#define DUK_HTHREAD_STRING_THIS(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THIS)
#define DUK_HEAP_STRING_THROW(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_THROW)
#define DUK_HTHREAD_STRING_THROW(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_THROW)
#define DUK_HEAP_STRING_TRY(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRY)
#define DUK_HTHREAD_STRING_TRY(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRY)
#define DUK_HEAP_STRING_TYPEOF(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TYPEOF)
#define DUK_HTHREAD_STRING_TYPEOF(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TYPEOF)
#define DUK_HEAP_STRING_VAR(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VAR)
#define DUK_HTHREAD_STRING_VAR(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VAR)
#define DUK_HEAP_STRING_CONST(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CONST)
#define DUK_HTHREAD_STRING_CONST(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CONST)
#define DUK_HEAP_STRING_VOID(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_VOID)
#define DUK_HTHREAD_STRING_VOID(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_VOID)
#define DUK_HEAP_STRING_WHILE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WHILE)
#define DUK_HTHREAD_STRING_WHILE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WHILE)
#define DUK_HEAP_STRING_WITH(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_WITH)
#define DUK_HTHREAD_STRING_WITH(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_WITH)
#define DUK_HEAP_STRING_CLASS(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_CLASS)
#define DUK_HTHREAD_STRING_CLASS(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_CLASS)
#define DUK_HEAP_STRING_ENUM(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_ENUM)
#define DUK_HTHREAD_STRING_ENUM(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_ENUM)
#define DUK_HEAP_STRING_EXPORT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXPORT)
#define DUK_HTHREAD_STRING_EXPORT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXPORT)
#define DUK_HEAP_STRING_EXTENDS(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_EXTENDS)
#define DUK_HTHREAD_STRING_EXTENDS(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_EXTENDS)
#define DUK_HEAP_STRING_IMPORT(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IMPORT)
#define DUK_HTHREAD_STRING_IMPORT(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IMPORT)
#define DUK_HEAP_STRING_SUPER(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_SUPER)
#define DUK_HTHREAD_STRING_SUPER(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_SUPER)
#define DUK_HEAP_STRING_LC_NULL(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LC_NULL)
#define DUK_HTHREAD_STRING_LC_NULL(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LC_NULL)
#define DUK_HEAP_STRING_TRUE(heap)                                    DUK_HEAP_GET_STRING((heap),DUK_STRIDX_TRUE)
#define DUK_HTHREAD_STRING_TRUE(thr)                                  DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_TRUE)
#define DUK_HEAP_STRING_FALSE(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_FALSE)
#define DUK_HTHREAD_STRING_FALSE(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_FALSE)
#define DUK_HEAP_STRING_IMPLEMENTS(heap)                              DUK_HEAP_GET_STRING((heap),DUK_STRIDX_IMPLEMENTS)
#define DUK_HTHREAD_STRING_IMPLEMENTS(thr)                            DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_IMPLEMENTS)
#define DUK_HEAP_STRING_INTERFACE(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_INTERFACE)
#define DUK_HTHREAD_STRING_INTERFACE(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_INTERFACE)
#define DUK_HEAP_STRING_LET(heap)                                     DUK_HEAP_GET_STRING((heap),DUK_STRIDX_LET)
#define DUK_HTHREAD_STRING_LET(thr)                                   DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_LET)
#define DUK_HEAP_STRING_PACKAGE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PACKAGE)
#define DUK_HTHREAD_STRING_PACKAGE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PACKAGE)
#define DUK_HEAP_STRING_PRIVATE(heap)                                 DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PRIVATE)
#define DUK_HTHREAD_STRING_PRIVATE(thr)                               DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PRIVATE)
#define DUK_HEAP_STRING_PROTECTED(heap)                               DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PROTECTED)
#define DUK_HTHREAD_STRING_PROTECTED(thr)                             DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PROTECTED)
#define DUK_HEAP_STRING_PUBLIC(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_PUBLIC)
#define DUK_HTHREAD_STRING_PUBLIC(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_PUBLIC)
#define DUK_HEAP_STRING_STATIC(heap)                                  DUK_HEAP_GET_STRING((heap),DUK_STRIDX_STATIC)
#define DUK_HTHREAD_STRING_STATIC(thr)                                DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_STATIC)
#define DUK_HEAP_STRING_YIELD(heap)                                   DUK_HEAP_GET_STRING((heap),DUK_STRIDX_YIELD)
#define DUK_HTHREAD_STRING_YIELD(thr)                                 DUK_HTHREAD_GET_STRING((thr),DUK_STRIDX_YIELD)

#define DUK_HEAP_NUM_STRINGS                                          414

#define DUK_STRIDX_START_RESERVED                                     369
#define DUK_STRIDX_START_STRICT_RESERVED                              405
#define DUK_STRIDX_END_RESERVED                                       414                            /* exclusive endpoint */

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const duk_c_function duk_bi_native_functions[149];
DUK_INTERNAL_DECL const duk_uint8_t duk_builtins_data[1955];
#ifdef DUK_USE_BUILTIN_INITJS
DUK_INTERNAL_DECL const duk_uint8_t duk_initjs_data[187];
#endif  /* DUK_USE_BUILTIN_INITJS */
#endif  /* !DUK_SINGLE_FILE */

#define DUK_BUILTINS_DATA_LENGTH                                      1955
#ifdef DUK_USE_BUILTIN_INITJS
#define DUK_BUILTIN_INITJS_DATA_LENGTH                                187
#endif  /* DUK_USE_BUILTIN_INITJS */

#define DUK_BIDX_GLOBAL                                               0
#define DUK_BIDX_GLOBAL_ENV                                           1
#define DUK_BIDX_OBJECT_CONSTRUCTOR                                   2
#define DUK_BIDX_OBJECT_PROTOTYPE                                     3
#define DUK_BIDX_FUNCTION_CONSTRUCTOR                                 4
#define DUK_BIDX_FUNCTION_PROTOTYPE                                   5
#define DUK_BIDX_ARRAY_CONSTRUCTOR                                    6
#define DUK_BIDX_ARRAY_PROTOTYPE                                      7
#define DUK_BIDX_STRING_CONSTRUCTOR                                   8
#define DUK_BIDX_STRING_PROTOTYPE                                     9
#define DUK_BIDX_BOOLEAN_CONSTRUCTOR                                  10
#define DUK_BIDX_BOOLEAN_PROTOTYPE                                    11
#define DUK_BIDX_NUMBER_CONSTRUCTOR                                   12
#define DUK_BIDX_NUMBER_PROTOTYPE                                     13
#define DUK_BIDX_DATE_CONSTRUCTOR                                     14
#define DUK_BIDX_DATE_PROTOTYPE                                       15
#define DUK_BIDX_REGEXP_CONSTRUCTOR                                   16
#define DUK_BIDX_REGEXP_PROTOTYPE                                     17
#define DUK_BIDX_ERROR_CONSTRUCTOR                                    18
#define DUK_BIDX_ERROR_PROTOTYPE                                      19
#define DUK_BIDX_EVAL_ERROR_CONSTRUCTOR                               20
#define DUK_BIDX_EVAL_ERROR_PROTOTYPE                                 21
#define DUK_BIDX_RANGE_ERROR_CONSTRUCTOR                              22
#define DUK_BIDX_RANGE_ERROR_PROTOTYPE                                23
#define DUK_BIDX_REFERENCE_ERROR_CONSTRUCTOR                          24
#define DUK_BIDX_REFERENCE_ERROR_PROTOTYPE                            25
#define DUK_BIDX_SYNTAX_ERROR_CONSTRUCTOR                             26
#define DUK_BIDX_SYNTAX_ERROR_PROTOTYPE                               27
#define DUK_BIDX_TYPE_ERROR_CONSTRUCTOR                               28
#define DUK_BIDX_TYPE_ERROR_PROTOTYPE                                 29
#define DUK_BIDX_URI_ERROR_CONSTRUCTOR                                30
#define DUK_BIDX_URI_ERROR_PROTOTYPE                                  31
#define DUK_BIDX_MATH                                                 32
#define DUK_BIDX_JSON                                                 33
#define DUK_BIDX_TYPE_ERROR_THROWER                                   34
#define DUK_BIDX_PROXY_CONSTRUCTOR                                    35
#define DUK_BIDX_DUKTAPE                                              36
#define DUK_BIDX_THREAD_CONSTRUCTOR                                   37
#define DUK_BIDX_THREAD_PROTOTYPE                                     38
#define DUK_BIDX_BUFFER_CONSTRUCTOR                                   39
#define DUK_BIDX_BUFFER_PROTOTYPE                                     40
#define DUK_BIDX_POINTER_CONSTRUCTOR                                  41
#define DUK_BIDX_POINTER_PROTOTYPE                                    42
#define DUK_BIDX_LOGGER_CONSTRUCTOR                                   43
#define DUK_BIDX_LOGGER_PROTOTYPE                                     44
#define DUK_BIDX_DOUBLE_ERROR                                         45
#define DUK_BIDX_ARRAYBUFFER_CONSTRUCTOR                              46
#define DUK_BIDX_ARRAYBUFFER_PROTOTYPE                                47
#define DUK_BIDX_DATAVIEW_CONSTRUCTOR                                 48
#define DUK_BIDX_DATAVIEW_PROTOTYPE                                   49
#define DUK_BIDX_TYPEDARRAY_PROTOTYPE                                 50
#define DUK_BIDX_INT8ARRAY_CONSTRUCTOR                                51
#define DUK_BIDX_INT8ARRAY_PROTOTYPE                                  52
#define DUK_BIDX_UINT8ARRAY_CONSTRUCTOR                               53
#define DUK_BIDX_UINT8ARRAY_PROTOTYPE                                 54
#define DUK_BIDX_UINT8CLAMPEDARRAY_CONSTRUCTOR                        55
#define DUK_BIDX_UINT8CLAMPEDARRAY_PROTOTYPE                          56
#define DUK_BIDX_INT16ARRAY_CONSTRUCTOR                               57
#define DUK_BIDX_INT16ARRAY_PROTOTYPE                                 58
#define DUK_BIDX_UINT16ARRAY_CONSTRUCTOR                              59
#define DUK_BIDX_UINT16ARRAY_PROTOTYPE                                60
#define DUK_BIDX_INT32ARRAY_CONSTRUCTOR                               61
#define DUK_BIDX_INT32ARRAY_PROTOTYPE                                 62
#define DUK_BIDX_UINT32ARRAY_CONSTRUCTOR                              63
#define DUK_BIDX_UINT32ARRAY_PROTOTYPE                                64
#define DUK_BIDX_FLOAT32ARRAY_CONSTRUCTOR                             65
#define DUK_BIDX_FLOAT32ARRAY_PROTOTYPE                               66
#define DUK_BIDX_FLOAT64ARRAY_CONSTRUCTOR                             67
#define DUK_BIDX_FLOAT64ARRAY_PROTOTYPE                               68
#define DUK_BIDX_NODEJS_BUFFER_CONSTRUCTOR                            69
#define DUK_BIDX_NODEJS_BUFFER_PROTOTYPE                              70

#define DUK_NUM_BUILTINS                                              71

#else
#error invalid endianness defines
#endif
#endif  /* DUK_BUILTINS_H_INCLUDED */
#line 51 "duk_internal.h"

#line 1 "duk_util.h"
/*
 *  Utilities
 */

#ifndef DUK_UTIL_H_INCLUDED
#define DUK_UTIL_H_INCLUDED

#define DUK_UTIL_MIN_HASH_PRIME  17  /* must match genhashsizes.py */

#define DUK_UTIL_GET_HASH_PROBE_STEP(hash)  (duk_util_probe_steps[(hash) & 0x1f])

/*
 *  Endian conversion
 */

#if defined(DUK_USE_INTEGER_LE)
#define DUK_HTON32(x) DUK_BSWAP32((x))
#define DUK_NTOH32(x) DUK_BSWAP32((x))
#define DUK_HTON16(x) DUK_BSWAP16((x))
#define DUK_NTOH16(x) DUK_BSWAP16((x))
#elif defined(DUK_USE_INTEGER_BE)
#define DUK_HTON32(x) (x)
#define DUK_NTOH32(x) (x)
#define DUK_HTON16(x) (x)
#define DUK_NTOH16(x) (x)
#else
#error internal error, endianness defines broken
#endif

/*
 *  Bitstream decoder
 */

struct duk_bitdecoder_ctx {
	const duk_uint8_t *data;
	duk_size_t offset;
	duk_size_t length;
	duk_uint32_t currval;
	duk_small_int_t currbits;
};

/*
 *  Bitstream encoder
 */

struct duk_bitencoder_ctx {
	duk_uint8_t *data;
	duk_size_t offset;
	duk_size_t length;
	duk_uint32_t currval;
	duk_small_int_t currbits;
	duk_small_int_t truncated;
};

/*
 *  Raw write/read macros for big endian, unaligned basic values.
 *  Caller ensures there's enough space.  The macros update the pointer
 *  argument automatically on resizes.  The idiom seems a bit odd, but
 *  leads to compact code.
 */

#define DUK_RAW_WRITE_U8(ptr,val)  do { \
		*(ptr)++ = (duk_uint8_t) (val); \
	} while (0)
#define DUK_RAW_WRITE_U16_BE(ptr,val) duk_raw_write_u16_be(&(ptr), (duk_uint16_t) (val))
#define DUK_RAW_WRITE_U32_BE(ptr,val) duk_raw_write_u32_be(&(ptr), (duk_uint32_t) (val))
#define DUK_RAW_WRITE_DOUBLE_BE(ptr,val) duk_raw_write_double_be(&(ptr), (duk_double_t) (val))
#define DUK_RAW_WRITE_XUTF8(ptr,val)  do { \
		/* 'ptr' is evaluated both as LHS and RHS. */ \
		duk_uint8_t *duk__ptr; \
		duk_small_int_t duk__len; \
		duk__ptr = (duk_uint8_t *) (ptr); \
		duk__len = duk_unicode_encode_xutf8((duk_ucodepoint_t) (val), duk__ptr); \
		duk__ptr += duk__len; \
		(ptr) = duk__ptr; \
	} while (0)
#define DUK_RAW_WRITE_CESU8(ptr,val)  do { \
		/* 'ptr' is evaluated both as LHS and RHS. */ \
		duk_uint8_t *duk__ptr; \
		duk_small_int_t duk__len; \
		duk__ptr = (duk_uint8_t *) (ptr); \
		duk__len = duk_unicode_encode_cesu8((duk_ucodepoint_t) (val), duk__ptr); \
		duk__ptr += duk__len; \
		(ptr) = duk__ptr; \
	} while (0)

#define DUK_RAW_READ_U8(ptr) ((duk_uint8_t) (*(ptr)++))
#define DUK_RAW_READ_U16_BE(ptr) duk_raw_read_u16_be(&(ptr));
#define DUK_RAW_READ_U32_BE(ptr) duk_raw_read_u32_be(&(ptr));
#define DUK_RAW_READ_DOUBLE_BE(ptr) duk_raw_read_double_be(&(ptr));

/*
 *  Buffer writer (dynamic buffer only)
 *
 *  Helper for writing to a dynamic buffer with a concept of a "spare" area
 *  to reduce resizes.  You can ensure there is enough space beforehand and
 *  then write for a while without further checks, relying on a stable data
 *  pointer.  Spare handling is automatic so call sites only indicate how
 *  much data they need right now.
 *
 *  There are several ways to write using bufwriter.  The best approach
 *  depends mainly on how much performance matters over code footprint.
 *  The key issues are (1) ensuring there is space and (2) keeping the
 *  pointers consistent.  Fast code should ensure space for multiple writes
 *  with one ensure call.  Fastest inner loop code can temporarily borrow
 *  the 'p' pointer but must write it back eventually.
 *
 *  Be careful to ensure all macro arguments (other than static pointers like
 *  'thr' and 'bw_ctx') are evaluated exactly once, using temporaries if
 *  necessary (if that's not possible, there should be a note near the macro).
 *  Buffer write arguments often contain arithmetic etc so this is
 *  particularly important here.
 */

/* XXX: Migrate bufwriter and other read/write helpers to its own header? */

struct duk_bufwriter_ctx {
	duk_uint8_t *p;
	duk_uint8_t *p_base;
	duk_uint8_t *p_limit;
	duk_hbuffer_dynamic *buf;
};

#define DUK_BW_SPARE_ADD           64
#define DUK_BW_SPARE_SHIFT         4    /* 2^4 -> 1/16 = 6.25% spare */

/* Initialization and finalization (compaction), converting to other types. */

#define DUK_BW_INIT_PUSHBUF(thr,bw_ctx,sz) do { \
		duk_bw_init_pushbuf((thr), (bw_ctx), (sz)); \
	} while (0)
#define DUK_BW_INIT_WITHBUF(thr,bw_ctx,buf) do { \
		duk_bw_init((thr), (bw_ctx), (buf)); \
	} while (0)
#define DUK_BW_COMPACT(thr,bw_ctx) do { \
		/* Make underlying buffer compact to match DUK_BW_GET_SIZE(). */ \
		duk_bw_compact((thr), (bw_ctx)); \
	} while (0)
#define DUK_BW_PUSH_AS_STRING(thr,bw_ctx) do { \
		duk_push_lstring((duk_context *) (thr), \
		                 (const char *) (bw_ctx)->p_base, \
		                 (duk_size_t) ((bw_ctx)->p - (bw_ctx)->p_base)); \
	} while (0)
/* Pointers may be NULL for a while when 'buf' size is zero and before any
 * ENSURE calls have been made.  Once an ENSURE has been made, the pointers
 * are required to be non-NULL so that it's always valid to use memcpy() and
 * memmove(), even for zero size.
 */
#define DUK_BW_ASSERT_VALID_EXPR(thr,bw_ctx) \
	DUK_ASSERT_EXPR((bw_ctx) != NULL && \
	                (bw_ctx)->buf != NULL && \
			((DUK_HBUFFER_DYNAMIC_GET_SIZE((bw_ctx)->buf) == 0) || \
				((bw_ctx)->p != NULL && \
		                 (bw_ctx)->p_base != NULL && \
		                 (bw_ctx)->p_limit != NULL && \
		                 (bw_ctx)->p_limit >= (bw_ctx)->p_base && \
		                 (bw_ctx)->p >= (bw_ctx)->p_base && \
		                 (bw_ctx)->p <= (bw_ctx)->p_limit)))
#define DUK_BW_ASSERT_VALID(thr,bw_ctx) do { \
		DUK_BW_ASSERT_VALID_EXPR((thr), (bw_ctx)); \
	} while (0)

/* Working with the pointer and current size. */

#define DUK_BW_GET_PTR(thr,bw_ctx) \
	((bw_ctx)->p)
#define DUK_BW_SET_PTR(thr,bw_ctx,ptr) do { \
		(bw_ctx)->p = (ptr); \
	} while (0)
#define DUK_BW_ADD_PTR(thr,bw_ctx,delta) do { \
		(bw_ctx)->p += (delta); \
	} while (0)
#define DUK_BW_GET_BASEPTR(thr,bw_ctx) \
	((bw_ctx)->p_base)
#define DUK_BW_GET_LIMITPTR(thr,bw_ctx) \
	((bw_ctx)->p_limit)
#define DUK_BW_GET_SIZE(thr,bw_ctx) \
	((duk_size_t) ((bw_ctx)->p - (bw_ctx)->p_base))
#define DUK_BW_SET_SIZE(thr,bw_ctx,sz) do { \
		DUK_ASSERT((duk_size_t) (sz) <= (duk_size_t) ((bw_ctx)->p - (bw_ctx)->p_base)); \
		(bw_ctx)->p = (bw_ctx)->p_base + (sz); \
	} while (0)
#define DUK_BW_RESET_SIZE(thr,bw_ctx) do { \
		/* Reset to zero size, keep current limit. */ \
		(bw_ctx)->p = (bw_ctx)->p_base; \
	} while (0)
#define DUK_BW_GET_BUFFER(thr,bw_ctx) \
	((bw_ctx)->buf)

/* Ensuring (reserving) space. */

#define DUK_BW_ENSURE(thr,bw_ctx,sz) do { \
		duk_size_t duk__sz, duk__space; \
		DUK_BW_ASSERT_VALID((thr), (bw_ctx)); \
		duk__sz = (sz); \
		duk__space = (duk_size_t) ((bw_ctx)->p_limit - (bw_ctx)->p); \
		if (duk__space < duk__sz) { \
			(void) duk_bw_resize((thr), (bw_ctx), duk__sz); \
		} \
	} while (0)
/* NOTE: Multiple evaluation of 'ptr' in this macro. */
/* XXX: Rework to use an always-inline function? */
#define DUK_BW_ENSURE_RAW(thr,bw_ctx,sz,ptr) \
	(((duk_size_t) ((bw_ctx)->p_limit - (ptr)) >= (sz)) ? \
	 (ptr) : \
	 ((bw_ctx)->p = (ptr), duk_bw_resize((thr),(bw_ctx),(sz))))
#define DUK_BW_ENSURE_GETPTR(thr,bw_ctx,sz) \
	DUK_BW_ENSURE_RAW((thr), (bw_ctx), (sz), (bw_ctx)->p)
#define DUK_BW_ASSERT_SPACE_EXPR(thr,bw_ctx,sz) \
	(DUK_BW_ASSERT_VALID_EXPR((thr), (bw_ctx)), \
	 DUK_ASSERT_EXPR((duk_size_t) ((bw_ctx)->p_limit - (bw_ctx)->p) >= (duk_size_t) (sz)))
#define DUK_BW_ASSERT_SPACE(thr,bw_ctx,sz) do { \
		DUK_BW_ASSERT_SPACE_EXPR((thr), (bw_ctx), (sz)); \
	} while (0)

/* Miscellaneous. */

#define DUK_BW_SETPTR_AND_COMPACT(thr,bw_ctx,ptr) do { \
		(bw_ctx)->p = (ptr); \
		duk_bw_compact((thr), (bw_ctx)); \
	} while (0)

/* Fast write calls which assume you control the spare beforehand.
 * Multibyte write variants exist and use a temporary write pointer
 * because byte writes alias with anything: with a stored pointer
 * explicit pointer load/stores get generated (e.g. gcc -Os).
 */

#define DUK_BW_WRITE_RAW_U8(thr,bw_ctx,val) do { \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), 1); \
		*(bw_ctx)->p++ = (duk_uint8_t) (val); \
	} while (0)
#define DUK_BW_WRITE_RAW_U8_2(thr,bw_ctx,val1,val2) do { \
		duk_uint8_t *duk__p; \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), 2); \
		duk__p = (bw_ctx)->p; \
		*duk__p++ = (duk_uint8_t) (val1); \
		*duk__p++ = (duk_uint8_t) (val2); \
		(bw_ctx)->p = duk__p; \
	} while (0)
#define DUK_BW_WRITE_RAW_U8_3(thr,bw_ctx,val1,val2,val3) do { \
		duk_uint8_t *duk__p; \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), 3); \
		duk__p = (bw_ctx)->p; \
		*duk__p++ = (duk_uint8_t) (val1); \
		*duk__p++ = (duk_uint8_t) (val2); \
		*duk__p++ = (duk_uint8_t) (val3); \
		(bw_ctx)->p = duk__p; \
	} while (0)
#define DUK_BW_WRITE_RAW_U8_4(thr,bw_ctx,val1,val2,val3,val4) do { \
		duk_uint8_t *duk__p; \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), 4); \
		duk__p = (bw_ctx)->p; \
		*duk__p++ = (duk_uint8_t) (val1); \
		*duk__p++ = (duk_uint8_t) (val2); \
		*duk__p++ = (duk_uint8_t) (val3); \
		*duk__p++ = (duk_uint8_t) (val4); \
		(bw_ctx)->p = duk__p; \
	} while (0)
#define DUK_BW_WRITE_RAW_U8_5(thr,bw_ctx,val1,val2,val3,val4,val5) do { \
		duk_uint8_t *duk__p; \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), 5); \
		duk__p = (bw_ctx)->p; \
		*duk__p++ = (duk_uint8_t) (val1); \
		*duk__p++ = (duk_uint8_t) (val2); \
		*duk__p++ = (duk_uint8_t) (val3); \
		*duk__p++ = (duk_uint8_t) (val4); \
		*duk__p++ = (duk_uint8_t) (val5); \
		(bw_ctx)->p = duk__p; \
	} while (0)
#define DUK_BW_WRITE_RAW_U8_6(thr,bw_ctx,val1,val2,val3,val4,val5,val6) do { \
		duk_uint8_t *duk__p; \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), 6); \
		duk__p = (bw_ctx)->p; \
		*duk__p++ = (duk_uint8_t) (val1); \
		*duk__p++ = (duk_uint8_t) (val2); \
		*duk__p++ = (duk_uint8_t) (val3); \
		*duk__p++ = (duk_uint8_t) (val4); \
		*duk__p++ = (duk_uint8_t) (val5); \
		*duk__p++ = (duk_uint8_t) (val6); \
		(bw_ctx)->p = duk__p; \
	} while (0)
#define DUK_BW_WRITE_RAW_XUTF8(thr,bw_ctx,cp) do { \
		duk_ucodepoint_t duk__cp; \
		duk_small_int_t duk__enc_len; \
		duk__cp = (cp); \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), duk_unicode_get_xutf8_length(duk__cp)); \
		duk__enc_len = duk_unicode_encode_xutf8(duk__cp, (bw_ctx)->p); \
		(bw_ctx)->p += duk__enc_len; \
	} while (0)
#define DUK_BW_WRITE_RAW_CESU8(thr,bw_ctx,cp) do { \
		duk_ucodepoint_t duk__cp; \
		duk_small_int_t duk__enc_len; \
		duk__cp = (duk_ucodepoint_t) (cp); \
		DUK_BW_ASSERT_SPACE((thr), (bw_ctx), duk_unicode_get_cesu8_length(duk__cp)); \
		duk__enc_len = duk_unicode_encode_cesu8(duk__cp, (bw_ctx)->p); \
		(bw_ctx)->p += duk__enc_len; \
	} while (0)
/* XXX: add temporary duk__p pointer here too; sharing */
#define DUK_BW_WRITE_RAW_BYTES(thr,bw_ctx,valptr,valsz) do { \
		const void *duk__valptr; \
		duk_size_t duk__valsz; \
		duk__valptr = (const void *) (valptr); \
		duk__valsz = (duk_size_t) (valsz); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), duk__valptr, duk__valsz); \
		(bw_ctx)->p += duk__valsz; \
	} while (0)
#define DUK_BW_WRITE_RAW_CSTRING(thr,bw_ctx,val) do { \
		const duk_uint8_t *duk__val; \
		duk_size_t duk__val_len; \
		duk__val = (const duk_uint8_t *) (val); \
		duk__val_len = DUK_STRLEN((const char *) duk__val); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) duk__val, duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_RAW_HSTRING(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HSTRING_GET_BYTELEN((val)); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HSTRING_GET_DATA((val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_RAW_HBUFFER(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HBUFFER_GET_SIZE((val)); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HBUFFER_GET_DATA_PTR((thr)->heap, (val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_RAW_HBUFFER_FIXED(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HBUFFER_FIXED_GET_SIZE((val)); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HBUFFER_FIXED_GET_DATA_PTR((thr)->heap, (val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_RAW_HBUFFER_DYNAMIC(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HBUFFER_DYNAMIC_GET_SIZE((val)); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HBUFFER_DYNAMIC_GET_DATA_PTR((thr)->heap, (val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)

/* Append bytes from a slice already in the buffer. */
#define DUK_BW_WRITE_RAW_SLICE(thr,bw,dst_off,dst_len) \
	duk_bw_write_raw_slice((thr), (bw), (dst_off), (dst_len))

/* Insert bytes in the middle of the buffer from an external buffer. */
#define DUK_BW_INSERT_RAW_BYTES(thr,bw,dst_off,buf,len) \
	duk_bw_insert_raw_bytes((thr), (bw), (dst_off), (buf), (len))

/* Insert bytes in the middle of the buffer from a slice already
 * in the buffer.  Source offset is interpreted "before" the operation.
 */
#define DUK_BW_INSERT_RAW_SLICE(thr,bw,dst_off,src_off,len) \
	duk_bw_insert_raw_slice((thr), (bw), (dst_off), (src_off), (len))

/* Insert a reserved area somewhere in the buffer; caller fills it.
 * Evaluates to a (duk_uint_t *) pointing to the start of the reserved
 * area for convenience.
 */
#define DUK_BW_INSERT_RAW_AREA(thr,bw,off,len) \
	duk_bw_insert_raw_area((thr), (bw), (off), (len))

/* Remove a slice from inside buffer. */
#define DUK_BW_REMOVE_RAW_SLICE(thr,bw,off,len) \
	duk_bw_remove_raw_slice((thr), (bw), (off), (len))

/* Safe write calls which will ensure space first. */

#define DUK_BW_WRITE_ENSURE_U8(thr,bw_ctx,val) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), 1); \
		DUK_BW_WRITE_RAW_U8((thr), (bw_ctx), (val)); \
	} while (0)
#define DUK_BW_WRITE_ENSURE_U8_2(thr,bw_ctx,val1,val2) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), 2); \
		DUK_BW_WRITE_RAW_U8_2((thr), (bw_ctx), (val1), (val2)); \
	} while (0)
#define DUK_BW_WRITE_ENSURE_U8_3(thr,bw_ctx,val1,val2,val3) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), 3); \
		DUK_BW_WRITE_RAW_U8_3((thr), (bw_ctx), (val1), (val2), (val3)); \
	} while (0)
#define DUK_BW_WRITE_ENSURE_U8_4(thr,bw_ctx,val1,val2,val3,val4) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), 4); \
		DUK_BW_WRITE_RAW_U8_4((thr), (bw_ctx), (val1), (val2), (val3), (val4)); \
	} while (0)
#define DUK_BW_WRITE_ENSURE_U8_5(thr,bw_ctx,val1,val2,val3,val4,val5) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), 5); \
		DUK_BW_WRITE_RAW_U8_5((thr), (bw_ctx), (val1), (val2), (val3), (val4), (val5)); \
	} while (0)
#define DUK_BW_WRITE_ENSURE_U8_6(thr,bw_ctx,val1,val2,val3,val4,val5,val6) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), 6); \
		DUK_BW_WRITE_RAW_U8_6((thr), (bw_ctx), (val1), (val2), (val3), (val4), (val5), (val6)); \
	} while (0)
#define DUK_BW_WRITE_ENSURE_XUTF8(thr,bw_ctx,cp) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), DUK_UNICODE_MAX_XUTF8_LENGTH); \
		DUK_BW_WRITE_RAW_XUTF8((thr), (bw_ctx), (cp)); \
	} while (0)
#define DUK_BW_WRITE_ENSURE_CESU8(thr,bw_ctx,cp) do { \
		DUK_BW_ENSURE((thr), (bw_ctx), DUK_UNICODE_MAX_CESU8_LENGTH); \
		DUK_BW_WRITE_RAW_CESU8((thr), (bw_ctx), (cp)); \
	} while (0)
/* XXX: add temporary duk__p pointer here too; sharing */
#define DUK_BW_WRITE_ENSURE_BYTES(thr,bw_ctx,valptr,valsz) do { \
		const void *duk__valptr; \
		duk_size_t duk__valsz; \
		duk__valptr = (const void *) (valptr); \
		duk__valsz = (duk_size_t) (valsz); \
		DUK_BW_ENSURE((thr), (bw_ctx), duk__valsz); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), duk__valptr, duk__valsz); \
		(bw_ctx)->p += duk__valsz; \
	} while (0)
#define DUK_BW_WRITE_ENSURE_CSTRING(thr,bw_ctx,val) do { \
		const duk_uint8_t *duk__val; \
		duk_size_t duk__val_len; \
		duk__val = (const duk_uint8_t *) (val); \
		duk__val_len = DUK_STRLEN((const char *) duk__val); \
		DUK_BW_ENSURE((thr), (bw_ctx), duk__val_len); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) duk__val, duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_ENSURE_HSTRING(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HSTRING_GET_BYTELEN((val)); \
		DUK_BW_ENSURE((thr), (bw_ctx), duk__val_len); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HSTRING_GET_DATA((val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_ENSURE_HBUFFER(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HBUFFER_GET_SIZE((val)); \
		DUK_BW_ENSURE((thr), (bw_ctx), duk__val_len); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HBUFFER_GET_DATA_PTR((thr)->heap, (val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_ENSURE_HBUFFER_FIXED(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HBUFFER_FIXED_GET_SIZE((val)); \
		DUK_BW_ENSURE((thr), (bw_ctx), duk__val_len); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HBUFFER_FIXED_GET_DATA_PTR((thr)->heap, (val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)
#define DUK_BW_WRITE_ENSURE_HBUFFER_DYNAMIC(thr,bw_ctx,val) do { \
		duk_size_t duk__val_len; \
		duk__val_len = DUK_HBUFFER_DYNAMIC_GET_SIZE((val)); \
		DUK_BW_ENSURE((thr), (bw_ctx), duk__val_len); \
		DUK_MEMCPY((void *) ((bw_ctx)->p), (const void *) DUK_HBUFFER_DYNAMIC_GET_DATA_PTR((thr)->heap, (val)), duk__val_len); \
		(bw_ctx)->p += duk__val_len; \
	} while (0)

#define DUK_BW_WRITE_ENSURE_SLICE(thr,bw,dst_off,dst_len) \
	duk_bw_write_ensure_slice((thr), (bw), (dst_off), (dst_len))
#define DUK_BW_INSERT_ENSURE_BYTES(thr,bw,dst_off,buf,len) \
	duk_bw_insert_ensure_bytes((thr), (bw), (dst_off), (buf), (len))
#define DUK_BW_INSERT_ENSURE_SLICE(thr,bw,dst_off,src_off,len) \
	duk_bw_insert_ensure_slice((thr), (bw), (dst_off), (src_off), (len))
#define DUK_BW_INSERT_ENSURE_AREA(thr,bw,off,len) \
	/* Evaluates to (duk_uint8_t *) pointing to start of area. */ \
	duk_bw_insert_ensure_area((thr), (bw), (off), (len))
#define DUK_BW_REMOVE_ENSURE_SLICE(thr,bw,off,len) \
	/* No difference between raw/ensure because the buffer shrinks. */ \
	DUK_BW_REMOVE_RAW_SLICE((thr), (bw), (off), (len))

/*
 *  Externs and prototypes
 */

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const duk_uint8_t duk_lc_digits[36];
DUK_INTERNAL_DECL const duk_uint8_t duk_uc_nybbles[16];
DUK_INTERNAL_DECL const duk_int8_t duk_hex_dectab[256];
#if defined(DUK_USE_HEX_FASTPATH)
DUK_INTERNAL_DECL const duk_int16_t duk_hex_dectab_shift4[256];
DUK_INTERNAL_DECL const duk_uint16_t duk_hex_enctab[256];
#endif
#if defined(DUK_USE_BASE64_FASTPATH)
DUK_INTERNAL_DECL const duk_uint8_t duk_base64_enctab[64];
DUK_INTERNAL_DECL const duk_int8_t duk_base64_dectab[256];
#endif
#endif  /* !DUK_SINGLE_FILE */

/* Note: assumes that duk_util_probe_steps size is 32 */
#if defined(DUK_USE_HOBJECT_HASH_PART) || defined(DUK_USE_STRTAB_PROBE)
#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL duk_uint8_t duk_util_probe_steps[32];
#endif  /* !DUK_SINGLE_FILE */
#endif

#if defined(DUK_USE_STRHASH_DENSE)
DUK_INTERNAL_DECL duk_uint32_t duk_util_hashbytes(const duk_uint8_t *data, duk_size_t len, duk_uint32_t seed);
#endif

#if defined(DUK_USE_HOBJECT_HASH_PART) || defined(DUK_USE_STRTAB_PROBE)
DUK_INTERNAL_DECL duk_uint32_t duk_util_get_hash_prime(duk_uint32_t size);
#endif

DUK_INTERNAL_DECL duk_int32_t duk_bd_decode(duk_bitdecoder_ctx *ctx, duk_small_int_t bits);
DUK_INTERNAL_DECL duk_small_int_t duk_bd_decode_flag(duk_bitdecoder_ctx *ctx);
DUK_INTERNAL_DECL duk_int32_t duk_bd_decode_flagged(duk_bitdecoder_ctx *ctx, duk_small_int_t bits, duk_int32_t def_value);

DUK_INTERNAL_DECL void duk_be_encode(duk_bitencoder_ctx *ctx, duk_uint32_t data, duk_small_int_t bits);
DUK_INTERNAL_DECL void duk_be_finish(duk_bitencoder_ctx *ctx);

DUK_INTERNAL_DECL duk_uint32_t duk_util_tinyrandom_get_bits(duk_hthread *thr, duk_small_int_t n);
DUK_INTERNAL_DECL duk_double_t duk_util_tinyrandom_get_double(duk_hthread *thr);

DUK_INTERNAL_DECL void duk_bw_init(duk_hthread *thr, duk_bufwriter_ctx *bw_ctx, duk_hbuffer_dynamic *h_buf);
DUK_INTERNAL_DECL void duk_bw_init_pushbuf(duk_hthread *thr, duk_bufwriter_ctx *bw_ctx, duk_size_t buf_size);
DUK_INTERNAL_DECL duk_uint8_t *duk_bw_resize(duk_hthread *thr, duk_bufwriter_ctx *bw_ctx, duk_size_t sz);
DUK_INTERNAL_DECL void duk_bw_compact(duk_hthread *thr, duk_bufwriter_ctx *bw_ctx);
DUK_INTERNAL_DECL void duk_bw_write_raw_slice(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t src_off, duk_size_t len);
DUK_INTERNAL_DECL void duk_bw_write_ensure_slice(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t src_off, duk_size_t len);
DUK_INTERNAL_DECL void duk_bw_insert_raw_bytes(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t dst_off, const duk_uint8_t *buf, duk_size_t len);
DUK_INTERNAL_DECL void duk_bw_insert_ensure_bytes(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t dst_off, const duk_uint8_t *buf, duk_size_t len);
DUK_INTERNAL_DECL void duk_bw_insert_raw_slice(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t dst_off, duk_size_t src_off, duk_size_t len);
DUK_INTERNAL_DECL void duk_bw_insert_ensure_slice(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t dst_off, duk_size_t src_off, duk_size_t len);
DUK_INTERNAL_DECL duk_uint8_t *duk_bw_insert_raw_area(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t off, duk_size_t len);
DUK_INTERNAL_DECL duk_uint8_t *duk_bw_insert_ensure_area(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t off, duk_size_t len);
DUK_INTERNAL_DECL void duk_bw_remove_raw_slice(duk_hthread *thr, duk_bufwriter_ctx *bw, duk_size_t off, duk_size_t len);
/* No duk_bw_remove_ensure_slice(), functionality would be identical. */

DUK_INTERNAL_DECL duk_uint16_t duk_raw_read_u16_be(duk_uint8_t **p);
DUK_INTERNAL_DECL duk_uint32_t duk_raw_read_u32_be(duk_uint8_t **p);
DUK_INTERNAL_DECL duk_double_t duk_raw_read_double_be(duk_uint8_t **p);
DUK_INTERNAL_DECL void duk_raw_write_u16_be(duk_uint8_t **p, duk_uint16_t val);
DUK_INTERNAL_DECL void duk_raw_write_u32_be(duk_uint8_t **p, duk_uint32_t val);
DUK_INTERNAL_DECL void duk_raw_write_double_be(duk_uint8_t **p, duk_double_t val);

#if defined(DUK_USE_DEBUGGER_SUPPORT)  /* For now only needed by the debugger. */
DUK_INTERNAL void duk_byteswap_bytes(duk_uint8_t *p, duk_small_uint_t len);
#endif

#endif  /* DUK_UTIL_H_INCLUDED */
#line 1 "duk_strings.h"
/*
 *  Shared error messages: declarations and macros
 *
 *  Error messages are accessed through macros with fine-grained, explicit
 *  error message distinctions.  Concrete error messages are selected by the
 *  macros and multiple macros can map to the same concrete string to save
 *  on code footprint.  This allows flexible footprint/verbosity tuning with
 *  minimal code impact.  There are a few limitations to this approach:
 *  (1) switching between plain messages and format strings doesn't work
 *  conveniently, and (2) conditional strings are a bit awkward to handle.
 *
 *  Because format strings behave differently in the call site (they need to
 *  be followed by format arguments), they have a special prefix (DUK_STR_FMT_
 *  and duk_str_fmt_).
 *
 *  On some compilers using explicit shared strings is preferable; on others
 *  it may be better to use straight literals because the compiler will combine
 *  them anyway, and such strings won't end up unnecessarily in a symbol table.
 */

#ifndef DUK_ERRMSG_H_INCLUDED
#define DUK_ERRMSG_H_INCLUDED

#define DUK_STR_INTERNAL_ERROR duk_str_internal_error
#define DUK_STR_INVALID_COUNT duk_str_invalid_count
#define DUK_STR_INVALID_CALL_ARGS duk_str_invalid_call_args
#define DUK_STR_NOT_CONSTRUCTABLE duk_str_not_constructable
#define DUK_STR_NOT_CALLABLE duk_str_not_callable
#define DUK_STR_NOT_EXTENSIBLE duk_str_not_extensible
#define DUK_STR_NOT_WRITABLE duk_str_not_writable
#define DUK_STR_NOT_CONFIGURABLE duk_str_not_configurable

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_internal_error;
DUK_INTERNAL_DECL const char *duk_str_invalid_count;
DUK_INTERNAL_DECL const char *duk_str_invalid_call_args;
DUK_INTERNAL_DECL const char *duk_str_not_constructable;
DUK_INTERNAL_DECL const char *duk_str_not_callable;
DUK_INTERNAL_DECL const char *duk_str_not_extensible;
DUK_INTERNAL_DECL const char *duk_str_not_writable;
DUK_INTERNAL_DECL const char *duk_str_not_configurable;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_INVALID_CONTEXT duk_str_invalid_context
#define DUK_STR_INVALID_INDEX duk_str_invalid_call_args
#define DUK_STR_PUSH_BEYOND_ALLOC_STACK duk_str_push_beyond_alloc_stack
#define DUK_STR_NOT_UNDEFINED duk_str_unexpected_type
#define DUK_STR_NOT_NULL duk_str_unexpected_type
#define DUK_STR_NOT_BOOLEAN duk_str_unexpected_type
#define DUK_STR_NOT_NUMBER duk_str_unexpected_type
#define DUK_STR_NOT_STRING duk_str_unexpected_type
#define DUK_STR_NOT_OBJECT duk_str_unexpected_type
#define DUK_STR_NOT_POINTER duk_str_unexpected_type
#define DUK_STR_NOT_BUFFER duk_str_not_buffer  /* still in use with verbose messages */
#define DUK_STR_UNEXPECTED_TYPE duk_str_unexpected_type
#define DUK_STR_NOT_THREAD duk_str_unexpected_type
#define DUK_STR_NOT_COMPILEDFUNCTION duk_str_unexpected_type
#define DUK_STR_NOT_NATIVEFUNCTION duk_str_unexpected_type
#define DUK_STR_NOT_C_FUNCTION duk_str_unexpected_type
#define DUK_STR_NOT_FUNCTION duk_str_unexpected_type
#define DUK_STR_NOT_REGEXP duk_str_unexpected_type
#define DUK_STR_DEFAULTVALUE_COERCE_FAILED duk_str_defaultvalue_coerce_failed
#define DUK_STR_NUMBER_OUTSIDE_RANGE duk_str_number_outside_range
#define DUK_STR_NOT_OBJECT_COERCIBLE duk_str_not_object_coercible
#define DUK_STR_STRING_TOO_LONG duk_str_string_too_long
#define DUK_STR_BUFFER_TOO_LONG duk_str_buffer_too_long
#define DUK_STR_SPRINTF_TOO_LONG duk_str_sprintf_too_long
#define DUK_STR_ALLOC_FAILED duk_str_alloc_failed
#define DUK_STR_POP_TOO_MANY duk_str_pop_too_many
#define DUK_STR_WRONG_BUFFER_TYPE duk_str_wrong_buffer_type
#define DUK_STR_FAILED_TO_EXTEND_VALSTACK duk_str_failed_to_extend_valstack
#define DUK_STR_ENCODE_FAILED duk_str_encode_failed
#define DUK_STR_DECODE_FAILED duk_str_decode_failed
#define DUK_STR_NO_SOURCECODE duk_str_no_sourcecode
#define DUK_STR_CONCAT_RESULT_TOO_LONG duk_str_concat_result_too_long
#define DUK_STR_UNIMPLEMENTED duk_str_unimplemented
#define DUK_STR_UNSUPPORTED duk_str_unsupported
#define DUK_STR_ARRAY_LENGTH_OVER_2G duk_str_array_length_over_2g

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_invalid_context;
DUK_INTERNAL_DECL const char *duk_str_push_beyond_alloc_stack;
DUK_INTERNAL_DECL const char *duk_str_not_buffer;
DUK_INTERNAL_DECL const char *duk_str_unexpected_type;
DUK_INTERNAL_DECL const char *duk_str_defaultvalue_coerce_failed;
DUK_INTERNAL_DECL const char *duk_str_number_outside_range;
DUK_INTERNAL_DECL const char *duk_str_not_object_coercible;
DUK_INTERNAL_DECL const char *duk_str_string_too_long;
DUK_INTERNAL_DECL const char *duk_str_buffer_too_long;
DUK_INTERNAL_DECL const char *duk_str_sprintf_too_long;
DUK_INTERNAL_DECL const char *duk_str_alloc_failed;
DUK_INTERNAL_DECL const char *duk_str_pop_too_many;
DUK_INTERNAL_DECL const char *duk_str_wrong_buffer_type;
DUK_INTERNAL_DECL const char *duk_str_failed_to_extend_valstack;
DUK_INTERNAL_DECL const char *duk_str_encode_failed;
DUK_INTERNAL_DECL const char *duk_str_decode_failed;
DUK_INTERNAL_DECL const char *duk_str_no_sourcecode;
DUK_INTERNAL_DECL const char *duk_str_concat_result_too_long;
DUK_INTERNAL_DECL const char *duk_str_unimplemented;
DUK_INTERNAL_DECL const char *duk_str_unsupported;
DUK_INTERNAL_DECL const char *duk_str_array_length_over_2g;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_FMT_PTR duk_str_fmt_ptr
#define DUK_STR_FMT_INVALID_JSON duk_str_fmt_invalid_json
#define DUK_STR_JSONDEC_RECLIMIT duk_str_jsondec_reclimit
#define DUK_STR_JSONENC_RECLIMIT duk_str_jsonenc_reclimit
#define DUK_STR_CYCLIC_INPUT duk_str_cyclic_input

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_fmt_ptr;
DUK_INTERNAL_DECL const char *duk_str_fmt_invalid_json;
DUK_INTERNAL_DECL const char *duk_str_jsondec_reclimit;
DUK_INTERNAL_DECL const char *duk_str_jsonenc_reclimit;
DUK_INTERNAL_DECL const char *duk_str_cyclic_input;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_PROXY_REVOKED duk_str_proxy_revoked
#define DUK_STR_OBJECT_RESIZE_FAILED duk_str_object_resize_failed
#define DUK_STR_INVALID_BASE duk_str_invalid_base
#define DUK_STR_STRICT_CALLER_READ duk_str_strict_caller_read
#define DUK_STR_PROXY_REJECTED duk_str_proxy_rejected
#define DUK_STR_INVALID_ARRAY_LENGTH duk_str_invalid_array_length
#define DUK_STR_ARRAY_LENGTH_WRITE_FAILED duk_str_array_length_write_failed
#define DUK_STR_ARRAY_LENGTH_NOT_WRITABLE duk_str_array_length_not_writable
#define DUK_STR_SETTER_UNDEFINED duk_str_setter_undefined
#define DUK_STR_REDEFINE_VIRT_PROP duk_str_redefine_virt_prop
#define DUK_STR_INVALID_DESCRIPTOR duk_str_invalid_descriptor
#define DUK_STR_PROPERTY_IS_VIRTUAL duk_str_property_is_virtual

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_proxy_revoked;
DUK_INTERNAL_DECL const char *duk_str_object_resize_failed;
DUK_INTERNAL_DECL const char *duk_str_invalid_base;
DUK_INTERNAL_DECL const char *duk_str_strict_caller_read;
DUK_INTERNAL_DECL const char *duk_str_proxy_rejected;
DUK_INTERNAL_DECL const char *duk_str_invalid_array_length;
DUK_INTERNAL_DECL const char *duk_str_array_length_write_failed;
DUK_INTERNAL_DECL const char *duk_str_array_length_not_writable;
DUK_INTERNAL_DECL const char *duk_str_setter_undefined;
DUK_INTERNAL_DECL const char *duk_str_redefine_virt_prop;
DUK_INTERNAL_DECL const char *duk_str_invalid_descriptor;
DUK_INTERNAL_DECL const char *duk_str_property_is_virtual;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_PARSE_ERROR duk_str_parse_error
#define DUK_STR_DUPLICATE_LABEL duk_str_duplicate_label
#define DUK_STR_INVALID_LABEL duk_str_invalid_label
#define DUK_STR_INVALID_ARRAY_LITERAL duk_str_invalid_array_literal
#define DUK_STR_INVALID_OBJECT_LITERAL duk_str_invalid_object_literal
#define DUK_STR_INVALID_VAR_DECLARATION duk_str_invalid_var_declaration
#define DUK_STR_CANNOT_DELETE_IDENTIFIER duk_str_cannot_delete_identifier
#define DUK_STR_INVALID_EXPRESSION duk_str_invalid_expression
#define DUK_STR_INVALID_LVALUE duk_str_invalid_lvalue
#define DUK_STR_EXPECTED_IDENTIFIER duk_str_expected_identifier
#define DUK_STR_EMPTY_EXPR_NOT_ALLOWED duk_str_empty_expr_not_allowed
#define DUK_STR_INVALID_FOR duk_str_invalid_for
#define DUK_STR_INVALID_SWITCH duk_str_invalid_switch
#define DUK_STR_INVALID_BREAK_CONT_LABEL duk_str_invalid_break_cont_label
#define DUK_STR_INVALID_RETURN duk_str_invalid_return
#define DUK_STR_INVALID_TRY duk_str_invalid_try
#define DUK_STR_INVALID_THROW duk_str_invalid_throw
#define DUK_STR_WITH_IN_STRICT_MODE duk_str_with_in_strict_mode
#define DUK_STR_FUNC_STMT_NOT_ALLOWED duk_str_func_stmt_not_allowed
#define DUK_STR_UNTERMINATED_STMT duk_str_unterminated_stmt
#define DUK_STR_INVALID_ARG_NAME duk_str_invalid_arg_name
#define DUK_STR_INVALID_FUNC_NAME duk_str_invalid_func_name
#define DUK_STR_INVALID_GETSET_NAME duk_str_invalid_getset_name
#define DUK_STR_FUNC_NAME_REQUIRED duk_str_func_name_required

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_parse_error;
DUK_INTERNAL_DECL const char *duk_str_duplicate_label;
DUK_INTERNAL_DECL const char *duk_str_invalid_label;
DUK_INTERNAL_DECL const char *duk_str_invalid_array_literal;
DUK_INTERNAL_DECL const char *duk_str_invalid_object_literal;
DUK_INTERNAL_DECL const char *duk_str_invalid_var_declaration;
DUK_INTERNAL_DECL const char *duk_str_cannot_delete_identifier;
DUK_INTERNAL_DECL const char *duk_str_invalid_expression;
DUK_INTERNAL_DECL const char *duk_str_invalid_lvalue;
DUK_INTERNAL_DECL const char *duk_str_expected_identifier;
DUK_INTERNAL_DECL const char *duk_str_empty_expr_not_allowed;
DUK_INTERNAL_DECL const char *duk_str_invalid_for;
DUK_INTERNAL_DECL const char *duk_str_invalid_switch;
DUK_INTERNAL_DECL const char *duk_str_invalid_break_cont_label;
DUK_INTERNAL_DECL const char *duk_str_invalid_return;
DUK_INTERNAL_DECL const char *duk_str_invalid_try;
DUK_INTERNAL_DECL const char *duk_str_invalid_throw;
DUK_INTERNAL_DECL const char *duk_str_with_in_strict_mode;
DUK_INTERNAL_DECL const char *duk_str_func_stmt_not_allowed;
DUK_INTERNAL_DECL const char *duk_str_unterminated_stmt;
DUK_INTERNAL_DECL const char *duk_str_invalid_arg_name;
DUK_INTERNAL_DECL const char *duk_str_invalid_func_name;
DUK_INTERNAL_DECL const char *duk_str_invalid_getset_name;
DUK_INTERNAL_DECL const char *duk_str_func_name_required;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_INTERNAL_ERROR_EXEC_LONGJMP duk_str_internal_error_exec_longjmp

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_internal_error_exec_longjmp;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_INVALID_QUANTIFIER_NO_ATOM duk_str_invalid_quantifier_no_atom
#define DUK_STR_INVALID_QUANTIFIER_VALUES duk_str_invalid_quantifier_values
#define DUK_STR_QUANTIFIER_TOO_MANY_COPIES duk_str_quantifier_too_many_copies
#define DUK_STR_UNEXPECTED_CLOSING_PAREN duk_str_unexpected_closing_paren
#define DUK_STR_UNEXPECTED_END_OF_PATTERN duk_str_unexpected_end_of_pattern
#define DUK_STR_UNEXPECTED_REGEXP_TOKEN duk_str_unexpected_regexp_token
#define DUK_STR_INVALID_REGEXP_FLAGS duk_str_invalid_regexp_flags
#define DUK_STR_INVALID_BACKREFS duk_str_invalid_backrefs
#define DUK_STR_REGEXP_BACKTRACK_FAILED duk_str_regexp_backtrack_failed
#define DUK_STR_REGEXP_ADVANCE_FAILED duk_str_regexp_advance_failed
#define DUK_STR_REGEXP_INTERNAL_ERROR duk_str_regexp_internal_error

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_invalid_quantifier_no_atom;
DUK_INTERNAL_DECL const char *duk_str_invalid_quantifier_values;
DUK_INTERNAL_DECL const char *duk_str_quantifier_too_many_copies;
DUK_INTERNAL_DECL const char *duk_str_unexpected_closing_paren;
DUK_INTERNAL_DECL const char *duk_str_unexpected_end_of_pattern;
DUK_INTERNAL_DECL const char *duk_str_unexpected_regexp_token;
DUK_INTERNAL_DECL const char *duk_str_invalid_regexp_flags;
DUK_INTERNAL_DECL const char *duk_str_invalid_backrefs;
DUK_INTERNAL_DECL const char *duk_str_regexp_backtrack_failed;
DUK_INTERNAL_DECL const char *duk_str_regexp_advance_failed;
DUK_INTERNAL_DECL const char *duk_str_regexp_internal_error;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_VALSTACK_LIMIT duk_str_valstack_limit
#define DUK_STR_CALLSTACK_LIMIT duk_str_callstack_limit
#define DUK_STR_CATCHSTACK_LIMIT duk_str_catchstack_limit
#define DUK_STR_OBJECT_PROPERTY_LIMIT duk_str_object_property_limit
#define DUK_STR_PROTOTYPE_CHAIN_LIMIT duk_str_prototype_chain_limit
#define DUK_STR_BOUND_CHAIN_LIMIT duk_str_bound_chain_limit
#define DUK_STR_C_CALLSTACK_LIMIT duk_str_c_callstack_limit
#define DUK_STR_COMPILER_RECURSION_LIMIT duk_str_compiler_recursion_limit
#define DUK_STR_BYTECODE_LIMIT duk_str_bytecode_limit
#define DUK_STR_REG_LIMIT duk_str_reg_limit
#define DUK_STR_TEMP_LIMIT duk_str_temp_limit
#define DUK_STR_CONST_LIMIT duk_str_const_limit
#define DUK_STR_FUNC_LIMIT duk_str_func_limit
#define DUK_STR_REGEXP_COMPILER_RECURSION_LIMIT duk_str_regexp_compiler_recursion_limit
#define DUK_STR_REGEXP_EXECUTOR_RECURSION_LIMIT duk_str_regexp_executor_recursion_limit
#define DUK_STR_REGEXP_EXECUTOR_STEP_LIMIT duk_str_regexp_executor_step_limit

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_valstack_limit;
DUK_INTERNAL_DECL const char *duk_str_callstack_limit;
DUK_INTERNAL_DECL const char *duk_str_catchstack_limit;
DUK_INTERNAL_DECL const char *duk_str_object_property_limit;
DUK_INTERNAL_DECL const char *duk_str_prototype_chain_limit;
DUK_INTERNAL_DECL const char *duk_str_bound_chain_limit;
DUK_INTERNAL_DECL const char *duk_str_c_callstack_limit;
DUK_INTERNAL_DECL const char *duk_str_compiler_recursion_limit;
DUK_INTERNAL_DECL const char *duk_str_bytecode_limit;
DUK_INTERNAL_DECL const char *duk_str_reg_limit;
DUK_INTERNAL_DECL const char *duk_str_temp_limit;
DUK_INTERNAL_DECL const char *duk_str_const_limit;
DUK_INTERNAL_DECL const char *duk_str_func_limit;
DUK_INTERNAL_DECL const char *duk_str_regexp_compiler_recursion_limit;
DUK_INTERNAL_DECL const char *duk_str_regexp_executor_recursion_limit;
DUK_INTERNAL_DECL const char *duk_str_regexp_executor_step_limit;
#endif  /* !DUK_SINGLE_FILE */

#define DUK_STR_ANON duk_str_anon
#define DUK_STR_REALLOC_FAILED duk_str_realloc_failed

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_str_anon;
DUK_INTERNAL_DECL const char *duk_str_realloc_failed;
#endif  /* !DUK_SINGLE_FILE */

#endif  /* DUK_ERRMSG_H_INCLUDED */
#line 1 "duk_js_bytecode.h"
/*
 *  Ecmascript bytecode
 */

#ifndef DUK_JS_BYTECODE_H_INCLUDED
#define DUK_JS_BYTECODE_H_INCLUDED

/*
 *  Logical instruction layout
 *  ==========================
 *
 *  !3!3!2!2!2!2!2!2!2!2!2!2!1!1!1!1!1!1!1!1!1!1! ! ! ! ! ! ! ! ! ! !
 *  !1!0!9!8!7!6!5!4!3!2!1!0!9!8!7!6!5!4!3!2!1!0!9!8!7!6!5!4!3!2!1!0!
 *  +---------------------------------------------------+-----------+
 *  !       C         !       B         !      A        !    OP     !
 *  +---------------------------------------------------+-----------+
 *
 *  OP (6 bits):  opcode (DUK_OP_*), access should be fastest
 *  A (8 bits):   typically a target register number
 *  B (9 bits):   typically first source register/constant number
 *  C (9 bits):   typically second source register/constant number
 *
 *  Some instructions combine BC or ABC together for larger parameter values.
 *  Signed integers (e.g. jump offsets) are encoded as unsigned, with an opcode
 *  specific bias.  B and C may denote a register or a constant, see
 *  DUK_BC_ISREG() and DUK_BC_ISCONST().
 *
 *  Note: macro naming is a bit misleading, e.g. "ABC" in macro name but
 *  the field layout is logically "CBA".
 */

typedef duk_uint32_t duk_instr_t;

#define DUK_DEC_OP(x)               ((x) & 0x3fUL)
#define DUK_DEC_A(x)                (((x) >> 6) & 0xffUL)
#define DUK_DEC_B(x)                (((x) >> 14) & 0x1ffUL)
#define DUK_DEC_C(x)                (((x) >> 23) & 0x1ffUL)
#define DUK_DEC_BC(x)               (((x) >> 14) & 0x3ffffUL)
#define DUK_DEC_ABC(x)              (((x) >> 6) & 0x3ffffffUL)

#define DUK_ENC_OP(op)              ((duk_instr_t) (op))
#define DUK_ENC_OP_ABC(op,abc)      ((duk_instr_t) ( \
                                        (((duk_instr_t) (abc)) << 6) | \
                                        ((duk_instr_t) (op)) \
                                    ))
#define DUK_ENC_OP_A_BC(op,a,bc)    ((duk_instr_t) ( \
                                        (((duk_instr_t) (bc)) << 14) | \
                                        (((duk_instr_t) (a)) << 6) | \
                                        ((duk_instr_t) (op)) \
                                    ))
#define DUK_ENC_OP_A_B_C(op,a,b,c)  ((duk_instr_t) ( \
                                        (((duk_instr_t) (c)) << 23) | \
                                        (((duk_instr_t) (b)) << 14) | \
                                        (((duk_instr_t) (a)) << 6) | \
                                        ((duk_instr_t) (op)) \
                                    ))
#define DUK_ENC_OP_A_B(op,a,b)      DUK_ENC_OP_A_B_C(op,a,b,0)
#define DUK_ENC_OP_A(op,a)          DUK_ENC_OP_A_B_C(op,a,0,0)

/* Constants should be signed so that signed arithmetic involving them
 * won't cause values to be coerced accidentally to unsigned.
 */
#define DUK_BC_OP_MIN               0
#define DUK_BC_OP_MAX               0x3fL
#define DUK_BC_A_MIN                0
#define DUK_BC_A_MAX                0xffL
#define DUK_BC_B_MIN                0
#define DUK_BC_B_MAX                0x1ffL
#define DUK_BC_C_MIN                0
#define DUK_BC_C_MAX                0x1ffL
#define DUK_BC_BC_MIN               0
#define DUK_BC_BC_MAX               0x3ffffL
#define DUK_BC_ABC_MIN              0
#define DUK_BC_ABC_MAX              0x3ffffffL
#define DUK_BC_EXTRAOP_MIN          DUK_BC_A_MIN
#define DUK_BC_EXTRAOP_MAX          DUK_BC_A_MAX

#define DUK_OP_LDREG                0
#define DUK_OP_STREG                1
#define DUK_OP_LDCONST              2
#define DUK_OP_LDINT                3
#define DUK_OP_LDINTX               4
#define DUK_OP_MPUTOBJ              5
#define DUK_OP_MPUTOBJI             6
#define DUK_OP_MPUTARR              7
#define DUK_OP_MPUTARRI             8
#define DUK_OP_NEW                  9
#define DUK_OP_NEWI                 10
#define DUK_OP_REGEXP               11
#define DUK_OP_CSREG                12
#define DUK_OP_CSREGI               13
#define DUK_OP_GETVAR               14
#define DUK_OP_PUTVAR               15
#define DUK_OP_DECLVAR              16
#define DUK_OP_DELVAR               17
#define DUK_OP_CSVAR                18
#define DUK_OP_CSVARI               19
#define DUK_OP_CLOSURE              20
#define DUK_OP_GETPROP              21
#define DUK_OP_PUTPROP              22
#define DUK_OP_DELPROP              23
#define DUK_OP_CSPROP               24
#define DUK_OP_CSPROPI              25
#define DUK_OP_ADD                  26
#define DUK_OP_SUB                  27
#define DUK_OP_MUL                  28
#define DUK_OP_DIV                  29
#define DUK_OP_MOD                  30
#define DUK_OP_BAND                 31
#define DUK_OP_BOR                  32
#define DUK_OP_BXOR                 33
#define DUK_OP_BASL                 34
#define DUK_OP_BLSR                 35
#define DUK_OP_BASR                 36
#define DUK_OP_EQ                   37
#define DUK_OP_NEQ                  38
#define DUK_OP_SEQ                  39
#define DUK_OP_SNEQ                 40
#define DUK_OP_GT                   41
#define DUK_OP_GE                   42
#define DUK_OP_LT                   43
#define DUK_OP_LE                   44
#define DUK_OP_IF                   45
#define DUK_OP_JUMP                 46
#define DUK_OP_RETURN               47
#define DUK_OP_CALL                 48
#define DUK_OP_CALLI                49
#define DUK_OP_TRYCATCH             50
#define DUK_OP_EXTRA                51
#define DUK_OP_PREINCR              52  /* pre/post opcode values have constraints, */
#define DUK_OP_PREDECR              53  /* see duk_js_executor.c */
#define DUK_OP_POSTINCR             54
#define DUK_OP_POSTDECR             55
#define DUK_OP_PREINCV              56
#define DUK_OP_PREDECV              57
#define DUK_OP_POSTINCV             58
#define DUK_OP_POSTDECV             59
#define DUK_OP_PREINCP              60
#define DUK_OP_PREDECP              61
#define DUK_OP_POSTINCP             62
#define DUK_OP_POSTDECP             63
#define DUK_OP_NONE                 64  /* dummy value used as marker */

/* DUK_OP_EXTRA, sub-operation in A */
#define DUK_EXTRAOP_NOP             0
#define DUK_EXTRAOP_INVALID         1
#define DUK_EXTRAOP_LDTHIS          2
#define DUK_EXTRAOP_LDUNDEF         3
#define DUK_EXTRAOP_LDNULL          4
#define DUK_EXTRAOP_LDTRUE          5
#define DUK_EXTRAOP_LDFALSE         6
#define DUK_EXTRAOP_NEWOBJ          7
#define DUK_EXTRAOP_NEWARR          8
#define DUK_EXTRAOP_SETALEN         9
#define DUK_EXTRAOP_TYPEOF          10
#define DUK_EXTRAOP_TYPEOFID        11
#define DUK_EXTRAOP_INITENUM        12
#define DUK_EXTRAOP_NEXTENUM        13
#define DUK_EXTRAOP_INITSET         14
#define DUK_EXTRAOP_INITSETI        15
#define DUK_EXTRAOP_INITGET         16
#define DUK_EXTRAOP_INITGETI        17
#define DUK_EXTRAOP_ENDTRY          18
#define DUK_EXTRAOP_ENDCATCH        19
#define DUK_EXTRAOP_ENDFIN          20
#define DUK_EXTRAOP_THROW           21
#define DUK_EXTRAOP_INVLHS          22
#define DUK_EXTRAOP_UNM             23
#define DUK_EXTRAOP_UNP             24
#define DUK_EXTRAOP_DEBUGGER        25
#define DUK_EXTRAOP_BREAK           26
#define DUK_EXTRAOP_CONTINUE        27
#define DUK_EXTRAOP_BNOT            28
#define DUK_EXTRAOP_LNOT            29
#define DUK_EXTRAOP_INSTOF          30
#define DUK_EXTRAOP_IN              31
#define DUK_EXTRAOP_LABEL           32
#define DUK_EXTRAOP_ENDLABEL        33

/* DUK_OP_CALL flags in A */
#define DUK_BC_CALL_FLAG_TAILCALL           (1 << 0)
#define DUK_BC_CALL_FLAG_EVALCALL           (1 << 1)

/* DUK_OP_TRYCATCH flags in A */
#define DUK_BC_TRYCATCH_FLAG_HAVE_CATCH     (1 << 0)
#define DUK_BC_TRYCATCH_FLAG_HAVE_FINALLY   (1 << 1)
#define DUK_BC_TRYCATCH_FLAG_CATCH_BINDING  (1 << 2)
#define DUK_BC_TRYCATCH_FLAG_WITH_BINDING   (1 << 3)

/* DUK_OP_RETURN flags in A */
#define DUK_BC_RETURN_FLAG_HAVE_RETVAL      (1 << 0)

/* DUK_OP_DECLVAR flags in A; bottom bits are reserved for propdesc flags (DUK_PROPDESC_FLAG_XXX) */
#define DUK_BC_DECLVAR_FLAG_UNDEF_VALUE     (1 << 4)  /* use 'undefined' for value automatically */
#define DUK_BC_DECLVAR_FLAG_FUNC_DECL       (1 << 5)  /* function declaration */

/* misc constants and helper macros */
#define DUK_BC_REGLIMIT             256  /* if B/C is >= this value, refers to a const */
#define DUK_BC_ISREG(x)             ((x) < DUK_BC_REGLIMIT)
#define DUK_BC_ISCONST(x)           ((x) >= DUK_BC_REGLIMIT)
#define DUK_BC_LDINT_BIAS           (1L << 17)
#define DUK_BC_LDINTX_SHIFT         18
#define DUK_BC_JUMP_BIAS            (1L << 25)

#endif  /* DUK_JS_BYTECODE_H_INCLUDED */
#line 1 "duk_lexer.h"
/*
 *  Lexer defines.
 */

#ifndef DUK_LEXER_H_INCLUDED
#define DUK_LEXER_H_INCLUDED

typedef void (*duk_re_range_callback)(void *user, duk_codepoint_t r1, duk_codepoint_t r2, duk_bool_t direct);

/*
 *  A token is interpreted as any possible production of InputElementDiv
 *  and InputElementRegExp, see E5 Section 7 in its entirety.  Note that
 *  the E5 "Token" production does not cover all actual tokens of the
 *  language (which is explicitly stated in the specification, Section 7.5).
 *  Null and boolean literals are defined as part of both ReservedWord
 *  (E5 Section 7.6.1) and Literal (E5 Section 7.8) productions.  Here,
 *  null and boolean values have literal tokens, and are not reserved
 *  words.
 *
 *  Decimal literal negative/positive sign is -not- part of DUK_TOK_NUMBER.
 *  The number tokens always have a non-negative value.  The unary minus
 *  operator in "-1.0" is optimized during compilation to yield a single
 *  negative constant.
 *
 *  Token numbering is free except that reserved words are required to be
 *  in a continuous range and in a particular order.  See genstrings.py.
 */

#define DUK_LEXER_INITCTX(ctx)        duk_lexer_initctx((ctx))

#define DUK_LEXER_SETPOINT(ctx,pt)    duk_lexer_setpoint((ctx), (pt))

#define DUK_LEXER_GETPOINT(ctx,pt)    do { (pt)->offset = (ctx)->window[0].offset; \
                                           (pt)->line = (ctx)->window[0].line; } while (0)

/* currently 6 characters of lookup are actually needed (duk_lexer.c) */
#define DUK_LEXER_WINDOW_SIZE                     6
#if defined(DUK_USE_LEXER_SLIDING_WINDOW)
#define DUK_LEXER_BUFFER_SIZE                     64
#endif

#define DUK_TOK_MINVAL                            0

/* returned after EOF (infinite amount) */
#define DUK_TOK_EOF                               0

/* identifier names (E5 Section 7.6) */
#define DUK_TOK_IDENTIFIER                        1

/* reserved words: keywords */
#define DUK_TOK_START_RESERVED                    2
#define DUK_TOK_BREAK                             2
#define DUK_TOK_CASE                              3
#define DUK_TOK_CATCH                             4
#define DUK_TOK_CONTINUE                          5
#define DUK_TOK_DEBUGGER                          6
#define DUK_TOK_DEFAULT                           7
#define DUK_TOK_DELETE                            8
#define DUK_TOK_DO                                9
#define DUK_TOK_ELSE                              10
#define DUK_TOK_FINALLY                           11
#define DUK_TOK_FOR                               12
#define DUK_TOK_FUNCTION                          13
#define DUK_TOK_IF                                14
#define DUK_TOK_IN                                15
#define DUK_TOK_INSTANCEOF                        16
#define DUK_TOK_NEW                               17
#define DUK_TOK_RETURN                            18
#define DUK_TOK_SWITCH                            19
#define DUK_TOK_THIS                              20
#define DUK_TOK_THROW                             21
#define DUK_TOK_TRY                               22
#define DUK_TOK_TYPEOF                            23
#define DUK_TOK_VAR                               24
#define DUK_TOK_CONST                             25
#define DUK_TOK_VOID                              26
#define DUK_TOK_WHILE                             27
#define DUK_TOK_WITH                              28

/* reserved words: future reserved words */
#define DUK_TOK_CLASS                             29
#define DUK_TOK_ENUM                              30
#define DUK_TOK_EXPORT                            31
#define DUK_TOK_EXTENDS                           32
#define DUK_TOK_IMPORT                            33
#define DUK_TOK_SUPER                             34

/* "null", "true", and "false" are always reserved words.
 * Note that "get" and "set" are not!
 */
#define DUK_TOK_NULL                              35
#define DUK_TOK_TRUE                              36
#define DUK_TOK_FALSE                             37

/* reserved words: additional future reserved words in strict mode */
#define DUK_TOK_START_STRICT_RESERVED             38  /* inclusive */
#define DUK_TOK_IMPLEMENTS                        38
#define DUK_TOK_INTERFACE                         39
#define DUK_TOK_LET                               40
#define DUK_TOK_PACKAGE                           41
#define DUK_TOK_PRIVATE                           42
#define DUK_TOK_PROTECTED                         43
#define DUK_TOK_PUBLIC                            44
#define DUK_TOK_STATIC                            45
#define DUK_TOK_YIELD                             46

#define DUK_TOK_END_RESERVED                      47  /* exclusive */

/* "get" and "set" are tokens but NOT ReservedWords.  They are currently
 * parsed and identifiers and these defines are actually now unused.
 */
#define DUK_TOK_GET                               47
#define DUK_TOK_SET                               48

/* punctuators (unlike the spec, also includes "/" and "/=") */
#define DUK_TOK_LCURLY                            49
#define DUK_TOK_RCURLY                            50
#define DUK_TOK_LBRACKET                          51
#define DUK_TOK_RBRACKET                          52
#define DUK_TOK_LPAREN                            53
#define DUK_TOK_RPAREN                            54
#define DUK_TOK_PERIOD                            55
#define DUK_TOK_SEMICOLON                         56
#define DUK_TOK_COMMA                             57
#define DUK_TOK_LT                                58
#define DUK_TOK_GT                                59
#define DUK_TOK_LE                                60
#define DUK_TOK_GE                                61
#define DUK_TOK_EQ                                62
#define DUK_TOK_NEQ                               63
#define DUK_TOK_SEQ                               64
#define DUK_TOK_SNEQ                              65
#define DUK_TOK_ADD                               66
#define DUK_TOK_SUB                               67
#define DUK_TOK_MUL                               68
#define DUK_TOK_DIV                               69
#define DUK_TOK_MOD                               70
#define DUK_TOK_INCREMENT                         71
#define DUK_TOK_DECREMENT                         72
#define DUK_TOK_ALSHIFT                           73  /* named "arithmetic" because result is signed */
#define DUK_TOK_ARSHIFT                           74
#define DUK_TOK_RSHIFT                            75
#define DUK_TOK_BAND                              76
#define DUK_TOK_BOR                               77
#define DUK_TOK_BXOR                              78
#define DUK_TOK_LNOT                              79
#define DUK_TOK_BNOT                              80
#define DUK_TOK_LAND                              81
#define DUK_TOK_LOR                               82
#define DUK_TOK_QUESTION                          83
#define DUK_TOK_COLON                             84
#define DUK_TOK_EQUALSIGN                         85
#define DUK_TOK_ADD_EQ                            86
#define DUK_TOK_SUB_EQ                            87
#define DUK_TOK_MUL_EQ                            88
#define DUK_TOK_DIV_EQ                            89
#define DUK_TOK_MOD_EQ                            90
#define DUK_TOK_ALSHIFT_EQ                        91
#define DUK_TOK_ARSHIFT_EQ                        92
#define DUK_TOK_RSHIFT_EQ                         93
#define DUK_TOK_BAND_EQ                           94
#define DUK_TOK_BOR_EQ                            95
#define DUK_TOK_BXOR_EQ                           96

/* literals (E5 Section 7.8), except null, true, false, which are treated
 * like reserved words (above).
 */
#define DUK_TOK_NUMBER                            97
#define DUK_TOK_STRING                            98
#define DUK_TOK_REGEXP                            99

#define DUK_TOK_MAXVAL                            99  /* inclusive */

/* Convert heap string index to a token (reserved words) */
#define DUK_STRIDX_TO_TOK(x)                        ((x) - DUK_STRIDX_START_RESERVED + DUK_TOK_START_RESERVED)

/* Sanity check */
#if (DUK_TOK_MAXVAL > 255)
#error DUK_TOK_MAXVAL too large, code assumes it fits into 8 bits
#endif

/* Sanity checks for string and token defines */
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_BREAK) != DUK_TOK_BREAK)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_CASE) != DUK_TOK_CASE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_CATCH) != DUK_TOK_CATCH)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_CONTINUE) != DUK_TOK_CONTINUE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_DEBUGGER) != DUK_TOK_DEBUGGER)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_DEFAULT) != DUK_TOK_DEFAULT)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_DELETE) != DUK_TOK_DELETE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_DO) != DUK_TOK_DO)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_ELSE) != DUK_TOK_ELSE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_FINALLY) != DUK_TOK_FINALLY)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_FOR) != DUK_TOK_FOR)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_LC_FUNCTION) != DUK_TOK_FUNCTION)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_IF) != DUK_TOK_IF)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_IN) != DUK_TOK_IN)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_INSTANCEOF) != DUK_TOK_INSTANCEOF)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_NEW) != DUK_TOK_NEW)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_RETURN) != DUK_TOK_RETURN)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_SWITCH) != DUK_TOK_SWITCH)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_THIS) != DUK_TOK_THIS)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_THROW) != DUK_TOK_THROW)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_TRY) != DUK_TOK_TRY)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_TYPEOF) != DUK_TOK_TYPEOF)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_VAR) != DUK_TOK_VAR)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_VOID) != DUK_TOK_VOID)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_WHILE) != DUK_TOK_WHILE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_WITH) != DUK_TOK_WITH)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_CLASS) != DUK_TOK_CLASS)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_CONST) != DUK_TOK_CONST)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_ENUM) != DUK_TOK_ENUM)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_EXPORT) != DUK_TOK_EXPORT)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_EXTENDS) != DUK_TOK_EXTENDS)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_IMPORT) != DUK_TOK_IMPORT)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_SUPER) != DUK_TOK_SUPER)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_LC_NULL) != DUK_TOK_NULL)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_TRUE) != DUK_TOK_TRUE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_FALSE) != DUK_TOK_FALSE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_IMPLEMENTS) != DUK_TOK_IMPLEMENTS)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_INTERFACE) != DUK_TOK_INTERFACE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_LET) != DUK_TOK_LET)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_PACKAGE) != DUK_TOK_PACKAGE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_PRIVATE) != DUK_TOK_PRIVATE)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_PROTECTED) != DUK_TOK_PROTECTED)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_PUBLIC) != DUK_TOK_PUBLIC)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_STATIC) != DUK_TOK_STATIC)
#error mismatch in token defines
#endif
#if (DUK_STRIDX_TO_TOK(DUK_STRIDX_YIELD) != DUK_TOK_YIELD)
#error mismatch in token defines
#endif

/* Regexp tokens */
#define DUK_RETOK_EOF                              0
#define DUK_RETOK_DISJUNCTION                      1
#define DUK_RETOK_QUANTIFIER                       2
#define DUK_RETOK_ASSERT_START                     3
#define DUK_RETOK_ASSERT_END                       4
#define DUK_RETOK_ASSERT_WORD_BOUNDARY             5
#define DUK_RETOK_ASSERT_NOT_WORD_BOUNDARY         6
#define DUK_RETOK_ASSERT_START_POS_LOOKAHEAD       7
#define DUK_RETOK_ASSERT_START_NEG_LOOKAHEAD       8
#define DUK_RETOK_ATOM_PERIOD                      9
#define DUK_RETOK_ATOM_CHAR                        10
#define DUK_RETOK_ATOM_DIGIT                       11
#define DUK_RETOK_ATOM_NOT_DIGIT                   12
#define DUK_RETOK_ATOM_WHITE                       13
#define DUK_RETOK_ATOM_NOT_WHITE                   14
#define DUK_RETOK_ATOM_WORD_CHAR                   15
#define DUK_RETOK_ATOM_NOT_WORD_CHAR               16
#define DUK_RETOK_ATOM_BACKREFERENCE               17
#define DUK_RETOK_ATOM_START_CAPTURE_GROUP         18
#define DUK_RETOK_ATOM_START_NONCAPTURE_GROUP      19
#define DUK_RETOK_ATOM_START_CHARCLASS             20
#define DUK_RETOK_ATOM_START_CHARCLASS_INVERTED    21
#define DUK_RETOK_ATOM_END_GROUP                   22

/* Constants for duk_lexer_ctx.buf. */
#define DUK_LEXER_TEMP_BUF_LIMIT                   256

/* A token value.  Can be memcpy()'d, but note that slot1/slot2 values are on the valstack.
 * Some fields (like num, str1, str2) are only valid for specific token types and may have
 * stale values otherwise.
 */
struct duk_token {
	duk_small_int_t t;            /* token type (with reserved word identification) */
	duk_small_int_t t_nores;      /* token type (with reserved words as DUK_TOK_IDENTIFER) */
	duk_double_t num;             /* numeric value of token */
	duk_hstring *str1;            /* string 1 of token (borrowed, stored to ctx->slot1_idx) */
	duk_hstring *str2;            /* string 2 of token (borrowed, stored to ctx->slot2_idx) */
	duk_size_t start_offset;      /* start byte offset of token in lexer input */
	duk_int_t start_line;         /* start line of token (first char) */
	duk_int_t num_escapes;        /* number of escapes and line continuations (for directive prologue) */
	duk_bool_t lineterm;          /* token was preceded by a lineterm */
	duk_bool_t allow_auto_semi;   /* token allows automatic semicolon insertion (eof or preceded by newline) */
};

#define DUK_RE_QUANTIFIER_INFINITE         ((duk_uint32_t) 0xffffffffUL)

/* A regexp token value. */
struct duk_re_token {
	duk_small_int_t t;           /* token type */
	duk_small_int_t greedy;
	duk_uint_fast32_t num;       /* numeric value (character, count) */
	duk_uint_fast32_t qmin;
	duk_uint_fast32_t qmax;
};

/* A structure for 'snapshotting' a point for rewinding */
struct duk_lexer_point {
	duk_size_t offset;
	duk_int_t line;
};

/* Lexer codepoint with additional info like offset/line number */
struct duk_lexer_codepoint {
	duk_codepoint_t codepoint;
	duk_size_t offset;
	duk_int_t line;
};

/* Lexer context.  Same context is used for Ecmascript and Regexp parsing. */
struct duk_lexer_ctx {
#if defined(DUK_USE_LEXER_SLIDING_WINDOW)
	duk_lexer_codepoint *window; /* unicode code points, window[0] is always next, points to 'buffer' */
	duk_lexer_codepoint buffer[DUK_LEXER_BUFFER_SIZE];
#else
	duk_lexer_codepoint window[DUK_LEXER_WINDOW_SIZE]; /* unicode code points, window[0] is always next */
#endif

	duk_hthread *thr;                              /* thread; minimizes argument passing */

	const duk_uint8_t *input;                      /* input string (may be a user pointer) */
	duk_size_t input_length;                       /* input byte length */
	duk_size_t input_offset;                       /* input offset for window leading edge (not window[0]) */
	duk_int_t input_line;                          /* input linenumber at input_offset (not window[0]), init to 1 */

	duk_idx_t slot1_idx;                           /* valstack slot for 1st token value */
	duk_idx_t slot2_idx;                           /* valstack slot for 2nd token value */
	duk_idx_t buf_idx;                             /* valstack slot for temp buffer */
	duk_hbuffer_dynamic *buf;                      /* temp accumulation buffer */
	duk_bufwriter_ctx bw;                          /* bufwriter for temp accumulation */

	duk_int_t token_count;                         /* number of tokens parsed */
	duk_int_t token_limit;                         /* maximum token count before error (sanity backstop) */
};

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL void duk_lexer_initctx(duk_lexer_ctx *lex_ctx);

DUK_INTERNAL_DECL void duk_lexer_setpoint(duk_lexer_ctx *lex_ctx, duk_lexer_point *pt);

DUK_INTERNAL_DECL
void duk_lexer_parse_js_input_element(duk_lexer_ctx *lex_ctx,
                                      duk_token *out_token,
                                      duk_bool_t strict_mode,
                                      duk_bool_t regexp_mode);
#ifdef DUK_USE_REGEXP_SUPPORT
DUK_INTERNAL_DECL void duk_lexer_parse_re_token(duk_lexer_ctx *lex_ctx, duk_re_token *out_token);
DUK_INTERNAL_DECL void duk_lexer_parse_re_ranges(duk_lexer_ctx *lex_ctx, duk_re_range_callback gen_range, void *userdata);
#endif  /* DUK_USE_REGEXP_SUPPORT */

#endif  /* DUK_LEXER_H_INCLUDED */
#line 1 "duk_js_compiler.h"
/*
 *  Ecmascript compiler.
 */

#ifndef DUK_JS_COMPILER_H_INCLUDED
#define DUK_JS_COMPILER_H_INCLUDED

/* ecmascript compiler limits */
#define DUK_COMPILER_TOKEN_LIMIT           100000000L  /* 1e8: protects against deeply nested inner functions */

/* maximum loopcount for peephole optimization */
#define DUK_COMPILER_PEEPHOLE_MAXITER      3

/* maximum bytecode length in instructions */
#define DUK_COMPILER_MAX_BYTECODE_LENGTH   (256L * 1024L * 1024L)  /* 1 GB */

/*
 *  Compiler intermediate values
 *
 *  Intermediate values describe either plain values (e.g. strings or
 *  numbers) or binary operations which have not yet been coerced into
 *  either a left-hand-side or right-hand-side role (e.g. object property).
 */

#define DUK_IVAL_NONE          0   /* no value */
#define DUK_IVAL_PLAIN         1   /* register, constant, or value */
#define DUK_IVAL_ARITH         2   /* binary arithmetic; DUK_OP_ADD, DUK_OP_EQ, other binary ops */
#define DUK_IVAL_ARITH_EXTRAOP 3   /* binary arithmetic using extraops; DUK_EXTRAOP_INSTOF etc */
#define DUK_IVAL_PROP          4   /* property access */
#define DUK_IVAL_VAR           5   /* variable access */

#define DUK_ISPEC_NONE         0   /* no value */
#define DUK_ISPEC_VALUE        1   /* value resides in 'valstack_idx' */
#define DUK_ISPEC_REGCONST     2   /* value resides in a register or constant */

/* bit mask which indicates that a regconst is a constant instead of a register */
#define DUK_JS_CONST_MARKER    0x80000000UL

/* type to represent a reg/const reference during compilation */
typedef duk_uint32_t duk_regconst_t;

/* type to represent a straight register reference, with <0 indicating none */
typedef duk_int32_t duk_reg_t;

typedef struct {
	duk_small_uint_t t;          /* DUK_ISPEC_XXX */
	duk_regconst_t regconst;
	duk_idx_t valstack_idx;      /* always set; points to a reserved valstack slot */
} duk_ispec;

typedef struct {
	/*
	 *  PLAIN: x1
	 *  ARITH: x1 <op> x2
	 *  PROP: x1.x2
	 *  VAR: x1 (name)
	 */

	/* XXX: can be optimized for smaller footprint esp. on 32-bit environments */
	duk_small_uint_t t;          /* DUK_IVAL_XXX */
	duk_small_uint_t op;         /* bytecode opcode (or extraop) for binary ops */
	duk_ispec x1;
	duk_ispec x2;
} duk_ivalue;

/*
 *  Bytecode instruction representation during compilation
 *
 *  Contains the actual instruction and (optionally) debug info.
 */

struct duk_compiler_instr {
	duk_instr_t ins;
#if defined(DUK_USE_PC2LINE)
	duk_uint32_t line;
#endif
};

/*
 *  Compiler state
 */

#define DUK_LABEL_FLAG_ALLOW_BREAK       (1 << 0)
#define DUK_LABEL_FLAG_ALLOW_CONTINUE    (1 << 1)

#define DUK_DECL_TYPE_VAR                0
#define DUK_DECL_TYPE_FUNC               1

/* XXX: optimize to 16 bytes */
typedef struct {
	duk_small_uint_t flags;
	duk_int_t label_id;          /* numeric label_id (-1 reserved as marker) */
	duk_hstring *h_label;        /* borrowed label name */
	duk_int_t catch_depth;       /* catch depth at point of definition */
	duk_int_t pc_label;          /* pc of label statement:
	                              * pc+1: break jump site
	                              * pc+2: continue jump site
	                              */

	/* Fast jumps (which avoid longjmp) jump directly to the jump sites
	 * which are always known even while the iteration/switch statement
	 * is still being parsed.  A final peephole pass "straightens out"
	 * the jumps.
	 */
} duk_labelinfo;

/* Compiling state of one function, eventually converted to duk_hcompiledfunction */
struct duk_compiler_func {
	/* These pointers are at the start of the struct so that they pack
	 * nicely.  Mixing pointers and integer values is bad on some
	 * platforms (e.g. if int is 32 bits and pointers are 64 bits).
	 */

	duk_bufwriter_ctx bw_code;          /* bufwriter for code */

	duk_hstring *h_name;                /* function name (borrowed reference), ends up in _name */
	/* h_code: held in bw_code */
	duk_hobject *h_consts;              /* array */
	duk_hobject *h_funcs;               /* array of function templates: [func1, offset1, line1, func2, offset2, line2]
	                                     * offset/line points to closing brace to allow skipping on pass 2
	                                     */
	duk_hobject *h_decls;               /* array of declarations: [ name1, val1, name2, val2, ... ]
	                                     * valN = (typeN) | (fnum << 8), where fnum is inner func number (0 for vars)
	                                     * record function and variable declarations in pass 1
	                                     */
	duk_hobject *h_labelnames;          /* array of active label names */
	duk_hbuffer_dynamic *h_labelinfos;  /* C array of duk_labelinfo */
	duk_hobject *h_argnames;            /* array of formal argument names (-> _Formals) */
	duk_hobject *h_varmap;              /* variable map for pass 2 (identifier -> register number or null (unmapped)) */

	/* value stack indices for tracking objects */
	/* code_idx: not needed */
	duk_idx_t consts_idx;
	duk_idx_t funcs_idx;
	duk_idx_t decls_idx;
	duk_idx_t labelnames_idx;
	duk_idx_t labelinfos_idx;
	duk_idx_t argnames_idx;
	duk_idx_t varmap_idx;

	/* temp reg handling */
	duk_reg_t temp_first;               /* first register that is a temporary (below: variables) */
	duk_reg_t temp_next;                /* next temporary register to allocate */
	duk_reg_t temp_max;                 /* highest value of temp_reg (temp_max - 1 is highest used reg) */

	/* shuffle registers if large number of regs/consts */
	duk_reg_t shuffle1;
	duk_reg_t shuffle2;
	duk_reg_t shuffle3;

	/* stats for current expression being parsed */
	duk_int_t nud_count;
	duk_int_t led_count;
	duk_int_t paren_level;              /* parenthesis count, 0 = top level */
	duk_bool_t expr_lhs;                /* expression is left-hand-side compatible */
	duk_bool_t allow_in;                /* current paren level allows 'in' token */

	/* misc */
	duk_int_t stmt_next;                /* statement id allocation (running counter) */
	duk_int_t label_next;               /* label id allocation (running counter) */
	duk_int_t catch_depth;              /* catch stack depth */
	duk_int_t with_depth;               /* with stack depth (affects identifier lookups) */
	duk_int_t fnum_next;                /* inner function numbering */
	duk_int_t num_formals;              /* number of formal arguments */
	duk_reg_t reg_stmt_value;           /* register for writing value of 'non-empty' statements (global or eval code), -1 is marker */
#if defined(DUK_USE_DEBUGGER_SUPPORT)
	duk_int_t min_line;                 /* XXX: typing (duk_hcompiledfunction has duk_uint32_t) */
	duk_int_t max_line;
#endif

	/* status booleans */
	duk_bool_t is_function;             /* is an actual function (not global/eval code) */
	duk_bool_t is_eval;                 /* is eval code */
	duk_bool_t is_global;               /* is global code */
	duk_bool_t is_setget;               /* is a setter/getter */
	duk_bool_t is_decl;                 /* is a function declaration (as opposed to function expression) */
	duk_bool_t is_strict;               /* function is strict */
	duk_bool_t is_notail;               /* function must not be tail called */
	duk_bool_t in_directive_prologue;   /* parsing in "directive prologue", recognize directives */
	duk_bool_t in_scanning;             /* parsing in "scanning" phase (first pass) */
	duk_bool_t may_direct_eval;         /* function may call direct eval */
	duk_bool_t id_access_arguments;     /* function refers to 'arguments' identifier */
	duk_bool_t id_access_slow;          /* function makes one or more slow path accesses */
	duk_bool_t is_arguments_shadowed;   /* argument/function declaration shadows 'arguments' */
	duk_bool_t needs_shuffle;           /* function needs shuffle registers */
	duk_bool_t reject_regexp_in_adv;    /* reject RegExp literal on next advance() call; needed for handling IdentifierName productions */
};

struct duk_compiler_ctx {
	duk_hthread *thr;

	/* filename being compiled (ends up in functions' '_filename' property) */
	duk_hstring *h_filename;            /* borrowed reference */

	/* lexing (tokenization) state (contains two valstack slot indices) */
	duk_lexer_ctx lex;

	/* current and previous token for parsing */
	duk_token prev_token;
	duk_token curr_token;
	duk_idx_t tok11_idx;                /* curr_token slot1 (matches 'lex' slot1_idx) */
	duk_idx_t tok12_idx;                /* curr_token slot2 (matches 'lex' slot2_idx) */
	duk_idx_t tok21_idx;                /* prev_token slot1 */
	duk_idx_t tok22_idx;                /* prev_token slot2 */

	/* recursion limit */
	duk_int_t recursion_depth;
	duk_int_t recursion_limit;

	/* code emission temporary */
	duk_int_t emit_jumpslot_pc;

	/* current function being compiled (embedded instead of pointer for more compact access) */
	duk_compiler_func curr_func;
};

/*
 *  Prototypes
 */

#define DUK_JS_COMPILE_FLAG_EVAL      (1 << 0)  /* source is eval code (not global) */
#define DUK_JS_COMPILE_FLAG_STRICT    (1 << 1)  /* strict outer context */
#define DUK_JS_COMPILE_FLAG_FUNCEXPR  (1 << 2)  /* source is a function expression (used for Function constructor) */

DUK_INTERNAL_DECL void duk_js_compile(duk_hthread *thr, const duk_uint8_t *src_buffer, duk_size_t src_length, duk_small_uint_t flags);

#endif  /* DUK_JS_COMPILER_H_INCLUDED */
#line 1 "duk_regexp.h"
/*
 *  Regular expression structs, constants, and bytecode defines.
 */

#ifndef DUK_REGEXP_H_INCLUDED
#define DUK_REGEXP_H_INCLUDED

/* maximum bytecode copies for {n,m} quantifiers */
#define DUK_RE_MAX_ATOM_COPIES             1000

/* regexp compilation limits */
#define DUK_RE_COMPILE_TOKEN_LIMIT         100000000L   /* 1e8 */

/* regexp execution limits */
#define DUK_RE_EXECUTE_STEPS_LIMIT         1000000000L  /* 1e9 */

/* regexp opcodes */
#define DUK_REOP_MATCH                     1
#define DUK_REOP_CHAR                      2
#define DUK_REOP_PERIOD                    3
#define DUK_REOP_RANGES                    4
#define DUK_REOP_INVRANGES                 5
#define DUK_REOP_JUMP                      6
#define DUK_REOP_SPLIT1                    7
#define DUK_REOP_SPLIT2                    8
#define DUK_REOP_SQMINIMAL                 9
#define DUK_REOP_SQGREEDY                  10
#define DUK_REOP_SAVE                      11
#define DUK_REOP_WIPERANGE                 12
#define DUK_REOP_LOOKPOS                   13
#define DUK_REOP_LOOKNEG                   14
#define DUK_REOP_BACKREFERENCE             15
#define DUK_REOP_ASSERT_START              16
#define DUK_REOP_ASSERT_END                17
#define DUK_REOP_ASSERT_WORD_BOUNDARY      18
#define DUK_REOP_ASSERT_NOT_WORD_BOUNDARY  19

/* flags */
#define DUK_RE_FLAG_GLOBAL                 (1 << 0)
#define DUK_RE_FLAG_IGNORE_CASE            (1 << 1)
#define DUK_RE_FLAG_MULTILINE              (1 << 2)

struct duk_re_matcher_ctx {
	duk_hthread *thr;

	duk_uint32_t re_flags;
	const duk_uint8_t *input;
	const duk_uint8_t *input_end;
	const duk_uint8_t *bytecode;
	const duk_uint8_t *bytecode_end;
	const duk_uint8_t **saved;  /* allocated from valstack (fixed buffer) */
	duk_uint32_t nsaved;
	duk_uint32_t recursion_depth;
	duk_uint32_t recursion_limit;
	duk_uint32_t steps_count;
	duk_uint32_t steps_limit;
};

struct duk_re_compiler_ctx {
	duk_hthread *thr;

	duk_uint32_t re_flags;
	duk_lexer_ctx lex;
	duk_re_token curr_token;
	duk_bufwriter_ctx bw;
	duk_uint32_t captures;  /* highest capture number emitted so far (used as: ++captures) */
	duk_uint32_t highest_backref;
	duk_uint32_t recursion_depth;
	duk_uint32_t recursion_limit;
	duk_uint32_t nranges;  /* internal temporary value, used for char classes */
};

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL void duk_regexp_compile(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_regexp_create_instance(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_regexp_match(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_regexp_match_force_global(duk_hthread *thr);  /* hacky helper for String.prototype.split() */

#endif  /* DUK_REGEXP_H_INCLUDED */
#line 1 "duk_tval.h"
/*
 *  Tagged type definition (duk_tval) and accessor macros.
 *
 *  Access all fields through the accessor macros, as the representation
 *  is quite tricky.
 *
 *  There are two packed type alternatives: an 8-byte representation
 *  based on an IEEE double (preferred for compactness), and a 12-byte
 *  representation (portability).  The latter is needed also in e.g.
 *  64-bit environments (it usually pads to 16 bytes per value).
 *
 *  Selecting the tagged type format involves many trade-offs (memory
 *  use, size and performance of generated code, portability, etc),
 *  see doc/types.rst for a detailed discussion (especially of how the
 *  IEEE double format is used to pack tagged values).
 *
 *  NB: because macro arguments are often expressions, macros should
 *  avoid evaluating their argument more than once.
 */

#ifndef DUK_TVAL_H_INCLUDED
#define DUK_TVAL_H_INCLUDED

/* sanity */
#if !defined(DUK_USE_DOUBLE_LE) && !defined(DUK_USE_DOUBLE_ME) && !defined(DUK_USE_DOUBLE_BE)
#error unsupported: cannot determine byte order variant
#endif

#ifdef DUK_USE_PACKED_TVAL
/* ======================================================================== */

/*
 *  Packed 8-byte representation
 */

/* use duk_double_union as duk_tval directly */
typedef union duk_double_union duk_tval;

/* tags */
#define DUK_TAG_NORMALIZED_NAN    0x7ff8UL   /* the NaN variant we use */
/* avoid tag 0xfff0, no risk of confusion with negative infinity */
#if defined(DUK_USE_FASTINT)
#define DUK_TAG_FASTINT           0xfff1UL   /* embed: integer value */
#endif
#define DUK_TAG_UNUSED            0xfff2UL   /* marker; not actual tagged value */
#define DUK_TAG_UNDEFINED         0xfff3UL   /* embed: nothing */
#define DUK_TAG_NULL              0xfff4UL   /* embed: nothing */
#define DUK_TAG_BOOLEAN           0xfff5UL   /* embed: 0 or 1 (false or true) */
/* DUK_TAG_NUMBER would logically go here, but it has multiple 'tags' */
#define DUK_TAG_POINTER           0xfff6UL   /* embed: void ptr */
#define DUK_TAG_LIGHTFUNC         0xfff7UL   /* embed: func ptr */
#define DUK_TAG_STRING            0xfff8UL   /* embed: duk_hstring ptr */
#define DUK_TAG_OBJECT            0xfff9UL   /* embed: duk_hobject ptr */
#define DUK_TAG_BUFFER            0xfffaUL   /* embed: duk_hbuffer ptr */

/* for convenience */
#define DUK_XTAG_BOOLEAN_FALSE    0xfff50000UL
#define DUK_XTAG_BOOLEAN_TRUE     0xfff50001UL

/* two casts to avoid gcc warning: "warning: cast from pointer to integer of different size [-Wpointer-to-int-cast]" */
#ifdef DUK_USE_64BIT_OPS
#ifdef DUK_USE_DOUBLE_ME
#define DUK__TVAL_SET_TAGGEDPOINTER(v,h,tag)  do { \
		(v)->ull[DUK_DBL_IDX_ULL0] = (((duk_uint64_t) (tag)) << 16) | (((duk_uint64_t) (duk_uint32_t) (h)) << 32); \
	} while (0)
#else
#define DUK__TVAL_SET_TAGGEDPOINTER(v,h,tag)  do { \
		(v)->ull[DUK_DBL_IDX_ULL0] = (((duk_uint64_t) (tag)) << 48) | ((duk_uint64_t) (duk_uint32_t) (h)); \
	} while (0)
#endif
#else  /* DUK_USE_64BIT_OPS */
#define DUK__TVAL_SET_TAGGEDPOINTER(v,h,tag)  do { \
		(v)->ui[DUK_DBL_IDX_UI0] = ((duk_uint32_t) (tag)) << 16; \
		(v)->ui[DUK_DBL_IDX_UI1] = (duk_uint32_t) (h); \
	} while (0)
#endif  /* DUK_USE_64BIT_OPS */

#ifdef DUK_USE_64BIT_OPS
/* Double casting for pointer to avoid gcc warning (cast from pointer to integer of different size) */
#ifdef DUK_USE_DOUBLE_ME
#define DUK__TVAL_SET_LIGHTFUNC(v,fp,flags)  do { \
		(v)->ull[DUK_DBL_IDX_ULL0] = (((duk_uint64_t) DUK_TAG_LIGHTFUNC) << 16) | \
		                             ((duk_uint64_t) (flags)) | \
		                             (((duk_uint64_t) (duk_uint32_t) (fp)) << 32); \
	} while (0)
#else
#define DUK__TVAL_SET_LIGHTFUNC(v,fp,flags)  do { \
		(v)->ull[DUK_DBL_IDX_ULL0] = (((duk_uint64_t) DUK_TAG_LIGHTFUNC) << 48) | \
		                             (((duk_uint64_t) (flags)) << 32) | \
		                             ((duk_uint64_t) (duk_uint32_t) (fp)); \
	} while (0)
#endif
#else  /* DUK_USE_64BIT_OPS */
#define DUK__TVAL_SET_LIGHTFUNC(v,fp,flags)  do { \
		(v)->ui[DUK_DBL_IDX_UI0] = (((duk_uint32_t) DUK_TAG_LIGHTFUNC) << 16) | ((duk_uint32_t) (flags)); \
		(v)->ui[DUK_DBL_IDX_UI1] = (duk_uint32_t) (fp); \
	} while (0)
#endif  /* DUK_USE_64BIT_OPS */

#if defined(DUK_USE_FASTINT)
/* Note: masking is done for 'i' to deal with negative numbers correctly */
#ifdef DUK_USE_DOUBLE_ME
#define DUK__TVAL_SET_FASTINT(v,i)  do { \
		(v)->ui[DUK_DBL_IDX_UI0] = ((duk_uint32_t) DUK_TAG_FASTINT) << 16 | (((duk_uint32_t) ((i) >> 32)) & 0x0000ffffUL); \
		(v)->ui[DUK_DBL_IDX_UI1] = (duk_uint32_t) (i); \
	} while (0)
#define DUK__TVAL_SET_FASTINT_U32(v,i)  do { \
		(v)->ui[DUK_DBL_IDX_UI0] = ((duk_uint32_t) DUK_TAG_FASTINT) << 16; \
		(v)->ui[DUK_DBL_IDX_UI1] = (duk_uint32_t) (i); \
	} while (0)
#else
#define DUK__TVAL_SET_FASTINT(v,i)  do { \
		(v)->ull[DUK_DBL_IDX_ULL0] = (((duk_uint64_t) DUK_TAG_FASTINT) << 48) | (((duk_uint64_t) (i)) & 0x0000ffffffffffffULL); \
	} while (0)
#define DUK__TVAL_SET_FASTINT_U32(v,i)  do { \
		(v)->ull[DUK_DBL_IDX_ULL0] = (((duk_uint64_t) DUK_TAG_FASTINT) << 48) | (duk_uint64_t) (i); \
	} while (0)
#endif

#define DUK__TVAL_SET_FASTINT_I32(v,i)  do { \
		duk_int64_t duk__tmp = (duk_int64_t) (i); \
		DUK_TVAL_SET_FASTINT((v), duk__tmp); \
	} while (0)

/* XXX: clumsy sign extend and masking of 16 topmost bits */
#ifdef DUK_USE_DOUBLE_ME
#define DUK__TVAL_GET_FASTINT(v)      (((duk_int64_t) ((((duk_uint64_t) (v)->ui[DUK_DBL_IDX_UI0]) << 32) | ((duk_uint64_t) (v)->ui[DUK_DBL_IDX_UI1]))) << 16 >> 16)
#else
#define DUK__TVAL_GET_FASTINT(v)      ((((duk_int64_t) (v)->ull[DUK_DBL_IDX_ULL0]) << 16) >> 16)
#endif
#define DUK__TVAL_GET_FASTINT_U32(v)  ((v)->ui[DUK_DBL_IDX_UI1])
#define DUK__TVAL_GET_FASTINT_I32(v)  ((duk_int32_t) (v)->ui[DUK_DBL_IDX_UI1])
#endif  /* DUK_USE_FASTINT */

#define DUK_TVAL_SET_UNDEFINED(v)  do { \
		(v)->us[DUK_DBL_IDX_US0] = (duk_uint16_t) DUK_TAG_UNDEFINED; \
	} while (0)
#define DUK_TVAL_SET_UNUSED(v)  do { \
		(v)->us[DUK_DBL_IDX_US0] = (duk_uint16_t) DUK_TAG_UNUSED; \
	} while (0)
#define DUK_TVAL_SET_NULL(v)  do { \
		(v)->us[DUK_DBL_IDX_US0] = (duk_uint16_t) DUK_TAG_NULL; \
	} while (0)

#define DUK_TVAL_SET_BOOLEAN(v,val)         DUK_DBLUNION_SET_HIGH32((v), (((duk_uint32_t) DUK_TAG_BOOLEAN) << 16) | ((duk_uint32_t) (val)))

#define DUK_TVAL_SET_NAN(v)                 DUK_DBLUNION_SET_NAN_FULL((v))

/* Assumes that caller has normalized NaNs, otherwise trouble ahead. */
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_SET_DOUBLE(v,d)  do { \
		duk_double_t duk__dblval; \
		duk__dblval = (d); \
		DUK_ASSERT_DOUBLE_IS_NORMALIZED(duk__dblval); \
		DUK_DBLUNION_SET_DOUBLE((v), duk__dblval); \
	} while (0)
#define DUK_TVAL_SET_FASTINT(v,i)           DUK__TVAL_SET_FASTINT((v), (i))
#define DUK_TVAL_SET_FASTINT_I32(v,i)       DUK__TVAL_SET_FASTINT_I32((v), (i))
#define DUK_TVAL_SET_FASTINT_U32(v,i)       DUK__TVAL_SET_FASTINT_U32((v), (i))
#define DUK_TVAL_SET_NUMBER_CHKFAST(v,d)    duk_tval_set_number_chkfast((v), (d))
#define DUK_TVAL_SET_NUMBER(v,d)            DUK_TVAL_SET_DOUBLE((v), (d))
#define DUK_TVAL_CHKFAST_INPLACE(v)  do { \
		duk_tval *duk__tv; \
		duk_double_t duk__d; \
		duk__tv = (v); \
		if (DUK_TVAL_IS_DOUBLE(duk__tv)) { \
			duk__d = DUK_TVAL_GET_DOUBLE(duk__tv); \
			DUK_TVAL_SET_NUMBER_CHKFAST(duk__tv, duk__d); \
		} \
	} while (0)
#else
#define DUK_TVAL_SET_DOUBLE(v,d)  do { \
		duk_double_t duk__dblval; \
		duk__dblval = (d); \
		DUK_ASSERT_DOUBLE_IS_NORMALIZED(duk__dblval); \
		DUK_DBLUNION_SET_DOUBLE((v), duk__dblval); \
	} while (0)
#define DUK_TVAL_SET_NUMBER_CHKFAST(v,d)    DUK_TVAL_SET_DOUBLE((v), (d))
#define DUK_TVAL_SET_NUMBER(v,d)            DUK_TVAL_SET_DOUBLE((v), (d))
#define DUK_TVAL_CHKFAST_INPLACE(v)  do { } while (0)
#endif

#define DUK_TVAL_SET_LIGHTFUNC(v,fp,flags)  DUK__TVAL_SET_LIGHTFUNC((v), (fp), (flags))
#define DUK_TVAL_SET_STRING(v,h)            DUK__TVAL_SET_TAGGEDPOINTER((v), (h), DUK_TAG_STRING)
#define DUK_TVAL_SET_OBJECT(v,h)            DUK__TVAL_SET_TAGGEDPOINTER((v), (h), DUK_TAG_OBJECT)
#define DUK_TVAL_SET_BUFFER(v,h)            DUK__TVAL_SET_TAGGEDPOINTER((v), (h), DUK_TAG_BUFFER)
#define DUK_TVAL_SET_POINTER(v,p)           DUK__TVAL_SET_TAGGEDPOINTER((v), (p), DUK_TAG_POINTER)

#define DUK_TVAL_SET_TVAL(v,x)              do { *(v) = *(x); } while (0)

/* getters */
#define DUK_TVAL_GET_BOOLEAN(v)             ((int) (v)->us[DUK_DBL_IDX_US1])
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_GET_DOUBLE(v)              ((v)->d)
#define DUK_TVAL_GET_FASTINT(v)             DUK__TVAL_GET_FASTINT((v))
#define DUK_TVAL_GET_FASTINT_U32(v)         DUK__TVAL_GET_FASTINT_U32((v))
#define DUK_TVAL_GET_FASTINT_I32(v)         DUK__TVAL_GET_FASTINT_I32((v))
#define DUK_TVAL_GET_NUMBER(v)              duk_tval_get_number_packed((v))
#else
#define DUK_TVAL_GET_NUMBER(v)              ((v)->d)
#define DUK_TVAL_GET_DOUBLE(v)              ((v)->d)
#endif
#define DUK_TVAL_GET_LIGHTFUNC(v,out_fp,out_flags)  do { \
		(out_flags) = (v)->ui[DUK_DBL_IDX_UI0] & 0xffffUL; \
		(out_fp) = (duk_c_function) (v)->ui[DUK_DBL_IDX_UI1]; \
	} while (0)
#define DUK_TVAL_GET_LIGHTFUNC_FUNCPTR(v)   ((duk_c_function) ((v)->ui[DUK_DBL_IDX_UI1]))
#define DUK_TVAL_GET_LIGHTFUNC_FLAGS(v)     (((int) (v)->ui[DUK_DBL_IDX_UI0]) & 0xffffUL)
#define DUK_TVAL_GET_STRING(v)              ((duk_hstring *) (v)->vp[DUK_DBL_IDX_VP1])
#define DUK_TVAL_GET_OBJECT(v)              ((duk_hobject *) (v)->vp[DUK_DBL_IDX_VP1])
#define DUK_TVAL_GET_BUFFER(v)              ((duk_hbuffer *) (v)->vp[DUK_DBL_IDX_VP1])
#define DUK_TVAL_GET_POINTER(v)             ((void *) (v)->vp[DUK_DBL_IDX_VP1])
#define DUK_TVAL_GET_HEAPHDR(v)             ((duk_heaphdr *) (v)->vp[DUK_DBL_IDX_VP1])

/* decoding */
#define DUK_TVAL_GET_TAG(v)                 ((duk_small_uint_t) (v)->us[DUK_DBL_IDX_US0])

#define DUK_TVAL_IS_UNDEFINED(v)            (DUK_TVAL_GET_TAG((v)) == DUK_TAG_UNDEFINED)
#define DUK_TVAL_IS_UNUSED(v)               (DUK_TVAL_GET_TAG((v)) == DUK_TAG_UNUSED)
#define DUK_TVAL_IS_NULL(v)                 (DUK_TVAL_GET_TAG((v)) == DUK_TAG_NULL)
#define DUK_TVAL_IS_BOOLEAN(v)              (DUK_TVAL_GET_TAG((v)) == DUK_TAG_BOOLEAN)
#define DUK_TVAL_IS_BOOLEAN_TRUE(v)         ((v)->ui[DUK_DBL_IDX_UI0] == DUK_XTAG_BOOLEAN_TRUE)
#define DUK_TVAL_IS_BOOLEAN_FALSE(v)        ((v)->ui[DUK_DBL_IDX_UI0] == DUK_XTAG_BOOLEAN_FALSE)
#define DUK_TVAL_IS_LIGHTFUNC(v)            (DUK_TVAL_GET_TAG((v)) == DUK_TAG_LIGHTFUNC)
#define DUK_TVAL_IS_STRING(v)               (DUK_TVAL_GET_TAG((v)) == DUK_TAG_STRING)
#define DUK_TVAL_IS_OBJECT(v)               (DUK_TVAL_GET_TAG((v)) == DUK_TAG_OBJECT)
#define DUK_TVAL_IS_BUFFER(v)               (DUK_TVAL_GET_TAG((v)) == DUK_TAG_BUFFER)
#define DUK_TVAL_IS_POINTER(v)              (DUK_TVAL_GET_TAG((v)) == DUK_TAG_POINTER)
#if defined(DUK_USE_FASTINT)
/* 0xfff0 is -Infinity */
#define DUK_TVAL_IS_DOUBLE(v)               (DUK_TVAL_GET_TAG((v)) <= 0xfff0UL)
#define DUK_TVAL_IS_FASTINT(v)              (DUK_TVAL_GET_TAG((v)) == DUK_TAG_FASTINT)
#define DUK_TVAL_IS_NUMBER(v)               (DUK_TVAL_GET_TAG((v)) <= 0xfff1UL)
#else
#define DUK_TVAL_IS_NUMBER(v)               (DUK_TVAL_GET_TAG((v)) <= 0xfff0UL)
#define DUK_TVAL_IS_DOUBLE(v)               DUK_TVAL_IS_NUMBER((v))
#endif

/* This is performance critical because it appears in every DECREF. */
#define DUK_TVAL_IS_HEAP_ALLOCATED(v)       (DUK_TVAL_GET_TAG((v)) >= DUK_TAG_STRING)

#if defined(DUK_USE_FASTINT)
DUK_INTERNAL_DECL duk_double_t duk_tval_get_number_packed(duk_tval *tv);
#endif

#else  /* DUK_USE_PACKED_TVAL */
/* ======================================================================== */

/*
 *  Portable 12-byte representation
 */

/* Note: not initializing all bytes is normally not an issue: Duktape won't
 * read or use the uninitialized bytes so valgrind won't issue warnings.
 * In some special cases a harmless valgrind warning may be issued though.
 * For example, the DumpHeap debugger command writes out a compiled function's
 * 'data' area as is, including any uninitialized bytes, which causes a
 * valgrind warning.
 */

typedef struct duk_tval_struct duk_tval;

struct duk_tval_struct {
	duk_small_uint_t t;
	duk_small_uint_t v_extra;
	union {
		duk_double_t d;
		duk_small_int_t i;
#if defined(DUK_USE_FASTINT)
		duk_int64_t fi;  /* if present, forces 16-byte duk_tval */
#endif
		void *voidptr;
		duk_hstring *hstring;
		duk_hobject *hobject;
		duk_hcompiledfunction *hcompiledfunction;
		duk_hnativefunction *hnativefunction;
		duk_hthread *hthread;
		duk_hbuffer *hbuffer;
		duk_heaphdr *heaphdr;
		duk_c_function lightfunc;
	} v;
};

#define DUK__TAG_NUMBER               0  /* not exposed */
#if defined(DUK_USE_FASTINT)
#define DUK_TAG_FASTINT               1
#endif
#define DUK_TAG_UNDEFINED             2
#define DUK_TAG_NULL                  3
#define DUK_TAG_BOOLEAN               4
#define DUK_TAG_POINTER               5
#define DUK_TAG_LIGHTFUNC             6
#define DUK_TAG_UNUSED                7  /* marker; not actual tagged type */
#define DUK_TAG_STRING                8  /* first heap allocated, match bit boundary */
#define DUK_TAG_OBJECT                9
#define DUK_TAG_BUFFER                10

/* DUK__TAG_NUMBER is intentionally first, as it is the default clause in code
 * to support the 8-byte representation.  Further, it is a non-heap-allocated
 * type so it should come before DUK_TAG_STRING.  Finally, it should not break
 * the tag value ranges covered by case-clauses in a switch-case.
 */

/* setters */
#define DUK_TVAL_SET_UNDEFINED(tv)  do { \
		(tv)->t = DUK_TAG_UNDEFINED; \
	} while (0)

#define DUK_TVAL_SET_UNUSED(tv)  do { \
		(tv)->t = DUK_TAG_UNUSED; \
	} while (0)

#define DUK_TVAL_SET_NULL(tv)  do { \
		(tv)->t = DUK_TAG_NULL; \
	} while (0)

#define DUK_TVAL_SET_BOOLEAN(tv,val)  do { \
		(tv)->t = DUK_TAG_BOOLEAN; \
		(tv)->v.i = (val); \
	} while (0)

#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_SET_DOUBLE(tv,val)  do { \
		(tv)->t = DUK__TAG_NUMBER; \
		(tv)->v.d = (val); \
	} while (0)
#define DUK_TVAL_SET_FASTINT(tv,val)  do { \
		(tv)->t = DUK_TAG_FASTINT; \
		(tv)->v.fi = (val); \
	} while (0)
#define DUK_TVAL_SET_FASTINT_U32(tv,val)  do { \
		(tv)->t = DUK_TAG_FASTINT; \
		(tv)->v.fi = (duk_int64_t) (val); \
	} while (0)
#define DUK_TVAL_SET_FASTINT_I32(tv,val)  do { \
		(tv)->t = DUK_TAG_FASTINT; \
		(tv)->v.fi = (duk_int64_t) (val); \
	} while (0)
#define DUK_TVAL_SET_NUMBER_CHKFAST(tv,d) \
	duk_tval_set_number_chkfast((tv), (d))
#define DUK_TVAL_SET_NUMBER(tv,val) \
	DUK_TVAL_SET_DOUBLE((tv), (val))
#define DUK_TVAL_CHKFAST_INPLACE(v)  do { \
		duk_tval *duk__tv; \
		duk_double_t duk__d; \
		duk__tv = (v); \
		if (DUK_TVAL_IS_DOUBLE(duk__tv)) { \
			duk__d = DUK_TVAL_GET_DOUBLE(duk__tv); \
			DUK_TVAL_SET_NUMBER_CHKFAST(duk__tv, duk__d); \
		} \
	} while (0)
#else
#define DUK_TVAL_SET_NUMBER(tv,val)  do { \
		(tv)->t = DUK__TAG_NUMBER; \
		(tv)->v.d = (val); \
	} while (0)
#define DUK_TVAL_SET_NUMBER_CHKFAST(tv,d) \
	DUK_TVAL_SET_NUMBER((tv), (d))
#define DUK_TVAL_SET_DOUBLE(v,d) \
	DUK_TVAL_SET_NUMBER((tv), (d))
#define DUK_TVAL_CHKFAST_INPLACE(v)  do { } while (0)
#endif  /* DUK_USE_FASTINT */

#define DUK_TVAL_SET_POINTER(tv,hptr)  do { \
		(tv)->t = DUK_TAG_POINTER; \
		(tv)->v.voidptr = (hptr); \
	} while (0)

#define DUK_TVAL_SET_LIGHTFUNC(tv,fp,flags)  do { \
		(tv)->t = DUK_TAG_LIGHTFUNC; \
		(tv)->v_extra = (flags); \
		(tv)->v.lightfunc = (duk_c_function) (fp); \
	} while (0)

#define DUK_TVAL_SET_STRING(tv,hptr)  do { \
		(tv)->t = DUK_TAG_STRING; \
		(tv)->v.hstring = (hptr); \
	} while (0)

#define DUK_TVAL_SET_OBJECT(tv,hptr)  do { \
		(tv)->t = DUK_TAG_OBJECT; \
		(tv)->v.hobject = (hptr); \
	} while (0)

#define DUK_TVAL_SET_BUFFER(tv,hptr)  do { \
		(tv)->t = DUK_TAG_BUFFER; \
		(tv)->v.hbuffer = (hptr); \
	} while (0)

#define DUK_TVAL_SET_NAN(tv)  do { \
		/* in non-packed representation we don't care about which NaN is used */ \
		(tv)->t = DUK__TAG_NUMBER; \
		(tv)->v.d = DUK_DOUBLE_NAN; \
	} while (0)

#define DUK_TVAL_SET_TVAL(v,x)             do { *(v) = *(x); } while (0)

/* getters */
#define DUK_TVAL_GET_BOOLEAN(tv)           ((tv)->v.i)
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_GET_DOUBLE(tv)            ((tv)->v.d)
#define DUK_TVAL_GET_FASTINT(tv)           ((tv)->v.fi)
#define DUK_TVAL_GET_FASTINT_U32(tv)       ((duk_uint32_t) ((tv)->v.fi))
#define DUK_TVAL_GET_FASTINT_I32(tv)       ((duk_int32_t) ((tv)->v.fi))
#if 0
#define DUK_TVAL_GET_NUMBER(tv)            (DUK_TVAL_IS_FASTINT((tv)) ? \
                                               (duk_double_t) DUK_TVAL_GET_FASTINT((tv)) : \
                                               DUK_TVAL_GET_DOUBLE((tv)))
#define DUK_TVAL_GET_NUMBER(tv)            duk_tval_get_number_unpacked((tv))
#else
/* This seems reasonable overall. */
#define DUK_TVAL_GET_NUMBER(tv)            (DUK_TVAL_IS_FASTINT((tv)) ? \
                                               duk_tval_get_number_unpacked_fastint((tv)) : \
                                               DUK_TVAL_GET_DOUBLE((tv)))
#endif
#else
#define DUK_TVAL_GET_NUMBER(tv)            ((tv)->v.d)
#define DUK_TVAL_GET_DOUBLE(tv)            ((tv)->v.d)
#endif  /* DUK_USE_FASTINT */
#define DUK_TVAL_GET_POINTER(tv)           ((tv)->v.voidptr)
#define DUK_TVAL_GET_LIGHTFUNC(tv,out_fp,out_flags)  do { \
		(out_flags) = (duk_uint32_t) (tv)->v_extra; \
		(out_fp) = (tv)->v.lightfunc; \
	} while (0)
#define DUK_TVAL_GET_LIGHTFUNC_FUNCPTR(tv) ((tv)->v.lightfunc)
#define DUK_TVAL_GET_LIGHTFUNC_FLAGS(tv)   ((duk_uint32_t) ((tv)->v_extra))
#define DUK_TVAL_GET_STRING(tv)            ((tv)->v.hstring)
#define DUK_TVAL_GET_OBJECT(tv)            ((tv)->v.hobject)
#define DUK_TVAL_GET_BUFFER(tv)            ((tv)->v.hbuffer)
#define DUK_TVAL_GET_HEAPHDR(tv)           ((tv)->v.heaphdr)

/* decoding */
#define DUK_TVAL_GET_TAG(tv)               ((tv)->t)
#define DUK_TVAL_IS_UNDEFINED(tv)          ((tv)->t == DUK_TAG_UNDEFINED)
#define DUK_TVAL_IS_UNUSED(tv)             ((tv)->t == DUK_TAG_UNUSED)
#define DUK_TVAL_IS_NULL(tv)               ((tv)->t == DUK_TAG_NULL)
#define DUK_TVAL_IS_BOOLEAN(tv)            ((tv)->t == DUK_TAG_BOOLEAN)
#define DUK_TVAL_IS_BOOLEAN_TRUE(tv)       (((tv)->t == DUK_TAG_BOOLEAN) && ((tv)->v.i != 0))
#define DUK_TVAL_IS_BOOLEAN_FALSE(tv)      (((tv)->t == DUK_TAG_BOOLEAN) && ((tv)->v.i == 0))
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_IS_DOUBLE(tv)             ((tv)->t == DUK__TAG_NUMBER)
#define DUK_TVAL_IS_FASTINT(tv)            ((tv)->t == DUK_TAG_FASTINT)
#define DUK_TVAL_IS_NUMBER(tv)             ((tv)->t == DUK__TAG_NUMBER || \
                                            (tv)->t == DUK_TAG_FASTINT)
#else
#define DUK_TVAL_IS_NUMBER(tv)             ((tv)->t == DUK__TAG_NUMBER)
#define DUK_TVAL_IS_DOUBLE(v)              DUK_TVAL_IS_NUMBER((v))
#endif  /* DUK_USE_FASTINT */
#define DUK_TVAL_IS_POINTER(tv)            ((tv)->t == DUK_TAG_POINTER)
#define DUK_TVAL_IS_LIGHTFUNC(tv)          ((tv)->t == DUK_TAG_LIGHTFUNC)
#define DUK_TVAL_IS_STRING(tv)             ((tv)->t == DUK_TAG_STRING)
#define DUK_TVAL_IS_OBJECT(tv)             ((tv)->t == DUK_TAG_OBJECT)
#define DUK_TVAL_IS_BUFFER(tv)             ((tv)->t == DUK_TAG_BUFFER)

/* This is performance critical because it's needed for every DECREF.
 * Take advantage of the fact that the first heap allocated tag is 8,
 * so that bit 3 is set for all heap allocated tags (and never set for
 * non-heap-allocated tags).
 */
#if 0
#define DUK_TVAL_IS_HEAP_ALLOCATED(tv)     ((tv)->t >= DUK_TAG_STRING)
#endif
#define DUK_TVAL_IS_HEAP_ALLOCATED(tv)     ((tv)->t & 0x08)

#if defined(DUK_USE_FASTINT)
#if 0
DUK_INTERNAL_DECL duk_double_t duk_tval_get_number_unpacked(duk_tval *tv);
#endif
DUK_INTERNAL_DECL duk_double_t duk_tval_get_number_unpacked_fastint(duk_tval *tv);
#endif

#endif  /* DUK_USE_PACKED_TVAL */

/*
 *  Convenience (independent of representation)
 */

#define DUK_TVAL_SET_BOOLEAN_TRUE(v)        DUK_TVAL_SET_BOOLEAN(v, 1)
#define DUK_TVAL_SET_BOOLEAN_FALSE(v)       DUK_TVAL_SET_BOOLEAN(v, 0)

/* Lightfunc flags packing and unpacking. */
/* Sign extend: 0x0000##00 -> 0x##000000 -> sign extend to 0xssssss## */
#define DUK_LFUNC_FLAGS_GET_MAGIC(lf_flags) \
	((((duk_int32_t) (lf_flags)) << 16) >> 24)
#define DUK_LFUNC_FLAGS_GET_LENGTH(lf_flags) \
	(((lf_flags) >> 4) & 0x0f)
#define DUK_LFUNC_FLAGS_GET_NARGS(lf_flags) \
	((lf_flags) & 0x0f)
#define DUK_LFUNC_FLAGS_PACK(magic,length,nargs) \
	(((magic) & 0xff) << 8) | ((length) << 4) | (nargs)

#define DUK_LFUNC_NARGS_VARARGS             0x0f   /* varargs marker */
#define DUK_LFUNC_NARGS_MIN                 0x00
#define DUK_LFUNC_NARGS_MAX                 0x0e   /* max, excl. varargs marker */
#define DUK_LFUNC_LENGTH_MIN                0x00
#define DUK_LFUNC_LENGTH_MAX                0x0f
#define DUK_LFUNC_MAGIC_MIN                 (-0x80)
#define DUK_LFUNC_MAGIC_MAX                 0x7f

/* fastint constants etc */
#if defined(DUK_USE_FASTINT)
#define DUK_FASTINT_MIN           (-0x800000000000LL)
#define DUK_FASTINT_MAX           0x7fffffffffffLL
#define DUK_FASTINT_BITS          48

DUK_INTERNAL_DECL void duk_tval_set_number_chkfast(duk_tval *tv, duk_double_t x);
#endif

#endif  /* DUK_TVAL_H_INCLUDED */
#line 1 "duk_heaphdr.h"
/*
 *  Heap header definition and assorted macros, including ref counting.
 *  Access all fields through the accessor macros.
 */

#ifndef DUK_HEAPHDR_H_INCLUDED
#define DUK_HEAPHDR_H_INCLUDED

/*
 *  Common heap header
 *
 *  All heap objects share the same flags and refcount fields.  Objects other
 *  than strings also need to have a single or double linked list pointers
 *  for insertion into the "heap allocated" list.  Strings are held in the
 *  heap-wide string table so they don't need link pointers.
 *
 *  Technically, 'h_refcount' must be wide enough to guarantee that it cannot
 *  wrap (otherwise objects might be freed incorrectly after wrapping).  This
 *  means essentially that the refcount field must be as wide as data pointers.
 *  On 64-bit platforms this means that the refcount needs to be 64 bits even
 *  if an 'int' is 32 bits.  This is a bit unfortunate, and compromising on
 *  this might be reasonable in the future.
 *
 *  Heap header size on 32-bit platforms: 8 bytes without reference counting,
 *  16 bytes with reference counting.
 */

struct duk_heaphdr {
	duk_uint32_t h_flags;

#if defined(DUK_USE_REFERENCE_COUNTING)
#if defined(DUK_USE_REFCOUNT16)
	duk_uint16_t h_refcount16;
#else
	duk_size_t h_refcount;
#endif
#endif

#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t h_next16;
#else
	duk_heaphdr *h_next;
#endif

#if defined(DUK_USE_DOUBLE_LINKED_HEAP)
	/* refcounting requires direct heap frees, which in turn requires a dual linked heap */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t h_prev16;
#else
	duk_heaphdr *h_prev;
#endif
#endif

	/* When DUK_USE_HEAPPTR16 (and DUK_USE_REFCOUNT16) is in use, the
	 * struct won't align nicely to 4 bytes.  This 16-bit extra field
	 * is added to make the alignment clean; the field can be used by
	 * heap objects when 16-bit packing is used.  This field is now
	 * conditional to DUK_USE_HEAPPTR16 only, but it is intended to be
	 * used with DUK_USE_REFCOUNT16 and DUK_USE_DOUBLE_LINKED_HEAP;
	 * this only matter to low memory environments anyway.
	 */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t h_extra16;
#endif
};

struct duk_heaphdr_string {
	/* 16 bits would be enough for shared heaphdr flags and duk_hstring
	 * flags.  The initial parts of duk_heaphdr_string and duk_heaphdr
	 * must match so changing the flags field size here would be quite
	 * awkward.  However, to minimize struct size, we can pack at least
	 * 16 bits of duk_hstring data into the flags field.
	 */
	duk_uint32_t h_flags;

#if defined(DUK_USE_REFERENCE_COUNTING)
#if defined(DUK_USE_REFCOUNT16)
	duk_uint16_t h_refcount16;
#else
	duk_size_t h_refcount;
#endif
#endif
};

#define DUK_HEAPHDR_FLAGS_TYPE_MASK      0x00000003UL
#define DUK_HEAPHDR_FLAGS_FLAG_MASK      (~DUK_HEAPHDR_FLAGS_TYPE_MASK)

                                             /* 2 bits for heap type */
#define DUK_HEAPHDR_FLAGS_HEAP_START     2   /* 4 heap flags */
#define DUK_HEAPHDR_FLAGS_USER_START     6   /* 26 user flags */

#define DUK_HEAPHDR_HEAP_FLAG_NUMBER(n)  (DUK_HEAPHDR_FLAGS_HEAP_START + (n))
#define DUK_HEAPHDR_USER_FLAG_NUMBER(n)  (DUK_HEAPHDR_FLAGS_USER_START + (n))
#define DUK_HEAPHDR_HEAP_FLAG(n)         (1UL << (DUK_HEAPHDR_FLAGS_HEAP_START + (n)))
#define DUK_HEAPHDR_USER_FLAG(n)         (1UL << (DUK_HEAPHDR_FLAGS_USER_START + (n)))

#define DUK_HEAPHDR_FLAG_REACHABLE       DUK_HEAPHDR_HEAP_FLAG(0)  /* mark-and-sweep: reachable */
#define DUK_HEAPHDR_FLAG_TEMPROOT        DUK_HEAPHDR_HEAP_FLAG(1)  /* mark-and-sweep: children not processed */
#define DUK_HEAPHDR_FLAG_FINALIZABLE     DUK_HEAPHDR_HEAP_FLAG(2)  /* mark-and-sweep: finalizable (on current pass) */
#define DUK_HEAPHDR_FLAG_FINALIZED       DUK_HEAPHDR_HEAP_FLAG(3)  /* mark-and-sweep: finalized (on previous pass) */

#define DUK_HTYPE_MIN                    1
#define DUK_HTYPE_STRING                 1
#define DUK_HTYPE_OBJECT                 2
#define DUK_HTYPE_BUFFER                 3
#define DUK_HTYPE_MAX                    3

#if defined(DUK_USE_HEAPPTR16)
#define DUK_HEAPHDR_GET_NEXT(heap,h) \
	((duk_heaphdr *) DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, (h)->h_next16))
#define DUK_HEAPHDR_SET_NEXT(heap,h,val)   do { \
		(h)->h_next16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) val); \
	} while (0)
#else
#define DUK_HEAPHDR_GET_NEXT(heap,h)  ((h)->h_next)
#define DUK_HEAPHDR_SET_NEXT(heap,h,val)   do { \
		(h)->h_next = (val); \
	} while (0)
#endif

#if defined(DUK_USE_DOUBLE_LINKED_HEAP)
#if defined(DUK_USE_HEAPPTR16)
#define DUK_HEAPHDR_GET_PREV(heap,h) \
	((duk_heaphdr *) DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, (h)->h_prev16))
#define DUK_HEAPHDR_SET_PREV(heap,h,val)   do { \
		(h)->h_prev16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) (val)); \
	} while (0)
#else
#define DUK_HEAPHDR_GET_PREV(heap,h)       ((h)->h_prev)
#define DUK_HEAPHDR_SET_PREV(heap,h,val)   do { \
		(h)->h_prev = (val); \
	} while (0)
#endif
#endif

#if defined(DUK_USE_REFERENCE_COUNTING)
#if defined(DUK_USE_REFCOUNT16)
#define DUK_HEAPHDR_GET_REFCOUNT(h)   ((h)->h_refcount16)
#define DUK_HEAPHDR_SET_REFCOUNT(h,val)  do { \
		(h)->h_refcount16 = (val); \
	} while (0)
#define DUK_HEAPHDR_PREINC_REFCOUNT(h)  (++(h)->h_refcount16)  /* result: updated refcount */
#define DUK_HEAPHDR_PREDEC_REFCOUNT(h)  (--(h)->h_refcount16)  /* result: updated refcount */
#else
#define DUK_HEAPHDR_GET_REFCOUNT(h)   ((h)->h_refcount)
#define DUK_HEAPHDR_SET_REFCOUNT(h,val)  do { \
		(h)->h_refcount = (val); \
	} while (0)
#define DUK_HEAPHDR_PREINC_REFCOUNT(h)  (++(h)->h_refcount)  /* result: updated refcount */
#define DUK_HEAPHDR_PREDEC_REFCOUNT(h)  (--(h)->h_refcount)  /* result: updated refcount */
#endif
#else
/* refcount macros not defined without refcounting, caller must #ifdef now */
#endif  /* DUK_USE_REFERENCE_COUNTING */

/*
 *  Note: type is treated as a field separate from flags, so some masking is
 *  involved in the macros below.
 */

#define DUK_HEAPHDR_GET_FLAGS_RAW(h)  ((h)->h_flags)

#define DUK_HEAPHDR_GET_FLAGS(h)      ((h)->h_flags & DUK_HEAPHDR_FLAGS_FLAG_MASK)
#define DUK_HEAPHDR_SET_FLAGS(h,val)  do { \
		(h)->h_flags = ((h)->h_flags & ~(DUK_HEAPHDR_FLAGS_FLAG_MASK)) | (val); \
	} while (0)

#define DUK_HEAPHDR_GET_TYPE(h)       ((h)->h_flags & DUK_HEAPHDR_FLAGS_TYPE_MASK)
#define DUK_HEAPHDR_SET_TYPE(h,val)   do { \
		(h)->h_flags = ((h)->h_flags & ~(DUK_HEAPHDR_FLAGS_TYPE_MASK)) | (val); \
	} while (0)

#define DUK_HEAPHDR_HTYPE_VALID(h)    ( \
	DUK_HEAPHDR_GET_TYPE((h)) >= DUK_HTYPE_MIN && \
	DUK_HEAPHDR_GET_TYPE((h)) <= DUK_HTYPE_MAX \
	)

#define DUK_HEAPHDR_SET_TYPE_AND_FLAGS(h,tval,fval)  do { \
		(h)->h_flags = ((tval) & DUK_HEAPHDR_FLAGS_TYPE_MASK) | \
		               ((fval) & DUK_HEAPHDR_FLAGS_FLAG_MASK); \
	} while (0)

#define DUK_HEAPHDR_SET_FLAG_BITS(h,bits)  do { \
		DUK_ASSERT(((bits) & ~(DUK_HEAPHDR_FLAGS_FLAG_MASK)) == 0); \
		(h)->h_flags |= (bits); \
	} while (0)

#define DUK_HEAPHDR_CLEAR_FLAG_BITS(h,bits)  do { \
		DUK_ASSERT(((bits) & ~(DUK_HEAPHDR_FLAGS_FLAG_MASK)) == 0); \
		(h)->h_flags &= ~((bits)); \
	} while (0)

#define DUK_HEAPHDR_CHECK_FLAG_BITS(h,bits)  (((h)->h_flags & (bits)) != 0)

#define DUK_HEAPHDR_SET_REACHABLE(h)      DUK_HEAPHDR_SET_FLAG_BITS((h),DUK_HEAPHDR_FLAG_REACHABLE)
#define DUK_HEAPHDR_CLEAR_REACHABLE(h)    DUK_HEAPHDR_CLEAR_FLAG_BITS((h),DUK_HEAPHDR_FLAG_REACHABLE)
#define DUK_HEAPHDR_HAS_REACHABLE(h)      DUK_HEAPHDR_CHECK_FLAG_BITS((h),DUK_HEAPHDR_FLAG_REACHABLE)

#define DUK_HEAPHDR_SET_TEMPROOT(h)       DUK_HEAPHDR_SET_FLAG_BITS((h),DUK_HEAPHDR_FLAG_TEMPROOT)
#define DUK_HEAPHDR_CLEAR_TEMPROOT(h)     DUK_HEAPHDR_CLEAR_FLAG_BITS((h),DUK_HEAPHDR_FLAG_TEMPROOT)
#define DUK_HEAPHDR_HAS_TEMPROOT(h)       DUK_HEAPHDR_CHECK_FLAG_BITS((h),DUK_HEAPHDR_FLAG_TEMPROOT)

#define DUK_HEAPHDR_SET_FINALIZABLE(h)    DUK_HEAPHDR_SET_FLAG_BITS((h),DUK_HEAPHDR_FLAG_FINALIZABLE)
#define DUK_HEAPHDR_CLEAR_FINALIZABLE(h)  DUK_HEAPHDR_CLEAR_FLAG_BITS((h),DUK_HEAPHDR_FLAG_FINALIZABLE)
#define DUK_HEAPHDR_HAS_FINALIZABLE(h)    DUK_HEAPHDR_CHECK_FLAG_BITS((h),DUK_HEAPHDR_FLAG_FINALIZABLE)

#define DUK_HEAPHDR_SET_FINALIZED(h)      DUK_HEAPHDR_SET_FLAG_BITS((h),DUK_HEAPHDR_FLAG_FINALIZED)
#define DUK_HEAPHDR_CLEAR_FINALIZED(h)    DUK_HEAPHDR_CLEAR_FLAG_BITS((h),DUK_HEAPHDR_FLAG_FINALIZED)
#define DUK_HEAPHDR_HAS_FINALIZED(h)      DUK_HEAPHDR_CHECK_FLAG_BITS((h),DUK_HEAPHDR_FLAG_FINALIZED)

/* get or set a range of flags; m=first bit number, n=number of bits */
#define DUK_HEAPHDR_GET_FLAG_RANGE(h,m,n)  (((h)->h_flags >> (m)) & ((1UL << (n)) - 1UL))

#define DUK_HEAPHDR_SET_FLAG_RANGE(h,m,n,v)  do { \
		(h)->h_flags = \
			((h)->h_flags & (~(((1 << (n)) - 1) << (m)))) \
			| ((v) << (m)); \
	} while (0)

/* init pointer fields to null */
#if defined(DUK_USE_DOUBLE_LINKED_HEAP)
#define DUK_HEAPHDR_INIT_NULLS(h)       do { \
		DUK_HEAPHDR_SET_NEXT((h), (void *) NULL); \
		DUK_HEAPHDR_SET_PREV((h), (void *) NULL); \
	} while (0)
#else
#define DUK_HEAPHDR_INIT_NULLS(h)       do { \
		DUK_HEAPHDR_SET_NEXT((h), (void *) NULL); \
	} while (0)
#endif

#define DUK_HEAPHDR_STRING_INIT_NULLS(h)  /* currently nop */

/*
 *  Reference counting helper macros.  The macros take a thread argument
 *  and must thus always be executed in a specific thread context.  The
 *  thread argument is needed for features like finalization.  Currently
 *  it is not required for INCREF, but it is included just in case.
 *
 *  Note that 'raw' macros such as DUK_HEAPHDR_GET_REFCOUNT() are not
 *  defined without DUK_USE_REFERENCE_COUNTING, so caller must #ifdef
 *  around them.
 */

#if defined(DUK_USE_REFERENCE_COUNTING)

/* Fast variants, inline refcount operations except for refzero handling.
 * Can be used explicitly when speed is always more important than size.
 * For a good compiler and a single file build, these are basically the
 * same as a forced inline.
 */
#define DUK_TVAL_INCREF_FAST(thr,tv) do { \
		duk_tval *duk__tv = (tv); \
		DUK_ASSERT(duk__tv != NULL); \
		if (DUK_TVAL_IS_HEAP_ALLOCATED(duk__tv)) { \
			duk_heaphdr *duk__h = DUK_TVAL_GET_HEAPHDR(duk__tv); \
			DUK_ASSERT(duk__h != NULL); \
			DUK_ASSERT(DUK_HEAPHDR_HTYPE_VALID(duk__h)); \
			DUK_HEAPHDR_PREINC_REFCOUNT(duk__h); \
		} \
	} while (0)
#define DUK_TVAL_DECREF_FAST(thr,tv) do { \
		duk_tval *duk__tv = (tv); \
		DUK_ASSERT(duk__tv != NULL); \
		if (DUK_TVAL_IS_HEAP_ALLOCATED(duk__tv)) { \
			duk_heaphdr *duk__h = DUK_TVAL_GET_HEAPHDR(duk__tv); \
			DUK_ASSERT(duk__h != NULL); \
			DUK_ASSERT(DUK_HEAPHDR_HTYPE_VALID(duk__h)); \
			DUK_ASSERT(DUK_HEAPHDR_GET_REFCOUNT(duk__h) > 0); \
			if (DUK_HEAPHDR_PREDEC_REFCOUNT(duk__h) == 0) { \
				duk_heaphdr_refzero((thr), duk__h); \
			} \
		} \
	} while (0)
#define DUK_HEAPHDR_INCREF_FAST(thr,h) do { \
		duk_heaphdr *duk__h = (duk_heaphdr *) (h); \
		DUK_ASSERT(duk__h != NULL); \
		DUK_ASSERT(DUK_HEAPHDR_HTYPE_VALID(duk__h)); \
		DUK_HEAPHDR_PREINC_REFCOUNT(duk__h); \
	} while (0)
#define DUK_HEAPHDR_DECREF_FAST(thr,h) do { \
		duk_heaphdr *duk__h = (duk_heaphdr *) (h); \
		DUK_ASSERT(duk__h != NULL); \
		DUK_ASSERT(DUK_HEAPHDR_HTYPE_VALID(duk__h)); \
		DUK_ASSERT(DUK_HEAPHDR_GET_REFCOUNT(duk__h) > 0); \
		if (DUK_HEAPHDR_PREDEC_REFCOUNT(duk__h) == 0) { \
			duk_heaphdr_refzero((thr), duk__h); \
		} \
	} while (0)

/* Slow variants, call to a helper to reduce code size.
 * Can be used explicitly when size is always more important than speed.
 */
#define DUK_TVAL_INCREF_SLOW(thr,tv) do { \
		duk_tval_incref((tv)); \
	} while (0)
#define DUK_TVAL_DECREF_SLOW(thr,tv) do { \
		duk_tval_decref((thr), (tv)); \
	} while (0)
#define DUK_HEAPHDR_INCREF_SLOW(thr,h) do { \
		duk_heaphdr_incref((duk_heaphdr *) (h)); \
	} while (0)
#define DUK_HEAPHDR_DECREF_SLOW(thr,h) do { \
		duk_heaphdr_decref((thr), (duk_heaphdr *) (h)); \
	} while (0)

/* Default variants.  Selection depends on speed/size preference.
 * Concretely: with gcc 4.8.1 -Os x64 the difference in final binary
 * is about +1kB for _FAST variants.
 */
#if defined(DUK_USE_FAST_REFCOUNT_DEFAULT)
#define DUK_TVAL_INCREF(thr,tv)                DUK_TVAL_INCREF_FAST((thr),(tv))
#define DUK_TVAL_DECREF(thr,tv)                DUK_TVAL_DECREF_FAST((thr),(tv))
#define DUK_HEAPHDR_INCREF(thr,h)              DUK_HEAPHDR_INCREF_FAST((thr),(h))
#define DUK_HEAPHDR_DECREF(thr,h)              DUK_HEAPHDR_DECREF_FAST((thr),(h))
#else
#define DUK_TVAL_INCREF(thr,tv)                DUK_TVAL_INCREF_SLOW((thr),(tv))
#define DUK_TVAL_DECREF(thr,tv)                DUK_TVAL_DECREF_SLOW((thr),(tv))
#define DUK_HEAPHDR_INCREF(thr,h)              DUK_HEAPHDR_INCREF_SLOW((thr),(h))
#define DUK_HEAPHDR_DECREF(thr,h)              DUK_HEAPHDR_DECREF_SLOW((thr),(h))
#endif

/* Casting convenience. */
#define DUK_HSTRING_INCREF(thr,h)              DUK_HEAPHDR_INCREF((thr),(duk_heaphdr *) (h))
#define DUK_HSTRING_DECREF(thr,h)              DUK_HEAPHDR_DECREF((thr),(duk_heaphdr *) (h))
#define DUK_HOBJECT_INCREF(thr,h)              DUK_HEAPHDR_INCREF((thr),(duk_heaphdr *) (h))
#define DUK_HOBJECT_DECREF(thr,h)              DUK_HEAPHDR_DECREF((thr),(duk_heaphdr *) (h))
#define DUK_HBUFFER_INCREF(thr,h)              DUK_HEAPHDR_INCREF((thr),(duk_heaphdr *) (h))
#define DUK_HBUFFER_DECREF(thr,h)              DUK_HEAPHDR_DECREF((thr),(duk_heaphdr *) (h))
#define DUK_HCOMPILEDFUNCTION_INCREF(thr,h)    DUK_HEAPHDR_INCREF((thr),(duk_heaphdr *) &(h)->obj)
#define DUK_HCOMPILEDFUNCTION_DECREF(thr,h)    DUK_HEAPHDR_DECREF((thr),(duk_heaphdr *) &(h)->obj)
#define DUK_HNATIVEFUNCTION_INCREF(thr,h)      DUK_HEAPHDR_INCREF((thr),(duk_heaphdr *) &(h)->obj)
#define DUK_HNATIVEFUNCTION_DECREF(thr,h)      DUK_HEAPHDR_DECREF((thr),(duk_heaphdr *) &(h)->obj)
#define DUK_HBUFFEROBJECT_INCREF(thr,h)        DUK_HEAPHDR_INCREF((thr),(duk_heaphdr *) &(h)->obj)
#define DUK_HBUFFEROBJECT_DECREF(thr,h)        DUK_HEAPHDR_DECREF((thr),(duk_heaphdr *) &(h)->obj)
#define DUK_HTHREAD_INCREF(thr,h)              DUK_HEAPHDR_INCREF((thr),(duk_heaphdr *) &(h)->obj)
#define DUK_HTHREAD_DECREF(thr,h)              DUK_HEAPHDR_DECREF((thr),(duk_heaphdr *) &(h)->obj)

/* Convenience for some situations; the above macros don't allow NULLs
 * for performance reasons.
 */
#define DUK_HOBJECT_INCREF_ALLOWNULL(thr,h) do { \
		if ((h) != NULL) { \
			DUK_HEAPHDR_INCREF((thr), (duk_heaphdr *) (h)); \
		} \
	} while (0)
#define DUK_HOBJECT_DECREF_ALLOWNULL(thr,h) do { \
		if ((h) != NULL) { \
			DUK_HEAPHDR_DECREF((thr), (duk_heaphdr *) (h)); \
		} \
	} while (0)

/*
 *  Macros to set a duk_tval and update refcount of the target (decref the
 *  old value and incref the new value if necessary).  This is both performance
 *  and footprint critical; any changes made should be measured for size/speed.
 */

#define DUK_TVAL_SET_UNDEFINED_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_UNDEFINED(tv__dst); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_UNUSED_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_UNUSED(tv__dst); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_NULL_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_NULL(tv__dst); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_BOOLEAN_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_BOOLEAN(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_NUMBER_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_NUMBER(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)
#define DUK_TVAL_SET_NUMBER_CHKFAST_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_NUMBER_CHKFAST(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)
#define DUK_TVAL_SET_DOUBLE_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_DOUBLE(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)
#define DUK_TVAL_SET_NAN_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_NAN(tv__dst); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_SET_FASTINT_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_FASTINT(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)
#define DUK_TVAL_SET_FASTINT_I32_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_FASTINT_I32(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)
#define DUK_TVAL_SET_FASTINT_U32_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_FASTINT_U32(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)
#endif  /* DUK_USE_FASTINT */

#define DUK_TVAL_SET_LIGHTFUNC_UPDREF_ALT0(thr,tvptr_dst,lf_v,lf_fp,lf_flags) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_LIGHTFUNC(tv__dst, (lf_v), (lf_fp), (lf_flags)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_STRING_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_STRING(tv__dst, (newval)); \
		DUK_HSTRING_INCREF((thr), (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_OBJECT_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_OBJECT(tv__dst, (newval)); \
		DUK_HOBJECT_INCREF((thr), (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_BUFFER_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_BUFFER(tv__dst, (newval)); \
		DUK_HBUFFER_INCREF((thr), (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

#define DUK_TVAL_SET_POINTER_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; duk_tval tv__tmp; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_POINTER(tv__dst, (newval)); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

/* DUK_TVAL_SET_TVAL_UPDREF() is used a lot in executor, property lookups,
 * etc, so it's very important for performance.  Measure when changing.
 *
 * NOTE: the source and destination duk_tval pointers may be the same, and
 * the macros MUST deal with that correctly.
 */

/* Original idiom used, minimal code size. */
#define DUK_TVAL_SET_TVAL_UPDREF_ALT0(thr,tvptr_dst,tvptr_src) do { \
		duk_tval *tv__dst, *tv__src; duk_tval tv__tmp; \
		tv__dst = (tvptr_dst); tv__src = (tvptr_src); \
		DUK_TVAL_SET_TVAL(&tv__tmp, tv__dst); \
		DUK_TVAL_SET_TVAL(tv__dst, tv__src); \
		DUK_TVAL_INCREF((thr), tv__src); \
		DUK_TVAL_DECREF((thr), &tv__tmp);  /* side effects */ \
	} while (0)

/* Faster alternative: avoid making a temporary copy of tvptr_dst and use
 * fast incref/decref macros.
 */
#define DUK_TVAL_SET_TVAL_UPDREF_ALT1(thr,tvptr_dst,tvptr_src) do { \
		duk_tval *tv__dst, *tv__src; duk_heaphdr *h__obj; \
		tv__dst = (tvptr_dst); tv__src = (tvptr_src); \
		DUK_TVAL_INCREF_FAST((thr), tv__src); \
		if (DUK_TVAL_IS_HEAP_ALLOCATED(tv__dst)) { \
			h__obj = DUK_TVAL_GET_HEAPHDR(tv__dst); \
			DUK_ASSERT(h__obj != NULL); \
			DUK_TVAL_SET_TVAL(tv__dst, tv__src); \
			DUK_HEAPHDR_DECREF_FAST((thr), h__obj);  /* side effects */ \
		} else { \
			DUK_TVAL_SET_TVAL(tv__dst, tv__src); \
		} \
	} while (0)

/* XXX: no optimized variants yet */
#define DUK_TVAL_SET_UNDEFINED_UPDREF         DUK_TVAL_SET_UNDEFINED_UPDREF_ALT0
#define DUK_TVAL_SET_UNUSED_UPDREF            DUK_TVAL_SET_UNUSED_UPDREF_ALT0
#define DUK_TVAL_SET_NULL_UPDREF              DUK_TVAL_SET_NULL_UPDREF_ALT0
#define DUK_TVAL_SET_BOOLEAN_UPDREF           DUK_TVAL_SET_BOOLEAN_UPDREF_ALT0
#define DUK_TVAL_SET_NUMBER_UPDREF            DUK_TVAL_SET_NUMBER_UPDREF_ALT0
#define DUK_TVAL_SET_NUMBER_CHKFAST_UPDREF    DUK_TVAL_SET_NUMBER_CHKFAST_UPDREF_ALT0
#define DUK_TVAL_SET_DOUBLE_UPDREF            DUK_TVAL_SET_DOUBLE_UPDREF_ALT0
#define DUK_TVAL_SET_NAN_UPDREF               DUK_TVAL_SET_NAN_UPDREF_ALT0
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_SET_FASTINT_UPDREF           DUK_TVAL_SET_FASTINT_UPDREF_ALT0
#define DUK_TVAL_SET_FASTINT_I32_UPDREF       DUK_TVAL_SET_FASTINT_I32_UPDREF_ALT0
#define DUK_TVAL_SET_FASTINT_U32_UPDREF       DUK_TVAL_SET_FASTINT_U32_UPDREF_ALT0
#endif  /* DUK_USE_FASTINT */
#define DUK_TVAL_SET_LIGHTFUNC_UPDREF         DUK_TVAL_SET_LIGHTFUNC_UPDREF_ALT0
#define DUK_TVAL_SET_STRING_UPDREF            DUK_TVAL_SET_STRING_UPDREF_ALT0
#define DUK_TVAL_SET_OBJECT_UPDREF            DUK_TVAL_SET_OBJECT_UPDREF_ALT0
#define DUK_TVAL_SET_BUFFER_UPDREF            DUK_TVAL_SET_BUFFER_UPDREF_ALT0
#define DUK_TVAL_SET_POINTER_UPDREF           DUK_TVAL_SET_POINTER_UPDREF_ALT0

#if defined(DUK_USE_FAST_REFCOUNT_DEFAULT)
/* Optimized for speed. */
#define DUK_TVAL_SET_TVAL_UPDREF              DUK_TVAL_SET_TVAL_UPDREF_ALT1
#define DUK_TVAL_SET_TVAL_UPDREF_FAST         DUK_TVAL_SET_TVAL_UPDREF_ALT1
#define DUK_TVAL_SET_TVAL_UPDREF_SLOW         DUK_TVAL_SET_TVAL_UPDREF_ALT0
#else
/* Optimized for size. */
#define DUK_TVAL_SET_TVAL_UPDREF              DUK_TVAL_SET_TVAL_UPDREF_ALT0
#define DUK_TVAL_SET_TVAL_UPDREF_FAST         DUK_TVAL_SET_TVAL_UPDREF_ALT0
#define DUK_TVAL_SET_TVAL_UPDREF_SLOW         DUK_TVAL_SET_TVAL_UPDREF_ALT0
#endif

#else  /* DUK_USE_REFERENCE_COUNTING */

#define DUK_TVAL_INCREF_FAST(thr,v)            do {} while (0) /* nop */
#define DUK_TVAL_DECREF_FAST(thr,v)            do {} while (0) /* nop */
#define DUK_TVAL_INCREF_SLOW(thr,v)            do {} while (0) /* nop */
#define DUK_TVAL_DECREF_SLOW(thr,v)            do {} while (0) /* nop */
#define DUK_TVAL_INCREF(thr,v)                 do {} while (0) /* nop */
#define DUK_TVAL_DECREF(thr,v)                 do {} while (0) /* nop */
#define DUK_HEAPHDR_INCREF_FAST(thr,h)         do {} while (0) /* nop */
#define DUK_HEAPHDR_DECREF_FAST(thr,h)         do {} while (0) /* nop */
#define DUK_HEAPHDR_INCREF_SLOW(thr,h)         do {} while (0) /* nop */
#define DUK_HEAPHDR_DECREF_SLOW(thr,h)         do {} while (0) /* nop */
#define DUK_HEAPHDR_INCREF(thr,h)              do {} while (0) /* nop */
#define DUK_HEAPHDR_DECREF(thr,h)              do {} while (0) /* nop */
#define DUK_HSTRING_INCREF(thr,h)              do {} while (0) /* nop */
#define DUK_HSTRING_DECREF(thr,h)              do {} while (0) /* nop */
#define DUK_HOBJECT_INCREF(thr,h)              do {} while (0) /* nop */
#define DUK_HOBJECT_DECREF(thr,h)              do {} while (0) /* nop */
#define DUK_HBUFFER_INCREF(thr,h)              do {} while (0) /* nop */
#define DUK_HBUFFER_DECREF(thr,h)              do {} while (0) /* nop */
#define DUK_HCOMPILEDFUNCTION_INCREF(thr,h)    do {} while (0) /* nop */
#define DUK_HCOMPILEDFUNCTION_DECREF(thr,h)    do {} while (0) /* nop */
#define DUK_HNATIVEFUNCTION_INCREF(thr,h)      do {} while (0) /* nop */
#define DUK_HNATIVEFUNCTION_DECREF(thr,h)      do {} while (0) /* nop */
#define DUK_HBUFFEROBJECT_INCREF(thr,h)        do {} while (0) /* nop */
#define DUK_HBUFFEROBJECT_DECREF(thr,h)        do {} while (0) /* nop */
#define DUK_HTHREAD_INCREF(thr,h)              do {} while (0) /* nop */
#define DUK_HTHREAD_DECREF(thr,h)              do {} while (0) /* nop */
#define DUK_HOBJECT_INCREF_ALLOWNULL(thr,h)    do {} while (0) /* nop */
#define DUK_HOBJECT_DECREF_ALLOWNULL(thr,h)    do {} while (0) /* nop */

#define DUK_TVAL_SET_UNDEFINED_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_UNDEFINED(tv__dst); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_UNUSED_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_UNUSED(tv__dst); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_NULL_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_NULL(tv__dst); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_BOOLEAN_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_BOOLEAN(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_NUMBER_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_NUMBER(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)
#define DUK_TVAL_SET_NUMBER_CHKFAST_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_NUMBER_CHKFAST(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)
#define DUK_TVAL_SET_DOUBLE_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_DOUBLE(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)
#define DUK_TVAL_SET_NAN_UPDREF_ALT0(thr,tvptr_dst) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_NAN(tv__dst); \
		DUK_UNREF((thr)); \
	} while (0)
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_SET_FASTINT_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_FASTINT(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)
#define DUK_TVAL_SET_FASTINT_I32_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_FASTINT_I32(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)
#define DUK_TVAL_SET_FASTINT_U32_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_FASTINT_U32(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)
#endif  /* DUK_USE_FASTINT */

#define DUK_TVAL_SET_LIGHTFUNC_UPDREF_ALT0(thr,tvptr_dst,lf_v,lf_fp,lf_flags) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_LIGHTFUNC(tv__dst, (lf_v), (lf_fp), (lf_flags)); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_STRING_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_STRING(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_OBJECT_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_OBJECT(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_BUFFER_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_BUFFER(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_POINTER_UPDREF_ALT0(thr,tvptr_dst,newval) do { \
		duk_tval *tv__dst; tv__dst = (tvptr_dst); \
		DUK_TVAL_SET_POINTER(tv__dst, (newval)); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_TVAL_UPDREF_ALT0(thr,tvptr_dst,tvptr_src) do { \
		duk_tval *tv__dst, *tv__src; \
		tv__dst = (tvptr_dst); tv__src = (tvptr_src); \
		DUK_TVAL_SET_TVAL(tv__dst, tv__src); \
		DUK_UNREF((thr)); \
	} while (0)

#define DUK_TVAL_SET_UNDEFINED_UPDREF         DUK_TVAL_SET_UNDEFINED_UPDREF_ALT0
#define DUK_TVAL_SET_UNUSED_UPDREF            DUK_TVAL_SET_UNUSED_UPDREF_ALT0
#define DUK_TVAL_SET_NULL_UPDREF              DUK_TVAL_SET_NULL_UPDREF_ALT0
#define DUK_TVAL_SET_BOOLEAN_UPDREF           DUK_TVAL_SET_BOOLEAN_UPDREF_ALT0
#define DUK_TVAL_SET_NUMBER_UPDREF            DUK_TVAL_SET_NUMBER_UPDREF_ALT0
#define DUK_TVAL_SET_NUMBER_CHKFAST_UPDREF    DUK_TVAL_SET_NUMBER_CHKFAST_UPDREF_ALT0
#define DUK_TVAL_SET_DOUBLE_UPDREF            DUK_TVAL_SET_DOUBLE_UPDREF_ALT0
#define DUK_TVAL_SET_NAN_UPDREF               DUK_TVAL_SET_NAN_UPDREF_ALT0
#if defined(DUK_USE_FASTINT)
#define DUK_TVAL_SET_FASTINT_UPDREF           DUK_TVAL_SET_FASTINT_UPDREF_ALT0
#define DUK_TVAL_SET_FASTINT_I32_UPDREF       DUK_TVAL_SET_FASTINT_I32_UPDREF_ALT0
#define DUK_TVAL_SET_FASTINT_U32_UPDREF       DUK_TVAL_SET_FASTINT_U32_UPDREF_ALT0
#endif  /* DUK_USE_FASTINT */
#define DUK_TVAL_SET_LIGHTFUNC_UPDREF         DUK_TVAL_SET_LIGHTFUNC_UPDREF_ALT0
#define DUK_TVAL_SET_STRING_UPDREF            DUK_TVAL_SET_STRING_UPDREF_ALT0
#define DUK_TVAL_SET_OBJECT_UPDREF            DUK_TVAL_SET_OBJECT_UPDREF_ALT0
#define DUK_TVAL_SET_BUFFER_UPDREF            DUK_TVAL_SET_BUFFER_UPDREF_ALT0
#define DUK_TVAL_SET_POINTER_UPDREF           DUK_TVAL_SET_POINTER_UPDREF_ALT0

#define DUK_TVAL_SET_TVAL_UPDREF              DUK_TVAL_SET_TVAL_UPDREF_ALT0
#define DUK_TVAL_SET_TVAL_UPDREF_FAST         DUK_TVAL_SET_TVAL_UPDREF_ALT0
#define DUK_TVAL_SET_TVAL_UPDREF_SLOW         DUK_TVAL_SET_TVAL_UPDREF_ALT0

#endif  /* DUK_USE_REFERENCE_COUNTING */

#endif  /* DUK_HEAPHDR_H_INCLUDED */
#line 1 "duk_api_internal.h"
/*
 *  Internal API calls which have (stack and other) semantics similar
 *  to the public API.
 */

#ifndef DUK_API_INTERNAL_H_INCLUDED
#define DUK_API_INTERNAL_H_INCLUDED

/* duk_push_sprintf constants */
#define DUK_PUSH_SPRINTF_INITIAL_SIZE  256L
#define DUK_PUSH_SPRINTF_SANITY_LIMIT  (1L * 1024L * 1024L * 1024L)

/* Flag ORed to err_code to indicate __FILE__ / __LINE__ is not
 * blamed as source of error for error fileName / lineNumber.
 */
#define DUK_ERRCODE_FLAG_NOBLAME_FILELINE  (1L << 24)

/* Valstack resize flags */
#define DUK_VSRESIZE_FLAG_SHRINK           (1 << 0)
#define DUK_VSRESIZE_FLAG_COMPACT          (1 << 1)
#define DUK_VSRESIZE_FLAG_THROW            (1 << 2)

/* Current convention is to use duk_size_t for value stack sizes and global indices,
 * and duk_idx_t for local frame indices.
 */
DUK_INTERNAL_DECL
duk_bool_t duk_valstack_resize_raw(duk_context *ctx,
                                   duk_size_t min_new_size,
                                   duk_small_uint_t flags);

#if defined(DUK_USE_VERBOSE_ERRORS) && defined(DUK_USE_PARANOID_ERRORS)
DUK_INTERNAL_DECL const char *duk_get_type_name(duk_context *ctx, duk_idx_t index);
#endif

DUK_INTERNAL_DECL duk_tval *duk_get_tval(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_tval *duk_require_tval(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL void duk_push_tval(duk_context *ctx, duk_tval *tv);

/* Push the current 'this' binding; throw TypeError if binding is not object
 * coercible (CheckObjectCoercible).
 */
DUK_INTERNAL_DECL void duk_push_this_check_object_coercible(duk_context *ctx);

/* duk_push_this() + CheckObjectCoercible() + duk_to_object() */
DUK_INTERNAL_DECL duk_hobject *duk_push_this_coercible_to_object(duk_context *ctx);

/* duk_push_this() + CheckObjectCoercible() + duk_to_string() */
DUK_INTERNAL_DECL duk_hstring *duk_push_this_coercible_to_string(duk_context *ctx);

/* Get a borrowed duk_tval pointer to the current 'this' binding.  Caller must
 * make sure there's an active callstack entry.  Note that the returned pointer
 * is unstable with regards to side effects.
 */
DUK_INTERNAL_DECL duk_tval *duk_get_borrowed_this_tval(duk_context *ctx);

/* XXX: add fastint support? */
#define duk_push_u64(ctx,val) \
	duk_push_number((ctx), (duk_double_t) (val))
#define duk_push_i64(ctx,val) \
	duk_push_number((ctx), (duk_double_t) (val))

/* duk_push_(u)int() is guaranteed to support at least (un)signed 32-bit range */
#define duk_push_u32(ctx,val) \
	duk_push_uint((ctx), (duk_uint_t) (val))
#define duk_push_i32(ctx,val) \
	duk_push_int((ctx), (duk_int_t) (val))

/* sometimes stack and array indices need to go on the stack */
#define duk_push_idx(ctx,val) \
	duk_push_int((ctx), (duk_int_t) (val))
#define duk_push_uarridx(ctx,val) \
	duk_push_uint((ctx), (duk_uint_t) (val))
#define duk_push_size_t(ctx,val) \
	duk_push_uint((ctx), (duk_uint_t) (val))  /* XXX: assumed to fit for now */

DUK_INTERNAL_DECL duk_hstring *duk_get_hstring(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hobject *duk_get_hobject(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hbuffer *duk_get_hbuffer(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hthread *duk_get_hthread(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hcompiledfunction *duk_get_hcompiledfunction(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hnativefunction *duk_get_hnativefunction(duk_context *ctx, duk_idx_t index);

DUK_INTERNAL_DECL duk_hobject *duk_get_hobject_with_class(duk_context *ctx, duk_idx_t index, duk_small_uint_t classnum);

#if 0  /* This would be pointless: unexpected type and lightfunc would both return NULL */
DUK_INTERNAL_DECL duk_hobject *duk_get_hobject_or_lfunc(duk_context *ctx, duk_idx_t index);
#endif
DUK_INTERNAL_DECL duk_hobject *duk_get_hobject_or_lfunc_coerce(duk_context *ctx, duk_idx_t index);

#if 0  /*unused*/
DUK_INTERNAL_DECL void *duk_get_voidptr(duk_context *ctx, duk_idx_t index);
#endif

DUK_INTERNAL_DECL duk_hstring *duk_to_hstring(duk_context *ctx, duk_idx_t index);
#if defined(DUK_USE_DEBUGGER_SUPPORT)  /* only needed by debugger for now */
DUK_INTERNAL_DECL duk_hstring *duk_safe_to_hstring(duk_context *ctx, duk_idx_t index);
#endif
DUK_INTERNAL_DECL void duk_to_object_class_string_top(duk_context *ctx);
#if !defined(DUK_USE_PARANOID_ERRORS)
DUK_INTERNAL_DECL void duk_push_hobject_class_string(duk_context *ctx, duk_hobject *h);
#endif

DUK_INTERNAL_DECL duk_int_t duk_to_int_clamped_raw(duk_context *ctx, duk_idx_t index, duk_int_t minval, duk_int_t maxval, duk_bool_t *out_clamped);  /* out_clamped=NULL, RangeError if outside range */
DUK_INTERNAL_DECL duk_int_t duk_to_int_clamped(duk_context *ctx, duk_idx_t index, duk_int_t minval, duk_int_t maxval);
DUK_INTERNAL_DECL duk_int_t duk_to_int_check_range(duk_context *ctx, duk_idx_t index, duk_int_t minval, duk_int_t maxval);
#if defined(DUK_USE_BUFFEROBJECT_SUPPORT)
DUK_INTERNAL_DECL duk_uint8_t duk_to_uint8clamped(duk_context *ctx, duk_idx_t index);
#endif

DUK_INTERNAL_DECL duk_hstring *duk_require_hstring(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hobject *duk_require_hobject(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hbuffer *duk_require_hbuffer(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hthread *duk_require_hthread(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hcompiledfunction *duk_require_hcompiledfunction(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hnativefunction *duk_require_hnativefunction(duk_context *ctx, duk_idx_t index);

DUK_INTERNAL_DECL duk_hobject *duk_require_hobject_with_class(duk_context *ctx, duk_idx_t index, duk_small_uint_t classnum);

DUK_INTERNAL_DECL duk_hobject *duk_require_hobject_or_lfunc(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL duk_hobject *duk_require_hobject_or_lfunc_coerce(duk_context *ctx, duk_idx_t index);

DUK_INTERNAL_DECL void duk_push_hstring(duk_context *ctx, duk_hstring *h);
DUK_INTERNAL_DECL void duk_push_hstring_stridx(duk_context *ctx, duk_small_int_t stridx);
DUK_INTERNAL_DECL void duk_push_hobject(duk_context *ctx, duk_hobject *h);
DUK_INTERNAL_DECL void duk_push_hbuffer(duk_context *ctx, duk_hbuffer *h);
#define duk_push_hthread(ctx,h) \
	duk_push_hobject((ctx), (duk_hobject *) (h))
#define duk_push_hcompiledfunction(ctx,h) \
	duk_push_hobject((ctx), (duk_hobject *) (h))
#define duk_push_hnativefunction(ctx,h) \
	duk_push_hobject((ctx), (duk_hobject *) (h))
DUK_INTERNAL_DECL void duk_push_hobject_bidx(duk_context *ctx, duk_small_int_t builtin_idx);
DUK_INTERNAL_DECL duk_idx_t duk_push_object_helper(duk_context *ctx, duk_uint_t hobject_flags_and_class, duk_small_int_t prototype_bidx);
DUK_INTERNAL_DECL duk_idx_t duk_push_object_helper_proto(duk_context *ctx, duk_uint_t hobject_flags_and_class, duk_hobject *proto);
DUK_INTERNAL_DECL duk_idx_t duk_push_object_internal(duk_context *ctx);
DUK_INTERNAL_DECL duk_idx_t duk_push_compiledfunction(duk_context *ctx);
DUK_INTERNAL_DECL void duk_push_c_function_noexotic(duk_context *ctx, duk_c_function func, duk_int_t nargs);
DUK_INTERNAL_DECL void duk_push_c_function_noconstruct_noexotic(duk_context *ctx, duk_c_function func, duk_int_t nargs);

DUK_INTERNAL_DECL void duk_push_string_funcptr(duk_context *ctx, duk_uint8_t *ptr, duk_size_t sz);
DUK_INTERNAL_DECL void duk_push_lightfunc_name(duk_context *ctx, duk_tval *tv);
DUK_INTERNAL_DECL void duk_push_lightfunc_tostring(duk_context *ctx, duk_tval *tv);
DUK_INTERNAL_DECL duk_hbufferobject *duk_push_bufferobject_raw(duk_context *ctx, duk_uint_t hobject_flags_and_class, duk_small_int_t prototype_bidx);

#if !defined(DUK_USE_PARANOID_ERRORS)
DUK_INTERNAL_DECL const char *duk_push_string_readable(duk_context *ctx, duk_idx_t index);
DUK_INTERNAL_DECL const char *duk_push_string_tval_readable(duk_context *ctx, duk_tval *tv);
#endif

DUK_INTERNAL_DECL duk_bool_t duk_get_prop_stridx(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx);     /* [] -> [val] */
DUK_INTERNAL_DECL duk_bool_t duk_put_prop_stridx(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx);     /* [val] -> [] */
DUK_INTERNAL_DECL duk_bool_t duk_del_prop_stridx(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx);     /* [] -> [] */
DUK_INTERNAL_DECL duk_bool_t duk_has_prop_stridx(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx);     /* [] -> [] */

DUK_INTERNAL_DECL duk_bool_t duk_get_prop_stridx_boolean(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx, duk_bool_t *out_has_prop);  /* [] -> [] */

DUK_INTERNAL_DECL void duk_xdef_prop(duk_context *ctx, duk_idx_t obj_index, duk_small_uint_t desc_flags);  /* [key val] -> [] */
DUK_INTERNAL_DECL void duk_xdef_prop_index(duk_context *ctx, duk_idx_t obj_index, duk_uarridx_t arr_index, duk_small_uint_t desc_flags);  /* [val] -> [] */
DUK_INTERNAL_DECL void duk_xdef_prop_stridx(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx, duk_small_uint_t desc_flags);  /* [val] -> [] */
DUK_INTERNAL_DECL void duk_xdef_prop_stridx_builtin(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx, duk_small_int_t builtin_idx, duk_small_uint_t desc_flags);  /* [] -> [] */
DUK_INTERNAL_DECL void duk_xdef_prop_stridx_thrower(duk_context *ctx, duk_idx_t obj_index, duk_small_int_t stridx, duk_small_uint_t desc_flags);  /* [] -> [] */

/* These are macros for now, but could be separate functions to reduce code
 * footprint (check call site count before refactoring).
 */
#define duk_xdef_prop_wec(ctx,obj_index) \
	duk_xdef_prop((ctx), (obj_index), DUK_PROPDESC_FLAGS_WEC)
#define duk_xdef_prop_index_wec(ctx,obj_index,arr_index) \
	duk_xdef_prop_index((ctx), (obj_index), (arr_index), DUK_PROPDESC_FLAGS_WEC)
#define duk_xdef_prop_stridx_wec(ctx,obj_index,stridx) \
	duk_xdef_prop_stridx((ctx), (obj_index), (stridx), DUK_PROPDESC_FLAGS_WEC)

/* Set object 'length'. */
DUK_INTERNAL_DECL void duk_set_length(duk_context *ctx, duk_idx_t index, duk_size_t length);

#endif  /* DUK_API_INTERNAL_H_INCLUDED */
#line 1 "duk_hstring.h"
/*
 *  Heap string representation.
 *
 *  Strings are byte sequences ordinarily stored in extended UTF-8 format,
 *  allowing values larger than the official UTF-8 range (used internally)
 *  and also allowing UTF-8 encoding of surrogate pairs (CESU-8 format).
 *  Strings may also be invalid UTF-8 altogether which is the case e.g. with
 *  strings used as internal property names and raw buffers converted to
 *  strings.  In such cases the 'clen' field contains an inaccurate value.
 *
 *  Ecmascript requires support for 32-bit long strings.  However, since each
 *  16-bit codepoint can take 3 bytes in CESU-8, this representation can only
 *  support about 1.4G codepoint long strings in extreme cases.  This is not
 *  really a practical issue.
 */

#ifndef DUK_HSTRING_H_INCLUDED
#define DUK_HSTRING_H_INCLUDED

/* Impose a maximum string length for now.  Restricted artificially to
 * ensure adding a heap header length won't overflow size_t.  The limit
 * should be synchronized with DUK_HBUFFER_MAX_BYTELEN.
 *
 * E5.1 makes provisions to support strings longer than 4G characters.
 * This limit should be eliminated on 64-bit platforms (and increased
 * closer to maximum support on 32-bit platforms).
 */

#if defined(DUK_USE_STRLEN16)
#define DUK_HSTRING_MAX_BYTELEN                     (0x0000ffffUL)
#else
#define DUK_HSTRING_MAX_BYTELEN                     (0x7fffffffUL)
#endif

/* XXX: could add flags for "is valid CESU-8" (Ecmascript compatible strings),
 * "is valid UTF-8", "is valid extended UTF-8" (internal strings are not,
 * regexp bytecode is), and "contains non-BMP characters".  These are not
 * needed right now.
 */

#define DUK_HSTRING_FLAG_ARRIDX                     DUK_HEAPHDR_USER_FLAG(0)  /* string is a valid array index */
#define DUK_HSTRING_FLAG_INTERNAL                   DUK_HEAPHDR_USER_FLAG(1)  /* string is internal */
#define DUK_HSTRING_FLAG_RESERVED_WORD              DUK_HEAPHDR_USER_FLAG(2)  /* string is a reserved word (non-strict) */
#define DUK_HSTRING_FLAG_STRICT_RESERVED_WORD       DUK_HEAPHDR_USER_FLAG(3)  /* string is a reserved word (strict) */
#define DUK_HSTRING_FLAG_EVAL_OR_ARGUMENTS          DUK_HEAPHDR_USER_FLAG(4)  /* string is 'eval' or 'arguments' */
#define DUK_HSTRING_FLAG_EXTDATA                    DUK_HEAPHDR_USER_FLAG(5)  /* string data is external (duk_hstring_external) */

#define DUK_HSTRING_HAS_ARRIDX(x)                   DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_ARRIDX)
#define DUK_HSTRING_HAS_INTERNAL(x)                 DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_INTERNAL)
#define DUK_HSTRING_HAS_RESERVED_WORD(x)            DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_RESERVED_WORD)
#define DUK_HSTRING_HAS_STRICT_RESERVED_WORD(x)     DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_STRICT_RESERVED_WORD)
#define DUK_HSTRING_HAS_EVAL_OR_ARGUMENTS(x)        DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_EVAL_OR_ARGUMENTS)
#define DUK_HSTRING_HAS_EXTDATA(x)                  DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_EXTDATA)

#define DUK_HSTRING_SET_ARRIDX(x)                   DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_ARRIDX)
#define DUK_HSTRING_SET_INTERNAL(x)                 DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_INTERNAL)
#define DUK_HSTRING_SET_RESERVED_WORD(x)            DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_RESERVED_WORD)
#define DUK_HSTRING_SET_STRICT_RESERVED_WORD(x)     DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_STRICT_RESERVED_WORD)
#define DUK_HSTRING_SET_EVAL_OR_ARGUMENTS(x)        DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_EVAL_OR_ARGUMENTS)
#define DUK_HSTRING_SET_EXTDATA(x)                  DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_EXTDATA)

#define DUK_HSTRING_CLEAR_ARRIDX(x)                 DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_ARRIDX)
#define DUK_HSTRING_CLEAR_INTERNAL(x)               DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_INTERNAL)
#define DUK_HSTRING_CLEAR_RESERVED_WORD(x)          DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_RESERVED_WORD)
#define DUK_HSTRING_CLEAR_STRICT_RESERVED_WORD(x)   DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_STRICT_RESERVED_WORD)
#define DUK_HSTRING_CLEAR_EVAL_OR_ARGUMENTS(x)      DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_EVAL_OR_ARGUMENTS)
#define DUK_HSTRING_CLEAR_EXTDATA(x)                DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HSTRING_FLAG_EXTDATA)

#define DUK_HSTRING_IS_ASCII(x)                     (DUK_HSTRING_GET_BYTELEN((x)) == DUK_HSTRING_GET_CHARLEN((x)))
#define DUK_HSTRING_IS_EMPTY(x)                     (DUK_HSTRING_GET_BYTELEN((x)) == 0)

#if defined(DUK_USE_STRHASH16)
#define DUK_HSTRING_GET_HASH(x)                     ((x)->hdr.h_flags >> 16)
#define DUK_HSTRING_SET_HASH(x,v) do { \
		(x)->hdr.h_flags = ((x)->hdr.h_flags & 0x0000ffffUL) | ((v) << 16); \
	} while (0)
#else
#define DUK_HSTRING_GET_HASH(x)                     ((x)->hash)
#define DUK_HSTRING_SET_HASH(x,v) do { \
		(x)->hash = (v); \
	} while (0)
#endif

#if defined(DUK_USE_STRLEN16)
#define DUK_HSTRING_GET_BYTELEN(x)                  ((x)->blen16)
#define DUK_HSTRING_SET_BYTELEN(x,v) do { \
		(x)->blen16 = (v); \
	} while (0)
#define DUK_HSTRING_GET_CHARLEN(x)                  ((x)->clen16)
#define DUK_HSTRING_SET_CHARLEN(x,v) do { \
		(x)->clen16 = (v); \
	} while (0)
#else
#define DUK_HSTRING_GET_BYTELEN(x)                  ((x)->blen)
#define DUK_HSTRING_SET_BYTELEN(x,v) do { \
		(x)->blen = (v); \
	} while (0)
#define DUK_HSTRING_GET_CHARLEN(x)                  ((x)->clen)
#define DUK_HSTRING_SET_CHARLEN(x,v) do { \
		(x)->clen = (v); \
	} while (0)
#endif

#if defined(DUK_USE_HSTRING_EXTDATA)
#define DUK_HSTRING_GET_EXTDATA(x) \
	((x)->extdata)
#define DUK_HSTRING_GET_DATA(x) \
	(DUK_HSTRING_HAS_EXTDATA((x)) ? \
		DUK_HSTRING_GET_EXTDATA((duk_hstring_external *) (x)) : ((const duk_uint8_t *) ((x) + 1)))
#else
#define DUK_HSTRING_GET_DATA(x) \
	((const duk_uint8_t *) ((x) + 1))
#endif

#define DUK_HSTRING_GET_DATA_END(x) \
	(DUK_HSTRING_GET_DATA((x)) + (x)->blen)

/* marker value; in E5 2^32-1 is not a valid array index (2^32-2 is highest valid) */
#define DUK_HSTRING_NO_ARRAY_INDEX  (0xffffffffUL)

/* get array index related to string (or return DUK_HSTRING_NO_ARRAY_INDEX);
 * avoids helper call if string has no array index value.
 */
#define DUK_HSTRING_GET_ARRIDX_FAST(h)  \
	(DUK_HSTRING_HAS_ARRIDX((h)) ? duk_js_to_arrayindex_string_helper((h)) : DUK_HSTRING_NO_ARRAY_INDEX)

/* slower but more compact variant */
#define DUK_HSTRING_GET_ARRIDX_SLOW(h)  \
	(duk_js_to_arrayindex_string_helper((h)))

/*
 *  Misc
 */

struct duk_hstring {
	/* Smaller heaphdr than for other objects, because strings are held
	 * in string intern table which requires no link pointers.  Much of
	 * the 32-bit flags field is unused by flags, so we can stuff a 16-bit
	 * field in there.
	 */
	duk_heaphdr_string hdr;

	/* Note: we could try to stuff a partial hash (e.g. 16 bits) into the
	 * shared heap header.  Good hashing needs more hash bits though.
	 */

	/* string hash */
#if defined(DUK_USE_STRHASH16)
	/* If 16-bit hash is in use, stuff it into duk_heaphdr_string flags. */
#else
	duk_uint32_t hash;
#endif

	/* length in bytes (not counting NUL term) */
#if defined(DUK_USE_STRLEN16)
	duk_uint16_t blen16;
#else
	duk_uint32_t blen;
#endif

	/* length in codepoints (must be E5 compatible) */
#if defined(DUK_USE_STRLEN16)
	duk_uint16_t clen16;
#else
	duk_uint32_t clen;
#endif

	/*
	 *  String value of 'blen+1' bytes follows (+1 for NUL termination
	 *  convenience for C API).  No alignment needs to be guaranteed
	 *  for strings, but fields above should guarantee alignment-by-4
	 *  (but not alignment-by-8).
	 */
};

/* The external string struct is defined even when the feature is inactive. */
struct duk_hstring_external {
	duk_hstring str;

	/*
	 *  For an external string, the NUL-terminated string data is stored
	 *  externally.  The user must guarantee that data behind this pointer
	 *  doesn't change while it's used.
	 */

	const duk_uint8_t *extdata;
};

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL duk_ucodepoint_t duk_hstring_char_code_at_raw(duk_hthread *thr, duk_hstring *h, duk_uint_t pos);

#endif  /* DUK_HSTRING_H_INCLUDED */
#line 1 "duk_hobject.h"
/*
 *  Heap object representation.
 *
 *  Heap objects are used for Ecmascript objects, arrays, and functions,
 *  but also for internal control like declarative and object environment
 *  records.  Compiled functions, native functions, and threads are also
 *  objects but with an extended C struct.
 *
 *  Objects provide the required Ecmascript semantics and exotic behaviors
 *  especially for property access.
 *
 *  Properties are stored in three conceptual parts:
 *
 *    1. A linear 'entry part' contains ordered key-value-attributes triples
 *       and is the main method of string properties.
 *
 *    2. An optional linear 'array part' is used for array objects to store a
 *       (dense) range of [0,N[ array indexed entries with default attributes
 *       (writable, enumerable, configurable).  If the array part would become
 *       sparse or non-default attributes are required, the array part is
 *       abandoned and moved to the 'entry part'.
 *
 *    3. An optional 'hash part' is used to optimize lookups of the entry
 *       part; it is used only for objects with sufficiently many properties
 *       and can be abandoned without loss of information.
 *
 *  These three conceptual parts are stored in a single memory allocated area.
 *  This minimizes memory allocation overhead but also means that all three
 *  parts are resized together, and makes property access a bit complicated.
 */

#ifndef DUK_HOBJECT_H_INCLUDED
#define DUK_HOBJECT_H_INCLUDED

/* there are currently 26 flag bits available */
#define DUK_HOBJECT_FLAG_EXTENSIBLE            DUK_HEAPHDR_USER_FLAG(0)   /* object is extensible */
#define DUK_HOBJECT_FLAG_CONSTRUCTABLE         DUK_HEAPHDR_USER_FLAG(1)   /* object is constructable */
#define DUK_HOBJECT_FLAG_BOUND                 DUK_HEAPHDR_USER_FLAG(2)   /* object established using Function.prototype.bind() */
#define DUK_HOBJECT_FLAG_COMPILEDFUNCTION      DUK_HEAPHDR_USER_FLAG(4)   /* object is a compiled function (duk_hcompiledfunction) */
#define DUK_HOBJECT_FLAG_NATIVEFUNCTION        DUK_HEAPHDR_USER_FLAG(5)   /* object is a native function (duk_hnativefunction) */
#define DUK_HOBJECT_FLAG_BUFFEROBJECT          DUK_HEAPHDR_USER_FLAG(6)   /* object is a buffer object (duk_hbufferobject) (always exotic) */
#define DUK_HOBJECT_FLAG_THREAD                DUK_HEAPHDR_USER_FLAG(7)   /* object is a thread (duk_hthread) */
#define DUK_HOBJECT_FLAG_ARRAY_PART            DUK_HEAPHDR_USER_FLAG(8)   /* object has an array part (a_size may still be 0) */
#define DUK_HOBJECT_FLAG_STRICT                DUK_HEAPHDR_USER_FLAG(9)   /* function: function object is strict */
#define DUK_HOBJECT_FLAG_NOTAIL                DUK_HEAPHDR_USER_FLAG(10)  /* function: function must not be tail called */
#define DUK_HOBJECT_FLAG_NEWENV                DUK_HEAPHDR_USER_FLAG(11)  /* function: create new environment when called (see duk_hcompiledfunction) */
#define DUK_HOBJECT_FLAG_NAMEBINDING           DUK_HEAPHDR_USER_FLAG(12)  /* function: create binding for func name (function templates only, used for named function expressions) */
#define DUK_HOBJECT_FLAG_CREATEARGS            DUK_HEAPHDR_USER_FLAG(13)  /* function: create an arguments object on function call */
#define DUK_HOBJECT_FLAG_ENVRECCLOSED          DUK_HEAPHDR_USER_FLAG(14)  /* envrec: (declarative) record is closed */
#define DUK_HOBJECT_FLAG_EXOTIC_ARRAY          DUK_HEAPHDR_USER_FLAG(15)  /* 'Array' object, array length and index exotic behavior */
#define DUK_HOBJECT_FLAG_EXOTIC_STRINGOBJ      DUK_HEAPHDR_USER_FLAG(16)  /* 'String' object, array index exotic behavior */
#define DUK_HOBJECT_FLAG_EXOTIC_ARGUMENTS      DUK_HEAPHDR_USER_FLAG(17)  /* 'Arguments' object and has arguments exotic behavior (non-strict callee) */
#define DUK_HOBJECT_FLAG_EXOTIC_DUKFUNC        DUK_HEAPHDR_USER_FLAG(18)  /* Duktape/C (nativefunction) object, exotic 'length' */
#define DUK_HOBJECT_FLAG_EXOTIC_PROXYOBJ       DUK_HEAPHDR_USER_FLAG(19)  /* 'Proxy' object */

#define DUK_HOBJECT_FLAG_CLASS_BASE            DUK_HEAPHDR_USER_FLAG_NUMBER(21)
#define DUK_HOBJECT_FLAG_CLASS_BITS            5

#define DUK_HOBJECT_GET_CLASS_NUMBER(h)        \
	DUK_HEAPHDR_GET_FLAG_RANGE(&(h)->hdr, DUK_HOBJECT_FLAG_CLASS_BASE, DUK_HOBJECT_FLAG_CLASS_BITS)
#define DUK_HOBJECT_SET_CLASS_NUMBER(h,v)      \
	DUK_HEAPHDR_SET_FLAG_RANGE(&(h)->hdr, DUK_HOBJECT_FLAG_CLASS_BASE, DUK_HOBJECT_FLAG_CLASS_BITS, (v))

#define DUK_HOBJECT_GET_CLASS_MASK(h)          \
	(1UL << DUK_HEAPHDR_GET_FLAG_RANGE(&(h)->hdr, DUK_HOBJECT_FLAG_CLASS_BASE, DUK_HOBJECT_FLAG_CLASS_BITS))

/* Macro for creating flag initializer from a class number.
 * Unsigned type cast is needed to avoid warnings about coercing
 * a signed integer to an unsigned one; the largest class values
 * have the highest bit (bit 31) set which causes this.
 */
#define DUK_HOBJECT_CLASS_AS_FLAGS(v)          (((duk_uint_t) (v)) << DUK_HOBJECT_FLAG_CLASS_BASE)

/* E5 Section 8.6.2 + custom classes */
#define DUK_HOBJECT_CLASS_UNUSED               0
#define DUK_HOBJECT_CLASS_ARGUMENTS            1
#define DUK_HOBJECT_CLASS_ARRAY                2
#define DUK_HOBJECT_CLASS_BOOLEAN              3
#define DUK_HOBJECT_CLASS_DATE                 4
#define DUK_HOBJECT_CLASS_ERROR                5
#define DUK_HOBJECT_CLASS_FUNCTION             6
#define DUK_HOBJECT_CLASS_JSON                 7
#define DUK_HOBJECT_CLASS_MATH                 8
#define DUK_HOBJECT_CLASS_NUMBER               9
#define DUK_HOBJECT_CLASS_OBJECT               10
#define DUK_HOBJECT_CLASS_REGEXP               11
#define DUK_HOBJECT_CLASS_STRING               12
#define DUK_HOBJECT_CLASS_GLOBAL               13
#define DUK_HOBJECT_CLASS_OBJENV               14  /* custom */
#define DUK_HOBJECT_CLASS_DECENV               15  /* custom */
#define DUK_HOBJECT_CLASS_BUFFER               16  /* custom; implies DUK_HOBJECT_IS_BUFFEROBJECT */
#define DUK_HOBJECT_CLASS_POINTER              17  /* custom */
#define DUK_HOBJECT_CLASS_THREAD               18  /* custom; implies DUK_HOBJECT_IS_THREAD */
#define DUK_HOBJECT_CLASS_ARRAYBUFFER          19  /* implies DUK_HOBJECT_IS_BUFFEROBJECT */
#define DUK_HOBJECT_CLASS_DATAVIEW             20
#define DUK_HOBJECT_CLASS_INT8ARRAY            21
#define DUK_HOBJECT_CLASS_UINT8ARRAY           22
#define DUK_HOBJECT_CLASS_UINT8CLAMPEDARRAY    23
#define DUK_HOBJECT_CLASS_INT16ARRAY           24
#define DUK_HOBJECT_CLASS_UINT16ARRAY          25
#define DUK_HOBJECT_CLASS_INT32ARRAY           26
#define DUK_HOBJECT_CLASS_UINT32ARRAY          27
#define DUK_HOBJECT_CLASS_FLOAT32ARRAY         28
#define DUK_HOBJECT_CLASS_FLOAT64ARRAY         29
#define DUK_HOBJECT_CLASS_MAX                  29

/* class masks */
#define DUK_HOBJECT_CMASK_ALL                  ((1UL << (DUK_HOBJECT_CLASS_MAX + 1)) - 1UL)
#define DUK_HOBJECT_CMASK_UNUSED               (1UL << DUK_HOBJECT_CLASS_UNUSED)
#define DUK_HOBJECT_CMASK_ARGUMENTS            (1UL << DUK_HOBJECT_CLASS_ARGUMENTS)
#define DUK_HOBJECT_CMASK_ARRAY                (1UL << DUK_HOBJECT_CLASS_ARRAY)
#define DUK_HOBJECT_CMASK_BOOLEAN              (1UL << DUK_HOBJECT_CLASS_BOOLEAN)
#define DUK_HOBJECT_CMASK_DATE                 (1UL << DUK_HOBJECT_CLASS_DATE)
#define DUK_HOBJECT_CMASK_ERROR                (1UL << DUK_HOBJECT_CLASS_ERROR)
#define DUK_HOBJECT_CMASK_FUNCTION             (1UL << DUK_HOBJECT_CLASS_FUNCTION)
#define DUK_HOBJECT_CMASK_JSON                 (1UL << DUK_HOBJECT_CLASS_JSON)
#define DUK_HOBJECT_CMASK_MATH                 (1UL << DUK_HOBJECT_CLASS_MATH)
#define DUK_HOBJECT_CMASK_NUMBER               (1UL << DUK_HOBJECT_CLASS_NUMBER)
#define DUK_HOBJECT_CMASK_OBJECT               (1UL << DUK_HOBJECT_CLASS_OBJECT)
#define DUK_HOBJECT_CMASK_REGEXP               (1UL << DUK_HOBJECT_CLASS_REGEXP)
#define DUK_HOBJECT_CMASK_STRING               (1UL << DUK_HOBJECT_CLASS_STRING)
#define DUK_HOBJECT_CMASK_GLOBAL               (1UL << DUK_HOBJECT_CLASS_GLOBAL)
#define DUK_HOBJECT_CMASK_OBJENV               (1UL << DUK_HOBJECT_CLASS_OBJENV)
#define DUK_HOBJECT_CMASK_DECENV               (1UL << DUK_HOBJECT_CLASS_DECENV)
#define DUK_HOBJECT_CMASK_BUFFER               (1UL << DUK_HOBJECT_CLASS_BUFFER)
#define DUK_HOBJECT_CMASK_POINTER              (1UL << DUK_HOBJECT_CLASS_POINTER)
#define DUK_HOBJECT_CMASK_THREAD               (1UL << DUK_HOBJECT_CLASS_THREAD)
#define DUK_HOBJECT_CMASK_ARRAYBUFFER          (1UL << DUK_HOBJECT_CLASS_ARRAYBUFFER)
#define DUK_HOBJECT_CMASK_DATAVIEW             (1UL << DUK_HOBJECT_CLASS_DATAVIEW)
#define DUK_HOBJECT_CMASK_INT8ARRAY            (1UL << DUK_HOBJECT_CLASS_INT8ARRAY)
#define DUK_HOBJECT_CMASK_UINT8ARRAY           (1UL << DUK_HOBJECT_CLASS_UINT8ARRAY)
#define DUK_HOBJECT_CMASK_UINT8CLAMPEDARRAY    (1UL << DUK_HOBJECT_CLASS_UINT8CLAMPEDARRAY)
#define DUK_HOBJECT_CMASK_INT16ARRAY           (1UL << DUK_HOBJECT_CLASS_INT16ARRAY)
#define DUK_HOBJECT_CMASK_UINT16ARRAY          (1UL << DUK_HOBJECT_CLASS_UINT16ARRAY)
#define DUK_HOBJECT_CMASK_INT32ARRAY           (1UL << DUK_HOBJECT_CLASS_INT32ARRAY)
#define DUK_HOBJECT_CMASK_UINT32ARRAY          (1UL << DUK_HOBJECT_CLASS_UINT32ARRAY)
#define DUK_HOBJECT_CMASK_FLOAT32ARRAY         (1UL << DUK_HOBJECT_CLASS_FLOAT32ARRAY)
#define DUK_HOBJECT_CMASK_FLOAT64ARRAY         (1UL << DUK_HOBJECT_CLASS_FLOAT64ARRAY)

#define DUK_HOBJECT_CMASK_ALL_BUFFEROBJECTS \
	(DUK_HOBJECT_CMASK_BUFFER | \
	 DUK_HOBJECT_CMASK_ARRAYBUFFER | \
	 DUK_HOBJECT_CMASK_DATAVIEW | \
	 DUK_HOBJECT_CMASK_INT8ARRAY | \
	 DUK_HOBJECT_CMASK_UINT8ARRAY | \
	 DUK_HOBJECT_CMASK_UINT8CLAMPEDARRAY | \
	 DUK_HOBJECT_CMASK_INT16ARRAY | \
	 DUK_HOBJECT_CMASK_UINT16ARRAY | \
	 DUK_HOBJECT_CMASK_INT32ARRAY | \
	 DUK_HOBJECT_CMASK_UINT32ARRAY | \
	 DUK_HOBJECT_CMASK_FLOAT32ARRAY | \
	 DUK_HOBJECT_CMASK_FLOAT64ARRAY)

#define DUK_HOBJECT_IS_OBJENV(h)               (DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_OBJENV)
#define DUK_HOBJECT_IS_DECENV(h)               (DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_DECENV)
#define DUK_HOBJECT_IS_ENV(h)                  (DUK_HOBJECT_IS_OBJENV((h)) || DUK_HOBJECT_IS_DECENV((h)))
#define DUK_HOBJECT_IS_ARRAY(h)                (DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_ARRAY)
#define DUK_HOBJECT_IS_COMPILEDFUNCTION(h)     DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_COMPILEDFUNCTION)
#define DUK_HOBJECT_IS_NATIVEFUNCTION(h)       DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NATIVEFUNCTION)
#define DUK_HOBJECT_IS_BUFFEROBJECT(h)         DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_BUFFEROBJECT)
#define DUK_HOBJECT_IS_THREAD(h)               DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_THREAD)

#define DUK_HOBJECT_IS_NONBOUND_FUNCTION(h)    DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, \
                                                        DUK_HOBJECT_FLAG_COMPILEDFUNCTION | \
                                                        DUK_HOBJECT_FLAG_NATIVEFUNCTION)

#define DUK_HOBJECT_IS_FUNCTION(h)             DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, \
                                                        DUK_HOBJECT_FLAG_BOUND | \
                                                        DUK_HOBJECT_FLAG_COMPILEDFUNCTION | \
                                                        DUK_HOBJECT_FLAG_NATIVEFUNCTION)

#define DUK_HOBJECT_IS_CALLABLE(h)             DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, \
                                                        DUK_HOBJECT_FLAG_BOUND | \
                                                        DUK_HOBJECT_FLAG_COMPILEDFUNCTION | \
                                                        DUK_HOBJECT_FLAG_NATIVEFUNCTION)

/* object has any exotic behavior(s) */
#define DUK_HOBJECT_EXOTIC_BEHAVIOR_FLAGS      (DUK_HOBJECT_FLAG_EXOTIC_ARRAY | \
                                                DUK_HOBJECT_FLAG_EXOTIC_ARGUMENTS | \
                                                DUK_HOBJECT_FLAG_EXOTIC_STRINGOBJ | \
                                                DUK_HOBJECT_FLAG_EXOTIC_DUKFUNC | \
                                                DUK_HOBJECT_FLAG_BUFFEROBJECT | \
                                                DUK_HOBJECT_FLAG_EXOTIC_PROXYOBJ)

#define DUK_HOBJECT_HAS_EXOTIC_BEHAVIOR(h)     DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_EXOTIC_BEHAVIOR_FLAGS)

#define DUK_HOBJECT_HAS_EXTENSIBLE(h)          DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXTENSIBLE)
#define DUK_HOBJECT_HAS_CONSTRUCTABLE(h)       DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_CONSTRUCTABLE)
#define DUK_HOBJECT_HAS_BOUND(h)               DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_BOUND)
#define DUK_HOBJECT_HAS_COMPILEDFUNCTION(h)    DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_COMPILEDFUNCTION)
#define DUK_HOBJECT_HAS_NATIVEFUNCTION(h)      DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NATIVEFUNCTION)
#define DUK_HOBJECT_HAS_BUFFEROBJECT(h)        DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_BUFFEROBJECT)
#define DUK_HOBJECT_HAS_THREAD(h)              DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_THREAD)
#define DUK_HOBJECT_HAS_ARRAY_PART(h)          DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_ARRAY_PART)
#define DUK_HOBJECT_HAS_STRICT(h)              DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_STRICT)
#define DUK_HOBJECT_HAS_NOTAIL(h)              DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NOTAIL)
#define DUK_HOBJECT_HAS_NEWENV(h)              DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NEWENV)
#define DUK_HOBJECT_HAS_NAMEBINDING(h)         DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NAMEBINDING)
#define DUK_HOBJECT_HAS_CREATEARGS(h)          DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_CREATEARGS)
#define DUK_HOBJECT_HAS_ENVRECCLOSED(h)        DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_ENVRECCLOSED)
#define DUK_HOBJECT_HAS_EXOTIC_ARRAY(h)        DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_ARRAY)
#define DUK_HOBJECT_HAS_EXOTIC_STRINGOBJ(h)    DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_STRINGOBJ)
#define DUK_HOBJECT_HAS_EXOTIC_ARGUMENTS(h)    DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_ARGUMENTS)
#define DUK_HOBJECT_HAS_EXOTIC_DUKFUNC(h)      DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_DUKFUNC)
#define DUK_HOBJECT_HAS_EXOTIC_PROXYOBJ(h)     DUK_HEAPHDR_CHECK_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_PROXYOBJ)

#define DUK_HOBJECT_SET_EXTENSIBLE(h)          DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXTENSIBLE)
#define DUK_HOBJECT_SET_CONSTRUCTABLE(h)       DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_CONSTRUCTABLE)
#define DUK_HOBJECT_SET_BOUND(h)               DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_BOUND)
#define DUK_HOBJECT_SET_COMPILEDFUNCTION(h)    DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_COMPILEDFUNCTION)
#define DUK_HOBJECT_SET_NATIVEFUNCTION(h)      DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NATIVEFUNCTION)
#define DUK_HOBJECT_SET_BUFFEROBJECT(h)        DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_BUFFEROBJECT)
#define DUK_HOBJECT_SET_THREAD(h)              DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_THREAD)
#define DUK_HOBJECT_SET_ARRAY_PART(h)          DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_ARRAY_PART)
#define DUK_HOBJECT_SET_STRICT(h)              DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_STRICT)
#define DUK_HOBJECT_SET_NOTAIL(h)              DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NOTAIL)
#define DUK_HOBJECT_SET_NEWENV(h)              DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NEWENV)
#define DUK_HOBJECT_SET_NAMEBINDING(h)         DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NAMEBINDING)
#define DUK_HOBJECT_SET_CREATEARGS(h)          DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_CREATEARGS)
#define DUK_HOBJECT_SET_ENVRECCLOSED(h)        DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_ENVRECCLOSED)
#define DUK_HOBJECT_SET_EXOTIC_ARRAY(h)        DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_ARRAY)
#define DUK_HOBJECT_SET_EXOTIC_STRINGOBJ(h)    DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_STRINGOBJ)
#define DUK_HOBJECT_SET_EXOTIC_ARGUMENTS(h)    DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_ARGUMENTS)
#define DUK_HOBJECT_SET_EXOTIC_DUKFUNC(h)      DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_DUKFUNC)
#define DUK_HOBJECT_SET_EXOTIC_PROXYOBJ(h)     DUK_HEAPHDR_SET_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_PROXYOBJ)

#define DUK_HOBJECT_CLEAR_EXTENSIBLE(h)        DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXTENSIBLE)
#define DUK_HOBJECT_CLEAR_CONSTRUCTABLE(h)     DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_CONSTRUCTABLE)
#define DUK_HOBJECT_CLEAR_BOUND(h)             DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_BOUND)
#define DUK_HOBJECT_CLEAR_COMPILEDFUNCTION(h)  DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_COMPILEDFUNCTION)
#define DUK_HOBJECT_CLEAR_NATIVEFUNCTION(h)    DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NATIVEFUNCTION)
#define DUK_HOBJECT_CLEAR_BUFFEROBJECT(h)      DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_BUFFEROBJECT)
#define DUK_HOBJECT_CLEAR_THREAD(h)            DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_THREAD)
#define DUK_HOBJECT_CLEAR_ARRAY_PART(h)        DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_ARRAY_PART)
#define DUK_HOBJECT_CLEAR_STRICT(h)            DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_STRICT)
#define DUK_HOBJECT_CLEAR_NOTAIL(h)            DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NOTAIL)
#define DUK_HOBJECT_CLEAR_NEWENV(h)            DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NEWENV)
#define DUK_HOBJECT_CLEAR_NAMEBINDING(h)       DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_NAMEBINDING)
#define DUK_HOBJECT_CLEAR_CREATEARGS(h)        DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_CREATEARGS)
#define DUK_HOBJECT_CLEAR_ENVRECCLOSED(h)      DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_ENVRECCLOSED)
#define DUK_HOBJECT_CLEAR_EXOTIC_ARRAY(h)      DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_ARRAY)
#define DUK_HOBJECT_CLEAR_EXOTIC_STRINGOBJ(h)  DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_STRINGOBJ)
#define DUK_HOBJECT_CLEAR_EXOTIC_ARGUMENTS(h)  DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_ARGUMENTS)
#define DUK_HOBJECT_CLEAR_EXOTIC_DUKFUNC(h)    DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_DUKFUNC)
#define DUK_HOBJECT_CLEAR_EXOTIC_PROXYOBJ(h)   DUK_HEAPHDR_CLEAR_FLAG_BITS(&(h)->hdr, DUK_HOBJECT_FLAG_EXOTIC_PROXYOBJ)

/* flags used for property attributes in duk_propdesc and packed flags */
#define DUK_PROPDESC_FLAG_WRITABLE              (1 << 0)    /* E5 Section 8.6.1 */
#define DUK_PROPDESC_FLAG_ENUMERABLE            (1 << 1)    /* E5 Section 8.6.1 */
#define DUK_PROPDESC_FLAG_CONFIGURABLE          (1 << 2)    /* E5 Section 8.6.1 */
#define DUK_PROPDESC_FLAG_ACCESSOR              (1 << 3)    /* accessor */
#define DUK_PROPDESC_FLAG_VIRTUAL               (1 << 4)    /* property is virtual: used in duk_propdesc, never stored
                                                             * (used by e.g. buffer virtual properties)
                                                             */
#define DUK_PROPDESC_FLAGS_MASK                 (DUK_PROPDESC_FLAG_WRITABLE | \
                                                 DUK_PROPDESC_FLAG_ENUMERABLE | \
                                                 DUK_PROPDESC_FLAG_CONFIGURABLE | \
                                                 DUK_PROPDESC_FLAG_ACCESSOR)

/* additional flags which are passed in the same flags argument as property
 * flags but are not stored in object properties.
 */
#define DUK_PROPDESC_FLAG_NO_OVERWRITE          (1 << 4)    /* internal define property: skip write silently if exists */

/* convenience */
#define DUK_PROPDESC_FLAGS_NONE                 0
#define DUK_PROPDESC_FLAGS_W                    (DUK_PROPDESC_FLAG_WRITABLE)
#define DUK_PROPDESC_FLAGS_E                    (DUK_PROPDESC_FLAG_ENUMERABLE)
#define DUK_PROPDESC_FLAGS_C                    (DUK_PROPDESC_FLAG_CONFIGURABLE)
#define DUK_PROPDESC_FLAGS_WE                   (DUK_PROPDESC_FLAG_WRITABLE | DUK_PROPDESC_FLAG_ENUMERABLE)
#define DUK_PROPDESC_FLAGS_WC                   (DUK_PROPDESC_FLAG_WRITABLE | DUK_PROPDESC_FLAG_CONFIGURABLE)
#define DUK_PROPDESC_FLAGS_EC                   (DUK_PROPDESC_FLAG_ENUMERABLE | DUK_PROPDESC_FLAG_CONFIGURABLE)
#define DUK_PROPDESC_FLAGS_WEC                  (DUK_PROPDESC_FLAG_WRITABLE | \
                                                 DUK_PROPDESC_FLAG_ENUMERABLE | \
                                                 DUK_PROPDESC_FLAG_CONFIGURABLE)

/*
 *  Macro for object validity check
 *
 *  Assert for currently guaranteed relations between flags, for instance.
 */

#define DUK_ASSERT_HOBJECT_VALID(h) do { \
		DUK_ASSERT((h) != NULL); \
		DUK_ASSERT(!DUK_HOBJECT_IS_CALLABLE((h)) || \
		           DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_FUNCTION); \
		DUK_ASSERT(!DUK_HOBJECT_IS_BUFFEROBJECT((h)) || \
		           (DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_BUFFER || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_ARRAYBUFFER || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_DATAVIEW || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_INT8ARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_UINT8ARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_UINT8CLAMPEDARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_INT16ARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_UINT16ARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_INT32ARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_UINT32ARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_FLOAT32ARRAY || \
		            DUK_HOBJECT_GET_CLASS_NUMBER((h)) == DUK_HOBJECT_CLASS_FLOAT64ARRAY)); \
	} while (0)

/*
 *  Macros to access the 'props' allocation.
 */

#if defined(DUK_USE_HEAPPTR16)
#define DUK_HOBJECT_GET_PROPS(heap,h) \
	((duk_uint8_t *) DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, ((duk_heaphdr *) (h))->h_extra16))
#define DUK_HOBJECT_SET_PROPS(heap,h,x) do { \
		((duk_heaphdr *) (h))->h_extra16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) (x)); \
	} while (0)
#else
#define DUK_HOBJECT_GET_PROPS(heap,h) \
	((h)->props)
#define DUK_HOBJECT_SET_PROPS(heap,h,x) do { \
		(h)->props = (duk_uint8_t *) (x); \
	} while (0)
#endif

#if defined(DUK_USE_HOBJECT_LAYOUT_1)
/* LAYOUT 1 */
#define DUK_HOBJECT_E_GET_KEY_BASE(heap,h) \
	((duk_hstring **) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) \
	))
#define DUK_HOBJECT_E_GET_VALUE_BASE(heap,h) \
	((duk_propvalue *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * sizeof(duk_hstring *) \
	))
#define DUK_HOBJECT_E_GET_FLAGS_BASE(heap,h) \
	((duk_uint8_t *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_hstring *) + sizeof(duk_propvalue)) \
	))
#define DUK_HOBJECT_A_GET_BASE(heap,h) \
	((duk_tval *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_hstring *) + sizeof(duk_propvalue) + sizeof(duk_uint8_t)) \
	))
#define DUK_HOBJECT_H_GET_BASE(heap,h) \
	((duk_uint32_t *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_hstring *) + sizeof(duk_propvalue) + sizeof(duk_uint8_t)) + \
			DUK_HOBJECT_GET_ASIZE((h)) * sizeof(duk_tval) \
	))
#define DUK_HOBJECT_P_COMPUTE_SIZE(n_ent,n_arr,n_hash) \
	( \
		(n_ent) * (sizeof(duk_hstring *) + sizeof(duk_propvalue) + sizeof(duk_uint8_t)) + \
		(n_arr) * sizeof(duk_tval) + \
		(n_hash) * sizeof(duk_uint32_t) \
	)
#define DUK_HOBJECT_P_SET_REALLOC_PTRS(p_base,set_e_k,set_e_pv,set_e_f,set_a,set_h,n_ent,n_arr,n_hash)  do { \
		(set_e_k) = (duk_hstring **) (void *) (p_base); \
		(set_e_pv) = (duk_propvalue *) (void *) ((set_e_k) + (n_ent)); \
		(set_e_f) = (duk_uint8_t *) (void *) ((set_e_pv) + (n_ent)); \
		(set_a) = (duk_tval *) (void *) ((set_e_f) + (n_ent)); \
		(set_h) = (duk_uint32_t *) (void *) ((set_a) + (n_arr)); \
	} while (0)
#elif defined(DUK_USE_HOBJECT_LAYOUT_2)
/* LAYOUT 2 */
#if (DUK_USE_ALIGN_BY == 4)
#define DUK_HOBJECT_E_FLAG_PADDING(e_sz) ((4 - (e_sz)) & 0x03)
#elif (DUK_USE_ALIGN_BY == 8)
#define DUK_HOBJECT_E_FLAG_PADDING(e_sz) ((8 - (e_sz)) & 0x07)
#elif (DUK_USE_ALIGN_BY == 1)
#define DUK_HOBJECT_E_FLAG_PADDING(e_sz) 0
#else
#error invalid DUK_USE_ALIGN_BY
#endif
#define DUK_HOBJECT_E_GET_KEY_BASE(heap,h) \
	((duk_hstring **) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * sizeof(duk_propvalue) \
	))
#define DUK_HOBJECT_E_GET_VALUE_BASE(heap,h) \
	((duk_propvalue *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) \
	))
#define DUK_HOBJECT_E_GET_FLAGS_BASE(heap,h) \
	((duk_uint8_t *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_hstring *) + sizeof(duk_propvalue)) \
	))
#define DUK_HOBJECT_A_GET_BASE(heap,h) \
	((duk_tval *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_hstring *) + sizeof(duk_propvalue) + sizeof(duk_uint8_t)) + \
			DUK_HOBJECT_E_FLAG_PADDING(DUK_HOBJECT_GET_ESIZE((h))) \
	))
#define DUK_HOBJECT_H_GET_BASE(heap,h) \
	((duk_uint32_t *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_hstring *) + sizeof(duk_propvalue) + sizeof(duk_uint8_t)) + \
			DUK_HOBJECT_E_FLAG_PADDING(DUK_HOBJECT_GET_ESIZE((h))) + \
			DUK_HOBJECT_GET_ASIZE((h)) * sizeof(duk_tval) \
	))
#define DUK_HOBJECT_P_COMPUTE_SIZE(n_ent,n_arr,n_hash) \
	( \
		(n_ent) * (sizeof(duk_hstring *) + sizeof(duk_propvalue) + sizeof(duk_uint8_t)) + \
		DUK_HOBJECT_E_FLAG_PADDING((n_ent)) + \
		(n_arr) * sizeof(duk_tval) + \
		(n_hash) * sizeof(duk_uint32_t) \
	)
#define DUK_HOBJECT_P_SET_REALLOC_PTRS(p_base,set_e_k,set_e_pv,set_e_f,set_a,set_h,n_ent,n_arr,n_hash)  do { \
		(set_e_pv) = (duk_propvalue *) (void *) (p_base); \
		(set_e_k) = (duk_hstring **) (void *) ((set_e_pv) + (n_ent)); \
		(set_e_f) = (duk_uint8_t *) (void *) ((set_e_k) + (n_ent)); \
		(set_a) = (duk_tval *) (void *) (((duk_uint8_t *) (set_e_f)) + \
		                                 sizeof(duk_uint8_t) * (n_ent) + \
		                                 DUK_HOBJECT_E_FLAG_PADDING((n_ent))); \
		(set_h) = (duk_uint32_t *) (void *) ((set_a) + (n_arr)); \
	} while (0)
#elif defined(DUK_USE_HOBJECT_LAYOUT_3)
/* LAYOUT 3 */
#define DUK_HOBJECT_E_GET_KEY_BASE(heap,h) \
	((duk_hstring **) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * sizeof(duk_propvalue) + \
			DUK_HOBJECT_GET_ASIZE((h)) * sizeof(duk_tval) \
	))
#define DUK_HOBJECT_E_GET_VALUE_BASE(heap,h) \
	((duk_propvalue *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) \
	))
#define DUK_HOBJECT_E_GET_FLAGS_BASE(heap,h) \
	((duk_uint8_t *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_propvalue) + sizeof(duk_hstring *)) + \
			DUK_HOBJECT_GET_ASIZE((h)) * sizeof(duk_tval) + \
			DUK_HOBJECT_GET_HSIZE((h)) * sizeof(duk_uint32_t) \
	))
#define DUK_HOBJECT_A_GET_BASE(heap,h) \
	((duk_tval *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * sizeof(duk_propvalue) \
	))
#define DUK_HOBJECT_H_GET_BASE(heap,h) \
	((duk_uint32_t *) (void *) ( \
		DUK_HOBJECT_GET_PROPS((heap), (h)) + \
			DUK_HOBJECT_GET_ESIZE((h)) * (sizeof(duk_propvalue) + sizeof(duk_hstring *)) + \
			DUK_HOBJECT_GET_ASIZE((h)) * sizeof(duk_tval) \
	))
#define DUK_HOBJECT_P_COMPUTE_SIZE(n_ent,n_arr,n_hash) \
	( \
		(n_ent) * (sizeof(duk_propvalue) + sizeof(duk_hstring *) + sizeof(duk_uint8_t)) + \
		(n_arr) * sizeof(duk_tval) + \
		(n_hash) * sizeof(duk_uint32_t) \
	)
#define DUK_HOBJECT_P_SET_REALLOC_PTRS(p_base,set_e_k,set_e_pv,set_e_f,set_a,set_h,n_ent,n_arr,n_hash)  do { \
		(set_e_pv) = (duk_propvalue *) (void *) (p_base); \
		(set_a) = (duk_tval *) (void *) ((set_e_pv) + (n_ent)); \
		(set_e_k) = (duk_hstring **) (void *) ((set_a) + (n_arr)); \
		(set_h) = (duk_uint32_t *) (void *) ((set_e_k) + (n_ent)); \
		(set_e_f) = (duk_uint8_t *) (void *) ((set_h) + (n_hash)); \
	} while (0)
#else
#error invalid hobject layout defines
#endif  /* hobject property layout */

#define DUK_HOBJECT_E_ALLOC_SIZE(h) \
	DUK_HOBJECT_P_COMPUTE_SIZE(DUK_HOBJECT_GET_ESIZE((h)), DUK_HOBJECT_GET_ASIZE((h)), DUK_HOBJECT_GET_HSIZE((h)))

#define DUK_HOBJECT_E_GET_KEY(heap,h,i)              (DUK_HOBJECT_E_GET_KEY_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_E_GET_KEY_PTR(heap,h,i)          (&DUK_HOBJECT_E_GET_KEY_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_E_GET_VALUE(heap,h,i)            (DUK_HOBJECT_E_GET_VALUE_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_E_GET_VALUE_PTR(heap,h,i)        (&DUK_HOBJECT_E_GET_VALUE_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_E_GET_VALUE_TVAL(heap,h,i)       (DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).v)
#define DUK_HOBJECT_E_GET_VALUE_TVAL_PTR(heap,h,i)   (&DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).v)
#define DUK_HOBJECT_E_GET_VALUE_GETTER(heap,h,i)     (DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).a.get)
#define DUK_HOBJECT_E_GET_VALUE_GETTER_PTR(heap,h,i) (&DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).a.get)
#define DUK_HOBJECT_E_GET_VALUE_SETTER(heap,h,i)     (DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).a.set)
#define DUK_HOBJECT_E_GET_VALUE_SETTER_PTR(heap,h,i) (&DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).a.set)
#define DUK_HOBJECT_E_GET_FLAGS(heap,h,i)            (DUK_HOBJECT_E_GET_FLAGS_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_E_GET_FLAGS_PTR(heap,h,i)        (&DUK_HOBJECT_E_GET_FLAGS_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_A_GET_VALUE(heap,h,i)            (DUK_HOBJECT_A_GET_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_A_GET_VALUE_PTR(heap,h,i)        (&DUK_HOBJECT_A_GET_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_H_GET_INDEX(heap,h,i)            (DUK_HOBJECT_H_GET_BASE((heap), (h))[(i)])
#define DUK_HOBJECT_H_GET_INDEX_PTR(heap,h,i)        (&DUK_HOBJECT_H_GET_BASE((heap), (h))[(i)])

#define DUK_HOBJECT_E_SET_KEY(heap,h,i,k)  do { \
		DUK_HOBJECT_E_GET_KEY((heap), (h), (i)) = (k); \
	} while (0)
#define DUK_HOBJECT_E_SET_VALUE(heap,h,i,v)  do { \
		DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)) = (v); \
	} while (0)
#define DUK_HOBJECT_E_SET_VALUE_TVAL(heap,h,i,v)  do { \
		DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).v = (v); \
	} while (0)
#define DUK_HOBJECT_E_SET_VALUE_GETTER(heap,h,i,v)  do { \
		DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).a.get = (v); \
	} while (0)
#define DUK_HOBJECT_E_SET_VALUE_SETTER(heap,h,i,v)  do { \
		DUK_HOBJECT_E_GET_VALUE((heap), (h), (i)).a.set = (v); \
	} while (0)
#define DUK_HOBJECT_E_SET_FLAGS(heap,h,i,f)  do { \
		DUK_HOBJECT_E_GET_FLAGS((heap), (h), (i)) = (duk_uint8_t) (f); \
	} while (0)
#define DUK_HOBJECT_A_SET_VALUE(heap,h,i,v)  do { \
		DUK_HOBJECT_A_GET_VALUE((heap), (h), (i)) = (v); \
	} while (0)
#define DUK_HOBJECT_A_SET_VALUE_TVAL(heap,h,i,v) \
	DUK_HOBJECT_A_SET_VALUE((heap), (h), (i), (v))  /* alias for above */
#define DUK_HOBJECT_H_SET_INDEX(heap,h,i,v)  do { \
		DUK_HOBJECT_H_GET_INDEX((heap), (h), (i)) = (v); \
	} while (0)

#define DUK_HOBJECT_E_SET_FLAG_BITS(heap,h,i,mask)  do { \
		DUK_HOBJECT_E_GET_FLAGS_BASE((heap), (h))[(i)] |= (mask); \
	} while (0)

#define DUK_HOBJECT_E_CLEAR_FLAG_BITS(heap,h,i,mask)  do { \
		DUK_HOBJECT_E_GET_FLAGS_BASE((heap), (h))[(i)] &= ~(mask); \
	} while (0)

#define DUK_HOBJECT_E_SLOT_IS_WRITABLE(heap,h,i)     ((DUK_HOBJECT_E_GET_FLAGS((heap), (h), (i)) & DUK_PROPDESC_FLAG_WRITABLE) != 0)
#define DUK_HOBJECT_E_SLOT_IS_ENUMERABLE(heap,h,i)   ((DUK_HOBJECT_E_GET_FLAGS((heap), (h), (i)) & DUK_PROPDESC_FLAG_ENUMERABLE) != 0)
#define DUK_HOBJECT_E_SLOT_IS_CONFIGURABLE(heap,h,i) ((DUK_HOBJECT_E_GET_FLAGS((heap), (h), (i)) & DUK_PROPDESC_FLAG_CONFIGURABLE) != 0)
#define DUK_HOBJECT_E_SLOT_IS_ACCESSOR(heap,h,i)     ((DUK_HOBJECT_E_GET_FLAGS((heap), (h), (i)) & DUK_PROPDESC_FLAG_ACCESSOR) != 0)

#define DUK_HOBJECT_E_SLOT_SET_WRITABLE(heap,h,i)        DUK_HOBJECT_E_SET_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_WRITABLE)
#define DUK_HOBJECT_E_SLOT_SET_ENUMERABLE(heap,h,i)      DUK_HOBJECT_E_SET_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_ENUMERABLE)
#define DUK_HOBJECT_E_SLOT_SET_CONFIGURABLE(heap,h,i)    DUK_HOBJECT_E_SET_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_CONFIGURABLE)
#define DUK_HOBJECT_E_SLOT_SET_ACCESSOR(heap,h,i)        DUK_HOBJECT_E_SET_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_ACCESSOR)

#define DUK_HOBJECT_E_SLOT_CLEAR_WRITABLE(heap,h,i)      DUK_HOBJECT_E_CLEAR_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_WRITABLE)
#define DUK_HOBJECT_E_SLOT_CLEAR_ENUMERABLE(heap,h,i)    DUK_HOBJECT_E_CLEAR_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_ENUMERABLE)
#define DUK_HOBJECT_E_SLOT_CLEAR_CONFIGURABLE(heap,h,i)  DUK_HOBJECT_E_CLEAR_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_CONFIGURABLE)
#define DUK_HOBJECT_E_SLOT_CLEAR_ACCESSOR(heap,h,i)      DUK_HOBJECT_E_CLEAR_FLAG_BITS((heap), (h), (i),DUK_PROPDESC_FLAG_ACCESSOR)

#define DUK_PROPDESC_IS_WRITABLE(p)             (((p)->flags & DUK_PROPDESC_FLAG_WRITABLE) != 0)
#define DUK_PROPDESC_IS_ENUMERABLE(p)           (((p)->flags & DUK_PROPDESC_FLAG_ENUMERABLE) != 0)
#define DUK_PROPDESC_IS_CONFIGURABLE(p)         (((p)->flags & DUK_PROPDESC_FLAG_CONFIGURABLE) != 0)
#define DUK_PROPDESC_IS_ACCESSOR(p)             (((p)->flags & DUK_PROPDESC_FLAG_ACCESSOR) != 0)

#define DUK_HOBJECT_HASHIDX_UNUSED              0xffffffffUL
#define DUK_HOBJECT_HASHIDX_DELETED             0xfffffffeUL

/*
 *  Macros for accessing size fields
 */

#if defined(DUK_USE_OBJSIZES16)
#define DUK_HOBJECT_GET_ESIZE(h) ((h)->e_size16)
#define DUK_HOBJECT_SET_ESIZE(h,v) do { (h)->e_size16 = (v); } while (0)
#define DUK_HOBJECT_GET_ENEXT(h) ((h)->e_next16)
#define DUK_HOBJECT_SET_ENEXT(h,v) do { (h)->e_next16 = (v); } while (0)
#define DUK_HOBJECT_POSTINC_ENEXT(h) ((h)->e_next16++)
#define DUK_HOBJECT_GET_ASIZE(h) ((h)->a_size16)
#define DUK_HOBJECT_SET_ASIZE(h,v) do { (h)->a_size16 = (v); } while (0)
#if defined(DUK_USE_HOBJECT_HASH_PART)
#define DUK_HOBJECT_GET_HSIZE(h) ((h)->h_size16)
#define DUK_HOBJECT_SET_HSIZE(h,v) do { (h)->h_size16 = (v); } while (0)
#else
#define DUK_HOBJECT_GET_HSIZE(h) 0
#define DUK_HOBJECT_SET_HSIZE(h,v) do { DUK_ASSERT((v) == 0); } while (0)
#endif
#else
#define DUK_HOBJECT_GET_ESIZE(h) ((h)->e_size)
#define DUK_HOBJECT_SET_ESIZE(h,v) do { (h)->e_size = (v); } while (0)
#define DUK_HOBJECT_GET_ENEXT(h) ((h)->e_next)
#define DUK_HOBJECT_SET_ENEXT(h,v) do { (h)->e_next = (v); } while (0)
#define DUK_HOBJECT_POSTINC_ENEXT(h) ((h)->e_next++)
#define DUK_HOBJECT_GET_ASIZE(h) ((h)->a_size)
#define DUK_HOBJECT_SET_ASIZE(h,v) do { (h)->a_size = (v); } while (0)
#if defined(DUK_USE_HOBJECT_HASH_PART)
#define DUK_HOBJECT_GET_HSIZE(h) ((h)->h_size)
#define DUK_HOBJECT_SET_HSIZE(h,v) do { (h)->h_size = (v); } while (0)
#else
#define DUK_HOBJECT_GET_HSIZE(h) 0
#define DUK_HOBJECT_SET_HSIZE(h,v) do { DUK_ASSERT((v) == 0); } while (0)
#endif
#endif

/*
 *  Misc
 */

/* Maximum prototype traversal depth.  Sanity limit which handles e.g.
 * prototype loops (even complex ones like 1->2->3->4->2->3->4->2->3->4).
 */
#define DUK_HOBJECT_PROTOTYPE_CHAIN_SANITY      10000L

/* Maximum traversal depth for "bound function" chains. */
#define DUK_HOBJECT_BOUND_CHAIN_SANITY          10000L

/*
 *  Ecmascript [[Class]]
 */

/* range check not necessary because all 4-bit values are mapped */
#define DUK_HOBJECT_CLASS_NUMBER_TO_STRIDX(n)  duk_class_number_to_stridx[(n)]

#define DUK_HOBJECT_GET_CLASS_STRING(heap,h)          \
	DUK_HEAP_GET_STRING( \
		(heap), \
		DUK_HOBJECT_CLASS_NUMBER_TO_STRIDX(DUK_HOBJECT_GET_CLASS_NUMBER((h))) \
	)

/*
 *  Macros for property handling
 */

#if defined(DUK_USE_HEAPPTR16)
#define DUK_HOBJECT_GET_PROTOTYPE(heap,h) \
	((duk_hobject *) DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, (h)->prototype16))
#define DUK_HOBJECT_SET_PROTOTYPE(heap,h,x) do { \
		(h)->prototype16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) (x)); \
	} while (0)
#else
#define DUK_HOBJECT_GET_PROTOTYPE(heap,h) \
	((h)->prototype)
#define DUK_HOBJECT_SET_PROTOTYPE(heap,h,x) do { \
		(h)->prototype = (x); \
	} while (0)
#endif

/* note: this updates refcounts */
#define DUK_HOBJECT_SET_PROTOTYPE_UPDREF(thr,h,p)       duk_hobject_set_prototype_updref((thr), (h), (p))

/*
 *  Resizing and hash behavior
 */

/* Sanity limit on max number of properties (allocated, not necessarily used).
 * This is somewhat arbitrary, but if we're close to 2**32 properties some
 * algorithms will fail (e.g. hash size selection, next prime selection).
 * Also, we use negative array/entry table indices to indicate 'not found',
 * so anything above 0x80000000 will cause trouble now.
 */
#if defined(DUK_USE_OBJSIZES16)
#define DUK_HOBJECT_MAX_PROPERTIES       0x0000ffffUL
#else
#define DUK_HOBJECT_MAX_PROPERTIES       0x7fffffffUL   /* 2**31-1 ~= 2G properties */
#endif

/* higher value conserves memory; also note that linear scan is cache friendly */
#define DUK_HOBJECT_E_USE_HASH_LIMIT     32

/* hash size relative to entries size: for value X, approx. hash_prime(e_size + e_size / X) */
#define DUK_HOBJECT_H_SIZE_DIVISOR       4  /* hash size approx. 1.25 times entries size */

/* if new_size < L * old_size, resize without abandon check; L = 3-bit fixed point, e.g. 9 -> 9/8 = 112.5% */
#define DUK_HOBJECT_A_FAST_RESIZE_LIMIT  9  /* 112.5%, i.e. new size less than 12.5% higher -> fast resize */

/* if density < L, abandon array part, L = 3-bit fixed point, e.g. 2 -> 2/8 = 25% */
/* limit is quite low: one array entry is 8 bytes, one normal entry is 4+1+8+4 = 17 bytes (with hash entry) */
#define DUK_HOBJECT_A_ABANDON_LIMIT      2  /* 25%, i.e. less than 25% used -> abandon */

/* internal align target for props allocation, must be 2*n for some n */
#if (DUK_USE_ALIGN_BY == 4)
#define DUK_HOBJECT_ALIGN_TARGET         4
#elif (DUK_USE_ALIGN_BY == 8)
#define DUK_HOBJECT_ALIGN_TARGET         8
#elif (DUK_USE_ALIGN_BY == 1)
#define DUK_HOBJECT_ALIGN_TARGET         1
#else
#error invalid DUK_USE_ALIGN_BY
#endif

/* controls for minimum entry part growth */
#define DUK_HOBJECT_E_MIN_GROW_ADD       16
#define DUK_HOBJECT_E_MIN_GROW_DIVISOR   8  /* 2^3 -> 1/8 = 12.5% min growth */

/* controls for minimum array part growth */
#define DUK_HOBJECT_A_MIN_GROW_ADD       16
#define DUK_HOBJECT_A_MIN_GROW_DIVISOR   8  /* 2^3 -> 1/8 = 12.5% min growth */

/* probe sequence */
#define DUK_HOBJECT_HASH_INITIAL(hash,h_size)  ((hash) % (h_size))
#define DUK_HOBJECT_HASH_PROBE_STEP(hash)      DUK_UTIL_GET_HASH_PROBE_STEP((hash))

/*
 *  PC-to-line constants
 */

#define DUK_PC2LINE_SKIP    64

/* maximum length for a SKIP-1 diffstream: 35 bits per entry, rounded up to bytes */
#define DUK_PC2LINE_MAX_DIFF_LENGTH    (((DUK_PC2LINE_SKIP - 1) * 35 + 7) / 8)

/*
 *  Struct defs
 */

struct duk_propaccessor {
	duk_hobject *get;
	duk_hobject *set;
};

union duk_propvalue {
	/* The get/set pointers could be 16-bit pointer compressed but it
	 * would make no difference on 32-bit platforms because duk_tval is
	 * 8 bytes or more anyway.
	 */
	duk_tval v;
	duk_propaccessor a;
};

struct duk_propdesc {
	/* read-only values 'lifted' for ease of use */
	duk_small_int_t flags;
	duk_hobject *get;
	duk_hobject *set;

	/* for updating (all are set to < 0 for virtual properties) */
	duk_int_t e_idx;  /* prop index in 'entry part', < 0 if not there */
	duk_int_t h_idx;  /* prop index in 'hash part', < 0 if not there */
	duk_int_t a_idx;  /* prop index in 'array part', < 0 if not there */
};

struct duk_hobject {
	duk_heaphdr hdr;

	/*
	 *  'props' contains {key,value,flags} entries, optional array entries, and
	 *  an optional hash lookup table for non-array entries in a single 'sliced'
	 *  allocation.  There are several layout options, which differ slightly in
	 *  generated code size/speed and alignment/padding; duk_features.h selects
	 *  the layout used.
	 *
	 *  Layout 1 (DUK_USE_HOBJECT_LAYOUT_1):
	 *
	 *    e_size * sizeof(duk_hstring *)         bytes of   entry keys (e_next gc reachable)
	 *    e_size * sizeof(duk_propvalue)         bytes of   entry values (e_next gc reachable)
	 *    e_size * sizeof(duk_uint8_t)           bytes of   entry flags (e_next gc reachable)
	 *    a_size * sizeof(duk_tval)              bytes of   (opt) array values (plain only) (all gc reachable)
	 *    h_size * sizeof(duk_uint32_t)          bytes of   (opt) hash indexes to entries (e_size),
	 *                                                      0xffffffffUL = unused, 0xfffffffeUL = deleted
	 *
	 *  Layout 2 (DUK_USE_HOBJECT_LAYOUT_2):
	 *
	 *    e_size * sizeof(duk_propvalue)         bytes of   entry values (e_next gc reachable)
	 *    e_size * sizeof(duk_hstring *)         bytes of   entry keys (e_next gc reachable)
	 *    e_size * sizeof(duk_uint8_t) + pad     bytes of   entry flags (e_next gc reachable)
	 *    a_size * sizeof(duk_tval)              bytes of   (opt) array values (plain only) (all gc reachable)
	 *    h_size * sizeof(duk_uint32_t)          bytes of   (opt) hash indexes to entries (e_size),
	 *                                                      0xffffffffUL = unused, 0xfffffffeUL = deleted
	 *
	 *  Layout 3 (DUK_USE_HOBJECT_LAYOUT_3):
	 *
	 *    e_size * sizeof(duk_propvalue)         bytes of   entry values (e_next gc reachable)
	 *    a_size * sizeof(duk_tval)              bytes of   (opt) array values (plain only) (all gc reachable)
	 *    e_size * sizeof(duk_hstring *)         bytes of   entry keys (e_next gc reachable)
	 *    h_size * sizeof(duk_uint32_t)          bytes of   (opt) hash indexes to entries (e_size),
	 *                                                      0xffffffffUL = unused, 0xfffffffeUL = deleted
	 *    e_size * sizeof(duk_uint8_t)           bytes of   entry flags (e_next gc reachable)
	 *
	 *  In layout 1, the 'e_next' count is rounded to 4 or 8 on platforms
	 *  requiring 4 or 8 byte alignment.  This ensures proper alignment
	 *  for the entries, at the cost of memory footprint.  However, it's
	 *  probably preferable to use another layout on such platforms instead.
	 *
	 *  In layout 2, the key and value parts are swapped to avoid padding
	 *  the key array on platforms requiring alignment by 8.  The flags part
	 *  is padded to get alignment for array entries.  The 'e_next' count does
	 *  not need to be rounded as in layout 1.
	 *
	 *  In layout 3, entry values and array values are always aligned properly,
	 *  and assuming pointers are at most 8 bytes, so are the entry keys.  Hash
	 *  indices will be properly aligned (assuming pointers are at least 4 bytes).
	 *  Finally, flags don't need additional alignment.  This layout provides
	 *  compact allocations without padding (even on platforms with alignment
	 *  requirements) at the cost of a bit slower lookups.
	 *
	 *  Objects with few keys don't have a hash index; keys are looked up linearly,
	 *  which is cache efficient because the keys are consecutive.  Larger objects
	 *  have a hash index part which contains integer indexes to the entries part.
	 *
	 *  A single allocation reduces memory allocation overhead but requires more
	 *  work when any part needs to be resized.  A sliced allocation for entries
	 *  makes linear key matching faster on most platforms (more locality) and
	 *  skimps on flags size (which would be followed by 3 bytes of padding in
	 *  most architectures if entries were placed in a struct).
	 *
	 *  'props' also contains internal properties distinguished with a non-BMP
	 *  prefix.  Often used properties should be placed early in 'props' whenever
	 *  possible to make accessing them as fast a possible.
	 */

#if defined(DUK_USE_HEAPPTR16)
	/* Located in duk_heaphdr h_extra16.  Subclasses of duk_hobject (like
	 * duk_hcompiledfunction) are not free to use h_extra16 for this reason.
	 */
#else
	duk_uint8_t *props;
#endif

	/* prototype: the only internal property lifted outside 'e' as it is so central */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t prototype16;
#else
	duk_hobject *prototype;
#endif

#if defined(DUK_USE_OBJSIZES16)
	duk_uint16_t e_size16;
	duk_uint16_t e_next16;
	duk_uint16_t a_size16;
#if defined(DUK_USE_HOBJECT_HASH_PART)
	duk_uint16_t h_size16;
#endif
#else
	duk_uint32_t e_size;  /* entry part size */
	duk_uint32_t e_next;  /* index for next new key ([0,e_next[ are gc reachable) */
	duk_uint32_t a_size;  /* array part size (entirely gc reachable) */
#if defined(DUK_USE_HOBJECT_HASH_PART)
	duk_uint32_t h_size;  /* hash part size or 0 if unused */
#endif
#endif
};

/*
 *  Exposed data
 */

#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL duk_uint8_t duk_class_number_to_stridx[32];
#endif  /* !DUK_SINGLE_FILE */

/*
 *  Prototypes
 */

/* alloc and init */
DUK_INTERNAL_DECL duk_hobject *duk_hobject_alloc(duk_heap *heap, duk_uint_t hobject_flags);
#if 0  /* unused */
DUK_INTERNAL_DECL duk_hobject *duk_hobject_alloc_checked(duk_hthread *thr, duk_uint_t hobject_flags);
#endif
DUK_INTERNAL_DECL duk_hcompiledfunction *duk_hcompiledfunction_alloc(duk_heap *heap, duk_uint_t hobject_flags);
DUK_INTERNAL_DECL duk_hnativefunction *duk_hnativefunction_alloc(duk_heap *heap, duk_uint_t hobject_flags);
DUK_INTERNAL duk_hbufferobject *duk_hbufferobject_alloc(duk_heap *heap, duk_uint_t hobject_flags);
DUK_INTERNAL_DECL duk_hthread *duk_hthread_alloc(duk_heap *heap, duk_uint_t hobject_flags);

/* low-level property functions */
DUK_INTERNAL_DECL void duk_hobject_find_existing_entry(duk_heap *heap, duk_hobject *obj, duk_hstring *key, duk_int_t *e_idx, duk_int_t *h_idx);
DUK_INTERNAL_DECL duk_tval *duk_hobject_find_existing_entry_tval_ptr(duk_heap *heap, duk_hobject *obj, duk_hstring *key);
DUK_INTERNAL_DECL duk_tval *duk_hobject_find_existing_entry_tval_ptr_and_attrs(duk_heap *heap, duk_hobject *obj, duk_hstring *key, duk_int_t *out_attrs);
DUK_INTERNAL_DECL duk_tval *duk_hobject_find_existing_array_entry_tval_ptr(duk_heap *heap, duk_hobject *obj, duk_uarridx_t i);

/* XXX: when optimizing for guaranteed property slots, use a guaranteed
 * slot for internal value; this call can then access it directly.
 */
#define duk_hobject_get_internal_value_tval_ptr(heap,obj) \
	duk_hobject_find_existing_entry_tval_ptr((heap), (obj), DUK_HEAP_STRING_INT_VALUE((heap)))

/* core property functions */
DUK_INTERNAL_DECL duk_bool_t duk_hobject_getprop(duk_hthread *thr, duk_tval *tv_obj, duk_tval *tv_key);
DUK_INTERNAL_DECL duk_bool_t duk_hobject_putprop(duk_hthread *thr, duk_tval *tv_obj, duk_tval *tv_key, duk_tval *tv_val, duk_bool_t throw_flag);
DUK_INTERNAL_DECL duk_bool_t duk_hobject_delprop(duk_hthread *thr, duk_tval *tv_obj, duk_tval *tv_key, duk_bool_t throw_flag);
DUK_INTERNAL_DECL duk_bool_t duk_hobject_hasprop(duk_hthread *thr, duk_tval *tv_obj, duk_tval *tv_key);

/* internal property functions */
#define DUK_DELPROP_FLAG_THROW  (1 << 0)
#define DUK_DELPROP_FLAG_FORCE  (1 << 1)
DUK_INTERNAL_DECL duk_bool_t duk_hobject_delprop_raw(duk_hthread *thr, duk_hobject *obj, duk_hstring *key, duk_small_uint_t flags);
DUK_INTERNAL_DECL duk_bool_t duk_hobject_hasprop_raw(duk_hthread *thr, duk_hobject *obj, duk_hstring *key);
DUK_INTERNAL_DECL void duk_hobject_define_property_internal(duk_hthread *thr, duk_hobject *obj, duk_hstring *key, duk_small_uint_t flags);
DUK_INTERNAL_DECL void duk_hobject_define_property_internal_arridx(duk_hthread *thr, duk_hobject *obj, duk_uarridx_t arr_idx, duk_small_uint_t flags);
DUK_INTERNAL_DECL void duk_hobject_define_accessor_internal(duk_hthread *thr, duk_hobject *obj, duk_hstring *key, duk_hobject *getter, duk_hobject *setter, duk_small_uint_t propflags);
DUK_INTERNAL_DECL void duk_hobject_set_length(duk_hthread *thr, duk_hobject *obj, duk_uint32_t length);  /* XXX: duk_uarridx_t? */
DUK_INTERNAL_DECL void duk_hobject_set_length_zero(duk_hthread *thr, duk_hobject *obj);
DUK_INTERNAL_DECL duk_uint32_t duk_hobject_get_length(duk_hthread *thr, duk_hobject *obj);  /* XXX: duk_uarridx_t? */

/* helpers for defineProperty() and defineProperties() */
DUK_INTERNAL_DECL
void duk_hobject_prepare_property_descriptor(duk_context *ctx,
                                             duk_idx_t idx_in,
                                             duk_uint_t *out_defprop_flags,
                                             duk_idx_t *out_idx_value,
                                             duk_hobject **out_getter,
                                             duk_hobject **out_setter);
DUK_INTERNAL_DECL
void duk_hobject_define_property_helper(duk_context *ctx,
                                        duk_uint_t defprop_flags,
                                        duk_hobject *obj,
                                        duk_hstring *key,
                                        duk_idx_t idx_value,
                                        duk_hobject *get,
                                        duk_hobject *set);

/* Object built-in methods */
DUK_INTERNAL_DECL duk_ret_t duk_hobject_object_get_own_property_descriptor(duk_context *ctx);
DUK_INTERNAL_DECL void duk_hobject_object_seal_freeze_helper(duk_hthread *thr, duk_hobject *obj, duk_bool_t is_freeze);
DUK_INTERNAL_DECL duk_bool_t duk_hobject_object_is_sealed_frozen_helper(duk_hthread *thr, duk_hobject *obj, duk_bool_t is_frozen);
DUK_INTERNAL_DECL duk_bool_t duk_hobject_object_ownprop_helper(duk_context *ctx, duk_small_uint_t required_desc_flags);

/* internal properties */
DUK_INTERNAL_DECL duk_bool_t duk_hobject_get_internal_value(duk_heap *heap, duk_hobject *obj, duk_tval *tv);
DUK_INTERNAL_DECL duk_hstring *duk_hobject_get_internal_value_string(duk_heap *heap, duk_hobject *obj);

/* hobject management functions */
DUK_INTERNAL_DECL void duk_hobject_compact_props(duk_hthread *thr, duk_hobject *obj);

/* ES6 proxy */
#if defined(DUK_USE_ES6_PROXY)
DUK_INTERNAL_DECL duk_bool_t duk_hobject_proxy_check(duk_hthread *thr, duk_hobject *obj, duk_hobject **out_target, duk_hobject **out_handler);
DUK_INTERNAL_DECL duk_hobject *duk_hobject_resolve_proxy_target(duk_hthread *thr, duk_hobject *obj);
#endif

/* enumeration */
DUK_INTERNAL_DECL void duk_hobject_enumerator_create(duk_context *ctx, duk_small_uint_t enum_flags);
DUK_INTERNAL_DECL duk_ret_t duk_hobject_get_enumerated_keys(duk_context *ctx, duk_small_uint_t enum_flags);
DUK_INTERNAL_DECL duk_bool_t duk_hobject_enumerator_next(duk_context *ctx, duk_bool_t get_value);

/* macros */
DUK_INTERNAL_DECL void duk_hobject_set_prototype_updref(duk_hthread *thr, duk_hobject *h, duk_hobject *p);

/* finalization */
DUK_INTERNAL_DECL void duk_hobject_run_finalizer(duk_hthread *thr, duk_hobject *obj);

/* pc2line */
#if defined(DUK_USE_PC2LINE)
DUK_INTERNAL_DECL void duk_hobject_pc2line_pack(duk_hthread *thr, duk_compiler_instr *instrs, duk_uint_fast32_t length);
DUK_INTERNAL_DECL duk_uint_fast32_t duk_hobject_pc2line_query(duk_context *ctx, duk_idx_t idx_func, duk_uint_fast32_t pc);
#endif

/* misc */
DUK_INTERNAL_DECL duk_bool_t duk_hobject_prototype_chain_contains(duk_hthread *thr, duk_hobject *h, duk_hobject *p, duk_bool_t ignore_loop);

#endif  /* DUK_HOBJECT_H_INCLUDED */
#line 1 "duk_hcompiledfunction.h"
/*
 *  Heap compiled function (Ecmascript function) representation.
 *
 *  There is a single data buffer containing the Ecmascript function's
 *  bytecode, constants, and inner functions.
 */

#ifndef DUK_HCOMPILEDFUNCTION_H_INCLUDED
#define DUK_HCOMPILEDFUNCTION_H_INCLUDED

/*
 *  Field accessor macros
 */

/* XXX: casts could be improved, especially for GET/SET DATA */

#if defined(DUK_USE_HEAPPTR16)
#define DUK_HCOMPILEDFUNCTION_GET_DATA(heap,h) \
	((duk_hbuffer_fixed *) (void *) DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, (h)->data16))
#define DUK_HCOMPILEDFUNCTION_SET_DATA(heap,h,v) do { \
		(h)->data16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) (v)); \
	} while (0)
#define DUK_HCOMPILEDFUNCTION_GET_FUNCS(heap,h)  \
	((duk_hobject **) (void *) (DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, (h)->funcs16)))
#define DUK_HCOMPILEDFUNCTION_SET_FUNCS(heap,h,v)  do { \
		(h)->funcs16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) (v)); \
	} while (0)
#define DUK_HCOMPILEDFUNCTION_GET_BYTECODE(heap,h)  \
	((duk_instr_t *) (void *) (DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, (h)->bytecode16)))
#define DUK_HCOMPILEDFUNCTION_SET_BYTECODE(heap,h,v)  do { \
		(h)->bytecode16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) (v)); \
	} while (0)
#else
#define DUK_HCOMPILEDFUNCTION_GET_DATA(heap,h) \
	((duk_hbuffer_fixed *) (void *) (h)->data)
#define DUK_HCOMPILEDFUNCTION_SET_DATA(heap,h,v) do { \
		(h)->data = (duk_hbuffer *) (v); \
	} while (0)
#define DUK_HCOMPILEDFUNCTION_GET_FUNCS(heap,h)  \
	((h)->funcs)
#define DUK_HCOMPILEDFUNCTION_SET_FUNCS(heap,h,v)  do { \
		(h)->funcs = (v); \
	} while (0)
#define DUK_HCOMPILEDFUNCTION_GET_BYTECODE(heap,h)  \
	((h)->bytecode)
#define DUK_HCOMPILEDFUNCTION_SET_BYTECODE(heap,h,v)  do { \
		(h)->bytecode = (v); \
	} while (0)
#endif

/*
 *  Accessor macros for function specific data areas
 */

/* Note: assumes 'data' is always a fixed buffer */
#define DUK_HCOMPILEDFUNCTION_GET_BUFFER_BASE(heap,h)  \
	DUK_HBUFFER_FIXED_GET_DATA_PTR((heap), DUK_HCOMPILEDFUNCTION_GET_DATA((heap), (h)))

#define DUK_HCOMPILEDFUNCTION_GET_CONSTS_BASE(heap,h)  \
	((duk_tval *) (void *) DUK_HCOMPILEDFUNCTION_GET_BUFFER_BASE((heap), (h)))

#define DUK_HCOMPILEDFUNCTION_GET_FUNCS_BASE(heap,h)  \
	DUK_HCOMPILEDFUNCTION_GET_FUNCS((heap), (h))

#define DUK_HCOMPILEDFUNCTION_GET_CODE_BASE(heap,h)  \
	DUK_HCOMPILEDFUNCTION_GET_BYTECODE((heap), (h))

#define DUK_HCOMPILEDFUNCTION_GET_CONSTS_END(heap,h)  \
	((duk_tval *) (void *) DUK_HCOMPILEDFUNCTION_GET_FUNCS((heap), (h)))

#define DUK_HCOMPILEDFUNCTION_GET_FUNCS_END(heap,h)  \
	((duk_hobject **) (void *) DUK_HCOMPILEDFUNCTION_GET_BYTECODE((heap), (h)))

/* XXX: double evaluation of DUK_HCOMPILEDFUNCTION_GET_DATA() */
#define DUK_HCOMPILEDFUNCTION_GET_CODE_END(heap,h)  \
	((duk_instr_t *) (void *) (DUK_HBUFFER_FIXED_GET_DATA_PTR((heap), DUK_HCOMPILEDFUNCTION_GET_DATA((heap), (h))) + \
	                DUK_HBUFFER_GET_SIZE((duk_hbuffer *) DUK_HCOMPILEDFUNCTION_GET_DATA((heap), h))))

#define DUK_HCOMPILEDFUNCTION_GET_CONSTS_SIZE(heap,h)  \
	( \
	 (duk_size_t) \
	 ( \
	   ((const duk_uint8_t *) DUK_HCOMPILEDFUNCTION_GET_CONSTS_END((heap), (h))) - \
	   ((const duk_uint8_t *) DUK_HCOMPILEDFUNCTION_GET_CONSTS_BASE((heap), (h))) \
	 ) \
	)

#define DUK_HCOMPILEDFUNCTION_GET_FUNCS_SIZE(heap,h)  \
	( \
	 (duk_size_t) \
	 ( \
	   ((const duk_uint8_t *) DUK_HCOMPILEDFUNCTION_GET_FUNCS_END((heap), (h))) - \
	   ((const duk_uint8_t *) DUK_HCOMPILEDFUNCTION_GET_FUNCS_BASE((heap), (h))) \
	 ) \
	)

#define DUK_HCOMPILEDFUNCTION_GET_CODE_SIZE(heap,h)  \
	( \
	 (duk_size_t) \
	 ( \
	   ((const duk_uint8_t *) DUK_HCOMPILEDFUNCTION_GET_CODE_END((heap),(h))) - \
	   ((const duk_uint8_t *) DUK_HCOMPILEDFUNCTION_GET_CODE_BASE((heap),(h))) \
	 ) \
	)

#define DUK_HCOMPILEDFUNCTION_GET_CONSTS_COUNT(heap,h)  \
	((duk_size_t) (DUK_HCOMPILEDFUNCTION_GET_CONSTS_SIZE((heap), (h)) / sizeof(duk_tval)))

#define DUK_HCOMPILEDFUNCTION_GET_FUNCS_COUNT(heap,h)  \
	((duk_size_t) (DUK_HCOMPILEDFUNCTION_GET_FUNCS_SIZE((heap), (h)) / sizeof(duk_hobject *)))

#define DUK_HCOMPILEDFUNCTION_GET_CODE_COUNT(heap,h)  \
	((duk_size_t) (DUK_HCOMPILEDFUNCTION_GET_CODE_SIZE((heap), (h)) / sizeof(duk_instr_t)))


/*
 *  Main struct
 */

struct duk_hcompiledfunction {
	/* shared object part */
	duk_hobject obj;

	/*
	 *  Pointers to function data area for faster access.  Function
	 *  data is a buffer shared between all closures of the same
	 *  "template" function.  The data buffer is always fixed (non-
	 *  dynamic, hence stable), with a layout as follows:
	 *
	 *    constants (duk_tval)
	 *    inner functions (duk_hobject *)
	 *    bytecode (duk_instr_t)
	 *
	 *  Note: bytecode end address can be computed from 'data' buffer
	 *  size.  It is not strictly necessary functionally, assuming
	 *  bytecode never jumps outside its allocated area.  However,
	 *  it's a safety/robustness feature for avoiding the chance of
	 *  executing random data as bytecode due to a compiler error.
	 *
	 *  Note: values in the data buffer must be incref'd (they will
	 *  be decref'd on release) for every compiledfunction referring
	 *  to the 'data' element.
	 */

	/* Data area, fixed allocation, stable data ptrs. */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t data16;
#else
	duk_hbuffer *data;
#endif

	/* No need for constants pointer (= same as data).
	 *
	 * When using 16-bit packing alignment to 4 is nice.  'funcs' will be
	 * 4-byte aligned because 'constants' are duk_tvals.  For now the
	 * inner function pointers are not compressed, so that 'bytecode' will
	 * also be 4-byte aligned.
	 */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t funcs16;
	duk_uint16_t bytecode16;
#else
	duk_hobject **funcs;
	duk_instr_t *bytecode;
#endif

	/*
	 *  'nregs' registers are allocated on function entry, at most 'nargs'
	 *  are initialized to arguments, and the rest to undefined.  Arguments
	 *  above 'nregs' are not mapped to registers.  All registers in the
	 *  active stack range must be initialized because they are GC reachable.
	 *  'nargs' is needed so that if the function is given more than 'nargs'
	 *  arguments, the additional arguments do not 'clobber' registers
	 *  beyond 'nregs' which must be consistently initialized to undefined.
	 *
	 *  Usually there is no need to know which registers are mapped to
	 *  local variables.  Registers may be allocated to variable in any
	 *  way (even including gaps).  However, a register-variable mapping
	 *  must be the same for the duration of the function execution and
	 *  the register cannot be used for anything else.
	 *
	 *  When looking up variables by name, the '_Varmap' map is used.
	 *  When an activation closes, registers mapped to arguments are
	 *  copied into the environment record based on the same map.  The
	 *  reverse map (from register to variable) is not currently needed
	 *  at run time, except for debugging, so it is not maintained.
	 */

	duk_uint16_t nregs;                /* regs to allocate */
	duk_uint16_t nargs;                /* number of arguments allocated to regs */

	/*
	 *  Additional control information is placed into the object itself
	 *  as internal properties to avoid unnecessary fields for the
	 *  majority of functions.  The compiler tries to omit internal
	 *  control fields when possible.
	 *
	 *  Function templates:
	 *
	 *    {
	 *      name: "func",    // declaration, named function expressions
	 *      fileName: <debug info for creating nice errors>
	 *      _Varmap: { "arg1": 0, "arg2": 1, "varname": 2 },
	 *      _Formals: [ "arg1", "arg2" ],
	 *      _Source: "function func(arg1, arg2) { ... }",
	 *      _Pc2line: <debug info for pc-to-line mapping>,
	 *    }
	 *
	 *  Function instances:
	 *
	 *    {
	 *      length: 2,
	 *      prototype: { constructor: <func> },
	 *      caller: <thrower>,
	 *      arguments: <thrower>,
	 *      name: "func",    // declaration, named function expressions
	 *      fileName: <debug info for creating nice errors>
	 *      _Varmap: { "arg1": 0, "arg2": 1, "varname": 2 },
	 *      _Formals: [ "arg1", "arg2" ],
	 *      _Source: "function func(arg1, arg2) { ... }",
	 *      _Pc2line: <debug info for pc-to-line mapping>,
	 *      _Varenv: <variable environment of closure>,
	 *      _Lexenv: <lexical environment of closure (if differs from _Varenv)>
	 *    }
	 *
	 *  More detailed description of these properties can be found
	 *  in the documentation.
	 */

#if defined(DUK_USE_DEBUGGER_SUPPORT)
	/* Line number range for function.  Needed during debugging to
	 * determine active breakpoints.
	 */
	duk_uint32_t start_line;
	duk_uint32_t end_line;
#endif
};

#endif  /* DUK_HCOMPILEDFUNCTION_H_INCLUDED */
#line 1 "duk_hnativefunction.h"
/*
 *  Heap native function representation.
 */

#ifndef DUK_HNATIVEFUNCTION_H_INCLUDED
#define DUK_HNATIVEFUNCTION_H_INCLUDED

#define DUK_HNATIVEFUNCTION_NARGS_VARARGS  ((duk_int16_t) -1)
#define DUK_HNATIVEFUNCTION_NARGS_MAX      ((duk_int16_t) 0x7fff)

struct duk_hnativefunction {
	/* shared object part */
	duk_hobject obj;

	duk_c_function func;
	duk_int16_t nargs;
	duk_int16_t magic;

	/* The 'magic' field allows an opaque 16-bit field to be accessed by the
	 * Duktape/C function.  This allows, for instance, the same native function
	 * to be used for a set of very similar functions, with the 'magic' field
	 * providing the necessary non-argument flags / values to guide the behavior
	 * of the native function.  The value is signed on purpose: it is easier to
	 * convert a signed value to unsigned (simply AND with 0xffff) than vice
	 * versa.
	 *
	 * Note: cannot place nargs/magic into the heaphdr flags, because
	 * duk_hobject takes almost all flags already (and needs the spare).
	 */
};

#endif  /* DUK_HNATIVEFUNCTION_H_INCLUDED */
#line 1 "duk_hbufferobject.h"
/*
 *  Heap Buffer object representation.  Used for all Buffer variants.
 */

#ifndef DUK_HBUFFEROBJECT_H_INCLUDED
#define DUK_HBUFFEROBJECT_H_INCLUDED

/* All element accessors are host endian now (driven by TypedArray spec). */
#define DUK_HBUFFEROBJECT_ELEM_UINT8           0
#define DUK_HBUFFEROBJECT_ELEM_UINT8CLAMPED    1
#define DUK_HBUFFEROBJECT_ELEM_INT8            2
#define DUK_HBUFFEROBJECT_ELEM_UINT16          3
#define DUK_HBUFFEROBJECT_ELEM_INT16           4
#define DUK_HBUFFEROBJECT_ELEM_UINT32          5
#define DUK_HBUFFEROBJECT_ELEM_INT32           6
#define DUK_HBUFFEROBJECT_ELEM_FLOAT32         7
#define DUK_HBUFFEROBJECT_ELEM_FLOAT64         8
#define DUK_HBUFFEROBJECT_ELEM_MAX             8

#define DUK_ASSERT_HBUFFEROBJECT_VALID(h) do { \
		DUK_ASSERT((h) != NULL); \
		DUK_ASSERT((h)->shift <= 3); \
		DUK_ASSERT((h)->elem_type <= DUK_HBUFFEROBJECT_ELEM_MAX); \
		DUK_ASSERT(((h)->shift == 0 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_UINT8) || \
		           ((h)->shift == 0 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_UINT8CLAMPED) || \
		           ((h)->shift == 0 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_INT8) || \
		           ((h)->shift == 1 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_UINT16) || \
		           ((h)->shift == 1 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_INT16) || \
		           ((h)->shift == 2 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_UINT32) || \
		           ((h)->shift == 2 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_INT32) || \
		           ((h)->shift == 2 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_FLOAT32) || \
		           ((h)->shift == 3 && (h)->elem_type == DUK_HBUFFEROBJECT_ELEM_FLOAT64)); \
		DUK_ASSERT((h)->is_view == 0 || (h)->is_view == 1); \
		DUK_ASSERT(DUK_HOBJECT_IS_BUFFEROBJECT((duk_hobject *) (h))); \
		if ((h)->buf == NULL) { \
			DUK_ASSERT((h)->offset == 0); \
			DUK_ASSERT((h)->length == 0); \
		} else { \
			/* No assertions for offset or length; in particular, \
			 * it's OK for length to be longer than underlying \
			 * buffer.  Just ensure they don't wrap when added. \
			 */ \
			DUK_ASSERT((h)->offset + (h)->length >= (h)->offset); \
		} \
	} while (0)

/* Get the current data pointer (caller must ensure buf != NULL) as a
 * duk_uint8_t ptr.
 */
#define DUK_HBUFFEROBJECT_GET_SLICE_BASE(heap,h) \
	(DUK_ASSERT_EXPR((h) != NULL), DUK_ASSERT_EXPR((h)->buf != NULL), \
	(((duk_uint8_t *) DUK_HBUFFER_GET_DATA_PTR((heap), (h)->buf)) + (h)->offset))

/* True if slice is full, i.e. offset is zero and length covers the entire
 * buffer.  This status may change independently of the duk_hbufferobject if
 * the underlying buffer is dynamic and changes without the hbufferobject
 * being changed.
 */
#define DUK_HBUFFEROBJECT_FULL_SLICE(h) \
	(DUK_ASSERT_EXPR((h) != NULL), DUK_ASSERT_EXPR((h)->buf != NULL), \
	((h)->offset == 0 && (h)->length == DUK_HBUFFER_GET_SIZE((h)->buf)))

/* Validate that the whole slice [0,length[ is contained in the underlying
 * buffer.  Caller must ensure 'buf' != NULL.
 */
#define DUK_HBUFFEROBJECT_VALID_SLICE(h) \
	(DUK_ASSERT_EXPR((h) != NULL), DUK_ASSERT_EXPR((h)->buf != NULL), \
	((h)->offset + (h)->length <= DUK_HBUFFER_GET_SIZE((h)->buf)))

/* Validate byte read/write for virtual 'offset', i.e. check that the
 * offset, taking into account h->offset, is within the underlying
 * buffer size.  This is a safety check which is needed to ensure
 * that even a misconfigured duk_hbufferobject never causes memory
 * unsafe behavior (e.g. if an underlying dynamic buffer changes
 * after being setup).  Caller must ensure 'buf' != NULL.
 */
#define DUK_HBUFFEROBJECT_VALID_BYTEOFFSET_INCL(h,off) \
	(DUK_ASSERT_EXPR((h) != NULL), DUK_ASSERT_EXPR((h)->buf != NULL), \
	((h)->offset + (off) < DUK_HBUFFER_GET_SIZE((h)->buf)))

#define DUK_HBUFFEROBJECT_VALID_BYTEOFFSET_EXCL(h,off) \
	(DUK_ASSERT_EXPR((h) != NULL), DUK_ASSERT_EXPR((h)->buf != NULL), \
	((h)->offset + (off) <= DUK_HBUFFER_GET_SIZE((h)->buf)))

/* Clamp an input byte length (already assumed to be within the nominal
 * duk_hbufferobject 'length') to the current dynamic buffer limits to
 * yield a byte length limit that's safe for memory accesses.  This value
 * can be invalidated by any side effect because it may trigger a user
 * callback that resizes the underlying buffer.
 */
#define DUK_HBUFFEROBJECT_CLAMP_BYTELENGTH(h,len) \
	(DUK_ASSERT_EXPR((h) != NULL), \
	duk_hbufferobject_clamp_bytelength((h), (len)))

struct duk_hbufferobject {
	/* Shared object part. */
	duk_hobject obj;

	/* Underlying buffer (refcounted), may be NULL. */
	duk_hbuffer *buf;

	/* Slice and accessor information.
	 *
	 * Because the underlying buffer may be dynamic, these may be
	 * invalidated by the buffer being modified so that both offset
	 * and length should be validated before every access.  Behavior
	 * when the underlying buffer has changed doesn't need to be clean:
	 * virtual 'length' doesn't need to be affected, reads can return
	 * zero/NaN, and writes can be ignored.
	 *
	 * Note that a data pointer cannot be precomputed because 'buf' may
	 * be dynamic and its pointer unstable.
	 */

	duk_uint_t offset;       /* byte offset to buf */
	duk_uint_t length;       /* byte index limit for element access, exclusive */
	duk_uint8_t shift;       /* element size shift:
	                          *   0 = u8/i8
	                          *   1 = u16/i16
	                          *   2 = u32/i32/float
	                          *   3 = double
	                          */
	duk_uint8_t elem_type;   /* element type */
	duk_uint8_t is_view;
};

#if defined(DUK_USE_BUFFEROBJECT_SUPPORT)
DUK_INTERNAL_DECL duk_uint_t duk_hbufferobject_clamp_bytelength(duk_hbufferobject *h_bufobj, duk_uint_t len);
#endif
DUK_INTERNAL_DECL void duk_hbufferobject_push_validated_read(duk_context *ctx, duk_hbufferobject *h_bufobj, duk_uint8_t *p, duk_small_uint_t elem_size);
DUK_INTERNAL_DECL void duk_hbufferobject_validated_write(duk_context *ctx, duk_hbufferobject *h_bufobj, duk_uint8_t *p, duk_small_uint_t elem_size);

#endif  /* DUK_HBUFFEROBJECT_H_INCLUDED */
#line 1 "duk_hthread.h"
/*
 *  Heap thread object representation.
 *
 *  duk_hthread is also the 'context' (duk_context) for exposed APIs
 *  which mostly operate on the topmost frame of the value stack.
 */

#ifndef DUK_HTHREAD_H_INCLUDED
#define DUK_HTHREAD_H_INCLUDED

/*
 *  Stack constants
 */

#define DUK_VALSTACK_GROW_STEP          128     /* roughly 1 kiB */
#define DUK_VALSTACK_SHRINK_THRESHOLD   256     /* roughly 2 kiB */
#define DUK_VALSTACK_SHRINK_SPARE       64      /* roughly 0.5 kiB */
#define DUK_VALSTACK_INITIAL_SIZE       128     /* roughly 1.0 kiB -> but rounds up to DUK_VALSTACK_GROW_STEP in practice */
#define DUK_VALSTACK_INTERNAL_EXTRA     64      /* internal extra elements assumed on function entry,
                                                 * always added to user-defined 'extra' for e.g. the
                                                 * duk_check_stack() call.
                                                 */
#define DUK_VALSTACK_API_ENTRY_MINIMUM  DUK_API_ENTRY_STACK
                                                /* number of elements guaranteed to be user accessible
                                                 * (in addition to call arguments) on Duktape/C function entry.
                                                 */

/* Note: DUK_VALSTACK_INITIAL_SIZE must be >= DUK_VALSTACK_API_ENTRY_MINIMUM
 * + DUK_VALSTACK_INTERNAL_EXTRA so that the initial stack conforms to spare
 * requirements.
 */

#define DUK_VALSTACK_DEFAULT_MAX        1000000L

#define DUK_CALLSTACK_GROW_STEP         8       /* roughly 256 bytes */
#define DUK_CALLSTACK_SHRINK_THRESHOLD  16      /* roughly 512 bytes */
#define DUK_CALLSTACK_SHRINK_SPARE      8       /* roughly 256 bytes */
#define DUK_CALLSTACK_INITIAL_SIZE      8
#define DUK_CALLSTACK_DEFAULT_MAX       10000L

#define DUK_CATCHSTACK_GROW_STEP         4      /* roughly 64 bytes */
#define DUK_CATCHSTACK_SHRINK_THRESHOLD  8      /* roughly 128 bytes */
#define DUK_CATCHSTACK_SHRINK_SPARE      4      /* roughly 64 bytes */
#define DUK_CATCHSTACK_INITIAL_SIZE      4
#define DUK_CATCHSTACK_DEFAULT_MAX       10000L

/*
 *  Activation defines
 */

#define DUK_ACT_FLAG_STRICT             (1 << 0)  /* function executes in strict mode */
#define DUK_ACT_FLAG_TAILCALLED         (1 << 1)  /* activation has tail called one or more times */
#define DUK_ACT_FLAG_CONSTRUCT          (1 << 2)  /* function executes as a constructor (called via "new") */
#define DUK_ACT_FLAG_PREVENT_YIELD      (1 << 3)  /* activation prevents yield (native call or "new") */
#define DUK_ACT_FLAG_DIRECT_EVAL        (1 << 4)  /* activation is a direct eval call */
#define DUK_ACT_FLAG_BREAKPOINT_ACTIVE  (1 << 5)  /* activation has active breakpoint(s) */

#define DUK_ACT_GET_FUNC(act)        ((act)->func)

/*
 *  Flags for __FILE__ / __LINE__ registered into tracedata
 */

#define DUK_TB_FLAG_NOBLAME_FILELINE   (1 << 0)  /* don't report __FILE__ / __LINE__ as fileName/lineNumber */

/*
 *  Catcher defines
 */

/* flags field: LLLLLLFT, L = label (24 bits), F = flags (4 bits), T = type (4 bits) */
#define DUK_CAT_TYPE_MASK            0x0000000fUL
#define DUK_CAT_TYPE_BITS            4
#define DUK_CAT_LABEL_MASK           0xffffff00UL
#define DUK_CAT_LABEL_BITS           24
#define DUK_CAT_LABEL_SHIFT          8

#define DUK_CAT_FLAG_CATCH_ENABLED          (1 << 4)   /* catch part will catch */
#define DUK_CAT_FLAG_FINALLY_ENABLED        (1 << 5)   /* finally part will catch */
#define DUK_CAT_FLAG_CATCH_BINDING_ENABLED  (1 << 6)   /* request to create catch binding */
#define DUK_CAT_FLAG_LEXENV_ACTIVE          (1 << 7)   /* catch or with binding is currently active */

#define DUK_CAT_TYPE_UNKNOWN         0
#define DUK_CAT_TYPE_TCF             1
#define DUK_CAT_TYPE_LABEL           2

#define DUK_CAT_GET_TYPE(c)          ((c)->flags & DUK_CAT_TYPE_MASK)
#define DUK_CAT_GET_LABEL(c)         (((c)->flags & DUK_CAT_LABEL_MASK) >> DUK_CAT_LABEL_SHIFT)

#define DUK_CAT_HAS_CATCH_ENABLED(c)           ((c)->flags & DUK_CAT_FLAG_CATCH_ENABLED)
#define DUK_CAT_HAS_FINALLY_ENABLED(c)         ((c)->flags & DUK_CAT_FLAG_FINALLY_ENABLED)
#define DUK_CAT_HAS_CATCH_BINDING_ENABLED(c)   ((c)->flags & DUK_CAT_FLAG_CATCH_BINDING_ENABLED)
#define DUK_CAT_HAS_LEXENV_ACTIVE(c)           ((c)->flags & DUK_CAT_FLAG_LEXENV_ACTIVE)

#define DUK_CAT_SET_CATCH_ENABLED(c)    do { \
		(c)->flags |= DUK_CAT_FLAG_CATCH_ENABLED; \
	} while (0)
#define DUK_CAT_SET_FINALLY_ENABLED(c)  do { \
		(c)->flags |= DUK_CAT_FLAG_FINALLY_ENABLED; \
	} while (0)
#define DUK_CAT_SET_CATCH_BINDING_ENABLED(c)    do { \
		(c)->flags |= DUK_CAT_FLAG_CATCH_BINDING_ENABLED; \
	} while (0)
#define DUK_CAT_SET_LEXENV_ACTIVE(c)    do { \
		(c)->flags |= DUK_CAT_FLAG_LEXENV_ACTIVE; \
	} while (0)

#define DUK_CAT_CLEAR_CATCH_ENABLED(c)    do { \
		(c)->flags &= ~DUK_CAT_FLAG_CATCH_ENABLED; \
	} while (0)
#define DUK_CAT_CLEAR_FINALLY_ENABLED(c)  do { \
		(c)->flags &= ~DUK_CAT_FLAG_FINALLY_ENABLED; \
	} while (0)
#define DUK_CAT_CLEAR_CATCH_BINDING_ENABLED(c)    do { \
		(c)->flags &= ~DUK_CAT_FLAG_CATCH_BINDING_ENABLED; \
	} while (0)
#define DUK_CAT_CLEAR_LEXENV_ACTIVE(c)    do { \
		(c)->flags &= ~DUK_CAT_FLAG_LEXENV_ACTIVE; \
	} while (0)

/*
 *  Thread defines
 */

#if defined(DUK_USE_HEAPPTR16)
#define DUK_HTHREAD_GET_STRING(thr,idx) \
	((duk_hstring *) DUK_USE_HEAPPTR_DEC16((thr)->heap->heap_udata, (thr)->strs16[(idx)]))
#else
#define DUK_HTHREAD_GET_STRING(thr,idx) \
	((thr)->strs[(idx)])
#endif

#define DUK_HTHREAD_GET_CURRENT_ACTIVATION(thr)  (&(thr)->callstack[(thr)->callstack_top - 1])

/* values for the state field */
#define DUK_HTHREAD_STATE_INACTIVE     1   /* thread not currently running */
#define DUK_HTHREAD_STATE_RUNNING      2   /* thread currently running (only one at a time) */
#define DUK_HTHREAD_STATE_RESUMED      3   /* thread resumed another thread (active but not running) */
#define DUK_HTHREAD_STATE_YIELDED      4   /* thread has yielded */
#define DUK_HTHREAD_STATE_TERMINATED   5   /* thread has terminated */

/* Executor interrupt default interval when nothing else requires a
 * smaller value.  The default interval must be small enough to allow
 * for reasonable execution timeout checking but large enough to keep
 * impact on execution performance low.
 */
#if defined(DUK_USE_INTERRUPT_COUNTER)
#define DUK_HTHREAD_INTCTR_DEFAULT     (256L * 1024L)
#endif

/*
 *  Assert context is valid: non-NULL pointer, fields look sane.
 *
 *  This is used by public API call entrypoints to catch invalid 'ctx' pointers
 *  as early as possible; invalid 'ctx' pointers cause very odd and difficult to
 *  diagnose behavior so it's worth checking even when the check is not 100%.
 */

#if defined(DUK_USE_PREFER_SIZE)
#define DUK_ASSERT_CTX_VSSIZE(ctx)  /*nop*/
#else
#define DUK_ASSERT_CTX_VSSIZE(ctx) \
	DUK_ASSERT((duk_size_t) (((duk_hthread *) (ctx))->valstack_end - ((duk_hthread *) (ctx))->valstack) == \
		((duk_hthread *) (ctx))->valstack_size)
#endif
#define DUK_ASSERT_CTX_VALID(ctx) do { \
		DUK_ASSERT((ctx) != NULL); \
		DUK_ASSERT(DUK_HEAPHDR_GET_TYPE((duk_heaphdr *) (ctx)) == DUK_HTYPE_OBJECT); \
		DUK_ASSERT(DUK_HOBJECT_IS_THREAD((duk_hobject *) (ctx))); \
		DUK_ASSERT(((duk_hthread *) (ctx))->unused1 == 0); \
		DUK_ASSERT(((duk_hthread *) (ctx))->unused2 == 0); \
		DUK_ASSERT(((duk_hthread *) (ctx))->valstack != NULL); \
		DUK_ASSERT(((duk_hthread *) (ctx))->valstack_end >= ((duk_hthread *) (ctx))->valstack); \
		DUK_ASSERT(((duk_hthread *) (ctx))->valstack_top >= ((duk_hthread *) (ctx))->valstack); \
		DUK_ASSERT(((duk_hthread *) (ctx))->valstack_top >= ((duk_hthread *) (ctx))->valstack_bottom); \
		DUK_ASSERT(((duk_hthread *) (ctx))->valstack_end >= ((duk_hthread *) (ctx))->valstack_top); \
		DUK_ASSERT_CTX_VSSIZE((ctx)); \
	} while (0)

/*
 *  Struct defines
 */

/* XXX: for a memory-code tradeoff, remove 'func' and make it's access either a function
 * or a macro.  This would make the activation 32 bytes long on 32-bit platforms again.
 */

/* Note: it's nice if size is 2^N (at least for 32-bit platforms). */
struct duk_activation {
	duk_tval tv_func;       /* borrowed: full duk_tval for function being executed; for lightfuncs */
	duk_hobject *func;      /* borrowed: function being executed; for bound function calls, this is the final, real function, NULL for lightfuncs */
	duk_hobject *var_env;   /* current variable environment (may be NULL if delayed) */
	duk_hobject *lex_env;   /* current lexical environment (may be NULL if delayed) */
#ifdef DUK_USE_NONSTD_FUNC_CALLER_PROPERTY
	/* Previous value of 'func' caller, restored when unwound.  Only in use
	 * when 'func' is non-strict.
	 */
	duk_hobject *prev_caller;
#endif

	duk_instr_t *curr_pc;   /* next instruction to execute (points to 'func' bytecode, stable pointer), NULL for native calls */
#if defined(DUK_USE_DEBUGGER_SUPPORT)
	duk_uint32_t prev_line; /* needed for stepping */
#endif
	duk_small_uint_t flags;

	/* idx_bottom and idx_retval are only used for book-keeping of
	 * Ecmascript-initiated calls, to allow returning to an Ecmascript
	 * function properly.  They are duk_size_t to match the convention
	 * that value stack sizes are duk_size_t and local frame indices
	 * are duk_idx_t.
	 */

	/* Bottom of valstack for this activation, used to reset
	 * valstack_bottom on return; index is absolute.  Note:
	 * idx_top not needed because top is set to 'nregs' always
	 * when returning to an Ecmascript activation.
	 */
	duk_size_t idx_bottom;

	/* Return value when returning to this activation (points to caller
	 * reg, not callee reg); index is absolute (only set if activation is
	 * not topmost).
	 *
	 * Note: idx_bottom is always set, while idx_retval is only applicable
	 * for activations below the topmost one.  Currently idx_retval for
	 * the topmost activation is considered garbage (and it not initialized
	 * on entry or cleared on return; may contain previous or garbage
	 * values).
	 */
	duk_size_t idx_retval;

	/* Current 'this' binding is the value just below idx_bottom.
	 * Previously, 'this' binding was handled with an index to the
	 * (calling) valstack.  This works for everything except tail
	 * calls, which must not "cumulate" valstack temps.
	 */
};

/* Note: it's nice if size is 2^N (not 4x4 = 16 bytes on 32 bit) */
struct duk_catcher {
	duk_hstring *h_varname;         /* borrowed reference to catch variable name (or NULL if none) */
	                                /* (reference is valid as long activation exists) */
	duk_instr_t *pc_base;           /* resume execution from pc_base or pc_base+1 (points to 'func' bytecode, stable pointer) */
	duk_size_t callstack_index;     /* callstack index of related activation */
	duk_size_t idx_base;            /* idx_base and idx_base+1 get completion value and type */
	duk_uint32_t flags;             /* type and control flags, label number */
};

struct duk_hthread {
	/* Shared object part */
	duk_hobject obj;

	/* Pointer to bytecode executor's 'curr_pc' variable.  Used to copy
	 * the current PC back into the topmost activation when activation
	 * state is about to change (or "syncing" is otherwise needed).  This
	 * is rather awkward but important for performance, see execution.rst.
	 */
	duk_instr_t **ptr_curr_pc;

	/* Backpointers. */
	duk_heap *heap;

	/* Current strictness flag: affects API calls. */
	duk_uint8_t strict;

	/* Thread state. */
	duk_uint8_t state;
	duk_uint8_t unused1;
	duk_uint8_t unused2;

	/* Sanity limits for stack sizes. */
	duk_size_t valstack_max;
	duk_size_t callstack_max;
	duk_size_t catchstack_max;

	/* XXX: Valstack, callstack, and catchstack are currently assumed
	 * to have non-NULL pointers.  Relaxing this would not lead to big
	 * benefits (except perhaps for terminated threads).
	 */

	/* Value stack: these are expressed as pointers for faster stack manipulation.
	 * [valstack,valstack_top[ is GC-reachable, [valstack_top,valstack_end[ is
	 * not GC-reachable but kept initialized as 'undefined'.
	 */
	duk_tval *valstack;                     /* start of valstack allocation */
	duk_tval *valstack_end;                 /* end of valstack allocation (exclusive) */
	duk_tval *valstack_bottom;              /* bottom of current frame */
	duk_tval *valstack_top;                 /* top of current frame (exclusive) */
#if !defined(DUK_USE_PREFER_SIZE)
	duk_size_t valstack_size;               /* cached: valstack_end - valstack (in entries, not bytes) */
#endif

	/* Call stack.  [0,callstack_top[ is GC reachable. */
	duk_activation *callstack;
	duk_size_t callstack_size;              /* allocation size */
	duk_size_t callstack_top;               /* next to use, highest used is top - 1 */
	duk_size_t callstack_preventcount;      /* number of activation records in callstack preventing a yield */

	/* Catch stack.  [0,catchstack_top[ is GC reachable. */
	duk_catcher *catchstack;
	duk_size_t catchstack_size;             /* allocation size */
	duk_size_t catchstack_top;              /* next to use, highest used is top - 1 */

	/* Yield/resume book-keeping. */
	duk_hthread *resumer;                   /* who resumed us (if any) */

	/* Current compiler state (if any), used for augmenting SyntaxErrors. */
	duk_compiler_ctx *compile_ctx;

#if defined(DUK_USE_INTERRUPT_COUNTER)
	/* Interrupt counter for triggering a slow path check for execution
	 * timeout, debugger interaction such as breakpoints, etc.  The value
	 * is valid for the current running thread, and both the init and
	 * counter values are copied whenever a thread switch occurs.  It's
	 * important for the counter to be conveniently accessible for the
	 * bytecode executor inner loop for performance reasons.
	 */
	duk_int_t interrupt_counter;    /* countdown state */
	duk_int_t interrupt_init;       /* start value for current countdown */
#endif

	/* Builtin-objects; may or may not be shared with other threads,
	 * threads existing in different "compartments" will have different
	 * built-ins.  Must be stored on a per-thread basis because there
	 * is no intermediate structure for a thread group / compartment.
	 * This takes quite a lot of space, currently 43x4 = 172 bytes on
	 * 32-bit platforms.
	 */
	duk_hobject *builtins[DUK_NUM_BUILTINS];

	/* Convenience copies from heap/vm for faster access. */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t *strs16;
#else
	duk_hstring **strs;
#endif
};

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL void duk_hthread_copy_builtin_objects(duk_hthread *thr_from, duk_hthread *thr_to);
DUK_INTERNAL_DECL void duk_hthread_create_builtin_objects(duk_hthread *thr);
DUK_INTERNAL_DECL duk_bool_t duk_hthread_init_stacks(duk_heap *heap, duk_hthread *thr);
DUK_INTERNAL_DECL void duk_hthread_terminate(duk_hthread *thr);

DUK_INTERNAL_DECL void duk_hthread_callstack_grow(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_hthread_callstack_shrink_check(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_hthread_callstack_unwind(duk_hthread *thr, duk_size_t new_top);
DUK_INTERNAL_DECL void duk_hthread_catchstack_grow(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_hthread_catchstack_shrink_check(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_hthread_catchstack_unwind(duk_hthread *thr, duk_size_t new_top);

DUK_INTERNAL_DECL duk_activation *duk_hthread_get_current_activation(duk_hthread *thr);
DUK_INTERNAL_DECL void *duk_hthread_get_valstack_ptr(duk_heap *heap, void *ud);  /* indirect allocs */
DUK_INTERNAL_DECL void *duk_hthread_get_callstack_ptr(duk_heap *heap, void *ud);  /* indirect allocs */
DUK_INTERNAL_DECL void *duk_hthread_get_catchstack_ptr(duk_heap *heap, void *ud);  /* indirect allocs */

#if defined(DUK_USE_DEBUGGER_SUPPORT)
DUK_INTERNAL_DECL duk_uint_fast32_t duk_hthread_get_act_curr_pc(duk_hthread *thr, duk_activation *act);
#endif
DUK_INTERNAL_DECL duk_uint_fast32_t duk_hthread_get_act_prev_pc(duk_hthread *thr, duk_activation *act);
DUK_INTERNAL_DECL void duk_hthread_sync_currpc(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_hthread_sync_and_null_currpc(duk_hthread *thr);

#endif  /* DUK_HTHREAD_H_INCLUDED */
#line 1 "duk_hbuffer.h"
/*
 *  Heap buffer representation.
 *
 *  Heap allocated user data buffer which is either:
 *
 *    1. A fixed size buffer (data follows header statically)
 *    2. A dynamic size buffer (data pointer follows header)
 *
 *  The data pointer for a variable size buffer of zero size may be NULL.
 */

#ifndef DUK_HBUFFER_H_INCLUDED
#define DUK_HBUFFER_H_INCLUDED

/*
 *  Flags
 *
 *  Fixed buffer:     0
 *  Dynamic buffer:   DUK_HBUFFER_FLAG_DYNAMIC
 *  External buffer:  DUK_HBUFFER_FLAG_DYNAMIC | DUK_HBUFFER_FLAG_EXTERNAL
 */

#define DUK_HBUFFER_FLAG_DYNAMIC                  DUK_HEAPHDR_USER_FLAG(0)    /* buffer is behind a pointer, dynamic or external */
#define DUK_HBUFFER_FLAG_EXTERNAL                 DUK_HEAPHDR_USER_FLAG(1)    /* buffer pointer is to an externally allocated buffer */

#define DUK_HBUFFER_HAS_DYNAMIC(x)                DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HBUFFER_FLAG_DYNAMIC)
#define DUK_HBUFFER_HAS_EXTERNAL(x)               DUK_HEAPHDR_CHECK_FLAG_BITS(&(x)->hdr, DUK_HBUFFER_FLAG_EXTERNAL)

#define DUK_HBUFFER_SET_DYNAMIC(x)                DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HBUFFER_FLAG_DYNAMIC)
#define DUK_HBUFFER_SET_EXTERNAL(x)               DUK_HEAPHDR_SET_FLAG_BITS(&(x)->hdr, DUK_HBUFFER_FLAG_EXTERNAL)

#define DUK_HBUFFER_CLEAR_DYNAMIC(x)              DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HBUFFER_FLAG_DYNAMIC)
#define DUK_HBUFFER_CLEAR_EXTERNAL(x)             DUK_HEAPHDR_CLEAR_FLAG_BITS(&(x)->hdr, DUK_HBUFFER_FLAG_EXTERNAL)

/*
 *  Misc defines
 */

/* Impose a maximum buffer length for now.  Restricted artificially to
 * ensure resize computations or adding a heap header length won't
 * overflow size_t and that a signed duk_int_t can hold a buffer
 * length.  The limit should be synchronized with DUK_HSTRING_MAX_BYTELEN.
 */

#if defined(DUK_USE_BUFLEN16)
#define DUK_HBUFFER_MAX_BYTELEN                   (0x0000ffffUL)
#else
/* Intentionally not 0x7fffffffUL; at least JSON code expects that
 * 2*len + 2 fits in 32 bits.
 */
#define DUK_HBUFFER_MAX_BYTELEN                   (0x7ffffffeUL)
#endif

/*
 *  Field access
 */

/* Get/set the current user visible size, without accounting for a dynamic
 * buffer's "spare" (= usable size).
 */
#if defined(DUK_USE_BUFLEN16)
/* size stored in duk_heaphdr unused flag bits */
#define DUK_HBUFFER_GET_SIZE(x)     ((x)->hdr.h_flags >> 16)
#define DUK_HBUFFER_SET_SIZE(x,v)   do { \
		(x)->hdr.h_flags = ((x)->hdr.h_flags & 0x0000ffffUL) | ((v) << 16); \
	} while (0)
#define DUK_HBUFFER_ADD_SIZE(x,dv)  do { \
		(x)->hdr.h_flags += ((dv) << 16); \
	} while (0)
#define DUK_HBUFFER_SUB_SIZE(x,dv)  do { \
		(x)->hdr.h_flags -= ((dv) << 16); \
	} while (0)
#else
#define DUK_HBUFFER_GET_SIZE(x)     (((duk_hbuffer *) (x))->size)
#define DUK_HBUFFER_SET_SIZE(x,v)   do { \
		((duk_hbuffer *) (x))->size = (v); \
	} while (0)
#define DUK_HBUFFER_ADD_SIZE(x,dv)  do { \
		(x)->size += (dv); \
	} while (0)
#define DUK_HBUFFER_SUB_SIZE(x,dv)  do { \
		(x)->size -= (dv); \
	} while (0)
#endif

#define DUK_HBUFFER_FIXED_GET_SIZE(x)       DUK_HBUFFER_GET_SIZE((duk_hbuffer *) (x))
#define DUK_HBUFFER_FIXED_SET_SIZE(x,v)     DUK_HBUFFER_SET_SIZE((duk_hbuffer *) (x))

#define DUK_HBUFFER_DYNAMIC_GET_SIZE(x)     DUK_HBUFFER_GET_SIZE((duk_hbuffer *) (x))
#define DUK_HBUFFER_DYNAMIC_SET_SIZE(x,v)   DUK_HBUFFER_SET_SIZE((duk_hbuffer *) (x), (v))
#define DUK_HBUFFER_DYNAMIC_ADD_SIZE(x,dv)  DUK_HBUFFER_ADD_SIZE((duk_hbuffer *) (x), (dv))
#define DUK_HBUFFER_DYNAMIC_SUB_SIZE(x,dv)  DUK_HBUFFER_SUB_SIZE((duk_hbuffer *) (x), (dv))

#define DUK_HBUFFER_EXTERNAL_GET_SIZE(x)    DUK_HBUFFER_GET_SIZE((duk_hbuffer *) (x))
#define DUK_HBUFFER_EXTERNAL_SET_SIZE(x,v)  DUK_HBUFFER_SET_SIZE((duk_hbuffer *) (x), (v))

#define DUK_HBUFFER_FIXED_GET_DATA_PTR(heap,x)    ((duk_uint8_t *) (((duk_hbuffer_fixed *) (x)) + 1))

#if defined(DUK_USE_HEAPPTR16)
#define DUK_HBUFFER_DYNAMIC_GET_DATA_PTR(heap,x) \
	((void *) DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, ((duk_heaphdr *) (x))->h_extra16))
#define DUK_HBUFFER_DYNAMIC_SET_DATA_PTR(heap,x,v)     do { \
		((duk_heaphdr *) (x))->h_extra16 = DUK_USE_HEAPPTR_ENC16((heap)->heap_udata, (void *) (v)); \
	} while (0)
#define DUK_HBUFFER_DYNAMIC_SET_DATA_PTR_NULL(heap,x)  do { \
		((duk_heaphdr *) (x))->h_extra16 = 0;  /* assume 0 <=> NULL */ \
	} while (0)
#else
#define DUK_HBUFFER_DYNAMIC_GET_DATA_PTR(heap,x)       ((x)->curr_alloc)
#define DUK_HBUFFER_DYNAMIC_SET_DATA_PTR(heap,x,v)     do { \
		(x)->curr_alloc = (void *) (v); \
	} while (0)
#define DUK_HBUFFER_DYNAMIC_SET_DATA_PTR_NULL(heap,x)  do { \
		(x)->curr_alloc = (void *) NULL; \
	} while (0)
#endif

/* No pointer compression because pointer is potentially outside of
 * Duktape heap.
 */
#if defined(DUK_USE_HEAPPTR16)
#define DUK_HBUFFER_EXTERNAL_GET_DATA_PTR(heap,x) \
	((void *) (x)->curr_alloc)
#define DUK_HBUFFER_EXTERNAL_SET_DATA_PTR(heap,x,v)     do { \
		(x)->curr_alloc = (void *) (v); \
	} while (0)
#define DUK_HBUFFER_EXTERNAL_SET_DATA_PTR_NULL(heap,x)  do { \
		(x)->curr_alloc = (void *) NULL; \
	} while (0)
#else
#define DUK_HBUFFER_EXTERNAL_GET_DATA_PTR(heap,x) \
	((void *) (x)->curr_alloc)
#define DUK_HBUFFER_EXTERNAL_SET_DATA_PTR(heap,x,v)     do { \
		(x)->curr_alloc = (void *) (v); \
	} while (0)
#define DUK_HBUFFER_EXTERNAL_SET_DATA_PTR_NULL(heap,x)  do { \
		(x)->curr_alloc = (void *) NULL; \
	} while (0)
#endif

/* Get a pointer to the current buffer contents (matching current allocation
 * size).  May be NULL for zero size dynamic/external buffer.
 */
#if defined(DUK_USE_HEAPPTR16)
#define DUK_HBUFFER_GET_DATA_PTR(heap,x)  ( \
	DUK_HBUFFER_HAS_DYNAMIC((x)) ? \
		( \
			DUK_HBUFFER_HAS_EXTERNAL((x)) ? \
				DUK_HBUFFER_EXTERNAL_GET_DATA_PTR((heap), (duk_hbuffer_external *) (x)) : \
				DUK_HBUFFER_DYNAMIC_GET_DATA_PTR((heap), (duk_hbuffer_dynamic *) (x)) \
		) : \
		DUK_HBUFFER_FIXED_GET_DATA_PTR((heap), (duk_hbuffer_fixed *) (x)) \
	)
#else
/* Without heap pointer compression duk_hbuffer_dynamic and duk_hbuffer_external
 * have the same layout so checking for fixed vs. dynamic (or external) is enough.
 */
#define DUK_HBUFFER_GET_DATA_PTR(heap,x)  ( \
	DUK_HBUFFER_HAS_DYNAMIC((x)) ? \
		DUK_HBUFFER_DYNAMIC_GET_DATA_PTR((heap), (duk_hbuffer_dynamic *) (x)) : \
		DUK_HBUFFER_FIXED_GET_DATA_PTR((heap), (duk_hbuffer_fixed *) (x)) \
	)
#endif

/*
 *  Structs
 */

/* Shared prefix for all buffer types. */
struct duk_hbuffer {
	duk_heaphdr hdr;

	/* It's not strictly necessary to track the current size, but
	 * it is useful for writing robust native code.
	 */

	/* Current size (not counting a dynamic buffer's "spare"). */
#if defined(DUK_USE_BUFLEN16)
	/* Stored in duk_heaphdr unused flags. */
#else
	duk_size_t size;
#endif

	/*
	 *  Data following the header depends on the DUK_HBUFFER_FLAG_DYNAMIC
	 *  flag.
	 *
	 *  If the flag is clear (the buffer is a fixed size one), the buffer
	 *  data follows the header directly, consisting of 'size' bytes.
	 *
	 *  If the flag is set, the actual buffer is allocated separately, and
	 *  a few control fields follow the header.  Specifically:
	 *
	 *    - a "void *" pointing to the current allocation
	 *    - a duk_size_t indicating the full allocated size (always >= 'size')
	 *
	 *  If DUK_HBUFFER_FLAG_EXTERNAL is set, the buffer has been allocated
	 *  by user code, so that Duktape won't be able to resize it and won't
	 *  free it.  This allows buffers to point to e.g. an externally
	 *  allocated structure such as a frame buffer.
	 *
	 *  Unlike strings, no terminator byte (NUL) is guaranteed after the
	 *  data.  This would be convenient, but would pad aligned user buffers
	 *  unnecessarily upwards in size.  For instance, if user code requested
	 *  a 64-byte dynamic buffer, 65 bytes would actually be allocated which
	 *  would then potentially round upwards to perhaps 68 or 72 bytes.
	 */
};

/* Fixed buffer; data follows struct, with proper alignment guaranteed by
 * struct size.
 */
#if (DUK_USE_ALIGN_BY == 8) && defined(DUK_USE_PACK_MSVC_PRAGMA)
#pragma pack(push, 8)
#endif
struct duk_hbuffer_fixed {
	/* A union is used here as a portable struct size / alignment trick:
	 * by adding a 32-bit or a 64-bit (unused) union member, the size of
	 * the struct is effectively forced to be a multiple of 4 or 8 bytes
	 * (respectively) without increasing the size of the struct unless
	 * necessary.
	 */
	union {
		struct {
			duk_heaphdr hdr;
#if defined(DUK_USE_BUFLEN16)
			/* Stored in duk_heaphdr unused flags. */
#else
			duk_size_t size;
#endif
		} s;
#if (DUK_USE_ALIGN_BY == 4)
		duk_uint32_t dummy_for_align4;
#elif (DUK_USE_ALIGN_BY == 8)
		duk_double_t dummy_for_align8;
#elif (DUK_USE_ALIGN_BY == 1)
		/* no extra padding */
#else
#error invalid DUK_USE_ALIGN_BY
#endif
	} u;

	/*
	 *  Data follows the struct header.  The struct size is padded by the
	 *  compiler based on the struct members.  This guarantees that the
	 *  buffer data will be aligned-by-4 but not necessarily aligned-by-8.
	 *
	 *  On platforms where alignment does not matter, the struct padding
	 *  could be removed (if there is any).  On platforms where alignment
	 *  by 8 is required, the struct size must be forced to be a multiple
	 *  of 8 by some means.  Without it, some user code may break, and also
	 *  Duktape itself breaks (e.g. the compiler stores duk_tvals in a
	 *  dynamic buffer).
	 */
}
#if (DUK_USE_ALIGN_BY == 8) && defined(DUK_USE_PACK_GCC_ATTR)
__attribute__ ((aligned (8)))
#elif (DUK_USE_ALIGN_BY == 8) && defined(DUK_USE_PACK_CLANG_ATTR)
__attribute__ ((aligned (8)))
#endif
;
#if (DUK_USE_ALIGN_BY == 8) && defined(DUK_USE_PACK_MSVC_PRAGMA)
#pragma pack(pop)
#endif

/* Dynamic buffer with 'curr_alloc' pointing to a dynamic area allocated using
 * heap allocation primitives.  Also used for external buffers when low memory
 * options are not used.
 */
struct duk_hbuffer_dynamic {
	duk_heaphdr hdr;

#if defined(DUK_USE_BUFLEN16)
	/* Stored in duk_heaphdr unused flags. */
#else
	duk_size_t size;
#endif

#if defined(DUK_USE_HEAPPTR16)
	/* Stored in duk_heaphdr h_extra16. */
#else
	void *curr_alloc;  /* may be NULL if alloc_size == 0 */
#endif

	/*
	 *  Allocation size for 'curr_alloc' is alloc_size.  There is no
	 *  automatic NUL terminator for buffers (see above for rationale).
	 *
	 *  'curr_alloc' is explicitly allocated with heap allocation
	 *  primitives and will thus always have alignment suitable for
	 *  e.g. duk_tval and an IEEE double.
	 */
};

/* External buffer with 'curr_alloc' managed by user code and pointing to an
 * arbitrary address.  When heap pointer compression is not used, this struct
 * has the same layout as duk_hbuffer_dynamic.
 */
struct duk_hbuffer_external {
	duk_heaphdr hdr;

#if defined(DUK_USE_BUFLEN16)
	/* Stored in duk_heaphdr unused flags. */
#else
	duk_size_t size;
#endif

	/* Cannot be compressed as a heap pointer because may point to
	 * an arbitrary address.
	 */
	void *curr_alloc;  /* may be NULL if alloc_size == 0 */
};

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL duk_hbuffer *duk_hbuffer_alloc(duk_heap *heap, duk_size_t size, duk_small_uint_t flags, void **out_bufdata);
DUK_INTERNAL_DECL void *duk_hbuffer_get_dynalloc_ptr(duk_heap *heap, void *ud);  /* indirect allocs */

/* dynamic buffer ops */
DUK_INTERNAL_DECL void duk_hbuffer_resize(duk_hthread *thr, duk_hbuffer_dynamic *buf, duk_size_t new_size);
DUK_INTERNAL_DECL void duk_hbuffer_reset(duk_hthread *thr, duk_hbuffer_dynamic *buf);

#endif  /* DUK_HBUFFER_H_INCLUDED */
#line 1 "duk_heap.h"
/*
 *  Heap structure.
 *
 *  Heap contains allocated heap objects, interned strings, and built-in
 *  strings for one or more threads.
 */

#ifndef DUK_HEAP_H_INCLUDED
#define DUK_HEAP_H_INCLUDED

/* alloc function typedefs in duktape.h */

/*
 *  Heap flags
 */

#define DUK_HEAP_FLAG_MARKANDSWEEP_RUNNING                     (1 << 0)  /* mark-and-sweep is currently running */
#define DUK_HEAP_FLAG_MARKANDSWEEP_RECLIMIT_REACHED            (1 << 1)  /* mark-and-sweep marking reached a recursion limit and must use multi-pass marking */
#define DUK_HEAP_FLAG_REFZERO_FREE_RUNNING                     (1 << 2)  /* refcount code is processing refzero list */
#define DUK_HEAP_FLAG_ERRHANDLER_RUNNING                       (1 << 3)  /* an error handler (user callback to augment/replace error) is running */
#define DUK_HEAP_FLAG_INTERRUPT_RUNNING                        (1 << 4)  /* executor interrupt running (used to avoid nested interrupts) */
#define DUK_HEAP_FLAG_FINALIZER_NORESCUE                       (1 << 5)  /* heap destruction ongoing, finalizer rescue no longer possible */

#define DUK__HEAP_HAS_FLAGS(heap,bits)               ((heap)->flags & (bits))
#define DUK__HEAP_SET_FLAGS(heap,bits)  do { \
		(heap)->flags |= (bits); \
	} while (0)
#define DUK__HEAP_CLEAR_FLAGS(heap,bits)  do { \
		(heap)->flags &= ~(bits); \
	} while (0)

#define DUK_HEAP_HAS_MARKANDSWEEP_RUNNING(heap)            DUK__HEAP_HAS_FLAGS((heap), DUK_HEAP_FLAG_MARKANDSWEEP_RUNNING)
#define DUK_HEAP_HAS_MARKANDSWEEP_RECLIMIT_REACHED(heap)   DUK__HEAP_HAS_FLAGS((heap), DUK_HEAP_FLAG_MARKANDSWEEP_RECLIMIT_REACHED)
#define DUK_HEAP_HAS_REFZERO_FREE_RUNNING(heap)            DUK__HEAP_HAS_FLAGS((heap), DUK_HEAP_FLAG_REFZERO_FREE_RUNNING)
#define DUK_HEAP_HAS_ERRHANDLER_RUNNING(heap)              DUK__HEAP_HAS_FLAGS((heap), DUK_HEAP_FLAG_ERRHANDLER_RUNNING)
#define DUK_HEAP_HAS_INTERRUPT_RUNNING(heap)               DUK__HEAP_HAS_FLAGS((heap), DUK_HEAP_FLAG_INTERRUPT_RUNNING)
#define DUK_HEAP_HAS_FINALIZER_NORESCUE(heap)              DUK__HEAP_HAS_FLAGS((heap), DUK_HEAP_FLAG_FINALIZER_NORESCUE)

#define DUK_HEAP_SET_MARKANDSWEEP_RUNNING(heap)            DUK__HEAP_SET_FLAGS((heap), DUK_HEAP_FLAG_MARKANDSWEEP_RUNNING)
#define DUK_HEAP_SET_MARKANDSWEEP_RECLIMIT_REACHED(heap)   DUK__HEAP_SET_FLAGS((heap), DUK_HEAP_FLAG_MARKANDSWEEP_RECLIMIT_REACHED)
#define DUK_HEAP_SET_REFZERO_FREE_RUNNING(heap)            DUK__HEAP_SET_FLAGS((heap), DUK_HEAP_FLAG_REFZERO_FREE_RUNNING)
#define DUK_HEAP_SET_ERRHANDLER_RUNNING(heap)              DUK__HEAP_SET_FLAGS((heap), DUK_HEAP_FLAG_ERRHANDLER_RUNNING)
#define DUK_HEAP_SET_INTERRUPT_RUNNING(heap)               DUK__HEAP_SET_FLAGS((heap), DUK_HEAP_FLAG_INTERRUPT_RUNNING)
#define DUK_HEAP_SET_FINALIZER_NORESCUE(heap)              DUK__HEAP_SET_FLAGS((heap), DUK_HEAP_FLAG_FINALIZER_NORESCUE)

#define DUK_HEAP_CLEAR_MARKANDSWEEP_RUNNING(heap)          DUK__HEAP_CLEAR_FLAGS((heap), DUK_HEAP_FLAG_MARKANDSWEEP_RUNNING)
#define DUK_HEAP_CLEAR_MARKANDSWEEP_RECLIMIT_REACHED(heap) DUK__HEAP_CLEAR_FLAGS((heap), DUK_HEAP_FLAG_MARKANDSWEEP_RECLIMIT_REACHED)
#define DUK_HEAP_CLEAR_REFZERO_FREE_RUNNING(heap)          DUK__HEAP_CLEAR_FLAGS((heap), DUK_HEAP_FLAG_REFZERO_FREE_RUNNING)
#define DUK_HEAP_CLEAR_ERRHANDLER_RUNNING(heap)            DUK__HEAP_CLEAR_FLAGS((heap), DUK_HEAP_FLAG_ERRHANDLER_RUNNING)
#define DUK_HEAP_CLEAR_INTERRUPT_RUNNING(heap)             DUK__HEAP_CLEAR_FLAGS((heap), DUK_HEAP_FLAG_INTERRUPT_RUNNING)
#define DUK_HEAP_CLEAR_FINALIZER_NORESCUE(heap)            DUK__HEAP_CLEAR_FLAGS((heap), DUK_HEAP_FLAG_FINALIZER_NORESCUE)

/*
 *  Longjmp types, also double as identifying continuation type for a rethrow (in 'finally')
 */

#define DUK_LJ_TYPE_UNKNOWN      0    /* unused */
#define DUK_LJ_TYPE_THROW        1    /* value1 -> error object */
#define DUK_LJ_TYPE_YIELD        2    /* value1 -> yield value, iserror -> error / normal */
#define DUK_LJ_TYPE_RESUME       3    /* value1 -> resume value, value2 -> resumee thread, iserror -> error/normal */
#define DUK_LJ_TYPE_BREAK        4    /* value1 -> label number, pseudo-type to indicate a break continuation (for ENDFIN) */
#define DUK_LJ_TYPE_CONTINUE     5    /* value1 -> label number, pseudo-type to indicate a continue continuation (for ENDFIN) */
#define DUK_LJ_TYPE_RETURN       6    /* value1 -> return value, pseudo-type to indicate a return continuation (for ENDFIN) */
#define DUK_LJ_TYPE_NORMAL       7    /* no value, pseudo-type to indicate a normal continuation (for ENDFIN) */

/*
 *  Mark-and-sweep flags
 *
 *  These are separate from heap level flags now but could be merged.
 *  The heap structure only contains a 'base mark-and-sweep flags'
 *  field and the GC caller can impose further flags.
 */

#define DUK_MS_FLAG_EMERGENCY                (1 << 0)   /* emergency mode: try extra hard */
#define DUK_MS_FLAG_NO_STRINGTABLE_RESIZE    (1 << 1)   /* don't resize stringtable (but may sweep it); needed during stringtable resize */
#define DUK_MS_FLAG_NO_OBJECT_COMPACTION     (1 << 2)   /* don't compact objects; needed during object property allocation resize */
#define DUK_MS_FLAG_NO_FINALIZERS            (1 << 3)   /* don't run finalizers; leave finalizable objects in finalize_list for next round */
#define DUK_MS_FLAG_SKIP_FINALIZERS          (1 << 4)   /* don't run finalizers; queue finalizable objects back to heap_allocated */

/*
 *  Thread switching
 *
 *  To switch heap->curr_thread, use the macro below so that interrupt counters
 *  get updated correctly.  The macro allows a NULL target thread because that
 *  happens e.g. in call handling.
 */

#if defined(DUK_USE_INTERRUPT_COUNTER)
#define DUK_HEAP_SWITCH_THREAD(heap,newthr)  duk_heap_switch_thread((heap), (newthr))
#else
#define DUK_HEAP_SWITCH_THREAD(heap,newthr)  do { \
		(heap)->curr_thread = (newthr); \
	} while (0)
#endif

/*
 *  Other heap related defines
 */

/* Mark-and-sweep interval is relative to combined count of objects and
 * strings kept in the heap during the latest mark-and-sweep pass.
 * Fixed point .8 multiplier and .0 adder.  Trigger count (interval) is
 * decreased by each (re)allocation attempt (regardless of size), and each
 * refzero processed object.
 *
 * 'SKIP' indicates how many (re)allocations to wait until a retry if
 * GC is skipped because there is no thread do it with yet (happens
 * only during init phases).
 */
#if defined(DUK_USE_MARK_AND_SWEEP)
#if defined(DUK_USE_REFERENCE_COUNTING)
#define DUK_HEAP_MARK_AND_SWEEP_TRIGGER_MULT              12800L  /* 50x heap size */
#define DUK_HEAP_MARK_AND_SWEEP_TRIGGER_ADD               1024L
#define DUK_HEAP_MARK_AND_SWEEP_TRIGGER_SKIP              256L
#else
#define DUK_HEAP_MARK_AND_SWEEP_TRIGGER_MULT              256L    /* 1x heap size */
#define DUK_HEAP_MARK_AND_SWEEP_TRIGGER_ADD               1024L
#define DUK_HEAP_MARK_AND_SWEEP_TRIGGER_SKIP              256L
#endif
#endif

/* Stringcache is used for speeding up char-offset-to-byte-offset
 * translations for non-ASCII strings.
 */
#define DUK_HEAP_STRCACHE_SIZE                            4
#define DUK_HEAP_STRINGCACHE_NOCACHE_LIMIT                16  /* strings up to the this length are not cached */

/* helper to insert a (non-string) heap object into heap allocated list */
#define DUK_HEAP_INSERT_INTO_HEAP_ALLOCATED(heap,hdr)     duk_heap_insert_into_heap_allocated((heap),(hdr))

/*
 *  Stringtable
 */

/* initial stringtable size, must be prime and higher than DUK_UTIL_MIN_HASH_PRIME */
#define DUK_STRTAB_INITIAL_SIZE            17

/* indicates a deleted string; any fixed non-NULL, non-hstring pointer works */
#define DUK_STRTAB_DELETED_MARKER(heap)    ((duk_hstring *) heap)

/* resizing parameters */
#define DUK_STRTAB_MIN_FREE_DIVISOR        4                /* load factor max 75% */
#define DUK_STRTAB_MIN_USED_DIVISOR        4                /* load factor min 25% */
#define DUK_STRTAB_GROW_ST_SIZE(n)         ((n) + (n))      /* used entries + approx 100% -> reset load to 50% */

#define DUK_STRTAB_U32_MAX_STRLEN          10               /* 4'294'967'295 */
#define DUK_STRTAB_HIGHEST_32BIT_PRIME     0xfffffffbUL

/* probe sequence (open addressing) */
#define DUK_STRTAB_HASH_INITIAL(hash,h_size)    ((hash) % (h_size))
#define DUK_STRTAB_HASH_PROBE_STEP(hash)        DUK_UTIL_GET_HASH_PROBE_STEP((hash))

/* fixed top level hashtable size (separate chaining) */
#define DUK_STRTAB_CHAIN_SIZE              DUK_USE_STRTAB_CHAIN_SIZE

/*
 *  Built-in strings
 */

/* heap string indices are autogenerated in duk_strings.h */
#if defined(DUK_USE_HEAPPTR16)
#define DUK_HEAP_GET_STRING(heap,idx) \
	((duk_hstring *) DUK_USE_HEAPPTR_DEC16((heap)->heap_udata, (heap)->strs16[(idx)]))
#else
#define DUK_HEAP_GET_STRING(heap,idx) \
	((heap)->strs[(idx)])
#endif

/*
 *  Raw memory calls: relative to heap, but no GC interaction
 */

#define DUK_ALLOC_RAW(heap,size) \
	((heap)->alloc_func((heap)->heap_udata, (size)))

#define DUK_REALLOC_RAW(heap,ptr,newsize) \
	((heap)->realloc_func((heap)->heap_udata, (void *) (ptr), (newsize)))

#define DUK_FREE_RAW(heap,ptr) \
	((heap)->free_func((heap)->heap_udata, (void *) (ptr)))

/*
 *  Memory calls: relative to heap, GC interaction, but no error throwing.
 *
 *  XXX: Currently a mark-and-sweep triggered by memory allocation will run
 *  using the heap->heap_thread.  This thread is also used for running
 *  mark-and-sweep finalization; this is not ideal because it breaks the
 *  isolation between multiple global environments.
 *
 *  Notes:
 *
 *    - DUK_FREE() is required to ignore NULL and any other possible return
 *      value of a zero-sized alloc/realloc (same as ANSI C free()).
 *
 *    - There is no DUK_REALLOC_ZEROED because we don't assume to know the
 *      old size.  Caller must zero the reallocated memory.
 *
 *    - DUK_REALLOC_INDIRECT() must be used when a mark-and-sweep triggered
 *      by an allocation failure might invalidate the original 'ptr', thus
 *      causing a realloc retry to use an invalid pointer.  Example: we're
 *      reallocating the value stack and a finalizer resizes the same value
 *      stack during mark-and-sweep.  The indirect variant requests for the
 *      current location of the pointer being reallocated using a callback
 *      right before every realloc attempt; this circuitous approach is used
 *      to avoid strict aliasing issues in a more straightforward indirect
 *      pointer (void **) approach.  Note: the pointer in the storage
 *      location is read but is NOT updated; the caller must do that.
 */

/* callback for indirect reallocs, request for current pointer */
typedef void *(*duk_mem_getptr)(duk_heap *heap, void *ud);

#define DUK_ALLOC(heap,size)                            duk_heap_mem_alloc((heap), (size))
#define DUK_ALLOC_ZEROED(heap,size)                     duk_heap_mem_alloc_zeroed((heap), (size))
#define DUK_REALLOC(heap,ptr,newsize)                   duk_heap_mem_realloc((heap), (ptr), (newsize))
#define DUK_REALLOC_INDIRECT(heap,cb,ud,newsize)        duk_heap_mem_realloc_indirect((heap), (cb), (ud), (newsize))
#define DUK_FREE(heap,ptr)                              duk_heap_mem_free((heap), (ptr))

/*
 *  Memory constants
 */

#define DUK_HEAP_ALLOC_FAIL_MARKANDSWEEP_LIMIT           5   /* Retry allocation after mark-and-sweep for this
                                                              * many times.  A single mark-and-sweep round is
                                                              * not guaranteed to free all unreferenced memory
                                                              * because of finalization (in fact, ANY number of
                                                              * rounds is strictly not enough).
                                                              */

#define DUK_HEAP_ALLOC_FAIL_MARKANDSWEEP_EMERGENCY_LIMIT  3  /* Starting from this round, use emergency mode
                                                              * for mark-and-sweep.
                                                              */

/*
 *  Debugger support
 */

/* Maximum number of breakpoints.  Only breakpoints that are set are
 * consulted so increasing this has no performance impact.
 */
#define DUK_HEAP_MAX_BREAKPOINTS          16

/* Opcode interval for a Date-based status/peek rate limit check.  Only
 * relevant when debugger is attached.  Requesting a timestamp may be a
 * slow operation on some platforms so this shouldn't be too low.  On the
 * other hand a high value makes Duktape react to a pause request slowly.
 */
#define DUK_HEAP_DBG_RATELIMIT_OPCODES    4000

/* Milliseconds between status notify and transport peeks. */
#define DUK_HEAP_DBG_RATELIMIT_MILLISECS  200

/* Step types */
#define DUK_STEP_TYPE_NONE  0
#define DUK_STEP_TYPE_INTO  1
#define DUK_STEP_TYPE_OVER  2
#define DUK_STEP_TYPE_OUT   3

struct duk_breakpoint {
	duk_hstring *filename;
	duk_uint32_t line;
};

#if defined(DUK_USE_DEBUGGER_SUPPORT)
#define DUK_HEAP_IS_DEBUGGER_ATTACHED(heap) ((heap)->dbg_read_cb != NULL)
#define DUK_HEAP_CLEAR_STEP_STATE(heap) do { \
		(heap)->dbg_step_type = DUK_STEP_TYPE_NONE; \
		(heap)->dbg_step_thread = NULL; \
		(heap)->dbg_step_csindex = 0; \
		(heap)->dbg_step_startline = 0; \
	} while (0)
#define DUK_HEAP_SET_PAUSED(heap) do { \
		(heap)->dbg_paused = 1; \
		(heap)->dbg_state_dirty = 1; \
		DUK_HEAP_CLEAR_STEP_STATE((heap)); \
	} while (0)
#define DUK_HEAP_CLEAR_PAUSED(heap) do { \
		(heap)->dbg_paused = 0; \
		(heap)->dbg_state_dirty = 1; \
		DUK_HEAP_CLEAR_STEP_STATE((heap)); \
	} while (0)
#endif  /* DUK_USE_DEBUGGER_SUPPORT */

/*
 *  String cache should ideally be at duk_hthread level, but that would
 *  cause string finalization to slow down relative to the number of
 *  threads; string finalization must check the string cache for "weak"
 *  references to the string being finalized to avoid dead pointers.
 *
 *  Thus, string caches are now at the heap level now.
 */

struct duk_strcache {
	duk_hstring *h;
	duk_uint32_t bidx;
	duk_uint32_t cidx;
};

/*
 *  Longjmp state, contains the information needed to perform a longjmp.
 *  Longjmp related values are written to value1, value2, and iserror.
 */

struct duk_ljstate {
#if !defined(DUK_USE_CPP_EXCEPTIONS)
	duk_jmpbuf *jmpbuf_ptr;   /* current setjmp() catchpoint */
#endif
	duk_small_uint_t type;    /* longjmp type */
	duk_bool_t iserror;       /* isError flag for yield */
	duk_tval value1;          /* 1st related value (type specific) */
	duk_tval value2;          /* 2nd related value (type specific) */
};

/*
 *  Stringtable entry for fixed size stringtable
 */

struct duk_strtab_entry {
#if defined(DUK_USE_HEAPPTR16)
	/* A 16-bit listlen makes sense with 16-bit heap pointers: there
	 * won't be space for 64k strings anyway.
	 */
	duk_uint16_t listlen;  /* if 0, 'str16' used, if > 0, 'strlist16' used */
	union {
		duk_uint16_t strlist16;
		duk_uint16_t str16;
	} u;
#else
	duk_size_t listlen;  /* if 0, 'str' used, if > 0, 'strlist' used */
	union {
		duk_hstring **strlist;
		duk_hstring *str;
	} u;
#endif
};

/*
 *  Main heap structure
 */

struct duk_heap {
	duk_small_uint_t flags;

	/* Allocator functions. */
	duk_alloc_function alloc_func;
	duk_realloc_function realloc_func;
	duk_free_function free_func;

	/* Heap udata, used for allocator functions but also for other heap
	 * level callbacks like pointer compression, etc.
	 */
	void *heap_udata;

	/* Precomputed pointers when using 16-bit heap pointer packing. */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t heapptr_null16;
	duk_uint16_t heapptr_deleted16;
#endif

	/* Fatal error handling, called e.g. when a longjmp() is needed but
	 * lj.jmpbuf_ptr is NULL.  fatal_func must never return; it's not
	 * declared as "noreturn" because doing that for typedefs is a bit
	 * challenging portability-wise.
	 */
	duk_fatal_function fatal_func;

	/* allocated heap objects */
	duk_heaphdr *heap_allocated;

	/* work list for objects whose refcounts are zero but which have not been
	 * "finalized"; avoids recursive C calls when refcounts go to zero in a
	 * chain of objects.
	 */
#if defined(DUK_USE_REFERENCE_COUNTING)
	duk_heaphdr *refzero_list;
	duk_heaphdr *refzero_list_tail;
#endif

#if defined(DUK_USE_MARK_AND_SWEEP)
	/* mark-and-sweep control */
#if defined(DUK_USE_VOLUNTARY_GC)
	duk_int_t mark_and_sweep_trigger_counter;
#endif
	duk_int_t mark_and_sweep_recursion_depth;

	/* mark-and-sweep flags automatically active (used for critical sections) */
	duk_small_uint_t mark_and_sweep_base_flags;

	/* work list for objects to be finalized (by mark-and-sweep) */
	duk_heaphdr *finalize_list;
#endif

	/* longjmp state */
	duk_ljstate lj;

	/* marker for detecting internal "double faults", see duk_error_throw.c */
	duk_bool_t handling_error;

	/* heap thread, used internally and for finalization */
	duk_hthread *heap_thread;

	/* current thread */
	duk_hthread *curr_thread;  /* currently running thread */

	/* heap level "stash" object (e.g., various reachability roots) */
	duk_hobject *heap_object;

	/* duk_handle_call / duk_handle_safe_call recursion depth limiting */
	duk_int_t call_recursion_depth;
	duk_int_t call_recursion_limit;

	/* mix-in value for computing string hashes; should be reasonably unpredictable */
	duk_uint32_t hash_seed;

	/* rnd_state for duk_util_tinyrandom.c */
	duk_uint32_t rnd_state;

	/* For manual debugging: instruction count based on executor and
	 * interrupt counter book-keeping.  Inspect debug logs to see how
	 * they match up.
	 */
#if defined(DUK_USE_INTERRUPT_COUNTER) && defined(DUK_USE_DEBUG)
	duk_int_t inst_count_exec;
	duk_int_t inst_count_interrupt;
#endif

	/* debugger */

#if defined(DUK_USE_DEBUGGER_SUPPORT)
	/* callbacks and udata; dbg_read_cb != NULL is used to indicate attached state */
	duk_debug_read_function dbg_read_cb;                /* required, NULL implies detached */
	duk_debug_write_function dbg_write_cb;              /* required */
	duk_debug_peek_function dbg_peek_cb;
	duk_debug_read_flush_function dbg_read_flush_cb;
	duk_debug_write_flush_function dbg_write_flush_cb;
	duk_debug_detached_function dbg_detached_cb;
	void *dbg_udata;

	/* debugger state, only relevant when attached */
	duk_bool_t dbg_processing;              /* currently processing messages or breakpoints: don't enter message processing recursively (e.g. no breakpoints when processing debugger eval) */
	duk_bool_t dbg_paused;                  /* currently paused: talk with debug client until step/resume */
	duk_bool_t dbg_state_dirty;             /* resend state next time executor is about to run */
	duk_bool_t dbg_force_restart;           /* force executor restart to recheck breakpoints; used to handle function returns (see GH-303) */
	duk_bool_t dbg_detaching;               /* debugger detaching; used to avoid calling detach handler recursively */
	duk_small_uint_t dbg_step_type;         /* step type: none, step into, step over, step out */
	duk_hthread *dbg_step_thread;           /* borrowed; NULL if no step state (NULLed in unwind) */
	duk_size_t dbg_step_csindex;            /* callstack index */
	duk_uint32_t dbg_step_startline;        /* starting line number */
	duk_breakpoint dbg_breakpoints[DUK_HEAP_MAX_BREAKPOINTS];  /* breakpoints: [0,breakpoint_count[ gc reachable */
	duk_small_uint_t dbg_breakpoint_count;
	duk_breakpoint *dbg_breakpoints_active[DUK_HEAP_MAX_BREAKPOINTS + 1];  /* currently active breakpoints: NULL term, borrowed pointers */
	/* XXX: make active breakpoints actual copies instead of pointers? */

	/* These are for rate limiting Status notifications and transport peeking. */
	duk_uint32_t dbg_exec_counter;          /* cumulative opcode execution count (overflows are OK) */
	duk_uint32_t dbg_last_counter;          /* value of dbg_exec_counter when we last did a Date-based check */
	duk_double_t dbg_last_time;             /* time when status/peek was last done (Date-based rate limit) */

	/* Used to support single-byte stream lookahead. */
	duk_bool_t dbg_have_next_byte;
	duk_uint8_t dbg_next_byte;
#endif

	/* string intern table (weak refs) */
#if defined(DUK_USE_STRTAB_PROBE)
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t *strtable16;
#else
	duk_hstring **strtable;
#endif
	duk_uint32_t st_size;     /* alloc size in elements */
	duk_uint32_t st_used;     /* used elements (includes DELETED) */
#endif

	/* XXX: static alloc is OK until separate chaining stringtable
	 * resizing is implemented.
	 */
#if defined(DUK_USE_STRTAB_CHAIN)
	duk_strtab_entry strtable[DUK_STRTAB_CHAIN_SIZE];
#endif

	/* string access cache (codepoint offset -> byte offset) for fast string
	 * character looping; 'weak' reference which needs special handling in GC.
	 */
	duk_strcache strcache[DUK_HEAP_STRCACHE_SIZE];

	/* built-in strings */
#if defined(DUK_USE_HEAPPTR16)
	duk_uint16_t strs16[DUK_HEAP_NUM_STRINGS];
#else
	duk_hstring *strs[DUK_HEAP_NUM_STRINGS];
#endif
};

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL
duk_heap *duk_heap_alloc(duk_alloc_function alloc_func,
                         duk_realloc_function realloc_func,
                         duk_free_function free_func,
                         void *heap_udata,
                         duk_fatal_function fatal_func);
DUK_INTERNAL_DECL void duk_heap_free(duk_heap *heap);
DUK_INTERNAL_DECL void duk_free_hobject_inner(duk_heap *heap, duk_hobject *h);
DUK_INTERNAL_DECL void duk_free_hbuffer_inner(duk_heap *heap, duk_hbuffer *h);
DUK_INTERNAL_DECL void duk_free_hstring_inner(duk_heap *heap, duk_hstring *h);
DUK_INTERNAL_DECL void duk_heap_free_heaphdr_raw(duk_heap *heap, duk_heaphdr *hdr);

DUK_INTERNAL_DECL void duk_heap_insert_into_heap_allocated(duk_heap *heap, duk_heaphdr *hdr);
#if defined(DUK_USE_DOUBLE_LINKED_HEAP) && defined(DUK_USE_REFERENCE_COUNTING)
DUK_INTERNAL_DECL void duk_heap_remove_any_from_heap_allocated(duk_heap *heap, duk_heaphdr *hdr);
#endif
#if defined(DUK_USE_INTERRUPT_COUNTER)
DUK_INTERNAL_DECL void duk_heap_switch_thread(duk_heap *heap, duk_hthread *new_thr);
#endif

#if 0  /*unused*/
DUK_INTERNAL_DECL duk_hstring *duk_heap_string_lookup(duk_heap *heap, const duk_uint8_t *str, duk_uint32_t blen);
#endif
DUK_INTERNAL_DECL duk_hstring *duk_heap_string_intern(duk_heap *heap, const duk_uint8_t *str, duk_uint32_t blen);
DUK_INTERNAL_DECL duk_hstring *duk_heap_string_intern_checked(duk_hthread *thr, const duk_uint8_t *str, duk_uint32_t len);
#if 0  /*unused*/
DUK_INTERNAL_DECL duk_hstring *duk_heap_string_lookup_u32(duk_heap *heap, duk_uint32_t val);
#endif
DUK_INTERNAL_DECL duk_hstring *duk_heap_string_intern_u32(duk_heap *heap, duk_uint32_t val);
DUK_INTERNAL_DECL duk_hstring *duk_heap_string_intern_u32_checked(duk_hthread *thr, duk_uint32_t val);
#if defined(DUK_USE_REFERENCE_COUNTING)
DUK_INTERNAL_DECL void duk_heap_string_remove(duk_heap *heap, duk_hstring *h);
#endif
#if defined(DUK_USE_MARK_AND_SWEEP) && defined(DUK_USE_MS_STRINGTABLE_RESIZE)
DUK_INTERNAL_DECL void duk_heap_force_strtab_resize(duk_heap *heap);
#endif
DUK_INTERNAL void duk_heap_free_strtab(duk_heap *heap);
#if defined(DUK_USE_DEBUG)
DUK_INTERNAL void duk_heap_dump_strtab(duk_heap *heap);
#endif


DUK_INTERNAL_DECL void duk_heap_strcache_string_remove(duk_heap *heap, duk_hstring *h);
DUK_INTERNAL_DECL duk_uint_fast32_t duk_heap_strcache_offset_char2byte(duk_hthread *thr, duk_hstring *h, duk_uint_fast32_t char_offset);

#if defined(DUK_USE_PROVIDE_DEFAULT_ALLOC_FUNCTIONS)
DUK_INTERNAL_DECL void *duk_default_alloc_function(void *udata, duk_size_t size);
DUK_INTERNAL_DECL void *duk_default_realloc_function(void *udata, void *ptr, duk_size_t newsize);
DUK_INTERNAL_DECL void duk_default_free_function(void *udata, void *ptr);
#endif

DUK_INTERNAL_DECL void *duk_heap_mem_alloc(duk_heap *heap, duk_size_t size);
DUK_INTERNAL_DECL void *duk_heap_mem_alloc_zeroed(duk_heap *heap, duk_size_t size);
DUK_INTERNAL_DECL void *duk_heap_mem_realloc(duk_heap *heap, void *ptr, duk_size_t newsize);
DUK_INTERNAL_DECL void *duk_heap_mem_realloc_indirect(duk_heap *heap, duk_mem_getptr cb, void *ud, duk_size_t newsize);
DUK_INTERNAL_DECL void duk_heap_mem_free(duk_heap *heap, void *ptr);

#ifdef DUK_USE_REFERENCE_COUNTING
#if !defined(DUK_USE_FAST_REFCOUNT_DEFAULT)
DUK_INTERNAL_DECL void duk_tval_incref(duk_tval *tv);
#endif
#if 0  /* unused */
DUK_INTERNAL_DECL void duk_tval_incref_allownull(duk_tval *tv);
#endif
DUK_INTERNAL_DECL void duk_tval_decref(duk_hthread *thr, duk_tval *tv);
#if 0  /* unused */
DUK_INTERNAL_DECL void duk_tval_decref_allownull(duk_hthread *thr, duk_tval *tv);
#endif
#if !defined(DUK_USE_FAST_REFCOUNT_DEFAULT)
DUK_INTERNAL_DECL void duk_heaphdr_incref(duk_heaphdr *h);
#endif
#if 0  /* unused */
DUK_INTERNAL_DECL void duk_heaphdr_incref_allownull(duk_heaphdr *h);
#endif
DUK_INTERNAL_DECL void duk_heaphdr_decref(duk_hthread *thr, duk_heaphdr *h);
DUK_INTERNAL_DECL void duk_heaphdr_decref_allownull(duk_hthread *thr, duk_heaphdr *h);
DUK_INTERNAL_DECL void duk_heaphdr_refzero(duk_hthread *thr, duk_heaphdr *h);
DUK_INTERNAL_DECL void duk_heaphdr_refcount_finalize(duk_hthread *thr, duk_heaphdr *hdr);
#else
/* no refcounting */
#endif

#if defined(DUK_USE_MARK_AND_SWEEP)
DUK_INTERNAL_DECL duk_bool_t duk_heap_mark_and_sweep(duk_heap *heap, duk_small_uint_t flags);
#endif

DUK_INTERNAL_DECL duk_uint32_t duk_heap_hashstring(duk_heap *heap, const duk_uint8_t *str, duk_size_t len);

#endif  /* DUK_HEAP_H_INCLUDED */
#line 1 "duk_debugger.h"
#ifndef DUK_DEBUGGER_H_INCLUDED
#define DUK_DEBUGGER_H_INCLUDED

/* Debugger protocol version is defined in the public API header. */

#define DUK_DBG_MARKER_EOM        0x00
#define DUK_DBG_MARKER_REQUEST    0x01
#define DUK_DBG_MARKER_REPLY      0x02
#define DUK_DBG_MARKER_ERROR      0x03
#define DUK_DBG_MARKER_NOTIFY     0x04

#define DUK_DBG_ERR_UNKNOWN       0x00
#define DUK_DBG_ERR_UNSUPPORTED   0x01
#define DUK_DBG_ERR_TOOMANY       0x02
#define DUK_DBG_ERR_NOTFOUND      0x03

/* Initiated by Duktape */
#define DUK_DBG_CMD_STATUS        0x01
#define DUK_DBG_CMD_PRINT         0x02
#define DUK_DBG_CMD_ALERT         0x03
#define DUK_DBG_CMD_LOG           0x04
#define DUK_DBG_CMD_THROW         0x05
#define DUK_DBG_CMD_DETACHING     0x06

/* Initiated by debug client */
#define DUK_DBG_CMD_BASICINFO     0x10
#define DUK_DBG_CMD_TRIGGERSTATUS 0x11
#define DUK_DBG_CMD_PAUSE         0x12
#define DUK_DBG_CMD_RESUME        0x13
#define DUK_DBG_CMD_STEPINTO      0x14
#define DUK_DBG_CMD_STEPOVER      0x15
#define DUK_DBG_CMD_STEPOUT       0x16
#define DUK_DBG_CMD_LISTBREAK     0x17
#define DUK_DBG_CMD_ADDBREAK      0x18
#define DUK_DBG_CMD_DELBREAK      0x19
#define DUK_DBG_CMD_GETVAR        0x1a
#define DUK_DBG_CMD_PUTVAR        0x1b
#define DUK_DBG_CMD_GETCALLSTACK  0x1c
#define DUK_DBG_CMD_GETLOCALS     0x1d
#define DUK_DBG_CMD_EVAL          0x1e
#define DUK_DBG_CMD_DETACH        0x1f
#define DUK_DBG_CMD_DUMPHEAP      0x20
#define DUK_DBG_CMD_GETBYTECODE   0x21

#if defined(DUK_USE_DEBUGGER_SUPPORT)
DUK_INTERNAL_DECL void duk_debug_do_detach(duk_heap *heap);

DUK_INTERNAL_DECL duk_bool_t duk_debug_read_peek(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_debug_write_flush(duk_hthread *thr);

DUK_INTERNAL_DECL void duk_debug_skip_bytes(duk_hthread *thr, duk_size_t length);
DUK_INTERNAL_DECL void duk_debug_skip_byte(duk_hthread *thr);

DUK_INTERNAL_DECL void duk_debug_read_bytes(duk_hthread *thr, duk_uint8_t *data, duk_size_t length);
DUK_INTERNAL_DECL duk_uint8_t duk_debug_read_byte(duk_hthread *thr);
DUK_INTERNAL_DECL duk_int32_t duk_debug_read_int(duk_hthread *thr);
DUK_INTERNAL_DECL duk_hstring *duk_debug_read_hstring(duk_hthread *thr);
/* XXX: exposed duk_debug_read_pointer */
/* XXX: exposed duk_debug_read_buffer */
/* XXX: exposed duk_debug_read_hbuffer */
DUK_INTERNAL_DECL void duk_debug_read_tval(duk_hthread *thr);

DUK_INTERNAL_DECL void duk_debug_write_bytes(duk_hthread *thr, const duk_uint8_t *data, duk_size_t length);
DUK_INTERNAL_DECL void duk_debug_write_byte(duk_hthread *thr, duk_uint8_t x);
DUK_INTERNAL_DECL void duk_debug_write_unused(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_debug_write_undefined(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_debug_write_int(duk_hthread *thr, duk_int32_t x);
DUK_INTERNAL_DECL void duk_debug_write_uint(duk_hthread *thr, duk_uint32_t x);
DUK_INTERNAL_DECL void duk_debug_write_string(duk_hthread *thr, const char *data, duk_size_t length);
DUK_INTERNAL_DECL void duk_debug_write_cstring(duk_hthread *thr, const char *data);
DUK_INTERNAL_DECL void duk_debug_write_hstring(duk_hthread *thr, duk_hstring *h);
DUK_INTERNAL_DECL void duk_debug_write_buffer(duk_hthread *thr, const char *data, duk_size_t length);
DUK_INTERNAL_DECL void duk_debug_write_hbuffer(duk_hthread *thr, duk_hbuffer *h);
DUK_INTERNAL_DECL void duk_debug_write_pointer(duk_hthread *thr, void *ptr);
#if defined(DUK_USE_DEBUGGER_DUMPHEAP)
DUK_INTERNAL_DECL void duk_debug_write_heapptr(duk_hthread *thr, duk_heaphdr *h);
#endif
DUK_INTERNAL_DECL void duk_debug_write_hobject(duk_hthread *thr, duk_hobject *obj);
DUK_INTERNAL_DECL void duk_debug_write_tval(duk_hthread *thr, duk_tval *tv);

#if 0  /* unused */
DUK_INTERNAL_DECL void duk_debug_write_request(duk_hthread *thr, duk_small_uint_t command);
#endif
DUK_INTERNAL_DECL void duk_debug_write_reply(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_debug_write_error_eom(duk_hthread *thr, duk_small_uint_t err_code, const char *msg);
DUK_INTERNAL_DECL void duk_debug_write_notify(duk_hthread *thr, duk_small_uint_t command);
DUK_INTERNAL_DECL void duk_debug_write_eom(duk_hthread *thr);

DUK_INTERNAL_DECL duk_uint_fast32_t duk_debug_curr_line(duk_hthread *thr);
DUK_INTERNAL_DECL void duk_debug_send_status(duk_hthread *thr);
#if defined(DUK_USE_DEBUGGER_THROW_NOTIFY)
DUK_INTERNAL_DECL void duk_debug_send_throw(duk_hthread *thr, duk_bool_t fatal);
#endif

DUK_INTERNAL_DECL void duk_debug_halt_execution(duk_hthread *thr, duk_bool_t use_prev_pc);
DUK_INTERNAL_DECL duk_bool_t duk_debug_process_messages(duk_hthread *thr, duk_bool_t no_block);

DUK_INTERNAL_DECL duk_small_int_t duk_debug_add_breakpoint(duk_hthread *thr, duk_hstring *filename, duk_uint32_t line);
DUK_INTERNAL_DECL duk_bool_t duk_debug_remove_breakpoint(duk_hthread *thr, duk_small_uint_t breakpoint_index);
#endif

#endif  /* DUK_DEBUGGER_H_INCLUDED */
#line 1 "duk_debug.h"
/*
 *  Debugging macros, DUK_DPRINT() and its variants in particular.
 *
 *  DUK_DPRINT() allows formatted debug prints, and supports standard
 *  and Duktape specific formatters.  See duk_debug_vsnprintf.c for details.
 *
 *  DUK_D(x), DUK_DD(x), and DUK_DDD(x) are used together with log macros
 *  for technical reasons.  They are concretely used to hide 'x' from the
 *  compiler when the corresponding log level is disabled.  This allows
 *  clean builds on non-C99 compilers, at the cost of more verbose code.
 *  Examples:
 *
 *    DUK_D(DUK_DPRINT("foo"));
 *    DUK_DD(DUK_DDPRINT("foo"));
 *    DUK_DDD(DUK_DDDPRINT("foo"));
 *
 *  This approach is preferable to the old "double parentheses" hack because
 *  double parentheses make the C99 solution worse: __FILE__ and __LINE__ can
 *  no longer be added transparently without going through globals, which
 *  works poorly with threading.
 */

#ifndef DUK_DEBUG_H_INCLUDED
#define DUK_DEBUG_H_INCLUDED

#ifdef DUK_USE_DEBUG

#if defined(DUK_USE_DPRINT)
#define DUK_D(x) x
#else
#define DUK_D(x) do { } while (0) /* omit */
#endif

#if defined(DUK_USE_DDPRINT)
#define DUK_DD(x) x
#else
#define DUK_DD(x) do { } while (0) /* omit */
#endif

#if defined(DUK_USE_DDDPRINT)
#define DUK_DDD(x) x
#else
#define DUK_DDD(x) do { } while (0) /* omit */
#endif

/*
 *  Exposed debug macros: debugging enabled
 */

#define DUK_LEVEL_DEBUG    1
#define DUK_LEVEL_DDEBUG   2
#define DUK_LEVEL_DDDEBUG  3

#ifdef DUK_USE_VARIADIC_MACROS

/* Note: combining __FILE__, __LINE__, and __func__ into fmt would be
 * possible compile time, but waste some space with shared function names.
 */
#define DUK__DEBUG_LOG(lev,...)  duk_debug_log((duk_small_int_t) (lev), DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, DUK_FUNC_MACRO, __VA_ARGS__);

#define DUK_DPRINT(...)          DUK__DEBUG_LOG(DUK_LEVEL_DEBUG, __VA_ARGS__)

#ifdef DUK_USE_DDPRINT
#define DUK_DDPRINT(...)         DUK__DEBUG_LOG(DUK_LEVEL_DDEBUG, __VA_ARGS__)
#else
#define DUK_DDPRINT(...)
#endif

#ifdef DUK_USE_DDDPRINT
#define DUK_DDDPRINT(...)        DUK__DEBUG_LOG(DUK_LEVEL_DDDEBUG, __VA_ARGS__)
#else
#define DUK_DDDPRINT(...)
#endif

#else  /* DUK_USE_VARIADIC_MACROS */

#define DUK__DEBUG_STASH(lev)    \
	(void) DUK_SNPRINTF(duk_debug_file_stash, DUK_DEBUG_STASH_SIZE, "%s", (const char *) DUK_FILE_MACRO), \
	duk_debug_file_stash[DUK_DEBUG_STASH_SIZE - 1] = (char) 0; \
	(void) DUK_SNPRINTF(duk_debug_line_stash, DUK_DEBUG_STASH_SIZE, "%ld", (long) DUK_LINE_MACRO), \
	duk_debug_line_stash[DUK_DEBUG_STASH_SIZE - 1] = (char) 0; \
	(void) DUK_SNPRINTF(duk_debug_func_stash, DUK_DEBUG_STASH_SIZE, "%s", (const char *) DUK_FUNC_MACRO), \
	duk_debug_func_stash[DUK_DEBUG_STASH_SIZE - 1] = (char) 0; \
	(void) (duk_debug_level_stash = (lev))

/* Without variadic macros resort to comma expression trickery to handle debug
 * prints.  This generates a lot of harmless warnings.  These hacks are not
 * needed normally because DUK_D() and friends will hide the entire debug log
 * statement from the compiler.
 */

#ifdef DUK_USE_DPRINT
#define DUK_DPRINT  DUK__DEBUG_STASH(DUK_LEVEL_DEBUG), (void) duk_debug_log  /* args go here in parens */
#else
#define DUK_DPRINT  0 && /* args go here as a comma expression in parens */
#endif

#ifdef DUK_USE_DDPRINT
#define DUK_DDPRINT  DUK__DEBUG_STASH(DUK_LEVEL_DDEBUG), (void) duk_debug_log  /* args go here in parens */
#else
#define DUK_DDPRINT  0 && /* args */
#endif

#ifdef DUK_USE_DDDPRINT
#define DUK_DDDPRINT  DUK__DEBUG_STASH(DUK_LEVEL_DDDEBUG), (void) duk_debug_log  /* args go here in parens */
#else
#define DUK_DDDPRINT  0 && /* args */
#endif

#endif  /* DUK_USE_VARIADIC_MACROS */

#else  /* DUK_USE_DEBUG */

/*
 *  Exposed debug macros: debugging disabled
 */

#define DUK_D(x) do { } while (0) /* omit */
#define DUK_DD(x) do { } while (0) /* omit */
#define DUK_DDD(x) do { } while (0) /* omit */

#ifdef DUK_USE_VARIADIC_MACROS

#define DUK_DPRINT(...)
#define DUK_DDPRINT(...)
#define DUK_DDDPRINT(...)

#else  /* DUK_USE_VARIADIC_MACROS */

#define DUK_DPRINT    0 && /* args go here as a comma expression in parens */
#define DUK_DDPRINT   0 && /* args */
#define DUK_DDDPRINT  0 && /* args */

#endif  /* DUK_USE_VARIADIC_MACROS */

#endif  /* DUK_USE_DEBUG */

/*
 *  Structs
 */

#ifdef DUK_USE_DEBUG
struct duk_fixedbuffer {
	duk_uint8_t *buffer;
	duk_size_t length;
	duk_size_t offset;
	duk_bool_t truncated;
};
#endif

/*
 *  Prototypes
 */

#ifdef DUK_USE_DEBUG
DUK_INTERNAL_DECL duk_int_t duk_debug_vsnprintf(char *str, duk_size_t size, const char *format, va_list ap);
#if 0  /*unused*/
DUK_INTERNAL_DECL duk_int_t duk_debug_snprintf(char *str, duk_size_t size, const char *format, ...);
#endif
DUK_INTERNAL_DECL void duk_debug_format_funcptr(char *buf, duk_size_t buf_size, duk_uint8_t *fptr, duk_size_t fptr_size);

#ifdef DUK_USE_VARIADIC_MACROS
DUK_INTERNAL_DECL void duk_debug_log(duk_small_int_t level, const char *file, duk_int_t line, const char *func, const char *fmt, ...);
#else  /* DUK_USE_VARIADIC_MACROS */
/* parameter passing, not thread safe */
#define DUK_DEBUG_STASH_SIZE  128
#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL char duk_debug_file_stash[DUK_DEBUG_STASH_SIZE];
DUK_INTERNAL_DECL char duk_debug_line_stash[DUK_DEBUG_STASH_SIZE];
DUK_INTERNAL_DECL char duk_debug_func_stash[DUK_DEBUG_STASH_SIZE];
DUK_INTERNAL_DECL duk_small_int_t duk_debug_level_stash;
#endif
DUK_INTERNAL_DECL void duk_debug_log(const char *fmt, ...);
#endif  /* DUK_USE_VARIADIC_MACROS */

DUK_INTERNAL_DECL void duk_fb_put_bytes(duk_fixedbuffer *fb, const duk_uint8_t *buffer, duk_size_t length);
DUK_INTERNAL_DECL void duk_fb_put_byte(duk_fixedbuffer *fb, duk_uint8_t x);
DUK_INTERNAL_DECL void duk_fb_put_cstring(duk_fixedbuffer *fb, const char *x);
DUK_INTERNAL_DECL void duk_fb_sprintf(duk_fixedbuffer *fb, const char *fmt, ...);
DUK_INTERNAL_DECL void duk_fb_put_funcptr(duk_fixedbuffer *fb, duk_uint8_t *fptr, duk_size_t fptr_size);
DUK_INTERNAL_DECL duk_bool_t duk_fb_is_full(duk_fixedbuffer *fb);

#endif  /* DUK_USE_DEBUG */

#endif  /* DUK_DEBUG_H_INCLUDED */
#line 1 "duk_error.h"
/*
 *  Error handling macros, assertion macro, error codes.
 *
 *  There are three level of 'errors':
 *
 *    1. Ordinary errors, relative to a thread, cause a longjmp, catchable.
 *    2. Fatal errors, relative to a heap, cause fatal handler to be called.
 *    3. Panic errors, unrelated to a heap and cause a process exit.
 *
 *  Panics are used by the default fatal error handler and by debug code
 *  such as assertions.  By providing a proper fatal error handler, user
 *  code can avoid panics in non-debug builds.
 */

#ifndef DUK_ERROR_H_INCLUDED
#define DUK_ERROR_H_INCLUDED

/*
 *  Error codes: defined in duktape.h
 *
 *  Error codes are used as a shorthand to throw exceptions from inside
 *  the implementation.  The appropriate Ecmascript object is constructed
 *  based on the code.  Ecmascript code throws objects directly.  The error
 *  codes are defined in the public API header because they are also used
 *  by calling code.
 */

/*
 *  Normal error
 *
 *  Normal error is thrown with a longjmp() through the current setjmp()
 *  catchpoint record in the duk_heap.  The 'curr_thread' of the duk_heap
 *  identifies the throwing thread.
 *
 *  Error formatting is not always necessary but there are no separate calls
 *  (to minimize code size).  Error object creation will consume a considerable
 *  amount of time, compared to which formatting is probably trivial.  Note
 *  that special formatting (provided by DUK_DEBUG macros) is NOT available.
 *
 *  The _RAW variants allow the caller to specify file and line.  This makes
 *  it easier to write checked calls which want to use the call site of the
 *  checked function, not the error macro call inside the checked function.
 *
 *  We prefer the standard variadic macros; if they are not available, we
 *  fall back to awkward hacks.
 */

#if defined(DUK_USE_VERBOSE_ERRORS)

#if defined(DUK_USE_VARIADIC_MACROS)

/* __VA_ARGS__ has comma issues for empty lists, so we mandate at least 1 argument for '...' (format string) */
#define DUK_ERROR(thr,err,...)                    duk_err_handle_error(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr), (err), __VA_ARGS__)
#define DUK_ERROR_RAW(file,line,thr,err,...)      duk_err_handle_error((file), (line), (thr), (err), __VA_ARGS__)

#else  /* DUK_USE_VARIADIC_MACROS */

/* Parameter passing here is not thread safe.  We rely on the __FILE__
 * pointer being a constant which can be passed through a global.
 */

#define DUK_ERROR  \
	(void) (duk_err_file_stash = (const char *) DUK_FILE_MACRO, \
	        duk_err_line_stash = (duk_int_t) DUK_LINE_MACRO, \
	        duk_err_handle_error_stash)  /* arguments follow */
#define DUK_ERROR_RAW                             duk_err_handle_error

#endif  /* DUK_USE_VARIADIC_MACROS */

#else  /* DUK_USE_VERBOSE_ERRORS */

#if defined(DUK_USE_VARIADIC_MACROS)

#define DUK_ERROR(thr,err,...)                    duk_err_handle_error((thr), (err))
#define DUK_ERROR_RAW(file,line,thr,err,...)      duk_err_handle_error((thr), (err))

#else  /* DUK_USE_VARIADIC_MACROS */

/* This is sub-optimal because arguments will be passed but ignored, and the strings
 * will go into the object file.  Can't think of how to do this portably and still
 * relatively conveniently.
 */
#define DUK_ERROR                                 duk_err_handle_error_nonverbose1
#define DUK_ERROR_RAW                             duk_err_handle_error_nonverbose2

#endif  /* DUK_USE_VARIADIC_MACROS */

#endif  /* DUK_USE_VERBOSE_ERRORS */

/*
 *  Fatal error
 *
 *  There are no fatal error macros at the moment.  There are so few call
 *  sites that the fatal error handler is called directly.
 */

/*
 *  Panic error
 *
 *  Panic errors are not relative to either a heap or a thread, and cause
 *  DUK_PANIC() macro to be invoked.  Unless a user provides DUK_USE_PANIC_HANDLER,
 *  DUK_PANIC() calls a helper which prints out the error and causes a process
 *  exit.
 *
 *  The user can override the macro to provide custom handling.  A macro is
 *  used to allow the user to have inline panic handling if desired (without
 *  causing a potentially risky function call).
 *
 *  Panics are only used in debug code such as assertions, and by the default
 *  fatal error handler.
 */

#if defined(DUK_USE_PANIC_HANDLER)
/* already defined, good */
#define DUK_PANIC(code,msg)  DUK_USE_PANIC_HANDLER((code),(msg))
#else
#define DUK_PANIC(code,msg)  duk_default_panic_handler((code),(msg))
#endif  /* DUK_USE_PANIC_HANDLER */

/*
 *  Assert macro: failure causes panic.
 */

#if defined(DUK_USE_ASSERTIONS)

/* the message should be a compile time constant without formatting (less risk);
 * we don't care about assertion text size because they're not used in production
 * builds.
 */
#define DUK_ASSERT(x)  do { \
	if (!(x)) { \
		DUK_PANIC(DUK_ERR_ASSERTION_ERROR, \
			"assertion failed: " #x \
			" (" DUK_FILE_MACRO ":" DUK_MACRO_STRINGIFY(DUK_LINE_MACRO) ")"); \
	} \
	} while (0)

/* Assertion compatible inside a comma expression, evaluates to void.
 * Currently not compatible with DUK_USE_PANIC_HANDLER() which may have
 * a statement block.
 */
#if defined(DUK_USE_PANIC_HANDLER)
/* XXX: resolve macro definition issue or call through a helper function? */
#define DUK_ASSERT_EXPR(x)  ((void) 0)
#else
#define DUK_ASSERT_EXPR(x) \
	((void) ((x) ? 0 : (DUK_PANIC(DUK_ERR_ASSERTION_ERROR, \
				"assertion failed: " #x \
				" (" DUK_FILE_MACRO ":" DUK_MACRO_STRINGIFY(DUK_LINE_MACRO) ")"), 0)))
#endif

#else  /* DUK_USE_ASSERTIONS */

#define DUK_ASSERT(x)  do { /* assertion omitted */ } while (0)

#define DUK_ASSERT_EXPR(x)  ((void) 0)

#endif  /* DUK_USE_ASSERTIONS */

/* this variant is used when an assert would generate a compile warning by
 * being always true (e.g. >= 0 comparison for an unsigned value
 */
#define DUK_ASSERT_DISABLE(x)  do { /* assertion disabled */ } while (0)

/*
 *  Assertion helpers
 */

#if defined(DUK_USE_ASSERTIONS) && defined(DUK_USE_REFERENCE_COUNTING)
#define DUK_ASSERT_REFCOUNT_NONZERO_HEAPHDR(h)  do { \
		DUK_ASSERT((h) == NULL || DUK_HEAPHDR_GET_REFCOUNT((duk_heaphdr *) (h)) > 0); \
	} while (0)
#define DUK_ASSERT_REFCOUNT_NONZERO_TVAL(tv)  do { \
		if ((tv) != NULL && DUK_TVAL_IS_HEAP_ALLOCATED((tv))) { \
			DUK_ASSERT(DUK_HEAPHDR_GET_REFCOUNT(DUK_TVAL_GET_HEAPHDR((tv))) > 0); \
		} \
	} while (0)
#else
#define DUK_ASSERT_REFCOUNT_NONZERO_HEAPHDR(h)  /* no refcount check */
#define DUK_ASSERT_REFCOUNT_NONZERO_TVAL(tv)    /* no refcount check */
#endif

#define DUK_ASSERT_TOP(ctx,n)  DUK_ASSERT((duk_idx_t) duk_get_top((ctx)) == (duk_idx_t) (n))

#if defined(DUK_USE_ASSERTIONS) && defined(DUK_USE_PACKED_TVAL)
#define DUK_ASSERT_DOUBLE_IS_NORMALIZED(dval)  do { \
		duk_double_union duk__assert_tmp_du; \
		duk__assert_tmp_du.d = (dval); \
		DUK_ASSERT(DUK_DBLUNION_IS_NORMALIZED(&duk__assert_tmp_du)); \
	} while (0)
#else
#define DUK_ASSERT_DOUBLE_IS_NORMALIZED(dval)  /* nop */
#endif

/*
 *  Helper for valstack space
 *
 *  Caller of DUK_ASSERT_VALSTACK_SPACE() estimates the number of free stack entries
 *  required for its own use, and any child calls which are not (a) Duktape API calls
 *  or (b) Duktape calls which involve extending the valstack (e.g. getter call).
 */

#define DUK_VALSTACK_ASSERT_EXTRA  5  /* this is added to checks to allow for Duktape
                                       * API calls in addition to function's own use
                                       */
#if defined(DUK_USE_ASSERTIONS)
#define DUK_ASSERT_VALSTACK_SPACE(thr,n)   do { \
		DUK_ASSERT((thr) != NULL); \
		DUK_ASSERT((thr)->valstack_end - (thr)->valstack_top >= (n) + DUK_VALSTACK_ASSERT_EXTRA); \
	} while (0)
#else
#define DUK_ASSERT_VALSTACK_SPACE(thr,n)   /* no valstack space check */
#endif

/*
 *  Error throwing helpers
 *
 *  The goal is to provide verbose and configurable error messages.  Call
 *  sites should be clean in source code and compile to a small footprint.
 *  Small footprint is also useful for performance because small cold paths
 *  reduce code cache pressure.
 */

#if defined(DUK_USE_VERBOSE_ERRORS)
#if defined(DUK_USE_PARANOID_ERRORS)
/* Verbose but paranoid errors. */

#define DUK_ERROR_REQUIRE_TYPE_INDEX(thr,index,expectname,lowmemstr) do { \
		duk_err_require_type_index(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr), (index), (expectname)); \
	} while (0)
#else
/* Verbose errors with key/value summaries. */

#define DUK_ERROR_REQUIRE_TYPE_INDEX(thr,index,expectname,lowmemstr) do { \
		duk_err_require_type_index(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr), (index), (expectname)); \
	} while (0)
#endif
#define DUK_ERROR_API_INDEX(thr,index) do { \
		duk_err_api_index(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr), (index)); \
	} while (0)
#define DUK_ERROR_API(thr,msg) do { \
		duk_err_api(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr), (msg)); \
	} while (0)
#else
/* Non-verbose errors for low memory targets. */

#define DUK_ERROR_REQUIRE_TYPE_INDEX(thr,index,expectname,lowmemstr) do { \
		duk_err_require_type_index(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr), (lowmemstr)); \
	} while (0)
#define DUK_ERROR_API_INDEX(thr,index) do { \
		duk_err_api_index(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr)); \
	} while (0)
#define DUK_ERROR_API(thr,msg) do { \
		duk_err_api(DUK_FILE_MACRO, (duk_int_t) DUK_LINE_MACRO, (thr), (msg)); \
	} while (0)
#endif

/*
 *  Prototypes
 */

#if defined(DUK_USE_VERBOSE_ERRORS)
#if defined(DUK_USE_VARIADIC_MACROS)
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_handle_error(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, ...));
#else  /* DUK_USE_VARIADIC_MACROS */
#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL const char *duk_err_file_stash;
DUK_INTERNAL_DECL duk_int_t duk_err_line_stash;
#endif  /* !DUK_SINGLE_FILE */
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_handle_error(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, ...));
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_handle_error_stash(duk_hthread *thr, duk_errcode_t code, const char *fmt, ...));
#endif  /* DUK_USE_VARIADIC_MACROS */
#else  /* DUK_USE_VERBOSE_ERRORS */
#if defined(DUK_USE_VARIADIC_MACROS)
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_handle_error(duk_hthread *thr, duk_errcode_t code));
#else  /* DUK_USE_VARIADIC_MACROS */
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_handle_error_nonverbose1(duk_hthread *thr, duk_errcode_t code, const char *fmt, ...));
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_handle_error_nonverbose2(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, ...));
#endif  /* DUK_USE_VARIADIC_MACROS */
#endif  /* DUK_USE_VERBOSE_ERRORS */

#if defined(DUK_USE_VERBOSE_ERRORS)
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_create_and_throw(duk_hthread *thr, duk_errcode_t code, const char *msg, const char *filename, duk_int_t line));
#else
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_create_and_throw(duk_hthread *thr, duk_errcode_t code));
#endif

DUK_NORETURN(DUK_INTERNAL_DECL void duk_error_throw_from_negative_rc(duk_hthread *thr, duk_ret_t rc));

#if defined(DUK_USE_AUGMENT_ERROR_CREATE)
DUK_INTERNAL_DECL void duk_err_augment_error_create(duk_hthread *thr, duk_hthread *thr_callstack, const char *filename, duk_int_t line, duk_bool_t noblame_fileline);
#endif
#if defined(DUK_USE_AUGMENT_ERROR_THROW)
DUK_INTERNAL_DECL void duk_err_augment_error_throw(duk_hthread *thr);
#endif

#if defined(DUK_USE_VERBOSE_ERRORS)
#if defined(DUK_USE_PARANOID_ERRORS)
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_require_type_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, duk_idx_t index, const char *expect_name));
#else
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_require_type_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, duk_idx_t index, const char *expect_name));
#endif
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_api_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, duk_idx_t index));
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_api(const char *filename, duk_int_t linenumber, duk_hthread *thr, const char *message));
#else
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_require_type_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, const char *error_msg));
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_api_index(const char *filename, duk_int_t linenumber, duk_hthread *thr));
DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_api(const char *filename, duk_int_t linenumber, duk_hthread *thr, const char *message));
#endif

DUK_NORETURN(DUK_INTERNAL_DECL void duk_err_longjmp(duk_hthread *thr));

DUK_NORETURN(DUK_INTERNAL_DECL void duk_default_fatal_handler(duk_context *ctx, duk_errcode_t code, const char *msg));

#if !defined(DUK_USE_PANIC_HANDLER)
DUK_NORETURN(DUK_INTERNAL_DECL void duk_default_panic_handler(duk_errcode_t code, const char *msg));
#endif

DUK_INTERNAL_DECL void duk_err_setup_heap_ljstate(duk_hthread *thr, duk_small_int_t lj_type);

DUK_INTERNAL_DECL duk_hobject *duk_error_prototype_from_code(duk_hthread *thr, duk_errcode_t err_code);

#endif  /* DUK_ERROR_H_INCLUDED */
#line 1 "duk_unicode.h"
/*
 *  Unicode helpers
 */

#ifndef DUK_UNICODE_H_INCLUDED
#define DUK_UNICODE_H_INCLUDED

/*
 *  UTF-8 / XUTF-8 / CESU-8 constants
 */

#define DUK_UNICODE_MAX_XUTF8_LENGTH      7   /* up to 36 bit codepoints */
#define DUK_UNICODE_MAX_XUTF8_BMP_LENGTH  3   /* all codepoints up to U+FFFF */
#define DUK_UNICODE_MAX_CESU8_LENGTH      6   /* all codepoints up to U+10FFFF */
#define DUK_UNICODE_MAX_CESU8_BMP_LENGTH  3   /* all codepoints up to U+FFFF */

/*
 *  Useful Unicode codepoints
 *
 *  Integer constants must be signed to avoid unexpected coercions
 *  in comparisons.
 */

#define DUK_UNICODE_CP_ZWNJ                   0x200cL  /* zero-width non-joiner */
#define DUK_UNICODE_CP_ZWJ                    0x200dL  /* zero-width joiner */
#define DUK_UNICODE_CP_REPLACEMENT_CHARACTER  0xfffdL  /* http://en.wikipedia.org/wiki/Replacement_character#Replacement_character */

/*
 *  ASCII character constants
 *
 *  C character literals like 'x' have a platform specific value and do
 *  not match ASCII (UTF-8) values on e.g. EBCDIC platforms.  So, use
 *  these (admittedly awkward) constants instead.  These constants must
 *  also have signed values to avoid unexpected coercions in comparisons.
 *
 *  http://en.wikipedia.org/wiki/ASCII
 */

#define DUK_ASC_NUL              0x00
#define DUK_ASC_SOH              0x01
#define DUK_ASC_STX              0x02
#define DUK_ASC_ETX              0x03
#define DUK_ASC_EOT              0x04
#define DUK_ASC_ENQ              0x05
#define DUK_ASC_ACK              0x06
#define DUK_ASC_BEL              0x07
#define DUK_ASC_BS               0x08
#define DUK_ASC_HT               0x09
#define DUK_ASC_LF               0x0a
#define DUK_ASC_VT               0x0b
#define DUK_ASC_FF               0x0c
#define DUK_ASC_CR               0x0d
#define DUK_ASC_SO               0x0e
#define DUK_ASC_SI               0x0f
#define DUK_ASC_DLE              0x10
#define DUK_ASC_DC1              0x11
#define DUK_ASC_DC2              0x12
#define DUK_ASC_DC3              0x13
#define DUK_ASC_DC4              0x14
#define DUK_ASC_NAK              0x15
#define DUK_ASC_SYN              0x16
#define DUK_ASC_ETB              0x17
#define DUK_ASC_CAN              0x18
#define DUK_ASC_EM               0x19
#define DUK_ASC_SUB              0x1a
#define DUK_ASC_ESC              0x1b
#define DUK_ASC_FS               0x1c
#define DUK_ASC_GS               0x1d
#define DUK_ASC_RS               0x1e
#define DUK_ASC_US               0x1f
#define DUK_ASC_SPACE            0x20
#define DUK_ASC_EXCLAMATION      0x21
#define DUK_ASC_DOUBLEQUOTE      0x22
#define DUK_ASC_HASH             0x23
#define DUK_ASC_DOLLAR           0x24
#define DUK_ASC_PERCENT          0x25
#define DUK_ASC_AMP              0x26
#define DUK_ASC_SINGLEQUOTE      0x27
#define DUK_ASC_LPAREN           0x28
#define DUK_ASC_RPAREN           0x29
#define DUK_ASC_STAR             0x2a
#define DUK_ASC_PLUS             0x2b
#define DUK_ASC_COMMA            0x2c
#define DUK_ASC_MINUS            0x2d
#define DUK_ASC_PERIOD           0x2e
#define DUK_ASC_SLASH            0x2f
#define DUK_ASC_0                0x30
#define DUK_ASC_1                0x31
#define DUK_ASC_2                0x32
#define DUK_ASC_3                0x33
#define DUK_ASC_4                0x34
#define DUK_ASC_5                0x35
#define DUK_ASC_6                0x36
#define DUK_ASC_7                0x37
#define DUK_ASC_8                0x38
#define DUK_ASC_9                0x39
#define DUK_ASC_COLON            0x3a
#define DUK_ASC_SEMICOLON        0x3b
#define DUK_ASC_LANGLE           0x3c
#define DUK_ASC_EQUALS           0x3d
#define DUK_ASC_RANGLE           0x3e
#define DUK_ASC_QUESTION         0x3f
#define DUK_ASC_ATSIGN           0x40
#define DUK_ASC_UC_A             0x41
#define DUK_ASC_UC_B             0x42
#define DUK_ASC_UC_C             0x43
#define DUK_ASC_UC_D             0x44
#define DUK_ASC_UC_E             0x45
#define DUK_ASC_UC_F             0x46
#define DUK_ASC_UC_G             0x47
#define DUK_ASC_UC_H             0x48
#define DUK_ASC_UC_I             0x49
#define DUK_ASC_UC_J             0x4a
#define DUK_ASC_UC_K             0x4b
#define DUK_ASC_UC_L             0x4c
#define DUK_ASC_UC_M             0x4d
#define DUK_ASC_UC_N             0x4e
#define DUK_ASC_UC_O             0x4f
#define DUK_ASC_UC_P             0x50
#define DUK_ASC_UC_Q             0x51
#define DUK_ASC_UC_R             0x52
#define DUK_ASC_UC_S             0x53
#define DUK_ASC_UC_T             0x54
#define DUK_ASC_UC_U             0x55
#define DUK_ASC_UC_V             0x56
#define DUK_ASC_UC_W             0x57
#define DUK_ASC_UC_X             0x58
#define DUK_ASC_UC_Y             0x59
#define DUK_ASC_UC_Z             0x5a
#define DUK_ASC_LBRACKET         0x5b
#define DUK_ASC_BACKSLASH        0x5c
#define DUK_ASC_RBRACKET         0x5d
#define DUK_ASC_CARET            0x5e
#define DUK_ASC_UNDERSCORE       0x5f
#define DUK_ASC_GRAVE            0x60
#define DUK_ASC_LC_A             0x61
#define DUK_ASC_LC_B             0x62
#define DUK_ASC_LC_C             0x63
#define DUK_ASC_LC_D             0x64
#define DUK_ASC_LC_E             0x65
#define DUK_ASC_LC_F             0x66
#define DUK_ASC_LC_G             0x67
#define DUK_ASC_LC_H             0x68
#define DUK_ASC_LC_I             0x69
#define DUK_ASC_LC_J             0x6a
#define DUK_ASC_LC_K             0x6b
#define DUK_ASC_LC_L             0x6c
#define DUK_ASC_LC_M             0x6d
#define DUK_ASC_LC_N             0x6e
#define DUK_ASC_LC_O             0x6f
#define DUK_ASC_LC_P             0x70
#define DUK_ASC_LC_Q             0x71
#define DUK_ASC_LC_R             0x72
#define DUK_ASC_LC_S             0x73
#define DUK_ASC_LC_T             0x74
#define DUK_ASC_LC_U             0x75
#define DUK_ASC_LC_V             0x76
#define DUK_ASC_LC_W             0x77
#define DUK_ASC_LC_X             0x78
#define DUK_ASC_LC_Y             0x79
#define DUK_ASC_LC_Z             0x7a
#define DUK_ASC_LCURLY           0x7b
#define DUK_ASC_PIPE             0x7c
#define DUK_ASC_RCURLY           0x7d
#define DUK_ASC_TILDE            0x7e
#define DUK_ASC_DEL              0x7f

/*
 *  Unicode tables
 */

#ifdef DUK_USE_SOURCE_NONBMP
/*
 *  Automatically generated by extract_chars.py, do not edit!
 */

extern const duk_uint8_t duk_unicode_ids_noa[791];
#else
/*
 *  Automatically generated by extract_chars.py, do not edit!
 */

extern const duk_uint8_t duk_unicode_ids_noabmp[611];
#endif

#ifdef DUK_USE_SOURCE_NONBMP
/*
 *  Automatically generated by extract_chars.py, do not edit!
 */

extern const duk_uint8_t duk_unicode_ids_m_let_noa[42];
#else
/*
 *  Automatically generated by extract_chars.py, do not edit!
 */

extern const duk_uint8_t duk_unicode_ids_m_let_noabmp[24];
#endif

#ifdef DUK_USE_SOURCE_NONBMP
/*
 *  Automatically generated by extract_chars.py, do not edit!
 */

extern const duk_uint8_t duk_unicode_idp_m_ids_noa[397];
#else
/*
 *  Automatically generated by extract_chars.py, do not edit!
 */

extern const duk_uint8_t duk_unicode_idp_m_ids_noabmp[348];
#endif

/*
 *  Automatically generated by extract_caseconv.py, do not edit!
 */

extern const duk_uint8_t duk_unicode_caseconv_uc[1288];
extern const duk_uint8_t duk_unicode_caseconv_lc[616];

#if defined(DUK_USE_REGEXP_CANON_WORKAROUND)
/*
 *  Automatically generated by extract_caseconv.py, do not edit!
 */

extern const duk_uint16_t duk_unicode_re_canon_lookup[65536];
#endif

/*
 *  Extern
 */

/* duk_unicode_support.c */
#if !defined(DUK_SINGLE_FILE)
DUK_INTERNAL_DECL duk_uint8_t duk_unicode_xutf8_markers[7];
DUK_INTERNAL_DECL duk_uint16_t duk_unicode_re_ranges_digit[2];
DUK_INTERNAL_DECL duk_uint16_t duk_unicode_re_ranges_white[22];
DUK_INTERNAL_DECL duk_uint16_t duk_unicode_re_ranges_wordchar[8];
DUK_INTERNAL_DECL duk_uint16_t duk_unicode_re_ranges_not_digit[4];
DUK_INTERNAL_DECL duk_uint16_t duk_unicode_re_ranges_not_white[24];
DUK_INTERNAL_DECL duk_uint16_t duk_unicode_re_ranges_not_wordchar[10];
#endif  /* !DUK_SINGLE_FILE */

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL duk_small_int_t duk_unicode_get_xutf8_length(duk_ucodepoint_t cp);
#if defined(DUK_USE_ASSERTIONS)
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_get_cesu8_length(duk_ucodepoint_t cp);
#endif
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_encode_xutf8(duk_ucodepoint_t cp, duk_uint8_t *out);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_encode_cesu8(duk_ucodepoint_t cp, duk_uint8_t *out);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_decode_xutf8(duk_hthread *thr, const duk_uint8_t **ptr, const duk_uint8_t *ptr_start, const duk_uint8_t *ptr_end, duk_ucodepoint_t *out_cp);
DUK_INTERNAL_DECL duk_ucodepoint_t duk_unicode_decode_xutf8_checked(duk_hthread *thr, const duk_uint8_t **ptr, const duk_uint8_t *ptr_start, const duk_uint8_t *ptr_end);
DUK_INTERNAL_DECL duk_size_t duk_unicode_unvalidated_utf8_length(const duk_uint8_t *data, duk_size_t blen);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_is_whitespace(duk_codepoint_t cp);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_is_line_terminator(duk_codepoint_t cp);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_is_identifier_start(duk_codepoint_t cp);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_is_identifier_part(duk_codepoint_t cp);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_is_letter(duk_codepoint_t cp);
DUK_INTERNAL_DECL void duk_unicode_case_convert_string(duk_hthread *thr, duk_bool_t uppercase);
DUK_INTERNAL_DECL duk_codepoint_t duk_unicode_re_canonicalize_char(duk_hthread *thr, duk_codepoint_t cp);
DUK_INTERNAL_DECL duk_small_int_t duk_unicode_re_is_wordchar(duk_codepoint_t cp);

#endif  /* DUK_UNICODE_H_INCLUDED */
#line 1 "duk_json.h"
/*
 *  Defines for JSON, especially duk_bi_json.c.
 */

#ifndef DUK_JSON_H_INCLUDED
#define DUK_JSON_H_INCLUDED

/* Encoding/decoding flags */
#define DUK_JSON_FLAG_ASCII_ONLY              (1 << 0)  /* escape any non-ASCII characters */
#define DUK_JSON_FLAG_AVOID_KEY_QUOTES        (1 << 1)  /* avoid key quotes when key is an ASCII Identifier */
#define DUK_JSON_FLAG_EXT_CUSTOM              (1 << 2)  /* extended types: custom encoding */
#define DUK_JSON_FLAG_EXT_COMPATIBLE          (1 << 3)  /* extended types: compatible encoding */

/* How much stack to require on entry to object/array encode */
#define DUK_JSON_ENC_REQSTACK                 32

/* How much stack to require on entry to object/array decode */
#define DUK_JSON_DEC_REQSTACK                 32

/* How large a loop detection stack to use */
#define DUK_JSON_ENC_LOOPARRAY                64

/* Encoding state.  Heap object references are all borrowed. */
typedef struct {
	duk_hthread *thr;
	duk_bufwriter_ctx bw;        /* output bufwriter */
	duk_hobject *h_replacer;     /* replacer function */
	duk_hstring *h_gap;          /* gap (if empty string, NULL) */
	duk_idx_t idx_proplist;      /* explicit PropertyList */
	duk_idx_t idx_loop;          /* valstack index of loop detection object */
	duk_small_uint_t flags;
	duk_small_uint_t flag_ascii_only;
	duk_small_uint_t flag_avoid_key_quotes;
#if defined(DUK_USE_JX) || defined(DUK_USE_JC)
	duk_small_uint_t flag_ext_custom;
	duk_small_uint_t flag_ext_compatible;
	duk_small_uint_t flag_ext_custom_or_compatible;
#endif
	duk_int_t recursion_depth;
	duk_int_t recursion_limit;
	duk_uint_t mask_for_undefined;      /* type bit mask: types which certainly produce 'undefined' */
#if defined(DUK_USE_JX) || defined(DUK_USE_JC)
	duk_small_uint_t stridx_custom_undefined;
	duk_small_uint_t stridx_custom_nan;
	duk_small_uint_t stridx_custom_neginf;
	duk_small_uint_t stridx_custom_posinf;
	duk_small_uint_t stridx_custom_function;
#endif
	duk_hobject *visiting[DUK_JSON_ENC_LOOPARRAY];  /* indexed by recursion_depth */
} duk_json_enc_ctx;

typedef struct {
	duk_hthread *thr;
	const duk_uint8_t *p;
	const duk_uint8_t *p_start;
	const duk_uint8_t *p_end;
	duk_idx_t idx_reviver;
	duk_small_uint_t flags;
#if defined(DUK_USE_JX) || defined(DUK_USE_JC)
	duk_small_uint_t flag_ext_custom;
	duk_small_uint_t flag_ext_compatible;
	duk_small_uint_t flag_ext_custom_or_compatible;
#endif
	duk_int_t recursion_depth;
	duk_int_t recursion_limit;
} duk_json_dec_ctx;

#endif  /* DUK_JSON_H_INCLUDED */
#line 1 "duk_js.h"
/*
 *  Ecmascript execution, support primitives.
 */

#ifndef DUK_JS_H_INCLUDED
#define DUK_JS_H_INCLUDED

/* Flags for call handling. */
#define DUK_CALL_FLAG_IGNORE_RECLIMIT        (1 << 0)  /* duk_handle_call_xxx: call ignores C recursion limit (for errhandler calls) */
#define DUK_CALL_FLAG_CONSTRUCTOR_CALL       (1 << 1)  /* duk_handle_call_xxx: constructor call (i.e. called as 'new Foo()') */
#define DUK_CALL_FLAG_IS_RESUME              (1 << 2)  /* duk_handle_ecma_call_setup: setup for a resume() */
#define DUK_CALL_FLAG_IS_TAILCALL            (1 << 3)  /* duk_handle_ecma_call_setup: setup for a tail call */
#define DUK_CALL_FLAG_DIRECT_EVAL            (1 << 4)  /* call is a direct eval call */

/* Flags for duk_js_equals_helper(). */
#define DUK_EQUALS_FLAG_SAMEVALUE            (1 << 0)  /* use SameValue instead of non-strict equality */
#define DUK_EQUALS_FLAG_STRICT               (1 << 1)  /* use strict equality instead of non-strict equality */

/* Flags for duk_js_compare_helper(). */
#define DUK_COMPARE_FLAG_EVAL_LEFT_FIRST     (1 << 0)  /* eval left argument first */
#define DUK_COMPARE_FLAG_NEGATE              (1 << 1)  /* negate result */

/* conversions, coercions, comparison, etc */
DUK_INTERNAL_DECL duk_bool_t duk_js_toboolean(duk_tval *tv);
DUK_INTERNAL_DECL duk_double_t duk_js_tonumber(duk_hthread *thr, duk_tval *tv);
DUK_INTERNAL_DECL duk_double_t duk_js_tointeger_number(duk_double_t x);
DUK_INTERNAL_DECL duk_double_t duk_js_tointeger(duk_hthread *thr, duk_tval *tv);
DUK_INTERNAL_DECL duk_uint32_t duk_js_touint32(duk_hthread *thr, duk_tval *tv);
DUK_INTERNAL_DECL duk_int32_t duk_js_toint32(duk_hthread *thr, duk_tval *tv);
DUK_INTERNAL_DECL duk_uint16_t duk_js_touint16(duk_hthread *thr, duk_tval *tv);
DUK_INTERNAL_DECL duk_small_int_t duk_js_to_arrayindex_raw_string(const duk_uint8_t *str, duk_uint32_t blen, duk_uarridx_t *out_idx);
DUK_INTERNAL_DECL duk_uarridx_t duk_js_to_arrayindex_string_helper(duk_hstring *h);
DUK_INTERNAL_DECL duk_bool_t duk_js_equals_helper(duk_hthread *thr, duk_tval *tv_x, duk_tval *tv_y, duk_small_int_t flags);
DUK_INTERNAL_DECL duk_small_int_t duk_js_data_compare(const duk_uint8_t *buf1, const duk_uint8_t *buf2, duk_size_t len1, duk_size_t len2);
DUK_INTERNAL_DECL duk_small_int_t duk_js_string_compare(duk_hstring *h1, duk_hstring *h2);
#if 0  /* unused */
DUK_INTERNAL_DECL duk_small_int_t duk_js_buffer_compare(duk_heap *heap, duk_hbuffer *h1, duk_hbuffer *h2);
#endif
DUK_INTERNAL_DECL duk_bool_t duk_js_compare_helper(duk_hthread *thr, duk_tval *tv_x, duk_tval *tv_y, duk_small_int_t flags);
DUK_INTERNAL_DECL duk_bool_t duk_js_instanceof(duk_hthread *thr, duk_tval *tv_x, duk_tval *tv_y);
DUK_INTERNAL_DECL duk_bool_t duk_js_in(duk_hthread *thr, duk_tval *tv_x, duk_tval *tv_y);
DUK_INTERNAL_DECL duk_hstring *duk_js_typeof(duk_hthread *thr, duk_tval *tv_x);

#define duk_js_equals(thr,tv_x,tv_y) \
	duk_js_equals_helper((thr), (tv_x), (tv_y), 0)
#define duk_js_strict_equals(tv_x,tv_y) \
	duk_js_equals_helper(NULL, (tv_x), (tv_y), DUK_EQUALS_FLAG_STRICT)
#define duk_js_samevalue(tv_x,tv_y) \
	duk_js_equals_helper(NULL, (tv_x), (tv_y), DUK_EQUALS_FLAG_SAMEVALUE)

/* E5 Sections 11.8.1, 11.8.5; x < y */
#define duk_js_lessthan(thr,tv_x,tv_y) \
	duk_js_compare_helper((thr), (tv_x), (tv_Y), DUK_COMPARE_FLAG_EVAL_LEFT_FIRST)

/* E5 Sections 11.8.2, 11.8.5; x > y  -->  y < x */
#define duk_js_greaterthan(thr,tv_x,tv_y) \
	duk_js_compare_helper((thr), (tv_y), (tv_x), 0)

/* E5 Sections 11.8.3, 11.8.5; x <= y  -->  not (x > y)  -->  not (y < x) */
#define duk_js_lessthanorequal(thr,tv_x,tv_y) \
	duk_js_compare_helper((thr), (tv_y), (tv_x), DUK_COMPARE_FLAG_NEGATE)

/* E5 Sections 11.8.4, 11.8.5; x >= y  -->  not (x < y) */
#define duk_js_greaterthanorequal(thr,tv_x,tv_y) \
	duk_js_compare_helper((thr), (tv_x), (tv_y), DUK_COMPARE_FLAG_EVAL_LEFT_FIRST | DUK_COMPARE_FLAG_NEGATE)

/* identifiers and environment handling */
#if 0  /*unused*/
DUK_INTERNAL duk_bool_t duk_js_hasvar_envrec(duk_hthread *thr, duk_hobject *env, duk_hstring *name);
#endif
DUK_INTERNAL_DECL duk_bool_t duk_js_getvar_envrec(duk_hthread *thr, duk_hobject *env, duk_hstring *name, duk_bool_t throw_flag);
DUK_INTERNAL_DECL duk_bool_t duk_js_getvar_activation(duk_hthread *thr, duk_activation *act, duk_hstring *name, duk_bool_t throw_flag);
DUK_INTERNAL_DECL void duk_js_putvar_envrec(duk_hthread *thr, duk_hobject *env, duk_hstring *name, duk_tval *val, duk_bool_t strict);
DUK_INTERNAL_DECL void duk_js_putvar_activation(duk_hthread *thr, duk_activation *act, duk_hstring *name, duk_tval *val, duk_bool_t strict);
#if 0  /*unused*/
DUK_INTERNAL_DECL duk_bool_t duk_js_delvar_envrec(duk_hthread *thr, duk_hobject *env, duk_hstring *name);
#endif
DUK_INTERNAL_DECL duk_bool_t duk_js_delvar_activation(duk_hthread *thr, duk_activation *act, duk_hstring *name);
DUK_INTERNAL_DECL duk_bool_t duk_js_declvar_activation(duk_hthread *thr, duk_activation *act, duk_hstring *name, duk_tval *val, duk_small_int_t prop_flags, duk_bool_t is_func_decl);
DUK_INTERNAL_DECL void duk_js_init_activation_environment_records_delayed(duk_hthread *thr, duk_activation *act);
DUK_INTERNAL_DECL void duk_js_close_environment_record(duk_hthread *thr, duk_hobject *env, duk_hobject *func, duk_size_t regbase);
DUK_INTERNAL_DECL duk_hobject *duk_create_activation_environment_record(duk_hthread *thr, duk_hobject *func, duk_size_t idx_bottom);
DUK_INTERNAL_DECL
void duk_js_push_closure(duk_hthread *thr,
                         duk_hcompiledfunction *fun_temp,
                         duk_hobject *outer_var_env,
                         duk_hobject *outer_lex_env);

/* call handling */
DUK_INTERNAL_DECL duk_int_t duk_handle_call_protected(duk_hthread *thr, duk_idx_t num_stack_args, duk_small_uint_t call_flags);
DUK_INTERNAL_DECL void duk_handle_call_unprotected(duk_hthread *thr, duk_idx_t num_stack_args, duk_small_uint_t call_flags);
DUK_INTERNAL_DECL duk_int_t duk_handle_safe_call(duk_hthread *thr, duk_safe_call_function func, duk_idx_t num_stack_args, duk_idx_t num_stack_res);
DUK_INTERNAL_DECL duk_bool_t duk_handle_ecma_call_setup(duk_hthread *thr, duk_idx_t num_stack_args, duk_small_uint_t call_flags);

/* bytecode execution */
DUK_INTERNAL_DECL void duk_js_execute_bytecode(duk_hthread *exec_thr);

#endif  /* DUK_JS_H_INCLUDED */
#line 1 "duk_numconv.h"
#ifndef DUK_NUMCONV_H_INCLUDED
#define DUK_NUMCONV_H_INCLUDED

/*
 *  Number-to-string conversion.  The semantics of these is very tightly
 *  bound with the Ecmascript semantics required for call sites.
 */

/* Output a specified number of digits instead of using the shortest
 * form.  Used for toPrecision() and toFixed().
 */
#define DUK_N2S_FLAG_FIXED_FORMAT         (1 << 0)

/* Force exponential format.  Used for toExponential(). */
#define DUK_N2S_FLAG_FORCE_EXP            (1 << 1)

/* If number would need zero padding (for whole number part), use
 * exponential format instead.  E.g. if input number is 12300, 3
 * digits are generated ("123"), output "1.23e+4" instead of "12300".
 * Used for toPrecision().
 */
#define DUK_N2S_FLAG_NO_ZERO_PAD          (1 << 2)

/* Digit count indicates number of fractions (i.e. an absolute
 * digit index instead of a relative one).  Used together with
 * DUK_N2S_FLAG_FIXED_FORMAT for toFixed().
 */
#define DUK_N2S_FLAG_FRACTION_DIGITS      (1 << 3)

/*
 *  String-to-number conversion
 */

/* Maximum exponent value when parsing numbers.  This is not strictly
 * compliant as there should be no upper limit, but as we parse the
 * exponent without a bigint, impose some limit.
 */
#define DUK_S2N_MAX_EXPONENT              1000000000

/* Trim white space (= allow leading and trailing whitespace) */
#define DUK_S2N_FLAG_TRIM_WHITE           (1 << 0)

/* Allow exponent */
#define DUK_S2N_FLAG_ALLOW_EXP            (1 << 1)

/* Allow trailing garbage (e.g. treat "123foo" as "123) */
#define DUK_S2N_FLAG_ALLOW_GARBAGE        (1 << 2)

/* Allow leading plus sign */
#define DUK_S2N_FLAG_ALLOW_PLUS           (1 << 3)

/* Allow leading minus sign */
#define DUK_S2N_FLAG_ALLOW_MINUS          (1 << 4)

/* Allow 'Infinity' */
#define DUK_S2N_FLAG_ALLOW_INF            (1 << 5)

/* Allow fraction part */
#define DUK_S2N_FLAG_ALLOW_FRAC           (1 << 6)

/* Allow naked fraction (e.g. ".123") */
#define DUK_S2N_FLAG_ALLOW_NAKED_FRAC     (1 << 7)

/* Allow empty fraction (e.g. "123.") */
#define DUK_S2N_FLAG_ALLOW_EMPTY_FRAC     (1 << 8)

/* Allow empty string to be interpreted as 0 */
#define DUK_S2N_FLAG_ALLOW_EMPTY_AS_ZERO  (1 << 9)

/* Allow leading zeroes (e.g. "0123" -> "123") */
#define DUK_S2N_FLAG_ALLOW_LEADING_ZERO   (1 << 10)

/* Allow automatic detection of hex base ("0x" or "0X" prefix),
 * overrides radix argument and forces integer mode.
 */
#define DUK_S2N_FLAG_ALLOW_AUTO_HEX_INT   (1 << 11)

/* Allow automatic detection of octal base, overrides radix
 * argument and forces integer mode.
 */
#define DUK_S2N_FLAG_ALLOW_AUTO_OCT_INT   (1 << 12)

/*
 *  Prototypes
 */

DUK_INTERNAL_DECL void duk_numconv_stringify(duk_context *ctx, duk_small_int_t radix, duk_small_int_t digits, duk_small_uint_t flags);
DUK_INTERNAL_DECL void duk_numconv_parse(duk_context *ctx, duk_small_int_t radix, duk_small_uint_t flags);

#endif  /* DUK_NUMCONV_H_INCLUDED */
#line 1 "duk_bi_protos.h"
/*
 *  Prototypes for all built-in functions.
 */

#ifndef DUK_BUILTIN_PROTOS_H_INCLUDED
#define DUK_BUILTIN_PROTOS_H_INCLUDED

/* Buffer size needed for duk_bi_date_format_timeval().
 * Accurate value is 32 + 1 for NUL termination:
 *   >>> len('+123456-01-23T12:34:56.123+12:34')
 *   32
 * Include additional space to be safe.
 */
#define  DUK_BI_DATE_ISO8601_BUFSIZE  48

/* Maximum length of CommonJS module identifier to resolve.  Length includes
 * both current module ID, requested (possibly relative) module ID, and a
 * slash in between.
 */
#define  DUK_BI_COMMONJS_MODULE_ID_LIMIT  256

DUK_INTERNAL_DECL duk_ret_t duk_bi_array_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_constructor_is_array(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_to_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_concat(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_join_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_pop(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_push(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_reverse(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_shift(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_slice(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_sort(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_splice(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_unshift(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_indexof_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_iter_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_array_prototype_reduce_shared(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_boolean_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_boolean_prototype_tostring_shared(duk_context *ctx);

/* XXX: naming is inconsistent with other builtins, "prototype" not used as
 * part of function name.
 */
DUK_INTERNAL_DECL duk_ret_t duk_bi_buffer_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_buffer_prototype_tostring_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_buffer_readfield(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_buffer_writefield(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_buffer_compare_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_buffer_slice_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_arraybuffer_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_arraybuffer_isview(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_dataview_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_typedarray_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_typedarray_set(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_concat(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_is_encoding(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_is_buffer(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_byte_length(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_tostring(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_tojson(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_fill(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_copy(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_nodejs_buffer_write(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_date_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_constructor_parse(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_constructor_utc(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_constructor_now(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_prototype_tostring_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_prototype_value_of(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_prototype_to_json(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_prototype_get_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_prototype_get_timezone_offset(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_prototype_set_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_date_prototype_set_time(duk_context *ctx);
/* Helpers exposed for internal use */
DUK_INTERNAL_DECL void duk_bi_date_timeval_to_parts(duk_double_t d, duk_int_t *parts, duk_double_t *dparts, duk_small_uint_t flags);
DUK_INTERNAL_DECL duk_double_t duk_bi_date_get_timeval_from_dparts(duk_double_t *dparts, duk_small_uint_t flags);
DUK_INTERNAL_DECL void duk_bi_date_format_timeval(duk_double_t timeval, duk_uint8_t *out_buf);
DUK_INTERNAL_DECL duk_bool_t duk_bi_date_is_leap_year(duk_int_t year);
DUK_INTERNAL_DECL duk_bool_t duk_bi_date_timeval_in_valid_range(duk_double_t x);
DUK_INTERNAL_DECL duk_bool_t duk_bi_date_year_in_valid_range(duk_double_t year);
DUK_INTERNAL_DECL duk_bool_t duk_bi_date_timeval_in_leeway_range(duk_double_t x);
/* Built-in providers */
#if defined(DUK_USE_DATE_NOW_GETTIMEOFDAY)
DUK_INTERNAL_DECL duk_double_t duk_bi_date_get_now_gettimeofday(duk_context *ctx);
#endif
#if defined(DUK_USE_DATE_NOW_TIME)
DUK_INTERNAL_DECL duk_double_t duk_bi_date_get_now_time(duk_context *ctx);
#endif
#if defined(DUK_USE_DATE_NOW_WINDOWS)
DUK_INTERNAL_DECL duk_double_t duk_bi_date_get_now_windows(duk_context *ctx);
#endif
#if defined(DUK_USE_DATE_TZO_GMTIME_R) || defined(DUK_USE_DATE_TZO_GMTIME)
DUK_INTERNAL_DECL duk_int_t duk_bi_date_get_local_tzoffset_gmtime(duk_double_t d);
#endif
#if defined(DUK_USE_DATE_TZO_WINDOWS)
DUK_INTERNAL_DECL duk_int_t duk_bi_date_get_local_tzoffset_windows(duk_double_t d);
#endif
#if defined(DUK_USE_DATE_PRS_STRPTIME)
DUK_INTERNAL_DECL duk_bool_t duk_bi_date_parse_string_strptime(duk_context *ctx, const char *str);
#endif
#if defined(DUK_USE_DATE_PRS_GETDATE)
DUK_INTERNAL_DECL duk_bool_t duk_bi_date_parse_string_getdate(duk_context *ctx, const char *str);
#endif
#if defined(DUK_USE_DATE_FMT_STRFTIME)
DUK_INTERNAL_DECL duk_bool_t duk_bi_date_format_parts_strftime(duk_context *ctx, duk_int_t *parts, duk_int_t tzoffset, duk_small_uint_t flags);
#endif

DUK_INTERNAL_DECL duk_ret_t duk_bi_duktape_object_info(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_duktape_object_act(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_duktape_object_gc(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_duktape_object_fin(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_duktape_object_enc(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_duktape_object_dec(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_duktape_object_compact(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_error_constructor_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_error_prototype_to_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_error_prototype_stack_getter(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_error_prototype_filename_getter(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_error_prototype_linenumber_getter(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_error_prototype_stack_setter(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_error_prototype_filename_setter(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_error_prototype_linenumber_setter(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_function_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_function_prototype(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_function_prototype_to_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_function_prototype_apply(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_function_prototype_call(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_function_prototype_bind(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_eval(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_parse_int(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_parse_float(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_is_nan(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_is_finite(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_decode_uri(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_decode_uri_component(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_encode_uri(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_encode_uri_component(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_escape(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_unescape(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_print_helper(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_global_object_require(duk_context *ctx);

DUK_INTERNAL_DECL
void duk_bi_json_parse_helper(duk_context *ctx,
                              duk_idx_t idx_value,
                              duk_idx_t idx_reviver,
                              duk_small_uint_t flags);
DUK_INTERNAL_DECL
void duk_bi_json_stringify_helper(duk_context *ctx,
                                  duk_idx_t idx_value,
                                  duk_idx_t idx_replacer,
                                  duk_idx_t idx_space,
                                  duk_small_uint_t flags);
DUK_INTERNAL_DECL duk_ret_t duk_bi_json_object_parse(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_json_object_stringify(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_math_object_onearg_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_math_object_twoarg_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_math_object_max(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_math_object_min(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_math_object_random(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_number_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_number_prototype_to_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_number_prototype_to_locale_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_number_prototype_value_of(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_number_prototype_to_fixed(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_number_prototype_to_exponential(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_number_prototype_to_precision(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_object_getprototype_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_setprototype_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_get_own_property_descriptor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_create(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_define_property(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_define_properties(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_seal_freeze_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_prevent_extensions(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_is_sealed_frozen_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_is_extensible(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_constructor_keys_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_prototype_to_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_prototype_to_locale_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_prototype_value_of(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_prototype_has_own_property(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_prototype_is_prototype_of(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_object_prototype_property_is_enumerable(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_pointer_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_pointer_prototype_tostring_shared(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_regexp_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_regexp_prototype_exec(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_regexp_prototype_test(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_regexp_prototype_to_string(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_string_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_constructor_from_char_code(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_to_string(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_char_at(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_char_code_at(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_concat(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_indexof_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_locale_compare(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_match(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_replace(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_search(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_slice(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_split(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_substring(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_caseconv_shared(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_trim(duk_context *ctx);
/* Note: present even if DUK_USE_SECTION_B undefined given because genbuiltins.py
 * will point to it.
 */
DUK_INTERNAL_DECL duk_ret_t duk_bi_string_prototype_substr(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_proxy_constructor(duk_context *ctx);
#if 0  /* unimplemented now */
DUK_INTERNAL_DECL duk_ret_t duk_bi_proxy_constructor_revocable(duk_context *ctx);
#endif

DUK_INTERNAL_DECL duk_ret_t duk_bi_thread_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_thread_resume(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_thread_yield(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_thread_current(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_logger_constructor(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_logger_prototype_fmt(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_logger_prototype_raw(duk_context *ctx);
DUK_INTERNAL_DECL duk_ret_t duk_bi_logger_prototype_log_shared(duk_context *ctx);

DUK_INTERNAL_DECL duk_ret_t duk_bi_type_error_thrower(duk_context *ctx);

#endif  /* DUK_BUILTIN_PROTOS_H_INCLUDED */
#line 1 "duk_selftest.h"
/*
 *  Selftest code
 */

#ifndef DUK_SELFTEST_H_INCLUDED
#define DUK_SELFTEST_H_INCLUDED

#if defined(DUK_USE_SELF_TESTS)
DUK_INTERNAL_DECL void duk_selftest_run_tests(void);
#endif

#endif  /* DUK_SELFTEST_H_INCLUDED */
#line 78 "duk_internal.h"

#endif  /* DUK_INTERNAL_H_INCLUDED */
#line 1 "duk_strings.c"
/*
 *  Shared error message strings
 *
 *  To minimize code footprint, try to share error messages inside Duktape
 *  code.  Modern compilers will do this automatically anyway, this is mostly
 *  for older compilers.
 */

/* include removed: duk_internal.h */

/* Mostly API and built-in method related */
DUK_INTERNAL const char *duk_str_internal_error = "internal error";
DUK_INTERNAL const char *duk_str_invalid_count = "invalid count";
DUK_INTERNAL const char *duk_str_invalid_call_args = "invalid call args";
DUK_INTERNAL const char *duk_str_not_constructable = "not constructable";
DUK_INTERNAL const char *duk_str_not_callable = "not callable";
DUK_INTERNAL const char *duk_str_not_extensible = "not extensible";
DUK_INTERNAL const char *duk_str_not_writable = "not writable";
DUK_INTERNAL const char *duk_str_not_configurable = "not configurable";

DUK_INTERNAL const char *duk_str_invalid_context = "invalid context";
DUK_INTERNAL const char *duk_str_push_beyond_alloc_stack = "attempt to push beyond currently allocated stack";
DUK_INTERNAL const char *duk_str_not_buffer = "not buffer";  /* still in use with verbose messages */
DUK_INTERNAL const char *duk_str_unexpected_type = "unexpected type";
DUK_INTERNAL const char *duk_str_defaultvalue_coerce_failed = "[[DefaultValue]] coerce failed";
DUK_INTERNAL const char *duk_str_number_outside_range = "number outside range";
DUK_INTERNAL const char *duk_str_not_object_coercible = "not object coercible";
DUK_INTERNAL const char *duk_str_string_too_long = "string too long";
DUK_INTERNAL const char *duk_str_buffer_too_long = "buffer too long";
DUK_INTERNAL const char *duk_str_sprintf_too_long = "sprintf message too long";
DUK_INTERNAL const char *duk_str_alloc_failed = "alloc failed";
DUK_INTERNAL const char *duk_str_pop_too_many = "attempt to pop too many entries";
DUK_INTERNAL const char *duk_str_wrong_buffer_type = "wrong buffer type";
DUK_INTERNAL const char *duk_str_failed_to_extend_valstack = "failed to extend valstack";
DUK_INTERNAL const char *duk_str_encode_failed = "encode failed";
DUK_INTERNAL const char *duk_str_decode_failed = "decode failed";
DUK_INTERNAL const char *duk_str_no_sourcecode = "no sourcecode";
DUK_INTERNAL const char *duk_str_concat_result_too_long = "concat result too long";
DUK_INTERNAL const char *duk_str_unimplemented = "unimplemented";
DUK_INTERNAL const char *duk_str_unsupported = "unsupported";
DUK_INTERNAL const char *duk_str_array_length_over_2g = "array length over 2G";

/* JSON */
DUK_INTERNAL const char *duk_str_fmt_ptr = "%p";
DUK_INTERNAL const char *duk_str_fmt_invalid_json = "invalid json (at offset %ld)";
DUK_INTERNAL const char *duk_str_jsondec_reclimit = "json decode recursion limit";
DUK_INTERNAL const char *duk_str_jsonenc_reclimit = "json encode recursion limit";
DUK_INTERNAL const char *duk_str_cyclic_input = "cyclic input";

/* Object property access */
DUK_INTERNAL const char *duk_str_proxy_revoked = "proxy revoked";
DUK_INTERNAL const char *duk_str_object_resize_failed = "object resize failed";
DUK_INTERNAL const char *duk_str_invalid_base = "invalid base value";
DUK_INTERNAL const char *duk_str_strict_caller_read = "attempt to read strict 'caller'";
DUK_INTERNAL const char *duk_str_proxy_rejected = "proxy rejected";
DUK_INTERNAL const char *duk_str_invalid_array_length = "invalid array length";
DUK_INTERNAL const char *duk_str_array_length_write_failed = "array length write failed";
DUK_INTERNAL const char *duk_str_array_length_not_writable = "array length non-writable";
DUK_INTERNAL const char *duk_str_setter_undefined = "setter undefined";
DUK_INTERNAL const char *duk_str_redefine_virt_prop = "attempt to redefine virtual property";
DUK_INTERNAL const char *duk_str_invalid_descriptor = "invalid descriptor";
DUK_INTERNAL const char *duk_str_property_is_virtual = "property is virtual";

/* Compiler */
DUK_INTERNAL const char *duk_str_parse_error = "parse error";
DUK_INTERNAL const char *duk_str_duplicate_label = "duplicate label";
DUK_INTERNAL const char *duk_str_invalid_label = "invalid label";
DUK_INTERNAL const char *duk_str_invalid_array_literal = "invalid array literal";
DUK_INTERNAL const char *duk_str_invalid_object_literal = "invalid object literal";
DUK_INTERNAL const char *duk_str_invalid_var_declaration = "invalid variable declaration";
DUK_INTERNAL const char *duk_str_cannot_delete_identifier = "cannot delete identifier";
DUK_INTERNAL const char *duk_str_invalid_expression = "invalid expression";
DUK_INTERNAL const char *duk_str_invalid_lvalue = "invalid lvalue";
DUK_INTERNAL const char *duk_str_expected_identifier = "expected identifier";
DUK_INTERNAL const char *duk_str_empty_expr_not_allowed = "empty expression not allowed";
DUK_INTERNAL const char *duk_str_invalid_for = "invalid for statement";
DUK_INTERNAL const char *duk_str_invalid_switch = "invalid switch statement";
DUK_INTERNAL const char *duk_str_invalid_break_cont_label = "invalid break/continue label";
DUK_INTERNAL const char *duk_str_invalid_return = "invalid return";
DUK_INTERNAL const char *duk_str_invalid_try = "invalid try";
DUK_INTERNAL const char *duk_str_invalid_throw = "invalid throw";
DUK_INTERNAL const char *duk_str_with_in_strict_mode = "with in strict mode";
DUK_INTERNAL const char *duk_str_func_stmt_not_allowed = "function statement not allowed";
DUK_INTERNAL const char *duk_str_unterminated_stmt = "unterminated statement";
DUK_INTERNAL const char *duk_str_invalid_arg_name = "invalid argument name";
DUK_INTERNAL const char *duk_str_invalid_func_name = "invalid function name";
DUK_INTERNAL const char *duk_str_invalid_getset_name = "invalid getter/setter name";
DUK_INTERNAL const char *duk_str_func_name_required = "function name required";

/* Executor */
DUK_INTERNAL const char *duk_str_internal_error_exec_longjmp = "internal error in bytecode executor longjmp handler";

/* Regexp */
DUK_INTERNAL const char *duk_str_invalid_quantifier_no_atom = "quantifier without preceding atom";
DUK_INTERNAL const char *duk_str_invalid_quantifier_values = "quantifier values invalid (qmin > qmax)";
DUK_INTERNAL const char *duk_str_quantifier_too_many_copies = "quantifier expansion requires too many atom copies";
DUK_INTERNAL const char *duk_str_unexpected_closing_paren = "unexpected closing parenthesis";
DUK_INTERNAL const char *duk_str_unexpected_end_of_pattern = "unexpected end of pattern";
DUK_INTERNAL const char *duk_str_unexpected_regexp_token = "unexpected token in regexp";
DUK_INTERNAL const char *duk_str_invalid_regexp_flags = "invalid regexp flags";
DUK_INTERNAL const char *duk_str_invalid_backrefs = "invalid backreference(s)";
DUK_INTERNAL const char *duk_str_regexp_backtrack_failed = "regexp backtrack failed";
DUK_INTERNAL const char *duk_str_regexp_advance_failed = "regexp advance failed";
DUK_INTERNAL const char *duk_str_regexp_internal_error = "regexp internal error";

/* Limits */
DUK_INTERNAL const char *duk_str_valstack_limit = "valstack limit";
DUK_INTERNAL const char *duk_str_callstack_limit = "callstack limit";
DUK_INTERNAL const char *duk_str_catchstack_limit = "catchstack limit";
DUK_INTERNAL const char *duk_str_object_property_limit = "object property limit";
DUK_INTERNAL const char *duk_str_prototype_chain_limit = "prototype chain limit";
DUK_INTERNAL const char *duk_str_bound_chain_limit = "function call bound chain limit";
DUK_INTERNAL const char *duk_str_c_callstack_limit = "C call stack depth limit";
DUK_INTERNAL const char *duk_str_compiler_recursion_limit = "compiler recursion limit";
DUK_INTERNAL const char *duk_str_bytecode_limit = "bytecode limit";
DUK_INTERNAL const char *duk_str_reg_limit = "register limit";
DUK_INTERNAL const char *duk_str_temp_limit = "temp limit";
DUK_INTERNAL const char *duk_str_const_limit = "const limit";
DUK_INTERNAL const char *duk_str_func_limit = "function limit";
DUK_INTERNAL const char *duk_str_regexp_compiler_recursion_limit = "regexp compiler recursion limit";
DUK_INTERNAL const char *duk_str_regexp_executor_recursion_limit = "regexp executor recursion limit";
DUK_INTERNAL const char *duk_str_regexp_executor_step_limit = "regexp step limit";

/* Misc */
DUK_INTERNAL const char *duk_str_anon = "anon";
DUK_INTERNAL const char *duk_str_realloc_failed = "realloc failed";
#line 1 "duk_debug_macros.c"
/*
 *  Debugging macro calls.
 */

/* include removed: duk_internal.h */

#ifdef DUK_USE_DEBUG

/*
 *  Debugging enabled
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#define DUK__DEBUG_BUFSIZE  DUK_USE_DEBUG_BUFSIZE
DUK_LOCAL char duk__debug_buf[DUK__DEBUG_BUFSIZE];

DUK_LOCAL const char *duk__get_level_string(duk_small_int_t level) {
	switch ((int) level) {
	case DUK_LEVEL_DEBUG:
		return "D";
	case DUK_LEVEL_DDEBUG:
		return "DD";
	case DUK_LEVEL_DDDEBUG:
		return "DDD";
	}
	return "???";
}

#ifdef DUK_USE_DPRINT_COLORS

/* http://en.wikipedia.org/wiki/ANSI_escape_code */
#define DUK__TERM_REVERSE  "\x1b[7m"
#define DUK__TERM_BRIGHT   "\x1b[1m"
#define DUK__TERM_RESET    "\x1b[0m"
#define DUK__TERM_BLUE     "\x1b[34m"
#define DUK__TERM_RED      "\x1b[31m"

DUK_LOCAL const char *duk__get_term_1(duk_small_int_t level) {
	DUK_UNREF(level);
	return (const char *) DUK__TERM_RED;
}

DUK_LOCAL const char *duk__get_term_2(duk_small_int_t level) {
	switch ((int) level) {
	case DUK_LEVEL_DEBUG:
		return (const char *) (DUK__TERM_RESET DUK__TERM_BRIGHT);
	case DUK_LEVEL_DDEBUG:
		return (const char *) (DUK__TERM_RESET);
	case DUK_LEVEL_DDDEBUG:
		return (const char *) (DUK__TERM_RESET DUK__TERM_BLUE);
	}
	return (const char *) DUK__TERM_RESET;
}

DUK_LOCAL const char *duk__get_term_3(duk_small_int_t level) {
	DUK_UNREF(level);
	return (const char *) DUK__TERM_RESET;
}

#else

DUK_LOCAL const char *duk__get_term_1(duk_small_int_t level) {
	DUK_UNREF(level);
	return (const char *) "";
}

DUK_LOCAL const char *duk__get_term_2(duk_small_int_t level) {
	DUK_UNREF(level);
	return (const char *) "";
}

DUK_LOCAL const char *duk__get_term_3(duk_small_int_t level) {
	DUK_UNREF(level);
	return (const char *) "";
}

#endif  /* DUK_USE_DPRINT_COLORS */

#ifdef DUK_USE_VARIADIC_MACROS

DUK_INTERNAL void duk_debug_log(duk_small_int_t level, const char *file, duk_int_t line, const char *func, const char *fmt, ...) {
	va_list ap;

	va_start(ap, fmt);

	DUK_MEMZERO((void *) duk__debug_buf, (size_t) DUK__DEBUG_BUFSIZE);
	duk_debug_vsnprintf(duk__debug_buf, DUK__DEBUG_BUFSIZE - 1, fmt, ap);

	DUK_FPRINTF(DUK_STDERR, "%s[%s] %s:%ld (%s):%s %s%s\n",
	            (const char *) duk__get_term_1(level),
	            (const char *) duk__get_level_string(level),
	            (const char *) file,
	            (long) line,
	            (const char *) func,
	            (const char *) duk__get_term_2(level),
	            (const char *) duk__debug_buf,
	            (const char *) duk__get_term_3(level));
	DUK_FFLUSH(DUK_STDERR);

	va_end(ap);
}

#else  /* DUK_USE_VARIADIC_MACROS */

DUK_INTERNAL char duk_debug_file_stash[DUK_DEBUG_STASH_SIZE];
DUK_INTERNAL char duk_debug_line_stash[DUK_DEBUG_STASH_SIZE];
DUK_INTERNAL char duk_debug_func_stash[DUK_DEBUG_STASH_SIZE];
DUK_INTERNAL duk_small_int_t duk_debug_level_stash;

DUK_INTERNAL void duk_debug_log(const char *fmt, ...) {
	va_list ap;
	duk_small_int_t level = duk_debug_level_stash;

	va_start(ap, fmt);

	DUK_MEMZERO((void *) duk__debug_buf, (size_t) DUK__DEBUG_BUFSIZE);
	duk_debug_vsnprintf(duk__debug_buf, DUK__DEBUG_BUFSIZE - 1, fmt, ap);

	DUK_FPRINTF(DUK_STDERR, "%s[%s] %s:%s (%s):%s %s%s\n",
	            (const char *) duk__get_term_1(level),
	            (const char *) duk__get_level_string(duk_debug_level_stash),
	            (const char *) duk_debug_file_stash,
	            (const char *) duk_debug_line_stash,
	            (const char *) duk_debug_func_stash,
	            (const char *) duk__get_term_2(level),
	            (const char *) duk__debug_buf,
	            (const char *) duk__get_term_3(level));
	DUK_FFLUSH(DUK_STDERR);

	va_end(ap);
}

#endif  /* DUK_USE_VARIADIC_MACROS */

#else  /* DUK_USE_DEBUG */

/*
 *  Debugging disabled
 */

#endif  /* DUK_USE_DEBUG */
#line 1 "duk_builtins.c"
/*
 *  Automatically generated by genbuiltins.py, do not edit!
 */

/* include removed: duk_internal.h */

#if defined(DUK_USE_DOUBLE_LE)
DUK_INTERNAL const duk_uint8_t duk_strings_data[2624] = {
55,86,227,24,145,55,102,120,144,3,63,94,228,54,100,137,186,50,11,164,109,
77,215,5,61,35,106,206,149,110,4,254,219,237,58,8,196,24,103,74,183,2,127,
103,246,93,4,98,12,47,180,67,103,246,127,101,208,70,32,194,186,134,207,236,
254,203,160,140,65,133,246,136,108,254,199,237,186,8,196,24,87,80,217,253,
143,219,116,17,136,49,30,209,13,159,220,116,75,3,30,65,244,17,136,48,174,
209,13,159,220,116,17,136,48,158,161,179,251,142,130,49,6,17,209,130,96,
237,80,75,47,160,140,65,142,134,133,41,34,110,134,133,41,34,3,25,110,8,22,
158,130,38,163,8,217,200,158,76,156,210,117,128,153,203,210,70,46,137,187,
18,27,164,187,201,209,130,100,55,91,70,4,145,63,66,231,44,128,105,187,41,
197,13,49,122,8,196,24,71,75,70,138,104,115,77,215,5,36,20,201,214,209,107,
79,104,209,144,168,105,6,207,251,209,104,209,125,212,227,66,127,235,191,
239,232,180,90,52,95,69,247,83,141,9,255,174,255,191,162,211,80,210,253,23,
221,78,52,39,254,183,254,254,139,72,105,126,139,238,167,26,19,255,91,255,
127,69,166,129,191,69,247,83,141,9,255,175,255,191,162,213,26,50,23,232,
190,234,113,161,63,245,115,119,86,227,118,83,138,26,98,9,110,48,86,22,148,
160,152,22,82,70,46,137,44,8,180,163,32,104,98,206,32,17,7,16,88,101,100,
206,42,70,36,108,205,18,74,140,33,196,230,60,2,152,146,33,38,230,8,36,79,
182,251,65,156,151,24,200,33,145,162,25,80,209,24,67,0,166,68,52,174,61,73,
25,33,205,25,27,84,177,195,234,220,1,144,105,99,135,217,16,17,17,208,72,
199,179,60,93,100,146,49,232,162,64,76,135,19,152,244,44,136,223,98,67,4,
18,33,247,217,158,36,0,209,190,156,13,26,201,21,111,165,67,64,180,100,145,
62,250,32,45,100,33,55,214,1,229,223,65,19,72,187,236,206,137,35,125,120,
190,201,104,105,15,190,201,212,136,136,125,246,160,137,27,83,239,171,37,
200,218,159,125,168,34,192,61,27,233,93,22,1,114,78,250,28,76,130,112,200,
93,245,164,188,207,190,204,17,49,38,109,246,160,93,8,119,185,13,153,34,173,
246,113,0,136,48,76,10,90,26,78,182,140,9,34,130,161,100,235,64,194,9,226,
44,166,1,41,221,153,226,235,118,120,121,58,72,197,209,63,71,69,76,15,34,
164,73,244,171,112,39,246,223,104,169,18,125,42,220,9,253,159,217,38,68,
159,104,134,207,236,254,201,18,36,250,134,207,236,254,201,50,36,251,68,54,
127,99,246,200,145,39,212,54,127,99,246,200,145,39,218,33,179,251,131,200,
147,234,27,63,184,81,137,62,149,110,4,254,219,237,20,98,79,165,91,129,63,
179,251,36,152,147,237,16,217,253,159,217,32,196,159,80,217,253,159,217,36,
196,159,104,134,207,236,126,217,6,36,250,134,207,236,126,217,6,36,251,68,
54,127,112,115,18,125,67,103,247,8,149,2,8,196,24,143,131,137,146,90,121,
35,162,44,140,35,102,160,226,100,235,138,89,18,102,13,10,82,68,200,151,106,
130,88,131,4,192,73,225,228,85,162,137,147,168,108,252,18,42,209,68,201,
212,54,126,89,23,104,162,100,245,17,230,207,193,34,237,20,76,158,162,60,
217,249,100,109,162,137,147,163,117,2,178,120,36,109,162,137,147,163,117,2,
178,121,100,101,162,137,147,165,91,129,63,4,140,180,81,50,116,171,112,39,
229,145,150,138,38,78,161,179,251,63,178,240,72,203,69,19,39,80,217,253,
159,217,121,100,109,162,137,147,212,71,155,63,179,251,47,4,141,180,81,50,
122,136,243,103,246,127,101,229,145,150,138,38,78,161,179,251,31,182,240,
72,203,69,19,39,80,217,253,143,219,121,100,109,162,137,147,212,71,155,63,
177,251,111,4,141,180,81,50,122,136,243,103,246,63,109,229,145,54,138,38,
78,161,179,251,133,90,40,153,61,68,121,179,251,132,196,128,31,80,217,248,
36,76,72,1,245,13,159,150,69,68,128,31,168,143,54,126,9,21,18,0,126,162,60,
217,249,100,100,72,1,244,110,160,86,79,4,140,137,0,62,141,212,10,201,229,
145,113,32,7,210,173,192,159,130,69,196,128,31,74,183,2,126,89,23,18,0,125,
67,103,246,127,101,224,145,113,32,7,212,54,127,103,246,94,89,25,18,0,126,
162,60,217,253,159,217,120,36,100,72,1,250,136,243,103,246,127,101,229,145,
113,32,7,212,54,127,99,246,222,9,23,18,0,125,67,103,246,63,109,229,145,145,
32,7,234,35,205,159,216,253,183,130,70,68,128,31,168,143,54,127,99,246,222,
89,17,18,0,125,67,103,247,9,137,0,63,81,30,108,254,224,130,115,240,98,66,
128,92,136,84,45,101,180,81,50,28,78,99,193,18,40,56,153,58,178,52,211,58,
17,46,134,133,41,34,164,75,164,104,156,52,52,199,37,222,232,206,66,64,207,
18,66,136,137,19,173,62,46,155,181,167,72,147,235,226,233,186,120,121,58,
226,157,214,111,84,76,73,36,109,24,72,130,100,112,200,178,76,157,124,92,
242,70,120,25,193,34,245,241,117,240,97,1,107,33,25,212,54,160,90,7,244,29,
24,38,66,254,223,215,125,119,215,126,232,190,43,226,67,244,1,250,193,125,
111,216,11,234,254,192,63,96,159,173,234,26,84,53,19,194,126,175,168,105,
80,212,79,8,234,26,84,53,19,193,156,20,144,83,52,167,20,52,198,109,24,18,
68,225,115,150,64,53,52,104,200,84,52,131,76,167,20,52,200,46,7,48,52,146,
132,102,57,33,165,139,168,209,154,32,104,220,193,189,214,27,16,209,176,23,
26,220,98,149,110,116,70,75,188,98,116,136,34,33,101,4,192,223,178,32,38,6,
144,18,67,72,1,58,67,0,100,95,74,17,159,217,31,210,132,103,246,58,251,33,
121,232,55,150,227,125,143,216,16,190,91,141,246,68,31,150,223,178,39,150,
223,177,251,0,244,135,97,37,32,24,132,104,24,66,161,175,164,202,134,140,
151,39,212,125,255,221,125,74,86,9,79,168,104,201,116,178,139,154,22,134,
145,72,51,93,18,116,64,145,13,39,82,34,33,38,73,76,132,185,4,185,187,198,
100,229,233,197,13,49,228,73,247,4,4,78,98,79,184,32,34,105,187,201,147,
154,185,187,200,147,165,233,197,13,50,230,239,82,98,151,167,20,52,206,145,
39,234,76,69,245,22,190,224,128,138,228,73,244,180,90,251,130,2,43,145,39,
234,76,76,243,155,51,162,68,159,88,230,204,234,145,39,234,76,67,240,38,67,
200,147,232,193,50,46,68,159,169,49,31,206,164,100,137,18,125,59,169,25,54,
68,159,169,49,51,200,109,38,73,42,68,159,88,134,210,100,147,100,73,250,147,
20,188,65,57,163,146,164,73,246,68,19,154,57,74,68,159,169,49,51,200,90,
209,34,9,205,28,159,34,79,172,66,214,137,16,78,104,228,121,18,125,154,24,
72,152,147,236,208,194,101,205,39,92,82,200,147,145,137,63,82,98,103,144,
181,162,68,19,154,57,60,196,159,88,133,173,18,32,156,209,201,166,36,253,73,
138,94,32,156,209,201,70,36,251,34,9,205,28,154,98,79,212,152,153,228,54,
147,36,148,98,79,172,67,105,50,73,102,36,253,73,136,254,117,35,36,24,147,
233,221,72,201,38,36,253,73,136,126,6,12,98,79,163,6,20,98,79,212,152,135,
224,76,135,49,39,209,130,100,89,137,63,82,98,103,156,217,157,6,36,250,199,
54,103,113,137,63,82,98,47,168,181,247,4,4,86,98,79,165,162,215,220,16,17,
57,137,62,205,12,36,166,238,173,194,2,201,217,161,132,236,167,20,52,210,
155,186,183,8,11,39,70,9,147,178,156,80,211,50,110,236,208,194,118,83,138,
26,102,77,221,24,38,78,202,113,67,76,54,186,195,245,38,34,188,17,145,23,55,
117,241,32,145,36,57,173,155,186,75,189,205,35,102,128,44,243,119,74,139,
144,113,243,221,36,77,21,38,144,210,161,168,158,35,230,144,192,154,42,77,
33,165,67,81,60,15,173,7,90,159,49,13,213,64,186,17,62,96,47,170,129,116,
33,165,64,202,113,36,226,134,70,110,234,220,32,44,157,163,222,72,244,64,
145,23,55,118,143,121,35,209,2,68,140,221,213,184,64,89,58,183,88,145,232,
129,34,46,110,234,221,98,71,162,4,136,153,80,50,156,80,211,22,79,90,38,105,
16,17,17,207,18,61,96,17,10,192,76,71,106,220,32,44,157,19,152,240,68,138,
17,193,30,137,195,39,65,51,8,224,143,65,54,22,46,103,68,112,71,162,112,200,
184,144,116,17,59,20,24,243,52,72,58,8,134,42,23,50,68,108,3,206,87,71,164,
0,142,73,57,132,41,42,72,225,107,4,167,212,52,100,191,92,83,161,163,37,250,
226,158,141,145,208,89,154,79,90,4,66,73,209,153,100,180,8,133,145,208,89,
158,36,169,35,34,17,244,145,198,247,60,137,114,26,97,57,162,4,206,137,116,
17,136,48,144,68,212,97,27,57,24,64,90,201,18,5,13,25,4,5,172,160,123,215,
138,62,46,121,35,60,117,18,233,27,70,18,32,10,200,212,75,175,139,166,233,
225,228,235,138,227,130,93,117,155,215,197,207,36,103,131,212,11,161,58,
226,186,110,234,220,32,44,157,148,226,134,153,19,119,101,56,161,166,88,156,
217,78,52,20,221,17,200,147,25,137,53,17,180,97,34,0,172,140,19,154,84,26,
145,0,86,68,90,40,152,2,178,22,160,93,8,69,19,18,98,37,210,94,100,108,144,
21,145,8,151,75,23,100,141,66,37,217,16,11,32,226,248,146,164,108,250,75,
204,141,146,28,217,24,177,33,50,66,72,128,92,6,66,161,164,235,226,231,146,
51,65,36,225,144,168,105,58,248,185,228,140,240,97,68,128,153,38,98,79,174,
179,122,248,185,228,140,241,214,129,132,150,12,73,245,214,111,95,23,60,145,
158,58,50,72,81,67,230,232,184,196,159,95,23,77,211,195,201,215,21,47,139,
166,233,225,228,50,200,211,76,229,2,201,25,149,241,67,102,138,52,146,16,30,
67,18,66,3,201,34,52,78,25,61,72,160,94,115,30,230,145,179,73,26,39,12,158,
164,81,33,144,78,25,61,72,160,94,115,30,230,145,179,72,200,39,12,158,164,
80,132,75,165,67,81,50,21,18,235,65,214,169,224,140,137,210,173,192,154,30,
8,200,157,67,102,66,84,11,71,169,20,19,209,139,162,158,207,15,39,73,24,186,
43,236,176,217,130,253,36,98,232,187,177,33,73,18,52,68,233,35,23,69,93,
136,26,98,116,145,139,162,158,146,160,95,73,24,186,37,12,72,5,16,64,145,10,
32,76,71,64,156,217,161,180,34,6,64,208,198,36,78,50,20,20,92,204,50,44,
147,32,134,226,17,114,33,202,134,129,107,192,202,232,160,180,104,166,135,
52,72,40,144,213,33,178,152,26,34,56,163,105,44,104,146,116,139,77,43,34,
98,57,38,116,72,179,60,93,97,206,56,52,240,242,56,163,168,34,81,57,178,153,
42,228,12,182,58,22,66,89,19,57,68,176,74,68,35,104,195,18,239,116,102,114,
94,100,104,228,100,49,238,140,203,42,60,145,35,104,181,146,113,161,10,80,
46,68,82,24,245,145,132,108,228,148,54,100,137,64,34,13,100,153,222,1,40,6,
33,223,20,84,19,34,95,23,76,130,153,6,103,208,43,64,141,41,130,104,17,112,
130,44,96,
};

/* to convert a heap stridx to a token number, subtract
 * DUK_STRIDX_START_RESERVED and add DUK_TOK_START_RESERVED.
 */

/* native functions: 149 */
DUK_INTERNAL const duk_c_function duk_bi_native_functions[149] = {
	duk_bi_array_constructor,
	duk_bi_array_constructor_is_array,
	duk_bi_array_prototype_concat,
	duk_bi_array_prototype_indexof_shared,
	duk_bi_array_prototype_iter_shared,
	duk_bi_array_prototype_join_shared,
	duk_bi_array_prototype_pop,
	duk_bi_array_prototype_push,
	duk_bi_array_prototype_reduce_shared,
	duk_bi_array_prototype_reverse,
	duk_bi_array_prototype_shift,
	duk_bi_array_prototype_slice,
	duk_bi_array_prototype_sort,
	duk_bi_array_prototype_splice,
	duk_bi_array_prototype_to_string,
	duk_bi_array_prototype_unshift,
	duk_bi_arraybuffer_constructor,
	duk_bi_arraybuffer_isview,
	duk_bi_boolean_constructor,
	duk_bi_boolean_prototype_tostring_shared,
	duk_bi_buffer_compare_shared,
	duk_bi_buffer_constructor,
	duk_bi_buffer_prototype_tostring_shared,
	duk_bi_buffer_readfield,
	duk_bi_buffer_slice_shared,
	duk_bi_buffer_writefield,
	duk_bi_dataview_constructor,
	duk_bi_date_constructor,
	duk_bi_date_constructor_now,
	duk_bi_date_constructor_parse,
	duk_bi_date_constructor_utc,
	duk_bi_date_prototype_get_shared,
	duk_bi_date_prototype_get_timezone_offset,
	duk_bi_date_prototype_set_shared,
	duk_bi_date_prototype_set_time,
	duk_bi_date_prototype_to_json,
	duk_bi_date_prototype_tostring_shared,
	duk_bi_date_prototype_value_of,
	duk_bi_duktape_object_act,
	duk_bi_duktape_object_compact,
	duk_bi_duktape_object_dec,
	duk_bi_duktape_object_enc,
	duk_bi_duktape_object_fin,
	duk_bi_duktape_object_gc,
	duk_bi_duktape_object_info,
	duk_bi_error_constructor_shared,
	duk_bi_error_prototype_filename_getter,
	duk_bi_error_prototype_filename_setter,
	duk_bi_error_prototype_linenumber_getter,
	duk_bi_error_prototype_linenumber_setter,
	duk_bi_error_prototype_stack_getter,
	duk_bi_error_prototype_stack_setter,
	duk_bi_error_prototype_to_string,
	duk_bi_function_constructor,
	duk_bi_function_prototype,
	duk_bi_function_prototype_apply,
	duk_bi_function_prototype_bind,
	duk_bi_function_prototype_call,
	duk_bi_function_prototype_to_string,
	duk_bi_global_object_decode_uri,
	duk_bi_global_object_decode_uri_component,
	duk_bi_global_object_encode_uri,
	duk_bi_global_object_encode_uri_component,
	duk_bi_global_object_escape,
	duk_bi_global_object_eval,
	duk_bi_global_object_is_finite,
	duk_bi_global_object_is_nan,
	duk_bi_global_object_parse_float,
	duk_bi_global_object_parse_int,
	duk_bi_global_object_print_helper,
	duk_bi_global_object_require,
	duk_bi_global_object_unescape,
	duk_bi_json_object_parse,
	duk_bi_json_object_stringify,
	duk_bi_logger_constructor,
	duk_bi_logger_prototype_fmt,
	duk_bi_logger_prototype_log_shared,
	duk_bi_logger_prototype_raw,
	duk_bi_math_object_max,
	duk_bi_math_object_min,
	duk_bi_math_object_onearg_shared,
	duk_bi_math_object_random,
	duk_bi_math_object_twoarg_shared,
	duk_bi_nodejs_buffer_byte_length,
	duk_bi_nodejs_buffer_concat,
	duk_bi_nodejs_buffer_constructor,
	duk_bi_nodejs_buffer_copy,
	duk_bi_nodejs_buffer_fill,
	duk_bi_nodejs_buffer_is_buffer,
	duk_bi_nodejs_buffer_is_encoding,
	duk_bi_nodejs_buffer_tojson,
	duk_bi_nodejs_buffer_tostring,
	duk_bi_nodejs_buffer_write,
	duk_bi_number_constructor,
	duk_bi_number_prototype_to_exponential,
	duk_bi_number_prototype_to_fixed,
	duk_bi_number_prototype_to_locale_string,
	duk_bi_number_prototype_to_precision,
	duk_bi_number_prototype_to_string,
	duk_bi_number_prototype_value_of,
	duk_bi_object_constructor,
	duk_bi_object_constructor_create,
	duk_bi_object_constructor_define_properties,
	duk_bi_object_constructor_define_property,
	duk_bi_object_constructor_get_own_property_descriptor,
	duk_bi_object_constructor_is_extensible,
	duk_bi_object_constructor_is_sealed_frozen_shared,
	duk_bi_object_constructor_keys_shared,
	duk_bi_object_constructor_prevent_extensions,
	duk_bi_object_constructor_seal_freeze_shared,
	duk_bi_object_getprototype_shared,
	duk_bi_object_prototype_has_own_property,
	duk_bi_object_prototype_is_prototype_of,
	duk_bi_object_prototype_property_is_enumerable,
	duk_bi_object_prototype_to_locale_string,
	duk_bi_object_prototype_to_string,
	duk_bi_object_prototype_value_of,
	duk_bi_object_setprototype_shared,
	duk_bi_pointer_constructor,
	duk_bi_pointer_prototype_tostring_shared,
	duk_bi_proxy_constructor,
	duk_bi_regexp_constructor,
	duk_bi_regexp_prototype_exec,
	duk_bi_regexp_prototype_test,
	duk_bi_regexp_prototype_to_string,
	duk_bi_string_constructor,
	duk_bi_string_constructor_from_char_code,
	duk_bi_string_prototype_caseconv_shared,
	duk_bi_string_prototype_char_at,
	duk_bi_string_prototype_char_code_at,
	duk_bi_string_prototype_concat,
	duk_bi_string_prototype_indexof_shared,
	duk_bi_string_prototype_locale_compare,
	duk_bi_string_prototype_match,
	duk_bi_string_prototype_replace,
	duk_bi_string_prototype_search,
	duk_bi_string_prototype_slice,
	duk_bi_string_prototype_split,
	duk_bi_string_prototype_substr,
	duk_bi_string_prototype_substring,
	duk_bi_string_prototype_to_string,
	duk_bi_string_prototype_trim,
	duk_bi_thread_constructor,
	duk_bi_thread_current,
	duk_bi_thread_resume,
	duk_bi_thread_yield,
	duk_bi_type_error_thrower,
	duk_bi_typedarray_constructor,
	duk_bi_typedarray_set,
};

DUK_INTERNAL const duk_uint8_t duk_builtins_data[1955] = {
105,195,75,32,121,40,105,53,14,252,104,54,8,131,72,0,115,225,65,165,244,55,
243,6,145,32,210,24,210,186,25,249,35,120,216,99,226,13,79,33,116,177,164,
180,44,192,4,202,52,150,220,24,0,169,70,146,219,123,0,23,40,210,91,110,96,
3,37,26,75,109,172,0,108,163,73,109,177,128,14,148,105,45,181,176,1,242,
144,56,209,36,94,6,167,133,98,80,211,28,1,250,67,72,168,67,232,13,46,192,
47,162,52,165,0,62,80,163,72,128,61,40,107,26,7,37,20,53,201,131,88,0,66,
134,185,48,98,80,215,38,11,96,0,138,26,228,193,76,0,69,67,92,152,37,128,6,
168,107,147,4,48,1,165,13,114,96,118,0,44,161,174,76,12,192,7,148,53,201,
129,88,1,26,134,165,80,130,80,31,255,241,69,224,0,0,0,0,0,0,124,63,174,32,
0,0,0,0,0,0,120,63,175,98,7,140,16,116,194,7,12,48,108,196,6,140,80,100,
198,6,12,112,92,200,5,140,149,192,202,91,204,181,184,204,91,76,213,176,206,
90,204,240,84,208,5,13,9,124,210,43,13,24,64,226,131,205,112,56,216,3,77,
152,48,218,130,205,184,40,220,130,77,216,32,222,129,205,248,24,224,129,78,
25,214,164,2,90,81,17,104,67,37,157,8,150,100,18,89,78,201,100,60,37,140,
244,150,35,226,88,79,201,96,71,37,125,20,122,188,138,62,0,2,165,70,39,255,
255,193,43,67,0,0,80,127,192,58,182,220,80,0,21,59,170,64,0,107,77,8,172,
181,146,176,202,138,187,59,42,204,200,170,182,146,168,218,80,0,26,155,97,
42,77,68,168,181,20,0,6,160,210,74,123,89,64,0,127,255,4,10,153,219,157,70,
163,185,130,140,228,10,43,160,40,141,228,161,184,18,132,226,64,161,127,128,
0,63,225,1,109,74,8,137,71,58,5,4,221,20,3,147,233,249,193,240,80,255,192,
6,120,2,64,127,195,0,173,28,56,20,96,80,128,0,206,192,143,167,64,164,156,
131,2,112,14,125,55,9,4,216,40,19,80,180,77,3,9,51,13,94,153,7,159,76,64,
207,192,0,102,0,103,255,255,242,240,67,73,112,33,168,0,12,180,16,212,0,10,
88,8,106,0,7,43,4,53,0,4,149,4,31,128,0,202,66,15,255,255,194,137,254,0,50,
135,227,224,127,196,2,87,132,17,82,143,24,10,44,96,36,240,4,147,64,146,119,
4,125,49,131,52,152,65,154,128,0,201,97,9,36,133,36,142,25,18,40,114,77,98,
17,33,137,68,130,45,17,247,240,71,159,193,29,127,8,0,12,113,252,32,0,49,
184,208,70,162,144,20,95,240,0,7,252,80,37,120,193,81,196,194,0,3,69,19,0,
81,191,197,140,192,255,255,255,255,255,255,239,127,140,64,1,0,0,0,0,0,0,0,
139,192,0,0,0,0,0,0,248,127,138,192,0,0,0,0,0,0,240,127,139,64,0,0,0,0,0,0,
240,255,0,31,241,128,149,224,0,0,0,0,0,0,0,0,13,71,98,37,25,128,148,86,48,
69,23,201,19,94,36,73,132,129,71,255,0,56,136,233,34,3,223,208,241,192,3,
254,56,18,188,128,0,0,0,0,0,15,135,251,104,228,128,135,18,4,0,6,26,72,16,0,
42,49,32,64,0,225,132,129,0,4,133,146,4,0,21,210,72,16,0,103,65,32,64,1,
220,228,100,162,146,130,20,74,8,72,248,64,2,33,3,225,0,9,131,143,132,0,42,
12,62,16,0,184,40,248,64,3,32,131,225,0,13,129,143,132,0,58,4,62,16,0,248,
8,248,64,4,32,3,225,0,17,127,143,132,0,73,252,62,16,1,55,232,248,64,5,31,
131,225,0,21,125,143,132,0,89,244,62,16,1,119,201,0,31,4,68,123,144,148,0,
97,236,66,80,1,151,169,10,248,0,211,208,133,124,0,109,230,66,254,0,56,242,
33,127,0,29,120,144,207,128,15,60,8,103,192,7,221,228,37,0,32,119,16,148,0,
133,218,66,190,0,68,236,33,95,0,35,117,144,191,128,18,58,136,95,192,9,92,
195,225,0,38,114,144,148,0,156,41,31,224,0,15,249,1,138,144,65,192,2,22,0,
88,16,46,24,77,208,148,103,4,102,252,102,244,128,0,0,0,0,0,0,0,0,220,111,
68,113,61,146,142,248,0,164,255,128,0,63,228,133,109,16,89,178,65,18,235,
153,25,150,220,184,188,180,230,6,32,209,205,0,20,175,240,0,39,252,160,77,
162,184,54,72,34,0,82,255,192,0,159,242,193,54,138,222,217,32,136,1,76,255,
0,2,127,204,4,218,43,115,100,130,32,5,55,252,0,9,255,52,19,104,173,173,146,
8,128,20,239,240,0,39,252,224,77,162,182,54,72,34,0,83,255,192,0,159,243,
193,54,138,214,217,32,136,0,255,255,33,177,1,165,92,82,44,42,252,21,1,175,
0,89,86,214,238,197,172,9,1,173,3,188,231,235,249,8,187,152,253,171,3,250,
8,173,149,28,87,220,253,169,0,59,148,152,85,239,47,108,253,167,0,96,181,17,
83,236,132,37,1,165,3,52,237,253,154,122,131,152,253,163,3,52,237,253,154,
122,131,216,253,38,130,129,25,234,5,0,1,103,40,20,0,9,154,160,80,0,54,98,
146,25,106,5,0,4,101,40,20,0,21,146,160,80,0,102,66,129,64,1,216,234,5,0,8,
99,39,47,49,83,215,152,138,73,0,1,97,168,129,132,160,80,0,150,10,129,64,2,
152,10,5,0,11,95,168,20,0,48,31,255,224,5,17,72,66,249,37,129,127,255,0,0,
191,255,128,0,63,255,197,31,192,0,0,0,0,128,80,196,64,8,26,112,17,169,0,
154,80,1,171,28,124,88,65,233,49,7,133,100,29,149,15,14,138,71,135,37,3,
195,66,114,5,77,252,0,243,178,40,25,200,48,101,30,0,127,210,128,0,85,31,
192,0,31,244,224,5,71,22,8,0,13,20,88,1,85,127,0,0,127,212,128,21,29,220,
32,0,52,87,112,5,89,252,0,1,255,86,16,166,64,0,0,0,0,0,0,2,0,170,72,38,29,
219,247,16,49,75,32,193,52,130,244,193,225,114,96,248,0,8,249,48,124,0,8,
90,152,62,0,6,44,76,31,0,4,21,166,15,128,2,147,255,252,38,212,16,184,155,
250,226,217,150,47,46,91,249,54,96,139,229,229,203,127,36,26,119,32,203,
203,150,254,72,52,97,221,147,102,157,217,192,10,191,248,0,157,4,72,15,250,
224,1,154,140,36,0,8,43,31,224,0,15,251,0,16,55,139,164,0,192,220,46,144,2,
3,104,186,64,12,77,130,233,0,33,53,139,164,0,200,212,46,144,2,35,72,186,64,
8,205,2,233,0,36,51,140,180,0,192,204,50,208,2,3,40,203,64,12,76,131,45,0,
33,49,140,180,0,200,196,50,208,2,35,8,203,64,8,204,3,45,0,36,7,255,248,1,
82,101,16,112,24,72,0,8,86,159,193,56,192,0,0,0,0,0,0,240,63,1,151,246,96,
0,21,183,240,78,48,0,0,0,0,0,0,60,15,192,101,253,168,0,5,113,252,19,140,0,
0,0,0,0,0,15,3,240,25,127,110,0,1,93,127,4,227,0,0,0,0,0,0,0,1,0,6,95,220,
128,0,87,159,193,56,192,0,0,0,0,0,0,0,64,1,151,247,96,0,21,247,240,78,48,0,
0,0,0,0,0,4,16,0,101,253,232,0,5,129,252,19,140,0,0,0,0,0,0,1,4,0,25,127,
126,0,1,97,127,4,227,0,0,0,0,0,0,0,65,0,6,95,224,128,0,88,159,193,56,192,0,
0,0,0,0,0,32,64,1,151,248,96,0,22,55,240,5,157,170,33,68,178,69,10,193,20,
10,104,79,138,36,0,12,31,248,160,88,154,23,66,100,93,32,2,9,129,116,128,0,
165,197,210,0,18,150,23,72,0,138,84,93,32,3,41,65,116,128,1,36,197,210,0,
20,146,23,72,0,146,68,93,32,3,73,1,116,128,1,163,197,210,0,22,142,23,72,0,
34,52,93,32,1,136,193,118,128,2,162,197,218,0,26,138,23,104,0,170,36,93,
160,3,168,129,150,33,198,90,0,32,134,25,104,0,10,20,101,160,1,40,65,150,
128,8,160,198,90,0,50,130,25,104,0,18,4,101,160,1,72,1,150,128,9,31,198,90,
0,52,126,25,104,0,25,244,101,160,1,103,193,150,128,2,30,198,90,0,24,122,25,
136,0,41,228,102,32,1,167,129,152,128,10,157,198,98,0,59,71,91,99,157,104,
9,213,118,39,5,8,159,20,40,0,10,109,90,19,81,132,39,151,32,
};
#ifdef DUK_USE_BUILTIN_INITJS
DUK_INTERNAL const duk_uint8_t duk_initjs_data[187] = {
40,102,117,110,99,116,105,111,110,40,100,44,97,41,123,102,117,110,99,116,
105,111,110,32,98,40,97,44,98,44,99,41,123,79,98,106,101,99,116,46,100,101,
102,105,110,101,80,114,111,112,101,114,116,121,40,97,44,98,44,123,118,97,
108,117,101,58,99,44,119,114,105,116,97,98,108,101,58,33,48,44,101,110,117,
109,101,114,97,98,108,101,58,33,49,44,99,111,110,102,105,103,117,114,97,98,
108,101,58,33,48,125,41,125,98,40,97,46,76,111,103,103,101,114,44,34,99,
108,111,103,34,44,110,101,119,32,97,46,76,111,103,103,101,114,40,34,67,34,
41,41,59,98,40,97,44,34,109,111,100,76,111,97,100,101,100,34,44,123,125,41,
125,41,40,116,104,105,115,44,68,117,107,116,97,112,101,41,59,10,0,
};
#endif  /* DUK_USE_BUILTIN_INITJS */
#elif defined(DUK_USE_DOUBLE_BE)
DUK_INTERNAL const duk_uint8_t duk_strings_data[2624] = {
55,86,227,24,145,55,102,120,144,3,63,94,228,54,100,137,186,50,11,164,109,
77,215,5,61,35,106,206,149,110,4,254,219,237,58,8,196,24,103,74,183,2,127,
103,246,93,4,98,12,47,180,67,103,246,127,101,208,70,32,194,186,134,207,236,
254,203,160,140,65,133,246,136,108,254,199,237,186,8,196,24,87,80,217,253,
143,219,116,17,136,49,30,209,13,159,220,116,75,3,30,65,244,17,136,48,174,
209,13,159,220,116,17,136,48,158,161,179,251,142,130,49,6,17,209,130,96,
237,80,75,47,160,140,65,142,134,133,41,34,110,134,133,41,34,3,25,110,8,22,
158,130,38,163,8,217,200,158,76,156,210,117,128,153,203,210,70,46,137,187,
18,27,164,187,201,209,130,100,55,91,70,4,145,63,66,231,44,128,105,187,41,
197,13,49,122,8,196,24,71,75,70,138,104,115,77,215,5,36,20,201,214,209,107,
79,104,209,144,168,105,6,207,251,209,104,209,125,212,227,66,127,235,191,
239,232,180,90,52,95,69,247,83,141,9,255,174,255,191,162,211,80,210,253,23,
221,78,52,39,254,183,254,254,139,72,105,126,139,238,167,26,19,255,91,255,
127,69,166,129,191,69,247,83,141,9,255,175,255,191,162,213,26,50,23,232,
190,234,113,161,63,245,115,119,86,227,118,83,138,26,98,9,110,48,86,22,148,
160,152,22,82,70,46,137,44,8,180,163,32,104,98,206,32,17,7,16,88,101,100,
206,42,70,36,108,205,18,74,140,33,196,230,60,2,152,146,33,38,230,8,36,79,
182,251,65,156,151,24,200,33,145,162,25,80,209,24,67,0,166,68,52,174,61,73,
25,33,205,25,27,84,177,195,234,220,1,144,105,99,135,217,16,17,17,208,72,
199,179,60,93,100,146,49,232,162,64,76,135,19,152,244,44,136,223,98,67,4,
18,33,247,217,158,36,0,209,190,156,13,26,201,21,111,165,67,64,180,100,145,
62,250,32,45,100,33,55,214,1,229,223,65,19,72,187,236,206,137,35,125,120,
190,201,104,105,15,190,201,212,136,136,125,246,160,137,27,83,239,171,37,
200,218,159,125,168,34,192,61,27,233,93,22,1,114,78,250,28,76,130,112,200,
93,245,164,188,207,190,204,17,49,38,109,246,160,93,8,119,185,13,153,34,173,
246,113,0,136,48,76,10,90,26,78,182,140,9,34,130,161,100,235,64,194,9,226,
44,166,1,41,221,153,226,235,118,120,121,58,72,197,209,63,71,69,76,15,34,
164,73,244,171,112,39,246,223,104,169,18,125,42,220,9,253,159,217,38,68,
159,104,134,207,236,254,201,18,36,250,134,207,236,254,201,50,36,251,68,54,
127,99,246,200,145,39,212,54,127,99,246,200,145,39,218,33,179,251,131,200,
147,234,27,63,184,81,137,62,149,110,4,254,219,237,20,98,79,165,91,129,63,
179,251,36,152,147,237,16,217,253,159,217,32,196,159,80,217,253,159,217,36,
196,159,104,134,207,236,126,217,6,36,250,134,207,236,126,217,6,36,251,68,
54,127,112,115,18,125,67,103,247,8,149,2,8,196,24,143,131,137,146,90,121,
35,162,44,140,35,102,160,226,100,235,138,89,18,102,13,10,82,68,200,151,106,
130,88,131,4,192,73,225,228,85,162,137,147,168,108,252,18,42,209,68,201,
212,54,126,89,23,104,162,100,245,17,230,207,193,34,237,20,76,158,162,60,
217,249,100,109,162,137,147,163,117,2,178,120,36,109,162,137,147,163,117,2,
178,121,100,101,162,137,147,165,91,129,63,4,140,180,81,50,116,171,112,39,
229,145,150,138,38,78,161,179,251,63,178,240,72,203,69,19,39,80,217,253,
159,217,121,100,109,162,137,147,212,71,155,63,179,251,47,4,141,180,81,50,
122,136,243,103,246,127,101,229,145,150,138,38,78,161,179,251,31,182,240,
72,203,69,19,39,80,217,253,143,219,121,100,109,162,137,147,212,71,155,63,
177,251,111,4,141,180,81,50,122,136,243,103,246,63,109,229,145,54,138,38,
78,161,179,251,133,90,40,153,61,68,121,179,251,132,196,128,31,80,217,248,
36,76,72,1,245,13,159,150,69,68,128,31,168,143,54,126,9,21,18,0,126,162,60,
217,249,100,100,72,1,244,110,160,86,79,4,140,137,0,62,141,212,10,201,229,
145,113,32,7,210,173,192,159,130,69,196,128,31,74,183,2,126,89,23,18,0,125,
67,103,246,127,101,224,145,113,32,7,212,54,127,103,246,94,89,25,18,0,126,
162,60,217,253,159,217,120,36,100,72,1,250,136,243,103,246,127,101,229,145,
113,32,7,212,54,127,99,246,222,9,23,18,0,125,67,103,246,63,109,229,145,145,
32,7,234,35,205,159,216,253,183,130,70,68,128,31,168,143,54,127,99,246,222,
89,17,18,0,125,67,103,247,9,137,0,63,81,30,108,254,224,130,115,240,98,66,
128,92,136,84,45,101,180,81,50,28,78,99,193,18,40,56,153,58,178,52,211,58,
17,46,134,133,41,34,164,75,164,104,156,52,52,199,37,222,232,206,66,64,207,
18,66,136,137,19,173,62,46,155,181,167,72,147,235,226,233,186,120,121,58,
226,157,214,111,84,76,73,36,109,24,72,130,100,112,200,178,76,157,124,92,
242,70,120,25,193,34,245,241,117,240,97,1,107,33,25,212,54,160,90,7,244,29,
24,38,66,254,223,215,125,119,215,126,232,190,43,226,67,244,1,250,193,125,
111,216,11,234,254,192,63,96,159,173,234,26,84,53,19,194,126,175,168,105,
80,212,79,8,234,26,84,53,19,193,156,20,144,83,52,167,20,52,198,109,24,18,
68,225,115,150,64,53,52,104,200,84,52,131,76,167,20,52,200,46,7,48,52,146,
132,102,57,33,165,139,168,209,154,32,104,220,193,189,214,27,16,209,176,23,
26,220,98,149,110,116,70,75,188,98,116,136,34,33,101,4,192,223,178,32,38,6,
144,18,67,72,1,58,67,0,100,95,74,17,159,217,31,210,132,103,246,58,251,33,
121,232,55,150,227,125,143,216,16,190,91,141,246,68,31,150,223,178,39,150,
223,177,251,0,244,135,97,37,32,24,132,104,24,66,161,175,164,202,134,140,
151,39,212,125,255,221,125,74,86,9,79,168,104,201,116,178,139,154,22,134,
145,72,51,93,18,116,64,145,13,39,82,34,33,38,73,76,132,185,4,185,187,198,
100,229,233,197,13,49,228,73,247,4,4,78,98,79,184,32,34,105,187,201,147,
154,185,187,200,147,165,233,197,13,50,230,239,82,98,151,167,20,52,206,145,
39,234,76,69,245,22,190,224,128,138,228,73,244,180,90,251,130,2,43,145,39,
234,76,76,243,155,51,162,68,159,88,230,204,234,145,39,234,76,67,240,38,67,
200,147,232,193,50,46,68,159,169,49,31,206,164,100,137,18,125,59,169,25,54,
68,159,169,49,51,200,109,38,73,42,68,159,88,134,210,100,147,100,73,250,147,
20,188,65,57,163,146,164,73,246,68,19,154,57,74,68,159,169,49,51,200,90,
209,34,9,205,28,159,34,79,172,66,214,137,16,78,104,228,121,18,125,154,24,
72,152,147,236,208,194,101,205,39,92,82,200,147,145,137,63,82,98,103,144,
181,162,68,19,154,57,60,196,159,88,133,173,18,32,156,209,201,166,36,253,73,
138,94,32,156,209,201,70,36,251,34,9,205,28,154,98,79,212,152,153,228,54,
147,36,148,98,79,172,67,105,50,73,102,36,253,73,136,254,117,35,36,24,147,
233,221,72,201,38,36,253,73,136,126,6,12,98,79,163,6,20,98,79,212,152,135,
224,76,135,49,39,209,130,100,89,137,63,82,98,103,156,217,157,6,36,250,199,
54,103,113,137,63,82,98,47,168,181,247,4,4,86,98,79,165,162,215,220,16,17,
57,137,62,205,12,36,166,238,173,194,2,201,217,161,132,236,167,20,52,210,
155,186,183,8,11,39,70,9,147,178,156,80,211,50,110,236,208,194,118,83,138,
26,102,77,221,24,38,78,202,113,67,76,54,186,195,245,38,34,188,17,145,23,55,
117,241,32,145,36,57,173,155,186,75,189,205,35,102,128,44,243,119,74,139,
144,113,243,221,36,77,21,38,144,210,161,168,158,35,230,144,192,154,42,77,
33,165,67,81,60,15,173,7,90,159,49,13,213,64,186,17,62,96,47,170,129,116,
33,165,64,202,113,36,226,134,70,110,234,220,32,44,157,163,222,72,244,64,
145,23,55,118,143,121,35,209,2,68,140,221,213,184,64,89,58,183,88,145,232,
129,34,46,110,234,221,98,71,162,4,136,153,80,50,156,80,211,22,79,90,38,105,
16,17,17,207,18,61,96,17,10,192,76,71,106,220,32,44,157,19,152,240,68,138,
17,193,30,137,195,39,65,51,8,224,143,65,54,22,46,103,68,112,71,162,112,200,
184,144,116,17,59,20,24,243,52,72,58,8,134,42,23,50,68,108,3,206,87,71,164,
0,142,73,57,132,41,42,72,225,107,4,167,212,52,100,191,92,83,161,163,37,250,
226,158,141,145,208,89,154,79,90,4,66,73,209,153,100,180,8,133,145,208,89,
158,36,169,35,34,17,244,145,198,247,60,137,114,26,97,57,162,4,206,137,116,
17,136,48,144,68,212,97,27,57,24,64,90,201,18,5,13,25,4,5,172,160,123,215,
138,62,46,121,35,60,117,18,233,27,70,18,32,10,200,212,75,175,139,166,233,
225,228,235,138,227,130,93,117,155,215,197,207,36,103,131,212,11,161,58,
226,186,110,234,220,32,44,157,148,226,134,153,19,119,101,56,161,166,88,156,
217,78,52,20,221,17,200,147,25,137,53,17,180,97,34,0,172,140,19,154,84,26,
145,0,86,68,90,40,152,2,178,22,160,93,8,69,19,18,98,37,210,94,100,108,144,
21,145,8,151,75,23,100,141,66,37,217,16,11,32,226,248,146,164,108,250,75,
204,141,146,28,217,24,177,33,50,66,72,128,92,6,66,161,164,235,226,231,146,
51,65,36,225,144,168,105,58,248,185,228,140,240,97,68,128,153,38,98,79,174,
179,122,248,185,228,140,241,214,129,132,150,12,73,245,214,111,95,23,60,145,
158,58,50,72,81,67,230,232,184,196,159,95,23,77,211,195,201,215,21,47,139,
166,233,225,228,50,200,211,76,229,2,201,25,149,241,67,102,138,52,146,16,30,
67,18,66,3,201,34,52,78,25,61,72,160,94,115,30,230,145,179,73,26,39,12,158,
164,81,33,144,78,25,61,72,160,94,115,30,230,145,179,72,200,39,12,158,164,
80,132,75,165,67,81,50,21,18,235,65,214,169,224,140,137,210,173,192,154,30,
8,200,157,67,102,66,84,11,71,169,20,19,209,139,162,158,207,15,39,73,24,186,
43,236,176,217,130,253,36,98,232,187,177,33,73,18,52,68,233,35,23,69,93,
136,26,98,116,145,139,162,158,146,160,95,73,24,186,37,12,72,5,16,64,145,10,
32,76,71,64,156,217,161,180,34,6,64,208,198,36,78,50,20,20,92,204,50,44,
147,32,134,226,17,114,33,202,134,129,107,192,202,232,160,180,104,166,135,
52,72,40,144,213,33,178,152,26,34,56,163,105,44,104,146,116,139,77,43,34,
98,57,38,116,72,179,60,93,97,206,56,52,240,242,56,163,168,34,81,57,178,153,
42,228,12,182,58,22,66,89,19,57,68,176,74,68,35,104,195,18,239,116,102,114,
94,100,104,228,100,49,238,140,203,42,60,145,35,104,181,146,113,161,10,80,
46,68,82,24,245,145,132,108,228,148,54,100,137,64,34,13,100,153,222,1,40,6,
33,223,20,84,19,34,95,23,76,130,153,6,103,208,43,64,141,41,130,104,17,112,
130,44,96,
};

/* to convert a heap stridx to a token number, subtract
 * DUK_STRIDX_START_RESERVED and add DUK_TOK_START_RESERVED.
 */

/* native functions: 149 */
DUK_INTERNAL const duk_c_function duk_bi_native_functions[149] = {
	duk_bi_array_constructor,
	duk_bi_array_constructor_is_array,
	duk_bi_array_prototype_concat,
	duk_bi_array_prototype_indexof_shared,
	duk_bi_array_prototype_iter_shared,
	duk_bi_array_prototype_join_shared,
	duk_bi_array_prototype_pop,
	duk_bi_array_prototype_push,
	duk_bi_array_prototype_reduce_shared,
	duk_bi_array_prototype_reverse,
	duk_bi_array_prototype_shift,
	duk_bi_array_prototype_slice,
	duk_bi_array_prototype_sort,
	duk_bi_array_prototype_splice,
	duk_bi_array_prototype_to_string,
	duk_bi_array_prototype_unshift,
	duk_bi_arraybuffer_constructor,
	duk_bi_arraybuffer_isview,
	duk_bi_boolean_constructor,
	duk_bi_boolean_prototype_tostring_shared,
	duk_bi_buffer_compare_shared,
	duk_bi_buffer_constructor,
	duk_bi_buffer_prototype_tostring_shared,
	duk_bi_buffer_readfield,
	duk_bi_buffer_slice_shared,
	duk_bi_buffer_writefield,
	duk_bi_dataview_constructor,
	duk_bi_date_constructor,
	duk_bi_date_constructor_now,
	duk_bi_date_constructor_parse,
	duk_bi_date_constructor_utc,
	duk_bi_date_prototype_get_shared,
	duk_bi_date_prototype_get_timezone_offset,
	duk_bi_date_prototype_set_shared,
	duk_bi_date_prototype_set_time,
	duk_bi_date_prototype_to_json,
	duk_bi_date_prototype_tostring_shared,
	duk_bi_date_prototype_value_of,
	duk_bi_duktape_object_act,
	duk_bi_duktape_object_compact,
	duk_bi_duktape_object_dec,
	duk_bi_duktape_object_enc,
	duk_bi_duktape_object_fin,
	duk_bi_duktape_object_gc,
	duk_bi_duktape_object_info,
	duk_bi_error_constructor_shared,
	duk_bi_error_prototype_filename_getter,
	duk_bi_error_prototype_filename_setter,
	duk_bi_error_prototype_linenumber_getter,
	duk_bi_error_prototype_linenumber_setter,
	duk_bi_error_prototype_stack_getter,
	duk_bi_error_prototype_stack_setter,
	duk_bi_error_prototype_to_string,
	duk_bi_function_constructor,
	duk_bi_function_prototype,
	duk_bi_function_prototype_apply,
	duk_bi_function_prototype_bind,
	duk_bi_function_prototype_call,
	duk_bi_function_prototype_to_string,
	duk_bi_global_object_decode_uri,
	duk_bi_global_object_decode_uri_component,
	duk_bi_global_object_encode_uri,
	duk_bi_global_object_encode_uri_component,
	duk_bi_global_object_escape,
	duk_bi_global_object_eval,
	duk_bi_global_object_is_finite,
	duk_bi_global_object_is_nan,
	duk_bi_global_object_parse_float,
	duk_bi_global_object_parse_int,
	duk_bi_global_object_print_helper,
	duk_bi_global_object_require,
	duk_bi_global_object_unescape,
	duk_bi_json_object_parse,
	duk_bi_json_object_stringify,
	duk_bi_logger_constructor,
	duk_bi_logger_prototype_fmt,
	duk_bi_logger_prototype_log_shared,
	duk_bi_logger_prototype_raw,
	duk_bi_math_object_max,
	duk_bi_math_object_min,
	duk_bi_math_object_onearg_shared,
	duk_bi_math_object_random,
	duk_bi_math_object_twoarg_shared,
	duk_bi_nodejs_buffer_byte_length,
	duk_bi_nodejs_buffer_concat,
	duk_bi_nodejs_buffer_constructor,
	duk_bi_nodejs_buffer_copy,
	duk_bi_nodejs_buffer_fill,
	duk_bi_nodejs_buffer_is_buffer,
	duk_bi_nodejs_buffer_is_encoding,
	duk_bi_nodejs_buffer_tojson,
	duk_bi_nodejs_buffer_tostring,
	duk_bi_nodejs_buffer_write,
	duk_bi_number_constructor,
	duk_bi_number_prototype_to_exponential,
	duk_bi_number_prototype_to_fixed,
	duk_bi_number_prototype_to_locale_string,
	duk_bi_number_prototype_to_precision,
	duk_bi_number_prototype_to_string,
	duk_bi_number_prototype_value_of,
	duk_bi_object_constructor,
	duk_bi_object_constructor_create,
	duk_bi_object_constructor_define_properties,
	duk_bi_object_constructor_define_property,
	duk_bi_object_constructor_get_own_property_descriptor,
	duk_bi_object_constructor_is_extensible,
	duk_bi_object_constructor_is_sealed_frozen_shared,
	duk_bi_object_constructor_keys_shared,
	duk_bi_object_constructor_prevent_extensions,
	duk_bi_object_constructor_seal_freeze_shared,
	duk_bi_object_getprototype_shared,
	duk_bi_object_prototype_has_own_property,
	duk_bi_object_prototype_is_prototype_of,
	duk_bi_object_prototype_property_is_enumerable,
	duk_bi_object_prototype_to_locale_string,
	duk_bi_object_prototype_to_string,
	duk_bi_object_prototype_value_of,
	duk_bi_object_setprototype_shared,
	duk_bi_pointer_constructor,
	duk_bi_pointer_prototype_tostring_shared,
	duk_bi_proxy_constructor,
	duk_bi_regexp_constructor,
	duk_bi_regexp_prototype_exec,
	duk_bi_regexp_prototype_test,
	duk_bi_regexp_prototype_to_string,
	duk_bi_string_constructor,
	duk_bi_string_constructor_from_char_code,
	duk_bi_string_prototype_caseconv_shared,
	duk_bi_string_prototype_char_at,
	duk_bi_string_prototype_char_code_at,
	duk_bi_string_prototype_concat,
	duk_bi_string_prototype_indexof_shared,
	duk_bi_string_prototype_locale_compare,
	duk_bi_string_prototype_match,
	duk_bi_string_prototype_replace,
	duk_bi_string_prototype_search,
	duk_bi_string_prototype_slice,
	duk_bi_string_prototype_split,
	duk_bi_string_prototype_substr,
	duk_bi_string_prototype_substring,
	duk_bi_string_prototype_to_string,
	duk_bi_string_prototype_trim,
	duk_bi_thread_constructor,
	duk_bi_thread_current,
	duk_bi_thread_resume,
	duk_bi_thread_yield,
	duk_bi_type_error_thrower,
	duk_bi_typedarray_constructor,
	duk_bi_typedarray_set,
};

DUK_INTERNAL const duk_uint8_t duk_builtins_data[1955] = {
105,195,75,32,121,40,105,53,14,252,104,54,8,131,72,0,115,225,65,165,244,55,
243,6,145,32,210,24,210,186,25,249,35,120,216,99,226,13,79,33,116,177,164,
180,44,192,4,202,52,150,220,24,0,169,70,146,219,123,0,23,40,210,91,110,96,
3,37,26,75,109,172,0,108,163,73,109,177,128,14,148,105,45,181,176,1,242,
144,56,209,36,94,6,167,133,98,80,211,28,1,250,67,72,168,67,232,13,46,192,
47,162,52,165,0,62,80,163,72,128,61,40,107,26,7,37,20,53,201,131,88,0,66,
134,185,48,98,80,215,38,11,96,0,138,26,228,193,76,0,69,67,92,152,37,128,6,
168,107,147,4,48,1,165,13,114,96,118,0,44,161,174,76,12,192,7,148,53,201,
129,88,1,26,134,165,80,130,80,31,255,241,69,224,63,252,0,0,0,0,0,0,46,32,
63,248,0,0,0,0,0,0,47,98,7,140,16,116,194,7,12,48,108,196,6,140,80,100,198,
6,12,112,92,200,5,140,149,192,202,91,204,181,184,204,91,76,213,176,206,90,
204,240,84,208,5,13,9,124,210,43,13,24,64,226,131,205,112,56,216,3,77,152,
48,218,130,205,184,40,220,130,77,216,32,222,129,205,248,24,224,129,78,25,
214,164,2,90,81,17,104,67,37,157,8,150,100,18,89,78,201,100,60,37,140,244,
150,35,226,88,79,201,96,71,37,125,20,122,188,138,62,0,2,165,70,39,255,255,
193,43,67,0,0,80,127,192,58,182,220,80,0,21,59,170,64,0,107,77,8,172,181,
146,176,202,138,187,59,42,204,200,170,182,146,168,218,80,0,26,155,97,42,77,
68,168,181,20,0,6,160,210,74,123,89,64,0,127,255,4,10,153,219,157,70,163,
185,130,140,228,10,43,160,40,141,228,161,184,18,132,226,64,161,127,128,0,
63,225,1,109,74,8,137,71,58,5,4,221,20,3,147,233,249,193,240,80,255,192,6,
120,2,64,127,195,0,173,28,56,20,96,80,128,0,206,192,143,167,64,164,156,131,
2,112,14,125,55,9,4,216,40,19,80,180,77,3,9,51,13,94,153,7,159,76,64,207,
192,0,102,0,103,255,255,242,240,67,73,112,33,168,0,12,180,16,212,0,10,88,8,
106,0,7,43,4,53,0,4,149,4,31,128,0,202,66,15,255,255,194,137,254,0,50,135,
227,224,127,196,2,87,132,17,82,143,24,10,44,96,36,240,4,147,64,146,119,4,
125,49,131,52,152,65,154,128,0,201,97,9,36,133,36,142,25,18,40,114,77,98,
17,33,137,68,130,45,17,247,240,71,159,193,29,127,8,0,12,113,252,32,0,49,
184,208,70,162,144,20,95,240,0,7,252,80,37,120,193,81,196,194,0,3,69,19,0,
81,191,197,140,192,127,239,255,255,255,255,255,255,140,64,0,0,0,0,0,0,0,1,
139,192,127,248,0,0,0,0,0,0,138,192,127,240,0,0,0,0,0,0,139,64,255,240,0,0,
0,0,0,0,0,31,241,128,149,224,0,0,0,0,0,0,0,0,13,71,98,37,25,128,148,86,48,
69,23,201,19,94,36,73,132,129,71,255,0,56,136,233,34,3,223,208,241,192,3,
254,56,18,188,135,255,128,0,0,0,0,0,11,104,228,128,135,18,4,0,6,26,72,16,0,
42,49,32,64,0,225,132,129,0,4,133,146,4,0,21,210,72,16,0,103,65,32,64,1,
220,228,100,162,146,130,20,74,8,72,248,64,2,33,3,225,0,9,131,143,132,0,42,
12,62,16,0,184,40,248,64,3,32,131,225,0,13,129,143,132,0,58,4,62,16,0,248,
8,248,64,4,32,3,225,0,17,127,143,132,0,73,252,62,16,1,55,232,248,64,5,31,
131,225,0,21,125,143,132,0,89,244,62,16,1,119,201,0,31,4,68,123,144,148,0,
97,236,66,80,1,151,169,10,248,0,211,208,133,124,0,109,230,66,254,0,56,242,
33,127,0,29,120,144,207,128,15,60,8,103,192,7,221,228,37,0,32,119,16,148,0,
133,218,66,190,0,68,236,33,95,0,35,117,144,191,128,18,58,136,95,192,9,92,
195,225,0,38,114,144,148,0,156,41,31,224,0,15,249,1,138,144,65,192,2,22,0,
88,16,46,24,77,208,148,103,4,102,252,102,244,128,0,0,0,0,0,0,0,0,220,111,
68,113,61,146,142,248,0,164,255,128,0,63,228,133,109,16,89,178,65,18,235,
153,25,150,220,184,188,180,230,6,32,209,205,0,20,175,240,0,39,252,160,77,
162,184,54,72,34,0,82,255,192,0,159,242,193,54,138,222,217,32,136,1,76,255,
0,2,127,204,4,218,43,115,100,130,32,5,55,252,0,9,255,52,19,104,173,173,146,
8,128,20,239,240,0,39,252,224,77,162,182,54,72,34,0,83,255,192,0,159,243,
193,54,138,214,217,32,136,0,255,255,33,177,1,0,22,252,42,44,81,93,165,175,
1,0,9,174,198,238,213,84,89,173,0,255,152,185,11,251,232,231,189,171,0,255,
220,85,29,148,174,11,249,169,0,255,111,45,236,84,155,148,57,167,1,0,36,135,
237,81,16,180,97,165,0,255,154,130,121,153,252,239,53,163,0,255,218,130,
121,153,252,239,53,38,130,129,25,234,5,0,1,103,40,20,0,9,154,160,80,0,54,
98,146,25,106,5,0,4,101,40,20,0,21,146,160,80,0,102,66,129,64,1,216,234,5,
0,8,99,39,47,49,83,215,152,138,73,0,1,97,168,129,132,160,80,0,150,10,129,
64,2,152,10,5,0,11,95,168,20,0,48,31,255,224,5,17,72,66,249,37,129,127,255,
0,0,191,255,128,0,63,255,197,31,192,64,196,80,128,0,0,0,0,8,26,112,17,169,
0,154,80,1,171,28,124,88,65,233,49,7,133,100,29,149,15,14,138,71,135,37,3,
195,66,114,5,77,252,0,243,178,40,25,200,48,101,30,0,127,210,128,0,85,31,
192,0,31,244,224,5,71,22,8,0,13,20,88,1,85,127,0,0,127,212,128,21,29,220,
32,0,52,87,112,5,89,252,0,1,255,86,16,166,66,0,0,0,0,0,0,0,0,170,72,38,29,
219,247,16,49,75,32,193,52,130,244,193,225,114,96,248,0,8,249,48,124,0,8,
90,152,62,0,6,44,76,31,0,4,21,166,15,128,2,147,255,252,38,212,16,184,155,
250,226,217,150,47,46,91,249,54,96,139,229,229,203,127,36,26,119,32,203,
203,150,254,72,52,97,221,147,102,157,217,192,10,191,248,0,157,4,72,15,250,
224,1,154,140,36,0,8,43,31,224,0,15,251,0,16,55,139,164,0,192,220,46,144,2,
3,104,186,64,12,77,130,233,0,33,53,139,164,0,200,212,46,144,2,35,72,186,64,
8,205,2,233,0,36,51,140,180,0,192,204,50,208,2,3,40,203,64,12,76,131,45,0,
33,49,140,180,0,200,196,50,208,2,35,8,203,64,8,204,3,45,0,36,7,255,248,1,
82,101,16,112,24,72,0,8,86,159,193,56,192,63,240,0,0,0,0,0,0,1,151,246,96,
0,21,183,240,78,48,15,252,0,0,0,0,0,0,0,101,253,168,0,5,113,252,19,140,3,
255,0,0,0,0,0,0,0,25,127,110,0,1,93,127,4,227,1,0,0,0,0,0,0,0,0,6,95,220,
128,0,87,159,193,56,192,64,0,0,0,0,0,0,0,1,151,247,96,0,21,247,240,78,48,
16,4,0,0,0,0,0,0,0,101,253,232,0,5,129,252,19,140,4,1,0,0,0,0,0,0,0,25,127,
126,0,1,97,127,4,227,1,0,64,0,0,0,0,0,0,6,95,224,128,0,88,159,193,56,192,
64,32,0,0,0,0,0,0,1,151,248,96,0,22,55,240,5,157,170,33,68,178,69,10,193,
20,10,104,79,138,36,0,12,31,248,160,88,154,23,66,100,93,32,2,9,129,116,128,
0,165,197,210,0,18,150,23,72,0,138,84,93,32,3,41,65,116,128,1,36,197,210,0,
20,146,23,72,0,146,68,93,32,3,73,1,116,128,1,163,197,210,0,22,142,23,72,0,
34,52,93,32,1,136,193,118,128,2,162,197,218,0,26,138,23,104,0,170,36,93,
160,3,168,129,150,33,198,90,0,32,134,25,104,0,10,20,101,160,1,40,65,150,
128,8,160,198,90,0,50,130,25,104,0,18,4,101,160,1,72,1,150,128,9,31,198,90,
0,52,126,25,104,0,25,244,101,160,1,103,193,150,128,2,30,198,90,0,24,122,25,
136,0,41,228,102,32,1,167,129,152,128,10,157,198,98,0,59,71,91,99,157,104,
9,213,118,39,5,8,159,20,40,0,10,109,90,19,81,132,39,151,32,
};
#ifdef DUK_USE_BUILTIN_INITJS
DUK_INTERNAL const duk_uint8_t duk_initjs_data[187] = {
40,102,117,110,99,116,105,111,110,40,100,44,97,41,123,102,117,110,99,116,
105,111,110,32,98,40,97,44,98,44,99,41,123,79,98,106,101,99,116,46,100,101,
102,105,110,101,80,114,111,112,101,114,116,121,40,97,44,98,44,123,118,97,
108,117,101,58,99,44,119,114,105,116,97,98,108,101,58,33,48,44,101,110,117,
109,101,114,97,98,108,101,58,33,49,44,99,111,110,102,105,103,117,114,97,98,
108,101,58,33,48,125,41,125,98,40,97,46,76,111,103,103,101,114,44,34,99,
108,111,103,34,44,110,101,119,32,97,46,76,111,103,103,101,114,40,34,67,34,
41,41,59,98,40,97,44,34,109,111,100,76,111,97,100,101,100,34,44,123,125,41,
125,41,40,116,104,105,115,44,68,117,107,116,97,112,101,41,59,10,0,
};
#endif  /* DUK_USE_BUILTIN_INITJS */
#elif defined(DUK_USE_DOUBLE_ME)
DUK_INTERNAL const duk_uint8_t duk_strings_data[2624] = {
55,86,227,24,145,55,102,120,144,3,63,94,228,54,100,137,186,50,11,164,109,
77,215,5,61,35,106,206,149,110,4,254,219,237,58,8,196,24,103,74,183,2,127,
103,246,93,4,98,12,47,180,67,103,246,127,101,208,70,32,194,186,134,207,236,
254,203,160,140,65,133,246,136,108,254,199,237,186,8,196,24,87,80,217,253,
143,219,116,17,136,49,30,209,13,159,220,116,75,3,30,65,244,17,136,48,174,
209,13,159,220,116,17,136,48,158,161,179,251,142,130,49,6,17,209,130,96,
237,80,75,47,160,140,65,142,134,133,41,34,110,134,133,41,34,3,25,110,8,22,
158,130,38,163,8,217,200,158,76,156,210,117,128,153,203,210,70,46,137,187,
18,27,164,187,201,209,130,100,55,91,70,4,145,63,66,231,44,128,105,187,41,
197,13,49,122,8,196,24,71,75,70,138,104,115,77,215,5,36,20,201,214,209,107,
79,104,209,144,168,105,6,207,251,209,104,209,125,212,227,66,127,235,191,
239,232,180,90,52,95,69,247,83,141,9,255,174,255,191,162,211,80,210,253,23,
221,78,52,39,254,183,254,254,139,72,105,126,139,238,167,26,19,255,91,255,
127,69,166,129,191,69,247,83,141,9,255,175,255,191,162,213,26,50,23,232,
190,234,113,161,63,245,115,119,86,227,118,83,138,26,98,9,110,48,86,22,148,
160,152,22,82,70,46,137,44,8,180,163,32,104,98,206,32,17,7,16,88,101,100,
206,42,70,36,108,205,18,74,140,33,196,230,60,2,152,146,33,38,230,8,36,79,
182,251,65,156,151,24,200,33,145,162,25,80,209,24,67,0,166,68,52,174,61,73,
25,33,205,25,27,84,177,195,234,220,1,144,105,99,135,217,16,17,17,208,72,
199,179,60,93,100,146,49,232,162,64,76,135,19,152,244,44,136,223,98,67,4,
18,33,247,217,158,36,0,209,190,156,13,26,201,21,111,165,67,64,180,100,145,
62,250,32,45,100,33,55,214,1,229,223,65,19,72,187,236,206,137,35,125,120,
190,201,104,105,15,190,201,212,136,136,125,246,160,137,27,83,239,171,37,
200,218,159,125,168,34,192,61,27,233,93,22,1,114,78,250,28,76,130,112,200,
93,245,164,188,207,190,204,17,49,38,109,246,160,93,8,119,185,13,153,34,173,
246,113,0,136,48,76,10,90,26,78,182,140,9,34,130,161,100,235,64,194,9,226,
44,166,1,41,221,153,226,235,118,120,121,58,72,197,209,63,71,69,76,15,34,
164,73,244,171,112,39,246,223,104,169,18,125,42,220,9,253,159,217,38,68,
159,104,134,207,236,254,201,18,36,250,134,207,236,254,201,50,36,251,68,54,
127,99,246,200,145,39,212,54,127,99,246,200,145,39,218,33,179,251,131,200,
147,234,27,63,184,81,137,62,149,110,4,254,219,237,20,98,79,165,91,129,63,
179,251,36,152,147,237,16,217,253,159,217,32,196,159,80,217,253,159,217,36,
196,159,104,134,207,236,126,217,6,36,250,134,207,236,126,217,6,36,251,68,
54,127,112,115,18,125,67,103,247,8,149,2,8,196,24,143,131,137,146,90,121,
35,162,44,140,35,102,160,226,100,235,138,89,18,102,13,10,82,68,200,151,106,
130,88,131,4,192,73,225,228,85,162,137,147,168,108,252,18,42,209,68,201,
212,54,126,89,23,104,162,100,245,17,230,207,193,34,237,20,76,158,162,60,
217,249,100,109,162,137,147,163,117,2,178,120,36,109,162,137,147,163,117,2,
178,121,100,101,162,137,147,165,91,129,63,4,140,180,81,50,116,171,112,39,
229,145,150,138,38,78,161,179,251,63,178,240,72,203,69,19,39,80,217,253,
159,217,121,100,109,162,137,147,212,71,155,63,179,251,47,4,141,180,81,50,
122,136,243,103,246,127,101,229,145,150,138,38,78,161,179,251,31,182,240,
72,203,69,19,39,80,217,253,143,219,121,100,109,162,137,147,212,71,155,63,
177,251,111,4,141,180,81,50,122,136,243,103,246,63,109,229,145,54,138,38,
78,161,179,251,133,90,40,153,61,68,121,179,251,132,196,128,31,80,217,248,
36,76,72,1,245,13,159,150,69,68,128,31,168,143,54,126,9,21,18,0,126,162,60,
217,249,100,100,72,1,244,110,160,86,79,4,140,137,0,62,141,212,10,201,229,
145,113,32,7,210,173,192,159,130,69,196,128,31,74,183,2,126,89,23,18,0,125,
67,103,246,127,101,224,145,113,32,7,212,54,127,103,246,94,89,25,18,0,126,
162,60,217,253,159,217,120,36,100,72,1,250,136,243,103,246,127,101,229,145,
113,32,7,212,54,127,99,246,222,9,23,18,0,125,67,103,246,63,109,229,145,145,
32,7,234,35,205,159,216,253,183,130,70,68,128,31,168,143,54,127,99,246,222,
89,17,18,0,125,67,103,247,9,137,0,63,81,30,108,254,224,130,115,240,98,66,
128,92,136,84,45,101,180,81,50,28,78,99,193,18,40,56,153,58,178,52,211,58,
17,46,134,133,41,34,164,75,164,104,156,52,52,199,37,222,232,206,66,64,207,
18,66,136,137,19,173,62,46,155,181,167,72,147,235,226,233,186,120,121,58,
226,157,214,111,84,76,73,36,109,24,72,130,100,112,200,178,76,157,124,92,
242,70,120,25,193,34,245,241,117,240,97,1,107,33,25,212,54,160,90,7,244,29,
24,38,66,254,223,215,125,119,215,126,232,190,43,226,67,244,1,250,193,125,
111,216,11,234,254,192,63,96,159,173,234,26,84,53,19,194,126,175,168,105,
80,212,79,8,234,26,84,53,19,193,156,20,144,83,52,167,20,52,198,109,24,18,
68,225,115,150,64,53,52,104,200,84,52,131,76,167,20,52,200,46,7,48,52,146,
132,102,57,33,165,139,168,209,154,32,104,220,193,189,214,27,16,209,176,23,
26,220,98,149,110,116,70,75,188,98,116,136,34,33,101,4,192,223,178,32,38,6,
144,18,67,72,1,58,67,0,100,95,74,17,159,217,31,210,132,103,246,58,251,33,
121,232,55,150,227,125,143,216,16,190,91,141,246,68,31,150,223,178,39,150,
223,177,251,0,244,135,97,37,32,24,132,104,24,66,161,175,164,202,134,140,
151,39,212,125,255,221,125,74,86,9,79,168,104,201,116,178,139,154,22,134,
145,72,51,93,18,116,64,145,13,39,82,34,33,38,73,76,132,185,4,185,187,198,
100,229,233,197,13,49,228,73,247,4,4,78,98,79,184,32,34,105,187,201,147,
154,185,187,200,147,165,233,197,13,50,230,239,82,98,151,167,20,52,206,145,
39,234,76,69,245,22,190,224,128,138,228,73,244,180,90,251,130,2,43,145,39,
234,76,76,243,155,51,162,68,159,88,230,204,234,145,39,234,76,67,240,38,67,
200,147,232,193,50,46,68,159,169,49,31,206,164,100,137,18,125,59,169,25,54,
68,159,169,49,51,200,109,38,73,42,68,159,88,134,210,100,147,100,73,250,147,
20,188,65,57,163,146,164,73,246,68,19,154,57,74,68,159,169,49,51,200,90,
209,34,9,205,28,159,34,79,172,66,214,137,16,78,104,228,121,18,125,154,24,
72,152,147,236,208,194,101,205,39,92,82,200,147,145,137,63,82,98,103,144,
181,162,68,19,154,57,60,196,159,88,133,173,18,32,156,209,201,166,36,253,73,
138,94,32,156,209,201,70,36,251,34,9,205,28,154,98,79,212,152,153,228,54,
147,36,148,98,79,172,67,105,50,73,102,36,253,73,136,254,117,35,36,24,147,
233,221,72,201,38,36,253,73,136,126,6,12,98,79,163,6,20,98,79,212,152,135,
224,76,135,49,39,209,130,100,89,137,63,82,98,103,156,217,157,6,36,250,199,
54,103,113,137,63,82,98,47,168,181,247,4,4,86,98,79,165,162,215,220,16,17,
57,137,62,205,12,36,166,238,173,194,2,201,217,161,132,236,167,20,52,210,
155,186,183,8,11,39,70,9,147,178,156,80,211,50,110,236,208,194,118,83,138,
26,102,77,221,24,38,78,202,113,67,76,54,186,195,245,38,34,188,17,145,23,55,
117,241,32,145,36,57,173,155,186,75,189,205,35,102,128,44,243,119,74,139,
144,113,243,221,36,77,21,38,144,210,161,168,158,35,230,144,192,154,42,77,
33,165,67,81,60,15,173,7,90,159,49,13,213,64,186,17,62,96,47,170,129,116,
33,165,64,202,113,36,226,134,70,110,234,220,32,44,157,163,222,72,244,64,
145,23,55,118,143,121,35,209,2,68,140,221,213,184,64,89,58,183,88,145,232,
129,34,46,110,234,221,98,71,162,4,136,153,80,50,156,80,211,22,79,90,38,105,
16,17,17,207,18,61,96,17,10,192,76,71,106,220,32,44,157,19,152,240,68,138,
17,193,30,137,195,39,65,51,8,224,143,65,54,22,46,103,68,112,71,162,112,200,
184,144,116,17,59,20,24,243,52,72,58,8,134,42,23,50,68,108,3,206,87,71,164,
0,142,73,57,132,41,42,72,225,107,4,167,212,52,100,191,92,83,161,163,37,250,
226,158,141,145,208,89,154,79,90,4,66,73,209,153,100,180,8,133,145,208,89,
158,36,169,35,34,17,244,145,198,247,60,137,114,26,97,57,162,4,206,137,116,
17,136,48,144,68,212,97,27,57,24,64,90,201,18,5,13,25,4,5,172,160,123,215,
138,62,46,121,35,60,117,18,233,27,70,18,32,10,200,212,75,175,139,166,233,
225,228,235,138,227,130,93,117,155,215,197,207,36,103,131,212,11,161,58,
226,186,110,234,220,32,44,157,148,226,134,153,19,119,101,56,161,166,88,156,
217,78,52,20,221,17,200,147,25,137,53,17,180,97,34,0,172,140,19,154,84,26,
145,0,86,68,90,40,152,2,178,22,160,93,8,69,19,18,98,37,210,94,100,108,144,
21,145,8,151,75,23,100,141,66,37,217,16,11,32,226,248,146,164,108,250,75,
204,141,146,28,217,24,177,33,50,66,72,128,92,6,66,161,164,235,226,231,146,
51,65,36,225,144,168,105,58,248,185,228,140,240,97,68,128,153,38,98,79,174,
179,122,248,185,228,140,241,214,129,132,150,12,73,245,214,111,95,23,60,145,
158,58,50,72,81,67,230,232,184,196,159,95,23,77,211,195,201,215,21,47,139,
166,233,225,228,50,200,211,76,229,2,201,25,149,241,67,102,138,52,146,16,30,
67,18,66,3,201,34,52,78,25,61,72,160,94,115,30,230,145,179,73,26,39,12,158,
164,81,33,144,78,25,61,72,160,94,115,30,230,145,179,72,200,39,12,158,164,
80,132,75,165,67,81,50,21,18,235,65,214,169,224,140,137,210,173,192,154,30,
8,200,157,67,102,66,84,11,71,169,20,19,209,139,162,158,207,15,39,73,24,186,
43,236,176,217,130,253,36,98,232,187,177,33,73,18,52,68,233,35,23,69,93,
136,26,98,116,145,139,162,158,146,160,95,73,24,186,37,12,72,5,16,64,145,10,
32,76,71,64,156,217,161,180,34,6,64,208,198,36,78,50,20,20,92,204,50,44,
147,32,134,226,17,114,33,202,134,129,107,192,202,232,160,180,104,166,135,
52,72,40,144,213,33,178,152,26,34,56,163,105,44,104,146,116,139,77,43,34,
98,57,38,116,72,179,60,93,97,206,56,52,240,242,56,163,168,34,81,57,178,153,
42,228,12,182,58,22,66,89,19,57,68,176,74,68,35,104,195,18,239,116,102,114,
94,100,104,228,100,49,238,140,203,42,60,145,35,104,181,146,113,161,10,80,
46,68,82,24,245,145,132,108,228,148,54,100,137,64,34,13,100,153,222,1,40,6,
33,223,20,84,19,34,95,23,76,130,153,6,103,208,43,64,141,41,130,104,17,112,
130,44,96,
};

/* to convert a heap stridx to a token number, subtract
 * DUK_STRIDX_START_RESERVED and add DUK_TOK_START_RESERVED.
 */

/* native functions: 149 */
DUK_INTERNAL const duk_c_function duk_bi_native_functions[149] = {
	duk_bi_array_constructor,
	duk_bi_array_constructor_is_array,
	duk_bi_array_prototype_concat,
	duk_bi_array_prototype_indexof_shared,
	duk_bi_array_prototype_iter_shared,
	duk_bi_array_prototype_join_shared,
	duk_bi_array_prototype_pop,
	duk_bi_array_prototype_push,
	duk_bi_array_prototype_reduce_shared,
	duk_bi_array_prototype_reverse,
	duk_bi_array_prototype_shift,
	duk_bi_array_prototype_slice,
	duk_bi_array_prototype_sort,
	duk_bi_array_prototype_splice,
	duk_bi_array_prototype_to_string,
	duk_bi_array_prototype_unshift,
	duk_bi_arraybuffer_constructor,
	duk_bi_arraybuffer_isview,
	duk_bi_boolean_constructor,
	duk_bi_boolean_prototype_tostring_shared,
	duk_bi_buffer_compare_shared,
	duk_bi_buffer_constructor,
	duk_bi_buffer_prototype_tostring_shared,
	duk_bi_buffer_readfield,
	duk_bi_buffer_slice_shared,
	duk_bi_buffer_writefield,
	duk_bi_dataview_constructor,
	duk_bi_date_constructor,
	duk_bi_date_constructor_now,
	duk_bi_date_constructor_parse,
	duk_bi_date_constructor_utc,
	duk_bi_date_prototype_get_shared,
	duk_bi_date_prototype_get_timezone_offset,
	duk_bi_date_prototype_set_shared,
	duk_bi_date_prototype_set_time,
	duk_bi_date_prototype_to_json,
	duk_bi_date_prototype_tostring_shared,
	duk_bi_date_prototype_value_of,
	duk_bi_duktape_object_act,
	duk_bi_duktape_object_compact,
	duk_bi_duktape_object_dec,
	duk_bi_duktape_object_enc,
	duk_bi_duktape_object_fin,
	duk_bi_duktape_object_gc,
	duk_bi_duktape_object_info,
	duk_bi_error_constructor_shared,
	duk_bi_error_prototype_filename_getter,
	duk_bi_error_prototype_filename_setter,
	duk_bi_error_prototype_linenumber_getter,
	duk_bi_error_prototype_linenumber_setter,
	duk_bi_error_prototype_stack_getter,
	duk_bi_error_prototype_stack_setter,
	duk_bi_error_prototype_to_string,
	duk_bi_function_constructor,
	duk_bi_function_prototype,
	duk_bi_function_prototype_apply,
	duk_bi_function_prototype_bind,
	duk_bi_function_prototype_call,
	duk_bi_function_prototype_to_string,
	duk_bi_global_object_decode_uri,
	duk_bi_global_object_decode_uri_component,
	duk_bi_global_object_encode_uri,
	duk_bi_global_object_encode_uri_component,
	duk_bi_global_object_escape,
	duk_bi_global_object_eval,
	duk_bi_global_object_is_finite,
	duk_bi_global_object_is_nan,
	duk_bi_global_object_parse_float,
	duk_bi_global_object_parse_int,
	duk_bi_global_object_print_helper,
	duk_bi_global_object_require,
	duk_bi_global_object_unescape,
	duk_bi_json_object_parse,
	duk_bi_json_object_stringify,
	duk_bi_logger_constructor,
	duk_bi_logger_prototype_fmt,
	duk_bi_logger_prototype_log_shared,
	duk_bi_logger_prototype_raw,
	duk_bi_math_object_max,
	duk_bi_math_object_min,
	duk_bi_math_object_onearg_shared,
	duk_bi_math_object_random,
	duk_bi_math_object_twoarg_shared,
	duk_bi_nodejs_buffer_byte_length,
	duk_bi_nodejs_buffer_concat,
	duk_bi_nodejs_buffer_constructor,
	duk_bi_nodejs_buffer_copy,
	duk_bi_nodejs_buffer_fill,
	duk_bi_nodejs_buffer_is_buffer,
	duk_bi_nodejs_buffer_is_encoding,
	duk_bi_nodejs_buffer_tojson,
	duk_bi_nodejs_buffer_tostring,
	duk_bi_nodejs_buffer_write,
	duk_bi_number_constructor,
	duk_bi_number_prototype_to_exponential,
	duk_bi_number_prototype_to_fixed,
	duk_bi_number_prototype_to_locale_string,
	duk_bi_number_prototype_to_precision,
	duk_bi_number_prototype_to_string,
	duk_bi_number_prototype_value_of,
	duk_bi_object_constructor,
	duk_bi_object_constructor_create,
	duk_bi_object_constructor_define_properties,
	duk_bi_object_constructor_define_property,
	duk_bi_object_constructor_get_own_property_descriptor,
	duk_bi_object_constructor_is_extensible,
	duk_bi_object_constructor_is_sealed_frozen_shared,
	duk_bi_object_constructor_keys_shared,
	duk_bi_object_constructor_prevent_extensions,
	duk_bi_object_constructor_seal_freeze_shared,
	duk_bi_object_getprototype_shared,
	duk_bi_object_prototype_has_own_property,
	duk_bi_object_prototype_is_prototype_of,
	duk_bi_object_prototype_property_is_enumerable,
	duk_bi_object_prototype_to_locale_string,
	duk_bi_object_prototype_to_string,
	duk_bi_object_prototype_value_of,
	duk_bi_object_setprototype_shared,
	duk_bi_pointer_constructor,
	duk_bi_pointer_prototype_tostring_shared,
	duk_bi_proxy_constructor,
	duk_bi_regexp_constructor,
	duk_bi_regexp_prototype_exec,
	duk_bi_regexp_prototype_test,
	duk_bi_regexp_prototype_to_string,
	duk_bi_string_constructor,
	duk_bi_string_constructor_from_char_code,
	duk_bi_string_prototype_caseconv_shared,
	duk_bi_string_prototype_char_at,
	duk_bi_string_prototype_char_code_at,
	duk_bi_string_prototype_concat,
	duk_bi_string_prototype_indexof_shared,
	duk_bi_string_prototype_locale_compare,
	duk_bi_string_prototype_match,
	duk_bi_string_prototype_replace,
	duk_bi_string_prototype_search,
	duk_bi_string_prototype_slice,
	duk_bi_string_prototype_split,
	duk_bi_string_prototype_substr,
	duk_bi_string_prototype_substring,
	duk_bi_string_prototype_to_string,
	duk_bi_string_prototype_trim,
	duk_bi_thread_constructor,
	duk_bi_thread_current,
	duk_bi_thread_resume,
	duk_bi_thread_yield,
	duk_bi_type_error_thrower,
	duk_bi_typedarray_constructor,
	duk_bi_typedarray_set,
};

DUK_INTERNAL const duk_uint8_t duk_builtins_data[1955] = {
105,195,75,32,121,40,105,53,14,252,104,54,8,131,72,0,115,225,65,165,244,55,
243,6,145,32,210,24,210,186,25,249,35,120,216,99,226,13,79,33,116,177,164,
180,44,192,4,202,52,150,220,24,0,169,70,146,219,123,0,23,40,210,91,110,96,
3,37,26,75,109,172,0,108,163,73,109,177,128,14,148,105,45,181,176,1,242,
144,56,209,36,94,6,167,133,98,80,211,28,1,250,67,72,168,67,232,13,46,192,
47,162,52,165,0,62,80,163,72,128,61,40,107,26,7,37,20,53,201,131,88,0,66,
134,185,48,98,80,215,38,11,96,0,138,26,228,193,76,0,69,67,92,152,37,128,6,
168,107,147,4,48,1,165,13,114,96,118,0,44,161,174,76,12,192,7,148,53,201,
129,88,1,26,134,165,80,130,80,31,255,241,69,224,0,0,124,63,128,0,0,0,46,32,
0,0,120,63,128,0,0,0,47,98,7,140,16,116,194,7,12,48,108,196,6,140,80,100,
198,6,12,112,92,200,5,140,149,192,202,91,204,181,184,204,91,76,213,176,206,
90,204,240,84,208,5,13,9,124,210,43,13,24,64,226,131,205,112,56,216,3,77,
152,48,218,130,205,184,40,220,130,77,216,32,222,129,205,248,24,224,129,78,
25,214,164,2,90,81,17,104,67,37,157,8,150,100,18,89,78,201,100,60,37,140,
244,150,35,226,88,79,201,96,71,37,125,20,122,188,138,62,0,2,165,70,39,255,
255,193,43,67,0,0,80,127,192,58,182,220,80,0,21,59,170,64,0,107,77,8,172,
181,146,176,202,138,187,59,42,204,200,170,182,146,168,218,80,0,26,155,97,
42,77,68,168,181,20,0,6,160,210,74,123,89,64,0,127,255,4,10,153,219,157,70,
163,185,130,140,228,10,43,160,40,141,228,161,184,18,132,226,64,161,127,128,
0,63,225,1,109,74,8,137,71,58,5,4,221,20,3,147,233,249,193,240,80,255,192,
6,120,2,64,127,195,0,173,28,56,20,96,80,128,0,206,192,143,167,64,164,156,
131,2,112,14,125,55,9,4,216,40,19,80,180,77,3,9,51,13,94,153,7,159,76,64,
207,192,0,102,0,103,255,255,242,240,67,73,112,33,168,0,12,180,16,212,0,10,
88,8,106,0,7,43,4,53,0,4,149,4,31,128,0,202,66,15,255,255,194,137,254,0,50,
135,227,224,127,196,2,87,132,17,82,143,24,10,44,96,36,240,4,147,64,146,119,
4,125,49,131,52,152,65,154,128,0,201,97,9,36,133,36,142,25,18,40,114,77,98,
17,33,137,68,130,45,17,247,240,71,159,193,29,127,8,0,12,113,252,32,0,49,
184,208,70,162,144,20,95,240,0,7,252,80,37,120,193,81,196,194,0,3,69,19,0,
81,191,197,140,192,255,255,239,127,255,255,255,255,140,64,0,0,0,0,1,0,0,0,
139,192,0,0,248,127,0,0,0,0,138,192,0,0,240,127,0,0,0,0,139,64,0,0,240,255,
0,0,0,0,0,31,241,128,149,224,0,0,0,0,0,0,0,0,13,71,98,37,25,128,148,86,48,
69,23,201,19,94,36,73,132,129,71,255,0,56,136,233,34,3,223,208,241,192,3,
254,56,18,188,128,0,15,135,240,0,0,0,11,104,228,128,135,18,4,0,6,26,72,16,
0,42,49,32,64,0,225,132,129,0,4,133,146,4,0,21,210,72,16,0,103,65,32,64,1,
220,228,100,162,146,130,20,74,8,72,248,64,2,33,3,225,0,9,131,143,132,0,42,
12,62,16,0,184,40,248,64,3,32,131,225,0,13,129,143,132,0,58,4,62,16,0,248,
8,248,64,4,32,3,225,0,17,127,143,132,0,73,252,62,16,1,55,232,248,64,5,31,
131,225,0,21,125,143,132,0,89,244,62,16,1,119,201,0,31,4,68,123,144,148,0,
97,236,66,80,1,151,169,10,248,0,211,208,133,124,0,109,230,66,254,0,56,242,
33,127,0,29,120,144,207,128,15,60,8,103,192,7,221,228,37,0,32,119,16,148,0,
133,218,66,190,0,68,236,33,95,0,35,117,144,191,128,18,58,136,95,192,9,92,
195,225,0,38,114,144,148,0,156,41,31,224,0,15,249,1,138,144,65,192,2,22,0,
88,16,46,24,77,208,148,103,4,102,252,102,244,128,0,0,0,0,0,0,0,0,220,111,
68,113,61,146,142,248,0,164,255,128,0,63,228,133,109,16,89,178,65,18,235,
153,25,150,220,184,188,180,230,6,32,209,205,0,20,175,240,0,39,252,160,77,
162,184,54,72,34,0,82,255,192,0,159,242,193,54,138,222,217,32,136,1,76,255,
0,2,127,204,4,218,43,115,100,130,32,5,55,252,0,9,255,52,19,104,173,173,146,
8,128,20,239,240,0,39,252,224,77,162,182,54,72,34,0,83,255,192,0,159,243,
193,54,138,214,217,32,136,0,255,255,33,177,0,42,252,21,1,165,92,82,45,175,
2,197,172,9,0,89,86,214,237,173,1,8,187,152,255,188,231,235,249,171,1,28,
87,220,255,250,8,173,149,169,1,239,47,108,252,59,148,152,85,167,3,236,132,
37,0,96,181,17,81,165,2,122,131,152,255,52,237,253,153,163,2,122,131,216,
255,52,237,253,153,38,130,129,25,234,5,0,1,103,40,20,0,9,154,160,80,0,54,
98,146,25,106,5,0,4,101,40,20,0,21,146,160,80,0,102,66,129,64,1,216,234,5,
0,8,99,39,47,49,83,215,152,138,73,0,1,97,168,129,132,160,80,0,150,10,129,
64,2,152,10,5,0,11,95,168,20,0,48,31,255,224,5,17,72,66,249,37,129,127,255,
0,0,191,255,128,0,63,255,197,31,192,128,80,196,64,0,0,0,0,8,26,112,17,169,
0,154,80,1,171,28,124,88,65,233,49,7,133,100,29,149,15,14,138,71,135,37,3,
195,66,114,5,77,252,0,243,178,40,25,200,48,101,30,0,127,210,128,0,85,31,
192,0,31,244,224,5,71,22,8,0,13,20,88,1,85,127,0,0,127,212,128,21,29,220,
32,0,52,87,112,5,89,252,0,1,255,86,16,166,64,0,0,2,0,0,0,0,0,170,72,38,29,
219,247,16,49,75,32,193,52,130,244,193,225,114,96,248,0,8,249,48,124,0,8,
90,152,62,0,6,44,76,31,0,4,21,166,15,128,2,147,255,252,38,212,16,184,155,
250,226,217,150,47,46,91,249,54,96,139,229,229,203,127,36,26,119,32,203,
203,150,254,72,52,97,221,147,102,157,217,192,10,191,248,0,157,4,72,15,250,
224,1,154,140,36,0,8,43,31,224,0,15,251,0,16,55,139,164,0,192,220,46,144,2,
3,104,186,64,12,77,130,233,0,33,53,139,164,0,200,212,46,144,2,35,72,186,64,
8,205,2,233,0,36,51,140,180,0,192,204,50,208,2,3,40,203,64,12,76,131,45,0,
33,49,140,180,0,200,196,50,208,2,35,8,203,64,8,204,3,45,0,36,7,255,248,1,
82,101,16,112,24,72,0,8,86,159,193,56,192,0,0,240,63,0,0,0,0,1,151,246,96,
0,21,183,240,78,48,0,0,60,15,192,0,0,0,0,101,253,168,0,5,113,252,19,140,0,
0,15,3,240,0,0,0,0,25,127,110,0,1,93,127,4,227,0,0,0,1,0,0,0,0,0,6,95,220,
128,0,87,159,193,56,192,0,0,0,64,0,0,0,0,1,151,247,96,0,21,247,240,78,48,0,
0,4,16,0,0,0,0,0,101,253,232,0,5,129,252,19,140,0,0,1,4,0,0,0,0,0,25,127,
126,0,1,97,127,4,227,0,0,0,65,0,0,0,0,0,6,95,224,128,0,88,159,193,56,192,0,
0,32,64,0,0,0,0,1,151,248,96,0,22,55,240,5,157,170,33,68,178,69,10,193,20,
10,104,79,138,36,0,12,31,248,160,88,154,23,66,100,93,32,2,9,129,116,128,0,
165,197,210,0,18,150,23,72,0,138,84,93,32,3,41,65,116,128,1,36,197,210,0,
20,146,23,72,0,146,68,93,32,3,73,1,116,128,1,163,197,210,0,22,142,23,72,0,
34,52,93,32,1,136,193,118,128,2,162,197,218,0,26,138,23,104,0,170,36,93,
160,3,168,129,150,33,198,90,0,32,134,25,104,0,10,20,101,160,1,40,65,150,
128,8,160,198,90,0,50,130,25,104,0,18,4,101,160,1,72,1,150,128,9,31,198,90,
0,52,126,25,104,0,25,244,101,160,1,103,193,150,128,2,30,198,90,0,24,122,25,
136,0,41,228,102,32,1,167,129,152,128,10,157,198,98,0,59,71,91,99,157,104,
9,213,118,39,5,8,159,20,40,0,10,109,90,19,81,132,39,151,32,
};
#ifdef DUK_USE_BUILTIN_INITJS
DUK_INTERNAL const duk_uint8_t duk_initjs_data[187] = {
40,102,117,110,99,116,105,111,110,40,100,44,97,41,123,102,117,110,99,116,
105,111,110,32,98,40,97,44,98,44,99,41,123,79,98,106,101,99,116,46,100,101,
102,105,110,101,80,114,111,112,101,114,116,121,40,97,44,98,44,123,118,97,
108,117,101,58,99,44,119,114,105,116,97,98,108,101,58,33,48,44,101,110,117,
109,101,114,97,98,108,101,58,33,49,44,99,111,110,102,105,103,117,114,97,98,
108,101,58,33,48,125,41,125,98,40,97,46,76,111,103,103,101,114,44,34,99,
108,111,103,34,44,110,101,119,32,97,46,76,111,103,103,101,114,40,34,67,34,
41,41,59,98,40,97,44,34,109,111,100,76,111,97,100,101,100,34,44,123,125,41,
125,41,40,116,104,105,115,44,68,117,107,116,97,112,101,41,59,10,0,
};
#endif  /* DUK_USE_BUILTIN_INITJS */
#else
#error invalid endianness defines
#endif
#line 1 "duk_error_macros.c"
/*
 *  Error, fatal, and panic handling.
 */

/* include removed: duk_internal.h */

#define DUK__ERRFMT_BUFSIZE  256  /* size for formatting buffers */

#if defined(DUK_USE_VERBOSE_ERRORS)

#if defined(DUK_USE_VARIADIC_MACROS)
DUK_INTERNAL void duk_err_handle_error(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, ...) {
	va_list ap;
	char msg[DUK__ERRFMT_BUFSIZE];
	va_start(ap, fmt);
	(void) DUK_VSNPRINTF(msg, sizeof(msg), fmt, ap);
	msg[sizeof(msg) - 1] = (char) 0;
	duk_err_create_and_throw(thr, code, msg, filename, line);
	va_end(ap);  /* dead code, but ensures portability (see Linux man page notes) */
}
#else  /* DUK_USE_VARIADIC_MACROS */
DUK_INTERNAL const char *duk_err_file_stash = NULL;
DUK_INTERNAL duk_int_t duk_err_line_stash = 0;

DUK_NORETURN(DUK_LOCAL_DECL void duk__handle_error(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, va_list ap));

DUK_LOCAL void duk__handle_error(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, va_list ap) {
	char msg[DUK__ERRFMT_BUFSIZE];
	(void) DUK_VSNPRINTF(msg, sizeof(msg), fmt, ap);
	msg[sizeof(msg) - 1] = (char) 0;
	duk_err_create_and_throw(thr, code, msg, filename, line);
}

DUK_INTERNAL void duk_err_handle_error(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	duk__handle_error(filename, line, thr, code, fmt, ap);
	va_end(ap);  /* dead code */
}

DUK_INTERNAL void duk_err_handle_error_stash(duk_hthread *thr, duk_errcode_t code, const char *fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	duk__handle_error(duk_err_file_stash, duk_err_line_stash, thr, code, fmt, ap);
	va_end(ap);  /* dead code */
}
#endif  /* DUK_USE_VARIADIC_MACROS */

#else  /* DUK_USE_VERBOSE_ERRORS */

#if defined(DUK_USE_VARIADIC_MACROS)
DUK_INTERNAL void duk_err_handle_error(duk_hthread *thr, duk_errcode_t code) {
	duk_err_create_and_throw(thr, code);
}

#else  /* DUK_USE_VARIADIC_MACROS */
DUK_INTERNAL void duk_err_handle_error_nonverbose1(duk_hthread *thr, duk_errcode_t code, const char *fmt, ...) {
	DUK_UNREF(fmt);
	duk_err_create_and_throw(thr, code);
}

DUK_INTERNAL void duk_err_handle_error_nonverbose2(const char *filename, duk_int_t line, duk_hthread *thr, duk_errcode_t code, const char *fmt, ...) {
	DUK_UNREF(filename);
	DUK_UNREF(line);
	DUK_UNREF(fmt);
	duk_err_create_and_throw(thr, code);
}
#endif  /* DUK_USE_VARIADIC_MACROS */

#endif  /* DUK_USE_VERBOSE_ERRORS */

/*
 *  Error throwing helpers
 */

#if defined(DUK_USE_VERBOSE_ERRORS)
#if defined(DUK_USE_PARANOID_ERRORS)
DUK_INTERNAL void duk_err_require_type_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, duk_idx_t index, const char *expect_name) {
	DUK_ERROR_RAW(filename, linenumber, thr, DUK_ERR_TYPE_ERROR, "%s required, found %s (stack index %ld)",
	              expect_name, duk_get_type_name((duk_context *) thr, index), (long) index);
}
#else
DUK_INTERNAL void duk_err_require_type_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, duk_idx_t index, const char *expect_name) {
	DUK_ERROR_RAW(filename, linenumber, thr, DUK_ERR_TYPE_ERROR, "%s required, found %s (stack index %ld)",
	              expect_name, duk_push_string_readable((duk_context *) thr, index), (long) index);
}
#endif
DUK_INTERNAL void duk_err_api_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, duk_idx_t index) {
	DUK_ERROR_RAW(filename, linenumber, thr, DUK_ERR_API_ERROR, "invalid stack index %ld", (long) (index));
}
DUK_INTERNAL void duk_err_api(const char *filename, duk_int_t linenumber, duk_hthread *thr, const char *message) {
	DUK_ERROR_RAW(filename, linenumber, thr, DUK_ERR_API_ERROR, message);
}
#else
DUK_INTERNAL void duk_err_require_type_index(const char *filename, duk_int_t linenumber, duk_hthread *thr, const char *message) {
	DUK_UNREF(filename); DUK_UNREF(linenumber); DUK_UNREF(message);
	DUK_ERROR_RAW(filename, linenumber, thr, DUK_ERR_TYPE_ERROR, message);
}
DUK_INTERNAL void duk_err_api_index(const char *filename, duk_int_t linenumber, duk_hthread *thr) {
	DUK_UNREF(filename); DUK_UNREF(linenumber);
	DUK_ERROR(thr, DUK_ERR_API_ERROR, DUK_STR_INVALID_INDEX);
}
DUK_INTERNAL void duk_err_api(const char *filename, duk_int_t linenumber, duk_hthread *thr, const char *message) {
	DUK_UNREF(filename); DUK_UNREF(linenumber); DUK_UNREF(message);
	DUK_ERROR_RAW(filename, linenumber, thr, DUK_ERR_API_ERROR, message);
}
#endif

/*
 *  Default fatal error handler
 */

DUK_INTERNAL void duk_default_fatal_handler(duk_context *ctx, duk_errcode_t code, const char *msg) {
	DUK_UNREF(ctx);
#if defined(DUK_USE_FILE_IO)
	DUK_FPRINTF(DUK_STDERR, "FATAL %ld: %s\n", (long) code, (const char *) (msg ? msg : "null"));
	DUK_FFLUSH(DUK_STDERR);
#else
	/* omit print */
#endif
	DUK_D(DUK_DPRINT("default fatal handler called, code %ld -> calling DUK_PANIC()", (long) code));
	DUK_PANIC(code, msg);
	DUK_UNREACHABLE();
}

/*
 *  Default panic handler
 */

#if !defined(DUK_USE_PANIC_HANDLER)
DUK_INTERNAL void duk_default_panic_handler(duk_errcode_t code, const char *msg) {
#if defined(DUK_USE_FILE_IO)
	DUK_FPRINTF(DUK_STDERR, "PANIC %ld: %s ("
#if defined(DUK_USE_PANIC_ABORT)
	            "calling abort"
#elif defined(DUK_USE_PANIC_EXIT)
	            "calling exit"
#elif defined(DUK_USE_PANIC_SEGFAULT)
	            "segfaulting on purpose"
#else
#error no DUK_USE_PANIC_xxx macro defined
#endif
	            ")\n", (long) code, (const char *) (msg ? msg : "null"));
	DUK_FFLUSH(DUK_STDERR);
#else
	/* omit print */
	DUK_UNREF(code);
	DUK_UNREF(msg);
#endif

#if defined(DUK_USE_PANIC_ABORT)
	DUK_ABORT();
#elif defined(DUK_USE_PANIC_EXIT)
	DUK_EXIT(-1);
#elif defined(DUK_USE_PANIC_SEGFAULT)
	/* exit() afterwards to satisfy "noreturn" */
	DUK_CAUSE_SEGFAULT();  /* SCANBUILD: "Dereference of null pointer", normal */
	DUK_EXIT(-1);
#else
#error no DUK_USE_PANIC_xxx macro defined
#endif

	DUK_UNREACHABLE();
}
#endif  /* !DUK_USE_PANIC_HANDLER */

#undef DUK__ERRFMT_BUFSIZE
#line 1 "duk_unicode_support.c"
/*
 *  Various Unicode help functions for character classification predicates,
 *  case conversion, decoding, etc.
 */

/* include removed: duk_internal.h */

/*
 *  XUTF-8 and CESU-8 encoding/decoding
 */

DUK_INTERNAL duk_small_int_t duk_unicode_get_xutf8_length(duk_ucodepoint_t cp) {
	duk_uint_fast32_t x = (duk_uint_fast32_t) cp;
	if (x < 0x80UL) {
		/* 7 bits */
		return 1;
	} else if (x < 0x800UL) {
		/* 11 bits */
		return 2;
	} else if (x < 0x10000UL) {
		/* 16 bits */
		return 3;
	} else if (x < 0x200000UL) {
		/* 21 bits */
		return 4;
	} else if (x < 0x4000000UL) {
		/* 26 bits */
		return 5;
	} else if (x < (duk_ucodepoint_t) 0x80000000UL) {
		/* 31 bits */
		return 6;
	} else {
		/* 36 bits */
		return 7;
	}
}

#if defined(DUK_USE_ASSERTIONS)
DUK_INTERNAL duk_small_int_t duk_unicode_get_cesu8_length(duk_ucodepoint_t cp) {
	duk_uint_fast32_t x = (duk_uint_fast32_t) cp;
	if (x < 0x80UL) {
		/* 7 bits */
		return 1;
	} else if (x < 0x800UL) {
		/* 11 bits */
		return 2;
	} else if (x < 0x10000UL) {
		/* 16 bits */
		return 3;
	} else {
		/* Encoded as surrogate pair, each encoding to 3 bytes for
		 * 6 bytes total.  Codepoints above U+10FFFF encode as 6 bytes
		 * too, see duk_unicode_encode_cesu8().
		  */
		return 3 + 3;
	}
}
#endif  /* DUK_USE_ASSERTIONS */

DUK_INTERNAL duk_uint8_t duk_unicode_xutf8_markers[7] = {
	0x00, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe
};

/* Encode to extended UTF-8; 'out' must have space for at least
 * DUK_UNICODE_MAX_XUTF8_LENGTH bytes.  Allows encoding of any
 * 32-bit (unsigned) codepoint.
 */
DUK_INTERNAL duk_small_int_t duk_unicode_encode_xutf8(duk_ucodepoint_t cp, duk_uint8_t *out) {
	duk_uint_fast32_t x = (duk_uint_fast32_t) cp;
	duk_small_int_t len;
	duk_uint8_t marker;
	duk_small_int_t i;

	len = duk_unicode_get_xutf8_length(cp);
	DUK_ASSERT(len > 0);

	marker = duk_unicode_xutf8_markers[len - 1];  /* 64-bit OK because always >= 0 */

	i = len;
	DUK_ASSERT(i > 0);
	do {
		i--;
		if (i > 0) {
			out[i] = (duk_uint8_t) (0x80 + (x & 0x3f));
			x >>= 6;
		} else {
			/* Note: masking of 'x' is not necessary because of
			 * range check and shifting -> no bits overlapping
			 * the marker should be set.
			 */
			out[0] = (duk_uint8_t) (marker + x);
		}
	} while (i > 0);

	return len;
}

/* Encode to CESU-8; 'out' must have space for at least
 * DUK_UNICODE_MAX_CESU8_LENGTH bytes; codepoints above U+10FFFF
 * will encode to garbage but won't overwrite the output buffer.
 */
DUK_INTERNAL duk_small_int_t duk_unicode_encode_cesu8(duk_ucodepoint_t cp, duk_uint8_t *out) {
	duk_uint_fast32_t x = (duk_uint_fast32_t) cp;
	duk_small_int_t len;

	if (x < 0x80UL) {
		out[0] = (duk_uint8_t) x;
		len = 1;
	} else if (x < 0x800UL) {
		out[0] = (duk_uint8_t) (0xc0 + ((x >> 6) & 0x1f));
		out[1] = (duk_uint8_t) (0x80 + (x & 0x3f));
		len = 2;
	} else if (x < 0x10000UL) {
		/* surrogate pairs get encoded here */
		out[0] = (duk_uint8_t) (0xe0 + ((x >> 12) & 0x0f));
		out[1] = (duk_uint8_t) (0x80 + ((x >> 6) & 0x3f));
		out[2] = (duk_uint8_t) (0x80 + (x & 0x3f));
		len = 3;
	} else {
		/*
		 *  Unicode codepoints above U+FFFF are encoded as surrogate
		 *  pairs here.  This ensures that all CESU-8 codepoints are
		 *  16-bit values as expected in Ecmascript.  The surrogate
		 *  pairs always get a 3-byte encoding (each) in CESU-8.
		 *  See: http://en.wikipedia.org/wiki/Surrogate_pair
		 *
		 *  20-bit codepoint, 10 bits (A and B) per surrogate pair:
		 *
		 *    x = 0b00000000 0000AAAA AAAAAABB BBBBBBBB
		 *  sp1 = 0b110110AA AAAAAAAA  (0xd800 + ((x >> 10) & 0x3ff))
		 *  sp2 = 0b110111BB BBBBBBBB  (0xdc00 + (x & 0x3ff))
		 *
		 *  Encoded into CESU-8:
		 *
		 *  sp1 -> 0b11101101  (0xe0 + ((sp1 >> 12) & 0x0f))
		 *      -> 0b1010AAAA  (0x80 + ((sp1 >> 6) & 0x3f))
		 *      -> 0b10AAAAAA  (0x80 + (sp1 & 0x3f))
		 *  sp2 -> 0b11101101  (0xe0 + ((sp2 >> 12) & 0x0f))
		 *      -> 0b1011BBBB  (0x80 + ((sp2 >> 6) & 0x3f))
		 *      -> 0b10BBBBBB  (0x80 + (sp2 & 0x3f))
		 *
		 *  Note that 0x10000 must be subtracted first.  The code below
		 *  avoids the sp1, sp2 temporaries which saves around 20 bytes
		 *  of code.
		 */

		x -= 0x10000UL;

		out[0] = (duk_uint8_t) (0xed);
		out[1] = (duk_uint8_t) (0xa0 + ((x >> 16) & 0x0f));
		out[2] = (duk_uint8_t) (0x80 + ((x >> 10) & 0x3f));
		out[3] = (duk_uint8_t) (0xed);
		out[4] = (duk_uint8_t) (0xb0 + ((x >> 6) & 0x0f));
		out[5] = (duk_uint8_t) (0x80 + (x & 0x3f));
		len = 6;
	}

	return len;
}

/* Decode helper.  Return zero on error. */
DUK_INTERNAL duk_small_int_t duk_unicode_decode_xutf8(duk_hthread *thr, const duk_uint8_t **ptr, const duk_uint8_t *ptr_start, const duk_uint8_t *ptr_end, duk_ucodepoint_t *out_cp) {
	const duk_uint8_t *p;
	duk_uint32_t res;
	duk_uint_fast8_t ch;
	duk_small_int_t n;

	DUK_UNREF(thr);

	p = *ptr;
	if (p < ptr_start || p >= ptr_end) {
		goto fail;
	}

	/*
	 *  UTF-8 decoder which accepts longer than standard byte sequences.
	 *  This allows full 32-bit code points to be used.
	 */

	ch = (duk_uint_fast8_t) (*p++);
	if (ch < 0x80) {
		/* 0xxx xxxx   [7 bits] */
		res = (duk_uint32_t) (ch & 0x7f);
		n = 0;
	} else if (ch < 0xc0) {
		/* 10xx xxxx -> invalid */
		goto fail;
	} else if (ch < 0xe0) {
		/* 110x xxxx   10xx xxxx   [11 bits] */
		res = (duk_uint32_t) (ch & 0x1f);
		n = 1;
	} else if (ch < 0xf0) {
		/* 1110 xxxx   10xx xxxx   10xx xxxx   [16 bits] */
		res = (duk_uint32_t) (ch & 0x0f);
		n = 2;
	} else if (ch < 0xf8) {
		/* 1111 0xxx   10xx xxxx   10xx xxxx   10xx xxxx   [21 bits] */
		res = (duk_uint32_t) (ch & 0x07);
		n = 3;
	} else if (ch < 0xfc) {
		/* 1111 10xx   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   [26 bits] */
		res = (duk_uint32_t) (ch & 0x03);
		n = 4;
	} else if (ch < 0xfe) {
		/* 1111 110x   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   [31 bits] */
		res = (duk_uint32_t) (ch & 0x01);
		n = 5;
	} else if (ch < 0xff) {
		/* 1111 1110   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   [36 bits] */
		res = (duk_uint32_t) (0);
		n = 6;
	} else {
		/* 8-byte format could be:
		 * 1111 1111   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   10xx xxxx   [41 bits]
		 *
		 * However, this format would not have a zero bit following the
		 * leading one bits and would not allow 0xFF to be used as an
		 * "invalid xutf-8" marker for internal keys.  Further, 8-byte
		 * encodings (up to 41 bit code points) are not currently needed.
		 */
		goto fail;
	}

	DUK_ASSERT(p >= ptr_start);  /* verified at beginning */
	if (p + n > ptr_end) {
		/* check pointer at end */
		goto fail;
	}

	while (n > 0) {
		DUK_ASSERT(p >= ptr_start && p < ptr_end);
		res = res << 6;
		res += (duk_uint32_t) ((*p++) & 0x3f);
		n--;
	}

	*ptr = p;
	*out_cp = res;
	return 1;

 fail:
	return 0;
}

/* used by e.g. duk_regexp_executor.c, string built-ins */
DUK_INTERNAL duk_ucodepoint_t duk_unicode_decode_xutf8_checked(duk_hthread *thr, const duk_uint8_t **ptr, const duk_uint8_t *ptr_start, const duk_uint8_t *ptr_end) {
	duk_ucodepoint_t cp;

	if (duk_unicode_decode_xutf8(thr, ptr, ptr_start, ptr_end, &cp)) {
		return cp;
	}
	DUK_ERROR(thr, DUK_ERR_INTERNAL_ERROR, "utf-8 decode failed");
	DUK_UNREACHABLE();
	return 0;
}

/* Compute (extended) utf-8 length without codepoint encoding validation,
 * used for string interning.
 *
 * NOTE: This algorithm is performance critical, more so than string hashing
 * in some cases.  It is needed when interning a string and needs to scan
 * every byte of the string with no skipping.  Having an ASCII fast path
 * is useful if possible in the algorithm.  The current algorithms were
 * chosen from several variants, based on x64 gcc -O2 testing.  See:
 * https://github.com/svaarala/duktape/pull/422
 */

#if defined(DUK_USE_PREFER_SIZE)
/* Small variant; roughly 150 bytes smaller than the fast variant. */
DUK_INTERNAL duk_size_t duk_unicode_unvalidated_utf8_length(const duk_uint8_t *data, duk_size_t blen) {
	const duk_uint8_t *p;
	const duk_uint8_t *p_end;
	duk_size_t ncont;
	duk_size_t clen;

	p = data;
	p_end = data + blen;
	ncont = 0;
	while (p != p_end) {
		duk_uint8_t x;
		x = *p++;
		if (DUK_UNLIKELY(x >= 0x80 && x <= 0xbf)) {
			ncont++;
		}
	}

	DUK_ASSERT(ncont <= blen);
	clen = blen - ncont;
	DUK_ASSERT(clen <= blen);
	return clen;
}
#else  /* DUK_USE_PREFER_SIZE */
/* This seems like a good overall approach.  Fast path for ASCII in 4 byte
 * blocks.
 */
DUK_INTERNAL duk_size_t duk_unicode_unvalidated_utf8_length(const duk_uint8_t *data, duk_size_t blen) {
	const duk_uint8_t *p;
	const duk_uint8_t *p_end;
	const duk_uint32_t *p32_end;
	const duk_uint32_t *p32;
	duk_size_t ncont;
	duk_size_t clen;

	ncont = 0;  /* number of continuation (non-initial) bytes in [0x80,0xbf] */
	p = data;
	p_end = data + blen;
	if (blen < 16) {
		goto skip_fastpath;
	}

	/* Align 'p' to 4; the input data may have arbitrary alignment.
	 * End of string check not needed because blen >= 16.
	 */
	while (((duk_uintptr_t) (const void *) p) & 0x03) {
		duk_uint8_t x;
		x = *p++;
		if (DUK_UNLIKELY(x >= 0x80 && x <= 0xbf)) {
			ncont++;
		}
	}

	/* Full, aligned 4-byte reads. */
	p32_end = (const duk_uint32_t *) (const void *) (p + ((duk_size_t) (p_end - p) & (duk_size_t) (~0x03)));
	p32 = (const duk_uint32_t *) (const void *) p;
	while (p32 != (const duk_uint32_t *) p32_end) {
		duk_uint32_t x;
		x = *p32++;
		if (DUK_LIKELY((x & 0x80808080UL) == 0)) {
			;  /* ASCII fast path */
		} else {
			/* Flip highest bit of each byte which changes
			 * the bit pattern 10xxxxxx into 00xxxxxx which
			 * allows an easy bit mask test.
			 */
			x ^= 0x80808080UL;
			if (DUK_UNLIKELY(!(x & 0xc0000000UL))) {
				ncont++;
			}
			if (DUK_UNLIKELY(!(x & 0x00c00000UL))) {
				ncont++;
			}
			if (DUK_UNLIKELY(!(x & 0x0000c000UL))) {
				ncont++;
			}
			if (DUK_UNLIKELY(!(x & 0x000000c0UL))) {
				ncont++;
			}
		}
	}
	p = (const duk_uint8_t *) p32;
	/* Fall through to handle the rest. */

 skip_fastpath:
	while (p != p_end) {
		duk_uint8_t x;
		x = *p++;
		if (DUK_UNLIKELY(x >= 0x80 && x <= 0xbf)) {
			ncont++;
		}
	}

	DUK_ASSERT(ncont <= blen);
	clen = blen - ncont;
	DUK_ASSERT(clen <= blen);
	return clen;
}
#endif  /* DUK_USE_PREFER_SIZE */

/*
 *  Unicode range matcher
 *
 *  Matches a codepoint against a packed bitstream of character ranges.
 *  Used for slow path Unicode matching.
 */

/* Must match src/extract_chars.py, generate_match_table3(). */
DUK_LOCAL duk_uint32_t duk__uni_decode_value(duk_bitdecoder_ctx *bd_ctx) {
	duk_uint32_t t;

	t = (duk_uint32_t) duk_bd_decode(bd_ctx, 4);
	if (t <= 0x0eU) {
		return t;
	}
	t = (duk_uint32_t) duk_bd_decode(bd_ctx, 8);
	if (t <= 0xfdU) {
		return t + 0x0f;
	}
	if (t == 0xfeU) {
		t = (duk_uint32_t) duk_bd_decode(bd_ctx, 12);
		return t + 0x0fU + 0xfeU;
	} else {
		t = (duk_uint32_t) duk_bd_decode(bd_ctx, 24);
		return t + 0x0fU + 0xfeU + 0x1000UL;
	}
}

DUK_LOCAL duk_small_int_t duk__uni_range_match(const duk_uint8_t *unitab, duk_size_t unilen, duk_codepoint_t cp) {
	duk_bitdecoder_ctx bd_ctx;
	duk_codepoint_t prev_re;

	DUK_MEMZERO(&bd_ctx, sizeof(bd_ctx));
	bd_ctx.data = (const duk_uint8_t *) unitab;
	bd_ctx.length = (duk_size_t) unilen;

	prev_re = 0;
	for (;;) {
		duk_codepoint_t r1, r2;
		r1 = (duk_codepoint_t) duk__uni_decode_value(&bd_ctx);
		if (r1 == 0) {
			break;
		}
		r2 = (duk_codepoint_t) duk__uni_decode_value(&bd_ctx);

		r1 = prev_re + r1;
		r2 = r1 + r2;
		prev_re = r2;

		/* [r1,r2] is the range */

		DUK_DDD(DUK_DDDPRINT("duk__uni_range_match: cp=%06lx range=[0x%06lx,0x%06lx]",
		                     (unsigned long) cp, (unsigned long) r1, (unsigned long) r2));
		if (cp >= r1 && cp <= r2) {
			return 1;
		}
	}

	return 0;
}

/*
 *  "WhiteSpace" production check.
 */

DUK_INTERNAL duk_small_int_t duk_unicode_is_whitespace(duk_codepoint_t cp) {
	/*
	 *  E5 Section 7.2 specifies six characters specifically as
	 *  white space:
	 *
	 *    0009;<control>;Cc;0;S;;;;;N;CHARACTER TABULATION;;;;
	 *    000B;<control>;Cc;0;S;;;;;N;LINE TABULATION;;;;
	 *    000C;<control>;Cc;0;WS;;;;;N;FORM FEED (FF);;;;
	 *    0020;SPACE;Zs;0;WS;;;;;N;;;;;
	 *    00A0;NO-BREAK SPACE;Zs;0;CS;<noBreak> 0020;;;;N;NON-BREAKING SPACE;;;;
	 *    FEFF;ZERO WIDTH NO-BREAK SPACE;Cf;0;BN;;;;;N;BYTE ORDER MARK;;;;
	 *
	 *  It also specifies any Unicode category 'Zs' characters as white
	 *  space.  These can be extracted with the "src/extract_chars.py" script.
	 *  Current result:
	 *
	 *    RAW OUTPUT:
	 *    ===========
	 *    0020;SPACE;Zs;0;WS;;;;;N;;;;;
	 *    00A0;NO-BREAK SPACE;Zs;0;CS;<noBreak> 0020;;;;N;NON-BREAKING SPACE;;;;
	 *    1680;OGHAM SPACE MARK;Zs;0;WS;;;;;N;;;;;
	 *    180E;MONGOLIAN VOWEL SEPARATOR;Zs;0;WS;;;;;N;;;;;
	 *    2000;EN QUAD;Zs;0;WS;2002;;;;N;;;;;
	 *    2001;EM QUAD;Zs;0;WS;2003;;;;N;;;;;
	 *    2002;EN SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    2003;EM SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    2004;THREE-PER-EM SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    2005;FOUR-PER-EM SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    2006;SIX-PER-EM SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    2007;FIGURE SPACE;Zs;0;WS;<noBreak> 0020;;;;N;;;;;
	 *    2008;PUNCTUATION SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    2009;THIN SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    200A;HAIR SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    202F;NARROW NO-BREAK SPACE;Zs;0;CS;<noBreak> 0020;;;;N;;;;;
	 *    205F;MEDIUM MATHEMATICAL SPACE;Zs;0;WS;<compat> 0020;;;;N;;;;;
	 *    3000;IDEOGRAPHIC SPACE;Zs;0;WS;<wide> 0020;;;;N;;;;;
	 *
	 *    RANGES:
	 *    =======
	 *    0x0020
	 *    0x00a0
	 *    0x1680
	 *    0x180e
	 *    0x2000 ... 0x200a
	 *    0x202f
	 *    0x205f
	 *    0x3000
	 *
	 *  A manual decoder (below) is probably most compact for this.
	 */

	duk_uint_fast8_t lo;
	duk_uint_fast32_t hi;

	/* cp == -1 (EOF) never matches and causes return value 0 */

	lo = (duk_uint_fast8_t) (cp & 0xff);
	hi = (duk_uint_fast32_t) (cp >> 8);  /* does not fit into an uchar */

	if (hi == 0x0000UL) {
		if (lo == 0x09U || lo == 0x0bU || lo == 0x0cU ||
		    lo == 0x20U || lo == 0xa0U) {
			return 1;
		}
	} else if (hi == 0x0020UL) {
		if (lo <= 0x0aU || lo == 0x2fU || lo == 0x5fU) {
			return 1;
		}
	} else if (cp == 0x1680L || cp == 0x180eL || cp == 0x3000L ||
	           cp == 0xfeffL) {
		return 1;
	}

	return 0;
}

/*
 *  "LineTerminator" production check.
 */

DUK_INTERNAL duk_small_int_t duk_unicode_is_line_terminator(duk_codepoint_t cp) {
	/*
	 *  E5 Section 7.3
	 *
	 *  A LineTerminatorSequence essentially merges <CR> <LF> sequences
	 *  into a single line terminator.  This must be handled by the caller.
	 */

	if (cp == 0x000aL || cp == 0x000dL || cp == 0x2028L ||
	    cp == 0x2029L) {
		return 1;
	}

	return 0;
}

/*
 *  "IdentifierStart" production check.
 */

DUK_INTERNAL duk_small_int_t duk_unicode_is_identifier_start(duk_codepoint_t cp) {
	/*
	 *  E5 Section 7.6:
	 *
	 *    IdentifierStart:
	 *      UnicodeLetter
	 *      $
	 *      _
	 *      \ UnicodeEscapeSequence
	 *
	 *  IdentifierStart production has one multi-character production:
	 *
	 *    \ UnicodeEscapeSequence
	 *
	 *  The '\' character is -not- matched by this function.  Rather, the caller
	 *  should decode the escape and then call this function to check whether the
	 *  decoded character is acceptable (see discussion in E5 Section 7.6).
	 *
	 *  The "UnicodeLetter" alternative of the production allows letters
	 *  from various Unicode categories.  These can be extracted with the
	 *  "src/extract_chars.py" script.
	 *
	 *  Because the result has hundreds of Unicode codepoint ranges, matching
	 *  for any values >= 0x80 are done using a very slow range-by-range scan
	 *  and a packed range format.
	 *
	 *  The ASCII portion (codepoints 0x00 ... 0x7f) is fast-pathed below because
	 *  it matters the most.  The ASCII related ranges of IdentifierStart are:
	 *
	 *    0x0041 ... 0x005a     ['A' ... 'Z']
	 *    0x0061 ... 0x007a     ['a' ... 'z']
	 *    0x0024                ['$']
	 *    0x005f                ['_']
	 */

	/* ASCII (and EOF) fast path -- quick accept and reject */
	if (cp <= 0x7fL) {
		if ((cp >= 'a' && cp <= 'z') ||
		    (cp >= 'A' && cp <= 'Z') ||
		    cp == '_' || cp == '$') {
			return 1;
		}
		return 0;
	}

	/* Non-ASCII slow path (range-by-range linear comparison), very slow */

#ifdef DUK_USE_SOURCE_NONBMP
	if (duk__uni_range_match(duk_unicode_ids_noa,
	                         (duk_size_t) sizeof(duk_unicode_ids_noa),
	                         (duk_codepoint_t) cp)) {
		return 1;
	}
	return 0;
#else
	if (cp < 0x10000L) {
		if (duk__uni_range_match(duk_unicode_ids_noabmp,
		                         sizeof(duk_unicode_ids_noabmp),
		                         (duk_codepoint_t) cp)) {
			return 1;
		}
		return 0;
	} else {
		/* without explicit non-BMP support, assume non-BMP characters
		 * are always accepted as identifier characters.
		 */
		return 1;
	}
#endif
}

/*
 *  "IdentifierPart" production check.
 */

DUK_INTERNAL duk_small_int_t duk_unicode_is_identifier_part(duk_codepoint_t cp) {
	/*
	 *  E5 Section 7.6:
	 *
	 *    IdentifierPart:
	 *      IdentifierStart
	 *      UnicodeCombiningMark
	 *      UnicodeDigit
	 *      UnicodeConnectorPunctuation
	 *      <ZWNJ>  [U+200C]
	 *      <ZWJ>   [U+200D]
	 *
	 *  IdentifierPart production has one multi-character production
	 *  as part of its IdentifierStart alternative.  The '\' character
	 *  of an escape sequence is not matched here, see discussion in
	 *  duk_unicode_is_identifier_start().
	 *
	 *  To match non-ASCII characters (codepoints >= 0x80), a very slow
	 *  linear range-by-range scan is used.  The codepoint is first compared
	 *  to the IdentifierStart ranges, and if it doesn't match, then to a
	 *  set consisting of code points in IdentifierPart but not in
	 *  IdentifierStart.  This is done to keep the unicode range data small,
	 *  at the expense of speed.
	 *
	 *  The ASCII fast path consists of:
	 *
	 *    0x0030 ... 0x0039     ['0' ... '9', UnicodeDigit]
	 *    0x0041 ... 0x005a     ['A' ... 'Z', IdentifierStart]
	 *    0x0061 ... 0x007a     ['a' ... 'z', IdentifierStart]
	 *    0x0024                ['$', IdentifierStart]
	 *    0x005f                ['_', IdentifierStart and
	 *                                UnicodeConnectorPunctuation]
	 *
	 *  UnicodeCombiningMark has no code points <= 0x7f.
	 *
	 *  The matching code reuses the "identifier start" tables, and then
	 *  consults a separate range set for characters in "identifier part"
	 *  but not in "identifier start".  These can be extracted with the
	 *  "src/extract_chars.py" script.
	 *
	 *  UnicodeCombiningMark -> categories Mn, Mc
	 *  UnicodeDigit -> categories Nd
	 *  UnicodeConnectorPunctuation -> categories Pc
	 */

	/* ASCII (and EOF) fast path -- quick accept and reject */
	if (cp <= 0x7fL) {
		if ((cp >= 'a' && cp <= 'z') ||
		    (cp >= 'A' && cp <= 'Z') ||
		    (cp >= '0' && cp <= '9') ||
		    cp == '_' || cp == '$') {
			return 1;
		}
		return 0;
	}

	/* Non-ASCII slow path (range-by-range linear comparison), very slow */

#ifdef DUK_USE_SOURCE_NONBMP
	if (duk__uni_range_match(duk_unicode_ids_noa,
	                         sizeof(duk_unicode_ids_noa),
	                         (duk_codepoint_t) cp) ||
	    duk__uni_range_match(duk_unicode_idp_m_ids_noa,
	                         sizeof(duk_unicode_idp_m_ids_noa),
	                         (duk_codepoint_t) cp)) {
		return 1;
	}
	return 0;
#else
	if (cp < 0x10000L) {
		if (duk__uni_range_match(duk_unicode_ids_noabmp,
		                         sizeof(duk_unicode_ids_noabmp),
		                         (duk_codepoint_t) cp) ||
		    duk__uni_range_match(duk_unicode_idp_m_ids_noabmp,
		                         sizeof(duk_unicode_idp_m_ids_noabmp),
		                         (duk_codepoint_t) cp)) {
			return 1;
		}
		return 0;
	} else {
		/* without explicit non-BMP support, assume non-BMP characters
		 * are always accepted as identifier characters.
		 */
		return 1;
	}
#endif
}

/*
 *  Unicode letter check.
 */

DUK_INTERNAL duk_small_int_t duk_unicode_is_letter(duk_codepoint_t cp) {
	/*
	 *  Unicode letter is now taken to be the categories:
	 *
	 *    Lu, Ll, Lt, Lm, Lo
	 *
	 *  (Not sure if this is exactly correct.)
	 *
	 *  The ASCII fast path consists of:
	 *
	 *    0x0041 ... 0x005a     ['A' ... 'Z']
	 *    0x0061 ... 0x007a     ['a' ... 'z']
	 */

	/* ASCII (and EOF) fast path -- quick accept and reject */
	if (cp <= 0x7fL) {
		if ((cp >= 'a' && cp <= 'z') ||
		    (cp >= 'A' && cp <= 'Z')) {
			return 1;
		}
		return 0;
	}

	/* Non-ASCII slow path (range-by-range linear comparison), very slow */

#ifdef DUK_USE_SOURCE_NONBMP
	if (duk__uni_range_match(duk_unicode_ids_noa,
	                         sizeof(duk_unicode_ids_noa),
	                         (duk_codepoint_t) cp) &&
	    !duk__uni_range_match(duk_unicode_ids_m_let_noa,
	                          sizeof(duk_unicode_ids_m_let_noa),
	                          (duk_codepoint_t) cp)) {
		return 1;
	}
	return 0;
#else
	if (cp < 0x10000L) {
		if (duk__uni_range_match(duk_unicode_ids_noabmp,
		                         sizeof(duk_unicode_ids_noabmp),
		                         (duk_codepoint_t) cp) &&
		    !duk__uni_range_match(duk_unicode_ids_m_let_noabmp,
		                          sizeof(duk_unicode_ids_m_let_noabmp),
		                          (duk_codepoint_t) cp)) {
			return 1;
		}
		return 0;
	} else {
		/* without explicit non-BMP support, assume non-BMP characters
		 * are always accepted as letters.
		 */
		return 1;
	}
#endif
}

/*
 *  Complex case conversion helper which decodes a bit-packed conversion
 *  control stream generated by unicode/extract_caseconv.py.  The conversion
 *  is very slow because it runs through the conversion data in a linear
 *  fashion to save space (which is why ASCII characters have a special
 *  fast path before arriving here).
 *
 *  The particular bit counts etc have been determined experimentally to
 *  be small but still sufficient, and must match the Python script
 *  (src/extract_caseconv.py).
 *
 *  The return value is the case converted codepoint or -1 if the conversion
 *  results in multiple characters (this is useful for regexp Canonicalization
 *  operation).  If 'buf' is not NULL, the result codepoint(s) are also
 *  appended to the hbuffer.
 *
 *  Context and locale specific rules must be checked before consulting
 *  this function.
 */

DUK_LOCAL
duk_codepoint_t duk__slow_case_conversion(duk_hthread *thr,
                                          duk_bufwriter_ctx *bw,
                                          duk_codepoint_t cp,
                                          duk_bitdecoder_ctx *bd_ctx) {
	duk_small_int_t skip = 0;
	duk_small_int_t n;
	duk_small_int_t t;
	duk_small_int_t count;
	duk_codepoint_t tmp_cp;
	duk_codepoint_t start_i;
	duk_codepoint_t start_o;

	DUK_UNREF(thr);
	DUK_ASSERT(bd_ctx != NULL);

	DUK_DDD(DUK_DDDPRINT("slow case conversion for codepoint: %ld", (long) cp));

	/* range conversion with a "skip" */
	DUK_DDD(DUK_DDDPRINT("checking ranges"));
	for (;;) {
		skip++;
		n = (duk_small_int_t) duk_bd_decode(bd_ctx, 6);
		if (n == 0x3f) {
			/* end marker */
			break;
		}
		DUK_DDD(DUK_DDDPRINT("skip=%ld, n=%ld", (long) skip, (long) n));

		while (n--) {
			start_i = (duk_codepoint_t) duk_bd_decode(bd_ctx, 16);
			start_o = (duk_codepoint_t) duk_bd_decode(bd_ctx, 16);
			count = (duk_small_int_t) duk_bd_decode(bd_ctx, 7);
			DUK_DDD(DUK_DDDPRINT("range: start_i=%ld, start_o=%ld, count=%ld, skip=%ld",
			                     (long) start_i, (long) start_o, (long) count, (long) skip));

			if (cp >= start_i) {
				tmp_cp = cp - start_i;  /* always >= 0 */
				if (tmp_cp < (duk_codepoint_t) count * (duk_codepoint_t) skip &&
				    (tmp_cp % (duk_codepoint_t) skip) == 0) {
					DUK_DDD(DUK_DDDPRINT("range matches input codepoint"));
					cp = start_o + tmp_cp;
					goto single;
				}
			}
		}
	}

	/* 1:1 conversion */
	n = (duk_small_int_t) duk_bd_decode(bd_ctx, 6);
	DUK_DDD(DUK_DDDPRINT("checking 1:1 conversions (count %ld)", (long) n));
	while (n--) {
		start_i = (duk_codepoint_t) duk_bd_decode(bd_ctx, 16);
		start_o = (duk_codepoint_t) duk_bd_decode(bd_ctx, 16);
		DUK_DDD(DUK_DDDPRINT("1:1 conversion %ld -> %ld", (long) start_i, (long) start_o));
		if (cp == start_i) {
			DUK_DDD(DUK_DDDPRINT("1:1 matches input codepoint"));
			cp = start_o;
			goto single;
		}
	}

	/* complex, multicharacter conversion */
	n = (duk_small_int_t) duk_bd_decode(bd_ctx, 7);
	DUK_DDD(DUK_DDDPRINT("checking 1:n conversions (count %ld)", (long) n));
	while (n--) {
		start_i = (duk_codepoint_t) duk_bd_decode(bd_ctx, 16);
		t = (duk_small_int_t) duk_bd_decode(bd_ctx, 2);
		DUK_DDD(DUK_DDDPRINT("1:n conversion %ld -> %ld chars", (long) start_i, (long) t));
		if (cp == start_i) {
			DUK_DDD(DUK_DDDPRINT("1:n matches input codepoint"));
			if (bw != NULL) {
				while (t--) {
					tmp_cp = (duk_codepoint_t) duk_bd_decode(bd_ctx, 16);
					DUK_BW_WRITE_RAW_XUTF8(thr, bw, (duk_ucodepoint_t) tmp_cp);
				}
			}
			return -1;
		} else {
			while (t--) {
				(void) duk_bd_decode(bd_ctx, 16);
			}
		}
	}

	/* default: no change */
	DUK_DDD(DUK_DDDPRINT("no rule matches, output is same as input"));
	/* fall through */

 single:
	if (bw != NULL) {
		DUK_BW_WRITE_RAW_XUTF8(thr, bw, (duk_ucodepoint_t) cp);
	}
	return cp;
}

/*
 *  Case conversion helper, with context/local sensitivity.
 *  For proper case conversion, one needs to know the character
 *  and the preceding and following characters, as well as
 *  locale/language.
 */

/* XXX: add 'language' argument when locale/language sensitive rule
 * support added.
 */
DUK_LOCAL
duk_codepoint_t duk__case_transform_helper(duk_hthread *thr,
                                           duk_bufwriter_ctx *bw,
                                           duk_codepoint_t cp,
                                           duk_codepoint_t prev,
                                           duk_codepoint_t next,
                                           duk_bool_t uppercase) {
	duk_bitdecoder_ctx bd_ctx;

	/* fast path for ASCII */
	if (cp < 0x80L) {
		/* XXX: there are language sensitive rules for the ASCII range.
		 * If/when language/locale support is implemented, they need to
		 * be implemented here for the fast path.  There are no context
		 * sensitive rules for ASCII range.
		 */

		if (uppercase) {
			if (cp >= 'a' && cp <= 'z') {
				cp = cp - 'a' + 'A';
			}
		} else {
			if (cp >= 'A' && cp <= 'Z') {
				cp = cp - 'A' + 'a';
			}
		}

		if (bw != NULL) {
			DUK_BW_WRITE_RAW_U8(thr, bw, (duk_uint8_t) cp);
		}
		return cp;
	}

	/* context and locale specific rules which cannot currently be represented
	 * in the caseconv bitstream: hardcoded rules in C
	 */
	if (uppercase) {
		/* XXX: turkish / azeri */
	} else {
		/*
		 *  Final sigma context specific rule.  This is a rather tricky
		 *  rule and this handling is probably not 100% correct now.
		 *  The rule is not locale/language specific so it is supported.
		 */

		if (cp == 0x03a3L &&    /* U+03A3 = GREEK CAPITAL LETTER SIGMA */
		    duk_unicode_is_letter(prev) &&        /* prev exists and is not a letter */
		    !duk_unicode_is_letter(next)) {       /* next does not exist or next is not a letter */
			/* Capital sigma occurred at "end of word", lowercase to
			 * U+03C2 = GREEK SMALL LETTER FINAL SIGMA.  Otherwise
			 * fall through and let the normal rules lowercase it to
			 * U+03C3 = GREEK SMALL LETTER SIGMA.
			 */
			cp = 0x03c2L;
			goto singlechar;
		}

		/* XXX: lithuanian not implemented */
		/* XXX: lithuanian, explicit dot rules */
		/* XXX: turkish / azeri, lowercase rules */
	}

	/* 1:1 or special conversions, but not locale/context specific: script generated rules */
	DUK_MEMZERO(&bd_ctx, sizeof(bd_ctx));
	if (uppercase) {
		bd_ctx.data = (const duk_uint8_t *) duk_unicode_caseconv_uc;
		bd_ctx.length = (duk_size_t) sizeof(duk_unicode_caseconv_uc);
	} else {
		bd_ctx.data = (const duk_uint8_t *) duk_unicode_caseconv_lc;
		bd_ctx.length = (duk_size_t) sizeof(duk_unicode_caseconv_lc);
	}
	return duk__slow_case_conversion(thr, bw, cp, &bd_ctx);

 singlechar:
	if (bw != NULL) {
		DUK_BW_WRITE_RAW_XUTF8(thr, bw, (duk_ucodepoint_t) cp);
	}
	return cp;

 /* unused now, not needed until Turkish/Azeri */
#if 0
 nochar:
	return -1;
#endif
}

/*
 *  Replace valstack top with case converted version.
 */

DUK_INTERNAL void duk_unicode_case_convert_string(duk_hthread *thr, duk_small_int_t uppercase) {
	duk_context *ctx = (duk_context *) thr;
	duk_hstring *h_input;
	duk_bufwriter_ctx bw_alloc;
	duk_bufwriter_ctx *bw;
	const duk_uint8_t *p, *p_start, *p_end;
	duk_codepoint_t prev, curr, next;

	h_input = duk_require_hstring(ctx, -1);
	DUK_ASSERT(h_input != NULL);

	bw = &bw_alloc;
	DUK_BW_INIT_PUSHBUF(thr, bw, DUK_HSTRING_GET_BYTELEN(h_input));

	/* [ ... input buffer ] */

	p_start = (const duk_uint8_t *) DUK_HSTRING_GET_DATA(h_input);
	p_end = p_start + DUK_HSTRING_GET_BYTELEN(h_input);
	p = p_start;

	prev = -1; DUK_UNREF(prev);
	curr = -1;
	next = -1;
	for (;;) {
		prev = curr;
		curr = next;
		next = -1;
		if (p < p_end) {
			next = (int) duk_unicode_decode_xutf8_checked(thr, &p, p_start, p_end);
		} else {
			/* end of input and last char has been processed */
			if (curr < 0) {
				break;
			}
		}

		/* on first round, skip */
		if (curr >= 0) {
			/* XXX: could add a fast path to process chunks of input codepoints,
			 * but relative benefit would be quite small.
			 */

			/* Ensure space for maximum multi-character result; estimate is overkill. */
			DUK_BW_ENSURE(thr, bw, 8 * DUK_UNICODE_MAX_XUTF8_LENGTH);

			duk__case_transform_helper(thr,
			                           bw,
			                           (duk_codepoint_t) curr,
			                           prev,
			                           next,
			                           uppercase);
		}
	}

	DUK_BW_COMPACT(thr, bw);
	duk_to_string(ctx, -1);  /* invalidates h_buf pointer */
	duk_remove(ctx, -2);
}

#ifdef DUK_USE_REGEXP_SUPPORT

/*
 *  Canonicalize() abstract operation needed for canonicalization of individual
 *  codepoints during regexp compilation and execution, see E5 Section 15.10.2.8.
 *  Note that codepoints are canonicalized one character at a time, so no context
 *  specific rules can apply.  Locale specific rules can apply, though.
 */

DUK_INTERNAL duk_codepoint_t duk_unicode_re_canonicalize_char(duk_hthread *thr, duk_codepoint_t cp) {
#if defined(DUK_USE_REGEXP_CANON_WORKAROUND)
	/* Fast canonicalization lookup at the cost of 128kB footprint. */
	DUK_ASSERT(cp >= 0);
	DUK_UNREF(thr);
	if (DUK_LIKELY(cp < 0x10000L)) {
		return (duk_codepoint_t) duk_unicode_re_canon_lookup[cp];
	}
	return cp;
#else  /* DUK_USE_REGEXP_CANON_WORKAROUND */
	duk_codepoint_t y;

	y = duk__case_transform_helper(thr,
	                               NULL,    /* NULL is allowed, no output */
	                               cp,      /* curr char */
	                               -1,      /* prev char */
	                               -1,      /* next char */
	                               1);      /* uppercase */

	if ((y < 0) || (cp >= 0x80 && y < 0x80)) {
		/* multiple codepoint conversion or non-ASCII mapped to ASCII
		 * --> leave as is.
		 */
		return cp;
	}

	return y;
#endif  /* DUK_USE_REGEXP_CANON_WORKAROUND */
}

/*
 *  E5 Section 15.10.2.6 "IsWordChar" abstract operation.  Assume
 *  x < 0 for characters read outside the string.
 */

DUK_INTERNAL duk_small_int_t duk_unicode_re_is_wordchar(duk_codepoint_t x) {
	/*
	 *  Note: the description in E5 Section 15.10.2.6 has a typo, it
	 *  contains 'A' twice and lacks 'a'; the intent is [0-9a-zA-Z_].
	 */
	if ((x >= '0' && x <= '9') ||
	    (x >= 'a' && x <= 'z') ||
	    (x >= 'A' && x <= 'Z') ||
	    (x == '_')) {
		return 1;
	}
	return 0;
}

/*
 *  Regexp range tables
 */

/* exposed because lexer needs these too */
DUK_INTERNAL duk_uint16_t duk_unicode_re_ranges_digit[2] = {
	(duk_uint16_t) 0x0030UL, (duk_uint16_t) 0x0039UL,
};
DUK_INTERNAL duk_uint16_t duk_unicode_re_ranges_white[22] = {
	(duk_uint16_t) 0x0009UL, (duk_uint16_t) 0x000DUL,
	(duk_uint16_t) 0x0020UL, (duk_uint16_t) 0x0020UL,
	(duk_uint16_t) 0x00A0UL, (duk_uint16_t) 0x00A0UL,
	(duk_uint16_t) 0x1680UL, (duk_uint16_t) 0x1680UL,
	(duk_uint16_t) 0x180EUL, (duk_uint16_t) 0x180EUL,
	(duk_uint16_t) 0x2000UL, (duk_uint16_t) 0x200AUL,
	(duk_uint16_t) 0x2028UL, (duk_uint16_t) 0x2029UL,
	(duk_uint16_t) 0x202FUL, (duk_uint16_t) 0x202FUL,
	(duk_uint16_t) 0x205FUL, (duk_uint16_t) 0x205FUL,
	(duk_uint16_t) 0x3000UL, (duk_uint16_t) 0x3000UL,
	(duk_uint16_t) 0xFEFFUL, (duk_uint16_t) 0xFEFFUL,
};
DUK_INTERNAL duk_uint16_t duk_unicode_re_ranges_wordchar[8] = {
	(duk_uint16_t) 0x0030UL, (duk_uint16_t) 0x0039UL,
	(duk_uint16_t) 0x0041UL, (duk_uint16_t) 0x005AUL,
	(duk_uint16_t) 0x005FUL, (duk_uint16_t) 0x005FUL,
	(duk_uint16_t) 0x0061UL, (duk_uint16_t) 0x007AUL,
};
DUK_INTERNAL duk_uint16_t duk_unicode_re_ranges_not_digit[4] = {
	(duk_uint16_t) 0x0000UL, (duk_uint16_t) 0x002FUL,
	(duk_uint16_t) 0x003AUL, (duk_uint16_t) 0xFFFFUL,
};
DUK_INTERNAL duk_uint16_t duk_unicode_re_ranges_not_white[24] = {
	(duk_uint16_t) 0x0000UL, (duk_uint16_t) 0x0008UL,
	(duk_uint16_t) 0x000EUL, (duk_uint16_t) 0x001FUL,
	(duk_uint16_t) 0x0021UL, (duk_uint16_t) 0x009FUL,
	(duk_uint16_t) 0x00A1UL, (duk_uint16_t) 0x167FUL,
	(duk_uint16_t) 0x1681UL, (duk_uint16_t) 0x180DUL,
	(duk_uint16_t) 0x180FUL, (duk_uint16_t) 0x1FFFUL,
	(duk_uint16_t) 0x200BUL, (duk_uint16_t) 0x2027UL,
	(duk_uint16_t) 0x202AUL, (duk_uint16_t) 0x202EUL,
	(duk_uint16_t) 0x2030UL, (duk_uint16_t) 0x205EUL,
	(duk_uint16_t) 0x2060UL, (duk_uint16_t) 0x2FFFUL,
	(duk_uint16_t) 0x3001UL, (duk_uint16_t) 0xFEFEUL,
	(duk_uint16_t) 0xFF00UL, (duk_uint16_t) 0xFFFFUL,
};
DUK_INTERNAL duk_uint16_t duk_unicode_re_ranges_not_wordchar[10] = {
	(duk_uint16_t) 0x0000UL, (duk_uint16_t) 0x002FUL,
	(duk_uint16_t) 0x003AUL, (duk_uint16_t) 0x0040UL,
	(duk_uint16_t) 0x005BUL, (duk_uint16_t) 0x005EUL,
	(duk_uint16_t) 0x0060UL, (duk_uint16_t) 0x0060UL,
	(duk_uint16_t) 0x007BUL, (duk_uint16_t) 0xFFFFUL,
};

#endif  /* DUK_USE_REGEXP_SUPPORT */
#line 1 "duk_util_misc.c"
/*
 *  Misc util stuff
 */

/* include removed: duk_internal.h */

/*
 *  Lowercase digits for radix values 2 to 36.  Also doubles as lowercase
 *  hex nybble table.
 */

DUK_INTERNAL const duk_uint8_t duk_lc_digits[36] = {
	DUK_ASC_0, DUK_ASC_1, DUK_ASC_2, DUK_ASC_3,
	DUK_ASC_4, DUK_ASC_5, DUK_ASC_6, DUK_ASC_7,
	DUK_ASC_8, DUK_ASC_9, DUK_ASC_LC_A, DUK_ASC_LC_B,
	DUK_ASC_LC_C, DUK_ASC_LC_D, DUK_ASC_LC_E, DUK_ASC_LC_F,
	DUK_ASC_LC_G, DUK_ASC_LC_H, DUK_ASC_LC_I, DUK_ASC_LC_J,
	DUK_ASC_LC_K, DUK_ASC_LC_L, DUK_ASC_LC_M, DUK_ASC_LC_N,
	DUK_ASC_LC_O, DUK_ASC_LC_P, DUK_ASC_LC_Q, DUK_ASC_LC_R,
	DUK_ASC_LC_S, DUK_ASC_LC_T, DUK_ASC_LC_U, DUK_ASC_LC_V,
	DUK_ASC_LC_W, DUK_ASC_LC_X, DUK_ASC_LC_Y, DUK_ASC_LC_Z
};

DUK_INTERNAL const duk_uint8_t duk_uc_nybbles[16] = {
	DUK_ASC_0, DUK_ASC_1, DUK_ASC_2, DUK_ASC_3,
	DUK_ASC_4, DUK_ASC_5, DUK_ASC_6, DUK_ASC_7,
	DUK_ASC_8, DUK_ASC_9, DUK_ASC_UC_A, DUK_ASC_UC_B,
	DUK_ASC_UC_C, DUK_ASC_UC_D, DUK_ASC_UC_E, DUK_ASC_UC_F
};

/*
 *  Table for hex decoding ASCII hex digits
 */

DUK_INTERNAL const duk_int8_t duk_hex_dectab[256] = {
	/* -1 if invalid */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x00-0x0f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x10-0x1f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x20-0x2f */
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1,  /* 0x30-0x3f */
	-1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x40-0x4f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x50-0x5f */
	-1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x60-0x6f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x70-0x7f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x80-0x8f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x90-0x9f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xa0-0xaf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xb0-0xbf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xc0-0xcf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xd0-0xdf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xe0-0xef */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1   /* 0xf0-0xff */
};

#if defined(DUK_USE_HEX_FASTPATH)
/* Preshifted << 4.  Must use 16-bit entry to allow negative value signaling. */
DUK_INTERNAL const duk_int16_t duk_hex_dectab_shift4[256] = {
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x00-0x0f */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x10-0x1f */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x20-0x2f */
	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x30-0x3f */
	  -1, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x40-0x4f */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x50-0x5f */
	  -1, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x60-0x6f */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x70-0x7f */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x80-0x8f */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0x90-0x9f */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0xa0-0xaf */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0xb0-0xbf */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0xc0-0xcf */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0xd0-0xdf */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  /* 0xe0-0xef */
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1   /* 0xf0-0xff */
};
#endif

/*
 *  Table for hex encoding bytes
 */

#if defined(DUK_USE_HEX_FASTPATH)
/* Lookup to encode one byte directly into 2 characters:
 *
 *   def genhextab(bswap):
 *       for i in xrange(256):
 *           t = chr(i).encode('hex')
 *           if bswap:
 *               t = t[1] + t[0]
 *           print('0x' + t.encode('hex') + 'U')
 *   print('big endian'); genhextab(False)
 *   print('little endian'); genhextab(True)
*/
DUK_INTERNAL const duk_uint16_t duk_hex_enctab[256] = {
#if defined(DUK_USE_INTEGER_BE)
	0x3030U, 0x3031U, 0x3032U, 0x3033U, 0x3034U, 0x3035U, 0x3036U, 0x3037U,
	0x3038U, 0x3039U, 0x3061U, 0x3062U, 0x3063U, 0x3064U, 0x3065U, 0x3066U,
	0x3130U, 0x3131U, 0x3132U, 0x3133U, 0x3134U, 0x3135U, 0x3136U, 0x3137U,
	0x3138U, 0x3139U, 0x3161U, 0x3162U, 0x3163U, 0x3164U, 0x3165U, 0x3166U,
	0x3230U, 0x3231U, 0x3232U, 0x3233U, 0x3234U, 0x3235U, 0x3236U, 0x3237U,
	0x3238U, 0x3239U, 0x3261U, 0x3262U, 0x3263U, 0x3264U, 0x3265U, 0x3266U,
	0x3330U, 0x3331U, 0x3332U, 0x3333U, 0x3334U, 0x3335U, 0x3336U, 0x3337U,
	0x3338U, 0x3339U, 0x3361U, 0x3362U, 0x3363U, 0x3364U, 0x3365U, 0x3366U,
	0x3430U, 0x3431U, 0x3432U, 0x3433U, 0x3434U, 0x3435U, 0x3436U, 0x3437U,
	0x3438U, 0x3439U, 0x3461U, 0x3462U, 0x3463U, 0x3464U, 0x3465U, 0x3466U,
	0x3530U, 0x3531U, 0x3532U, 0x3533U, 0x3534U, 0x3535U, 0x3536U, 0x3537U,
	0x3538U, 0x3539U, 0x3561U, 0x3562U, 0x3563U, 0x3564U, 0x3565U, 0x3566U,
	0x3630U, 0x3631U, 0x3632U, 0x3633U, 0x3634U, 0x3635U, 0x3636U, 0x3637U,
	0x3638U, 0x3639U, 0x3661U, 0x3662U, 0x3663U, 0x3664U, 0x3665U, 0x3666U,
	0x3730U, 0x3731U, 0x3732U, 0x3733U, 0x3734U, 0x3735U, 0x3736U, 0x3737U,
	0x3738U, 0x3739U, 0x3761U, 0x3762U, 0x3763U, 0x3764U, 0x3765U, 0x3766U,
	0x3830U, 0x3831U, 0x3832U, 0x3833U, 0x3834U, 0x3835U, 0x3836U, 0x3837U,
	0x3838U, 0x3839U, 0x3861U, 0x3862U, 0x3863U, 0x3864U, 0x3865U, 0x3866U,
	0x3930U, 0x3931U, 0x3932U, 0x3933U, 0x3934U, 0x3935U, 0x3936U, 0x3937U,
	0x3938U, 0x3939U, 0x3961U, 0x3962U, 0x3963U, 0x3964U, 0x3965U, 0x3966U,
	0x6130U, 0x6131U, 0x6132U, 0x6133U, 0x6134U, 0x6135U, 0x6136U, 0x6137U,
	0x6138U, 0x6139U, 0x6161U, 0x6162U, 0x6163U, 0x6164U, 0x6165U, 0x6166U,
	0x6230U, 0x6231U, 0x6232U, 0x6233U, 0x6234U, 0x6235U, 0x6236U, 0x6237U,
	0x6238U, 0x6239U, 0x6261U, 0x6262U, 0x6263U, 0x6264U, 0x6265U, 0x6266U,
	0x6330U, 0x6331U, 0x6332U, 0x6333U, 0x6334U, 0x6335U, 0x6336U, 0x6337U,
	0x6338U, 0x6339U, 0x6361U, 0x6362U, 0x6363U, 0x6364U, 0x6365U, 0x6366U,
	0x6430U, 0x6431U, 0x6432U, 0x6433U, 0x6434U, 0x6435U, 0x6436U, 0x6437U,
	0x6438U, 0x6439U, 0x6461U, 0x6462U, 0x6463U, 0x6464U, 0x6465U, 0x6466U,
	0x6530U, 0x6531U, 0x6532U, 0x6533U, 0x6534U, 0x6535U, 0x6536U, 0x6537U,
	0x6538U, 0x6539U, 0x6561U, 0x6562U, 0x6563U, 0x6564U, 0x6565U, 0x6566U,
	0x6630U, 0x6631U, 0x6632U, 0x6633U, 0x6634U, 0x6635U, 0x6636U, 0x6637U,
	0x6638U, 0x6639U, 0x6661U, 0x6662U, 0x6663U, 0x6664U, 0x6665U, 0x6666U
#else  /* DUK_USE_INTEGER_BE */
	0x3030U, 0x3130U, 0x3230U, 0x3330U, 0x3430U, 0x3530U, 0x3630U, 0x3730U,
	0x3830U, 0x3930U, 0x6130U, 0x6230U, 0x6330U, 0x6430U, 0x6530U, 0x6630U,
	0x3031U, 0x3131U, 0x3231U, 0x3331U, 0x3431U, 0x3531U, 0x3631U, 0x3731U,
	0x3831U, 0x3931U, 0x6131U, 0x6231U, 0x6331U, 0x6431U, 0x6531U, 0x6631U,
	0x3032U, 0x3132U, 0x3232U, 0x3332U, 0x3432U, 0x3532U, 0x3632U, 0x3732U,
	0x3832U, 0x3932U, 0x6132U, 0x6232U, 0x6332U, 0x6432U, 0x6532U, 0x6632U,
	0x3033U, 0x3133U, 0x3233U, 0x3333U, 0x3433U, 0x3533U, 0x3633U, 0x3733U,
	0x3833U, 0x3933U, 0x6133U, 0x6233U, 0x6333U, 0x6433U, 0x6533U, 0x6633U,
	0x3034U, 0x3134U, 0x3234U, 0x3334U, 0x3434U, 0x3534U, 0x3634U, 0x3734U,
	0x3834U, 0x3934U, 0x6134U, 0x6234U, 0x6334U, 0x6434U, 0x6534U, 0x6634U,
	0x3035U, 0x3135U, 0x3235U, 0x3335U, 0x3435U, 0x3535U, 0x3635U, 0x3735U,
	0x3835U, 0x3935U, 0x6135U, 0x6235U, 0x6335U, 0x6435U, 0x6535U, 0x6635U,
	0x3036U, 0x3136U, 0x3236U, 0x3336U, 0x3436U, 0x3536U, 0x3636U, 0x3736U,
	0x3836U, 0x3936U, 0x6136U, 0x6236U, 0x6336U, 0x6436U, 0x6536U, 0x6636U,
	0x3037U, 0x3137U, 0x3237U, 0x3337U, 0x3437U, 0x3537U, 0x3637U, 0x3737U,
	0x3837U, 0x3937U, 0x6137U, 0x6237U, 0x6337U, 0x6437U, 0x6537U, 0x6637U,
	0x3038U, 0x3138U, 0x3238U, 0x3338U, 0x3438U, 0x3538U, 0x3638U, 0x3738U,
	0x3838U, 0x3938U, 0x6138U, 0x6238U, 0x6338U, 0x6438U, 0x6538U, 0x6638U,
	0x3039U, 0x3139U, 0x3239U, 0x3339U, 0x3439U, 0x3539U, 0x3639U, 0x3739U,
	0x3839U, 0x3939U, 0x6139U, 0x6239U, 0x6339U, 0x6439U, 0x6539U, 0x6639U,
	0x3061U, 0x3161U, 0x3261U, 0x3361U, 0x3461U, 0x3561U, 0x3661U, 0x3761U,
	0x3861U, 0x3961U, 0x6161U, 0x6261U, 0x6361U, 0x6461U, 0x6561U, 0x6661U,
	0x3062U, 0x3162U, 0x3262U, 0x3362U, 0x3462U, 0x3562U, 0x3662U, 0x3762U,
	0x3862U, 0x3962U, 0x6162U, 0x6262U, 0x6362U, 0x6462U, 0x6562U, 0x6662U,
	0x3063U, 0x3163U, 0x3263U, 0x3363U, 0x3463U, 0x3563U, 0x3663U, 0x3763U,
	0x3863U, 0x3963U, 0x6163U, 0x6263U, 0x6363U, 0x6463U, 0x6563U, 0x6663U,
	0x3064U, 0x3164U, 0x3264U, 0x3364U, 0x3464U, 0x3564U, 0x3664U, 0x3764U,
	0x3864U, 0x3964U, 0x6164U, 0x6264U, 0x6364U, 0x6464U, 0x6564U, 0x6664U,
	0x3065U, 0x3165U, 0x3265U, 0x3365U, 0x3465U, 0x3565U, 0x3665U, 0x3765U,
	0x3865U, 0x3965U, 0x6165U, 0x6265U, 0x6365U, 0x6465U, 0x6565U, 0x6665U,
	0x3066U, 0x3166U, 0x3266U, 0x3366U, 0x3466U, 0x3566U, 0x3666U, 0x3766U,
	0x3866U, 0x3966U, 0x6166U, 0x6266U, 0x6366U, 0x6466U, 0x6566U, 0x6666U
#endif  /* DUK_USE_INTEGER_BE */
};
#endif  /* DUK_USE_HEX_FASTPATH */

/*
 *  Table for base-64 encoding
 */

#if defined(DUK_USE_BASE64_FASTPATH)
DUK_INTERNAL const duk_uint8_t duk_base64_enctab[64] = {
	0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,  /* A...P */
	0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,  /* Q...f */
	0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,  /* g...v */
	0x77, 0x78, 0x79, 0x7a, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x2b, 0x2f   /* w.../ */
};
#endif  /* DUK_USE_BASE64_FASTPATH */

/*
 *  Table for base-64 decoding
 */

#if defined(DUK_USE_BASE64_FASTPATH)
DUK_INTERNAL const duk_int8_t duk_base64_dectab[256] = {
	/* -1 = error, -2 = allowed whitespace, -3 = padding ('='), 0...63 decoded bytes */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -1, -1, -2, -1, -1,  /* 0x00...0x0f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x10...0x1f */
	-2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,  /* 0x20...0x2f */
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -3, -1, -1,  /* 0x30...0x3f */
	-1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,  /* 0x40...0x4f */
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,  /* 0x50...0x5f */
	-1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,  /* 0x60...0x6f */
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1,  /* 0x70...0x7f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x80...0x8f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0x90...0x9f */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xa0...0xaf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xb0...0xbf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xc0...0xcf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xd0...0xdf */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  /* 0xe0...0xef */
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1   /* 0xf0...0xff */
};
#endif  /* DUK_USE_BASE64_FASTPATH */

/*
 *  Arbitrary byteswap for potentially unaligned values
 *
 *  Used to byteswap pointers e.g. in debugger code.
 */

#if defined(DUK_USE_DEBUGGER_SUPPORT)  /* For now only needed by the debugger. */
DUK_INTERNAL void duk_byteswap_bytes(duk_uint8_t *p, duk_small_uint_t len) {
	duk_uint8_t tmp;
	duk_uint8_t *q = p + len - 1;

	while (p - q < 0) {
		tmp = *p;
		*p = *q;
		*q = tmp;
		p++;
		q--;
	}
}
#endif
#line 1 "duk_util_hashprime.c"
/*
 *  Round a number upwards to a prime (not usually the nearest one).
 *
 *  Uses a table of successive 32-bit primes whose ratio is roughly
 *  constant.  This keeps the relative upwards 'rounding error' bounded
 *  and the data size small.  A simple 'predict-correct' compression is
 *  used to compress primes to one byte per prime.  See genhashsizes.py
 *  for details.
 *
 *  The minimum prime returned here must be coordinated with the possible
 *  probe sequence steps in duk_hobject and duk_heap stringtable.
 */

/* include removed: duk_internal.h */

/* Awkward inclusion condition: drop out of compilation if not needed by any
 * call site: object hash part or probing stringtable.
 */
#if defined(DUK_USE_HOBJECT_HASH_PART) || defined(DUK_USE_STRTAB_PROBE)

/* hash size ratio goal, must match genhashsizes.py */
#define DUK__HASH_SIZE_RATIO   1177  /* floor(1.15 * (1 << 10)) */

/* prediction corrections for prime list (see genhashsizes.py) */
DUK_LOCAL const duk_int8_t duk__hash_size_corrections[] = {
	17,  /* minimum prime */
	4, 3, 4, 1, 4, 1, 1, 2, 2, 2, 2, 1, 6, 6, 9, 5, 1, 2, 2, 5, 1, 3, 3, 3,
	5, 4, 4, 2, 4, 8, 3, 4, 23, 2, 4, 7, 8, 11, 2, 12, 15, 10, 1, 1, 5, 1, 5,
	8, 9, 17, 14, 10, 7, 5, 2, 46, 21, 1, 9, 9, 4, 4, 10, 23, 36, 6, 20, 29,
	18, 6, 19, 21, 16, 11, 5, 5, 48, 9, 1, 39, 14, 8, 4, 29, 9, 1, 15, 48, 12,
	22, 6, 15, 27, 4, 2, 17, 28, 8, 9, 4, 5, 8, 3, 3, 8, 37, 11, 15, 8, 30,
	43, 6, 33, 41, 5, 20, 32, 41, 38, 24, 77, 14, 19, 11, 4, 35, 18, 19, 41,
	10, 23, 16, 9, 2,
	-1
};

/* probe steps (see genhashsizes.py), currently assumed to be 32 entries long
 * (DUK_UTIL_GET_HASH_PROBE_STEP macro).
 */
DUK_INTERNAL duk_uint8_t duk_util_probe_steps[32] = {
	2, 3, 5, 7, 11, 13, 19, 31, 41, 47, 59, 67, 73, 79, 89, 101, 103, 107,
	109, 127, 137, 139, 149, 157, 163, 167, 173, 181, 191, 193, 197, 199
};

DUK_INTERNAL duk_uint32_t duk_util_get_hash_prime(duk_uint32_t size) {
	const duk_int8_t *p = duk__hash_size_corrections;
	duk_uint32_t curr;

	curr = (duk_uint32_t) *p++;
	for (;;) {
		duk_small_int_t t = (duk_small_int_t) *p++;
		if (t < 0) {
			/* may happen if size is very close to 2^32-1 */
			break;
		}

		/* prediction: portable variant using doubles if 64-bit values not available */
#ifdef DUK_USE_64BIT_OPS
		curr = (duk_uint32_t) ((((duk_uint64_t) curr) * ((duk_uint64_t) DUK__HASH_SIZE_RATIO)) >> 10);
#else
		/* 32-bit x 11-bit = 43-bit, fits accurately into a double */
		curr = (duk_uint32_t) DUK_FLOOR(((double) curr) * ((double) DUK__HASH_SIZE_RATIO) / 1024.0);
#endif

		/* correction */
		curr += t;

		DUK_DDD(DUK_DDDPRINT("size=%ld, curr=%ld", (long) size, (long) curr));

		if (curr >= size) {
			return curr;
		}
	}
	return 0;
}

#endif  /* DUK_USE_HOBJECT_HASH_PART || DUK_USE_STRTAB_PROBE */
#line 1 "duk_hobject_class.c"
/*
 *  Hobject Ecmascript [[Class]].
 */

/* include removed: duk_internal.h */

#if (DUK_STRIDX_UC_ARGUMENTS > 255)
#error constant too large
#endif
#if (DUK_STRIDX_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_BOOLEAN > 255)
#error constant too large
#endif
#if (DUK_STRIDX_DATE > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_ERROR > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_FUNCTION > 255)
#error constant too large
#endif
#if (DUK_STRIDX_JSON > 255)
#error constant too large
#endif
#if (DUK_STRIDX_MATH > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_NUMBER > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_OBJECT > 255)
#error constant too large
#endif
#if (DUK_STRIDX_REG_EXP > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_STRING > 255)
#error constant too large
#endif
#if (DUK_STRIDX_GLOBAL > 255)
#error constant too large
#endif
#if (DUK_STRIDX_OBJ_ENV > 255)
#error constant too large
#endif
#if (DUK_STRIDX_DEC_ENV > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_BUFFER > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_POINTER > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UC_THREAD > 255)
#error constant too large
#endif
#if (DUK_STRIDX_ARRAY_BUFFER > 255)
#error constant too large
#endif
#if (DUK_STRIDX_DATA_VIEW > 255)
#error constant too large
#endif
#if (DUK_STRIDX_INT8_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UINT8_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UINT8_CLAMPED_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_INT16_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UINT16_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_INT32_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_UINT32_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_FLOAT32_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_FLOAT64_ARRAY > 255)
#error constant too large
#endif
#if (DUK_STRIDX_EMPTY_STRING > 255)
#error constant too large
#endif

/* Note: assumes that these string indexes are 8-bit, genstrings.py must ensure that */
DUK_INTERNAL duk_uint8_t duk_class_number_to_stridx[32] = {
	DUK_STRIDX_EMPTY_STRING,  /* UNUSED, intentionally empty */
	DUK_STRIDX_UC_ARGUMENTS,
	DUK_STRIDX_ARRAY,
	DUK_STRIDX_UC_BOOLEAN,
	DUK_STRIDX_DATE,
	DUK_STRIDX_UC_ERROR,
	DUK_STRIDX_UC_FUNCTION,
	DUK_STRIDX_JSON,
	DUK_STRIDX_MATH,
	DUK_STRIDX_UC_NUMBER,
	DUK_STRIDX_UC_OBJECT,
	DUK_STRIDX_REG_EXP,
	DUK_STRIDX_UC_STRING,
	DUK_STRIDX_GLOBAL,
	DUK_STRIDX_OBJ_ENV,
	DUK_STRIDX_DEC_ENV,
	DUK_STRIDX_UC_BUFFER,
	DUK_STRIDX_UC_POINTER,
	DUK_STRIDX_UC_THREAD,
	DUK_STRIDX_ARRAY_BUFFER,
	DUK_STRIDX_DATA_VIEW,
	DUK_STRIDX_INT8_ARRAY,
	DUK_STRIDX_UINT8_ARRAY,
	DUK_STRIDX_UINT8_CLAMPED_ARRAY,
	DUK_STRIDX_INT16_ARRAY,
	DUK_STRIDX_UINT16_ARRAY,
	DUK_STRIDX_INT32_ARRAY,
	DUK_STRIDX_UINT32_ARRAY,
	DUK_STRIDX_FLOAT32_ARRAY,
	DUK_STRIDX_FLOAT64_ARRAY,
	DUK_STRIDX_EMPTY_STRING,  /* UNUSED, intentionally empty */
	DUK_STRIDX_EMPTY_STRING,  /* UNUSED, intentionally empty */
};
#line 1 "duk_alloc_default.c"
/*
 *  Default allocation functions.
 *
 *  Assumes behavior such as malloc allowing zero size, yielding
 *  a NULL or a unique pointer which is a no-op for free.
 */

/* include removed: duk_internal.h */

DUK_INTERNAL void *duk_default_alloc_function(void *udata, duk_size_t size) {
	void *res;
	DUK_UNREF(udata);
	res = DUK_ANSI_MALLOC(size);
	DUK_DDD(DUK_DDDPRINT("default alloc function: %lu -> %p",
	                     (unsigned long) size, (void *) res));
	return res;
}

DUK_INTERNAL void *duk_default_realloc_function(void *udata, void *ptr, duk_size_t newsize) {
	void *res;
	DUK_UNREF(udata);
	res = DUK_ANSI_REALLOC(ptr, newsize);
	DUK_DDD(DUK_DDDPRINT("default realloc function: %p %lu -> %p",
	                     (void *) ptr, (unsigned long) newsize, (void *) res));
	return res;
}

DUK_INTERNAL void duk_default_free_function(void *udata, void *ptr) {
	DUK_DDD(DUK_DDDPRINT("default free function: %p", (void *) ptr));
	DUK_UNREF(udata);
	DUK_ANSI_FREE(ptr);
}
#line 1 "duk_api_buffer.c"
/*
 *  Buffer
 */

/* include removed: duk_internal.h */

DUK_EXTERNAL void *duk_resize_buffer(duk_context *ctx, duk_idx_t index, duk_size_t new_size) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_hbuffer_dynamic *h;

	DUK_ASSERT_CTX_VALID(ctx);

	h = (duk_hbuffer_dynamic *) duk_require_hbuffer(ctx, index);
	DUK_ASSERT(h != NULL);

	if (!(DUK_HBUFFER_HAS_DYNAMIC(h) && !DUK_HBUFFER_HAS_EXTERNAL(h))) {
		DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_WRONG_BUFFER_TYPE);
	}

	/* maximum size check is handled by callee */
	duk_hbuffer_resize(thr, h, new_size);

	return DUK_HBUFFER_DYNAMIC_GET_DATA_PTR(thr->heap, h);
}

DUK_EXTERNAL void *duk_steal_buffer(duk_context *ctx, duk_idx_t index, duk_size_t *out_size) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_hbuffer_dynamic *h;
	void *ptr;
	duk_size_t sz;

	DUK_ASSERT(ctx != NULL);

	h = (duk_hbuffer_dynamic *) duk_require_hbuffer(ctx, index);
	DUK_ASSERT(h != NULL);

	if (!(DUK_HBUFFER_HAS_DYNAMIC(h) && !DUK_HBUFFER_HAS_EXTERNAL(h))) {
		DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_WRONG_BUFFER_TYPE);
	}

	/* Forget the previous allocation, setting size to 0 and alloc to
	 * NULL.  Caller is responsible for freeing the previous allocation.
	 * Getting the allocation and clearing it is done in the same API
	 * call to avoid any chance of a realloc.
	 */
	ptr = DUK_HBUFFER_DYNAMIC_GET_DATA_PTR(thr->heap, h);
	sz = DUK_HBUFFER_DYNAMIC_GET_SIZE(h);
	if (out_size) {
		*out_size = sz;
	}
	DUK_HBUFFER_DYNAMIC_SET_DATA_PTR_NULL(thr->heap, h);
	DUK_HBUFFER_DYNAMIC_SET_SIZE(h, 0);

	return ptr;
}

DUK_EXTERNAL void duk_config_buffer(duk_context *ctx, duk_idx_t index, void *ptr, duk_size_t len) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_hbuffer_external *h;

	DUK_ASSERT(ctx != NULL);

	h = (duk_hbuffer_external *) duk_require_hbuffer(ctx, index);
	DUK_ASSERT(h != NULL);

	if (!DUK_HBUFFER_HAS_EXTERNAL(h)) {
		DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_WRONG_BUFFER_TYPE);
	}
	DUK_ASSERT(DUK_HBUFFER_HAS_DYNAMIC(h));

	DUK_HBUFFER_EXTERNAL_SET_DATA_PTR(thr->heap, h, ptr);
	DUK_HBUFFER_EXTERNAL_SET_SIZE(h, len);
}
#line 1 "duk_api_bytecode.c"
/*
 *  Bytecode dump/load
 *
 *  The bytecode load primitive is more important performance-wise than the
 *  dump primitive.
 *
 *  Unlike most Duktape API calls, bytecode dump/load is not guaranteed to be
 *  memory safe for invalid arguments - caller beware!  There's little point
 *  in trying to achieve memory safety unless bytecode instructions are also
 *  validated which is not easy to do with indirect register references etc.
 */

/* include removed: duk_internal.h */

#if defined(DUK_USE_BYTECODE_DUMP_SUPPORT)

#define DUK__SER_MARKER  0xff
#define DUK__SER_VERSION 0x00
#define DUK__SER_STRING  0x00
#define DUK__SER_NUMBER  0x01
#define DUK__BYTECODE_INITIAL_ALLOC 256

/*
 *  Dump/load helpers, xxx_raw() helpers do no buffer checks
 */

DUK_LOCAL duk_uint8_t *duk__load_string_raw(duk_context *ctx, duk_uint8_t *p) {
	duk_uint32_t len;

	len = DUK_RAW_READ_U32_BE(p);
	duk_push_lstring(ctx, (const char *) p, len);
	p += len;
	return p;
}

DUK_LOCAL duk_uint8_t *duk__load_buffer_raw(duk_context *ctx, duk_uint8_t *p) {
	duk_uint32_t len;
	duk_uint8_t *buf;

	len = DUK_RAW_READ_U32_BE(p);
	buf = (duk_uint8_t *) duk_push_fixed_buffer(ctx, (duk_size_t) len);
	DUK_ASSERT(buf != NULL);
	DUK_MEMCPY((void *) buf, (const void *) p, (size_t) len);
	p += len;
	return p;
}

DUK_LOCAL duk_uint8_t *duk__dump_hstring_raw(duk_uint8_t *p, duk_hstring *h) {
	duk_size_t len;
	duk_uint32_t tmp32;

	DUK_ASSERT(h != NULL);

	len = DUK_HSTRING_GET_BYTELEN(h);
	DUK_ASSERT(len <= 0xffffffffUL);  /* string limits */
	tmp32 = (duk_uint32_t) len;
	DUK_RAW_WRITE_U32_BE(p, tmp32);
	DUK_MEMCPY((void *) p,
	           (const void *) DUK_HSTRING_GET_DATA(h),
	           len);
	p += len;
	return p;
}

DUK_LOCAL duk_uint8_t *duk__dump_hbuffer_raw(duk_hthread *thr, duk_uint8_t *p, duk_hbuffer *h) {
	duk_size_t len;
	duk_uint32_t tmp32;

	DUK_ASSERT(thr != NULL);
	DUK_ASSERT(h != NULL);
	DUK_UNREF(thr);

	len = DUK_HBUFFER_GET_SIZE(h);
	DUK_ASSERT(len <= 0xffffffffUL);  /* buffer limits */
	tmp32 = (duk_uint32_t) len;
	DUK_RAW_WRITE_U32_BE(p, tmp32);
	DUK_MEMCPY((void *) p,
	           (const void *) DUK_HBUFFER_GET_DATA_PTR(thr->heap, h),
	           len);
	p += len;
	return p;
}

DUK_LOCAL duk_uint8_t *duk__dump_string_prop(duk_hthread *thr, duk_uint8_t *p, duk_bufwriter_ctx *bw_ctx, duk_hobject *func, duk_small_uint_t stridx) {
	duk_hstring *h_str;
	duk_tval *tv;

	tv = duk_hobject_find_existing_entry_tval_ptr(thr->heap, (duk_hobject *) func, DUK_HTHREAD_GET_STRING(thr, stridx));
	if (tv != NULL && DUK_TVAL_IS_STRING(tv)) {
		h_str = DUK_TVAL_GET_STRING(tv);
		DUK_ASSERT(h_str != NULL);
	} else {
		h_str = DUK_HTHREAD_STRING_EMPTY_STRING(thr);
		DUK_ASSERT(h_str != NULL);
	}
	DUK_ASSERT(DUK_HSTRING_MAX_BYTELEN <= 0x7fffffffUL);  /* ensures no overflow */
	p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4 + DUK_HSTRING_GET_BYTELEN(h_str), p);
	p = duk__dump_hstring_raw(p, h_str);
	return p;
}

DUK_LOCAL duk_uint8_t *duk__dump_buffer_prop(duk_hthread *thr, duk_uint8_t *p, duk_bufwriter_ctx *bw_ctx, duk_hobject *func, duk_small_uint_t stridx) {
	duk_tval *tv;

	tv = duk_hobject_find_existing_entry_tval_ptr(thr->heap, (duk_hobject *) func, DUK_HTHREAD_GET_STRING(thr, stridx));
	if (tv != NULL && DUK_TVAL_IS_BUFFER(tv)) {
		duk_hbuffer *h_buf;
		h_buf = DUK_TVAL_GET_BUFFER(tv);
		DUK_ASSERT(h_buf != NULL);
		DUK_ASSERT(DUK_HBUFFER_MAX_BYTELEN <= 0x7fffffffUL);  /* ensures no overflow */
		p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4 + DUK_HBUFFER_GET_SIZE(h_buf), p);
		p = duk__dump_hbuffer_raw(thr, p, h_buf);
	} else {
		p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4, p);
		DUK_RAW_WRITE_U32_BE(p, 0);
	}
	return p;
}

DUK_LOCAL duk_uint8_t *duk__dump_uint32_prop(duk_hthread *thr, duk_uint8_t *p, duk_bufwriter_ctx *bw_ctx, duk_hobject *func, duk_small_uint_t stridx, duk_uint32_t def_value) {
	duk_tval *tv;
	duk_uint32_t val;

	tv = duk_hobject_find_existing_entry_tval_ptr(thr->heap, (duk_hobject *) func, DUK_HTHREAD_GET_STRING(thr, stridx));
	if (tv != NULL && DUK_TVAL_IS_NUMBER(tv)) {
		val = (duk_uint32_t) DUK_TVAL_GET_NUMBER(tv);
	} else {
		val = def_value;
	}
	p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4, p);
	DUK_RAW_WRITE_U32_BE(p, val);
	return p;
}

DUK_LOCAL duk_uint8_t *duk__dump_varmap(duk_hthread *thr, duk_uint8_t *p, duk_bufwriter_ctx *bw_ctx, duk_hobject *func) {
	duk_tval *tv;

	tv = duk_hobject_find_existing_entry_tval_ptr(thr->heap, (duk_hobject *) func, DUK_HTHREAD_STRING_INT_VARMAP(thr));
	if (tv != NULL && DUK_TVAL_IS_OBJECT(tv)) {
		duk_hobject *h;
		duk_uint_fast32_t i;

		h = DUK_TVAL_GET_OBJECT(tv);
		DUK_ASSERT(h != NULL);

		/* We know _Varmap only has own properties so walk property
		 * table directly.  We also know _Varmap is dense and all
		 * values are numbers; assert for these.  GC and finalizers
		 * shouldn't affect _Varmap so side effects should be fine.
		 */
		for (i = 0; i < (duk_uint_fast32_t) DUK_HOBJECT_GET_ENEXT(h); i++) {
			duk_hstring *key;
			duk_tval *tv_val;
			duk_uint32_t val;

			key = DUK_HOBJECT_E_GET_KEY(thr->heap, h, i);
			DUK_ASSERT(key != NULL);  /* _Varmap is dense */
			DUK_ASSERT(!DUK_HOBJECT_E_SLOT_IS_ACCESSOR(thr->heap, h, i));
			tv_val = DUK_HOBJECT_E_GET_VALUE_TVAL_PTR(thr->heap, h, i);
			DUK_ASSERT(tv_val != NULL);
			DUK_ASSERT(DUK_TVAL_IS_NUMBER(tv_val));  /* known to be number; in fact an integer */
#if defined(DUK_USE_FASTINT)
			DUK_ASSERT(DUK_TVAL_IS_FASTINT(tv_val));
			DUK_ASSERT(DUK_TVAL_GET_FASTINT(tv_val) == (duk_int64_t) DUK_TVAL_GET_FASTINT_U32(tv_val));  /* known to be 32-bit */
			val = DUK_TVAL_GET_FASTINT_U32(tv_val);
#else
			val = (duk_uint32_t) DUK_TVAL_GET_NUMBER(tv_val);
#endif

			DUK_ASSERT(DUK_HSTRING_MAX_BYTELEN <= 0x7fffffffUL);  /* ensures no overflow */
			p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4 + DUK_HSTRING_GET_BYTELEN(key) + 4, p);
			p = duk__dump_hstring_raw(p, key);
			DUK_RAW_WRITE_U32_BE(p, val);
		}
	}
	p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4, p);
	DUK_RAW_WRITE_U32_BE(p, 0);  /* end of _Varmap */
	return p;
}

DUK_LOCAL duk_uint8_t *duk__dump_formals(duk_hthread *thr, duk_uint8_t *p, duk_bufwriter_ctx *bw_ctx, duk_hobject *func) {
	duk_tval *tv;

	tv = duk_hobject_find_existing_entry_tval_ptr(thr->heap, (duk_hobject *) func, DUK_HTHREAD_STRING_INT_FORMALS(thr));
	if (tv != NULL && DUK_TVAL_IS_OBJECT(tv)) {
		duk_hobject *h;
		duk_uint_fast32_t i;

		h = DUK_TVAL_GET_OBJECT(tv);
		DUK_ASSERT(h != NULL);

		/* We know _Formals is dense and all entries will be in the
		 * array part.  GC and finalizers shouldn't affect _Formals
		 * so side effects should be fine.
		 */
		for (i = 0; i < (duk_uint_fast32_t) DUK_HOBJECT_GET_ASIZE(h); i++) {
			duk_tval *tv_val;
			duk_hstring *varname;

			tv_val = DUK_HOBJECT_A_GET_VALUE_PTR(thr->heap, h, i);
			DUK_ASSERT(tv_val != NULL);
			if (DUK_TVAL_IS_STRING(tv_val)) {
				/* Array is dense and contains only strings, but ASIZE may
				 * be larger than used part and there are UNUSED entries.
				 */
				varname = DUK_TVAL_GET_STRING(tv_val);
				DUK_ASSERT(varname != NULL);

				DUK_ASSERT(DUK_HSTRING_MAX_BYTELEN <= 0x7fffffffUL);  /* ensures no overflow */
				p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4 + DUK_HSTRING_GET_BYTELEN(varname), p);
				p = duk__dump_hstring_raw(p, varname);
			}
		}
	}
	p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 4, p);
	DUK_RAW_WRITE_U32_BE(p, 0);  /* end of _Formals */
	return p;
}

static duk_uint8_t *duk__dump_func(duk_context *ctx, duk_hcompiledfunction *func, duk_bufwriter_ctx *bw_ctx, duk_uint8_t *p) {
	duk_hthread *thr;
	duk_tval *tv, *tv_end;
	duk_instr_t *ins, *ins_end;
	duk_hobject **fn, **fn_end;
	duk_hstring *h_str;
	duk_uint32_t count_instr;
	duk_uint32_t tmp32;
	duk_uint16_t tmp16;
	duk_double_t d;

	thr = (duk_hthread *) ctx;
	DUK_UNREF(ctx);
	DUK_UNREF(thr);

	DUK_DD(DUK_DDPRINT("dumping function %p to %p: "
	                   "consts=[%p,%p[ (%ld bytes, %ld items), "
	                   "funcs=[%p,%p[ (%ld bytes, %ld items), "
	                   "code=[%p,%p[ (%ld bytes, %ld items)",
	                   (void *) func,
	                   (void *) p,
	                   (void *) DUK_HCOMPILEDFUNCTION_GET_CONSTS_BASE(thr->heap, func),
	                   (void *) DUK_HCOMPILEDFUNCTION_GET_CONSTS_END(thr->heap, func),
	                   (long) DUK_HCOMPILEDFUNCTION_GET_CONSTS_SIZE(thr->heap, func),
	                   (long) DUK_HCOMPILEDFUNCTION_GET_CONSTS_COUNT(thr->heap, func),
	                   (void *) DUK_HCOMPILEDFUNCTION_GET_FUNCS_BASE(thr->heap, func),
	                   (void *) DUK_HCOMPILEDFUNCTION_GET_FUNCS_END(thr->heap, func),
	                   (long) DUK_HCOMPILEDFUNCTION_GET_FUNCS_SIZE(thr->heap, func),
	                   (long) DUK_HCOMPILEDFUNCTION_GET_FUNCS_COUNT(thr->heap, func),
	                   (void *) DUK_HCOMPILEDFUNCTION_GET_CODE_BASE(thr->heap, func),
	                   (void *) DUK_HCOMPILEDFUNCTION_GET_CODE_END(thr->heap, func),
	                   (long) DUK_HCOMPILEDFUNCTION_GET_CODE_SIZE(thr->heap, func),
	                   (long) DUK_HCOMPILEDFUNCTION_GET_CODE_COUNT(thr->heap, func)));

	DUK_ASSERT(DUK_USE_ESBC_MAX_BYTES <= 0x7fffffffUL);  /* ensures no overflow */
	count_instr = (duk_uint32_t) DUK_HCOMPILEDFUNCTION_GET_CODE_COUNT(thr->heap, func);
	p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 3 * 4 + 2 * 2 + 3 * 4 + count_instr * 4, p);

	/* Fixed header info. */
	tmp32 = count_instr;
	DUK_RAW_WRITE_U32_BE(p, tmp32);
	tmp32 = (duk_uint32_t) DUK_HCOMPILEDFUNCTION_GET_CONSTS_COUNT(thr->heap, func);
	DUK_RAW_WRITE_U32_BE(p, tmp32);
	tmp32 = (duk_uint32_t) DUK_HCOMPILEDFUNCTION_GET_FUNCS_COUNT(thr->heap, func);
	DUK_RAW_WRITE_U32_BE(p, tmp32);
	tmp16 = func->nregs;
	DUK_RAW_WRITE_U16_BE(p, tmp16);
	tmp16 = func->nargs;
	DUK_RAW_WRITE_U16_BE(p, tmp16);
#if defined(DUK_USE_DEBUGGER_SUPPORT)
	tmp32 = func->start_line;
	DUK_RAW_WRITE_U32_BE(p, tmp32);
	tmp32 = func->end_line;
	DUK_RAW_WRITE_U32_BE(p, tmp32);
#else
	DUK_RAW_WRITE_U32_BE(p, 0);
	DUK_RAW_WRITE_U32_BE(p, 0);
#endif
	tmp32 = ((duk_heaphdr *) func)->h_flags & DUK_HEAPHDR_FLAGS_FLAG_MASK;
	DUK_RAW_WRITE_U32_BE(p, tmp32);

	/* Bytecode instructions: endian conversion needed unless
	 * platform is big endian.
	 */
	ins = DUK_HCOMPILEDFUNCTION_GET_CODE_BASE(thr->heap, func);
	ins_end = DUK_HCOMPILEDFUNCTION_GET_CODE_END(thr->heap, func);
	DUK_ASSERT((duk_size_t) (ins_end - ins) == (duk_size_t) count_instr);
#if defined(DUK_USE_INTEGER_BE)
	DUK_MEMCPY((void *) p, (const void *) ins, (size_t) (ins_end - ins));
	p += (size_t) (ins_end - ins);
#else
	while (ins != ins_end) {
		tmp32 = (duk_uint32_t) (*ins);
		DUK_RAW_WRITE_U32_BE(p, tmp32);
		ins++;
	}
#endif

	/* Constants: variable size encoding. */
	tv = DUK_HCOMPILEDFUNCTION_GET_CONSTS_BASE(thr->heap, func);
	tv_end = DUK_HCOMPILEDFUNCTION_GET_CONSTS_END(thr->heap, func);
	while (tv != tv_end) {
		/* constants are strings or numbers now */
		DUK_ASSERT(DUK_TVAL_IS_STRING(tv) ||
		           DUK_TVAL_IS_NUMBER(tv));

		if (DUK_TVAL_IS_STRING(tv)) {
			h_str = DUK_TVAL_GET_STRING(tv);
			DUK_ASSERT(h_str != NULL);
			DUK_ASSERT(DUK_HSTRING_MAX_BYTELEN <= 0x7fffffffUL);  /* ensures no overflow */
			p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 1 + 4 + DUK_HSTRING_GET_BYTELEN(h_str), p),
			*p++ = DUK__SER_STRING;
			p = duk__dump_hstring_raw(p, h_str);
		} else {
			DUK_ASSERT(DUK_TVAL_IS_NUMBER(tv));
			p = DUK_BW_ENSURE_RAW(thr, bw_ctx, 1 + 8, p);
			*p++ = DUK__SER_NUMBER;
			d = DUK_TVAL_GET_NUMBER(tv);
			DUK_RAW_WRITE_DOUBLE_BE(p, d);
		}
		tv++;
	}

	/* Inner functions recursively. */
	fn = (duk_hobject **) DUK_HCOMPILEDFUNCTION_GET_FUNCS_BASE(thr->heap, func);
	fn_end = (duk_hobject **) DUK_HCOMPILEDFUNCTION_GET_FUNCS_END(thr->heap, func);
	while (fn != fn_end) {
		/* XXX: This causes recursion up to inner function depth
		 * which is normally not an issue, e.g. mark-and-sweep uses
		 * a recursion limiter to avoid C stack issues.  Avoiding
		 * this would mean some sort of a work list or just refusing
		 * to serialize deep functions.
		 */
		DUK_ASSERT(DUK_HOBJECT_IS_COMPILEDFUNCTION(*fn));
		p = duk__dump_func(ctx, (duk_hcompiledfunction *) *fn, bw_ctx, p);
		fn++;
	}

	/* Object extra properties.
	 *
	 * There are some difference between function templates and functions.
	 * For example, function templates don't have .length and nargs is
	 * normally used to instantiate the functions.
	 */

	p = duk__dump_uint32_prop(thr, p, bw_ctx, (duk_hobject *) func, DUK_STRIDX_LENGTH, (duk_uint32_t) func->nargs);
	p = duk__dump_string_prop(thr, p, bw_ctx, (duk_hobject *) func, DUK_STRIDX_NAME);
	p = duk__dump_string_prop(thr, p, bw_ctx, (duk_hobject *) func, DUK_STRIDX_FILE_NAME);
	p = duk__dump_buffer_prop(thr, p, bw_ctx, (duk_hobject *) func, DUK_STRIDX_INT_PC2LINE);
	p = duk__dump_varmap(thr, p, bw_ctx, (duk_hobject *) func);
	p = duk__dump_formals(thr, p, bw_ctx, (duk_hobject *) func);

	DUK_DD(DUK_DDPRINT("serialized function %p -> final pointer %p", (void *) func, (void *) p));

	return p;
}

/* Load a function from bytecode.  The function object returned here must
 * match what is created by duk_js_push_closure() with respect to its flags,
 * properties, etc.
 *
 * NOTE: there are intentionally no input buffer length / bound checks.
 * Adding them would be easy but wouldn't ensure memory safety as untrusted
 * or broken bytecode is unsafe during execution unless the opcodes themselves
 * are validated (which is quite complex, especially for indirect opcodes).
 */

#define DUK__ASSERT_LEFT(n) do { \
		DUK_ASSERT((duk_size_t) (p_end - p) >= (duk_size_t) (n)); \
	} while (0)

static duk_uint8_t *duk__load_func(duk_context *ctx, duk_uint8_t *p, duk_uint8_t *p_end) {
	duk_hthread *thr;
	duk_hcompiledfunction *h_fun;
	duk_hbuffer *h_data;
	duk_size_t data_size;
	duk_uint32_t count_instr, count_const, count_funcs;
	duk_uint32_t n;
	duk_uint32_t tmp32;
	duk_small_uint_t const_type;
	duk_uint8_t *fun_data;
	duk_uint8_t *q;
	duk_idx_t idx_base;
	duk_tval *tv1;
	duk_uarridx_t arr_idx;

	/* XXX: There's some overlap with duk_js_closure() here, but
	 * seems difficult to share code.  Ensure that the final function
	 * looks the same as created by duk_js_closure().
	 */

	DUK_ASSERT(ctx != NULL);
	thr = (duk_hthread *) ctx;

	DUK_DD(DUK_DDPRINT("loading function, p=%p, p_end=%p", (void *) p, (void *) p_end));

	DUK__ASSERT_LEFT(3 * 4);
	count_instr = DUK_RAW_READ_U32_BE(p);
	count_const = DUK_RAW_READ_U32_BE(p);
	count_funcs = DUK_RAW_READ_U32_BE(p);

	data_size = sizeof(duk_tval) * count_const +
	            sizeof(duk_hobject *) * count_funcs +
	            sizeof(duk_instr_t) * count_instr;

	DUK_DD(DUK_DDPRINT("instr=%ld, const=%ld, funcs=%ld, data_size=%ld",
	                   (long) count_instr, (long) count_const,
	                   (long) count_const, (long) data_size));

	/* Value stack is used to ensure reachability of constants and
	 * inner functions being loaded.  Require enough space to handle
	 * large functions correctly.
	 */
	duk_require_stack(ctx, 2 + count_const + count_funcs);
	idx_base = duk_get_top(ctx);

	/* Push function object, init flags etc.  This must match
	 * duk_js_push_closure() quite carefully.
	 */
	duk_push_compiledfunction(ctx);
	h_fun = duk_get_hcompiledfunction(ctx, -1);
	DUK_ASSERT(h_fun != NULL);
	DUK_ASSERT(DUK_HOBJECT_IS_COMPILEDFUNCTION((duk_hobject *) h_fun));
	DUK_ASSERT(DUK_HCOMPILEDFUNCTION_GET_DATA(thr->heap, h_fun) == NULL);
	DUK_ASSERT(DUK_HCOMPILEDFUNCTION_GET_FUNCS(thr->heap, h_fun) == NULL);
	DUK_ASSERT(DUK_HCOMPILEDFUNCTION_GET_BYTECODE(thr->heap, h_fun) == NULL);

	h_fun->nregs = DUK_RAW_READ_U16_BE(p);
	h_fun->nargs = DUK_RAW_READ_U16_BE(p);
#if defined(DUK_USE_DEBUGGER_SUPPORT)
	h_fun->start_line = DUK_RAW_READ_U32_BE(p);
	h_fun->end_line = DUK_RAW_READ_U32_BE(p);
#else
	p += 8;  /* skip line info */
#endif

	/* duk_hcompiledfunction flags; quite version specific */
	tmp32 = DUK_RAW_READ_U32_BE(p);
	DUK_HEAPHDR_SET_FLAGS((duk_heaphdr *) h_fun, tmp32);

	/* standard prototype */
	DUK_HOBJECT_SET_PROTOTYPE_UPDREF(thr, &h_fun->obj, thr->builtins[DUK_BIDX_FUNCTION_PROTOTYPE]);

	/* assert just a few critical flags */
	DUK_ASSERT(DUK_HEAPHDR_GET_TYPE((duk_heaphdr *) h_fun) == DUK_HTYPE_OBJECT);
	DUK_ASSERT(!DUK_HOBJECT_HAS_BOUND(&h_fun->obj));
	DUK_ASSERT(DUK_HOBJECT_HAS_COMPILEDFUNCTION(&h_fun->obj));
	DUK_ASSERT(!DUK_HOBJECT_HAS_NATIVEFUNCTION(&h_fun->obj));
	DUK_ASSERT(!DUK_HOBJECT_HAS_THREAD(&h_fun->obj));
	DUK_ASSERT(!DUK_HOBJECT_HAS_EXOTIC_ARRAY(&h_fun->obj));
	DUK_ASSERT(!DUK_HOBJECT_HAS_EXOTIC_STRINGOBJ(&h_fun->obj));
	DUK_ASSERT(!DUK_HOBJECT_HAS_EXOTIC_ARGUMENTS(&h_fun->obj));

	/* Create function 'data' buffer but don't attach it yet. */
	fun_data = (duk_uint8_t *) duk_push_fixed_buffer(ctx, data_size);
	DUK_ASSERT(fun_data != NULL);

	/* Load bytecode instructions. */
	DUK_ASSERT(sizeof(duk_instr_t) == 4);
	DUK__ASSERT_LEFT(count_instr * sizeof(duk_instr_t));
#if defined(DUK_USE_INTEGER_BE)
	q = fun_data + sizeof(duk_tval) * count_const + sizeof(duk_hobject *) * count_funcs;
	DUK_MEMCPY((void *) q,
	           (const void *) p,
	           sizeof(duk_instr_t) * count_instr);
	p += sizeof(duk_instr_t) * count_instr;
#else
	q = fun_data + sizeof(duk_tval) * count_const + sizeof(duk_hobject *) * count_funcs;
	for (n = count_instr; n > 0; n--) {
		*((duk_instr_t *) (void *) q) = DUK_RAW_READ_U32_BE(p);
		q += sizeof(duk_instr_t);
	}
#endif

	/* Load constants onto value stack but don't yet copy to buffer. */
	for (n = count_const; n > 0; n--) {
		DUK__ASSERT_LEFT(1);
		const_type = DUK_RAW_READ_U8(p);
		switch (const_type) {
		case DUK__SER_STRING: {
			p = duk__load_string_raw(ctx, p);
			break;
		}
		case DUK__SER_NUMBER: {
			/* Important to do a fastint check so that constants are
			 * properly read back as fastints.
			 */
			duk_tval tv_tmp;
			duk_double_t val;
			DUK__ASSERT_LEFT(8);
			val = DUK_RAW_READ_DOUBLE_BE(p);
			DUK_TVAL_SET_NUMBER_CHKFAST(&tv_tmp, val);
			duk_push_tval(ctx, &tv_tmp);
			break;
		}
		default: {
			goto format_error;
		}
		}
	}

	/* Load inner functions to value stack, but don't yet copy to buffer. */
	for (n = count_funcs; n > 0; n--) {
		p = duk__load_func(ctx, p, p_end);
		if (p == NULL) {
			goto format_error;
		}
	}

	/* With constants and inner functions on value stack, we can now
	 * atomically finish the function 'data' buffer, bump refcounts,
	 * etc.
	 *
	 * Here we take advantage of the value stack being just a duk_tval
	 * array: we can just memcpy() the constants as long as we incref
	 * them afterwards.
	 */

	h_data = (duk_hbuffer *) duk_get_hbuffer(ctx, idx_base + 1);
	DUK_ASSERT(h_data != NULL);
	DUK_ASSERT(!DUK_HBUFFER_HAS_DYNAMIC(h_data));
	DUK_HCOMPILEDFUNCTION_SET_DATA(thr->heap, h_fun, h_data);
	DUK_HBUFFER_INCREF(thr, h_data);

	tv1 = duk_get_tval(ctx, idx_base + 2);  /* may be NULL if no constants or inner funcs */
	DUK_ASSERT((count_const == 0 && count_funcs == 0) || tv1 != NULL);

	q = fun_data;
	if (count_const > 0) {
		/* Explicit zero size check to avoid NULL 'tv1'. */
		DUK_MEMCPY((void *) q, (const void *) tv1, sizeof(duk_tval) * count_const);
		for (n = count_const; n > 0; n--) {
			DUK_TVAL_INCREF_FAST(thr, (duk_tval *) (void *) q);  /* no side effects */
			q += sizeof(duk_tval);
		}
		tv1 += count_const;
	}

	DUK_HCOMPILEDFUNCTION_SET_FUNCS(thr->heap, h_fun, (duk_hobject **) (void *) q);
	for (n = count_funcs; n > 0; n--) {
		duk_hobject *h_obj;

		DUK_ASSERT(DUK_TVAL_IS_OBJECT(tv1));
		h_obj = DUK_TVAL_GET_OBJECT(tv1);
		DUK_ASSERT(h_obj != NULL);
		tv1++;
		DUK_HOBJECT_INCREF(thr, h_obj);

		*((duk_hobject **) (void *) q) = h_obj;
		q += sizeof(duk_hobject *);
	}

	DUK_HCOMPILEDFUNCTION_SET_BYTECODE(thr->heap, h_fun, (duk_instr_t *) (void *) q);

	/* The function object is now reachable and refcounts are fine,
	 * so we can pop off all the temporaries.
	 */
	DUK_DDD(DUK_DDDPRINT("function is reachable, reset top; func: %!iT", duk_get_tval(ctx, idx_base)));
	duk_set_top(ctx, idx_base + 1);

	/* Setup function properties. */
	tmp32 = DUK_RAW_READ_U32_BE(p);
	duk_push_u32(ctx, tmp32);
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_LENGTH, DUK_PROPDESC_FLAGS_NONE);

	p = duk__load_string_raw(ctx, p);
	if (DUK_HOBJECT_HAS_NAMEBINDING((duk_hobject *) h_fun)) {
		/* Original function instance/template had NAMEBINDING.
		 * Must create a lexical environment on loading to allow
		 * recursive functions like 'function foo() { foo(); }'.
		 */
		duk_hobject *proto;

		proto = thr->builtins[DUK_BIDX_GLOBAL_ENV];
		(void) duk_push_object_helper_proto(ctx,
		                                    DUK_HOBJECT_FLAG_EXTENSIBLE |
		                                    DUK_HOBJECT_CLASS_AS_FLAGS(DUK_HOBJECT_CLASS_DECENV),
		                                    proto);
		duk_dup(ctx, -2);                                 /* -> [ func funcname env funcname ] */
		duk_dup(ctx, idx_base);                           /* -> [ func funcname env funcname func ] */
		duk_xdef_prop(ctx, -3, DUK_PROPDESC_FLAGS_NONE);  /* -> [ func funcname env ] */
		duk_xdef_prop_stridx(ctx, idx_base, DUK_STRIDX_INT_LEXENV, DUK_PROPDESC_FLAGS_WC);
		/* since closure has NEWENV, never define DUK_STRIDX_INT_VARENV, as it
		 * will be ignored anyway
		 */
	}
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_NAME, DUK_PROPDESC_FLAGS_NONE);

	p = duk__load_string_raw(ctx, p);
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_FILE_NAME, DUK_PROPDESC_FLAGS_WC);

	duk_push_object(ctx);
	duk_dup(ctx, -2);
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_CONSTRUCTOR, DUK_PROPDESC_FLAGS_WC);  /* func.prototype.constructor = func */
	duk_compact(ctx, -1);
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_PROTOTYPE, DUK_PROPDESC_FLAGS_W);

	p = duk__load_buffer_raw(ctx, p);
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_INT_PC2LINE, DUK_PROPDESC_FLAGS_WC);

	duk_push_object(ctx);  /* _Varmap */
	for (;;) {
		/* XXX: awkward */
		p = duk__load_string_raw(ctx, p);
		if (duk_get_length(ctx, -1) == 0) {
			duk_pop(ctx);
			break;
		}
		tmp32 = DUK_RAW_READ_U32_BE(p);
		duk_push_u32(ctx, tmp32);
		duk_put_prop(ctx, -3);
	}
	duk_compact(ctx, -1);
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_INT_VARMAP, DUK_PROPDESC_FLAGS_NONE);

	duk_push_array(ctx);  /* _Formals */
	for (arr_idx = 0; ; arr_idx++) {
		/* XXX: awkward */
		p = duk__load_string_raw(ctx, p);
		if (duk_get_length(ctx, -1) == 0) {
			duk_pop(ctx);
			break;
		}
		duk_put_prop_index(ctx, -2, arr_idx);
	}
	duk_compact(ctx, -1);
	duk_xdef_prop_stridx(ctx, -2, DUK_STRIDX_INT_FORMALS, DUK_PROPDESC_FLAGS_NONE);

	/* Return with final function pushed on stack top. */
	DUK_DD(DUK_DDPRINT("final loaded function: %!iT", duk_get_tval(ctx, -1)));
	DUK_ASSERT_TOP(ctx, idx_base + 1);
	return p;

 format_error:
	return NULL;
}

DUK_EXTERNAL void duk_dump_function(duk_context *ctx) {
	duk_hthread *thr;
	duk_hcompiledfunction *func;
	duk_bufwriter_ctx bw_ctx_alloc;
	duk_bufwriter_ctx *bw_ctx = &bw_ctx_alloc;
	duk_uint8_t *p;

	DUK_ASSERT(ctx != NULL);
	thr = (duk_hthread *) ctx;

	/* Bound functions don't have all properties so we'd either need to
	 * lookup the non-bound target function or reject bound functions.
	 * For now, bound functions are rejected.
	 */
	func = duk_require_hcompiledfunction(ctx, -1);
	DUK_ASSERT(func != NULL);
	DUK_ASSERT(!DUK_HOBJECT_HAS_BOUND(&func->obj));

	/* Estimating the result size beforehand would be costly, so
	 * start with a reasonable size and extend as needed.
	 */
	DUK_BW_INIT_PUSHBUF(thr, bw_ctx, DUK__BYTECODE_INITIAL_ALLOC);
	p = DUK_BW_GET_PTR(thr, bw_ctx);
	*p++ = DUK__SER_MARKER;
	*p++ = DUK__SER_VERSION;
	p = duk__dump_func(ctx, func, bw_ctx, p);
	DUK_BW_SET_PTR(thr, bw_ctx, p);
	DUK_BW_COMPACT(thr, bw_ctx);

	DUK_DD(DUK_DDPRINT("serialized result: %!T", duk_get_tval(ctx, -1)));

	duk_remove(ctx, -2);  /* [ ... func buf ] -> [ ... buf ] */
}

DUK_EXTERNAL void duk_load_function(duk_context *ctx) {
	duk_hthread *thr;
	duk_uint8_t *p_buf, *p, *p_end;
	duk_size_t sz;

	DUK_ASSERT(ctx != NULL);
	thr = (duk_hthread *) ctx;
	DUK_UNREF(ctx);

	p_buf = (duk_uint8_t *) duk_require_buffer(ctx, -1, &sz);
	DUK_ASSERT(p_buf != NULL);

	/* The caller is responsible for being sure that bytecode being loaded
	 * is valid and trusted.  Invalid bytecode can cause memory unsafe
	 * behavior directly during loading or later during bytecode execution
	 * (instruction validation would be quite complex to implement).
	 *
	 * This signature check is the only sanity check for detecting
	 * accidental invalid inputs.  The initial 0xFF byte ensures no
	 * ordinary string will be accepted by accident.
	 */
	p = p_buf;
	p_end = p_buf + sz;
	if (sz < 2 || p[0] != DUK__SER_MARKER || p[1] != DUK__SER_VERSION) {
		goto format_error;
	}
	p += 2;

	p = duk__load_func(ctx, p, p_end);
	if (p == NULL) {
		goto format_error;
	}

	duk_remove(ctx, -2);  /* [ ... buf func ] -> [ ... func ] */
	return;

 format_error:
	DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_DECODE_FAILED);
}

#undef DUK__SER_MARKER
#undef DUK__SER_VERSION
#undef DUK__SER_STRING
#undef DUK__SER_NUMBER
#undef DUK__BYTECODE_INITIAL_ALLOC

#else  /* DUK_USE_BYTECODE_DUMP_SUPPORT */

DUK_EXTERNAL void duk_dump_function(duk_context *ctx) {
	DUK_ERROR((duk_hthread *) ctx, DUK_ERR_ERROR, DUK_STR_UNSUPPORTED);
}

DUK_EXTERNAL void duk_load_function(duk_context *ctx) {
	DUK_ERROR((duk_hthread *) ctx, DUK_ERR_ERROR, DUK_STR_UNSUPPORTED);
}

#endif  /* DUK_USE_BYTECODE_DUMP_SUPPORT */
#line 1 "duk_api_call.c"
/*
 *  Calls.
 *
 *  Protected variants should avoid ever throwing an error.
 */

/* include removed: duk_internal.h */

/* Prepare value stack for a method call through an object property.
 * May currently throw an error e.g. when getting the property.
 */
DUK_LOCAL void duk__call_prop_prep_stack(duk_context *ctx, duk_idx_t normalized_obj_index, duk_idx_t nargs) {
	DUK_ASSERT_CTX_VALID(ctx);

	DUK_DDD(DUK_DDDPRINT("duk__call_prop_prep_stack, normalized_obj_index=%ld, nargs=%ld, stacktop=%ld",
	                     (long) normalized_obj_index, (long) nargs, (long) duk_get_top(ctx)));

	/* [... key arg1 ... argN] */

	/* duplicate key */
	duk_dup(ctx, -nargs - 1);  /* Note: -nargs alone would fail for nargs == 0, this is OK */
	duk_get_prop(ctx, normalized_obj_index);

	DUK_DDD(DUK_DDDPRINT("func: %!T", (duk_tval *) duk_get_tval(ctx, -1)));

	/* [... key arg1 ... argN func] */

	duk_replace(ctx, -nargs - 2);

	/* [... func arg1 ... argN] */

	duk_dup(ctx, normalized_obj_index);
	duk_insert(ctx, -nargs - 1);

	/* [... func this arg1 ... argN] */
}

DUK_EXTERNAL void duk_call(duk_context *ctx, duk_idx_t nargs) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_small_uint_t call_flags;
	duk_idx_t idx_func;

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);

	idx_func = duk_get_top(ctx) - nargs - 1;
	if (idx_func < 0 || nargs < 0) {
		/* note that we can't reliably pop anything here */
		DUK_ERROR(thr, DUK_ERR_API_ERROR, DUK_STR_INVALID_CALL_ARGS);
	}

	/* XXX: awkward; we assume there is space for this, overwrite
	 * directly instead?
	 */
	duk_push_undefined(ctx);
	duk_insert(ctx, idx_func + 1);

	call_flags = 0;  /* not protected, respect reclimit, not constructor */

	duk_handle_call_unprotected(thr,           /* thread */
	                            nargs,         /* num_stack_args */
	                            call_flags);   /* call_flags */
}

DUK_EXTERNAL void duk_call_method(duk_context *ctx, duk_idx_t nargs) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_small_uint_t call_flags;
	duk_idx_t idx_func;

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);

	idx_func = duk_get_top(ctx) - nargs - 2;  /* must work for nargs <= 0 */
	if (idx_func < 0 || nargs < 0) {
		/* note that we can't reliably pop anything here */
		DUK_ERROR(thr, DUK_ERR_API_ERROR, DUK_STR_INVALID_CALL_ARGS);
	}

	call_flags = 0;  /* not protected, respect reclimit, not constructor */

	duk_handle_call_unprotected(thr,           /* thread */
	                            nargs,         /* num_stack_args */
	                            call_flags);   /* call_flags */
}

DUK_EXTERNAL void duk_call_prop(duk_context *ctx, duk_idx_t obj_index, duk_idx_t nargs) {
	/*
	 *  XXX: if duk_handle_call() took values through indices, this could be
	 *  made much more sensible.  However, duk_handle_call() needs to fudge
	 *  the 'this' and 'func' values to handle bound function chains, which
	 *  is now done "in-place", so this is not a trivial change.
	 */

	DUK_ASSERT_CTX_VALID(ctx);

	obj_index = duk_require_normalize_index(ctx, obj_index);  /* make absolute */

	duk__call_prop_prep_stack(ctx, obj_index, nargs);

	duk_call_method(ctx, nargs);
}

DUK_EXTERNAL duk_int_t duk_pcall(duk_context *ctx, duk_idx_t nargs) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_small_uint_t call_flags;
	duk_idx_t idx_func;
	duk_int_t rc;

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);

	idx_func = duk_get_top(ctx) - nargs - 1;  /* must work for nargs <= 0 */
	if (idx_func < 0 || nargs < 0) {
		/* We can't reliably pop anything here because the stack input
		 * shape is incorrect.  So we throw an error; if the caller has
		 * no catch point for this, a fatal error will occur.  Another
		 * alternative would be to just return an error.  But then the
		 * stack would be in an unknown state which might cause some
		 * very hard to diagnose problems later on.  Also note that even
		 * if we did not throw an error here, the underlying call handler
		 * might STILL throw an out-of-memory error or some other internal
		 * fatal error.
		 */
		DUK_ERROR(thr, DUK_ERR_API_ERROR, DUK_STR_INVALID_CALL_ARGS);
		return DUK_EXEC_ERROR;  /* unreachable */
	}

	/* awkward; we assume there is space for this */
	duk_push_undefined(ctx);
	duk_insert(ctx, idx_func + 1);

	call_flags = 0;  /* respect reclimit, not constructor */

	rc = duk_handle_call_protected(thr,           /* thread */
	                               nargs,         /* num_stack_args */
	                               call_flags);   /* call_flags */

	return rc;
}

DUK_EXTERNAL duk_int_t duk_pcall_method(duk_context *ctx, duk_idx_t nargs) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_small_uint_t call_flags;
	duk_idx_t idx_func;
	duk_int_t rc;

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);

	idx_func = duk_get_top(ctx) - nargs - 2;  /* must work for nargs <= 0 */
	if (idx_func < 0 || nargs < 0) {
		/* See comments in duk_pcall(). */
		DUK_ERROR(thr, DUK_ERR_API_ERROR, DUK_STR_INVALID_CALL_ARGS);
		return DUK_EXEC_ERROR;  /* unreachable */
	}

	call_flags = 0;  /* respect reclimit, not constructor */

	rc = duk_handle_call_protected(thr,           /* thread */
	                               nargs,         /* num_stack_args */
	                               call_flags);   /* call_flags */

	return rc;
}

DUK_LOCAL duk_ret_t duk__pcall_prop_raw(duk_context *ctx) {
	duk_idx_t obj_index;
	duk_idx_t nargs;

	/* Get the original arguments.  Note that obj_index may be a relative
	 * index so the stack must have the same top when we use it.
	 */

	DUK_ASSERT_CTX_VALID(ctx);

	obj_index = (duk_idx_t) duk_get_int(ctx, -2);
	nargs = (duk_idx_t) duk_get_int(ctx, -1);
	duk_pop_2(ctx);

	obj_index = duk_require_normalize_index(ctx, obj_index);  /* make absolute */
	duk__call_prop_prep_stack(ctx, obj_index, nargs);
	duk_call_method(ctx, nargs);
	return 1;
}

DUK_EXTERNAL duk_int_t duk_pcall_prop(duk_context *ctx, duk_idx_t obj_index, duk_idx_t nargs) {
	/*
	 *  Must be careful to catch errors related to value stack manipulation
	 *  and property lookup, not just the call itself.
	 */

	DUK_ASSERT_CTX_VALID(ctx);

	duk_push_idx(ctx, obj_index);
	duk_push_idx(ctx, nargs);

	/* Inputs: explicit arguments (nargs), +1 for key, +2 for obj_index/nargs passing.
	 * If the value stack does not contain enough args, an error is thrown; this matches
	 * behavior of the other protected call API functions.
	 */
	return duk_safe_call(ctx, duk__pcall_prop_raw, nargs + 1 + 2 /*nargs*/, 1 /*nrets*/);
}

DUK_EXTERNAL duk_int_t duk_safe_call(duk_context *ctx, duk_safe_call_function func, duk_idx_t nargs, duk_idx_t nrets) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_int_t rc;

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);

	if (duk_get_top(ctx) < nargs || nrets < 0) {
		/* See comments in duk_pcall(). */
		DUK_ERROR(thr, DUK_ERR_API_ERROR, DUK_STR_INVALID_CALL_ARGS);
		return DUK_EXEC_ERROR;  /* unreachable */
	}

	rc = duk_handle_safe_call(thr,           /* thread */
	                          func,          /* func */
	                          nargs,         /* num_stack_args */
	                          nrets);        /* num_stack_res */

	return rc;
}

DUK_EXTERNAL void duk_new(duk_context *ctx, duk_idx_t nargs) {
	/*
	 *  There are two [[Construct]] operations in the specification:
	 *
	 *    - E5 Section 13.2.2: for Function objects
	 *    - E5 Section 15.3.4.5.2: for "bound" Function objects
	 *
	 *  The chain of bound functions is resolved in Section 15.3.4.5.2,
	 *  with arguments "piling up" until the [[Construct]] internal
	 *  method is called on the final, actual Function object.  Note
	 *  that the "prototype" property is looked up *only* from the
	 *  final object, *before* calling the constructor.
	 *
	 *  Currently we follow the bound function chain here to get the
	 *  "prototype" property value from the final, non-bound function.
	 *  However, we let duk_handle_call() handle the argument "piling"
	 *  when the constructor is called.  The bound function chain is
	 *  thus now processed twice.
	 *
	 *  When constructing new Array instances, an unnecessary object is
	 *  created and discarded now: the standard [[Construct]] creates an
	 *  object, and calls the Array constructor.  The Array constructor
	 *  returns an Array instance, which is used as the result value for
	 *  the "new" operation; the object created before the Array constructor
	 *  call is discarded.
	 *
	 *  This would be easy to fix, e.g. by knowing that the Array constructor
	 *  will always create a replacement object and skip creating the fallback
	 *  object in that case.
	 *
	 *  Note: functions called via "new" need to know they are called as a
	 *  constructor.  For instance, built-in constructors behave differently
	 *  depending on how they are called.
	 */

	/* XXX: merge this with duk_js_call.c, as this function implements
	 * core semantics (or perhaps merge the two files altogether).
	 */

	duk_hthread *thr = (duk_hthread *) ctx;
	duk_hobject *proto;
	duk_hobject *cons;
	duk_hobject *fallback;
	duk_idx_t idx_cons;
	duk_small_uint_t call_flags;

	DUK_ASSERT_CTX_VALID(ctx);

	/* [... constructor arg1 ... argN] */

	idx_cons = duk_require_normalize_index(ctx, -nargs - 1);

	DUK_DDD(DUK_DDDPRINT("top=%ld, nargs=%ld, idx_cons=%ld",
	                     (long) duk_get_top(ctx), (long) nargs, (long) idx_cons));

	/* XXX: code duplication */

	/*
	 *  Figure out the final, non-bound constructor, to get "prototype"
	 *  property.
	 */

	duk_dup(ctx, idx_cons);
	for (;;) {
		cons = duk_get_hobject(ctx, -1);
		if (cons == NULL || !DUK_HOBJECT_HAS_CONSTRUCTABLE(cons)) {
			/* Checking constructability from anything else than the
			 * initial constructor is not strictly necessary, but a
			 * nice sanity check.
			 */
			goto not_constructable;
		}
		if (!DUK_HOBJECT_HAS_BOUND(cons)) {
			break;
		}
		duk_get_prop_stridx(ctx, -1, DUK_STRIDX_INT_TARGET);  /* -> [... cons target] */
		duk_remove(ctx, -2);                                  /* -> [... target] */
	}
	DUK_ASSERT(cons != NULL && !DUK_HOBJECT_HAS_BOUND(cons));

	/* [... constructor arg1 ... argN final_cons] */

	/*
	 *  Create "fallback" object to be used as the object instance,
	 *  unless the constructor returns a replacement value.
	 *  Its internal prototype needs to be set based on "prototype"
	 *  property of the constructor.
	 */

	duk_push_object(ctx);  /* class Object, extensible */

	/* [... constructor arg1 ... argN final_cons fallback] */

	duk_get_prop_stridx(ctx, -2, DUK_STRIDX_PROTOTYPE);
	proto = duk_get_hobject(ctx, -1);
	if (!proto) {
		DUK_DDD(DUK_DDDPRINT("constructor has no 'prototype' property, or value not an object "
		                     "-> leave standard Object prototype as fallback prototype"));
	} else {
		DUK_DDD(DUK_DDDPRINT("constructor has 'prototype' property with object value "
		                     "-> set fallback prototype to that value: %!iO", (duk_heaphdr *) proto));
		fallback = duk_get_hobject(ctx, -2);
		DUK_ASSERT(fallback != NULL);
		DUK_HOBJECT_SET_PROTOTYPE_UPDREF(thr, fallback, proto);
	}
	duk_pop(ctx);

	/* [... constructor arg1 ... argN final_cons fallback] */

	/*
	 *  Manipulate callstack for the call.
	 */

	duk_dup_top(ctx);
	duk_insert(ctx, idx_cons + 1);  /* use fallback as 'this' value */
	duk_insert(ctx, idx_cons);      /* also stash it before constructor,
	                                 * in case we need it (as the fallback value)
	                                 */
	duk_pop(ctx);                   /* pop final_cons */


	/* [... fallback constructor fallback(this) arg1 ... argN];
	 * Note: idx_cons points to first 'fallback', not 'constructor'.
	 */

	DUK_DDD(DUK_DDDPRINT("before call, idx_cons+1 (constructor) -> %!T, idx_cons+2 (fallback/this) -> %!T, "
	                     "nargs=%ld, top=%ld",
	                     (duk_tval *) duk_get_tval(ctx, idx_cons + 1),
	                     (duk_tval *) duk_get_tval(ctx, idx_cons + 2),
	                     (long) nargs,
	                     (long) duk_get_top(ctx)));

	/*
	 *  Call the constructor function (called in "constructor mode").
	 */

	call_flags = DUK_CALL_FLAG_CONSTRUCTOR_CALL;  /* not protected, respect reclimit, is a constructor call */

	duk_handle_call_unprotected(thr,           /* thread */
	                            nargs,         /* num_stack_args */
	                            call_flags);   /* call_flags */

	/* [... fallback retval] */

	DUK_DDD(DUK_DDDPRINT("constructor call finished, fallback=%!iT, retval=%!iT",
	                     (duk_tval *) duk_get_tval(ctx, -2),
	                     (duk_tval *) duk_get_tval(ctx, -1)));

	/*
	 *  Determine whether to use the constructor return value as the created
	 *  object instance or not.
	 */

	if (duk_is_object(ctx, -1)) {
		duk_remove(ctx, -2);
	} else {
		duk_pop(ctx);
	}

	/*
	 *  Augment created errors upon creation (not when they are thrown or
	 *  rethrown).  __FILE__ and __LINE__ are not desirable here; the call
	 *  stack reflects the caller which is correct.
	 */

#ifdef DUK_USE_AUGMENT_ERROR_CREATE
	duk_hthread_sync_currpc(thr);
	duk_err_augment_error_create(thr, thr, NULL, 0, 1 /*noblame_fileline*/);
#endif

	/* [... retval] */

	return;

 not_constructable:
	DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_NOT_CONSTRUCTABLE);
}

DUK_LOCAL duk_ret_t duk__pnew_helper(duk_context *ctx) {
	duk_uint_t nargs;

	nargs = duk_to_uint(ctx, -1);
	duk_pop(ctx);

	duk_new(ctx, nargs);
	return 1;
}

DUK_EXTERNAL duk_int_t duk_pnew(duk_context *ctx, duk_idx_t nargs) {
	duk_int_t rc;

	DUK_ASSERT_CTX_VALID(ctx);

	/* For now, just use duk_safe_call() to wrap duk_new().  We can't
	 * simply use a protected duk_handle_call() because there's post
	 * processing which might throw.  It should be possible to ensure
	 * the post processing never throws (except in internal errors and
	 * out of memory etc which are always allowed) and then remove this
	 * wrapper.
	 */

	duk_push_uint(ctx, nargs);
	rc = duk_safe_call(ctx, duk__pnew_helper, nargs + 2 /*nargs*/, 1 /*nrets*/);
	return rc;
}

DUK_EXTERNAL duk_bool_t duk_is_constructor_call(duk_context *ctx) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_activation *act;

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);
	DUK_ASSERT_DISABLE(thr->callstack_top >= 0);

	act = duk_hthread_get_current_activation(thr);
	DUK_ASSERT(act != NULL);  /* because callstack_top > 0 */
	return ((act->flags & DUK_ACT_FLAG_CONSTRUCT) != 0 ? 1 : 0);
}

DUK_EXTERNAL duk_bool_t duk_is_strict_call(duk_context *ctx) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_activation *act;

	/* For user code this could just return 1 (strict) always
	 * because all Duktape/C functions are considered strict,
	 * and strict is also the default when nothing is running.
	 * However, Duktape may call this function internally when
	 * the current activation is an Ecmascript function, so
	 * this cannot be replaced by a 'return 1' without fixing
	 * the internal call sites.
	 */

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);
	DUK_ASSERT_DISABLE(thr->callstack_top >= 0);

	act = duk_hthread_get_current_activation(thr);
	if (act == NULL) {
		/* Strict by default. */
		return 1;
	}
	return ((act->flags & DUK_ACT_FLAG_STRICT) != 0 ? 1 : 0);
}

/*
 *  Duktape/C function magic
 */

DUK_EXTERNAL duk_int_t duk_get_current_magic(duk_context *ctx) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_activation *act;
	duk_hobject *func;

	DUK_ASSERT_CTX_VALID(ctx);
	DUK_ASSERT(thr != NULL);
	DUK_ASSERT_DISABLE(thr->callstack_top >= 0);

	act = duk_hthread_get_current_activation(thr);
	if (act) {
		func = DUK_ACT_GET_FUNC(act);
		if (!func) {
			duk_tval *tv = &act->tv_func;
			duk_small_uint_t lf_flags;
			lf_flags = DUK_TVAL_GET_LIGHTFUNC_FLAGS(tv);
			return (duk_int_t) DUK_LFUNC_FLAGS_GET_MAGIC(lf_flags);
		}
		DUK_ASSERT(func != NULL);

		if (DUK_HOBJECT_IS_NATIVEFUNCTION(func)) {
			duk_hnativefunction *nf = (duk_hnativefunction *) func;
			return (duk_int_t) nf->magic;
		}
	}
	return 0;
}

DUK_EXTERNAL duk_int_t duk_get_magic(duk_context *ctx, duk_idx_t index) {
	duk_hthread *thr = (duk_hthread *) ctx;
	duk_tval *tv;
	duk_hobject *h;

	DUK_ASSERT_CTX_VALID(ctx);

	tv = duk_require_tval(ctx, index);
	if (DUK_TVAL_IS_OBJECT(tv)) {
		h = DUK_TVAL_GET_OBJECT(tv);
		DUK_ASSERT(h != NULL);
		if (!DUK_HOBJECT_HAS_NATIVEFUNCTION(h)) {
			goto type_error;
		}
		return (duk_int_t) ((duk_hnativefunction *) h)->magic;
	} else if (DUK_TVAL_IS_LIGHTFUNC(tv)) {
		duk_small_uint_t lf_flags = DUK_TVAL_GET_LIGHTFUNC_FLAGS(tv);
		return (duk_int_t) DUK_LFUNC_FLAGS_GET_MAGIC(lf_flags);
	}

	/* fall through */
 type_error:
	DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_UNEXPECTED_TYPE);
	return 0;
}

DUK_EXTERNAL void duk_set_magic(duk_context *ctx, duk_idx_t index, duk_int_t magic) {
	duk_hnativefunction *nf;

	DUK_ASSERT_CTX_VALID(ctx);

	nf = duk_require_hnativefunction(ctx, index);
	DUK_ASSERT(nf != NULL);
	nf->magic = (duk_int16_t) magic;
}
#line 1 "duk_api_codec.c"
/*
 *  Encoding and decoding basic formats: hex, base64.
 *
 *  These are in-place operations which may allow an optimized implementation.
 *
 *  Base-64: https://tools.ietf.org/html/rfc4648#section-4
 */

/* include removed: duk_internal.h */

/* Shared handling for encode/decode argument.  Fast path handling for
 * buffer and string values because they're the most common.  In particular,
 * avoid creating a temporary string or buffer when possible.
 */
DUK_LOCAL const duk_uint8_t *duk__prep_codec_arg(duk_context *ctx, duk_idx_t index, duk_size_t *out_len) {
	DUK_ASSERT(duk_is_valid_index(ctx, index));  /* checked by caller */
	if (duk_is_buffer(ctx, index)) {
		return (const duk_uint8_t *) duk_get_buffer(ctx, index, out_len);
	} else {
		return (const duk_uint8_t *) duk_to_lstring(ctx, index, out_len);
	}
}

#if defined(DUK_USE_BASE64_FASTPATH)
DUK_LOCAL void duk__base64_encode_helper(const duk_uint8_t *src, duk_size_t srclen, duk_uint8_t *dst) {
	duk_uint_t t;
	duk_size_t n_full, n_full3, n_final;
	const duk_uint8_t *src_end_fast;

	n_full = srclen / 3;  /* full 3-byte -> 4-char conversions */
	n_full3 = n_full * 3;
	n_final = srclen - n_full3;
	DUK_ASSERT_DISABLE(n_final >= 0);
	DUK_ASSERT(n_final <= 2);

	src_end_fast = src + n_full3;
	while (DUK_UNLIKELY(src != src_end_fast)) {
		t = (duk_uint_t) (*src++);
		t = (t << 8) + (duk_uint_t) (*src++);
		t = (t << 8) + (duk_uint_t) (*src++);

		*dst++ = duk_base64_enctab[t >> 18];
		*dst++ = duk_base64_enctab[(t >> 12) & 0x3f];
		*dst++ = duk_base64_enctab[(t >> 6) & 0x3f];
		*dst++ = duk_base64_enctab[t & 0x3f];

#if 0  /* Tested: not faster on x64 */
		/* aaaaaabb bbbbcccc ccdddddd */
		dst[0] = duk_base64_enctab[(src[0] >> 2) & 0x3f];
		dst[1] = duk_base64_enctab[((src[0] << 4) & 0x30) | ((src[1] >> 4) & 0x0f)];
		dst[2] = duk_base64_enctab[((src[1] << 2) & 0x3f) | ((src[2] >> 6) & 0x03)];
		dst[3] = duk_base64_enctab[src[2] & 0x3f];
		src += 3; dst += 4;
#endif
	}

	switch (n_final) {
	/* case 0: nop */
	case 1: {
		/* XX== */
		t = (duk_uint_t) (*src++);
		*dst++ = duk_base64_enctab[t >> 2];           /* XXXXXX-- */
		*dst++ = duk_base64_enctab[(t << 4) & 0x3f];  /* ------XX */
		*dst++ = DUK_ASC_EQUALS;
		*dst++ = DUK_ASC_EQUALS;
		break;
	}
	case 2: {
		/* XXX= */
		t = (duk_uint_t) (*src++);
		t = (t << 8) + (duk_uint_t) (*src++);
		*dst++ = duk_base64_enctab[t >> 10];          /* XXXXXX-- -------- */
		*dst++ = duk_base64_enctab[(t >> 4) & 0x3f];  /* ------XX XXXX---- */
		*dst++ = duk_base64_enctab[(t << 2) & 0x3f];  /* -------- ----XXXX */
		*dst++ = DUK_ASC_EQUALS;
		break;
	}
	}
}
#else  /* DUK_USE_BASE64_FASTPATH */
DUK_LOCAL void duk__base64_encode_helper(const duk_uint8_t *src, duk_size_t srclen, duk_uint8_t *dst) {
	duk_small_uint_t i, snip;
	duk_uint_t t;
	duk_uint_fast8_t x, y;
	const duk_uint8_t *src_end;

	src_end = src + srclen;

	while (src < src_end) {
		/* read 3 bytes into 't', padded by zero */
		snip = 4;
		t = 0;
		for (i = 0; i < 3; i++) {
			t = t << 8;
			if (src >= src_end) {
				snip--;
			} else {
				t += (duk_uint_t) (*src++);
			}
		}

		/*
		 *  Missing bytes    snip     base64 example
		 *    0               4         XXXX
		 *    1               3         XXX=
		 *    2               2         XX==
		 */

		DUK_ASSERT(snip >= 2 && snip <= 4);

		for (i = 0; i < 4; i++) {
			x = (duk_uint_fast8_t) ((t >> 18) & 0x3f);
			t = t << 6;

			/* A straightforward 64-byte lookup would be faster
			 * and cleaner, but this is shorter.
			 */
			if (i >= snip) {
				y = '=';
			} else if (x <= 25) {
				y = x + 'A';
			} else if (x <= 51) {
				y = x - 26 + 'a';
			} else if (x <= 61) {
				y = x - 52 + '0';
			} else if (x == 62) {
				y = '+';
			} else {
				y = '/';
			}

			*dst++ = (duk_uint8_t) y;
		}
	}
}
#endif  /* DUK_USE_BASE64_FASTPATH */

#if defined(DUK_USE_BASE64_FASTPATH)
DUK_LOCAL duk_bool_t duk__base64_decode_helper(const duk_uint8_t *src, duk_size_t srclen, duk_uint8_t *dst, duk_uint8_t **out_dst_final) {
	duk_int_t x;
	duk_int_t t;
	duk_small_uint_t n_equal;
	duk_small_uint_t n_chars;
	const duk_uint8_t *src_end;
	const duk_uint8_t *src_end_safe;

	src_end = src + srclen;
	src_end_safe = src_end - 4;  /* if 'src < src_end_safe', safe to read 4 bytes */

	/* Innermost fast path processes 4 valid base-64 characters at a time
	 * but bails out on whitespace, padding chars ('=') and invalid chars.
	 * Once the slow path segment has been processed, we return to the
	 * inner fast path again.  This handles e.g. base64 with newlines
	 * reasonably well because the majority of a line is in the fast path.
	 */
	for (;;) {
		/* Fast path, handle units with just actual encoding characters. */

		while (src <= src_end_safe) {
			/* The lookup byte is intentionally sign extended to (at least)
			 * 32 bits and then ORed.  This ensures that is at least 1 byte
			 * is negative, the highest bit of 't' will be set at the end
			 * and we don't need to check every byte.
			 */
			DUK_DDD(DUK_DDDPRINT("fast loop: src=%p, src_end_safe=%p, src_end=%p",
			                     (const void *) src, (const void *) src_end_safe, (const void *) src_end));

			t = (duk_int_t) duk_base64_dectab[*src++];
			t = (t << 6) | (duk_int_t) duk_base64_dectab[*src++];
			t = (t << 6) | (duk_int_t) duk_base64_dectab[*src++];
			t = (t << 6) | (duk_int_t) duk_base64_dectab[*src++];

			if (DUK_UNLIKELY(t < 0)) {
				DUK_DDD(DUK_DDDPRINT("fast loop unit was not clean, process one slow path unit"));
				src -= 4;
				break;
			}

			DUK_ASSERT(t <= 0xffffffL);
			DUK_ASSERT((t >> 24) == 0);
			*dst++ = (duk_uint8_t) (t >> 16);
			*dst++ = (duk_uint8_t) ((t >> 8) & 0xff);
			*dst++ = (duk_uint8_t) (t & 0xff);
		}

		/* Handle one slow path unit (or finish if we're done). */

		n_equal = 0;
		n_chars = 0;
		t = 0;
		for (;;) {
			DUK_DDD(DUK_DDDPRINT("slow loop: src=%p, src_end=%p, n_chars=%ld, n_equal=%ld, t=%ld",
			                     (const void *) src, (const void *) src_end, (long) n_chars, (long) n_equal, (long) t));

			if (DUK_UNLIKELY(src >= src_end)) {
				goto done;  /* two level break */
			}

			x = duk_base64_dectab[*src++];
			if (DUK_UNLIKELY(x < 0)) {
				if (x == -2) {
					continue;  /* allowed ascii whitespace */
				} else if (x == -3) {
					n_equal++;
					t <<= 6;
				} else {
					DUK_ASSERT(x == -1);
					goto error;
				}
			} else {
				DUK_ASSERT(x >= 0 && x <= 63);
				if (n_equal > 0) {
					/* Don't allow actual chars after equal sign. */
					goto error;
				}
				t = (t << 6) + x;
			}

			if (DUK_UNLIKELY(n_chars == 3)) {
				/* Emit 3 bytes and backtrack if there was padding.  There's
				 * always space for the whole 3 bytes so no check needed.
				 */
				DUK_ASSERT(t <= 0xffffffL);
				DUK_ASSERT((t >> 24) == 0);
				*dst++ = (duk_uint8_t) (t >> 16);
				*dst++ = (duk_uint8_t) ((t >> 8) & 0xff);
				*dst++ = (duk_uint8_t) (t & 0xff);

				if (DUK_UNLIKELY(n_equal > 0)) {
					DUK_ASSERT(n_equal <= 4);

					/* There may be whitespace between the equal signs. */
					if (n_equal == 1) {
						/* XXX= */
						dst -= 1;
					} else if (n_equal == 2) {
						/* XX== */
						dst -= 2;
					} else {
						goto error;  /* invalid padding */
					}

					/* Continue parsing after padding, allows concatenated,
					 * padded base64.
					 */
				}
				break;  /* back to fast loop */
			} else {
				n_chars++;
			}
		}
	}
 done:
	DUK_DDD(DUK_DDDPRINT("done; src=%p, src_end=%p, n_chars=%ld",
	                     (const void *) src, (const void *) src_end, (long) n_chars));

	DUK_ASSERT(src == src_end);

	if (n_chars != 0) {
		/* Here we'd have the option of decoding unpadded base64
		 * (e.g. "xxxxyy" instead of "xxxxyy==".  Currently not
		 * accepted.
		 */
		goto error;
	}

	*out_dst_final = dst;
	return 1;

 error:
	return 0;
}
#else  /* DUK_USE_BASE64_FASTPATH */
DUK_LOCAL duk_bool_t duk__base64_decode_helper(const duk_uint8_t *src, duk_size_t srclen, duk_uint8_t *dst, duk_uint8_t **out_dst_final) {
	duk_uint_t t;
	duk_uint_fast8_t x, y;
	duk_small_uint_t group_idx;
	duk_small_uint_t n_equal;
	const duk_uint8_t *src_end;

	src_end = src + srclen;
	t = 0;
	group_idx = 0;
	n_equal = 0;

	while (src < src_end) {
		x = *src++;

		if (x >= 'A' && x <= 'Z') {
			y = x - 'A' + 0;
		} else if (x >= 'a' && x <= 'z') {
			y = x - 'a' + 26;
		} else if (x >= '0' && x <= '9') {
			y = x - '0' + 52;
		} else if (x == '+') {
			y = 62;
		} else if (x == '/') {
			y = 63;
		} else if (x == '=') {
			/* We don't check the zero padding bytes here right now
			 * (that they're actually zero).  This seems to be common
			 * behavior for base-64 decoders.
			 */

			n_equal++;
			t <<= 6;  /* shift in zeroes */
			goto skip_add;
		} else if (x == 0x09 || x == 0x0a || x == 0x0d || x == 0x20) {
			/* allow basic ASCII whitespace */
			continue;
		} else {
			goto error;
		}

		if (n_equal > 0) {
			/* Don't allow mixed padding and actual chars. */
			goto error;
		}
		t = (t << 6) + y;
	 skip_add:

		if (group_idx == 3) {
			/* output 3 bytes from 't' */
			*dst++ = (duk_uint8_t) ((t >> 16) & 0xff);
			*dst++ = (duk_uint8_t) ((t >> 8) & 0xff);
			*dst++ = (duk_uint8_t) (t & 0xff);

			if (DUK_UNLIKELY(n_equal > 0)) {
				/* Backtrack. */
				DUK_ASSERT(n_equal <= 4);
				if (n_equal == 1) {
					dst -= 1;
				} else if (n_equal == 2) {
					dst -= 2;
				} else {
					goto error;  /* invalid padding */
				}

				/* Here we can choose either to end parsing and ignore
				 * whatever follows, or to continue parsing in case
				 * multiple (possibly padded) base64 strings have been
				 * concatenated.  Currently, keep on parsing.
				 */
				n_equal = 0;
			}

			t = 0;
			group_idx = 0;
		} else {
			group_idx++;
		}
	}

	if (group_idx != 0) {
		/* Here we'd have the option of decoding unpadded base64
		 * (e.g. "xxxxyy" instead of "xxxxyy==".  Currently not
		 * accepted.
		 */
		goto error;
	}

	*out_dst_final = dst;
	return 1;

 error:
	return 0;
}
#endif  /* DUK_USE_BASE64_FASTPATH */

DUK_EXTERNAL const char *duk_base64_encode(duk_context *ctx, duk_idx_t index) {
	duk_hthread *thr = (duk_hthread *) ctx;
	const duk_uint8_t *src;
	duk_size_t srclen;
	duk_size_t dstlen;
	duk_uint8_t *dst;
	const char *ret;

	DUK_ASSERT_CTX_VALID(ctx);

	/* XXX: optimize for string inputs: no need to coerce to a buffer
	 * which makes a copy of the input.
	 */

	index = duk_require_normalize_index(ctx, index);
	src = duk__prep_codec_arg(ctx, index, &srclen);
	/* Note: for srclen=0, src may be NULL */

	/* Computation must not wrap; this limit works for 32-bit size_t:
	 * >>> srclen = 3221225469
	 * >>> '%x' % ((srclen + 2) / 3 * 4)
	 * 'fffffffc'
	 */
	if (srclen > 3221225469UL) {
		goto type_error;
	}
	dstlen = (srclen + 2) / 3 * 4;
	dst = (duk_uint8_t *) duk_push_fixed_buffer(ctx, dstlen);

	duk__base64_encode_helper((const duk_uint8_t *) src, srclen, dst);

	ret = duk_to_string(ctx, -1);
	duk_replace(ctx, index);
	return ret;

 type_error:
	DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_ENCODE_FAILED);
	return NULL;  /* never here */
}

DUK_EXTERNAL void duk_base64_decode(duk_context *ctx, duk_idx_t index) {
	duk_hthread *thr = (duk_hthread *) ctx;
	const duk_uint8_t *src;
	duk_size_t srclen;
	duk_size_t dstlen;
	duk_uint8_t *dst;
	duk_uint8_t *dst_final;
	duk_bool_t retval;

	DUK_ASSERT_CTX_VALID(ctx);

	/* XXX: optimize for buffer inputs: no need to coerce to a string
	 * which causes an unnecessary interning.
	 */

	index = duk_require_normalize_index(ctx, index);
	src = duk__prep_codec_arg(ctx, index, &srclen);

	/* Computation must not wrap, only srclen + 3 is at risk of
	 * wrapping because after that the number gets smaller.
	 * This limit works for 32-bit size_t:
	 * 0x100000000 - 3 - 1 = 4294967292
	 */
	if (srclen > 4294967292UL) {
		goto type_error;
	}
	dstlen = (srclen + 3) / 4 * 3;  /* upper limit, assuming no whitespace etc */
	dst = (duk_uint8_t *) duk_push_dynamic_buffer(ctx, dstlen);
	/* Note: for dstlen=0, dst may be NULL */

	retval = duk__base64_decode_helper((const duk_uint8_t *) src, srclen, dst, &dst_final);
	if (!retval) {
		goto type_error;
	}

	/* XXX: convert to fixed buffer? */
	(void) duk_resize_buffer(ctx, -1, (duk_size_t) (dst_final - dst));
	duk_replace(ctx, index);
	return;

 type_error:
	DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_DECODE_FAILED);
}

DUK_EXTERNAL const char *duk_hex_encode(duk_context *ctx, duk_idx_t index) {
	const duk_uint8_t *inp;
	duk_size_t len;
	duk_size_t i;
	duk_uint8_t *buf;
	const char *ret;
#if defined(DUK_USE_HEX_FASTPATH)
	duk_size_t len_safe;
	duk_uint16_t *p16;
#endif

	DUK_ASSERT_CTX_VALID(ctx);

	index = duk_require_normalize_index(ctx, index);
	inp = duk__prep_codec_arg(ctx, index, &len);
	DUK_ASSERT(inp != NULL || len == 0);

	/* Fixed buffer, no zeroing because we'll fill all the data. */
	buf = (duk_uint8_t *) duk_push_buffer_raw(ctx, len * 2, DUK_BUF_FLAG_NOZERO /*flags*/);
	DUK_ASSERT(buf != NULL);

#if defined(DUK_USE_HEX_FASTPATH)
	DUK_ASSERT((((duk_uintptr_t) buf) & 0x01U) == 0);   /* pointer is aligned, guaranteed for fixed buffer */
	p16 = (duk_uint16_t *) (void *) buf;
	len_safe = len & ~0x03U;
	for (i = 0; i < len_safe; i += 4) {
		p16[0] = duk_hex_enctab[inp[i]];
		p16[1] = duk_hex_enctab[inp[i + 1]];
		p16[2] = duk_hex_enctab[inp[i + 2]];
		p16[3] = duk_hex_enctab[inp[i + 3]];
		p16 += 4;
	}
	for (; i < len; i++) {
		*p16++ = duk_hex_enctab[inp[i]];
	}
#else  /* DUK_USE_HEX_FASTPATH */
	for (i = 0; i < len; i++) {
		duk_small_uint_t t;
		t = (duk_small_uint_t) inp[i];
		buf[i*2 + 0] = duk_lc_digits[t >> 4];
		buf[i*2 + 1] = duk_lc_digits[t & 0x0f];
	}
#endif  /* DUK_USE_HEX_FASTPATH */

	/* XXX: Using a string return value forces a string intern which is
	 * not always necessary.  As a rough performance measure, hex encode
	 * time for tests/perf/test-hex-encode.js dropped from ~35s to ~15s
	 * without string coercion.  Change to returning a buffer and let the
	 * caller coerce to string if necessary?
	 */

	ret = duk_to_string(ctx, -1);
	duk_replace(ctx, index);
	return ret;
}

DUK_EXTERNAL void duk_hex_decode(duk_context *ctx, duk_idx_t index) {
	duk_hthread *thr = (duk_hthread *) ctx;
	const duk_uint8_t *inp;
	duk_size_t len;
	duk_size_t i;
	duk_int_t t;
	duk_uint8_t *buf;
#if defined(DUK_USE_HEX_FASTPATH)
	duk_int_t chk;
	duk_uint8_t *p;
	duk_size_t len_safe;
#endif

	DUK_ASSERT_CTX_VALID(ctx);

	index = duk_require_normalize_index(ctx, index);
	inp = duk__prep_codec_arg(ctx, index, &len);
	DUK_ASSERT(inp != NULL || len == 0);

	if (len & 0x01) {
		goto type_error;
	}

	/* Fixed buffer, no zeroing because we'll fill all the data. */
	buf = (duk_uint8_t *) duk_push_buffer_raw(ctx, len / 2, DUK_BUF_FLAG_NOZERO /*flags*/);
	DUK_ASSERT(buf != NULL);

#if defined(DUK_USE_HEX_FASTPATH)
	p = buf;
	len_safe = len & ~0x07U;
	for (i = 0; i < len_safe; i += 8) {
		t = ((duk_int_t) duk_hex_dectab_shift4[inp[i]]) |
		    ((duk_int_t) duk_hex_dectab[inp[i + 1]]);
		chk = t;
		p[0] = (duk_uint8_t) t;
		t = ((duk_int_t) duk_hex_dectab_shift4[inp[i + 2]]) |
		    ((duk_int_t) duk_hex_dectab[inp[i + 3]]);
		chk |= t;
		p[1] = (duk_uint8_t) t;
		t = ((duk_int_t) duk_hex_dectab_shift4[inp[i + 4]]) |
		    ((duk_int_t) duk_hex_dectab[inp[i + 5]]);
		chk |= t;
		p[2] = (duk_uint8_t) t;
		t = ((duk_int_t) duk_hex_dectab_shift4[inp[i + 6]]) |
		    ((duk_int_t) duk_hex_dectab[inp[i + 7]]);
		chk |= t;
		p[3] = (duk_uint8_t) t;
		p += 4;

		/* Check if any lookup above had a negative result. */
		if (DUK_UNLIKELY(chk < 0)) {
			goto type_error;
		}
	}
	for (; i < len; i += 2) {
		t = (((duk_int_t) duk_hex_dectab[inp[i]]) << 4) |
		    ((duk_int_t) duk_hex_dectab[inp[i + 1]]);
		if (DUK_UNLIKELY(t < 0)) {
			goto type_error;
		}
		*p++ = (duk_uint8_t) t;
	}
#else  /* DUK_USE_HEX_FASTPATH */
	for (i = 0; i < len; i += 2) {
		/* For invalid characters the value -1 gets extended to
		 * at least 16 bits.  If either nybble is invalid, the
		 * resulting 't' will be < 0.
		 */
		t = (((duk_int_t) duk_hex_dectab[inp[i]]) << 4) |
		    ((duk_int_t) duk_hex_dectab[inp[i + 1]]);
		if (DUK_UNLIKELY(t < 0)) {
			goto type_error;
		}
		buf[i >> 1] = (duk_uint8_t) t;
	}
#endif  /* DUK_USE_HEX_FASTPATH */

	duk_replace(ctx, index);
	return;

 type_error:
	DUK_ERROR(thr, DUK_ERR_TYPE_ERROR, DUK_STR_DECODE_FAILED);
}

DUK_EXTERNAL const char *duk_json_encode(duk_context *ctx, duk_idx_t index) {
#ifdef DUK_USE_ASSERTIONS
	duk_idx_t top_at_entry;
#endif
	const char *ret;

	DUK_ASSERT_CTX_VALID(ctx);
#ifdef DUK_USE_ASSERTIONS
	top_at_entry = duk_get_top(ctx);
#endif

	index = duk_require_normalize_index(ctx, index);
	duk_bi_json_stringify_helper(ctx,
	                             index /*idx_value*/,
	                             DUK_INVALID_INDEX /*idx_replacer*/,
	                             DUK_INVALID_INDEX /*idx_space*/,
	                             0 /*flags*/);
	DUK_ASSERT(duk_is_string(ctx, -1));
	duk_replace(ctx, index);
	ret = duk_get_string(ctx, index);

	DUK_A