/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTrustedTypePolicyFactory.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSTrustedHTML.h"
#include "JSTrustedScript.h"
#include "JSTrustedTypePolicy.h"
#include "JSTrustedTypePolicyOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_createPolicy);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_isHTML);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_isScript);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_isScriptURL);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_getAttributeType);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_getPropertyType);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTrustedTypePolicyFactoryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsTrustedTypePolicyFactory_emptyHTML);
static JSC_DECLARE_CUSTOM_GETTER(jsTrustedTypePolicyFactory_emptyScript);
static JSC_DECLARE_CUSTOM_GETTER(jsTrustedTypePolicyFactory_defaultPolicy);

class JSTrustedTypePolicyFactoryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTrustedTypePolicyFactoryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTrustedTypePolicyFactoryPrototype* ptr = new (NotNull, JSC::allocateCell<JSTrustedTypePolicyFactoryPrototype>(vm)) JSTrustedTypePolicyFactoryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTrustedTypePolicyFactoryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTrustedTypePolicyFactoryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTrustedTypePolicyFactoryPrototype, JSTrustedTypePolicyFactoryPrototype::Base);

using JSTrustedTypePolicyFactoryDOMConstructor = JSDOMConstructorNotConstructable<JSTrustedTypePolicyFactory>;

template<> const ClassInfo JSTrustedTypePolicyFactoryDOMConstructor::s_info = { "TrustedTypePolicyFactory"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedTypePolicyFactoryDOMConstructor) };

template<> JSValue JSTrustedTypePolicyFactoryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTrustedTypePolicyFactoryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TrustedTypePolicyFactory"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTrustedTypePolicyFactory::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTrustedTypePolicyFactoryPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTrustedTypePolicyFactoryConstructor, 0 } },
    { "emptyHTML"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTrustedTypePolicyFactory_emptyHTML, 0 } },
    { "emptyScript"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTrustedTypePolicyFactory_emptyScript, 0 } },
    { "defaultPolicy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTrustedTypePolicyFactory_defaultPolicy, 0 } },
    { "createPolicy"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyFactoryPrototypeFunction_createPolicy, 1 } },
    { "isHTML"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyFactoryPrototypeFunction_isHTML, 1 } },
    { "isScript"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyFactoryPrototypeFunction_isScript, 1 } },
    { "isScriptURL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyFactoryPrototypeFunction_isScriptURL, 1 } },
    { "getAttributeType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyFactoryPrototypeFunction_getAttributeType, 2 } },
    { "getPropertyType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyFactoryPrototypeFunction_getPropertyType, 2 } },
};

const ClassInfo JSTrustedTypePolicyFactoryPrototype::s_info = { "TrustedTypePolicyFactory"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedTypePolicyFactoryPrototype) };

void JSTrustedTypePolicyFactoryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTrustedTypePolicyFactory::info(), JSTrustedTypePolicyFactoryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTrustedTypePolicyFactory::s_info = { "TrustedTypePolicyFactory"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedTypePolicyFactory) };

JSTrustedTypePolicyFactory::JSTrustedTypePolicyFactory(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TrustedTypePolicyFactory>&& impl)
    : JSDOMWrapper<TrustedTypePolicyFactory>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, TrustedTypePolicyFactory>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSTrustedTypePolicyFactory::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTrustedTypePolicyFactoryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSTrustedTypePolicyFactoryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTrustedTypePolicyFactory::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTrustedTypePolicyFactory>(vm, globalObject);
}

JSValue JSTrustedTypePolicyFactory::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTrustedTypePolicyFactoryDOMConstructor, DOMConstructorID::TrustedTypePolicyFactory>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTrustedTypePolicyFactory::destroy(JSC::JSCell* cell)
{
    JSTrustedTypePolicyFactory* thisObject = static_cast<JSTrustedTypePolicyFactory*>(cell);
    thisObject->JSTrustedTypePolicyFactory::~JSTrustedTypePolicyFactory();
}

JSC_DEFINE_CUSTOM_GETTER(jsTrustedTypePolicyFactoryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTrustedTypePolicyFactoryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTrustedTypePolicyFactory::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsTrustedTypePolicyFactory_emptyHTMLGetter(JSGlobalObject& lexicalGlobalObject, JSTrustedTypePolicyFactory& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TrustedHTML>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.emptyHTML())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTrustedTypePolicyFactory_emptyHTML, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTrustedTypePolicyFactory>::get<jsTrustedTypePolicyFactory_emptyHTMLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTrustedTypePolicyFactory_emptyScriptGetter(JSGlobalObject& lexicalGlobalObject, JSTrustedTypePolicyFactory& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TrustedScript>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.emptyScript())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTrustedTypePolicyFactory_emptyScript, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTrustedTypePolicyFactory>::get<jsTrustedTypePolicyFactory_emptyScriptGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTrustedTypePolicyFactory_defaultPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSTrustedTypePolicyFactory& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<TrustedTypePolicy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.defaultPolicy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTrustedTypePolicyFactory_defaultPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTrustedTypePolicyFactory>::get<jsTrustedTypePolicyFactory_defaultPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyFactoryPrototypeFunction_createPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicyFactory>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto policyNameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(policyNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto policyOptionsConversionResult = convert<IDLDictionary<TrustedTypePolicyOptions>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(policyOptionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<TrustedTypePolicy>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPolicy(*context, policyNameConversionResult.releaseReturnValue(), policyOptionsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_createPolicy, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicyFactory>::call<jsTrustedTypePolicyFactoryPrototypeFunction_createPolicyBody>(*lexicalGlobalObject, *callFrame, "createPolicy");
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyFactoryPrototypeFunction_isHTMLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicyFactory>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isHTML(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_isHTML, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicyFactory>::call<jsTrustedTypePolicyFactoryPrototypeFunction_isHTMLBody>(*lexicalGlobalObject, *callFrame, "isHTML");
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyFactoryPrototypeFunction_isScriptBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicyFactory>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isScript(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_isScript, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicyFactory>::call<jsTrustedTypePolicyFactoryPrototypeFunction_isScriptBody>(*lexicalGlobalObject, *callFrame, "isScript");
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyFactoryPrototypeFunction_isScriptURLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicyFactory>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isScriptURL(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_isScriptURL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicyFactory>::call<jsTrustedTypePolicyFactoryPrototypeFunction_isScriptURLBody>(*lexicalGlobalObject, *callFrame, "isScriptURL");
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyFactoryPrototypeFunction_getAttributeTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicyFactory>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto tagNameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(tagNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto attributeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(attributeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto elementNamespaceConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return Converter<IDLNullable<IDLDOMString>>::ReturnType { emptyString() }; });
    if (UNLIKELY(elementNamespaceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto attrNamespaceConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return Converter<IDLNullable<IDLDOMString>>::ReturnType { emptyString() }; });
    if (UNLIKELY(attrNamespaceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.getAttributeType(tagNameConversionResult.releaseReturnValue(), attributeConversionResult.releaseReturnValue(), elementNamespaceConversionResult.releaseReturnValue(), attrNamespaceConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_getAttributeType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicyFactory>::call<jsTrustedTypePolicyFactoryPrototypeFunction_getAttributeTypeBody>(*lexicalGlobalObject, *callFrame, "getAttributeType");
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyFactoryPrototypeFunction_getPropertyTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicyFactory>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto tagNameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(tagNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto propertyConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(propertyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto elementNamespaceConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return Converter<IDLNullable<IDLDOMString>>::ReturnType { emptyString() }; });
    if (UNLIKELY(elementNamespaceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.getPropertyType(tagNameConversionResult.releaseReturnValue(), propertyConversionResult.releaseReturnValue(), elementNamespaceConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyFactoryPrototypeFunction_getPropertyType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicyFactory>::call<jsTrustedTypePolicyFactoryPrototypeFunction_getPropertyTypeBody>(*lexicalGlobalObject, *callFrame, "getPropertyType");
}

JSC::GCClient::IsoSubspace* JSTrustedTypePolicyFactory::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTrustedTypePolicyFactory, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTrustedTypePolicyFactory.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTrustedTypePolicyFactory = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTrustedTypePolicyFactory.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTrustedTypePolicyFactory = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSTrustedTypePolicyFactory::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTrustedTypePolicyFactory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSTrustedTypePolicyFactory);

template<typename Visitor>
void JSTrustedTypePolicyFactory::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTrustedTypePolicyFactory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSTrustedTypePolicyFactory::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSTrustedTypePolicyFactory::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSTrustedTypePolicyFactory::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTrustedTypePolicyFactory*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSTrustedTypePolicyFactoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsTrustedTypePolicyFactory = jsCast<JSTrustedTypePolicyFactory*>(handle.slot()->asCell());
    ScriptExecutionContext* owner = WTF::getPtr(jsTrustedTypePolicyFactory->wrapped().scriptExecutionContext());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from ScriptExecutionContext"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSTrustedTypePolicyFactoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTrustedTypePolicyFactory = static_cast<JSTrustedTypePolicyFactory*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTrustedTypePolicyFactory->protectedWrapped().ptr(), jsTrustedTypePolicyFactory);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TrustedTypePolicyFactory@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24TrustedTypePolicyFactoryE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, TrustedTypePolicyFactory>, void>> static inline void verifyVTable(TrustedTypePolicyFactory* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TrustedTypePolicyFactory@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore24TrustedTypePolicyFactoryE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TrustedTypePolicyFactory has subclasses. If TrustedTypePolicyFactory has subclasses that get passed
        // to toJS() we currently require TrustedTypePolicyFactory you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TrustedTypePolicyFactory>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<TrustedTypePolicyFactory>(impl.ptr());
#endif
    return createWrapper<TrustedTypePolicyFactory>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TrustedTypePolicyFactory& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TrustedTypePolicyFactory* JSTrustedTypePolicyFactory::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTrustedTypePolicyFactory*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
