/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSKHRParallelShaderCompile.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSKHRParallelShaderCompilePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSKHRParallelShaderCompilePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKHRParallelShaderCompilePrototype* ptr = new (NotNull, JSC::allocateCell<JSKHRParallelShaderCompilePrototype>(vm)) JSKHRParallelShaderCompilePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKHRParallelShaderCompilePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSKHRParallelShaderCompilePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKHRParallelShaderCompilePrototype, JSKHRParallelShaderCompilePrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSKHRParallelShaderCompilePrototypeTableValues[] =
{
    { "COMPLETION_STATUS_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x91B1 } },
};

const ClassInfo JSKHRParallelShaderCompilePrototype::s_info = { "KHRParallelShaderCompile"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKHRParallelShaderCompilePrototype) };

void JSKHRParallelShaderCompilePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSKHRParallelShaderCompile::info(), JSKHRParallelShaderCompilePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSKHRParallelShaderCompile::s_info = { "KHRParallelShaderCompile"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKHRParallelShaderCompile) };

JSKHRParallelShaderCompile::JSKHRParallelShaderCompile(Structure* structure, JSDOMGlobalObject& globalObject, Ref<KHRParallelShaderCompile>&& impl)
    : JSDOMWrapper<KHRParallelShaderCompile>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, KHRParallelShaderCompile>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSKHRParallelShaderCompile::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSKHRParallelShaderCompilePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSKHRParallelShaderCompilePrototype::create(vm, &globalObject, structure);
}

JSObject* JSKHRParallelShaderCompile::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSKHRParallelShaderCompile>(vm, globalObject);
}

void JSKHRParallelShaderCompile::destroy(JSC::JSCell* cell)
{
    JSKHRParallelShaderCompile* thisObject = static_cast<JSKHRParallelShaderCompile*>(cell);
    thisObject->JSKHRParallelShaderCompile::~JSKHRParallelShaderCompile();
}

JSC::GCClient::IsoSubspace* JSKHRParallelShaderCompile::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSKHRParallelShaderCompile, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForKHRParallelShaderCompile.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForKHRParallelShaderCompile = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForKHRParallelShaderCompile.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForKHRParallelShaderCompile = std::forward<decltype(space)>(space); }
    );
}

void JSKHRParallelShaderCompile::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSKHRParallelShaderCompile*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSKHRParallelShaderCompileOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsKHRParallelShaderCompile = jsCast<JSKHRParallelShaderCompile*>(handle.slot()->asCell());
    auto& owner = jsKHRParallelShaderCompile->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsKHRParallelShaderCompile"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSKHRParallelShaderCompileOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsKHRParallelShaderCompile = static_cast<JSKHRParallelShaderCompile*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsKHRParallelShaderCompile->protectedWrapped().ptr(), jsKHRParallelShaderCompile);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7KHRParallelShaderCompile@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24KHRParallelShaderCompileE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, KHRParallelShaderCompile>, void>> static inline void verifyVTable(KHRParallelShaderCompile* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7KHRParallelShaderCompile@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore24KHRParallelShaderCompileE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // KHRParallelShaderCompile has subclasses. If KHRParallelShaderCompile has subclasses that get passed
        // to toJS() we currently require KHRParallelShaderCompile you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<KHRParallelShaderCompile>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<KHRParallelShaderCompile>(impl.ptr());
#endif
    return createWrapper<KHRParallelShaderCompile>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, KHRParallelShaderCompile& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

KHRParallelShaderCompile* JSKHRParallelShaderCompile::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSKHRParallelShaderCompile*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
