/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "HTMLInputElement.h"
#include "JSDOMWrapper.h"
#include "JSHTMLElement.h"

namespace WebCore {

class WEBCORE_EXPORT JSHTMLInputElement : public JSHTMLElement {
public:
    using Base = JSHTMLElement;
    using DOMWrapped = HTMLInputElement;
    static JSHTMLInputElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<HTMLInputElement>&& impl)
    {
        auto& vm = globalObject->vm();
        JSHTMLInputElement* ptr = new (NotNull, JSC::allocateCell<JSHTMLInputElement>(vm)) JSHTMLInputElement(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static HTMLInputElement* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSElementType), StructureFlags), info(), JSC::NonArray);
    }

    JSC::JSScope* pushEventHandlerScope(JSC::JSGlobalObject*, JSC::JSScope*) const;

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    mutable JSC::WriteBarrier<JSC::Unknown> m_webkitEntries;
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    DECLARE_VISIT_CHILDREN;

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    HTMLInputElement& wrapped() const
    {
        return static_cast<HTMLInputElement&>(Base::wrapped());
    }

    Ref<HTMLInputElement> protectedWrapped() const;

protected:
    JSHTMLInputElement(JSC::Structure*, JSDOMGlobalObject&, Ref<HTMLInputElement>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};


template<> struct JSDOMWrapperConverterTraits<HTMLInputElement> {
    using WrapperClass = JSHTMLInputElement;
    using ToWrappedReturnType = HTMLInputElement*;
};

} // namespace WebCore
