/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUFragmentState.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUColorTargetState.h"
#include "JSGPUShaderModule.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUFragmentState>> convertDictionary<GPUFragmentState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUFragmentState result;
    JSValue constantsValue;
    if (isNullOrUndefined)
        constantsValue = jsUndefined();
    else {
        constantsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "constants"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!constantsValue.isUndefined()) {
        auto constantsConversionResult = convert<IDLRecord<IDLUSVString, IDLDouble>>(lexicalGlobalObject, constantsValue);
        if (UNLIKELY(constantsConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.constants = constantsConversionResult.releaseReturnValue();
    }
    JSValue entryPointValue;
    if (isNullOrUndefined)
        entryPointValue = jsUndefined();
    else {
        entryPointValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "entryPoint"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!entryPointValue.isUndefined()) {
        auto entryPointConversionResult = convert<IDLUSVString>(lexicalGlobalObject, entryPointValue);
        if (UNLIKELY(entryPointConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.entryPoint = entryPointConversionResult.releaseReturnValue();
    }
    JSValue moduleValue;
    if (isNullOrUndefined)
        moduleValue = jsUndefined();
    else {
        moduleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "module"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (moduleValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "module"_s, "GPUFragmentState"_s, "GPUShaderModule"_s);
        return ConversionResultException { };
    }
    auto moduleConversionResult = convert<IDLInterface<GPUShaderModule>>(lexicalGlobalObject, moduleValue);
    if (UNLIKELY(moduleConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.module = moduleConversionResult.releaseReturnValue();
    JSValue targetsValue;
    if (isNullOrUndefined)
        targetsValue = jsUndefined();
    else {
        targetsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targets"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (targetsValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "targets"_s, "GPUFragmentState"_s, "sequence"_s);
        return ConversionResultException { };
    }
    auto targetsConversionResult = convert<IDLSequence<IDLNullable<IDLDictionary<GPUColorTargetState>>>>(lexicalGlobalObject, targetsValue);
    if (UNLIKELY(targetsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.targets = targetsConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
