/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFile.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEndingType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<File::PropertyBag>> convertDictionary<File::PropertyBag>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    File::PropertyBag result;
    JSValue endingsValue;
    if (isNullOrUndefined)
        endingsValue = jsUndefined();
    else {
        endingsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endings"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto endingsConversionResult = convertOptionalWithDefault<IDLEnumeration<EndingType>>(lexicalGlobalObject, endingsValue, [&]() -> ConversionResult<IDLEnumeration<EndingType>> { return Converter<IDLEnumeration<EndingType>>::ReturnType { EndingType::Transparent }; });
    if (UNLIKELY(endingsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.endings = endingsConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    JSValue lastModifiedValue;
    if (isNullOrUndefined)
        lastModifiedValue = jsUndefined();
    else {
        lastModifiedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lastModified"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!lastModifiedValue.isUndefined()) {
        auto lastModifiedConversionResult = convert<IDLLongLong>(lexicalGlobalObject, lastModifiedValue);
        if (UNLIKELY(lastModifiedConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.lastModified = lastModifiedConversionResult.releaseReturnValue();
    }
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsFile_name);
static JSC_DECLARE_CUSTOM_GETTER(jsFile_lastModified);
static JSC_DECLARE_CUSTOM_GETTER(jsFile_webkitRelativePath);

class JSFilePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFilePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFilePrototype* ptr = new (NotNull, JSC::allocateCell<JSFilePrototype>(vm)) JSFilePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFilePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFilePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFilePrototype, JSFilePrototype::Base);

using JSFileDOMConstructor = JSDOMConstructor<JSFile>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFileDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFileDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "File"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto fileBitsConversionResult = convert<IDLSequence<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLInterface<Blob>, IDLUSVString>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(fileBitsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto fileNameConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(fileNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto optionsConversionResult = convert<IDLDictionary<File::PropertyBag>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = File::create(*context, fileBitsConversionResult.releaseReturnValue(), fileNameConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<File>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<File>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFileDOMConstructorConstruct, JSFileDOMConstructor::construct);

template<> const ClassInfo JSFileDOMConstructor::s_info = { "File"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileDOMConstructor) };

template<> JSValue JSFileDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSBlob::getConstructor(vm, &globalObject);
}

template<> void JSFileDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "File"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFile::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSFilePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileConstructor, 0 } },
    { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFile_name, 0 } },
    { "lastModified"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFile_lastModified, 0 } },
    { "webkitRelativePath"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFile_webkitRelativePath, 0 } },
};

const ClassInfo JSFilePrototype::s_info = { "File"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFilePrototype) };

void JSFilePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFile::info(), JSFilePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().directoryUploadEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitRelativePath"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFile::s_info = { "File"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFile) };

JSFile::JSFile(Structure* structure, JSDOMGlobalObject& globalObject, Ref<File>&& impl)
    : JSBlob(structure, globalObject, WTFMove(impl))
{
}

Ref<File> JSFile::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, File>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFile::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFilePrototype::createStructure(vm, &globalObject, JSBlob::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFilePrototype::create(vm, &globalObject, structure);
}

JSObject* JSFile::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFile>(vm, globalObject);
}

JSValue JSFile::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileDOMConstructor, DOMConstructorID::File>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFilePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFile::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsFile_nameGetter(JSGlobalObject& lexicalGlobalObject, JSFile& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFile_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFile>::get<jsFile_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFile_lastModifiedGetter(JSGlobalObject& lexicalGlobalObject, JSFile& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.lastModified())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFile_lastModified, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFile>::get<jsFile_lastModifiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFile_webkitRelativePathGetter(JSGlobalObject& lexicalGlobalObject, JSFile& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.relativePath())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFile_webkitRelativePath, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFile>::get<jsFile_webkitRelativePathGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSFile::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFile, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFile.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFile = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFile.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFile = std::forward<decltype(space)>(space); }
    );
}

void JSFile::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFile*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFile = jsCast<JSFile*>(handle.slot()->asCell());
    auto& wrapped = jsFile->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFile = static_cast<JSFile*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFile->protectedWrapped().ptr(), jsFile);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7File@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore4FileE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, File>, void>> static inline void verifyVTable(File* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7File@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore4FileE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // File has subclasses. If File has subclasses that get passed
        // to toJS() we currently require File you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<File>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<File>(impl.ptr());
#endif
    return createWrapper<File>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, File& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

File* JSFile::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFile*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
