/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSPerspective.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSPerspectiveConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPerspective_length);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPerspective_length);

class JSCSSPerspectivePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSPerspectivePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSPerspectivePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSPerspectivePrototype>(vm)) JSCSSPerspectivePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSPerspectivePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSPerspectivePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSPerspectivePrototype, JSCSSPerspectivePrototype::Base);

using JSCSSPerspectiveDOMConstructor = JSDOMConstructor<JSCSSPerspective>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSPerspectiveDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSPerspectiveDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto lengthConversionResult = convert<IDLUnion<IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(lengthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = CSSPerspective::create(lengthConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSPerspective>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSPerspective>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSPerspectiveDOMConstructorConstruct, JSCSSPerspectiveDOMConstructor::construct);

template<> const ClassInfo JSCSSPerspectiveDOMConstructor::s_info = { "CSSPerspective"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPerspectiveDOMConstructor) };

template<> JSValue JSCSSPerspectiveDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSTransformComponent::getConstructor(vm, &globalObject);
}

template<> void JSCSSPerspectiveDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSPerspective"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSPerspective::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSPerspectivePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPerspectiveConstructor, 0 } },
    { "length"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPerspective_length, setJSCSSPerspective_length } },
};

const ClassInfo JSCSSPerspectivePrototype::s_info = { "CSSPerspective"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPerspectivePrototype) };

void JSCSSPerspectivePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSPerspective::info(), JSCSSPerspectivePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSPerspective::s_info = { "CSSPerspective"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPerspective) };

JSCSSPerspective::JSCSSPerspective(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSPerspective>&& impl)
    : JSCSSTransformComponent(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSPerspective> JSCSSPerspective::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSPerspective>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSPerspective::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSPerspectivePrototype::createStructure(vm, &globalObject, JSCSSTransformComponent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSPerspectivePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSPerspective::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSPerspective>(vm, globalObject);
}

JSValue JSCSSPerspective::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSPerspectiveDOMConstructor, DOMConstructorID::CSSPerspective>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPerspectiveConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSPerspectivePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSPerspective::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSPerspective_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPerspective& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPerspective_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPerspective>::get<jsCSSPerspective_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPerspective_lengthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPerspective& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLength(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPerspective_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPerspective>::set<setJSCSSPerspective_lengthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSPerspective::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSPerspective, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSPerspective.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSPerspective = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSPerspective.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSPerspective = std::forward<decltype(space)>(space); }
    );
}

void JSCSSPerspective::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSPerspective*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSPerspective@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14CSSPerspectiveE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CSSPerspective>, void>> static inline void verifyVTable(CSSPerspective* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSPerspective@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14CSSPerspectiveE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSPerspective has subclasses. If CSSPerspective has subclasses that get passed
        // to toJS() we currently require CSSPerspective you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSPerspective>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSPerspective>(impl.ptr());
#endif
    return createWrapper<CSSPerspective>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSPerspective& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
