/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.contactinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import net.java.sip.communicator.plugin.contactinfo.ContactInfoActivator;
import net.java.sip.communicator.plugin.contactinfo.Resources;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommHTMLEditorKit;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetWebContactInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;

public class ContactInfoDetailsPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final JTabbedPane tabbedPane = new SIPCommTabbedPane();
    private OperationSetServerStoredContactInfo contactInfoOpSet;
    private Contact contact;
    private static final int AVATAR_AREA_WIDTH = 105;
    private static final int AVATAR_AREA_HEIGHT = 130;

    public ContactInfoDetailsPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(400, 300));
        this.tabbedPane.setTabLayoutPolicy(1);
    }

    public void loadContactDetails(Contact c) {
        this.contact = c;
        ProtocolProviderService pps = this.contact.getProtocolProvider();
        this.contactInfoOpSet = (OperationSetServerStoredContactInfo)pps.getOperationSet(OperationSetServerStoredContactInfo.class);
        this.removeAll();
        if (this.contactInfoOpSet == null || !pps.isRegistered()) {
            JPanel unsupportedPanel = this.createUnsupportedPanel();
            this.add(unsupportedPanel);
            this.revalidate();
            this.repaint();
            return;
        }
        this.tabbedPane.removeAll();
        ImageIcon icon = new ImageIcon(this.contact.getProtocolProvider().getProtocolIcon().getIcon("IconSize16x16"));
        JPanel summaryPanel = this.createSummaryInfoPanel();
        JPanel extendedPanel = this.createExtendedInfoPanel();
        JScrollPane extendedScrollPane = new JScrollPane(extendedPanel);
        this.tabbedPane.addTab(Resources.getString("service.gui.SUMMARY"), icon, summaryPanel, Resources.getString("plugin.contactinfo.CONTACT_SUMMARY_DESCRIPTION") + this.contact.getDisplayName());
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(Resources.getString("plugin.accountinfo.EXTENDED"), icon, extendedScrollPane, Resources.getString("plugin.contactinfo.CONTACT_EXTENDED_DESCRIPTION") + this.contact.getDisplayName());
        this.tabbedPane.setMnemonicAt(1, 50);
        this.add(this.tabbedPane);
        this.revalidate();
        this.repaint();
    }

    private JPanel createUnsupportedPanel() {
        JTextArea unsupportedTextArea = new JTextArea(Resources.getString("service.gui.CONTACT_INFO_NOT_SUPPORTED"));
        unsupportedTextArea.setEditable(false);
        unsupportedTextArea.setLineWrap(true);
        TransparentPanel unsupportedPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        unsupportedPanel.add(unsupportedTextArea);
        return unsupportedPanel;
    }

    private JPanel createSummaryInfoPanel() {
        ServerStoredDetails.GenericDetail genericDetail;
        TransparentPanel summaryPanel = new TransparentPanel();
        summaryPanel.setLayout(new BorderLayout(10, 5));
        summaryPanel.setSize(this.getWidth(), this.getHeight());
        TransparentPanel avatarPanel = new TransparentPanel();
        avatarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        byte[] bytes = this.contact.getImage();
        ImageIcon scaledImage = null;
        scaledImage = bytes != null ? ImageUtils.getScaledRoundedIcon((byte[])bytes, (int)105, (int)130) : ImageUtils.getScaledRoundedIcon((Image)Resources.getImage("service.gui.DEFAULT_USER_PHOTO"), (int)105, (int)130);
        JLabel label = new JLabel(scaledImage);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
        label.setPreferredSize(new Dimension(105, 130));
        avatarPanel.add(label);
        summaryPanel.add((Component)avatarPanel, "West");
        TransparentPanel detailsPanel = new TransparentPanel();
        detailsPanel.setLayout(new BorderLayout());
        detailsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        summaryPanel.add((Component)detailsPanel);
        TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.FIRST_NAME")));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.MIDDLE_NAME")));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.LAST_NAME")));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.GENDER")));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.BDAY")));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.AGE")));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.EMAIL")));
        labelsPanel.add(new JLabel(Resources.getString("plugin.accountinfo.PHONE")));
        detailsPanel.add((Component)labelsPanel, "West");
        TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        detailsPanel.add((Component)valuesPanel, "Center");
        Iterator contactDetails = this.contactInfoOpSet.getDetails(this.contact, ServerStoredDetails.FirstNameDetail.class);
        String firstNameDetail = "";
        while (contactDetails.hasNext()) {
            genericDetail = (ServerStoredDetails.GenericDetail)contactDetails.next();
            firstNameDetail = firstNameDetail + " " + genericDetail.getDetailValue();
        }
        if (firstNameDetail.equals("")) {
            firstNameDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        valuesPanel.add(new JLabel(firstNameDetail));
        contactDetails = this.contactInfoOpSet.getDetails(this.contact, ServerStoredDetails.MiddleNameDetail.class);
        String middleNameDetail = "";
        while (contactDetails.hasNext()) {
            genericDetail = (ServerStoredDetails.GenericDetail)contactDetails.next();
            middleNameDetail = middleNameDetail + " " + genericDetail.getDetailValue();
        }
        if (middleNameDetail.trim().equals("")) {
            middleNameDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        valuesPanel.add(new JLabel(middleNameDetail));
        contactDetails = this.contactInfoOpSet.getDetails(this.contact, ServerStoredDetails.LastNameDetail.class);
        String lastNameDetail = "";
        while (contactDetails.hasNext()) {
            genericDetail = (ServerStoredDetails.GenericDetail)contactDetails.next();
            lastNameDetail = lastNameDetail + " " + genericDetail.getDetailValue();
        }
        if (lastNameDetail.trim().equals("")) {
            lastNameDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        valuesPanel.add(new JLabel(lastNameDetail));
        contactDetails = this.contactInfoOpSet.getDetails(this.contact, ServerStoredDetails.GenderDetail.class);
        String genderDetail = "";
        while (contactDetails.hasNext()) {
            genericDetail = (ServerStoredDetails.GenericDetail)contactDetails.next();
            genderDetail = genderDetail + " " + genericDetail.getDetailValue();
        }
        if (genderDetail.trim().equals("")) {
            genderDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        valuesPanel.add(new JLabel(genderDetail));
        contactDetails = this.contactInfoOpSet.getDetails(this.contact, ServerStoredDetails.BirthDateDetail.class);
        String birthDateDetail = "";
        String ageDetail = "";
        if (contactDetails.hasNext()) {
            genericDetail = (ServerStoredDetails.GenericDetail)contactDetails.next();
            Calendar calendarDetail = (Calendar)genericDetail.getDetailValue();
            Date birthDate = calendarDetail.getTime();
            DateFormat dateFormat = DateFormat.getDateInstance();
            birthDateDetail = dateFormat.format(birthDate).trim();
            Calendar c = Calendar.getInstance();
            int age = c.get(1) - calendarDetail.get(1);
            if (c.get(2) < calendarDetail.get(2)) {
                --age;
            }
            ageDetail = Integer.toString(age).trim();
        }
        if (birthDateDetail.equals("")) {
            birthDateDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        if (ageDetail.equals("")) {
            ageDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        valuesPanel.add(new JLabel(birthDateDetail));
        valuesPanel.add(new JLabel(ageDetail));
        contactDetails = this.contactInfoOpSet.getDetails(this.contact, ServerStoredDetails.EmailAddressDetail.class);
        String emailDetail = "";
        while (contactDetails.hasNext()) {
            genericDetail = (ServerStoredDetails.GenericDetail)contactDetails.next();
            emailDetail = emailDetail + " " + genericDetail.getDetailValue();
        }
        if (emailDetail.trim().equals("")) {
            emailDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        valuesPanel.add(new JLabel(emailDetail));
        contactDetails = this.contactInfoOpSet.getDetails(this.contact, ServerStoredDetails.PhoneNumberDetail.class);
        String phoneNumberDetail = "";
        while (contactDetails.hasNext()) {
            genericDetail = (ServerStoredDetails.GenericDetail)contactDetails.next();
            phoneNumberDetail = phoneNumberDetail + " " + genericDetail.getDetailValue();
        }
        if (phoneNumberDetail.trim().equals("")) {
            phoneNumberDetail = Resources.getString("plugin.contactinfo.NOT_SPECIFIED");
        }
        valuesPanel.add(new JLabel(phoneNumberDetail));
        return summaryPanel;
    }

    private JPanel createExtendedInfoPanel() {
        OperationSetWebContactInfo webContactInfo;
        TransparentPanel detailPanel;
        JLabel detailLabel;
        TransparentPanel mainExtendedPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel extendedPanel = new TransparentPanel();
        extendedPanel.setLayout(new BoxLayout((Container)extendedPanel, 1));
        TransparentPanel imagePanel = new TransparentPanel();
        imagePanel.setLayout(new BoxLayout((Container)imagePanel, 2));
        imagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.contactinfo.USER_PICTURES")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        Iterator iter = this.contactInfoOpSet.getAllDetailsForContact(this.contact);
        while (iter.hasNext()) {
            ServerStoredDetails.GenericDetail detail = (ServerStoredDetails.GenericDetail)iter.next();
            if (detail.getDetailValue().toString().equals("")) continue;
            detailLabel = new JLabel();
            JTextArea detailValueArea = new JTextArea();
            detailPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
            detailValueArea.setAlignmentX(0.5f);
            detailValueArea.setEditable(false);
            detailValueArea.setLineWrap(true);
            detailPanel.add((Component)detailLabel, "West");
            detailPanel.add((Component)detailValueArea, "Center");
            detailPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            extendedPanel.add((Component)detailPanel);
            if (detail instanceof ServerStoredDetails.BinaryDetail) {
                JLabel imageLabel = new JLabel(new ImageIcon((byte[])detail.getDetailValue()));
                imagePanel.add(imageLabel);
                continue;
            }
            if (detail instanceof ServerStoredDetails.CalendarDetail) {
                detailLabel.setText(detail.getDetailDisplayName() + ": ");
                Date detailDate = ((Calendar)detail.getDetailValue()).getTime();
                DateFormat df = DateFormat.getDateInstance();
                detailValueArea.setText(df.format(detailDate).trim());
                continue;
            }
            if (detail instanceof ServerStoredDetails.LocaleDetail) {
                detailLabel.setText(detail.getDetailDisplayName() + ": ");
                Object value = detail.getDetailValue();
                String valueStr = "";
                if (value instanceof Locale) {
                    valueStr = ((Locale)value).getDisplayName().trim();
                } else if (value instanceof String) {
                    valueStr = (String)value;
                }
                detailValueArea.setText(valueStr);
                continue;
            }
            if (detail instanceof ServerStoredDetails.TimeZoneDetail) {
                detailLabel.setText(detail.getDetailDisplayName() + ": ");
                detailValueArea.setText(((TimeZone)detail.getDetailValue()).getDisplayName().trim());
                continue;
            }
            detailLabel.setText(detail.getDetailDisplayName() + ": ");
            detailValueArea.setText(detail.getDetailValue().toString().trim());
        }
        String statusMessage = this.contact.getStatusMessage();
        if (statusMessage != null && statusMessage.length() > 0) {
            detailLabel = new JLabel();
            HTMLTextPane detailValuePane = new HTMLTextPane();
            detailPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
            detailValuePane.setEditable(false);
            detailValuePane.setOpaque(false);
            detailPanel.add((Component)detailLabel, "West");
            detailPanel.add((Component)detailValuePane, "Center");
            detailPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            extendedPanel.add((Component)detailPanel);
            detailLabel.setText(Resources.getString("plugin.contactinfo.USER_STATUS_MESSAGE") + ": ");
            detailValuePane.setText(statusMessage);
        }
        if ((webContactInfo = (OperationSetWebContactInfo)this.contact.getProtocolProvider().getOperationSet(OperationSetWebContactInfo.class)) != null) {
            final String urlString = webContactInfo.getWebContactInfo(this.contact).toString();
            JLabel webInfoLabel = new JLabel("Click to see web info: ");
            JEditorPane webInfoValue = new JEditorPane();
            TransparentPanel webInfoPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            webInfoPanel.add((Component)webInfoLabel, "West");
            webInfoPanel.add((Component)webInfoValue, "Center");
            extendedPanel.add((Component)webInfoPanel);
            webInfoValue.setOpaque(false);
            webInfoValue.setContentType("text/html");
            webInfoValue.setEditable(false);
            webInfoValue.setText("<a href='" + urlString + "'>" + this.contact.getDisplayName() + " web info</a>");
            webInfoValue.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        ContactInfoActivator.getBrowserLauncher().openURL(urlString);
                    }
                }
            });
        }
        if (imagePanel.getComponentCount() > 0) {
            mainExtendedPanel.add((Component)imagePanel, "Center");
        }
        mainExtendedPanel.add((Component)extendedPanel, "North");
        return mainExtendedPanel;
    }

    private class HTMLTextPane
    extends JTextPane
    implements HyperlinkListener {
        private static final long serialVersionUID = 0L;
        private final Pattern URL_PATTERN = Pattern.compile("((\\bwww\\.[^\\s<>\"]+\\.[^\\s<>\"]+/*[?#]*(\\w+[&=;?]\\w+)*\\b)|(\\b\\w+://[^\\s<>\"]+/*[?#]*(\\w+[&=;?]\\w+)*\\b))");
        private SIPCommHTMLEditorKit editorKit = new SIPCommHTMLEditorKit((JComponent)this);
        private HTMLDocument document = (HTMLDocument)this.editorKit.createDefaultDocument();

        public HTMLTextPane() {
            this.addHyperlinkListener(this);
            this.setContentType("text/html");
            this.setEditorKitForContentType("text/html", (EditorKit)this.editorKit);
            this.setEditorKit((EditorKit)this.editorKit);
            this.setDocument(this.document);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }

        @Override
        public void setText(String string) {
            Matcher m = this.URL_PATTERN.matcher(string);
            StringBuffer msgBuffer = new StringBuffer();
            int prevEnd = 0;
            while (m.find()) {
                String fromPrevEndToStart = string.substring(prevEnd, m.start());
                msgBuffer.append(fromPrevEndToStart);
                prevEnd = m.end();
                String url = m.group().trim();
                msgBuffer.append("<A href=\"");
                if (url.startsWith("www")) {
                    msgBuffer.append("http://");
                }
                msgBuffer.append(url);
                msgBuffer.append("\">");
                msgBuffer.append(url);
                msgBuffer.append("</A>");
            }
            String fromPrevEndToEnd = string.substring(prevEnd);
            msgBuffer.append(fromPrevEndToEnd);
            super.setText(msgBuffer.toString());
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                ContactInfoActivator.getBrowserLauncher().openURL(e.getURL().toString());
            }
        }
    }
}

