/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomMemberIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.OperationSetPersistentPresenceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import org.easymock.EasyMock;

public class ChatRoomMemberIrcImplTest
extends TestCase {
    public void testConstructorNullProvider() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        try {
            new ChatRoomMemberIrcImpl(null, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
            Assert.fail((String)"should throw IAE for parent provider instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullChatRoom() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        try {
            new ChatRoomMemberIrcImpl(provider, null, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
            Assert.fail((String)"should throw IAE for ChatRoom instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullContactId() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        try {
            new ChatRoomMemberIrcImpl(provider, chatroom, null, "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
            Assert.fail((String)"should throw IAE for ChatRoom instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullIdent() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        try {
            new ChatRoomMemberIrcImpl(provider, chatroom, "user", null, "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
            Assert.fail((String)"should throw IAE for ChatRoom instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullHostname() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        try {
            new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", null, ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
            Assert.fail((String)"should throw IAE for ChatRoom instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullRole() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        try {
            new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", null, IrcStatusEnum.ONLINE);
            Assert.fail((String)"should throw IAE for ChatRoom instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorSuccessful() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        Assert.assertNotNull((Object)new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE));
    }

    public void testCheckGetters() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertEquals((Object)((Object)provider), (Object)member.getProtocolProvider());
        Assert.assertEquals((Object)chatroom, (Object)member.getChatRoom());
        Assert.assertEquals((String)"user", (String)member.getContactAddress());
        Assert.assertEquals((String)"user", (String)member.getName());
        Assert.assertSame((Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)member.getRole());
    }

    public void testNameNull() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertEquals((String)"user", (String)member.getContactAddress());
        Assert.assertEquals((String)"user", (String)member.getName());
        try {
            member.setName(null);
            Assert.fail((String)"expected IAE to be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNameChange() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertEquals((String)"user", (String)member.getContactAddress());
        Assert.assertEquals((String)"user", (String)member.getName());
        member.setName("myNewName");
        Assert.assertEquals((String)"myNewName", (String)member.getContactAddress());
        Assert.assertEquals((String)"myNewName", (String)member.getName());
    }

    public void testRoleNull() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        member.setRole(null);
    }

    public void testRoleUnchange() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertSame((Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)member.getRole());
        member.setRole(ChatRoomMemberRole.ADMINISTRATOR);
        Assert.assertSame((Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)member.getRole());
    }

    public void testAddSignificantRole() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertSame((Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)member.getRole());
        member.addRole(ChatRoomMemberRole.ADMINISTRATOR);
        Assert.assertSame((Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)member.getRole());
    }

    public void testRemoveSignificantRole() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        member.addRole(ChatRoomMemberRole.ADMINISTRATOR);
        Assert.assertSame((Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)member.getRole());
        member.removeRole(ChatRoomMemberRole.ADMINISTRATOR);
        Assert.assertSame((Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)member.getRole());
    }

    public void testAddInsignificantRole() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.ADMINISTRATOR, IrcStatusEnum.ONLINE);
        Assert.assertSame((Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)member.getRole());
        member.addRole(ChatRoomMemberRole.MEMBER);
        Assert.assertSame((Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)member.getRole());
    }

    public void testRemoveInsignificantRole() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.ADMINISTRATOR, IrcStatusEnum.ONLINE);
        member.addRole(ChatRoomMemberRole.MEMBER);
        Assert.assertSame((Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)member.getRole());
        member.removeRole(ChatRoomMemberRole.MEMBER);
        Assert.assertSame((Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)member.getRole());
    }

    public void testGetContact() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        OperationSetPersistentPresenceIrcImpl pp = (OperationSetPersistentPresenceIrcImpl)((Object)EasyMock.createMock(OperationSetPersistentPresenceIrcImpl.class));
        EasyMock.expect((Object)((Object)provider.getPersistentPresence())).andReturn((Object)pp);
        EasyMock.replay((Object[])new Object[]{provider});
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertNull((Object)member.getContact());
    }

    public void testGetAvatar() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertNull((Object)member.getAvatar());
    }

    public void testEqualsSame() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertTrue((boolean)member.equals(member));
    }

    public void testEqualsNull() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertFalse((boolean)member.equals(null));
    }

    public void testEqualsObject() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertFalse((boolean)member.equals(new Object()));
    }

    public void testEqualsSameUserDifferentProvider() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member1 = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        ProtocolProviderServiceIrcImpl provider2 = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member2 = new ChatRoomMemberIrcImpl(provider2, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertFalse((boolean)member1.equals(member2));
    }

    public void testEqualsSameProviderDifferentUser() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member1 = new ChatRoomMemberIrcImpl(provider, chatroom, "user", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        ChatRoomMemberIrcImpl member2 = new ChatRoomMemberIrcImpl(provider, chatroom, "susy", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertFalse((boolean)member1.equals(member2));
    }

    public void testEqualsTrue() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member1 = new ChatRoomMemberIrcImpl(provider, chatroom, "susy", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        ChatRoomMemberIrcImpl member2 = new ChatRoomMemberIrcImpl(provider, chatroom, "susy", "user", "host.name", ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
        Assert.assertTrue((boolean)member1.equals(member2));
    }

    public void testHashcodeNotFailing() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "ET", "user", "host.name", ChatRoomMemberRole.ADMINISTRATOR, IrcStatusEnum.ONLINE);
        member.hashCode();
    }

    public void testGetIdent() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "ET", "user", "host.name", ChatRoomMemberRole.ADMINISTRATOR, IrcStatusEnum.ONLINE);
        Assert.assertEquals((String)"user", (String)member.getIdent());
    }

    public void testGetHostname() {
        ChatRoom chatroom = (ChatRoom)EasyMock.createMock(ChatRoom.class);
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(provider, chatroom, "ET", "user", "host.name", ChatRoomMemberRole.ADMINISTRATOR, IrcStatusEnum.ONLINE);
        Assert.assertEquals((String)"host.name", (String)member.getHostname());
    }
}

