/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.util.Collection;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.impl.protocol.mock.MockStatusEnum;
import net.java.sip.communicator.service.protocol.AbstractContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class MockContact
extends AbstractContact {
    private String contactID = null;
    private boolean isPersistent = true;
    private boolean isResolved = true;
    private MockContactGroup parentGroup = null;
    private MockProvider parentProvider = null;
    private PresenceStatus presenceStatus = MockStatusEnum.MOCK_STATUS_50;

    public MockContact(String id, MockProvider parentProvider) {
        this.contactID = id;
        this.parentProvider = parentProvider;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        Contact contact = (Contact)obj;
        String address = contact.getAddress();
        String thisAddress = this.getAddress();
        return address == null ? thisAddress == null : address.equals(thisAddress);
    }

    public String getAddress() {
        return this.contactID;
    }

    public String getDisplayName() {
        return this.contactID;
    }

    public byte[] getImage() {
        return null;
    }

    public ContactGroup getParentContactGroup() {
        return this.parentGroup;
    }

    public String getPersistentData() {
        return null;
    }

    public PresenceStatus getPresenceStatus() {
        return this.presenceStatus;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.parentProvider;
    }

    public String getStatusMessage() {
        return null;
    }

    public int hashCode() {
        return this.getAddress().hashCode();
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setDisplayName(String displayName) {
        if (this.isResolved) {
            // empty if block
        }
    }

    void setParentGroup(MockContactGroup newParentGroup) {
        this.parentGroup = newParentGroup;
    }

    public void setPresenceStatus(MockStatusEnum mockPresenceStatus) {
        this.presenceStatus = mockPresenceStatus;
    }

    public void setResolved(boolean resolved) {
        this.isResolved = resolved;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("MockContact[ DisplayName=").append(this.getDisplayName()).append("]");
        return buff.toString();
    }

    public boolean supportResources() {
        return false;
    }

    public Collection<ContactResource> getResources() {
        return null;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }
}

