/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.phonenumbercontactsource;

import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.plugin.phonenumbercontactsource.PhoneNumberContactSource;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class PNContactSourceActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(PNContactSourceActivator.class);
    static BundleContext bundleContext = null;
    private static List<ProtocolProviderService> phoneProviders;
    private static ProtocolProviderRegistrationListener ppRegListener;
    private static final PhoneNumberContactSource phoneNumberContactSource;
    private static ResourceManagementService resources;
    private static PhoneNumberI18nService phoneNumberI18nService;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        bundleContext.registerService(ContactSourceService.class.getName(), (Object)phoneNumberContactSource, null);
    }

    public void stop(BundleContext context) throws Exception {
    }

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resources;
    }

    public static List<ProtocolProviderService> getPhoneNumberProviders() {
        if (phoneProviders != null) {
            return phoneProviders;
        }
        phoneProviders = new LinkedList<ProtocolProviderService>();
        ppRegListener = new ProtocolProviderRegistrationListener();
        bundleContext.addServiceListener((ServiceListener)new ProtocolProviderServiceRegListener());
        ServiceReference[] serRefs = null;
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("LoginManager : " + (Object)((Object)e)));
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                    serRef = providerFactory.getProviderForAccount(accountID);
                    ProtocolProviderService protocolProvider = (ProtocolProviderService)bundleContext.getService(serRef);
                    PNContactSourceActivator.handleProviderAdded(protocolProvider);
                }
            }
        }
        return phoneProviders;
    }

    private static void handleProviderAdded(ProtocolProviderService protocolProvider) {
        if (protocolProvider.getOperationSet(OperationSetServerStoredContactInfo.class) != null && !phoneProviders.contains(protocolProvider)) {
            if (protocolProvider.isRegistered()) {
                phoneProviders.add(protocolProvider);
            } else {
                protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)ppRegListener);
            }
        }
    }

    private static void handleProviderRemoved(ProtocolProviderService protocolProvider) {
        if (phoneProviders.contains(protocolProvider)) {
            phoneProviders.remove(protocolProvider);
        }
        protocolProvider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)ppRegListener);
    }

    public static PhoneNumberI18nService getPhoneNumberI18nService() {
        if (phoneNumberI18nService == null) {
            phoneNumberI18nService = (PhoneNumberI18nService)ServiceUtils.getService((BundleContext)bundleContext, PhoneNumberI18nService.class);
        }
        return phoneNumberI18nService;
    }

    static {
        phoneNumberContactSource = new PhoneNumberContactSource();
        resources = null;
    }

    private static class ProtocolProviderRegistrationListener
    implements RegistrationStateChangeListener {
        private ProtocolProviderRegistrationListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            ProtocolProviderService protocolProvider = evt.getProvider();
            if (evt.getNewState() == RegistrationState.REGISTERED && !phoneProviders.contains(protocolProvider)) {
                phoneProviders.add(protocolProvider);
            }
        }
    }

    private static class ProtocolProviderServiceRegListener
    implements ServiceListener {
        private ProtocolProviderServiceRegListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = bundleContext.getService(serviceRef);
            if (!(service instanceof ProtocolProviderService)) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    PNContactSourceActivator.handleProviderAdded((ProtocolProviderService)service);
                    break;
                }
                case 4: {
                    PNContactSourceActivator.handleProviderRemoved((ProtocolProviderService)service);
                }
            }
        }
    }
}

