/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.sipaccregwizz;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.java.sip.communicator.plugin.sipaccregwizz.FirstWizardPage;
import net.java.sip.communicator.plugin.sipaccregwizz.Resources;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccRegWizzActivator;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountCreationFormService;
import net.java.sip.communicator.service.gui.ExtendedDesktopAccountRegWizard;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.SecurityAccountRegistration;
import net.java.sip.communicator.service.protocol.sip.SIPAccountRegistration;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.StringUtils;
import org.osgi.framework.ServiceReference;

public class SIPAccountRegistrationWizard
extends ExtendedDesktopAccountRegWizard {
    private FirstWizardPage firstWizardPage;
    private SIPAccountRegistration registration = new SIPAccountRegistration();
    private ProtocolProviderService protocolProvider;
    private static final Logger logger = Logger.getLogger(SIPAccountRegistrationWizard.class);

    public SIPAccountRegistrationWizard(WizardContainer wizardContainer) {
        this.setWizardContainer(wizardContainer);
        wizardContainer.setFinishButtonText(Resources.getString("service.gui.SIGN_IN"));
    }

    public byte[] getIcon() {
        return Resources.getImage(Resources.SIP_LOGO);
    }

    public byte[] getPageImage() {
        return Resources.getImage(Resources.PAGE_IMAGE);
    }

    public String getProtocolName() {
        return Resources.getString("plugin.sipaccregwizz.PROTOCOL_NAME");
    }

    public String getProtocolDescription() {
        return Resources.getString("plugin.sipaccregwizz.PROTOCOL_DESCRIPTION");
    }

    public Iterator<WizardPage> getPages() {
        return this.getPages(new SIPAccountRegistration());
    }

    public Iterator<WizardPage> getPages(SIPAccountRegistration registration) {
        ArrayList<FirstWizardPage> pages = new ArrayList<FirstWizardPage>();
        this.setRegistration(registration);
        if (this.firstWizardPage == null) {
            this.firstWizardPage = new FirstWizardPage(this);
        }
        pages.add(this.firstWizardPage);
        return pages.iterator();
    }

    public Iterator<Map.Entry<String, String>> getSummary() {
        String serverPort;
        LinkedHashMap<String, String> summaryTable = new LinkedHashMap<String, String>();
        boolean rememberPswd = this.registration.isRememberPassword();
        String rememberPswdString = Resources.getString(rememberPswd ? "service.gui.YES" : "service.gui.NO");
        String displayName = this.registration.getAccountPropertyString((Object)"DISPLAY_NAME");
        if (displayName != null && displayName.length() > 0) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.DISPLAY_NAME"), displayName);
        }
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.USERNAME"), this.registration.getId());
        summaryTable.put(Resources.getString("service.gui.REMEMBER_PASSWORD"), rememberPswdString);
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.REGISTRAR"), this.registration.getServerAddress());
        String authName = this.registration.getAuthorizationName();
        if (authName != null) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.AUTH_NAME"), authName);
        }
        if ((serverPort = this.registration.getServerPort()) != null && serverPort.length() > 0) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.SERVER_PORT"), serverPort);
        }
        if (this.registration.isProxyAutoConfigure()) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.PROXY_AUTO"), Resources.getString("service.gui.YES"));
        } else {
            String proxyPort;
            String proxy = this.registration.getProxy();
            if (proxy != null && proxy.length() > 0) {
                summaryTable.put(Resources.getString("plugin.sipaccregwizz.PROXY"), proxy);
            }
            if ((proxyPort = this.registration.getProxyPort()) != null && proxyPort.length() > 0) {
                summaryTable.put(Resources.getString("plugin.sipaccregwizz.PROXY_PORT"), proxyPort);
            }
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.PREFERRED_TRANSPORT"), this.registration.getPreferredTransport());
        }
        if (this.registration.isEnablePresence()) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.ENABLE_PRESENCE"), Resources.getString("service.gui.YES"));
        } else {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.ENABLE_PRESENCE"), Resources.getString("service.gui.NO"));
        }
        if (this.registration.isForceP2PMode()) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.FORCE_P2P_PRESENCE"), Resources.getString("service.gui.YES"));
        } else {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.FORCE_P2P_PRESENCE"), Resources.getString("service.gui.NO"));
        }
        SecurityAccountRegistration securityReg = this.registration.getSecurityRegistration();
        if (securityReg.isDefaultEncryption()) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.ENABLE_DEFAULT_ENCRYPTION"), Resources.getString("service.gui.YES"));
        } else {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.ENABLE_DEFAULT_ENCRYPTION"), Resources.getString("service.gui.NO"));
        }
        if (securityReg.isSipZrtpAttribute()) {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.ENABLE_SIPZRTP_ATTRIBUTE"), Resources.getString("service.gui.YES"));
        } else {
            summaryTable.put(Resources.getString("plugin.sipaccregwizz.ENABLE_SIPZRTP_ATTRIBUTE"), Resources.getString("service.gui.NO"));
        }
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.OFFLINE_CONTACT_POLLING_PERIOD"), this.registration.getPollingPeriod());
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.SUBSCRIPTION_EXPIRATION"), this.registration.getSubscriptionExpiration());
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.KEEP_ALIVE_METHOD"), this.registration.getKeepAliveMethod());
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.KEEP_ALIVE_INTERVAL"), this.registration.getKeepAliveInterval());
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.DTMF_METHOD"), this.registration.getDTMFMethod());
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.DTMF_MINIMAL_TONE_DURATION"), this.registration.getDtmfMinimalToneDuration());
        if (this.registration.isXCapEnable() || this.registration.isXiVOEnable()) {
            summaryTable.put("XCAP " + Resources.getString("plugin.sipaccregwizz.XCAP_SERVER_URI"), this.registration.getClistOptionServerUri());
            if (this.registration.isClistOptionUseSipCredentials()) {
                summaryTable.put("XCAP " + Resources.getString("plugin.sipaccregwizz.XCAP_USE_SIP_CREDENTIALS"), Resources.getString("service.gui.YES"));
            } else {
                summaryTable.put("XCAP " + Resources.getString("plugin.sipaccregwizz.XCAP_USER"), this.registration.getClistOptionUser());
            }
        }
        if (this.registration.isMessageWaitingIndicationsEnabled()) {
            if (!StringUtils.isNullOrEmpty((String)this.registration.getVoicemailURI(), (boolean)true)) {
                summaryTable.put(Resources.getString("plugin.sipaccregwizz.VOICEMAIL_URI"), this.registration.getVoicemailURI());
            }
            if (!StringUtils.isNullOrEmpty((String)this.registration.getVoicemailCheckURI(), (boolean)true)) {
                summaryTable.put(Resources.getString("plugin.sipaccregwizz.VOICEMAIL_CHECK_URI"), this.registration.getVoicemailURI());
            }
        }
        return summaryTable.entrySet().iterator();
    }

    public ProtocolProviderService signin() throws OperationFailedException {
        this.firstWizardPage.commitPage();
        if (this.firstWizardPage.isCommitted()) {
            return this.signin(this.registration.getId(), this.registration.getPassword());
        }
        return null;
    }

    public ProtocolProviderService signin(String userName, String password) throws OperationFailedException {
        if (userName.startsWith("sip:")) {
            userName = userName.substring(4);
        }
        ProtocolProviderFactory factory = SIPAccRegWizzActivator.getSIPProtocolProviderFactory();
        ProtocolProviderService pps = null;
        if (factory != null) {
            pps = this.installAccount(factory, userName, password);
        }
        return pps;
    }

    private ProtocolProviderService installAccount(ProtocolProviderFactory providerFactory, String userName, String passwd) throws OperationFailedException {
        HashMap<String, String> accountProperties = new HashMap<String, String>();
        String protocolIconPath = this.getProtocolIconPath();
        String accountIconPath = this.getAccountIconPath();
        this.registration.storeProperties(userName, passwd, protocolIconPath, accountIconPath, Boolean.valueOf(this.isModification()), accountProperties);
        accountProperties.put("PROTOCOL_NAME", this.getProtocol());
        if (this.isModification()) {
            accountProperties.put("USER_ID", userName);
            providerFactory.modifyAccount(this.protocolProvider, accountProperties);
            this.setModification(false);
            return this.protocolProvider;
        }
        try {
            AccountID accountID = providerFactory.installAccount(userName, accountProperties);
            ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
            this.protocolProvider = (ProtocolProviderService)SIPAccRegWizzActivator.bundleContext.getService(serRef);
        }
        catch (IllegalStateException exc) {
            logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Account already exists.", 10);
        }
        catch (Exception exc) {
            logger.warn((Object)exc.getMessage());
            throw new OperationFailedException(exc.getMessage(), 1);
        }
        return this.protocolProvider;
    }

    public void loadAccount(ProtocolProviderService protocolProvider) {
        this.setModification(true);
        this.protocolProvider = protocolProvider;
        this.setRegistration(new SIPAccountRegistration());
        AccountID currentAccountID = protocolProvider.getAccountID();
        String password = SIPAccRegWizzActivator.getSIPProtocolProviderFactory().loadPassword(currentAccountID);
        this.registration.loadAccount(protocolProvider.getAccountID(), password, SIPAccRegWizzActivator.bundleContext);
        this.firstWizardPage.loadAccount(protocolProvider);
    }

    public SIPAccountRegistration getRegistration() {
        return this.registration;
    }

    protected void setRegistration(SIPAccountRegistration registration) {
        this.registration = registration;
    }

    public Dimension getSize() {
        return new Dimension(600, 500);
    }

    public Object getFirstPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public Object getLastPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public String getUserNameExample() {
        return "Ex: john@voiphone.net or simply \"john\" for no server";
    }

    public String getWebSignupLinkName() {
        return null;
    }

    public boolean isSignupSupported() {
        return this.getCreateAccountService() != null;
    }

    public boolean isWebSignupSupported() {
        String webSignupLinkName = this.getWebSignupLinkName();
        return webSignupLinkName != null && webSignupLinkName.length() > 0;
    }

    public void setCreateAccountView() {
        if (this.getCreateAccountService() != null) {
            this.firstWizardPage.getRegistrationForm().setCreateButtonSelected();
        }
    }

    public Object getSimpleForm(boolean isCreateAccount) {
        return this.getSimpleForm(new SIPAccountRegistration(), isCreateAccount);
    }

    public Object getSimpleForm(SIPAccountRegistration registration, boolean isCreateAccount) {
        this.setRegistration(registration);
        this.firstWizardPage = new FirstWizardPage(this);
        return this.firstWizardPage.getSimpleForm();
    }

    public String getProtocol() {
        return "SIP";
    }

    public String getProtocolIconPath() {
        return null;
    }

    public String getAccountIconPath() {
        return null;
    }

    protected SIPAccountCreationFormService getCreateAccountService() {
        return null;
    }

    protected String getUsernameLabel() {
        return Resources.getString("plugin.sipaccregwizz.USERNAME");
    }

    protected String getExistingAccountLabel() {
        return Resources.getString("plugin.sipaccregwizz.EXISTING_ACCOUNT");
    }

    protected String getCreateAccountLabel() {
        return Resources.getString("plugin.sipaccregwizz.CREATE_ACCOUNT");
    }
}

