/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;
import org.jitsi.util.concurrent.MonotonicAtomicLong;

public class RawPacketCache
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(RawPacketCache.class);
    private static final ConfigurationService cfg = LibJitsi.getConfigurationService();
    public static final String NACK_CACHE_SIZE_STREAMS = "org.jitsi.impl.neomedia.transform.CachingTransformer.CACHE_SIZE_STREAMS";
    public static final String NACK_CACHE_SIZE_PACKETS = "org.jitsi.impl.neomedia.transform.CachingTransformer.CACHE_SIZE_PACKETS";
    public static final String NACK_CACHE_SIZE_MILLIS = "org.jitsi.impl.neomedia.transform.CachingTransformer.CACHE_SIZE_MILLIS";
    private static int SIZE_MILLIS = cfg.getInt("org.jitsi.impl.neomedia.transform.CachingTransformer.CACHE_SIZE_MILLIS", 500);
    private static int RTP_CLOCK_RATE = 90000;
    private static int SIZE_RTP_CLOCK_TICKS = RTP_CLOCK_RATE / 1000 * SIZE_MILLIS;
    private static int MAX_SSRC_COUNT = cfg.getInt("org.jitsi.impl.neomedia.transform.CachingTransformer.CACHE_SIZE_STREAMS", 50);
    private static int MAX_SIZE_PACKETS = cfg.getInt("org.jitsi.impl.neomedia.transform.CachingTransformer.CACHE_SIZE_PACKETS", 200);
    private static int POOL_SIZE = 100;
    private static int SSRC_TIMEOUT_MILLIS = SIZE_MILLIS + 50;
    private final Queue<RawPacket> pool = new LinkedBlockingQueue<RawPacket>(POOL_SIZE);
    private final Queue<Container> containersPool = new LinkedBlockingQueue<Container>(POOL_SIZE);
    private final Object sizesSyncRoot = new Object();
    private int sizeInBytes = 0;
    private int maxSizeInBytes = 0;
    private int sizeInPackets = 0;
    private int maxSizeInPackets = 0;
    private AtomicInteger totalHits = new AtomicInteger(0);
    private AtomicInteger totalMisses = new AtomicInteger(0);
    private AtomicInteger totalPacketsAdded = new AtomicInteger(0);
    private final Map<Long, Cache> caches = new HashMap<Long, Cache>();
    private MonotonicAtomicLong oldestHit = new MonotonicAtomicLong();
    private final int streamId;

    private static boolean lessThanTS(long a, long b) {
        if (a == b) {
            return false;
        }
        if (a > b) {
            return a - b >= 0x80000000L;
        }
        return b - a < 0x80000000L;
    }

    public RawPacketCache(int streamId) {
        this.streamId = streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.totalPacketsAdded.get() > 0) {
            logger.info(Logger.Category.STATISTICS, "closed,stream=" + this.streamId + " max_size_bytes=" + this.maxSizeInBytes + ",max_size_packets=" + this.maxSizeInPackets + ",total_hits=" + this.totalHits.get() + ",total_misses=" + this.totalMisses.get() + ",total_packets=" + this.totalPacketsAdded.get() + ",oldest_hit_ms=" + this.oldestHit);
        }
        Map<Long, Cache> map = this.caches;
        synchronized (map) {
            this.caches.clear();
        }
        this.pool.clear();
        this.containersPool.clear();
    }

    public Container getContainer(long ssrc, int seq) {
        Container container;
        Cache cache = this.getCache(ssrc & 0xFFFFFFFFL, false);
        Container container2 = container = cache != null ? cache.get(seq) : null;
        if (container != null) {
            if (container.timeAdded > 0L) {
                this.oldestHit.increase(System.currentTimeMillis() - container.timeAdded);
            }
            this.totalHits.incrementAndGet();
        } else {
            this.totalMisses.incrementAndGet();
        }
        return container;
    }

    public RawPacket get(long ssrc, int seq) {
        Container container = this.getContainer(ssrc, seq);
        return container == null ? null : container.pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache(long ssrc, boolean create) {
        Map<Long, Cache> map = this.caches;
        synchronized (map) {
            Cache cache = this.caches.get(ssrc);
            if (cache == null && create) {
                if (this.caches.size() < MAX_SSRC_COUNT) {
                    cache = new Cache();
                    this.caches.put(ssrc, cache);
                } else {
                    logger.warn("Not creating a new cache for SSRC " + ssrc + ": too many SSRCs already cached.");
                }
            }
            return cache;
        }
    }

    public void cachePacket(RawPacket pkt) {
        Cache cache = this.getCache(pkt.getSSRCAsLong(), true);
        if (cache != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Caching a packet. SSRC=" + pkt.getSSRCAsLong() + " seq=" + pkt.getSequenceNumber());
            }
            cache.insert(pkt);
            this.totalPacketsAdded.incrementAndGet();
        }
    }

    private RawPacket getFreePacket(int len) {
        RawPacket pkt = this.pool.poll();
        if (pkt == null) {
            pkt = new RawPacket(new byte[len], 0, 0);
        }
        if (pkt.getBuffer() == null || pkt.getBuffer().length < len) {
            pkt.setBuffer(new byte[len]);
        }
        pkt.setOffset(0);
        pkt.setLength(0);
        return pkt;
    }

    private Container getFreeContainer() {
        Container container = this.containersPool.poll();
        if (container == null) {
            container = new Container();
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(long now) {
        Map<Long, Cache> map = this.caches;
        synchronized (map) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaning CachingTransformer " + this.hashCode());
            }
            Iterator<Map.Entry<Long, Cache>> iter = this.caches.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, Cache> entry = iter.next();
                Cache cache = entry.getValue();
                if (cache.lastInsertTime + (long)SSRC_TIMEOUT_MILLIS >= now) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing cache for SSRC " + entry.getKey());
                }
                cache.empty();
                iter.remove();
            }
        }
    }

    private void returnContainer(Container container) {
        if (container != null) {
            if (container.pkt != null) {
                this.pool.offer(container.pkt);
            }
            container.pkt = null;
            this.containersPool.offer(container);
        }
    }

    public class Container {
        public RawPacket pkt;
        public long timeAdded;

        public Container() {
            this(null, -1L);
        }

        public Container(RawPacket pkt, long timeAdded) {
            this.pkt = pkt;
            this.timeAdded = timeAdded;
        }
    }

    private class Cache {
        private TreeMap<Integer, Container> cache = new TreeMap();
        private long lastInsertTime = -1L;
        private int ROC = 0;
        private int s_l = -1;

        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void insert(RawPacket pkt) {
            int len = pkt.getLength();
            RawPacket cachePacket = RawPacketCache.this.getFreePacket(len);
            System.arraycopy(pkt.getBuffer(), pkt.getOffset(), cachePacket.getBuffer(), 0, len);
            cachePacket.setLength(len);
            int index = this.calculateIndex(pkt.getSequenceNumber());
            Container container = RawPacketCache.this.getFreeContainer();
            container.pkt = cachePacket;
            container.timeAdded = System.currentTimeMillis();
            Container oldContainer = this.cache.put(index, container);
            Object object = RawPacketCache.this.sizesSyncRoot;
            synchronized (object) {
                RawPacketCache.this.sizeInPackets++;
                RawPacketCache.this.sizeInBytes = RawPacketCache.this.sizeInBytes + len;
                if (oldContainer != null) {
                    RawPacketCache.this.sizeInPackets--;
                    RawPacketCache.this.sizeInBytes = RawPacketCache.this.sizeInBytes - oldContainer.pkt.getLength();
                }
                if (RawPacketCache.this.sizeInPackets > RawPacketCache.this.maxSizeInPackets) {
                    RawPacketCache.this.maxSizeInPackets = RawPacketCache.this.sizeInPackets;
                }
                if (RawPacketCache.this.sizeInBytes > RawPacketCache.this.maxSizeInBytes) {
                    RawPacketCache.this.maxSizeInBytes = RawPacketCache.this.sizeInBytes;
                }
            }
            RawPacketCache.this.returnContainer(oldContainer);
            this.lastInsertTime = System.currentTimeMillis();
            this.clean();
        }

        private int calculateIndex(int seq) {
            if (this.s_l == -1) {
                this.s_l = seq;
                return seq;
            }
            int v = this.ROC;
            if (this.s_l < 32768) {
                if (seq - this.s_l > 32768) {
                    v = (int)((long)(this.ROC - 1) % 0x100000000L);
                } else if (this.s_l - 65536 > seq) {
                    v = (int)((long)(this.ROC + 1) % 0x100000000L);
                }
            }
            if (v == this.ROC && seq > this.s_l) {
                this.s_l = seq;
            } else if ((long)v == (long)(this.ROC + 1) % 0x100000000L) {
                this.s_l = seq;
                this.ROC = v;
            }
            return seq + v * 65536;
        }

        private synchronized Container get(int seq) {
            Container pkt = this.cache.get(seq + this.ROC * 65536);
            if (pkt == null && this.ROC > 0) {
                pkt = this.cache.get(seq + (this.ROC - 1) * 65536);
            }
            return pkt == null ? null : new Container(new RawPacket((byte[])pkt.pkt.getBuffer().clone(), pkt.pkt.getOffset(), pkt.pkt.getLength()), pkt.timeAdded);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void clean() {
            int size = this.cache.size();
            if (size <= 0) {
                return;
            }
            long lastTimestamp = 0xFFFFFFFFL & this.cache.lastEntry().getValue().pkt.getTimestamp();
            long cleanBefore = this.getCleanBefore(lastTimestamp);
            Iterator<Map.Entry<Integer, Container>> iter = this.cache.entrySet().iterator();
            int removedPackets = 0;
            int removedBytes = 0;
            while (iter.hasNext()) {
                Container container = iter.next().getValue();
                RawPacket pkt = container.pkt;
                if (size > MAX_SIZE_PACKETS) {
                    --size;
                } else if (RawPacketCache.lessThanTS(cleanBefore, 0xFFFFFFFFL & pkt.getTimestamp())) break;
                iter.remove();
                removedBytes += pkt.getLength();
                ++removedPackets;
                RawPacketCache.this.returnContainer(container);
            }
            Object object = RawPacketCache.this.sizesSyncRoot;
            synchronized (object) {
                RawPacketCache.this.sizeInBytes = RawPacketCache.this.sizeInBytes - removedBytes;
                RawPacketCache.this.sizeInPackets = RawPacketCache.this.sizeInPackets - removedPackets;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void empty() {
            int removedBytes = 0;
            for (Container container : this.cache.values()) {
                removedBytes += container.pkt.getBuffer().length;
                RawPacketCache.this.returnContainer(container);
            }
            Object object = RawPacketCache.this.sizesSyncRoot;
            synchronized (object) {
                RawPacketCache.this.sizeInPackets = RawPacketCache.this.sizeInPackets - this.cache.size();
                RawPacketCache.this.sizeInBytes = RawPacketCache.this.sizeInBytes - removedBytes;
            }
            this.cache.clear();
        }

        private long getCleanBefore(long ts) {
            return (ts + 0x100000000L - (long)SIZE_RTP_CLOCK_TICKS) % 0x100000000L;
        }
    }
}

