/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtp.FrameDesc;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.util.Logger;
import org.jitsi.util.TimeUtils;

public class MediaStreamTrackDesc {
    private static final Logger logger = Logger.getLogger(MediaStreamTrackDesc.class);
    private static final int MIN_KEY_FRAME_WAIT_MS = 300;
    private static final int SUSPENSION_THRESHOLD_MS = 100;
    private final RTPEncodingDesc[] rtpEncodings;
    private final MediaStreamTrackReceiver mediaStreamTrackReceiver;
    private final Statistics statistics = new Statistics();

    public MediaStreamTrackDesc(MediaStreamTrackReceiver mediaStreamTrackReceiver, RTPEncodingDesc[] rtpEncodings) {
        this.rtpEncodings = rtpEncodings;
        this.mediaStreamTrackReceiver = mediaStreamTrackReceiver;
    }

    public void srReceived(RTCPSRPacket sr) {
        long sendTimeMs = TimeUtils.getTime(TimeUtils.constuctNtp(sr.ntptimestampmsw, sr.ntptimestamplsw));
        long latencyMs = System.currentTimeMillis() - sendTimeMs;
        if (latencyMs < 0L) {
            this.statistics.latencyMs = 0L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("latency=" + this.statistics.latencyMs);
        }
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public RTPEncodingDesc[] getRTPEncodings() {
        return this.rtpEncodings;
    }

    public MediaStreamTrackReceiver getMediaStreamTrackReceiver() {
        return this.mediaStreamTrackReceiver;
    }

    RawPacket[] reverseTransform(RawPacket pkt, RTPEncodingDesc encoding) {
        long nowMs = System.currentTimeMillis();
        FrameDesc frameDesc = encoding.update(pkt, nowMs);
        if (frameDesc == null) {
            return null;
        }
        boolean deactivated = false;
        boolean activated = !encoding.isActive() && !frameDesc.isIndependent();
        for (int i = encoding.getIndex() + 1; i < this.rtpEncodings.length; ++i) {
            RTPEncodingDesc enc = this.rtpEncodings[i];
            FrameDesc lastReceivedFrame = enc.getLastReceivedFrame();
            if (lastReceivedFrame == null) continue;
            long silentIntervalMs = nowMs - lastReceivedFrame.getReceivedMs();
            if (!enc.isActive() || silentIntervalMs <= 100L) continue;
            deactivated = true;
            this.rtpEncodings[i].setActive(false);
            logger.info("suspended,stream=" + this.mediaStreamTrackReceiver.getStream().hashCode() + " ssrc=" + enc.getPrimarySSRC());
        }
        if (deactivated || activated) {
            ((RTPTranslatorImpl)this.mediaStreamTrackReceiver.getStream().getRTPTranslator()).getRtcpFeedbackMessageSender().sendFIR((int)this.rtpEncodings[0].getPrimarySSRC());
        }
        if (!frameDesc.isIndependent() || nowMs - this.statistics.lastKeyframeMs < 300L) {
            return null;
        }
        this.statistics.lastKeyframeMs = nowMs;
        boolean isActive = false;
        for (int i = this.rtpEncodings.length - 1; i >= 0; --i) {
            if (!isActive && this.rtpEncodings[i].requires(encoding.getIndex())) {
                isActive = true;
            }
            this.rtpEncodings[i].setActive(isActive);
        }
        RawPacket[] extras = null;
        if (!frameDesc.isSofInOrder()) {
            RawPacketCache inCache = this.mediaStreamTrackReceiver.getStream().getCachingTransformer().getIncomingRawPacketCache();
            int start = frameDesc.getStart();
            int len = frameDesc.getMaxSeen() - start & 0xFFFF;
            extras = new RawPacket[len];
            for (int i = 1; i <= len; ++i) {
                extras[i] = inCache.get(encoding.getPrimarySSRC(), start + i & 0xFFFF);
            }
        }
        return extras;
    }

    public RTPEncodingDesc findRTPEncodingDesc(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len) {
            return null;
        }
        for (RTPEncodingDesc encoding : this.rtpEncodings) {
            if (!encoding.matches(buf, off, len)) continue;
            return encoding;
        }
        return null;
    }

    public FrameDesc findFrameDesc(byte[] buf, int off, int len) {
        RTPEncodingDesc rtpEncoding = this.findRTPEncodingDesc(buf, off, len);
        if (rtpEncoding == null) {
            return null;
        }
        return rtpEncoding.findFrameDesc(buf, off, len);
    }

    public boolean matches(long ssrc) {
        return this.rtpEncodings[0].getPrimarySSRC() == ssrc;
    }

    public static class Statistics {
        private long lastKeyframeMs = -1L;
        long latencyMs = -1L;

        public long getLatencyMs() {
            return this.latencyMs;
        }
    }
}

