/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.fileaccess;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jitsi.impl.fileaccess.FailSafeTransactionImpl;
import org.jitsi.impl.fileaccess.TempFileManager;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FailSafeTransaction;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

public class FileAccessServiceImpl
implements FileAccessService {
    private static final Logger logger = Logger.getLogger(FileAccessServiceImpl.class);
    public static final String TEMP_FILE_PREFIX = "SIPCOMM";
    public static final String TEMP_FILE_SUFFIX = "TEMP";
    private String profileDirLocation;
    private String cacheDirLocation;
    private String logDirLocation;
    private String scHomeDirName;
    private boolean initialized = false;
    private static Map<String, Object> OPT;

    @Override
    public File getTemporaryFile() throws IOException {
        File retVal = null;
        try {
            logger.logEntry();
            retVal = TempFileManager.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        finally {
            logger.logExit();
        }
        return retVal;
    }

    @Override
    public File getTemporaryDirectory() throws IOException {
        File file = this.getTemporaryFile();
        if (!file.delete()) {
            throw new IOException("Could not create temporary directory, because: could not delete temporary file.");
        }
        if (!file.mkdirs()) {
            throw new IOException("Could not create temporary directory");
        }
        return file;
    }

    @Override
    @Deprecated
    public File getPrivatePersistentFile(String fileName) throws Exception {
        return this.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getPrivatePersistentFile(String fileName, FileCategory category) throws Exception {
        logger.logEntry();
        File file = null;
        try {
            file = FileAccessServiceImpl.accessibleFile(this.getFullPath(category), fileName);
            if (file == null) {
                throw new SecurityException("Insufficient rights to access this file in current user's home directory: " + new File(this.getFullPath(category), fileName).getPath());
            }
        }
        finally {
            logger.logExit();
        }
        return file;
    }

    @Override
    @Deprecated
    public File getPrivatePersistentDirectory(String dirName) throws Exception {
        return this.getPrivatePersistentDirectory(dirName, FileCategory.PROFILE);
    }

    @Override
    public File getPrivatePersistentDirectory(String dirName, FileCategory category) throws Exception {
        File dir = new File(this.getFullPath(category), dirName);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new RuntimeException("Could not create directory because: A file exists with this name:" + dir.getAbsolutePath());
            }
        } else if (!dir.mkdirs()) {
            throw new IOException("Could not create directory");
        }
        return dir;
    }

    private File getFullPath(FileCategory category) {
        String directory;
        this.initialize();
        switch (category) {
            case CACHE: {
                directory = this.cacheDirLocation;
                break;
            }
            case LOG: {
                directory = this.logDirLocation;
                break;
            }
            default: {
                directory = this.profileDirLocation;
            }
        }
        return new File(directory, this.scHomeDirName);
    }

    private static String getSystemProperty(String propertyName) {
        String retval = System.getProperty(propertyName);
        if (retval == null) {
            return retval;
        }
        if (retval.trim().length() == 0) {
            return null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File accessibleFile(File homedir, String fileName) throws IOException {
        File file = null;
        try {
            logger.logEntry();
            file = new File(homedir, fileName);
            if (file.canRead() || file.canWrite()) {
                File file2 = file;
                return file2;
            }
            if (!homedir.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating home directory : " + homedir.getAbsolutePath());
                }
                if (!homedir.mkdirs()) {
                    String message = "Could not create the home directory : " + homedir.getAbsolutePath();
                    if (logger.isDebugEnabled()) {
                        logger.debug(message);
                    }
                    throw new IOException(message);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Home directory created : " + homedir.getAbsolutePath());
                }
            } else if (!homedir.canWrite()) {
                file = null;
            }
            if (file != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                String message = "Could not create the parent directory : " + homedir.getAbsolutePath();
                logger.debug(message);
                throw new IOException(message);
            }
        }
        finally {
            logger.logExit();
        }
        return file;
    }

    @Override
    public File getDefaultDownloadDirectory() throws IOException {
        if (OSUtils.IS_WINDOWS) {
            if (FileAccessServiceImpl.getMajorOSVersion() < 6) {
                char[] pszPath = new char[260];
                int hResult = Shell32.INSTANCE.SHGetFolderPath(null, 5, null, 0, pszPath);
                if (hResult == 0) {
                    String path = new String(pszPath);
                    return new File(path.substring(0, path.indexOf(0)));
                }
            } else {
                GUID g = new GUID();
                g.data1 = 927851152;
                g.data2 = (short)4671;
                g.data3 = (short)17765;
                g.data4 = new byte[]{-111, 100, 57, -60, -110, 94, 70, 123};
                PointerByReference pszPath = new PointerByReference();
                int hResult = Shell32.INSTANCE.SHGetKnownFolderPath(g, 34816, null, pszPath);
                if (hResult == 0) {
                    File f = new File(pszPath.getValue().getWideString(0L));
                    Ole32.INSTANCE.CoTaskMemFree(pszPath.getValue());
                    return f;
                }
            }
        }
        return new File(FileAccessServiceImpl.getSystemProperty("user.home"), "Downloads");
    }

    private static int getMajorOSVersion() {
        int majorOSVersion;
        String osVersion = System.getProperty("os.version");
        if (osVersion != null && osVersion.length() > 0) {
            int majorOSVersionEnd = osVersion.indexOf(46);
            String majorOSVersionString = majorOSVersionEnd > -1 ? osVersion.substring(0, majorOSVersionEnd) : osVersion;
            majorOSVersion = Integer.parseInt(majorOSVersionString);
        } else {
            majorOSVersion = 0;
        }
        return majorOSVersion;
    }

    @Override
    public FailSafeTransaction createFailSafeTransaction(File file) {
        return file == null ? null : new FailSafeTransactionImpl(file);
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        String string = this.profileDirLocation = cfg != null ? cfg.getScHomeDirLocation() : FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
        if (this.profileDirLocation == null) {
            throw new IllegalStateException("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
        }
        String string2 = this.scHomeDirName = cfg != null ? cfg.getScHomeDirName() : FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
        if (this.scHomeDirName == null) {
            throw new IllegalStateException("net.java.sip.communicator.SC_HOME_DIR_NAME");
        }
        String cacheDir = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_CACHE_DIR_LOCATION");
        this.cacheDirLocation = cacheDir == null ? this.profileDirLocation : cacheDir;
        String logDir = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_LOG_DIR_LOCATION");
        this.logDirLocation = logDir == null ? this.profileDirLocation : logDir;
        this.initialized = true;
    }

    static /* synthetic */ Map access$100() {
        return OPT;
    }

    static {
        if (OSUtils.IS_WINDOWS) {
            OPT = new HashMap<String, Object>();
            OPT.put("type-mapper", W32APITypeMapper.UNICODE);
            OPT.put("function-mapper", W32APIFunctionMapper.UNICODE);
        }
    }

    private static interface Ole32
    extends Library {
        public static final Ole32 INSTANCE = (Ole32)Native.loadLibrary((String)"Ole32", Ole32.class, (Map)FileAccessServiceImpl.access$100());

        public void CoTaskMemFree(Pointer var1);
    }

    private static interface Shell32
    extends Library {
        public static final int MAX_PATH = 260;
        public static final int CSIDL_MYDOCUMENTS = 5;
        public static final int SHGFP_TYPE_CURRENT = 0;
        public static final int S_OK = 0;
        public static final int KF_FLAG_INIT = 2048;
        public static final int KF_FLAG_CREATE = 32768;
        public static final Shell32 INSTANCE = (Shell32)Native.loadLibrary((String)"shell32", Shell32.class, (Map)FileAccessServiceImpl.access$100());

        public int SHGetFolderPath(HWND var1, int var2, HANDLE var3, int var4, char[] var5);

        public int SHGetKnownFolderPath(GUID var1, int var2, HANDLE var3, PointerByReference var4);
    }

    public static class GUID
    extends Structure {
        public int data1;
        public short data2;
        public short data3;
        public byte[] data4;

        protected List<String> getFieldOrder() {
            return Arrays.asList("data1", "data2", "data3", "data4");
        }
    }

    private static class HWND
    extends HANDLE {
        private HWND() {
        }
    }

    private static class HANDLE
    extends PointerType
    implements NativeMapped {
        private HANDLE() {
        }
    }
}

