/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.sip.address.Address;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.xcap.HttpXCapClient;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapException;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapHttpResponse;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapResource;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapResourceId;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.ParsingException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.XCapError;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.XCapErrorParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.XCapErrorType;
import net.java.sip.communicator.impl.protocol.sip.xcap.utils.StreamUtils;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.httputil.HttpUtils;
import net.java.sip.communicator.util.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.osgi.framework.ServiceReference;

public abstract class BaseHttpXCapClient
implements HttpXCapClient {
    private static final Logger logger = Logger.getLogger(BaseHttpXCapClient.class);
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String XCAP_ERROR_CONTENT_TYPE = "application/xcap-error+xml";
    protected URI uri;
    protected Address userAddress;
    private String username;
    private String password;
    private boolean connected;
    private CertificateService certificateVerification;

    public BaseHttpXCapClient() {
        ServiceReference guiVerifyReference = SipActivator.getBundleContext().getServiceReference(CertificateService.class.getName());
        if (guiVerifyReference != null) {
            this.certificateVerification = (CertificateService)SipActivator.getBundleContext().getService(guiVerifyReference);
        }
    }

    @Override
    public void connect(URI uri, Address userAddress, String username, String password) throws XCapException {
        if (!userAddress.getURI().isSipURI()) {
            throw new IllegalArgumentException("Address must contains SipUri");
        }
        this.uri = uri;
        this.userAddress = (Address)userAddress.clone();
        this.username = username;
        this.password = password == null ? "" : password;
        this.connected = true;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect() {
        this.uri = null;
        this.userAddress = null;
        this.password = null;
        this.connected = false;
    }

    @Override
    public XCapHttpResponse get(XCapResourceId resourceId) throws XCapException {
        return this.get(this.getResourceURI(resourceId));
    }

    protected XCapHttpResponse get(URI uri) throws XCapException {
        DefaultHttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient();
            HttpGet getMethod = new HttpGet(uri);
            getMethod.setHeader("Connection", "close");
            HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
            XCapHttpResponse result = this.createResponse(response);
            if (logger.isDebugEnabled()) {
                byte[] contentBytes = result.getContent();
                String contenString = contentBytes != null && result.getContentType() != null && !result.getContentType().startsWith("application/vnd.oma.pres-content+xml") ? new String(contentBytes) : "";
                String logMessage = String.format("Getting resource %1s from the server content:%2s", uri.toString(), contenString);
                logger.debug((Object)logMessage);
            }
            XCapHttpResponse xCapHttpResponse = result;
            return xCapHttpResponse;
        }
        catch (UnknownHostException uhe) {
            BaseHttpXCapClient.showError(uhe, null, null);
            this.disconnect();
            throw new XCapException(uhe.getMessage(), uhe);
        }
        catch (IOException e) {
            String errorMessage = SipActivator.getResources().getI18NString("impl.protocol.sip.XCAP_ERROR_RESOURCE_ERR", new String[]{uri.toString(), this.userAddress.getDisplayName()});
            BaseHttpXCapClient.showError(e, null, errorMessage);
            throw new XCapException(errorMessage, e);
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    static void showError(Exception ex, String title, String message) {
        try {
            if (title == null) {
                title = SipActivator.getResources().getI18NString("impl.protocol.sip.XCAP_ERROR_TITLE");
            }
            if (message == null) {
                message = title + "\n" + ex.getClass().getName() + ": " + ex.getLocalizedMessage();
            }
            if (SipActivator.getUIService() != null) {
                SipActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)message, title, 0);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error for error dialog", t);
        }
    }

    @Override
    public XCapHttpResponse put(XCapResource resource) throws XCapException {
        DefaultHttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient();
            URI resourceUri = this.getResourceURI(resource.getId());
            HttpPut putMethod = new HttpPut(resourceUri);
            putMethod.setHeader("Connection", "close");
            StringEntity stringEntity = new StringEntity(resource.getContent());
            stringEntity.setContentType(resource.getContentType());
            stringEntity.setContentEncoding("UTF-8");
            putMethod.setEntity((HttpEntity)stringEntity);
            if (logger.isDebugEnabled()) {
                String logMessage = String.format("Puting resource %1s to the server %2s", resource.getId().toString(), resource.getContent());
                logger.debug((Object)logMessage);
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)putMethod);
            XCapHttpResponse xCapHttpResponse = this.createResponse(response);
            return xCapHttpResponse;
        }
        catch (IOException e) {
            String errorMessage = String.format("%1s resource cannot be put", resource.getId().toString());
            throw new XCapException(errorMessage, e);
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    @Override
    public XCapHttpResponse delete(XCapResourceId resourceId) throws XCapException {
        this.assertConnected();
        DefaultHttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient();
            URI resourceUri = this.getResourceURI(resourceId);
            HttpDelete deleteMethod = new HttpDelete(resourceUri);
            deleteMethod.setHeader("Connection", "close");
            if (logger.isDebugEnabled()) {
                String logMessage = String.format("Deleting resource %1s from the server", resourceId.toString());
                logger.debug((Object)logMessage);
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)deleteMethod);
            XCapHttpResponse xCapHttpResponse = this.createResponse(response);
            return xCapHttpResponse;
        }
        catch (IOException e) {
            String errorMessage = String.format("%1s resource cannot be deleted", resourceId.toString());
            throw new XCapException(errorMessage, e);
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    protected void assertConnected() {
        if (!this.connected) {
            throw new IllegalStateException("User is not connected to the server");
        }
    }

    protected URI getResourceURI(XCapResourceId resourceId) {
        try {
            return new URI(this.uri.toString() + "/" + resourceId);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid XCAP resource identifier", e);
        }
    }

    private DefaultHttpClient createHttpClient() throws IOException {
        XCapCredentialsProvider credentialsProvider = new XCapCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUserName(), this.password));
        return HttpUtils.getHttpClient(null, null, (String)this.uri.getHost(), (CredentialsProvider)credentialsProvider);
    }

    private XCapHttpResponse createResponse(HttpResponse response) throws IOException {
        XCapHttpResponse xcapHttpResponse = new XCapHttpResponse();
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200 || statusCode == 201 || statusCode == 409) {
            String contentType = BaseHttpXCapClient.getSingleHeaderValue(response, HEADER_CONTENT_TYPE);
            byte[] content = StreamUtils.read(response.getEntity().getContent());
            String eTag = BaseHttpXCapClient.getSingleHeaderValue(response, HEADER_ETAG);
            xcapHttpResponse.setContentType(contentType);
            xcapHttpResponse.setContent(content);
            xcapHttpResponse.setETag(eTag);
        }
        xcapHttpResponse.setHttpCode(statusCode);
        return xcapHttpResponse;
    }

    private static String readResponse(HttpResponse response) throws IOException {
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity.getContentLength() == 0L) {
            return "";
        }
        byte[] content = StreamUtils.read(responseEntity.getContent());
        return new String(content, "UTF-8");
    }

    protected static String getSingleHeaderValue(HttpResponse response, String headerName) {
        Header[] headers = response.getHeaders(headerName);
        if (headers != null && headers.length > 0) {
            return headers[0].getValue();
        }
        return null;
    }

    protected String getXCapErrorMessage(XCapHttpResponse response) {
        int httpCode = response.getHttpCode();
        String contentType = response.getContentType();
        try {
            if (httpCode != 409 || contentType == null || !contentType.startsWith(XCAP_ERROR_CONTENT_TYPE)) {
                return null;
            }
            String content = new String(response.getContent());
            XCapErrorType xCapError = XCapErrorParser.fromXml(content);
            XCapError error = xCapError.getError();
            if (error == null) {
                return null;
            }
            return error.getPhrase();
        }
        catch (ParsingException e) {
            logger.error((Object)"XCapError cannot be parsed.");
            return null;
        }
    }

    private class XCapCredentialsProvider
    implements CredentialsProvider {
        private Credentials credentials;

        private XCapCredentialsProvider() {
        }

        public void setCredentials(AuthScope authscope, Credentials credentials) {
            this.credentials = credentials;
        }

        public Credentials getCredentials(AuthScope authscope) {
            return this.credentials;
        }

        public void clear() {
            this.credentials = null;
        }
    }
}

