/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.MinExpiresHeader;
import javax.sip.header.SIPETagHeader;
import javax.sip.header.SIPIfMatchHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ContactGroupSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.EventPackageNotifier;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSubscriber;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSupport;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessor;
import net.java.sip.communicator.impl.protocol.sip.OperationSetContactTypeInfoImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ServerStoredContactList;
import net.java.sip.communicator.impl.protocol.sip.ServerStoredContactListSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ServerStoredContactListXivoImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.SipRegistrarlessConnection;
import net.java.sip.communicator.impl.protocol.sip.SipStatusEnum;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.protocol.AbstractOperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetContactTypeInfo;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OperationSetPresenceSipImpl
extends AbstractOperationSetPersistentPresence<ProtocolProviderServiceSipImpl>
implements MethodProcessor,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(OperationSetPresenceSipImpl.class);
    private ServerStoredContactList ssContactList;
    private String statusMessage = "Default Status Message";
    private PresenceStatus presenceStatus;
    private final List<String> waitedCallIds = new Vector<String>();
    private boolean useDistantPA;
    private String distantPAET = null;
    private static final int PRESENCE_DEFAULT_EXPIRE = 3600;
    private static final int REFRESH_MARGIN = 60;
    private final int subscriptionDuration;
    private static long publish_cseq = 1L;
    private final TimerScheduler timer = new TimerScheduler();
    private RePublishTask republishTask = null;
    private final int pollingTaskPeriod;
    private PollOfflineContactsTask pollingTask = null;
    private final boolean presenceEnabled;
    private final SipStatusEnum sipStatusEnum;
    private static final String TUPLE_ID = "t" + (long)(Math.random() * 10000.0);
    private static final String PERSON_ID = "p" + (long)(Math.random() * 10000.0);
    private static final String PIDF_XML = "pidf+xml";
    private static final String WATCHERINFO_XML = "watcherinfo+xml";
    private static final String PRESENCE_ELEMENT = "presence";
    private static final String NS_ELEMENT = "xmlns";
    private static final String PIDF_NS_VALUE = "urn:ietf:params:xml:ns:pidf";
    private static final String ENTITY_ATTRIBUTE = "entity";
    private static final String TUPLE_ELEMENT = "tuple";
    private static final String ID_ATTRIBUTE = "id";
    private static final String STATUS_ELEMENT = "status";
    private static final String ONLINE_STATUS = "open";
    private static final String OFFLINE_STATUS = "closed";
    private static final String BASIC_ELEMENT = "basic";
    private static final String CONTACT_ELEMENT = "contact";
    private static final String NOTE_ELEMENT = "note";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String RPID_NS_ELEMENT = "xmlns:rpid";
    private static final String RPID_NS_VALUE = "urn:ietf:params:xml:ns:pidf:rpid";
    private static final String DM_NS_ELEMENT = "xmlns:dm";
    private static final String DM_NS_VALUE = "urn:ietf:params:xml:ns:pidf:data-model";
    private static final String PERSON_ELEMENT = "person";
    private static final String NS_PERSON_ELT = "dm:person";
    private static final String ACTIVITY_ELEMENT = "activities";
    private static final String NS_ACTIVITY_ELT = "rpid:activities";
    private static final String AWAY_ELEMENT = "away";
    private static final String NS_AWAY_ELT = "rpid:away";
    private static final String BUSY_ELEMENT = "busy";
    private static final String NS_BUSY_ELT = "rpid:busy";
    private static final String OTP_ELEMENT = "on-the-phone";
    private static final String NS_OTP_ELT = "rpid:on-the-phone";
    private static final String STATUS_ICON_ELEMENT = "status-icon";
    private static final String NS_STATUS_ICON_ELT = "rpid:status-icon";
    private static final String ANY_NS = "*";
    private static final String WATCHERINFO_NS_VALUE = "urn:ietf:params:xml:ns:watcherinfo";
    private static final String WATCHERINFO_ELEMENT = "watcherinfo";
    private static final String STATE_ATTRIBUTE = "state";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String WATCHERLIST_ELEMENT = "watcher-list";
    private static final String RESOURCE_ATTRIBUTE = "resource";
    private static final String PACKAGE_ATTRIBUTE = "package";
    private static final String WATCHER_ELEMENT = "watcher";
    private final EventPackageNotifier notifier;
    private final EventPackageSubscriber subscriber;
    private final EventPackageSubscriber watcherInfoSubscriber;
    private AuthorizationHandler authorizationHandler = null;

    public OperationSetPresenceSipImpl(ProtocolProviderServiceSipImpl provider, boolean presenceEnabled, boolean forceP2PMode, int pollingPeriod, int subscriptionExpiration) {
        super((ProtocolProviderService)provider);
        if (provider.getAccountID().getAccountPropertyBoolean((Object)"XIVO_ENABLE", false)) {
            this.ssContactList = new ServerStoredContactListXivoImpl(provider, this);
        } else {
            this.ssContactList = new ServerStoredContactListSipImpl(provider, this);
            provider.addSupportedOperationSet(OperationSetContactTypeInfo.class, new OperationSetContactTypeInfoImpl(this));
        }
        ((ProtocolProviderServiceSipImpl)this.parentProvider).addRegistrationStateChangeListener(this);
        this.presenceEnabled = presenceEnabled;
        int n = this.subscriptionDuration = subscriptionExpiration > 0 ? subscriptionExpiration : 3600;
        if (this.presenceEnabled) {
            this.subscriber = new EventPackageSubscriber((ProtocolProviderServiceSipImpl)this.parentProvider, PRESENCE_ELEMENT, this.subscriptionDuration, PIDF_XML, this.timer, 60);
            this.notifier = new EventPackageNotifier((ProtocolProviderServiceSipImpl)this.parentProvider, PRESENCE_ELEMENT, 3600, PIDF_XML, this.timer){

                @Override
                protected EventPackageNotifier.Subscription createSubscription(Address fromAddress, String eventId) {
                    return new PresenceNotifierSubscription(fromAddress, eventId);
                }
            };
            this.watcherInfoSubscriber = new EventPackageSubscriber((ProtocolProviderServiceSipImpl)this.parentProvider, "presence.winfo", this.subscriptionDuration, WATCHERINFO_XML, this.timer, 60);
        } else {
            this.subscriber = null;
            this.notifier = null;
            this.watcherInfoSubscriber = null;
        }
        ((ProtocolProviderServiceSipImpl)this.parentProvider).registerMethodProcessor("SUBSCRIBE", this);
        ((ProtocolProviderServiceSipImpl)this.parentProvider).registerMethodProcessor("NOTIFY", this);
        ((ProtocolProviderServiceSipImpl)this.parentProvider).registerMethodProcessor("PUBLISH", this);
        ((ProtocolProviderServiceSipImpl)this.parentProvider).registerEvent(PRESENCE_ELEMENT);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("presence initialized with :" + presenceEnabled + ", " + forceP2PMode + ", " + pollingPeriod + ", " + subscriptionExpiration + " for " + ((ProtocolProviderServiceSipImpl)this.parentProvider).getOurDisplayName()));
        }
        this.pollingTaskPeriod = pollingPeriod > 0 ? pollingPeriod * 1000 : 30000;
        this.useDistantPA = !forceP2PMode;
        this.sipStatusEnum = ((ProtocolProviderServiceSipImpl)this.parentProvider).getSipStatusEnum();
        this.presenceStatus = this.sipStatusEnum.getStatus("Offline");
    }

    public void addServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.addGroupListener(listener);
    }

    public void removeServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.removeGroupListener(listener);
    }

    public PresenceStatus getPresenceStatus() {
        return this.presenceStatus;
    }

    private void setUseDistantPA(boolean useDistantPA) {
        this.useDistantPA = useDistantPA;
        if (!this.useDistantPA && this.republishTask != null) {
            this.republishTask.cancel();
            this.republishTask = null;
        }
    }

    public ContactGroup getServerStoredContactListRoot() {
        return this.ssContactList.getRootGroup();
    }

    public void createServerStoredContactGroup(ContactGroup parentGroup, String groupName) throws OperationFailedException {
        if (!(parentGroup instanceof ContactGroupSipImpl)) {
            String errorMessage = String.format("Group %1s does not seem to belong to this protocol's contact list", parentGroup.getGroupName());
            throw new IllegalArgumentException(errorMessage);
        }
        ContactGroupSipImpl sipGroup = (ContactGroupSipImpl)parentGroup;
        this.ssContactList.createGroup(sipGroup, groupName, true);
    }

    public ContactGroup createUnresolvedContactGroup(String groupUID, String persistentData, ContactGroup parentGroup) {
        if (parentGroup == null) {
            parentGroup = this.getServerStoredContactListRoot();
        }
        String groupName = ContactGroupSipImpl.createNameFromUID(groupUID);
        return this.ssContactList.createUnresolvedContactGroup((ContactGroupSipImpl)parentGroup, groupName);
    }

    public void renameServerStoredContactGroup(ContactGroup group, String newName) {
        if (!(group instanceof ContactGroupSipImpl)) {
            String errorMessage = String.format("Group %1s does not seem to belong to this protocol's contact list", group.getGroupName());
            throw new IllegalArgumentException(errorMessage);
        }
        this.ssContactList.renameGroup((ContactGroupSipImpl)group, newName);
    }

    public void moveContactToGroup(Contact contactToMove, ContactGroup newParent) {
        if (!(contactToMove instanceof ContactSipImpl)) {
            return;
        }
        try {
            this.ssContactList.moveContactToGroup((ContactSipImpl)contactToMove, (ContactGroupSipImpl)newParent);
            if (this.presenceEnabled) {
                this.subscriber.subscribe(new PresenceSubscriberSubscription((ContactSipImpl)contactToMove));
            }
        }
        catch (OperationFailedException ex) {
            throw new IllegalStateException("Failed to move contact " + contactToMove.getAddress(), ex);
        }
    }

    public void removeServerStoredContactGroup(ContactGroup group) {
        if (!(group instanceof ContactGroupSipImpl)) {
            String errorMessage = String.format("Group %1s does not seem to belong to this protocol's contact list", group.getGroupName());
            throw new IllegalArgumentException(errorMessage);
        }
        ContactGroupSipImpl sipGroup = (ContactGroupSipImpl)group;
        this.ssContactList.removeGroup(sipGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishPresenceStatus(PresenceStatus status, String statusMsg) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        String reason;
        String subscriptionState;
        PresenceStatus oldStatus = this.presenceStatus;
        this.presenceStatus = status;
        String oldMessage = this.statusMessage;
        this.statusMessage = statusMsg;
        if (!this.presenceEnabled || ((ProtocolProviderServiceSipImpl)this.parentProvider).getRegistrarConnection() instanceof SipRegistrarlessConnection) {
            this.fireProviderStatusChangeEvent(oldStatus);
            this.fireProviderMsgStatusChangeEvent(oldMessage);
            return;
        }
        if (!status.equals((Object)this.sipStatusEnum.getStatus("Offline"))) {
            this.assertConnected();
        }
        if (this.useDistantPA) {
            Request req = null;
            if (status.equals((Object)this.sipStatusEnum.getStatus("Offline"))) {
                req = this.createPublish(0, false);
                List<String> list = this.waitedCallIds;
                synchronized (list) {
                    this.waitedCallIds.add(((CallIdHeader)req.getHeader("Call-ID")).getCallId());
                }
            } else {
                req = this.createPublish(this.subscriptionDuration, true);
            }
            ClientTransaction transac = null;
            try {
                transac = ((ProtocolProviderServiceSipImpl)this.parentProvider).getDefaultJainSipProvider().getNewClientTransaction(req);
            }
            catch (TransactionUnavailableException e) {
                logger.error((Object)"can't create the client transaction", (Throwable)e);
                throw new OperationFailedException("can't create the client transaction", 2);
            }
            try {
                transac.sendRequest();
            }
            catch (SipException e) {
                logger.error((Object)"can't send the PUBLISH request", (Throwable)e);
                throw new OperationFailedException("can't send the PUBLISH request", 2);
            }
        }
        if (status.equals((Object)this.sipStatusEnum.getStatus("Offline"))) {
            subscriptionState = "terminated";
            reason = "probation";
        } else {
            subscriptionState = "active";
            reason = null;
        }
        this.notifier.notifyAll(subscriptionState, reason);
        if (status.equals((Object)this.sipStatusEnum.getStatus("Offline"))) {
            this.unsubscribeToAllEventSubscribers();
            this.unsubscribeToAllContact();
        }
        this.fireProviderStatusChangeEvent(oldStatus);
        this.fireProviderMsgStatusChangeEvent(oldMessage);
    }

    public void fireProviderMsgStatusChangeEvent(String oldValue) {
        this.fireProviderStatusMessageChangeEvent(oldValue, this.statusMessage);
    }

    private Request createPublish(int expires, boolean insertPresDoc) throws OperationFailedException {
        ContentTypeHeader contTypeHeader;
        CallIdHeader callIdHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getDefaultJainSipProvider().getNewCallId();
        String localTag = SipMessageFactory.generateLocalTag();
        FromHeader fromHeader = null;
        ToHeader toHeader = null;
        try {
            Address ourAOR = ((ProtocolProviderServiceSipImpl)this.parentProvider).getRegistrarConnection().getAddressOfRecord();
            fromHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createFromHeader(ourAOR, localTag);
            toHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createToHeader(ourAOR, null);
        }
        catch (ParseException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the FromHeader or ToHeader", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the FromHeader or ToHeader", 4, (Throwable)ex);
        }
        ArrayList<ViaHeader> viaHeaders = ((ProtocolProviderServiceSipImpl)this.parentProvider).getLocalViaHeaders(toHeader.getAddress());
        MaxForwardsHeader maxForwards = ((ProtocolProviderServiceSipImpl)this.parentProvider).getMaxForwardsHeader();
        byte[] doc = null;
        doc = insertPresDoc ? this.getPidfPresenceStatus(this.getLocalContactForDst(toHeader.getAddress())) : new byte[]{};
        try {
            contTypeHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createContentTypeHeader("application", PIDF_XML);
        }
        catch (ParseException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the content headers", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the content headers", 4, (Throwable)ex);
        }
        SIPIfMatchHeader ifmHeader = null;
        try {
            if (this.distantPAET != null) {
                ifmHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createSIPIfMatchHeader(this.distantPAET);
            }
        }
        catch (ParseException e) {
            logger.error((Object)"An unexpected error occurred whileconstructing the SIPIfMatch header", (Throwable)e);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the SIPIfMatch header", 4, (Throwable)e);
        }
        CSeqHeader cSeqHeader = null;
        try {
            cSeqHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createCSeqHeader(publish_cseq++, "PUBLISH");
        }
        catch (InvalidArgumentException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the CSeqHeader", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the CSeqHeader", 4, (Throwable)ex);
        }
        catch (ParseException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the CSeqHeader", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the CSeqHeader", 4, (Throwable)ex);
        }
        ExpiresHeader expHeader = null;
        try {
            expHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createExpiresHeader(expires);
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"An unexpected error occurred whileconstructing the Expires header", (Throwable)e);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the Expires header", 4, (Throwable)e);
        }
        EventHeader evtHeader = null;
        try {
            evtHeader = ((ProtocolProviderServiceSipImpl)this.parentProvider).getHeaderFactory().createEventHeader(PRESENCE_ELEMENT);
        }
        catch (ParseException e) {
            logger.error((Object)"An unexpected error occurred whileconstructing the Event header", (Throwable)e);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the Event header", 4, (Throwable)e);
        }
        Request req = null;
        try {
            req = ((ProtocolProviderServiceSipImpl)this.parentProvider).getMessageFactory().createRequest(toHeader.getAddress().getURI(), "PUBLISH", callIdHeader, cSeqHeader, fromHeader, toHeader, (List)viaHeaders, maxForwards, contTypeHeader, doc);
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to create message Request!", (Throwable)ex);
            throw new OperationFailedException("Failed to create message Request!", 4, (Throwable)ex);
        }
        req.setHeader((Header)expHeader);
        req.setHeader((Header)evtHeader);
        if (ifmHeader != null) {
            req.setHeader((Header)ifmHeader);
        }
        return req;
    }

    public Iterator<PresenceStatus> getSupportedStatusSet() {
        return this.sipStatusEnum.getSupportedStatusSet();
    }

    public PresenceStatus queryContactStatus(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        ContactSipImpl contact = this.resolveContactID(contactIdentifier);
        if (contact == null) {
            throw new IllegalArgumentException("contact " + contactIdentifier + " unknown");
        }
        return contact.getPresenceStatus();
    }

    public void subscribe(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.subscribe(this.ssContactList.getRootGroup(), contactIdentifier);
    }

    public void subscribe(ContactGroup parentGroup, String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.subscribe(parentGroup, contactIdentifier, null);
    }

    void subscribe(ContactGroup parentGroup, String contactIdentifier, String contactType) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(parentGroup instanceof ContactGroupSipImpl)) {
            String errorMessage = String.format("Group %1s does not seem to belong to this protocol's contact list", parentGroup.getGroupName());
            throw new IllegalArgumentException(errorMessage);
        }
        ContactSipImpl contact = this.resolveContactID(contactIdentifier);
        if (contact != null) {
            if (contact.isPersistent()) {
                throw new OperationFailedException("Contact " + contactIdentifier + " already exists.", 5);
            }
            this.ssContactList.removeContact(contact);
        }
        contact = this.ssContactList.createContact((ContactGroupSipImpl)parentGroup, contactIdentifier, true, contactType);
        if (this.presenceEnabled) {
            this.subscriber.subscribe(new PresenceSubscriberSubscription(contact));
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.parentProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to communicate.");
        }
        if (!((ProtocolProviderServiceSipImpl)this.parentProvider).isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    public void unsubscribe(Contact contact) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(contact instanceof ContactSipImpl)) {
            throw new IllegalArgumentException("The contact is not a SIP contact");
        }
        ContactSipImpl sipContact = (ContactSipImpl)contact;
        this.unsubscribe(sipContact, false);
        this.ssContactList.removeContact(sipContact);
    }

    private void unsubscribe(ContactSipImpl sipcontact, boolean assertConnectedAndSubscribed) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        if (this.presenceEnabled && sipcontact.isResolvable()) {
            if (assertConnectedAndSubscribed) {
                this.assertConnected();
            }
            this.subscriber.unsubscribe(this.getAddress(sipcontact), assertConnectedAndSubscribed);
        }
        this.terminateSubscription(sipcontact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processResponse(ResponseEvent responseEvent) {
        if (!this.presenceEnabled) {
            return false;
        }
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        Response response = responseEvent.getResponse();
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        if (cseq == null) {
            logger.error((Object)"An incoming response did not contain a CSeq header");
            return false;
        }
        String method = cseq.getMethod();
        boolean processed = false;
        if (method.equals("PUBLISH")) {
            if (response.getStatusCode() != 401 && response.getStatusCode() != 407 && response.getStatusCode() != 423) {
                List<String> list = this.waitedCallIds;
                synchronized (list) {
                    this.waitedCallIds.remove(((CallIdHeader)response.getHeader("Call-ID")).getCallId());
                }
            }
            if (response.getStatusCode() == 200) {
                SIPETagHeader etHeader = (SIPETagHeader)response.getHeader("SIP-ETag");
                if (etHeader == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"can't find the ETag header");
                    }
                    return false;
                }
                this.distantPAET = etHeader.getETag();
                ExpiresHeader expires = (ExpiresHeader)response.getHeader("Expires");
                if (expires == null) {
                    logger.error((Object)"no Expires header in the response");
                    return false;
                }
                if (expires.getExpires() == 0) {
                    this.distantPAET = null;
                    return true;
                }
                if (this.republishTask != null) {
                    this.republishTask.cancel();
                }
                this.republishTask = new RePublishTask();
                int republishDelay = expires.getExpires();
                if (republishDelay >= 120) {
                    republishDelay -= 60;
                }
                this.timer.schedule(this.republishTask, republishDelay * 1000);
            } else {
                if (response.getStatusCode() == 401 || response.getStatusCode() == 407) {
                    try {
                        this.processAuthenticationChallenge(clientTransaction, response, (SipProvider)responseEvent.getSource());
                    }
                    catch (OperationFailedException e) {
                        logger.error((Object)"can't handle the challenge", (Throwable)e);
                        return false;
                    }
                }
                if (response.getStatusCode() == 423) {
                    MinExpiresHeader min = (MinExpiresHeader)response.getHeader("Min-Expires");
                    if (min == null) {
                        logger.error((Object)"can't find a min expires header in the 423 error message");
                        return false;
                    }
                    Request req = null;
                    try {
                        req = this.createPublish(min.getExpires(), true);
                    }
                    catch (OperationFailedException e) {
                        logger.error((Object)"can't create the new publish request", (Throwable)e);
                        return false;
                    }
                    ClientTransaction transac = null;
                    try {
                        transac = ((ProtocolProviderServiceSipImpl)this.parentProvider).getDefaultJainSipProvider().getNewClientTransaction(req);
                    }
                    catch (TransactionUnavailableException e) {
                        logger.error((Object)"can't create the client transaction", (Throwable)e);
                        return false;
                    }
                    try {
                        transac.sendRequest();
                    }
                    catch (SipException e) {
                        logger.error((Object)"can't send the PUBLISH request", (Throwable)e);
                        return false;
                    }
                }
                if (response.getStatusCode() == 412) {
                    this.distantPAET = null;
                    Request req = null;
                    try {
                        req = this.createPublish(this.subscriptionDuration, true);
                    }
                    catch (OperationFailedException e) {
                        logger.error((Object)"can't create the new publish request", (Throwable)e);
                        return false;
                    }
                    ClientTransaction transac = null;
                    try {
                        transac = ((ProtocolProviderServiceSipImpl)this.parentProvider).getDefaultJainSipProvider().getNewClientTransaction(req);
                    }
                    catch (TransactionUnavailableException e) {
                        logger.error((Object)"can't create the client transaction", (Throwable)e);
                        return false;
                    }
                    try {
                        transac.sendRequest();
                    }
                    catch (SipException e) {
                        logger.error((Object)"can't send the PUBLISH request", (Throwable)e);
                        return false;
                    }
                }
                if (response.getStatusCode() < 100 || response.getStatusCode() >= 200) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("error received from the network" + response));
                    }
                    this.distantPAET = null;
                    if (this.useDistantPA) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"we enter into the peer-to-peer mode as the distant PA mode fails");
                        }
                        this.setUseDistantPA(false);
                    }
                }
            }
            processed = true;
        }
        return processed;
    }

    private void finalizeSubscription(ContactSipImpl contact) throws NullPointerException {
        if (contact == null) {
            throw new NullPointerException(CONTACT_ELEMENT);
        }
        contact.setResolved(true);
        this.fireSubscriptionEvent((Contact)contact, contact.getParentContactGroup(), 4);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("contact " + (Object)((Object)contact) + " resolved"));
        }
    }

    private void terminateSubscription(ContactSipImpl contact) {
        if (contact == null) {
            logger.error((Object)"null contact provided, can't terminate subscription");
            return;
        }
        this.changePresenceStatusForContact(contact, this.sipStatusEnum.getStatus("Unknown"));
        contact.setResolved(false);
    }

    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        if (!this.presenceEnabled) {
            return false;
        }
        Request request = requestEvent.getRequest();
        EventHeader eventHeader = (EventHeader)request.getHeader("Event");
        if (eventHeader == null) {
            return false;
        }
        String eventType = eventHeader.getEventType();
        if (!PRESENCE_ELEMENT.equalsIgnoreCase(eventType) && !"presence.winfo".equalsIgnoreCase(eventType)) {
            return false;
        }
        String requestMethod = request.getMethod();
        boolean processed = false;
        if (PRESENCE_ELEMENT.equalsIgnoreCase(eventType) && "PUBLISH".equals(requestMethod) || "presence.winfo".equalsIgnoreCase(eventType) && "SUBSCRIBE".equals(requestMethod)) {
            processed = EventPackageSupport.sendNotImplementedResponse((ProtocolProviderServiceSipImpl)this.parentProvider, requestEvent);
        }
        return processed;
    }

    @Override
    public boolean processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        return false;
    }

    @Override
    public boolean processIOException(IOExceptionEvent exceptionEvent) {
        return false;
    }

    @Override
    public boolean processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        return false;
    }

    @Override
    public boolean processTimeout(TimeoutEvent timeoutEvent) {
        logger.error((Object)("timeout reached, it looks really abnormal: " + timeoutEvent.toString()));
        return false;
    }

    private void processAuthenticationChallenge(ClientTransaction clientTransaction, Response response, SipProvider jainSipProvider) throws OperationFailedException {
        EventPackageSupport.processAuthenticationChallenge((ProtocolProviderServiceSipImpl)this.parentProvider, clientTransaction, response, jainSipProvider);
    }

    private void changePresenceStatusForContact(ContactSipImpl contact, PresenceStatus newStatus) {
        PresenceStatus oldStatus = contact.getPresenceStatus();
        contact.setPresenceStatus(newStatus);
        this.fireContactPresenceStatusChangeEvent((Contact)contact, contact.getParentContactGroup(), oldStatus);
    }

    public ContactSipImpl findContactByID(String contactID) {
        return this.ssContactList.getRootGroup().findContactByID(contactID);
    }

    public ContactSipImpl getLocalContactForDst(ContactSipImpl destination) {
        return this.getLocalContactForDst(destination.getSipAddress());
    }

    public ContactSipImpl getLocalContactForDst(Address destination) {
        Address sipAddress = ((ProtocolProviderServiceSipImpl)this.parentProvider).getOurSipAddress(destination);
        ContactSipImpl res = new ContactSipImpl(sipAddress, (ProtocolProviderServiceSipImpl)this.parentProvider);
        res.setPresenceStatus(this.presenceStatus);
        return res;
    }

    public void setAuthorizationHandler(AuthorizationHandler handler) {
        this.authorizationHandler = handler;
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public Contact createUnresolvedContact(String address, String persistentData) {
        return this.createUnresolvedContact(address, persistentData, this.getServerStoredContactListRoot());
    }

    public Contact createUnresolvedContact(String contactId, String persistentData, ContactGroup parent) {
        return this.ssContactList.createUnresolvedContact((ContactGroupSipImpl)parent, contactId, persistentData);
    }

    public ContactSipImpl createVolatileContact(String contactAddress, String displayName) {
        try {
            ContactGroupSipImpl volatileGroup = this.getNonPersistentGroup();
            if (volatileGroup == null) {
                ContactGroupSipImpl rootGroup = this.ssContactList.getRootGroup();
                volatileGroup = this.ssContactList.createGroup(rootGroup, SipActivator.getResources().getI18NString("service.gui.NOT_IN_CONTACT_LIST_GROUP_NAME"), false);
            }
            if (displayName != null) {
                return this.ssContactList.createContact(volatileGroup, contactAddress, displayName, false, null);
            }
            return this.ssContactList.createContact(volatileGroup, contactAddress, false, null);
        }
        catch (OperationFailedException ex) {
            return null;
        }
    }

    public ContactSipImpl createVolatileContact(String contactAddress) {
        return this.createVolatileContact(contactAddress, null);
    }

    private ContactGroupSipImpl getNonPersistentGroup() {
        for (int i = 0; i < this.getServerStoredContactListRoot().countSubgroups(); ++i) {
            ContactGroupSipImpl gr = (ContactGroupSipImpl)this.getServerStoredContactListRoot().getGroup(i);
            if (gr.isPersistent()) continue;
            return gr;
        }
        return null;
    }

    ContactSipImpl resolveContactID(String contactID) {
        ContactSipImpl res = this.findContactByID(contactID);
        if (res == null) {
            if (contactID.startsWith("sip:")) {
                res = this.findContactByID(contactID.substring(4));
            }
            if (res == null) {
                int domainBeginIndex = contactID.indexOf(64);
                if (domainBeginIndex > -1 && (res = this.findContactByID(contactID.substring(0, domainBeginIndex))) == null && contactID.startsWith("sip:")) {
                    res = this.findContactByID(contactID.substring(4, domainBeginIndex));
                }
                if (res == null) {
                    int domainEndIndex = contactID.indexOf(":", 4);
                    if (domainEndIndex < 0) {
                        domainEndIndex = contactID.indexOf(";", 4);
                    }
                    if (domainEndIndex > -1) {
                        res = this.findContactByID(contactID.substring(4, domainEndIndex));
                    }
                }
            }
        }
        return res;
    }

    Document createDocument() {
        try {
            return XMLUtils.createDocument();
        }
        catch (Exception e) {
            logger.error((Object)"Can't create xml document", (Throwable)e);
            return null;
        }
    }

    String convertDocument(Document document) {
        try {
            return XMLUtils.createXml((Document)document);
        }
        catch (Exception e) {
            logger.error((Object)"Can't convert the xml document into a string", (Throwable)e);
            return null;
        }
    }

    Document convertDocument(String document) {
        try {
            return XMLUtils.createDocument((String)document);
        }
        catch (Exception e) {
            logger.error((Object)"Can't convert the string into a xml document", (Throwable)e);
            return null;
        }
    }

    public byte[] getPidfPresenceStatus(ContactSipImpl contact) {
        Document doc = this.createDocument();
        if (doc == null) {
            return null;
        }
        String contactUri = contact.getSipAddress().getURI().toString();
        Element presence = doc.createElement(PRESENCE_ELEMENT);
        presence.setAttribute(NS_ELEMENT, PIDF_NS_VALUE);
        presence.setAttribute(RPID_NS_ELEMENT, RPID_NS_VALUE);
        presence.setAttribute(DM_NS_ELEMENT, DM_NS_VALUE);
        presence.setAttribute(ENTITY_ATTRIBUTE, contactUri);
        doc.appendChild(presence);
        Element person = doc.createElement(NS_PERSON_ELT);
        person.setAttribute(ID_ATTRIBUTE, PERSON_ID);
        presence.appendChild(person);
        Element activities = doc.createElement(NS_ACTIVITY_ELT);
        person.appendChild(activities);
        URI imageUri = this.ssContactList.getImageUri();
        if (imageUri != null) {
            Element statusIcon = doc.createElement(NS_STATUS_ICON_ELT);
            statusIcon.setTextContent(imageUri.toString());
            person.appendChild(statusIcon);
        }
        if (contact.getPresenceStatus().equals((Object)this.sipStatusEnum.getStatus("Away"))) {
            Element away = doc.createElement(NS_AWAY_ELT);
            activities.appendChild(away);
        } else if (contact.getPresenceStatus().equals((Object)this.sipStatusEnum.getStatus("Busy (DND)"))) {
            Element busy = doc.createElement(NS_BUSY_ELT);
            activities.appendChild(busy);
        } else if (contact.getPresenceStatus().equals((Object)this.sipStatusEnum.getStatus("On the phone"))) {
            Element otp = doc.createElement(NS_OTP_ELT);
            activities.appendChild(otp);
        }
        Element tuple = doc.createElement(TUPLE_ELEMENT);
        tuple.setAttribute(ID_ATTRIBUTE, TUPLE_ID);
        presence.appendChild(tuple);
        Element status = doc.createElement(STATUS_ELEMENT);
        tuple.appendChild(status);
        Element basic = doc.createElement(BASIC_ELEMENT);
        if (contact.getPresenceStatus().equals((Object)this.sipStatusEnum.getStatus("Offline"))) {
            basic.appendChild(doc.createTextNode(OFFLINE_STATUS));
        } else {
            basic.appendChild(doc.createTextNode(ONLINE_STATUS));
        }
        status.appendChild(basic);
        Element contactUriEl = doc.createElement(CONTACT_ELEMENT);
        Text cValue = doc.createTextNode(contactUri);
        contactUriEl.appendChild(cValue);
        tuple.appendChild(contactUriEl);
        Element noteNodeEl = doc.createElement(NOTE_ELEMENT);
        noteNodeEl.appendChild(doc.createTextNode(contact.getPresenceStatus().getStatusName()));
        tuple.appendChild(noteNodeEl);
        String res = this.convertDocument(doc);
        if (res == null) {
            return null;
        }
        return res.getBytes();
    }

    public void setPidfPresenceStatus(String presenceDoc) {
        String state;
        Node noteNode;
        NodeList presNoteList;
        Node presNode;
        NodeList presList;
        Document doc = this.convertDocument(presenceDoc);
        if (doc == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parsing:\n" + presenceDoc));
        }
        if ((presList = doc.getElementsByTagNameNS(PIDF_NS_VALUE, PRESENCE_ELEMENT)).getLength() == 0 && (presList = doc.getElementsByTagNameNS(ANY_NS, PRESENCE_ELEMENT)).getLength() == 0) {
            logger.error((Object)"no presence element in this document");
            return;
        }
        if (presList.getLength() > 1) {
            logger.warn((Object)"more than one presence element in this document");
        }
        if ((presNode = presList.item(0)).getNodeType() != 1) {
            logger.error((Object)"the presence node is not an element");
            return;
        }
        Element presence = (Element)presNode;
        SipStatusEnum.SipPresenceStatus personStatus = null;
        URI personStatusIcon = null;
        NodeList personList = presence.getElementsByTagNameNS(ANY_NS, PERSON_ELEMENT);
        if (personList.getLength() > 0) {
            Element statusIcon;
            String content;
            Node statusIconNode;
            Object statusIconList;
            Node personNode = personList.item(0);
            if (personNode.getNodeType() != 1) {
                logger.error((Object)"the person node is not an element");
                return;
            }
            Element person = (Element)personNode;
            NodeList activityList = person.getElementsByTagNameNS(ANY_NS, ACTIVITY_ELEMENT);
            if (activityList.getLength() > 0) {
                Element activity = null;
                for (int i = 0; i < activityList.getLength(); ++i) {
                    Node activityNode = activityList.item(i);
                    if (activityNode.getNodeType() != 1) continue;
                    activity = (Element)activityNode;
                    NodeList statusList = activity.getChildNodes();
                    for (int j = 0; j < statusList.getLength(); ++j) {
                        Node statusNode = statusList.item(j);
                        if (statusNode.getNodeType() != 1) continue;
                        String statusname = statusNode.getLocalName();
                        if (statusname.equals(AWAY_ELEMENT)) {
                            personStatus = this.sipStatusEnum.getStatus("Away");
                            break;
                        }
                        if (statusname.equals(BUSY_ELEMENT)) {
                            personStatus = this.sipStatusEnum.getStatus("Busy (DND)");
                            break;
                        }
                        if (!statusname.equals(OTP_ELEMENT)) continue;
                        personStatus = this.sipStatusEnum.getStatus("On the phone");
                        break;
                    }
                    if (personStatus != null) break;
                }
            }
            if ((statusIconList = person.getElementsByTagNameNS(ANY_NS, STATUS_ICON_ELEMENT)).getLength() > 0 && (statusIconNode = statusIconList.item(0)).getNodeType() == 1 && (content = this.getTextContent(statusIcon = (Element)statusIconNode)) != null && content.trim().length() != 0) {
                try {
                    personStatusIcon = URI.create(content);
                }
                catch (IllegalArgumentException ex) {
                    logger.error((Object)("Person's status icon uri: " + content + " is invalid"));
                }
            }
        }
        if (personStatusIcon != null) {
            String contactID = XMLUtils.getAttribute((Node)presNode, (String)ENTITY_ATTRIBUTE);
            if (contactID.startsWith("pres:")) {
                contactID = contactID.substring("pres:".length());
            }
            ContactSipImpl contact = this.resolveContactID(contactID);
            this.updateContactIcon(contact, personStatusIcon);
        }
        if ((presNoteList = this.getPidfChilds(presence, NOTE_ELEMENT)).getLength() >= 1 && (noteNode = presNoteList.item(presNoteList.getLength() - 1)).getNodeType() == 1 && (state = this.getTextContent((Element)noteNode)) != null) {
            switch (state.toLowerCase()) {
                case "ready": 
                case "available": {
                    personStatus = this.sipStatusEnum.getStatus("Online");
                    break;
                }
                case "ringing": 
                case "on the phone": 
                case "on hold": {
                    personStatus = this.sipStatusEnum.getStatus("On the phone");
                    break;
                }
                case "unavailable": {
                    personStatus = this.sipStatusEnum.getStatus("Offline");
                }
            }
        }
        List<Object[]> newPresenceStates = new Vector<Object[]>(3, 2);
        NodeList tupleList = this.getPidfChilds(presence, TUPLE_ELEMENT);
        for (int i = 0; i < tupleList.getLength(); ++i) {
            Node tupleNode = tupleList.item(i);
            if (tupleNode.getNodeType() != 1) continue;
            Element tuple = (Element)tupleNode;
            NodeList contactList = this.getPidfChilds(tuple, CONTACT_ELEMENT);
            Vector<Object[]> sipcontact = new Vector<Object[]>(1, 3);
            String contactID = null;
            if (contactList.getLength() == 0) {
                ContactSipImpl tmpContact;
                contactID = XMLUtils.getAttribute((Node)presNode, (String)ENTITY_ATTRIBUTE);
                if (contactID.startsWith("pres:")) {
                    contactID = contactID.substring("pres:".length());
                }
                if ((tmpContact = this.resolveContactID(contactID)) != null) {
                    sipcontact.add(new Object[]{tmpContact, new Float(0.0f)});
                }
            } else {
                for (int j = 0; j < contactList.getLength(); ++j) {
                    ContactSipImpl tmpContact;
                    Node contactNode = contactList.item(j);
                    if (contactNode.getNodeType() != 1) continue;
                    Element contact = (Element)contactNode;
                    contactID = this.getTextContent(contact);
                    if (contactID.startsWith("pres:")) {
                        contactID = contactID.substring("pres:".length());
                    }
                    if ((tmpContact = this.resolveContactID(contactID)) == null) continue;
                    Object[] tab = new Object[2];
                    String prioStr = contact.getAttribute(PRIORITY_ATTRIBUTE);
                    Float prio = null;
                    try {
                        prio = prioStr == null || prioStr.length() == 0 ? new Float(0.0f) : Float.valueOf(prioStr);
                    }
                    catch (NumberFormatException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"contact priority is not a valid float", (Throwable)e);
                        }
                        prio = new Float(0.0f);
                    }
                    if (prio.floatValue() < 0.0f) {
                        prio = new Float(0.0f);
                    }
                    if (prio.floatValue() > 1.0f) {
                        prio = new Float(1.0f);
                    }
                    tab[0] = tmpContact;
                    tab[1] = prio;
                    boolean contactAlreadyListed = false;
                    for (int k = 0; k < sipcontact.size(); ++k) {
                        Object[] tmp = (Object[])sipcontact.get(k);
                        if (!tmp[0].equals((Object)tmpContact)) continue;
                        contactAlreadyListed = true;
                        if (!(((Float)tmp[1]).floatValue() < prio.floatValue())) break;
                        sipcontact.remove(k);
                        sipcontact.add(tab);
                        break;
                    }
                    if (contactAlreadyListed) continue;
                    sipcontact.add(tab);
                }
            }
            if (sipcontact.isEmpty()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("no contact found for id: " + contactID));
                continue;
            }
            NodeList statusList = this.getPidfChilds(tuple, STATUS_ELEMENT);
            int index = statusList.getLength() - 1;
            Node statusNode = null;
            do {
                Node temp;
                if ((temp = statusList.item(index)).getNodeType() != 1) continue;
                statusNode = temp;
                break;
            } while (--index >= 0);
            Element basic = null;
            if (statusNode == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"no valid status in this tuple");
                }
            } else {
                Element status = (Element)statusNode;
                NodeList basicList = this.getPidfChilds(status, BASIC_ELEMENT);
                index = basicList.getLength() - 1;
                Node basicNode = null;
                do {
                    Node temp;
                    if ((temp = basicList.item(index)).getNodeType() != 1) continue;
                    basicNode = temp;
                    break;
                } while (--index >= 0);
                if (basicNode == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"no valid <basic> in this status");
                    }
                } else {
                    basic = (Element)basicNode;
                }
            }
            NodeList noteList = this.getPidfChilds(tuple, NOTE_ELEMENT);
            boolean changed = false;
            block24: for (int k = 0; k < noteList.getLength() && !changed; ++k) {
                Node noteNode2 = noteList.item(k);
                if (noteNode2.getNodeType() != 1) continue;
                Element note = (Element)noteNode2;
                String state2 = this.getTextContent(note);
                Iterator<PresenceStatus> states = this.sipStatusEnum.getSupportedStatusSet();
                while (states.hasNext()) {
                    PresenceStatus current = states.next();
                    if (!current.getStatusName().equalsIgnoreCase(state2)) continue;
                    changed = true;
                    newPresenceStates = this.setStatusForContacts(current, sipcontact, newPresenceStates);
                    continue block24;
                }
            }
            if (!changed && basic != null) {
                if (this.getTextContent(basic).equalsIgnoreCase(ONLINE_STATUS)) {
                    if (personStatus != null) {
                        newPresenceStates = this.setStatusForContacts(personStatus, sipcontact, newPresenceStates);
                        continue;
                    }
                    newPresenceStates = this.setStatusForContacts(this.sipStatusEnum.getStatus("Online"), sipcontact, newPresenceStates);
                    continue;
                }
                if (!this.getTextContent(basic).equalsIgnoreCase(OFFLINE_STATUS)) continue;
                newPresenceStates = this.setStatusForContacts(this.sipStatusEnum.getStatus("Offline"), sipcontact, newPresenceStates);
                continue;
            }
            if (changed || !logger.isDebugEnabled()) continue;
            logger.debug((Object)"no suitable presence state found in this tuple");
        }
        for (Object[] tab : newPresenceStates) {
            ContactSipImpl contact = (ContactSipImpl)((Object)tab[0]);
            PresenceStatus status = (PresenceStatus)tab[2];
            this.changePresenceStatusForContact(contact, status);
        }
    }

    public void setWatcherInfoStatus(WatcherInfoSubscriberSubscription subscriber, String watcherInfoDoc) {
        Node watcherInfoNode;
        NodeList watchList;
        if (this.authorizationHandler == null) {
            logger.warn((Object)"AuthorizationHandler missing!");
            return;
        }
        Document doc = this.convertDocument(watcherInfoDoc);
        if (doc == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parsing:\n" + watcherInfoDoc));
        }
        if ((watchList = doc.getElementsByTagNameNS(WATCHERINFO_NS_VALUE, WATCHERINFO_ELEMENT)).getLength() == 0 && (watchList = doc.getElementsByTagNameNS(ANY_NS, WATCHERINFO_ELEMENT)).getLength() == 0) {
            logger.error((Object)"no watcherinfo element in this document");
            return;
        }
        if (watchList.getLength() > 1) {
            logger.warn((Object)"more than one watcherinfo element in this document");
        }
        if ((watcherInfoNode = watchList.item(0)).getNodeType() != 1) {
            logger.error((Object)"the watcherinfo node is not an element");
            return;
        }
        Element watcherInfo = (Element)watcherInfoNode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Watcherinfo is with state: " + watcherInfo.getAttribute(STATE_ATTRIBUTE)));
        }
        int currentVersion = -1;
        try {
            currentVersion = Integer.parseInt(watcherInfo.getAttribute(VERSION_ATTRIBUTE));
        }
        catch (Throwable t) {
            logger.error((Object)"Cannot parse version!", t);
        }
        if (currentVersion != -1 && currentVersion <= subscriber.version) {
            logger.warn((Object)"Document version is old, ignore it.");
            return;
        }
        subscriber.version = currentVersion;
        Element wlist = XMLUtils.locateElement((Element)watcherInfo, (String)WATCHERLIST_ELEMENT, (String)RESOURCE_ATTRIBUTE, (String)((ProtocolProviderServiceSipImpl)this.parentProvider).getRegistrarConnection().getAddressOfRecord().getURI().toString());
        if (wlist == null || !wlist.getAttribute(PACKAGE_ATTRIBUTE).equals(PRESENCE_ELEMENT)) {
            logger.error((Object)"Watcher list for us is missing in this document!");
            return;
        }
        NodeList watcherList = wlist.getElementsByTagNameNS(ANY_NS, WATCHER_ELEMENT);
        for (int i = 0; i < watcherList.getLength(); ++i) {
            Node watcherNode = watcherList.item(i);
            if (watcherNode.getNodeType() != 1) {
                logger.error((Object)"the watcher node is not an element");
                return;
            }
            Element watcher = (Element)watcherNode;
            String status = watcher.getAttribute(STATUS_ELEMENT);
            String contactID = this.getTextContent(watcher);
            if (status == null || contactID == null) {
                logger.warn((Object)"Status or contactID missing for watcher!");
                continue;
            }
            if (!status.equals("waiting") && !status.equals("pending")) continue;
            ContactSipImpl contact = this.resolveContactID(contactID);
            if (contact != null) {
                logger.warn((Object)"We are not supposed to have this contact in our list or its just rerequest of authorization!");
                return;
            }
            AuthorizationRequest req = new AuthorizationRequest();
            contact = this.createVolatileContact(contactID);
            AuthorizationResponse response = this.authorizationHandler.processAuthorisationRequest(req, (Contact)contact);
            if (response.getResponseCode() == AuthorizationResponse.ACCEPT) {
                this.ssContactList.authorizationAccepted(contact);
                continue;
            }
            if (response.getResponseCode() == AuthorizationResponse.REJECT) {
                this.ssContactList.authorizationRejected(contact);
                continue;
            }
            if (response.getResponseCode() != AuthorizationResponse.IGNORE) continue;
            this.ssContactList.authorizationIgnored(contact);
        }
    }

    public static boolean isEquals(URI uri1, URI uri2) {
        return uri1 == null && uri2 == null || uri1 != null && uri1.equals(uri2);
    }

    private void updateContactIcon(ContactSipImpl contact, URI imageUri) {
        if (OperationSetPresenceSipImpl.isEquals(contact.getImageUri(), imageUri) || imageUri == null) {
            return;
        }
        byte[] oldImage = contact.getImage();
        byte[] newImage = this.ssContactList.getImage(imageUri);
        if (oldImage == null && newImage == null) {
            return;
        }
        contact.setImageUri(imageUri);
        contact.setImage(newImage);
        this.fireContactPropertyChangeEvent("Image", (Contact)contact, oldImage, newImage);
    }

    private String getTextContent(Element node) {
        String res = XMLUtils.getText((Element)node);
        if (res == null) {
            logger.warn((Object)("no text for element '" + node.getNodeName() + "'"));
            return "";
        }
        return res;
    }

    private NodeList getPidfChilds(Element element, String childName) {
        NodeList res = element.getElementsByTagNameNS(PIDF_NS_VALUE, childName);
        if (res.getLength() == 0) {
            res = element.getElementsByTagNameNS(ANY_NS, childName);
        }
        return res;
    }

    private List<Object[]> setStatusForContacts(PresenceStatus presenceState, Iterable<Object[]> contacts, List<Object[]> curStatus) {
        if (presenceState == null || contacts == null || curStatus == null) {
            return null;
        }
        for (Object[] tab : contacts) {
            Contact contact = (Contact)tab[0];
            float priority = ((Float)tab[1]).floatValue();
            int pos = 0;
            boolean skip = false;
            for (int i = 0; i < curStatus.size(); ++i) {
                Object[] tab2 = curStatus.get(i);
                Contact curContact = (Contact)tab2[0];
                float curPriority = ((Float)tab2[1]).floatValue();
                if (pos == 0 && curPriority <= priority) {
                    pos = i;
                }
                if (!curContact.equals(contact)) continue;
                if (curPriority > priority) {
                    skip = true;
                    break;
                }
                if (curPriority < priority) {
                    curStatus.remove(i);
                } else {
                    PresenceStatus curPresence = (PresenceStatus)tab2[2];
                    if (curPresence.getStatus() >= presenceState.getStatus()) {
                        skip = true;
                        break;
                    }
                    curStatus.remove(i);
                }
                --i;
            }
            if (skip) continue;
            curStatus.add(pos, new Object[]{contact, new Float(priority), presenceState});
        }
        return curStatus;
    }

    public void forcePollContact(ContactSipImpl contact) {
        if (!(this.presenceEnabled && contact.isResolvable() && contact.isPersistent())) {
            return;
        }
        try {
            this.subscriber.poll(new PresenceSubscriberSubscription(contact));
        }
        catch (OperationFailedException ex) {
            logger.error((Object)"Failed to create and send the subcription", (Throwable)ex);
        }
    }

    public void unsubscribeToAllContact() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Trying to unsubscribe to every contact");
        }
        for (ContactSipImpl contact : this.ssContactList.getUniqueContacts(this.ssContactList.getRootGroup())) {
            try {
                this.unsubscribe(contact, false);
            }
            catch (Throwable ex) {
                logger.error((Object)("Failed to unsubscribe to contact " + (Object)((Object)contact)), ex);
            }
        }
    }

    private void unsubscribeToAllEventSubscribers() {
        if (this.watcherInfoSubscriber != null) {
            try {
                this.watcherInfoSubscriber.unsubscribe(((ProtocolProviderServiceSipImpl)this.parentProvider).getRegistrarConnection().getAddressOfRecord(), false);
            }
            catch (Throwable ex) {
                logger.error((Object)"Failed to send the unsubscription for watcher info.", ex);
            }
        }
    }

    public void setDisplayName(Contact contact, String newName) throws IllegalArgumentException {
        this.assertConnected();
        if (!(contact instanceof ContactSipImpl)) {
            throw new IllegalArgumentException("The contact is not a SIP contact");
        }
        this.ssContactList.renameContact((ContactSipImpl)contact, newName);
    }

    protected ServerStoredContactList getSsContactList() {
        return this.ssContactList;
    }

    private void cancelTimer() {
        if (this.republishTask != null) {
            this.republishTask = null;
        }
        if (this.pollingTask != null) {
            this.pollingTask = null;
        }
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEvents() {
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            Object object = this.waitedCallIds;
            synchronized (object) {
                if (this.waitedCallIds.size() == 0) {
                    break;
                }
            }
            object = this;
            synchronized (object) {
                block10: {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException e) {
                        if (!logger.isDebugEnabled()) break block10;
                        logger.debug((Object)"abnormal behavior, may cause unnecessary CPU use", (Throwable)e);
                    }
                }
                continue;
            }
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERING)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Enter unregistering state");
            }
            this.cancelTimer();
            this.ssContactList.destroy();
            try {
                this.publishPresenceStatus(this.sipStatusEnum.getStatus("Offline"), "");
            }
            catch (OperationFailedException e) {
                logger.error((Object)"can't set the offline mode", (Throwable)e);
            }
            this.stopEvents();
        } else if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"enter registered state");
            }
            this.ssContactList.init();
            if (!this.presenceEnabled || this.pollingTask != null) {
                return;
            }
            for (ContactSipImpl contact : this.ssContactList.getAllContacts(this.ssContactList.getRootGroup())) {
                this.forcePollContact(contact);
            }
            this.pollingTask = new PollOfflineContactsTask();
            this.timer.schedule(this.pollingTask, this.pollingTaskPeriod, this.pollingTaskPeriod);
            if (this.useDistantPA) {
                try {
                    this.watcherInfoSubscriber.subscribe(new WatcherInfoSubscriberSubscription(((ProtocolProviderServiceSipImpl)this.parentProvider).getRegistrarConnection().getAddressOfRecord()));
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)"Failed to create and send the subcription for watcher info.", (Throwable)ex);
                }
            }
        } else if (evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || evt.getNewState().equals((Object)RegistrationState.AUTHENTICATION_FAILED)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Enter connction failed state");
            }
            this.ssContactList.destroy();
            for (ContactSipImpl contact : this.ssContactList.getAllContacts(this.ssContactList.getRootGroup())) {
                PresenceStatus oldContactStatus;
                block22: {
                    oldContactStatus = contact.getPresenceStatus();
                    if (this.subscriber != null) {
                        try {
                            this.subscriber.removeSubscription(this.getAddress(contact));
                        }
                        catch (OperationFailedException ex) {
                            if (!logger.isDebugEnabled()) break block22;
                            logger.debug((Object)("Failed to remove subscription to contact " + (Object)((Object)contact)));
                        }
                    }
                }
                if (!oldContactStatus.isOnline()) continue;
                contact.setPresenceStatus(this.sipStatusEnum.getStatus("Offline"));
                this.fireContactPresenceStatusChangeEvent((Contact)contact, contact.getParentContactGroup(), oldContactStatus);
            }
            if (this.useDistantPA) {
                try {
                    this.watcherInfoSubscriber.removeSubscription(((ProtocolProviderServiceSipImpl)this.parentProvider).getRegistrarConnection().getAddressOfRecord());
                }
                catch (Throwable ex) {
                    logger.error((Object)"Failed to remove subscription for watcher info.", ex);
                }
            }
            this.cancelTimer();
            this.waitedCallIds.clear();
            PresenceStatus oldStatus = this.presenceStatus;
            this.presenceStatus = this.sipStatusEnum.getStatus("Offline");
            this.fireProviderStatusChangeEvent(oldStatus);
        }
    }

    private Address getAddress(ContactSipImpl contact) throws OperationFailedException {
        try {
            return ((ProtocolProviderServiceSipImpl)this.parentProvider).parseAddressString(contact.getAddress());
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("An unexpected error occurred while constructing the address", 4, ex, logger);
            return null;
        }
    }

    void shutdown() {
        ((ProtocolProviderServiceSipImpl)this.parentProvider).removeRegistrationStateChangeListener(this);
    }

    private class WatcherInfoSubscriberSubscription
    extends EventPackageSubscriber.Subscription {
        private int version;

        public WatcherInfoSubscriberSubscription(Address toAddress) {
            super(toAddress);
            this.version = -1;
        }

        @Override
        protected void processActiveRequest(RequestEvent requestEvent, byte[] rawContent) {
            if (rawContent != null) {
                OperationSetPresenceSipImpl.this.setWatcherInfoStatus(this, new String(rawContent));
            }
        }

        @Override
        protected void processFailureResponse(ResponseEvent responseEvent, int statusCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot subscripe to presence watcher info!");
            }
        }

        @Override
        protected void processSuccessResponse(ResponseEvent responseEvent, int statusCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Subscriped to presence watcher info! status:" + statusCode));
            }
        }

        @Override
        protected void processTerminatedRequest(RequestEvent requestEvent, String reasonCode) {
            logger.error((Object)"Subscription to presence watcher info terminated!");
        }
    }

    private class PresenceSubscriberSubscription
    extends EventPackageSubscriber.Subscription {
        private final ContactSipImpl contact;

        public PresenceSubscriberSubscription(ContactSipImpl contact) throws OperationFailedException {
            super(OperationSetPresenceSipImpl.this.getAddress(contact));
            this.contact = contact;
        }

        @Override
        protected void processActiveRequest(RequestEvent requestEvent, byte[] rawContent) {
            SubscriptionStateHeader stateHeader;
            if (rawContent != null) {
                OperationSetPresenceSipImpl.this.setPidfPresenceStatus(new String(rawContent));
            }
            if ((stateHeader = (SubscriptionStateHeader)requestEvent.getRequest().getHeader("Subscription-State")) != null) {
                if ("pending".equals(stateHeader.getState())) {
                    this.contact.setSubscriptionState("pending");
                } else if ("active".equals(stateHeader.getState())) {
                    if ("pending".equals(this.contact.getSubscriptionState()) && OperationSetPresenceSipImpl.this.authorizationHandler != null) {
                        OperationSetPresenceSipImpl.this.authorizationHandler.processAuthorizationResponse(new AuthorizationResponse(AuthorizationResponse.ACCEPT, ""), (Contact)this.contact);
                    }
                    this.contact.setSubscriptionState("active");
                }
            }
        }

        @Override
        protected void processFailureResponse(ResponseEvent responseEvent, int statusCode) {
            OperationSetPresenceSipImpl.this.changePresenceStatusForContact(this.contact, OperationSetPresenceSipImpl.this.sipStatusEnum.getStatus(480 == statusCode ? "Offline" : "Unknown"));
            if (401 != statusCode && 407 != statusCode) {
                this.contact.setResolvable(false);
            }
        }

        @Override
        protected void processSuccessResponse(ResponseEvent responseEvent, int statusCode) {
            switch (statusCode) {
                case 200: 
                case 202: {
                    try {
                        if (this.contact.isResolved()) break;
                        if (OperationSetPresenceSipImpl.this.resolveContactID(this.contact.getAddress()) == null) {
                            ContactGroup parentGroup = this.contact.getParentContactGroup();
                            ((ContactGroupSipImpl)parentGroup).addContact(this.contact);
                            OperationSetPresenceSipImpl.this.fireSubscriptionEvent((Contact)this.contact, parentGroup, 1);
                        }
                        OperationSetPresenceSipImpl.this.finalizeSubscription(this.contact);
                        break;
                    }
                    catch (NullPointerException e) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)"failed to finalize the subscription of the contact", (Throwable)e);
                    }
                }
            }
        }

        @Override
        protected void processTerminatedRequest(RequestEvent requestEvent, String reasonCode) {
            SubscriptionStateHeader stateHeader;
            OperationSetPresenceSipImpl.this.terminateSubscription(this.contact);
            if ("deactivated".equals(reasonCode)) {
                try {
                    OperationSetPresenceSipImpl.this.ssContactList.removeContact(this.contact);
                }
                catch (OperationFailedException e) {
                    logger.error((Object)"Cannot remove contact that unsubscribed.", (Throwable)e);
                }
            }
            if ((stateHeader = (SubscriptionStateHeader)requestEvent.getRequest().getHeader("Subscription-State")) != null && "terminated".equals(stateHeader.getState())) {
                if ("rejected".equals(stateHeader.getReasonCode())) {
                    if ("pending".equals(this.contact.getSubscriptionState())) {
                        OperationSetPresenceSipImpl.this.authorizationHandler.processAuthorizationResponse(new AuthorizationResponse(AuthorizationResponse.REJECT, ""), (Contact)this.contact);
                    }
                    this.contact.setResolvable(false);
                }
                this.contact.setSubscriptionState("terminated");
            }
        }
    }

    private class PresenceNotifierSubscription
    extends EventPackageNotifier.Subscription {
        private final ContactSipImpl contact;

        public PresenceNotifierSubscription(Address fromAddress, String eventId) {
            super(fromAddress, eventId);
            OperationSetPresenceSipImpl.this.setUseDistantPA(false);
            ContactSipImpl contact = OperationSetPresenceSipImpl.this.resolveContactID(fromAddress.getURI().toString());
            if (contact == null) {
                contact = new ContactSipImpl(fromAddress, (ProtocolProviderServiceSipImpl)OperationSetPresenceSipImpl.this.parentProvider);
                contact.setResolved(true);
                contact.setResolvable(false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)((Object)((Object)contact) + " wants to watch your presence status"));
            }
            this.contact = contact;
        }

        @Override
        protected boolean addressEquals(Address address) {
            String addressString;
            String id1 = addressString = address.getURI().toString();
            String id2 = addressString.substring(4);
            int domainBeginIndex = addressString.indexOf(64);
            String id3 = addressString.substring(0, domainBeginIndex);
            String id4 = addressString.substring(4, domainBeginIndex);
            String contactAddressString = this.contact.getAddress();
            return contactAddressString.equals(id2) || contactAddressString.equals(id1) || contactAddressString.equals(id4) || contactAddressString.equals(id3);
        }

        @Override
        protected byte[] createNotifyContent(String subscriptionState, String reason) {
            return OperationSetPresenceSipImpl.this.getPidfPresenceStatus(OperationSetPresenceSipImpl.this.getLocalContactForDst(this.contact));
        }
    }

    private class PollOfflineContactsTask
    extends TimerTask {
        private PollOfflineContactsTask() {
        }

        @Override
        public void run() {
            Iterator rootContactsIter = OperationSetPresenceSipImpl.this.getServerStoredContactListRoot().contacts();
            while (rootContactsIter.hasNext()) {
                ContactSipImpl contact = (ContactSipImpl)((Object)rootContactsIter.next());
                OperationSetPresenceSipImpl.this.forcePollContact(contact);
            }
            Iterator groupsIter = OperationSetPresenceSipImpl.this.getServerStoredContactListRoot().subgroups();
            while (groupsIter.hasNext()) {
                ContactGroup group = (ContactGroup)groupsIter.next();
                Iterator contactsIter = group.contacts();
                while (contactsIter.hasNext()) {
                    ContactSipImpl contact = (ContactSipImpl)((Object)contactsIter.next());
                    OperationSetPresenceSipImpl.this.forcePollContact(contact);
                }
            }
        }
    }

    private class RePublishTask
    extends TimerTask {
        private RePublishTask() {
        }

        @Override
        public void run() {
            Request req = null;
            try {
                req = OperationSetPresenceSipImpl.this.distantPAET != null ? OperationSetPresenceSipImpl.this.createPublish(OperationSetPresenceSipImpl.this.subscriptionDuration, false) : OperationSetPresenceSipImpl.this.createPublish(OperationSetPresenceSipImpl.this.subscriptionDuration, true);
            }
            catch (OperationFailedException e) {
                logger.error((Object)"can't create a new PUBLISH message", (Throwable)e);
                return;
            }
            ClientTransaction transac = null;
            try {
                transac = ((ProtocolProviderServiceSipImpl)OperationSetPresenceSipImpl.this.parentProvider).getDefaultJainSipProvider().getNewClientTransaction(req);
            }
            catch (TransactionUnavailableException e) {
                logger.error((Object)"can't create the client transaction", (Throwable)e);
                return;
            }
            try {
                transac.sendRequest();
            }
            catch (SipException e) {
                logger.error((Object)"can't send the PUBLISH request", (Throwable)e);
                return;
            }
        }
    }

    private static enum WatcherStatus {
        PENDING("pending"),
        ACTIVE("active"),
        WAITING("waiting"),
        TERMINATED("terminated");

        private final String value;

        private WatcherStatus(String v) {
            this.value = v;
        }

        public String getValue() {
            return this.value;
        }
    }
}

