/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.util.Hashtable;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.spellcheck.LanguageMenuBar;
import net.java.sip.communicator.plugin.spellcheck.SpellChecker;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SpellCheckActivator
extends AbstractServiceDependentActivator {
    private static final Logger logger = Logger.getLogger(SpellCheckActivator.class);
    static BundleContext bundleContext;
    private static UIService uiService;
    private static FileAccessService faService;
    private static ConfigurationService configService;
    private static SpellChecker checker;

    public void start(Object dependentService) {
        Hashtable<String, String> containerFilter = new Hashtable<String, String>();
        containerFilter.put("CONTAINER_ID", Container.CONTAINER_CHAT_TOOL_BAR.getID());
        bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new PluginComponentFactory(Container.CONTAINER_CHAT_TOOL_BAR, "Right", -1, false){

            protected PluginComponent getPluginInstance() {
                LanguageMenuBarCreator creator = new LanguageMenuBarCreator(this);
                try {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeAndWait(creator);
                    } else {
                        creator.run();
                    }
                    return creator.menuBar;
                }
                catch (Throwable t) {
                    logger.error((Object)"Error creating LanguageMenuBar", t);
                    return null;
                }
            }
        }, containerFilter);
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public static UIService getUIService() {
        if (uiService != null) {
            return uiService;
        }
        ServiceReference uiServiceRef = bundleContext.getServiceReference(UIService.class.getName());
        uiService = (UIService)bundleContext.getService(uiServiceRef);
        return uiService;
    }

    public static FileAccessService getFileAccessService() {
        if (faService != null) {
            return faService;
        }
        ServiceReference faServiceReference = bundleContext.getServiceReference(FileAccessService.class.getName());
        faService = (FileAccessService)bundleContext.getService(faServiceReference);
        return faService;
    }

    public static ConfigurationService getConfigService() {
        if (configService != null) {
            return configService;
        }
        ServiceReference configServiceRef = bundleContext.getServiceReference(ConfigurationService.class.getName());
        configService = (ConfigurationService)bundleContext.getService(configServiceRef);
        return configService;
    }

    public void stop(BundleContext arg0) throws Exception {
    }

    static {
        checker = null;
    }

    private class LanguageMenuBarCreator
    implements Runnable {
        LanguageMenuBar menuBar;
        final PluginComponentFactory parentFactory;

        LanguageMenuBarCreator(PluginComponentFactory parentFactory) {
            this.parentFactory = parentFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SpellCheckActivator spellCheckActivator = SpellCheckActivator.this;
            synchronized (spellCheckActivator) {
                if (checker == null) {
                    checker = new SpellChecker();
                }
            }
            try {
                checker.start(bundleContext);
            }
            catch (Exception ex) {
                logger.error((Object)"Error starting SpellChecker", (Throwable)ex);
            }
            this.menuBar = new LanguageMenuBar(checker, this.parentFactory);
            this.menuBar.createSpellCheckerWorker(checker.getLocale()).start();
        }
    }
}

