/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.IMessageReader;
import com.ircclouds.irc.api.comms.INeedsConnection;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.om.AbstractMessageFactory;
import com.ircclouds.irc.api.om.IRCOMException;
import com.ircclouds.irc.api.utils.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageReader
implements IMessageReader,
INeedsConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMessageReader.class);
    private String crlf = "";
    private AbstractMessageFactory msgFactory;
    private StringBuilder ircData = new StringBuilder();
    private Queue<String> ircMessages = new LinkedList<String>();
    private boolean canRead = true;

    public AbstractMessageReader() {
        this.msgFactory = new AbstractMessageFactory(){

            @Override
            protected IRCServerOptions getIRCServerOptions() {
                return AbstractMessageReader.this.getIRCServerOptions();
            }
        };
    }

    @Override
    public boolean available() throws IOException {
        if (this.canRead) {
            this.ircData.append(this.getConnection().read());
            this.canRead = false;
            this.trySetNewLine();
            this.fetchNextBatch();
        }
        return true;
    }

    @Override
    public IMessage readMessage() {
        IMessage _msg = null;
        if (this.ircMessages.peek() != null) {
            try {
                _msg = this.msgFactory.build(this.ircMessages.poll());
            }
            catch (IRCOMException aExc) {
                LOG.error("Error from the OM layer", (Throwable)aExc);
            }
        }
        this.canRead = this.ircMessages.isEmpty();
        return _msg;
    }

    @Override
    public void reset() {
        this.ircMessages.clear();
        this.ircData.setLength(0);
        this.canRead = true;
    }

    protected abstract IRCServerOptions getIRCServerOptions();

    private void trySetNewLine() {
        if (!StringUtils.isEmpty(this.crlf)) {
            return;
        }
        if (this.ircData.indexOf("\r\n") != -1) {
            this.crlf = "\r\n";
        } else if (this.ircData.indexOf("\n") != -1) {
            this.crlf = "\n";
        }
    }

    private void fetchNextBatch() {
        if (this.ircData.indexOf(this.crlf) != -1) {
            String _tempMsg = this.ircData.toString();
            if (this.ircData.lastIndexOf(this.crlf) != this.ircData.length() - this.crlf.length() - 1) {
                int _i = this.ircData.lastIndexOf(this.crlf);
                _tempMsg = this.ircData.substring(0, _i);
                this.ircData = new StringBuilder(this.ircData.substring(_i + this.crlf.length()));
            } else {
                this.ircData.setLength(0);
            }
            this.ircMessages.addAll(Arrays.asList(_tempMsg.split(this.crlf)));
        }
    }
}

