/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.PublicKey;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.java.otr4j.OtrPolicy;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.OtrWeakListener;
import net.java.sip.communicator.plugin.otr.ScOtrEngineListener;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManagerListener;
import net.java.sip.communicator.plugin.otr.ScSessionStatus;
import net.java.sip.communicator.plugin.otr.SwingOtrActionHandler;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;

class OtrContactMenu
implements ActionListener,
ScOtrEngineListener,
ScOtrKeyManagerListener {
    private final Logger logger = Logger.getLogger(OtrContactMenu.class);
    private static final String ACTION_COMMAND_AUTHENTICATE_BUDDY = "AUTHENTICATE_BUDDY";
    private static final String ACTION_COMMAND_CB_AUTO = "CB_AUTO";
    private static final String ACTION_COMMAND_CB_AUTO_ALL = "CB_AUTO_ALL";
    private static final String ACTION_COMMAND_CB_ENABLE = "CB_ENABLE";
    private static final String ACTION_COMMAND_CB_REQUIRE = "CB_REQUIRE";
    private static final String ACTION_COMMAND_CB_RESET = "CB_RESET";
    private static final String ACTION_COMMAND_END_OTR = "END_OTR";
    private static final String ACTION_COMMAND_REFRESH_OTR = "REFRESH_OTR";
    private static final String ACTION_COMMAND_START_OTR = "START_OTR";
    private final OtrContactManager.OtrContact contact;
    private final boolean inMacOSXScreenMenuBar;
    private OtrPolicy otrPolicy;
    private ScSessionStatus sessionStatus;
    private final JMenu parentMenu;
    private final SIPCommMenu separateMenu;

    public OtrContactMenu(OtrContactManager.OtrContact otrContact, boolean inMacOSXScreenMenuBar, JMenu menu, boolean isSeparateMenu) {
        this.contact = otrContact;
        this.inMacOSXScreenMenuBar = inMacOSXScreenMenuBar;
        this.parentMenu = menu;
        String resourceName = otrContact.resource != null ? "/" + otrContact.resource.getResourceName() : "";
        this.separateMenu = isSeparateMenu ? new SIPCommMenu(otrContact.contact.getDisplayName() + resourceName) : null;
        new OtrWeakListener<OtrContactMenu>(this, OtrActivator.scOtrEngine, OtrActivator.scOtrKeyManager);
        this.setSessionStatus(OtrActivator.scOtrEngine.getSessionStatus(this.contact));
        this.setOtrPolicy(OtrActivator.scOtrEngine.getContactPolicy(otrContact.contact));
        this.buildMenu();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (ACTION_COMMAND_END_OTR.equals(actionCommand)) {
            OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(this.contact.contact);
            policy.setSendWhitespaceTag(false);
            OtrActivator.scOtrEngine.setContactPolicy(this.contact.contact, policy);
            OtrActivator.scOtrEngine.endSession(this.contact);
        } else if (ACTION_COMMAND_START_OTR.equals(actionCommand)) {
            OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(this.contact.contact);
            OtrPolicy globalPolicy = OtrActivator.scOtrEngine.getGlobalPolicy();
            policy.setSendWhitespaceTag(globalPolicy.getSendWhitespaceTag());
            OtrActivator.scOtrEngine.setContactPolicy(this.contact.contact, policy);
            OtrActivator.scOtrEngine.startSession(this.contact);
        } else if (ACTION_COMMAND_REFRESH_OTR.equals(actionCommand)) {
            OtrActivator.scOtrEngine.refreshSession(this.contact);
        } else if (ACTION_COMMAND_AUTHENTICATE_BUDDY.equals(actionCommand)) {
            SwingOtrActionHandler.openAuthDialog(this.contact);
        } else if (ACTION_COMMAND_CB_ENABLE.equals(actionCommand)) {
            OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(this.contact.contact);
            boolean state = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            policy.setEnableManual(state);
            OtrActivator.scOtrEngine.setContactPolicy(this.contact.contact, policy);
        } else if (ACTION_COMMAND_CB_AUTO.equals(actionCommand)) {
            OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(this.contact.contact);
            boolean state = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            policy.setSendWhitespaceTag(state);
            OtrActivator.scOtrEngine.setContactPolicy(this.contact.contact, policy);
        } else if (ACTION_COMMAND_CB_AUTO_ALL.equals(actionCommand)) {
            OtrPolicy globalPolicy = OtrActivator.scOtrEngine.getGlobalPolicy();
            boolean state = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            globalPolicy.setSendWhitespaceTag(state);
            OtrActivator.scOtrEngine.setGlobalPolicy(globalPolicy);
        } else if (ACTION_COMMAND_CB_REQUIRE.equals(actionCommand)) {
            OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(this.contact.contact);
            boolean state = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            policy.setRequireEncryption(state);
            OtrActivator.configService.setProperty("net.java.sip.communicator.plugin.otr.PRIVATE_MESSAGING_MANDATORY", (Object)Boolean.toString(state));
            OtrActivator.scOtrEngine.setContactPolicy(this.contact.contact, policy);
        } else if (ACTION_COMMAND_CB_RESET.equals(actionCommand)) {
            OtrActivator.scOtrEngine.setContactPolicy(this.contact.contact, null);
        }
    }

    @Override
    public void contactPolicyChanged(Contact contact) {
        if (this.contact != null && contact.equals(this.contact.contact)) {
            this.setOtrPolicy(OtrActivator.scOtrEngine.getContactPolicy(contact));
        }
    }

    @Override
    public void contactVerificationStatusChanged(OtrContactManager.OtrContact otrContact) {
        if (otrContact.equals(this.contact)) {
            this.setSessionStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
        }
    }

    void dispose() {
        OtrActivator.scOtrEngine.removeListener(this);
        OtrActivator.scOtrKeyManager.removeListener(this);
    }

    @Override
    public void globalPolicyChanged() {
        this.setOtrPolicy(OtrActivator.scOtrEngine.getContactPolicy(this.contact.contact));
    }

    private void buildMenu() {
        if (this.separateMenu != null) {
            this.separateMenu.removeAll();
        }
        OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(this.contact.contact);
        JMenuItem endOtr = new JMenuItem();
        endOtr.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.END_OTR"));
        endOtr.setActionCommand(ACTION_COMMAND_END_OTR);
        endOtr.addActionListener(this);
        JMenuItem startOtr = new JMenuItem();
        startOtr.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.START_OTR"));
        startOtr.setEnabled(policy.getEnableManual());
        startOtr.setActionCommand(ACTION_COMMAND_START_OTR);
        startOtr.addActionListener(this);
        JMenuItem refreshOtr = new JMenuItem();
        refreshOtr.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.REFRESH_OTR"));
        refreshOtr.setEnabled(policy.getEnableManual());
        refreshOtr.setActionCommand(ACTION_COMMAND_REFRESH_OTR);
        refreshOtr.addActionListener(this);
        switch (this.sessionStatus) {
            case LOADING: {
                if (this.separateMenu != null) {
                    this.separateMenu.add(endOtr);
                    this.separateMenu.add(refreshOtr);
                    break;
                }
                this.parentMenu.add(endOtr);
                this.parentMenu.add(refreshOtr);
                break;
            }
            case ENCRYPTED: {
                JMenuItem authBuddy = new JMenuItem();
                authBuddy.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.AUTHENTICATE_BUDDY"));
                authBuddy.setActionCommand(ACTION_COMMAND_AUTHENTICATE_BUDDY);
                authBuddy.addActionListener(this);
                if (this.separateMenu != null) {
                    this.separateMenu.add(endOtr);
                    this.separateMenu.add(refreshOtr);
                    this.separateMenu.add(authBuddy);
                    break;
                }
                this.parentMenu.add(endOtr);
                this.parentMenu.add(refreshOtr);
                this.parentMenu.add(authBuddy);
                break;
            }
            case FINISHED: {
                if (this.separateMenu != null) {
                    this.separateMenu.add(endOtr);
                    this.separateMenu.add(refreshOtr);
                    break;
                }
                this.parentMenu.add(endOtr);
                this.parentMenu.add(refreshOtr);
                break;
            }
            case TIMED_OUT: 
            case PLAINTEXT: {
                if (this.separateMenu != null) {
                    this.separateMenu.add(startOtr);
                    break;
                }
                this.parentMenu.add(startOtr);
            }
        }
        JCheckBoxMenuItem cbEnable = new JCheckBoxMenuItem();
        cbEnable.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.CB_ENABLE"));
        cbEnable.setSelected(policy.getEnableManual());
        cbEnable.setActionCommand(ACTION_COMMAND_CB_ENABLE);
        cbEnable.addActionListener(this);
        JCheckBoxMenuItem cbAlways = new JCheckBoxMenuItem();
        cbAlways.setText(String.format(OtrActivator.resourceService.getI18NString("plugin.otr.menu.CB_AUTO", new String[]{this.contact.contact.getDisplayName()}), new Object[0]));
        cbAlways.setEnabled(policy.getEnableManual());
        cbAlways.setSelected(policy.getEnableAlways());
        cbAlways.setActionCommand(ACTION_COMMAND_CB_AUTO);
        cbAlways.addActionListener(this);
        JCheckBoxMenuItem cbAlwaysAll = new JCheckBoxMenuItem();
        cbAlwaysAll.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.CB_AUTO_ALL"));
        cbAlwaysAll.setEnabled(policy.getEnableManual());
        boolean isAutoInit = OtrActivator.scOtrEngine.getGlobalPolicy().getEnableAlways();
        cbAlwaysAll.setSelected(isAutoInit);
        cbAlwaysAll.setActionCommand(ACTION_COMMAND_CB_AUTO_ALL);
        cbAlwaysAll.addActionListener(this);
        JCheckBoxMenuItem cbRequire = new JCheckBoxMenuItem();
        cbRequire.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.CB_REQUIRE"));
        cbRequire.setEnabled(policy.getEnableManual());
        String otrMandatoryPropValue = OtrActivator.configService.getString("net.java.sip.communicator.plugin.otr.PRIVATE_MESSAGING_MANDATORY");
        String defaultOtrPropValue = OtrActivator.resourceService.getSettingsString("net.java.sip.communicator.plugin.otr.PRIVATE_MESSAGING_MANDATORY");
        boolean isMandatory = policy.getRequireEncryption();
        if (otrMandatoryPropValue != null) {
            isMandatory = Boolean.parseBoolean(otrMandatoryPropValue);
        } else if (!isMandatory && defaultOtrPropValue != null) {
            isMandatory = Boolean.parseBoolean(defaultOtrPropValue);
        }
        cbRequire.setSelected(isMandatory);
        cbRequire.setActionCommand(ACTION_COMMAND_CB_REQUIRE);
        cbRequire.addActionListener(this);
        JMenuItem cbReset = new JMenuItem();
        cbReset.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.CB_RESET"));
        cbReset.setActionCommand(ACTION_COMMAND_CB_RESET);
        cbReset.addActionListener(this);
        if (this.separateMenu != null) {
            this.separateMenu.addSeparator();
            this.separateMenu.add((JMenuItem)cbEnable);
            this.separateMenu.add((JMenuItem)cbAlways);
            this.separateMenu.add((JMenuItem)cbAlwaysAll);
            this.separateMenu.add((JMenuItem)cbRequire);
            this.separateMenu.addSeparator();
            this.separateMenu.add(cbReset);
            this.parentMenu.add((JMenuItem)this.separateMenu);
        } else {
            this.parentMenu.addSeparator();
            this.parentMenu.add(cbEnable);
            this.parentMenu.add(cbAlways);
            this.parentMenu.add(cbAlwaysAll);
            this.parentMenu.add(cbRequire);
            this.parentMenu.addSeparator();
            this.parentMenu.add(cbReset);
        }
    }

    @Override
    public void sessionStatusChanged(OtrContactManager.OtrContact otrContact) {
        if (otrContact.equals(this.contact)) {
            this.setSessionStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
        }
    }

    private void setSessionStatus(ScSessionStatus sessionStatus) {
        if (sessionStatus != this.sessionStatus) {
            this.logger.debug((Object)("Setting session status of contact " + this.contact.contact + " to " + (Object)((Object)sessionStatus) + ". Was " + (Object)((Object)this.sessionStatus)));
            this.sessionStatus = sessionStatus;
            if (this.separateMenu != null) {
                this.updateIcon();
                if (this.separateMenu.isPopupMenuVisible() || this.inMacOSXScreenMenuBar) {
                    this.buildMenu();
                }
            }
        }
    }

    private void setOtrPolicy(OtrPolicy otrPolicy) {
        if (!otrPolicy.equals(this.otrPolicy)) {
            this.otrPolicy = otrPolicy;
            if (this.separateMenu != null && (this.separateMenu.isPopupMenuVisible() || this.inMacOSXScreenMenuBar)) {
                this.buildMenu();
            }
        }
    }

    private void updateIcon() {
        String imageID;
        if (this.separateMenu == null) {
            return;
        }
        switch (this.sessionStatus) {
            case ENCRYPTED: {
                PublicKey pubKey = OtrActivator.scOtrEngine.getRemotePublicKey(this.contact);
                String fingerprint = OtrActivator.scOtrKeyManager.getFingerprintFromPublicKey(pubKey);
                imageID = OtrActivator.scOtrKeyManager.isVerified(this.contact.contact, fingerprint) ? "plugin.otr.ENCRYPTED_ICON_16x16" : "plugin.otr.ENCRYPTED_UNVERIFIED_ICON_16x16";
                break;
            }
            case FINISHED: {
                imageID = "plugin.otr.FINISHED_ICON_16x16";
                break;
            }
            case PLAINTEXT: {
                imageID = "plugin.otr.PLAINTEXT_ICON_16x16";
                break;
            }
            default: {
                return;
            }
        }
        this.separateMenu.setIcon((Icon)OtrActivator.resourceService.getImage(imageID));
    }

    @Override
    public void multipleInstancesDetected(OtrContactManager.OtrContact contact) {
    }

    @Override
    public void outgoingSessionChanged(OtrContactManager.OtrContact otrContact) {
        if (otrContact.equals(this.contact)) {
            this.setSessionStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
        }
    }
}

