/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.presence;

import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.presence.StatusEntry;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountStatusUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class ReadonlyStatusItem
extends JMenuItem
implements StatusEntry,
Skinnable {
    private final Logger logger = Logger.getLogger(ReadonlyStatusItem.class);
    private Image connectingIcon;
    private boolean isConnecting;
    private PresenceStatus offlineStatus;
    private PresenceStatus onlineStatus;
    protected ProtocolProviderService protocolProvider;

    public ReadonlyStatusItem(ProtocolProviderService protocolProvider) {
        super(protocolProvider.getAccountID().getDisplayName(), ImageLoader.getAccountStatusImage(protocolProvider));
        this.protocolProvider = protocolProvider;
        this.loadSkin();
        String tooltip = "<html><b>" + protocolProvider.getAccountID().getDisplayName() + "</b><br>Connecting</html>";
        this.setToolTipText(tooltip);
        this.offlineStatus = AccountStatusUtils.getOfflineStatus((ProtocolProviderService)protocolProvider);
        this.onlineStatus = AccountStatusUtils.getOnlineStatus((ProtocolProviderService)protocolProvider);
        this.setSelectedStatus(this.offlineStatus);
        this.updateStatus(this.offlineStatus);
    }

    public void setSelectedStatus(PresenceStatus status) {
        ImageIcon statusImage = ImageLoader.getAccountStatusImage(this.protocolProvider);
        this.setIcon(statusImage);
        String tooltip = this.getToolTipText();
        tooltip = tooltip.substring(0, tooltip.lastIndexOf("<br>"));
        if (status != null) {
            this.setToolTipText(tooltip.concat("<br>" + status.getStatusName()));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing((Graphics)g);
        super.paintComponent(g);
        if (this.isConnecting) {
            g.drawImage(this.getConnectingIcon(), 0, 3, this);
        }
    }

    private Image getConnectingIcon() {
        if (this.connectingIcon == null) {
            this.connectingIcon = GuiActivator.getResources().getImage("service.gui.icons.CONNECTING").getImage();
        }
        return this.connectingIcon;
    }

    private void clearConnectingIcon() {
        if (this.connectingIcon != null) {
            this.connectingIcon.flush();
            this.connectingIcon = null;
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        this.repaint();
        return true;
    }

    @Override
    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    @Override
    public PresenceStatus getOfflineStatus() {
        return this.offlineStatus;
    }

    @Override
    public PresenceStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    public void loadSkin() {
        this.clearConnectingIcon();
        this.setIcon(ImageLoader.getAccountStatusImage(this.protocolProvider));
    }

    @Override
    public void dispose() {
        this.protocolProvider = null;
        this.clearConnectingIcon();
        this.onlineStatus = null;
        this.offlineStatus = null;
    }

    @Override
    public JMenuItem getEntryComponent() {
        return this;
    }

    @Override
    public void startConnecting() {
        this.setConnecting(true);
    }

    @Override
    public void stopConnecting() {
        this.clearConnectingIcon();
        this.setConnecting(false);
    }

    private void setConnecting(boolean isConnecting) {
        this.isConnecting = isConnecting;
        this.repaint();
    }

    @Override
    public void updateStatus(PresenceStatus presenceStatus) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Update status for provider: " + this.protocolProvider.getAccountID().getAccountAddress() + ". The new status will be: " + presenceStatus.getStatusName()));
        }
        this.setSelectedStatus(presenceStatus);
    }
}

