/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.menus;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChatRightButtonMenu
extends SIPCommPopupMenu
implements ActionListener,
Skinnable {
    private ChatConversationPanel chatConvPanel;
    private JMenuItem copyMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.COPY"), new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
    private JMenuItem closeMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CLOSE"), new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSE_ICON)));

    public ChatRightButtonMenu(ChatConversationPanel chatConvPanel) {
        this.chatConvPanel = chatConvPanel;
        this.init();
    }

    private void init() {
        this.add(this.copyMenuItem);
        this.addSeparator();
        this.add(this.closeMenuItem);
        this.copyMenuItem.setName("copy");
        this.closeMenuItem.setName("service.gui.CLOSE");
        this.copyMenuItem.addActionListener(this);
        this.closeMenuItem.addActionListener(this);
        this.copyMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.COPY"));
        this.closeMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CLOSE"));
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
    }

    public void disableCopy() {
        this.copyMenuItem.setEnabled(false);
    }

    public void enableCopy() {
        this.copyMenuItem.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemText = menuItem.getName();
        if (itemText.equalsIgnoreCase("copy")) {
            this.chatConvPanel.copyConversation();
        } else if (!itemText.equalsIgnoreCase("save") && !itemText.equalsIgnoreCase("print") && itemText.equalsIgnoreCase("service.gui.CLOSE")) {
            Window window = this.chatConvPanel.getChatContainer().getConversationContainerWindow();
            window.setVisible(false);
            window.dispose();
        }
    }

    public void loadSkin() {
        this.copyMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
        this.closeMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSE_ICON)));
    }

    public void dispose() {
        this.chatConvPanel = null;
        this.copyMenuItem = null;
        this.closeMenuItem = null;
    }
}

