/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransferHandler;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransportSelectorBox;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.menus.WritePanelRightButtonMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommHTMLEditorKit;
import net.java.sip.communicator.plugin.desktoputil.SIPCommScrollPane;
import net.java.sip.communicator.plugin.desktoputil.SIPCommToggleButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.event.ChatMenuListener;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ChatWritePanel
extends TransparentPanel
implements ActionListener,
KeyListener,
MouseListener,
UndoableEditListener,
DocumentListener,
PluginComponentListener,
Skinnable,
ChatSessionChangeListener {
    private static final Logger logger = Logger.getLogger(ChatWritePanel.class);
    private final JEditorPane editorPane = new JEditorPane();
    private final UndoManager undo = new UndoManager();
    private final ChatPanel chatPanel;
    private final Timer stoppedTypingTimer = new Timer(2000, this);
    private final Timer typingTimer = new Timer(5000, this);
    private int typingState = 4;
    private WritePanelRightButtonMenu rightButtonMenu;
    private final ArrayList<ChatMenuListener> menuListeners = new ArrayList();
    private final SIPCommScrollPane scrollPane = new SIPCommScrollPane();
    private ChatTransportSelectorBox transportSelectorBox;
    private final Container centerPanel;
    private SIPCommToggleButton smsButton;
    private JLabel smsCharCountLabel;
    private JLabel smsNumberLabel;
    private int smsNumberCount = 1;
    private int smsCharCount = 160;
    private boolean smsMode = false;
    private boolean disableMergedSmsMode = false;
    private static final String MERGE_SMS_MODE_DISABLED_PROP = "net.java.sip.communicator.impl.gui.MERGE_SMS_MODE_DISABLED";
    private java.util.Timer outdatedResourceTimer = null;
    private boolean isOutdatedResource = true;
    private List<PluginComponent> pluginComponents = Collections.synchronizedList(new ArrayList());

    public ChatWritePanel(ChatPanel panel) {
        super((LayoutManager)new BorderLayout());
        this.chatPanel = panel;
        this.centerPanel = this.createCenter();
        int chatAreaSize = ConfigurationUtils.getChatWriteAreaSize();
        Dimension writeMessagePanelDefaultSize = new Dimension(500, chatAreaSize > 0 ? chatAreaSize : 28);
        Dimension writeMessagePanelMinSize = new Dimension(500, 28);
        Dimension writeMessagePanelMaxSize = new Dimension(500, 100);
        this.setMinimumSize(writeMessagePanelMinSize);
        this.setMaximumSize(writeMessagePanelMaxSize);
        this.setPreferredSize(writeMessagePanelDefaultSize);
        this.add(this.centerPanel, "Center");
        this.rightButtonMenu = new WritePanelRightButtonMenu(this.chatPanel.getChatContainer());
        this.typingTimer.setRepeats(true);
        ConfigurationService configService = GuiActivator.getConfigurationService();
        this.disableMergedSmsMode = configService.getBoolean(MERGE_SMS_MODE_DISABLED_PROP, this.disableMergedSmsMode);
        String messageCommandProperty = "service.gui.SEND_MESSAGE_COMMAND";
        String messageCommand = configService.getString(messageCommandProperty);
        if (messageCommand == null) {
            messageCommand = GuiActivator.getResources().getSettingsString(messageCommandProperty);
        }
        this.changeSendCommand(messageCommand == null || messageCommand.equalsIgnoreCase("enter"));
        if (ConfigurationUtils.isFontSupportEnabled()) {
            this.initDefaultFontConfiguration();
        }
    }

    private void initDefaultFontConfiguration() {
        String fontFamily = ConfigurationUtils.getChatDefaultFontFamily();
        int fontSize = ConfigurationUtils.getChatDefaultFontSize();
        if (fontFamily != null && fontSize > 0) {
            this.setFontFamilyAndSize(fontFamily, fontSize);
        }
        this.setBoldStyleEnable(ConfigurationUtils.isChatFontBold());
        this.setItalicStyleEnable(ConfigurationUtils.isChatFontItalic());
        this.setUnderlineStyleEnable(ConfigurationUtils.isChatFontUnderline());
        Color fontColor = ConfigurationUtils.getChatDefaultFontColor();
        if (fontColor != null) {
            this.setFontColor(fontColor);
        }
    }

    private Container createCenter() {
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.setBackground(Color.WHITE);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 3));
        GridBagConstraints constraints = new GridBagConstraints();
        this.initSmsLabel(centerPanel);
        this.initTextArea(centerPanel);
        this.smsCharCountLabel = new JLabel(String.valueOf(this.smsCharCount));
        this.smsCharCountLabel.setForeground(Color.GRAY);
        this.smsCharCountLabel.setVisible(false);
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 2, 0, 2);
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        centerPanel.add((Component)this.smsCharCountLabel, constraints);
        this.smsNumberLabel = new JLabel(String.valueOf(this.smsNumberCount)){

            @Override
            public void paintComponent(Graphics g) {
                AntialiasingManager.activateAntialiasing((Graphics)g);
                g.setColor(this.getBackground());
                g.fillOval(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        this.smsNumberLabel.setHorizontalAlignment(0);
        this.smsNumberLabel.setPreferredSize(new Dimension(18, 18));
        this.smsNumberLabel.setMinimumSize(new Dimension(18, 18));
        this.smsNumberLabel.setForeground(Color.WHITE);
        this.smsNumberLabel.setBackground(Color.GRAY);
        this.smsNumberLabel.setVisible(false);
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 2, 0, 2);
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        centerPanel.add((Component)this.smsNumberLabel, constraints);
        return centerPanel;
    }

    private void initSmsLabel(final JPanel centerPanel) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 3, 0, 0);
        ImageID smsIcon = new ImageID("service.gui.icons.SEND_SMS");
        ImageID selectedIcon = new ImageID("service.gui.icons.SEND_SMS_SELECTED");
        this.smsButton = new SIPCommToggleButton((Image)ImageLoader.getImage(smsIcon), (Image)ImageLoader.getImage(selectedIcon), (Image)ImageLoader.getImage(smsIcon), (Image)ImageLoader.getImage(selectedIcon));
        this.smsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color bgColor;
                if (ChatWritePanel.this.smsMode && !ChatWritePanel.this.isIMAllowed()) {
                    return;
                }
                ChatWritePanel.this.smsMode = ChatWritePanel.this.smsButton.isSelected();
                if (ChatWritePanel.this.smsMode) {
                    bgColor = new Color(GuiActivator.getResources().getColor("service.gui.LIST_SELECTION_COLOR"));
                    ChatWritePanel.this.smsCharCountLabel.setVisible(true);
                    ChatWritePanel.this.smsNumberLabel.setVisible(true);
                } else {
                    bgColor = Color.WHITE;
                    ChatWritePanel.this.smsCharCountLabel.setVisible(false);
                    ChatWritePanel.this.smsNumberLabel.setVisible(false);
                }
                centerPanel.setBackground(bgColor);
                ChatWritePanel.this.editorPane.setBackground(bgColor);
            }
        });
        this.smsButton.setVisible(false);
        centerPanel.add((Component)this.smsButton, constraints);
    }

    private void initTextArea(JPanel centerPanel) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.editorPane.setContentType("text/html");
        this.editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.editorPane.setCaretPosition(0);
        this.editorPane.setEditorKit((EditorKit)new SIPCommHTMLEditorKit((JComponent)((Object)this)));
        this.editorPane.getDocument().addUndoableEditListener(this);
        this.editorPane.getDocument().addDocumentListener(this);
        this.editorPane.addKeyListener(this);
        this.editorPane.addMouseListener(this);
        this.editorPane.setCursor(Cursor.getPredefinedCursor(2));
        this.editorPane.setDragEnabled(true);
        this.editorPane.setTransferHandler((TransferHandler)((Object)new ChatTransferHandler(this.chatPanel)));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView((Component)this.editorPane);
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        centerPanel.add((Component)this.scrollPane, constraints);
    }

    public void dispose() {
        this.typingTimer.stop();
        this.typingTimer.removeActionListener(this);
        this.stoppedTypingTimer.stop();
        this.stoppedTypingTimer.removeActionListener(this);
        if (this.typingState != 4) {
            this.stopTypingTimer();
        }
        if (this.outdatedResourceTimer != null) {
            this.outdatedResourceTimer.cancel();
            this.outdatedResourceTimer.purge();
            this.outdatedResourceTimer = null;
        }
        this.editorPane.removeKeyListener(this);
        this.menuListeners.clear();
        if (this.rightButtonMenu != null) {
            this.rightButtonMenu.dispose();
            this.rightButtonMenu = null;
        }
        this.scrollPane.dispose();
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public void changeSendCommand(boolean isEnter) {
        ActionMap actionMap = this.editorPane.getActionMap();
        actionMap.put("send", new SendMessageAction());
        actionMap.put("newLine", new NewLineAction());
        InputMap im = this.editorPane.getInputMap();
        if (isEnter) {
            im.put(KeyStroke.getKeyStroke(10, 0), "send");
            im.put(KeyStroke.getKeyStroke(10, 128), "newLine");
            im.put(KeyStroke.getKeyStroke(10, 64), "newLine");
            this.setToolTipText("<html>" + GuiActivator.getResources().getI18NString("service.gui.SEND_MESSAGE") + " - Enter <br> Use Ctrl-Enter or Shift-Enter to make a new line</html>");
        } else {
            im.put(KeyStroke.getKeyStroke(10, 128), "send");
            im.put(KeyStroke.getKeyStroke(10, 0), "newLine");
            this.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.SEND_MESSAGE") + " Ctrl-Enter");
        }
    }

    public void setSmsSelected(boolean selected) {
        if (this.disableMergedSmsMode && this.isIMAllowed()) {
            return;
        }
        if (selected && !this.smsButton.isSelected() || !selected && this.smsButton.isSelected()) {
            this.smsButton.doClick();
        }
    }

    public boolean isSmsSelected() {
        return this.smsMode;
    }

    private boolean isIMAllowed() {
        List imContact;
        Object descr = this.chatPanel.getChatSession().getDescriptor();
        return !(descr instanceof MetaContact ? (imContact = ((MetaContact)descr).getContactsForOperationSet(OperationSetBasicInstantMessaging.class)) == null || imContact.size() == 0 : descr instanceof SourceContact && ((imContact = ((SourceContact)descr).getContactDetails(OperationSetBasicInstantMessaging.class)) == null || imContact.size() == 0));
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undo.addEdit(e.getEdit());
    }

    private void undo() {
        try {
            this.undo.undo();
        }
        catch (CannotUndoException e) {
            logger.error((Object)"Unable to undo.", (Throwable)e);
        }
    }

    private void redo() {
        try {
            this.undo.redo();
        }
        catch (CannotRedoException e) {
            logger.error((Object)"Unable to redo.", (Throwable)e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (ConfigurationUtils.isSendTypingNotifications() && !this.smsMode) {
            if (this.typingState != 1) {
                this.stoppedTypingTimer.setDelay(2000);
                this.typingState = 1;
                int result = this.chatPanel.getChatSession().getCurrentChatTransport().sendTypingNotification(this.typingState);
                if (result == 1) {
                    this.typingTimer.start();
                }
            }
            if (!this.stoppedTypingTimer.isRunning()) {
                this.stoppedTypingTimer.start();
            } else {
                this.stoppedTypingTimer.restart();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((e.getModifiers() & 2) == 2 && e.getKeyCode() == 90 && (e.getModifiers() & 8) != 8) {
            if (this.undo.canUndo()) {
                this.undo();
            }
        } else if ((e.getModifiers() & 2) == 2 && e.getKeyCode() == 82 && (e.getModifiers() & 8) != 8) {
            if (this.undo.canRedo()) {
                this.redo();
            }
        } else if (e.getKeyCode() == 9) {
            String sequence;
            int position;
            if (!(this.chatPanel.getChatSession() instanceof ConferenceChatSession)) {
                return;
            }
            e.consume();
            int index = ((JEditorPane)e.getSource()).getCaretPosition();
            StringBuffer message = new StringBuffer(this.chatPanel.getMessage());
            for (position = index - 1; position > 0 && message.charAt(position) != ' '; --position) {
            }
            if (position != 0) {
                ++position;
            }
            if ((sequence = message.substring(position, index)).length() <= 0) {
                return;
            }
            Iterator<ChatContact<?>> iter = this.chatPanel.getChatSession().getParticipants();
            ArrayList<String> contacts = new ArrayList<String>();
            while (iter.hasNext()) {
                ChatContact<?> c = iter.next();
                if (c.getName().length() < index - position || !c.getName().substring(0, index - position).equals(sequence)) continue;
                message.replace(position, index, c.getName().substring(0, index - position));
                contacts.add(c.getName());
            }
            if (contacts.size() > 1) {
                char key = ((String)contacts.get(0)).charAt(index - position - 1);
                int pos = index - position - 1;
                boolean flag = true;
                while (flag) {
                    try {
                        for (String name : contacts) {
                            if (key == name.charAt(pos)) continue;
                            flag = false;
                        }
                        if (!flag) continue;
                        key = ((String)contacts.get(0)).charAt(++pos);
                    }
                    catch (IndexOutOfBoundsException exp) {
                        flag = false;
                    }
                }
                message.replace(position, index, ((String)contacts.get(0)).substring(0, pos));
                Iterator contactIter = contacts.iterator();
                String contactList = "<DIV align='left'><h5>";
                while (contactIter.hasNext()) {
                    contactList = contactList + (String)contactIter.next() + " ";
                }
                contactList = contactList + "</h5></DIV>";
                this.chatPanel.getChatConversationPanel().appendMessageToEnd(contactList, "text/html");
            } else if (contacts.size() == 1) {
                String limiter = position == 0 ? ": " : "";
                message.replace(position, index, (String)contacts.get(0) + limiter);
            }
            try {
                ((JEditorPane)e.getSource()).getDocument().remove(0, ((JEditorPane)e.getSource()).getDocument().getLength());
                ((JEditorPane)e.getSource()).getDocument().insertString(0, message.toString(), null);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        } else if (e.getKeyCode() == 38) {
            if (this.chatPanel.getLastSentMessageUID() != null && this.chatPanel.isWriteAreaEmpty()) {
                this.chatPanel.startLastMessageCorrection();
                e.consume();
            }
        } else if (e.getKeyCode() == 40 && this.chatPanel.isMessageCorrectionActive()) {
            Document doc = this.editorPane.getDocument();
            if (this.editorPane.getCaretPosition() == doc.getLength()) {
                this.chatPanel.stopMessageCorrection();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.typingTimer.equals(source)) {
            if (this.typingState == 1) {
                this.chatPanel.getChatSession().getCurrentChatTransport().sendTypingNotification(1);
            }
        } else if (this.stoppedTypingTimer.equals(source)) {
            this.typingTimer.stop();
            if (this.typingState == 1) {
                try {
                    this.typingState = 3;
                    int result = this.chatPanel.getChatSession().getCurrentChatTransport().sendTypingNotification(this.typingState);
                    if (result == 1) {
                        this.stoppedTypingTimer.setDelay(3000);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to send typing notifications.", (Throwable)ex);
                }
            } else if (this.typingState == 3) {
                this.stopTypingTimer();
            }
        }
    }

    public void stopTypingTimer() {
        this.typingState = 4;
        int result = this.chatPanel.getChatSession().getCurrentChatTransport().sendTypingNotification(this.typingState);
        if (result == 1) {
            this.stoppedTypingTimer.stop();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 4) != 0 || e.isControlDown() && !e.isMetaDown()) {
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, e.getComponent());
            ArrayList<JMenuItem> contributedMenuEntries = new ArrayList<JMenuItem>();
            for (ChatMenuListener listener : this.menuListeners) {
                contributedMenuEntries.addAll(listener.getMenuElements((Chat)this.chatPanel, e));
            }
            for (JMenuItem item : contributedMenuEntries) {
                this.rightButtonMenu.add(item);
            }
            JPopupMenu rightMenu = this.rightButtonMenu.makeMenu(contributedMenuEntries);
            rightMenu.setInvoker(this.editorPane);
            rightMenu.setLocation(p.x, p.y);
            rightMenu.setVisible(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public WritePanelRightButtonMenu getRightButtonMenu() {
        return this.rightButtonMenu;
    }

    public String getTextAsHtml() {
        String msgText = this.editorPane.getText();
        String formattedString = msgText.replaceAll("<html>|<head>|<body>|</html>|</head>|</body>", "");
        formattedString = this.extractFormattedText(formattedString);
        if ((formattedString = formattedString.trim()).endsWith("<BR/>")) {
            formattedString = formattedString.substring(0, formattedString.lastIndexOf("<BR/>"));
        }
        return formattedString;
    }

    public String getText() {
        try {
            Document doc = this.editorPane.getDocument();
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            logger.error((Object)"Could not obtain write area text.", (Throwable)e);
            return null;
        }
    }

    public void clearWriteArea() {
        try {
            this.editorPane.getDocument().remove(0, this.editorPane.getDocument().getLength());
            if (this.smsMode) {
                this.setSmsLabelVisible(true);
                this.smsCharCountLabel.setText(String.valueOf(this.smsCharCount));
                this.smsNumberLabel.setText(String.valueOf(this.smsNumberCount));
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)"Failed to obtain write panel document content.", (Throwable)e);
        }
    }

    public void appendText(String text) {
        HTMLDocument doc = (HTMLDocument)this.editorPane.getDocument();
        Element currentElement = doc.getCharacterElement(this.editorPane.getCaretPosition());
        try {
            doc.insertAfterEnd(currentElement, text);
        }
        catch (BadLocationException e) {
            logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
        this.editorPane.setCaretPosition(doc.getLength());
    }

    private String extractFormattedText(String msgText) {
        String resultString = msgText.replaceAll("<p\\b[^>]*>", "");
        return resultString.replaceAll("<\\/p>", "<BR/>");
    }

    private Component createChatTransportSelectorBox() {
        if (this.transportSelectorBox == null) {
            this.transportSelectorBox = new ChatTransportSelectorBox(this.chatPanel, this.chatPanel.getChatSession(), this.chatPanel.getChatSession().getCurrentChatTransport());
            if (ConfigurationUtils.isHideAccountSelectionWhenPossibleEnabled() && this.transportSelectorBox.getMenu().getItemCount() <= 1 || !this.isIMAllowed()) {
                this.transportSelectorBox.setVisible(false);
            }
        }
        return this.transportSelectorBox;
    }

    public void setTransportSelectorBoxVisible(boolean isVisible) {
        if (isVisible) {
            if (this.transportSelectorBox == null) {
                this.createChatTransportSelectorBox();
                if (!this.transportSelectorBox.getMenu().isEnabled()) {
                    this.chatPanel.getChatConversationPanel().appendMessageToEnd("<h5>" + StringEscapeUtils.escapeHtml4((String)GuiActivator.getResources().getI18NString("service.gui.MSG_NOT_POSSIBLE")) + "</h5>", "text/html");
                } else {
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.anchor = 12;
                    constraints.fill = 0;
                    constraints.gridx = 0;
                    constraints.gridy = 0;
                    constraints.weightx = 0.0;
                    constraints.weighty = 0.0;
                    constraints.gridheight = 1;
                    constraints.gridwidth = 1;
                    this.centerPanel.add((Component)((Object)this.transportSelectorBox), constraints, 0);
                }
            } else {
                if (ConfigurationUtils.isHideAccountSelectionWhenPossibleEnabled() && this.transportSelectorBox.getMenu().getItemCount() <= 1) {
                    this.transportSelectorBox.setVisible(false);
                }
                this.transportSelectorBox.setVisible(true);
                this.centerPanel.repaint();
            }
        } else if (this.transportSelectorBox != null) {
            this.transportSelectorBox.setVisible(false);
            this.centerPanel.repaint();
        }
    }

    public void setSelectedChatTransport(final ChatTransport chatTransport, final boolean isMessageOrFileTransferReceived) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWritePanel.this.setSelectedChatTransport(chatTransport, isMessageOrFileTransferReceived);
                }
            });
            return;
        }
        long timeout = -1L;
        OperationSetBasicInstantMessaging opSetBasicIM = (OperationSetBasicInstantMessaging)chatTransport.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        if (opSetBasicIM != null) {
            timeout = opSetBasicIM.getInactivityTimeout();
        }
        if (isMessageOrFileTransferReceived) {
            this.isOutdatedResource = false;
        }
        if (timeout != -1L && (isMessageOrFileTransferReceived || this.isOutdatedResource)) {
            if (this.isOutdatedResource) {
                timeout = 0L;
            }
            if (this.outdatedResourceTimer != null) {
                this.outdatedResourceTimer.cancel();
                this.outdatedResourceTimer.purge();
            }
            if (chatTransport.getResourceName() != null) {
                OutdatedResourceTimerTask task = new OutdatedResourceTimerTask();
                this.outdatedResourceTimer = new java.util.Timer();
                this.outdatedResourceTimer.schedule((TimerTask)task, timeout);
            }
        }
        if (!(this.transportSelectorBox == null || !isMessageOrFileTransferReceived && this.transportSelectorBox.hasSelectedTransport() && this.chatPanel.getChatSession().getCurrentChatTransport().getStatus().isOnline())) {
            this.transportSelectorBox.setSelected(chatTransport);
        }
    }

    public void addChatTransport(final ChatTransport chatTransport) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWritePanel.this.addChatTransport(chatTransport);
                }
            });
            return;
        }
        if (this.transportSelectorBox != null) {
            this.transportSelectorBox.addChatTransport(chatTransport);
            if (!this.transportSelectorBox.isVisible() && ConfigurationUtils.isHideAccountSelectionWhenPossibleEnabled() && this.transportSelectorBox.getMenu().getItemCount() > 1) {
                this.transportSelectorBox.setVisible(true);
            }
        }
    }

    public void updateChatTransportStatus(final ChatTransport chatTransport) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWritePanel.this.updateChatTransportStatus(chatTransport);
                }
            });
            return;
        }
        if (this.transportSelectorBox != null) {
            this.transportSelectorBox.updateTransportStatus(chatTransport);
        }
    }

    public void openChatTransportSelectorBox() {
        this.transportSelectorBox.getMenu().doClick();
    }

    public void removeChatTransport(final ChatTransport chatTransport) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWritePanel.this.removeChatTransport(chatTransport);
                }
            });
            return;
        }
        if (this.transportSelectorBox != null) {
            this.transportSelectorBox.removeChatTransport(chatTransport);
        }
        if (this.transportSelectorBox != null && this.transportSelectorBox.getMenu().getItemCount() == 1 && ConfigurationUtils.isHideAccountSelectionWhenPossibleEnabled()) {
            this.transportSelectorBox.setVisible(false);
        }
    }

    public void setSmsLabelVisible(boolean isVisible) {
        if (this.disableMergedSmsMode && this.isIMAllowed()) {
            return;
        }
        this.smsCharCount = 160;
        this.smsNumberCount = 1;
        this.smsButton.setVisible(isVisible);
        this.centerPanel.repaint();
    }

    public void saveDefaultFontConfiguration(String fontFamily, int fontSize, boolean isBold, boolean isItalic, boolean isUnderline, Color color) {
        ConfigurationUtils.setChatDefaultFontFamily((String)fontFamily);
        ConfigurationUtils.setChatDefaultFontSize((int)fontSize);
        ConfigurationUtils.setChatFontIsBold((boolean)isBold);
        ConfigurationUtils.setChatFontIsItalic((boolean)isItalic);
        ConfigurationUtils.setChatFontIsUnderline((boolean)isUnderline);
        ConfigurationUtils.setChatDefaultFontColor((Color)color);
    }

    public void setFontFamilyAndSize(String family, int size) {
        ActionEvent evt = new ActionEvent(this.editorPane, 1001, family);
        StyledEditorKit.StyledTextAction action = new StyledEditorKit.FontFamilyAction(family, family);
        action.actionPerformed(evt);
        evt = new ActionEvent(this.editorPane, 1001, Integer.toString(size));
        action = new StyledEditorKit.FontSizeAction(Integer.toString(size), size);
        action.actionPerformed(evt);
    }

    public void setBoldStyleEnable(boolean b) {
        StyledEditorKit editorKit = (StyledEditorKit)this.editorPane.getEditorKit();
        MutableAttributeSet attr = editorKit.getInputAttributes();
        if (b && !StyleConstants.isBold(attr)) {
            this.setStyleConstant(new StyledEditorKit.BoldAction(), StyleConstants.Bold);
        }
    }

    public void setItalicStyleEnable(boolean b) {
        StyledEditorKit editorKit = (StyledEditorKit)this.editorPane.getEditorKit();
        MutableAttributeSet attr = editorKit.getInputAttributes();
        if (b && !StyleConstants.isItalic(attr)) {
            this.setStyleConstant(new StyledEditorKit.ItalicAction(), StyleConstants.Italic);
        }
    }

    public void setUnderlineStyleEnable(boolean b) {
        StyledEditorKit editorKit = (StyledEditorKit)this.editorPane.getEditorKit();
        MutableAttributeSet attr = editorKit.getInputAttributes();
        if (b && !StyleConstants.isUnderline(attr)) {
            this.setStyleConstant(new StyledEditorKit.UnderlineAction(), StyleConstants.Underline);
        }
    }

    public void setFontColor(Color color) {
        ActionEvent evt = new ActionEvent(this.editorPane, 1001, "");
        StyledEditorKit.ForegroundAction action = new StyledEditorKit.ForegroundAction(Integer.toString(color.getRGB()), color);
        action.actionPerformed(evt);
    }

    private void setStyleConstant(Action action, Object styleConstant) {
        ActionEvent event = new ActionEvent(this.editorPane, 1001, styleConstant.toString());
        action.actionPerformed(event);
    }

    public void addChatEditorMenuListener(ChatMenuListener l) {
        this.menuListeners.add(l);
    }

    public void removeChatEditorMenuListener(ChatMenuListener l) {
        this.menuListeners.remove(l);
    }

    public void loadSkin() {
        this.getRightButtonMenu().loadSkin();
    }

    @Override
    public void changedUpdate(DocumentEvent documentevent) {
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        if (this.smsButton.isVisible()) {
            this.updateSmsCounters(event.getDocument().getLength());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        if (this.smsButton.isVisible()) {
            this.updateSmsCounters(event.getDocument().getLength());
        }
    }

    private void updateSmsCounters(int documentLength) {
        this.smsCharCount = 160 - documentLength % 160;
        this.smsNumberCount = 1 + documentLength / 160;
        this.smsCharCountLabel.setText(String.valueOf(this.smsCharCount));
        this.smsNumberLabel.setText(String.valueOf(this.smsNumberCount));
    }

    public void setEditorPaneBackground(Color color) {
        this.centerPanel.setBackground(color);
        this.editorPane.setBackground(color);
    }

    void initPluginComponents() {
        Collection serRefs;
        String osgiFilter = "(CONTAINER_ID=" + net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WRITE_PANEL.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            serRefs = null;
            logger.error((Object)"Could not obtain plugin reference.", (Throwable)ex);
        }
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                Object c;
                ChatTransport currentTransport;
                Object currentDescriptor;
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                PluginComponent component = factory.getPluginComponentInstance((Object)this);
                this.pluginComponents.add(component);
                ChatSession chatSession = this.chatPanel.getChatSession();
                if (chatSession != null && (currentDescriptor = (currentTransport = chatSession.getCurrentChatTransport()).getDescriptor()) instanceof Contact) {
                    Contact contact = (Contact)currentDescriptor;
                    component.setCurrentContact(contact, currentTransport.getResourceName());
                }
                if ((c = component.getComponent()) == null) continue;
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.anchor = 12;
                constraints.fill = 0;
                constraints.gridy = 0;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                constraints.insets = new Insets(0, 3, 0, 0);
                this.centerPanel.add((Component)c, constraints);
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
        this.centerPanel.repaint();
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        ChatTransport currentTransport;
        Object currentDescriptor;
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (!factory.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WRITE_PANEL)) {
            return;
        }
        PluginComponent component = factory.getPluginComponentInstance((Object)this);
        this.pluginComponents.add(component);
        ChatSession chatSession = this.chatPanel.getChatSession();
        if (chatSession != null && (currentDescriptor = (currentTransport = chatSession.getCurrentChatTransport()).getDescriptor()) instanceof Contact) {
            Contact contact = (Contact)currentDescriptor;
            component.setCurrentContact(contact, currentTransport.getResourceName());
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 3, 0, 0);
        this.centerPanel.add((Component)component.getComponent(), constraints);
        this.centerPanel.repaint();
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (!factory.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WRITE_PANEL)) {
            return;
        }
        Component c = (Component)factory.getPluginComponentInstance((Object)this).getComponent();
        this.pluginComponents.remove(c);
        this.centerPanel.remove(c);
        this.centerPanel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void currentChatTransportChanged(ChatSession chatSession) {
        Contact contact;
        ArrayList<PluginComponent> components;
        List<PluginComponent> list = this.pluginComponents;
        synchronized (list) {
            components = new ArrayList<PluginComponent>(this.pluginComponents);
        }
        Object descriptor = chatSession.getDescriptor();
        if (descriptor instanceof MetaContact) {
            contact = ((MetaContact)descriptor).getDefaultContact();
        } else if (descriptor instanceof Contact) {
            contact = (Contact)descriptor;
        } else {
            if (descriptor == null) {
                for (PluginComponent c : components) {
                    c.setCurrentContact((Contact)null);
                }
                return;
            }
            logger.warn((Object)String.format("Unsupported descriptor type %s (%s),this event will not be propagated.", descriptor, descriptor.getClass().getCanonicalName()));
            return;
        }
        String resourceName = chatSession.getCurrentChatTransport().getResourceName();
        for (PluginComponent c : components) {
            try {
                c.setCurrentContact(contact, resourceName);
            }
            catch (RuntimeException e) {
                logger.error((Object)("BUG: setCurrentContact of PluginComponent instance: " + c.getClass().getCanonicalName() + " throws a RuntimeException."), (Throwable)e);
            }
        }
    }

    @Override
    public void currentChatTransportUpdated(int eventID) {
    }

    private class OutdatedResourceTimerTask
    extends TimerTask {
        private OutdatedResourceTimerTask() {
        }

        @Override
        public void run() {
            ChatWritePanel.this.outdatedResourceTimer = null;
            if (ChatWritePanel.this.chatPanel.getChatSession() != null) {
                Iterator<ChatTransport> transports = ChatWritePanel.this.chatPanel.getChatSession().getChatTransports();
                ChatTransport transport = null;
                while (transports.hasNext()) {
                    transport = transports.next();
                    if (transport.getResourceName() != null || !transport.getStatus().isOnline()) continue;
                    ChatWritePanel.this.isOutdatedResource = false;
                    ChatWritePanel.this.setSelectedChatTransport(transport, true);
                    return;
                }
            }
            ChatWritePanel.this.isOutdatedResource = true;
        }
    }

    private class NewLineAction
    extends AbstractAction {
        private NewLineAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int caretPosition = ChatWritePanel.this.editorPane.getCaretPosition();
            HTMLDocument doc = (HTMLDocument)ChatWritePanel.this.editorPane.getDocument();
            try {
                doc.insertString(caretPosition, "\n", null);
            }
            catch (BadLocationException e1) {
                logger.error((Object)"Could not insert <br> to the document.", (Throwable)e1);
            }
            ChatWritePanel.this.editorPane.setCaretPosition(caretPosition + 1);
        }
    }

    private class SendMessageAction
    extends AbstractAction {
        private SendMessageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatWritePanel.this.chatPanel.sendButtonDoClick();
        }
    }
}

