/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.util.skin.Skinnable;

public class TransferActiveCallsMenu
extends SIPCommPopupMenu
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private final JComponent invoker;
    private final CallPeer initialPeer;

    public TransferActiveCallsMenu(JComponent invoker, CallPeer peer, Collection<CallPeer> callPeers) {
        this.invoker = invoker;
        this.initialPeer = peer;
        this.init();
        for (CallPeer callPeer : callPeers) {
            this.addCallPeerItem(callPeer);
        }
        this.addSeparator();
        JMenuItem transferToMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.TRANSFER_TO"));
        transferToMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CallManager.openCallTransferDialog(TransferActiveCallsMenu.this.initialPeer);
            }
        });
        this.add(transferToMenuItem);
    }

    private void init() {
        this.setInvoker(this.invoker);
        this.add(this.createInfoLabel());
        this.addSeparator();
        this.setFocusable(true);
    }

    private void addCallPeerItem(final CallPeer callPeer) {
        CallPeerMenuItem peerItem = new CallPeerMenuItem(callPeer);
        peerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallManager.transferCall(TransferActiveCallsMenu.this.initialPeer, callPeer);
            }
        });
        this.add(peerItem);
    }

    public void showPopupMenu(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void showPopupMenu() {
        Point location = new Point(this.invoker.getX(), this.invoker.getY() + this.invoker.getHeight());
        SwingUtilities.convertPointToScreen(location, this.invoker.getParent());
        this.setLocation(location);
        this.setVisible(true);
    }

    private Component createInfoLabel() {
        JLabel infoLabel = new JLabel();
        infoLabel.setText("<html><b>" + GuiActivator.getResources().getI18NString("service.gui.TRANSFER_CALL_TO") + "</b></html>");
        return infoLabel;
    }

    public void loadSkin() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof Skinnable)) continue;
            Skinnable skinnableComponent = (Skinnable)component;
            skinnableComponent.loadSkin();
        }
    }

    private static class CallPeerMenuItem
    extends JMenuItem
    implements Skinnable {
        private static final long serialVersionUID = 0L;
        private final CallPeer callPeer;

        public CallPeerMenuItem(CallPeer peer) {
            this.callPeer = peer;
            this.setText(this.callPeer.getDisplayName());
            this.loadSkin();
        }

        public void loadSkin() {
            byte[] peerIcon = this.callPeer.getImage();
            if (peerIcon != null) {
                this.setIcon(new ImageIcon(peerIcon));
            }
        }
    }
}

