/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;

public class FullScreenLayout
implements LayoutManager {
    public static final String CENTER = "CENTER";
    public static final String SOUTH = "SOUTH";
    private Component center;
    private final boolean overlay;
    private Component south;
    private int yGap = 0;

    public FullScreenLayout(boolean overlay, int yGap) {
        this.overlay = overlay;
        this.yGap = yGap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (CENTER.equals(name)) {
            this.center = comp;
        } else if (SOUTH.equals(name)) {
            this.south = comp;
        }
    }

    private List<Component> getLayoutComponents() {
        ArrayList<Component> layoutComponents = new ArrayList<Component>(2);
        if (this.center != null) {
            layoutComponents.add(this.center);
        }
        if (this.south != null) {
            layoutComponents.add(this.south);
        }
        return layoutComponents;
    }

    @Override
    public void layoutContainer(Container parent) {
        int southWidth;
        int southHeight;
        if (this.south == null) {
            southHeight = 0;
            southWidth = 0;
        } else {
            Dimension southSize = this.south.getPreferredSize();
            southWidth = southSize.width;
            southHeight = southSize.height;
        }
        Dimension parentSize = parent.getSize();
        if (this.center != null) {
            int yOffset = this.overlay ? 0 : southHeight + this.yGap;
            this.center.setBounds(0, 0, parentSize.width, parentSize.height - yOffset);
        }
        if (this.south != null) {
            this.south.setBounds((parentSize.width - southWidth) / 2, parentSize.height - southHeight, southWidth, southHeight);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        List<Component> components = this.getLayoutComponents();
        Dimension size = new Dimension(0, 0);
        for (Component component : components) {
            Dimension componentSize = component.getMinimumSize();
            size.width = Math.max(size.width, componentSize.width);
            if (this.overlay) {
                size.height = Math.max(size.height, componentSize.height);
                continue;
            }
            size.height += componentSize.height;
        }
        return size;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        List<Component> components = this.getLayoutComponents();
        Dimension size = new Dimension(0, 0);
        for (Component component : components) {
            Dimension componentSize = component.getPreferredSize();
            size.width = Math.max(size.width, componentSize.width);
            if (this.overlay) {
                size.height = Math.max(size.height, componentSize.height);
                continue;
            }
            size.height += componentSize.height;
        }
        return size;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp.equals(this.center)) {
            this.center = null;
        } else if (comp.equals(this.south)) {
            this.south = null;
        }
    }
}

