/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.main.call.DTMFHandler;
import net.java.sip.communicator.impl.gui.main.call.DialPanel;
import net.java.sip.communicator.impl.gui.utils.Constants;

public class DialpadDialog
extends JDialog
implements WindowFocusListener {
    private DialpadDialog(DialPanel dialPanel) {
        dialPanel.setOpaque(false);
        BackgroundPanel bgPanel = new BackgroundPanel();
        bgPanel.setLayout(new BorderLayout());
        bgPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bgPanel.add((Component)dialPanel, "Center");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)bgPanel, "Center");
        this.setUndecorated(true);
        this.pack();
    }

    public DialpadDialog(final DTMFHandler dtmfHandler) {
        this(new DialPanel(dtmfHandler));
        this.setModal(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                dtmfHandler.removeParent(DialpadDialog.this);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                dtmfHandler.addParent(DialpadDialog.this);
            }
        });
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.removeWindowFocusListener(this);
        this.setVisible(false);
    }

    private static class BackgroundPanel
    extends JPanel {
        private BackgroundPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            GradientPaint p = new GradientPaint(width / 2, 0.0f, Constants.GRADIENT_DARK_COLOR, width / 2, height, Constants.GRADIENT_LIGHT_COLOR);
            g2.setPaint(p);
            g2.fillRoundRect(0, 0, width, height, 10, 10);
            g2.setColor(Constants.GRADIENT_DARK_COLOR);
            g2.drawRoundRect(0, 0, width - 1, height - 1, 10, 10);
        }
    }
}

