/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.account.AccountRegWizardContainerImpl;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommScrollPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class AccountRegSummaryPage
extends SIPCommScrollPane
implements WizardPage {
    private final Logger logger = Logger.getLogger(AccountRegSummaryPage.class);
    private final JPanel keysPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private final JPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private final AccountRegWizardContainerImpl wizardContainer;
    private ProtocolProviderService protocolProviderService;

    public AccountRegSummaryPage(AccountRegWizardContainerImpl wizardContainer) {
        this.wizardContainer = wizardContainer;
        JLabel pageTitleLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SUMMARY"), 0);
        Font font = this.getFont();
        pageTitleLabel.setFont(font.deriveFont(1, font.getSize() + 6));
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        mainPanel.add((Component)pageTitleLabel, "North");
        mainPanel.add((Component)this.keysPanel, "West");
        mainPanel.add((Component)this.valuesPanel, "Center");
        TransparentPanel wrapPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        wrapPanel.add((Component)mainPanel, "North");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setOpaque(false);
        this.setViewportView((Component)wrapPanel);
    }

    private void init(Iterator<Map.Entry<String, String>> summaryData) {
        while (summaryData.hasNext()) {
            Map.Entry<String, String> entry = summaryData.next();
            JLabel keyLabel = new JLabel(entry.getKey().toString() + ":");
            if (entry.getValue() == null) continue;
            JLabel valueLabel = new JLabel(entry.getValue().toString());
            this.keysPanel.add(keyLabel);
            this.valuesPanel.add(valueLabel);
        }
    }

    public Object getIdentifier() {
        return "SUMMARY";
    }

    public Object getNextPageIdentifier() {
        return "FINISH";
    }

    public Object getBackPageIdentifier() {
        return this.wizardContainer.getCurrentWizard().getLastPageIdentifier();
    }

    public Object getWizardForm() {
        return this;
    }

    public void pageShowing() {
        AccountRegistrationWizard wizard = this.wizardContainer.getCurrentWizard();
        this.keysPanel.removeAll();
        this.valuesPanel.removeAll();
        this.init(wizard.getSummary());
        if (this.protocolProviderService != null && this.protocolProviderService.getAccountID().isReadOnly()) {
            this.wizardContainer.setNextFinishButtonEnabled(false);
        }
    }

    public void commitPage() {
        AccountRegistrationWizard wizard = this.wizardContainer.getCurrentWizard();
        if (this.protocolProviderService != null) {
            this.protocolProviderService = null;
        }
        try {
            ProtocolProviderService protocolProvider = wizard.signin();
            if (protocolProvider != null) {
                this.wizardContainer.saveAccountWizard(protocolProvider, wizard);
            }
            this.wizardContainer.unregisterWizardPages();
            this.wizardContainer.removeWizzardIcon();
        }
        catch (OperationFailedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"The sign in operation has failed.");
            }
            if (e.getErrorCode() == 11) {
                new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.USERNAME_NULL"));
            }
            if (e.getErrorCode() == 10) {
                new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.USER_EXISTS_ERROR"));
            }
            if (e.getErrorCode() == 17) {
                new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.SPECIFY_SERVER"));
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void pageBack() {
    }

    public void pageHiding() {
    }

    public void pageShown() {
    }

    public void setModification(ProtocolProviderService protocolProvider) {
        this.protocolProviderService = protocolProvider;
    }

    public void dispose() {
        super.dispose();
        if (this.protocolProviderService != null) {
            this.protocolProviderService = null;
        }
    }
}

