/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTextFieldUI;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommSmartComboBox<E>
extends JComboBox {
    private static final long serialVersionUID = 0L;

    public SIPCommSmartComboBox() {
        this.setModel(new FilterableComboBoxModel());
        this.setEditor(new CallComboEditor());
        this.setEditable(true);
        this.setFocusable(true);
    }

    public class CallComboEditor
    implements ComboBoxEditor,
    DocumentListener,
    Skinnable {
        private JTextField text = new JTextField(15);
        private volatile boolean filtering = false;
        private volatile boolean setting = false;

        public CallComboEditor() {
            this.text.getDocument().addDocumentListener(this);
            if (this.text.getUI() instanceof SIPCommTextFieldUI) {
                ((SIPCommTextFieldUI)this.text.getUI()).setDeleteButtonEnabled(true);
            }
        }

        public void loadSkin() {
            if (this.text.getUI() instanceof SIPCommTextFieldUI) {
                ((SIPCommTextFieldUI)this.text.getUI()).loadSkin();
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.text;
        }

        @Override
        public void setItem(Object item) {
            if (!this.filtering) {
                this.setting = true;
                try {
                    this.text.setText(item == null ? "" : item.toString());
                }
                finally {
                    this.setting = false;
                }
            }
        }

        @Override
        public Object getItem() {
            return this.text.getText();
        }

        @Override
        public void selectAll() {
            this.text.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.text.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.text.removeActionListener(l);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        protected void handleChange() {
            if (this.setting) {
                return;
            }
            this.filtering = true;
            String prefix = this.text.getText();
            StartsWithFilter filter = prefix.length() > 0 ? new StartsWithFilter(prefix) : null;
            ((FilterableComboBoxModel)SIPCommSmartComboBox.this.getModel()).setFilter(filter);
            SIPCommSmartComboBox.this.setPopupVisible(false);
            if (SIPCommSmartComboBox.this.getModel().getSize() > 0) {
                SIPCommSmartComboBox.this.setPopupVisible(true);
            }
            this.filtering = false;
        }
    }

    private static class StartsWithFilter
    implements Filter {
        private final String prefix;

        public StartsWithFilter(String prefix) {
            this.prefix = prefix.toLowerCase();
        }

        @Override
        public boolean accept(Object o) {
            if (o != null) {
                String objectString = o.toString().toLowerCase();
                return objectString.indexOf(this.prefix) >= 0;
            }
            return false;
        }
    }

    public static interface Filter {
        public boolean accept(Object var1);
    }

    public static class FilterableComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private Filter filter;
        private final List<Object> filteredItems;
        private final List<Object> items = new ArrayList<Object>();
        private Object selectedItem;

        public FilterableComboBoxModel() {
            this.filteredItems = new ArrayList<Object>(this.items.size());
            this.updateFilteredItems();
        }

        public boolean contains(Object obj) {
            return this.items.contains(obj);
        }

        public void addElement(Object obj) {
            this.items.add(obj);
            this.updateFilteredItems();
        }

        @Override
        public void removeElement(Object obj) {
            this.items.remove(obj);
            this.updateFilteredItems();
        }

        @Override
        public void removeElementAt(int index) {
            this.items.remove(index);
            this.updateFilteredItems();
        }

        public void insertElementAt(Object obj, int index) {
            this.items.add(index, obj);
            this.updateFilteredItems();
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
            this.updateFilteredItems();
        }

        protected void updateFilteredItems() {
            this.fireIntervalRemoved(this, 0, this.filteredItems.size());
            this.filteredItems.clear();
            if (this.filter == null) {
                this.filteredItems.addAll(this.items);
            } else {
                for (Object item : this.items) {
                    if (!this.filter.accept(item)) continue;
                    this.filteredItems.add(item);
                }
            }
            this.fireIntervalAdded(this, 0, this.filteredItems.size());
        }

        @Override
        public int getSize() {
            return this.filteredItems.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.filteredItems.get(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object val) {
            if (this.selectedItem == null && val == null) {
                return;
            }
            if (this.selectedItem != null && this.selectedItem.equals(val)) {
                return;
            }
            if (val != null && val.equals(this.selectedItem)) {
                return;
            }
            this.selectedItem = val;
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

