/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.border;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.border.EtchedBorder;

public class ExtendedEtchedBorder
extends EtchedBorder {
    private static final long serialVersionUID = 0L;
    private final int top;
    private final int left;
    private final int bottom;
    private final int right;

    public ExtendedEtchedBorder(int etchType, int top, int left, int bottom, int right) {
        super(etchType, null, null);
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(x, y);
        g2.setColor(this.etchType == 1 ? this.getShadowColor(c) : this.getHighlightColor(c));
        if (this.top > 0) {
            g2.setStroke(new BasicStroke(this.top));
            g2.drawLine(0, 0, w - 2, 0);
        }
        if (this.left > 0) {
            g2.setStroke(new BasicStroke(this.left));
            g2.drawLine(0, 0, 0, h - 2);
        }
        if (this.bottom > 0) {
            g2.setStroke(new BasicStroke(this.bottom));
            g2.drawLine(0, h - 2, w - 2, h - 2);
        }
        if (this.right > 0) {
            g2.setStroke(new BasicStroke(this.right));
            g2.drawLine(w - 2, 0, w - 2, h - 2);
        }
        g2.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
        if (this.top > 0) {
            g2.drawLine(1, 1, w - 3, 1);
        }
        if (this.left > 0) {
            g2.drawLine(1, h - 3, 1, 1);
        }
        if (this.right > 0) {
            g2.drawLine(0, h - 1, w - 1, h - 1);
        }
        if (this.bottom > 0) {
            g2.drawLine(w - 1, h - 1, w - 1, 0);
        }
        g2.translate(-x, -y);
    }
}

