/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.advancedconfig;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.plugin.advancedconfig.AdvancedConfigActivator;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ConfigurationContainer;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AdvancedConfigurationPanel
extends TransparentPanel
implements ConfigurationForm,
ConfigurationContainer,
ServiceListener,
ListSelectionListener {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(AdvancedConfigurationPanel.class);
    private final JList configList = new JList();
    private final JPanel centerPanel = new TransparentPanel((LayoutManager)new BorderLayout());

    public AdvancedConfigurationPanel() {
        super((LayoutManager)new BorderLayout(10, 0));
        this.initList();
        this.centerPanel.setPreferredSize(new Dimension(500, 500));
        this.add(this.centerPanel, "Center");
    }

    private void initList() {
        this.configList.setModel(new DefaultListModel());
        this.configList.setCellRenderer(new ConfigListCellRenderer());
        this.configList.addListSelectionListener(this);
        this.configList.setSelectionMode(0);
        JScrollPane configScrollList = new JScrollPane();
        configScrollList.getVerticalScrollBar().setUnitIncrement(30);
        configScrollList.getViewport().add(this.configList);
        this.add(configScrollList, "West");
        String osgiFilter = "(FORM_TYPE=ADVANCED_TYPE)";
        ServiceReference[] confFormsRefs = null;
        try {
            confFormsRefs = AdvancedConfigActivator.bundleContext.getServiceReferences(ConfigurationForm.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (confFormsRefs != null) {
            for (int i = 0; i < confFormsRefs.length; ++i) {
                ConfigurationForm form = (ConfigurationForm)AdvancedConfigActivator.bundleContext.getService(confFormsRefs[i]);
                if (!form.isAdvanced()) continue;
                this.addConfigForm(form);
            }
        }
    }

    private void showFormContent(ConfigurationForm configForm) {
        this.centerPanel.removeAll();
        JComponent configFormPanel = (JComponent)configForm.getForm();
        configFormPanel.setOpaque(false);
        this.centerPanel.add((Component)configFormPanel, "Center");
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    public void serviceChanged(ServiceEvent event) {
        Object sService = AdvancedConfigActivator.bundleContext.getService(event.getServiceReference());
        if (!(sService instanceof ConfigurationForm)) {
            return;
        }
        ConfigurationForm configForm = (ConfigurationForm)sService;
        if (configForm == this || !configForm.isAdvanced()) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Handling registration of a new Configuration Form.");
                }
                this.addConfigForm(configForm);
                break;
            }
            case 4: {
                this.removeConfigForm(configForm);
            }
        }
    }

    public void addConfigForm(final ConfigurationForm configForm) {
        ConfigurationForm form;
        int i;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdvancedConfigurationPanel.this.addConfigForm(configForm);
                }
            });
            return;
        }
        if (configForm == null) {
            throw new IllegalArgumentException("configForm");
        }
        DefaultListModel listModel = (DefaultListModel)this.configList.getModel();
        int count = listModel.getSize();
        int configFormIndex = configForm.getIndex();
        for (i = 0; i < count && configFormIndex >= (form = (ConfigurationForm)listModel.get(i)).getIndex(); ++i) {
        }
        listModel.add(i, configForm);
    }

    public void setVisible(boolean isVisible) {
        if (isVisible && this.configList.getSelectedIndex() < 0) {
            this.configList.setSelectedIndex(0);
        }
        super.setVisible(isVisible);
    }

    public void removeConfigForm(final ConfigurationForm configForm) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdvancedConfigurationPanel.this.removeConfigForm(configForm);
                }
            });
            return;
        }
        DefaultListModel listModel = (DefaultListModel)this.configList.getModel();
        int count = listModel.getSize();
        for (int i = count - 1; i >= 0; --i) {
            ConfigurationForm form = (ConfigurationForm)listModel.get(i);
            if (!form.equals(configForm)) continue;
            listModel.remove(i);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ConfigurationForm configForm;
        if (!e.getValueIsAdjusting() && (configForm = (ConfigurationForm)this.configList.getSelectedValue()) != null) {
            this.showFormContent(configForm);
        }
    }

    public void setSelected(ConfigurationForm configForm) {
        this.configList.setSelectedValue(configForm, true);
    }

    public String getTitle() {
        return AdvancedConfigActivator.getResources().getI18NString("service.gui.ADVANCED");
    }

    public byte[] getIcon() {
        return AdvancedConfigActivator.getResources().getImageInBytes("plugin.advancedconfig.PLUGIN_ICON");
    }

    public Object getForm() {
        return this;
    }

    public int getIndex() {
        return 300;
    }

    public boolean isAdvanced() {
        return false;
    }

    public void validateCurrentForm() {
    }

    private class ConfigListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 0L;
        private boolean isSelected = false;
        private final Color selectedColor = new Color(AdvancedConfigActivator.getResources().getColor("service.gui.LIST_SELECTION_COLOR"));

        public ConfigListCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setOpaque(false);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ConfigurationForm configForm = (ConfigurationForm)value;
            this.isSelected = isSelected;
            this.setText(configForm.getTitle());
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics g2 = g.create();
            try {
                this.internalPaintComponent(g2);
            }
            finally {
                g2.dispose();
            }
            super.paintComponent(g);
        }

        private void internalPaintComponent(Graphics g) {
            AntialiasingManager.activateAntialiasing((Graphics)g);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isSelected) {
                g2.setColor(this.selectedColor);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

