/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

public class DataObject {
    private Object[] data;

    public Object getData(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        int index = this.dataIndexOf(key);
        return index == -1 ? null : this.data[index + 1];
    }

    private int dataIndexOf(Object key) {
        if (this.data != null) {
            for (int index = 0; index < this.data.length; index += 2) {
                if (!key.equals(this.data[index])) continue;
                return index;
            }
        }
        return -1;
    }

    public void setData(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        int index = this.dataIndexOf(key);
        if (index == -1) {
            if (this.data == null) {
                if (value != null) {
                    this.data = new Object[]{key, value};
                }
            } else if (value == null) {
                int length = this.data.length - 2;
                if (length > 0) {
                    Object[] newData = new Object[length];
                    System.arraycopy(this.data, 0, newData, 0, index);
                    System.arraycopy(this.data, index + 2, newData, index, length - index);
                    this.data = newData;
                } else {
                    this.data = null;
                }
            } else {
                int length = this.data.length;
                Object[] newData = new Object[length + 2];
                System.arraycopy(this.data, 0, newData, 0, length);
                this.data = newData;
                this.data[length++] = key;
                this.data[length++] = value;
            }
        } else {
            this.data[index + 1] = value;
        }
    }
}

