/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.control.JitterBufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.BasicSourceStream;
import net.sf.fmj.media.protocol.BufferListener;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.AudioJitterBufferBehaviour;
import net.sf.fmj.media.rtp.BasicJitterBufferBehaviour;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.JitterBuffer;
import net.sf.fmj.media.rtp.JitterBufferBehaviour;
import net.sf.fmj.media.rtp.JitterBufferStats;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.VideoJitterBufferBehaviour;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTPSourceStream
extends BasicSourceStream
implements PushBufferStream {
    private static final long WAIT_TIMEOUT = 100L;
    private BufferControlImpl bc;
    private JitterBufferBehaviour behaviour;
    private boolean bufferWhenStopped = true;
    private boolean closed = false;
    private boolean closing = false;
    final DataSource datasource;
    private Format format;
    private long lastSeqRecv = 0x7FFFFFFFFFFFFFFEL;
    private long lastSeqSent = 0x7FFFFFFFFFFFFFFEL;
    final JitterBuffer q;
    private final Condition qCondition;
    private final Lock qLock;
    private boolean started = false;
    private final Object startSyncRoot = new Object();
    final JitterBufferStats stats;
    private Thread thread;
    private long transferDataReason;
    private BufferTransferHandler transferHandler;

    public RTPSourceStream(DataSource datasource) {
        datasource.setSourceStream(this);
        this.datasource = datasource;
        this.q = new JitterBuffer(4);
        this.qCondition = this.q.condition;
        this.qLock = this.q.lock;
        this.stats = new JitterBufferStats(this);
        this.setBehaviour(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Buffer buffer, boolean flag, RTPRawReceiver rtprawreceiver) {
        if (!this.started && !this.bufferWhenStopped) {
            return;
        }
        long bufferSN = buffer.getSequenceNumber();
        this.qLock.lock();
        try {
            if (this.lastSeqRecv - bufferSN > 256L) {
                Log.info("Resetting queue, last seq added: " + this.lastSeqRecv + ", current seq: " + bufferSN);
                this.reset();
                this.lastSeqRecv = bufferSN;
            }
            this.stats.updateMaxSizeReached();
            this.stats.updateSizePerPacket(buffer);
            if (!this.behaviour.preAdd(buffer, rtprawreceiver)) {
                return;
            }
            this.stats.incrementNbAdd();
            this.lastSeqRecv = bufferSN;
            boolean almostFull = false;
            if (this.q.noMoreFree()) {
                this.stats.incrementDiscardedFull();
                long l = this.q.getFirstSeq();
                if (l != 0x7FFFFFFFFFFFFFFEL && bufferSN < l) {
                    return;
                }
                this.behaviour.dropPkt();
            }
            if (this.q.getFreeCount() <= 1) {
                almostFull = true;
            }
            Buffer qBuffer = this.q.getFree();
            boolean added = false;
            try {
                byte[] bufferData = (byte[])buffer.getData();
                byte[] qBufferData = (byte[])qBuffer.getData();
                if (qBufferData == null || qBufferData.length < bufferData.length) {
                    qBufferData = new byte[bufferData.length];
                }
                System.arraycopy(bufferData, buffer.getOffset(), qBufferData, buffer.getOffset(), buffer.getLength());
                qBuffer.copy(buffer);
                qBuffer.setData(qBufferData);
                if (almostFull) {
                    qBuffer.setFlags(qBuffer.getFlags() | 0x2000 | 0x20);
                } else {
                    qBuffer.setFlags(qBuffer.getFlags() | 0x20);
                }
                this.q.addPkt(qBuffer);
                added = true;
            }
            finally {
                if (!added) {
                    this.q.returnFree(qBuffer);
                }
            }
            ++this.transferDataReason;
            if (!this.behaviour.willReadBlock()) {
                this.qCondition.signalAll();
            }
        }
        finally {
            this.qLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block18: {
            Object object = this.startSyncRoot;
            synchronized (object) {
                if (this.closing) {
                    return;
                }
                this.closing = true;
                this.thread = null;
                this.startSyncRoot.notifyAll();
            }
            try {
                if (this.closed) break block18;
                this.closed = true;
                this.stats.printStats();
                this.stop();
                if (this.qLock.tryLock()) {
                    try {
                        this.qCondition.signalAll();
                    }
                    finally {
                        this.qLock.unlock();
                    }
                }
                if (this.bc != null) {
                    this.bc.removeSourceStream(this);
                }
            }
            finally {
                object = this.startSyncRoot;
                synchronized (object) {
                    this.closing = false;
                    this.startSyncRoot.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.waitWhileClosing();
            this.closed = false;
        }
    }

    JitterBufferBehaviour getBehaviour() {
        return this.behaviour;
    }

    BufferControlImpl getBufferControl() {
        return this.bc;
    }

    @Override
    public Object getControl(String controlType) {
        return JitterBufferControl.class.getName().equals(controlType) ? this.stats : super.getControl(controlType);
    }

    @Override
    public Object[] getControls() {
        Object[] superControls = super.getControls();
        Object[] thisControls = new Object[superControls.length + 1];
        System.arraycopy(superControls, 0, thisControls, 0, superControls.length);
        thisControls[superControls.length] = this.stats;
        return thisControls;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    long getLastReadSequenceNumber() {
        return this.lastSeqSent;
    }

    public void prebuffer() {
    }

    @Override
    public void read(Buffer buffer) {
        this.qLock.lock();
        try {
            try {
                this.behaviour.read(buffer);
                if (!buffer.isDiscard()) {
                    this.lastSeqSent = buffer.getSequenceNumber();
                }
            }
            finally {
                if (!buffer.isDiscard()) {
                    ++this.transferDataReason;
                    this.qCondition.signalAll();
                }
            }
        }
        finally {
            this.qLock.unlock();
        }
    }

    public void reset() {
        this.qLock.lock();
        try {
            this.stats.incrementNbReset();
            this.resetQ();
            this.behaviour.reset();
            this.lastSeqSent = 0x7FFFFFFFFFFFFFFEL;
        }
        finally {
            this.qLock.unlock();
        }
    }

    public void resetQ() {
        Log.comment("Resetting the RTP packet queue");
        this.qLock.lock();
        try {
            while (this.q.fillNotEmpty()) {
                this.behaviour.dropPkt();
                this.stats.incrementDiscardedReset();
            }
            this.qCondition.signalAll();
        }
        finally {
            this.qLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInThread(TransferDataRunnable runnable) {
        BufferTransferHandler transferHandler;
        block19: {
            Object object = this.startSyncRoot;
            synchronized (object) {
                if (!Thread.currentThread().equals(this.thread) || this.closing || this.closed) {
                    return false;
                }
                if (!this.started) {
                    try {
                        this.startSyncRoot.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return true;
                }
            }
            transferHandler = null;
            this.qLock.lock();
            try {
                boolean wait;
                if (this.behaviour.willReadBlock()) {
                    wait = true;
                } else if (runnable.transferDataReason == this.transferDataReason) {
                    wait = true;
                } else {
                    transferHandler = this.transferHandler;
                    if (transferHandler == null) {
                        wait = true;
                    } else {
                        wait = false;
                        runnable.transferDataReason = this.transferDataReason;
                    }
                }
                if (!wait) break block19;
                try {
                    this.qCondition.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.qLock.unlock();
            }
        }
        if (transferHandler != null) {
            transferHandler.transferData(this);
        }
        return true;
    }

    private void setBehaviour(JitterBufferBehaviour behaviour) {
        if (behaviour == null) {
            if (this.behaviour instanceof BasicJitterBufferBehaviour) {
                return;
            }
            behaviour = new BasicJitterBufferBehaviour(this);
        }
        this.behaviour = behaviour;
    }

    public void setBufferControl(BufferControl buffercontrol) {
        this.bc = (BufferControlImpl)buffercontrol;
        this.updateBuffer(this.bc.getBufferLength());
        this.updateThreshold(this.bc.getMinimumThreshold());
    }

    public void setBufferListener(BufferListener bufferlistener) {
    }

    public void setBufferWhenStopped(boolean flag) {
        this.bufferWhenStopped = flag;
    }

    void setContentDescriptor(String s) {
        this.contentDescriptor = new ContentDescriptor(s);
    }

    protected void setFormat(Format format) {
        if (this.format != format) {
            this.format = format;
            BasicJitterBufferBehaviour behaviour = this.format instanceof AudioFormat ? new AudioJitterBufferBehaviour(this) : (this.format instanceof VideoFormat ? new VideoJitterBufferBehaviour(this) : null);
            this.setBehaviour(behaviour);
        }
    }

    @Override
    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandler = transferHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Log.info("Starting RTPSourceStream.");
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.started = true;
            this.startThread();
            this.startSyncRoot.notifyAll();
        }
        if (this.qLock.tryLock()) {
            try {
                this.qCondition.signalAll();
            }
            finally {
                this.qLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.waitWhileClosing();
            if (this.thread == null && !this.closed) {
                RTPMediaThread thread = new RTPMediaThread(new TransferDataRunnable(this), RTPSourceStream.class.getName());
                thread.setDaemon(true);
                thread.useControlPriority();
                boolean started = false;
                this.thread = thread;
                try {
                    thread.start();
                    started = true;
                }
                finally {
                    if (!started && thread.equals(this.thread)) {
                        this.thread = null;
                    }
                }
            }
            this.startSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Log.info("Stopping RTPSourceStream.");
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.started = false;
            this.startSyncRoot.notifyAll();
            if (!this.bufferWhenStopped) {
                this.reset();
            }
        }
        if (this.qLock.tryLock()) {
            try {
                this.qCondition.signalAll();
            }
            finally {
                this.qLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadExited(TransferDataRunnable runnable) {
        Object object = this.startSyncRoot;
        synchronized (object) {
            if (Thread.currentThread().equals(this.thread)) {
                this.thread = null;
                this.startSyncRoot.notifyAll();
            }
        }
    }

    public long updateBuffer(long l) {
        return l;
    }

    public long updateThreshold(long l) {
        return l;
    }

    private void waitWhileClosing() {
        boolean interrupted = false;
        while (this.closing) {
            try {
                this.startSyncRoot.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static class TransferDataRunnable
    implements Runnable {
        private static final boolean WEAK_REFERENCE = false;
        private final RTPSourceStream owner;
        private long transferDataReason;
        private final WeakReference<RTPSourceStream> weakReference;

        public TransferDataRunnable(RTPSourceStream owner) {
            this.owner = owner;
            this.weakReference = null;
        }

        private RTPSourceStream getOwner() {
            return this.owner;
        }

        @Override
        public void run() {
            RTPSourceStream owner;
            try {
                while ((owner = this.getOwner()) != null) {
                    if (owner.runInThread(this)) continue;
                    break;
                }
            }
            finally {
                owner = this.getOwner();
                if (owner != null) {
                    owner.threadExited(this);
                }
            }
        }
    }
}

