/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

public class PNGFormat
extends VideoFormat {
    public PNGFormat() {
        super("png");
        this.dataType = Format.byteArray;
    }

    public PNGFormat(Dimension size, int maxDataLength, Class<?> dataType, float frameRate) {
        super("png", size, maxDataLength, dataType, frameRate);
    }

    @Override
    public Object clone() {
        return new PNGFormat(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate);
    }

    @Override
    protected void copy(Format f) {
        super.copy(f);
        PNGFormat oCast = (PNGFormat)f;
    }

    @Override
    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof PNGFormat)) {
            return false;
        }
        PNGFormat oCast = (PNGFormat)format;
        return true;
    }

    @Override
    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof PNGFormat) {
            PNGFormat resultCast = (PNGFormat)result;
            PNGFormat oCast = (PNGFormat)other;
            if (this.getClass().isAssignableFrom(other.getClass()) || other.getClass().isAssignableFrom(this.getClass())) {
                // empty if block
            }
        }
        FormatTraceUtils.traceIntersects(this, other, result);
        return result;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof PNGFormat)) {
            boolean result = true;
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        PNGFormat oCast = (PNGFormat)format;
        boolean result = true;
        FormatTraceUtils.traceMatches(this, format, true);
        return true;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("PNG video format:");
        if (FormatUtils.specified(this.size)) {
            b.append(" size = " + this.size.width + "x" + this.size.height);
        }
        if (FormatUtils.specified(this.frameRate)) {
            b.append(" FrameRate = " + this.frameRate);
        }
        if (FormatUtils.specified(this.maxDataLength)) {
            b.append(" maxDataLength = " + this.maxDataLength);
        }
        if (FormatUtils.specified(this.dataType)) {
            b.append(" dataType = " + this.dataType);
        }
        return b.toString();
    }
}

