/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.resolver.CumulativeScopeArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    private ArtifactResolver resolver;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource metadataSource;

    public DefaultProjectDependenciesResolver() {
    }

    DefaultProjectDependenciesResolver(ArtifactResolver resolver, ArtifactFactory artifactFactory, ArtifactMetadataSource metadataSource) {
        this.resolver = resolver;
        this.artifactFactory = artifactFactory;
        this.metadataSource = metadataSource;
    }

    @Override
    public Set<Artifact> resolve(Collection<? extends MavenProject> projects, Collection<String> scopes, MavenSession session) throws ArtifactResolutionException, ArtifactNotFoundException {
        LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>();
        if (projects == null || projects.isEmpty()) {
            return resolved;
        }
        CumulativeScopeArtifactFilter scopeFilter = new CumulativeScopeArtifactFilter(scopes);
        for (MavenProject mavenProject : projects) {
            Set depArtifacts = mavenProject.getDependencyArtifacts();
            if (depArtifacts == null) {
                try {
                    depArtifacts = mavenProject.createArtifacts(this.artifactFactory, null, (ArtifactFilter)scopeFilter);
                }
                catch (InvalidDependencyVersionException e) {
                    throw new ArtifactResolutionException("Failed to create Artifact instances for project dependencies: " + e.getMessage(), null, (Throwable)e);
                }
            }
            if (depArtifacts == null || depArtifacts.isEmpty()) continue;
            Iterator it = depArtifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                if (!resolved.contains(artifact)) continue;
                it.remove();
            }
            Artifact projectArtifact = mavenProject.getArtifact();
            if (projectArtifact == null) {
                projectArtifact = this.artifactFactory.createProjectArtifact(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
            }
            try {
                ArtifactResolutionResult result = this.resolver.resolveTransitively(depArtifacts, projectArtifact, mavenProject.getManagedVersionMap(), session.getLocalRepository(), mavenProject.getRemoteArtifactRepositories(), this.metadataSource, (ArtifactFilter)scopeFilter);
                if (result.getArtifacts() == null || result.getArtifacts().isEmpty()) continue;
                resolved.addAll(result.getArtifacts());
            }
            catch (MultipleArtifactsNotFoundException me) {
                Set<String> projectIds = this.getProjectIds(projects);
                HashSet missing = new HashSet(me.getMissingArtifacts());
                Iterator it2 = missing.iterator();
                while (it2.hasNext()) {
                    Artifact artifact = (Artifact)it2.next();
                    if (!projectIds.contains(DefaultProjectDependenciesResolver.getProjectReferenceId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()))) continue;
                    it2.remove();
                }
                if (missing.isEmpty()) {
                    resolved.addAll(me.getResolvedArtifacts());
                    continue;
                }
                throw me;
            }
        }
        return resolved;
    }

    @Override
    public Set<Artifact> resolve(MavenProject project, Collection<String> scopes, MavenSession session) throws ArtifactResolutionException, ArtifactNotFoundException {
        Set<MavenProject> projects = Collections.singleton(project);
        return this.resolve(projects, scopes, session);
    }

    private Set<String> getProjectIds(Collection<? extends MavenProject> projects) {
        HashSet<String> ids = new HashSet<String>();
        if (projects != null && !projects.isEmpty()) {
            for (MavenProject mavenProject : projects) {
                ids.add(DefaultProjectDependenciesResolver.getProjectReferenceId(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion()));
            }
        }
        return ids;
    }

    private static String getProjectReferenceId(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }
}

