/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.mp.AbstractRatMojo;
import org.apache.rat.mp.RatCheckException;
import org.apache.rat.report.claim.ClaimStatistic;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE)
public class RatCheckMojo
extends AbstractRatMojo {
    @Parameter(property="rat.outputFile", defaultValue="${project.build.directory}/rat.txt")
    private File reportFile;
    @Parameter(property="rat.outputStyle", defaultValue="plain")
    private String reportStyle;
    @Parameter(property="rat.numUnapprovedLicenses", defaultValue="0")
    private int numUnapprovedLicenses;
    @Parameter(property="rat.addLicenseHeaders", defaultValue="false")
    private String addLicenseHeaders;
    @Parameter(property="rat.copyrightMessage")
    private String copyrightMessage;
    @Parameter(property="rat.ignoreErrors", defaultValue="false")
    private boolean ignoreErrors;
    @Parameter(property="rat.skip", defaultValue="false")
    private boolean skip;

    private ClaimStatistic getRawReport() throws MojoExecutionException, MojoFailureException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.reportFile);
            ClaimStatistic statistic = this.createReport(fw, this.getStyleSheet());
            fw.close();
            fw = null;
            ClaimStatistic claimStatistic = statistic;
            return claimStatistic;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private InputStream getStyleSheet() throws MojoExecutionException {
        if (this.reportStyle == null || this.reportStyle.equals("plain")) {
            return Defaults.getPlainStyleSheet();
        }
        if (this.reportStyle.equals("xml")) {
            return null;
        }
        try {
            return new FileInputStream(this.reportStyle);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to find report stylesheet: " + this.reportStyle, (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"RAT will not execute since it is configured to be skipped via system property 'rat.skip'.");
            return;
        }
        File parent = this.reportFile.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new MojoExecutionException("Could not create report parent directory " + parent);
        }
        ClaimStatistic report = this.getRawReport();
        this.check(report);
    }

    protected void check(ClaimStatistic statistics) throws MojoFailureException {
        this.getLog().info((CharSequence)("Rat check: Summary of files. Unapproved: " + statistics.getNumUnApproved() + " unknown: " + statistics.getNumUnknown() + " generated: " + statistics.getNumGenerated() + " approved: " + statistics.getNumApproved() + " licence."));
        if (this.numUnapprovedLicenses < statistics.getNumUnApproved()) {
            String seeReport = " See RAT report in: " + this.reportFile;
            if (!this.ignoreErrors) {
                throw new RatCheckException("Too many files with unapproved license: " + statistics.getNumUnApproved() + seeReport);
            }
            this.getLog().warn((CharSequence)("Rat check: " + statistics.getNumUnApproved() + " files with unapproved licenses." + seeReport));
        }
    }

    protected ReportConfiguration getConfiguration() throws MojoFailureException, MojoExecutionException {
        ReportConfiguration configuration = super.getConfiguration();
        if ("forced".equals(this.addLicenseHeaders)) {
            configuration.setAddingLicenses(true);
            configuration.setAddingLicensesForced(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if ("true".equals(this.addLicenseHeaders)) {
            configuration.setAddingLicenses(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if (!"false".equals(this.addLicenseHeaders)) {
            throw new MojoFailureException("Invalid value for addLicenseHeaders: Expected forced|true|false, got " + this.addLicenseHeaders);
        }
        return configuration;
    }
}

