/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryManager;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteArrayBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetDirectByteBuffer;

public class SqlJetMemoryManager
implements ISqlJetMemoryManager {
    private SqlJetMemoryBufferType defaultBufferType = SqlJetUtility.getEnumSysProp("SqlJetMemoryManager.defaultBufferType", SqlJetMemoryBufferType.ARRAY);

    public SqlJetMemoryBufferType getDefaultBufferType() {
        return this.defaultBufferType;
    }

    public void setDefaultBufferType(SqlJetMemoryBufferType bufferType) {
        if (bufferType != null) {
            this.defaultBufferType = bufferType;
        }
    }

    public ISqlJetMemoryPointer allocatePtr(int size) {
        return this.allocate(size).getPointer(0);
    }

    public ISqlJetMemoryPointer allocatePtr(int size, SqlJetMemoryBufferType bufferType) {
        return this.allocate(size, bufferType).getPointer(0);
    }

    public ISqlJetMemoryBuffer allocate(int size) {
        return this.allocate(size, this.defaultBufferType);
    }

    public ISqlJetMemoryBuffer allocate(int size, SqlJetMemoryBufferType bufferType) {
        if (size >= 0) {
            ISqlJetMemoryBuffer buffer;
            switch (bufferType) {
                case ARRAY: {
                    buffer = new SqlJetByteArrayBuffer();
                    break;
                }
                case BUFFER: {
                    buffer = new SqlJetByteBuffer();
                    break;
                }
                case DIRECT: {
                    buffer = new SqlJetDirectByteBuffer();
                    break;
                }
                default: {
                    buffer = new SqlJetByteArrayBuffer();
                }
            }
            buffer.allocate(size);
            return buffer;
        }
        return null;
    }

    public void free(ISqlJetMemoryBuffer buffer) {
        if (buffer != null) {
            buffer.free();
        }
    }
}

