/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.tag;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.checkin.ClearCaseCheckInConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseTagCommand
extends AbstractTagCommand
implements ClearCaseCommand {
    protected ScmResult executeTagCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String tag, String message) throws ScmException {
        return this.executeTagCommand(scmProviderRepository, fileSet, tag, new ScmTagParameters(message));
    }

    protected ScmResult executeTagCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        int exitCode;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing tag command...");
        }
        Commandline cl = ClearCaseTagCommand.createCommandLine(fileSet, tag);
        ClearCaseCheckInConsumer consumer = new ClearCaseCheckInConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Creating label: " + tag);
            }
            Commandline newLabelCommandLine = ClearCaseTagCommand.createNewLabelCommandLine(fileSet, tag);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing: " + newLabelCommandLine.getWorkingDirectory().getAbsolutePath() + ">>" + newLabelCommandLine.toString());
            }
            if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)newLabelCommandLine, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr)) == 0) {
                this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
                exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
            }
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new TagScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new TagScmResult(cl.toString(), consumer.getCheckedInFiles());
    }

    public static Commandline createCommandLine(ScmFileSet scmFileSet, String tag) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArg().setValue("mklabel");
        List files = scmFileSet.getFileList();
        if (files.isEmpty()) {
            command.createArg().setValue("-recurse");
        }
        command.createArg().setValue(tag);
        if (files.size() > 0) {
            for (File file : files) {
                command.createArg().setValue(file.getName());
            }
        } else {
            command.createArg().setValue(".");
        }
        return command;
    }

    private static Commandline createNewLabelCommandLine(ScmFileSet scmFileSet, String tag) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArg().setValue("mklbtype");
        command.createArg().setValue("-nc");
        command.createArg().setValue(tag);
        return command;
    }
}

