/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.Eigen;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.EigenSort;
import org.jmol.util.Escape;

public class Tensor {
    private static final float ADP_FACTOR = (float)(Math.sqrt(0.5) / Math.PI);
    private static final float MAGNETIC_SUSCEPTIBILITY_FACTOR = 0.01f;
    private static final float INTERACTION_FACTOR = 0.04f;
    private static EigenSort tSort;
    public String id;
    public String type;
    public int iType = -1;
    private static final String KNOWN_TYPES = ";iso........;adp........;tls-u......;tls-r......;ms.........;efg........;isc........;charge.....;quadrupole.;raman......";
    public static final int TYPE_OTHER = -1;
    public static final int TYPE_ISO = 0;
    public static final int TYPE_ADP = 1;
    public static final int TYPE_TLS_U = 2;
    public static final int TYPE_TLS_R = 3;
    public static final int TYPE_MS = 4;
    public static final int TYPE_EFG = 5;
    public static final int TYPE_ISC = 6;
    public static final int TYPE_CHARGE = 7;
    public static final int TYPE_QUADRUPOLE = 8;
    public static final int TYPE_RAMAN = 9;
    public double[][] asymMatrix;
    public double[][] symMatrix;
    public V3[] eigenVectors;
    public float[] eigenValues;
    public float[] parBorU;
    public String altType;
    public boolean isIsotropic;
    public boolean forThermalEllipsoid;
    public int eigenSignMask = 7;
    private float typeFactor = 1.0f;
    private boolean sortIso;
    public int modelIndex;
    public int atomIndex1 = -1;
    public int atomIndex2 = -1;
    public boolean isModulated;
    public boolean isUnmodulated;
    private static final String infoList = ";.............;eigenvalues..;eigenvectors.;asymmatrix...;symmatrix....;value........;isotropy.....;anisotropy...;asymmetry....;eulerzyz.....;eulerzxz.....;quaternion...;indices......;string.......;type.........;id...........;span.........;skew.........";

    private static int getType(String type) {
        int pt = type.indexOf("_");
        if (pt >= 0) {
            type = type.substring(0, pt);
        }
        return (pt = KNOWN_TYPES.indexOf(";" + type.toLowerCase() + ".")) < 0 ? -1 : pt / 11;
    }

    private static int getInfoIndex(String infoType) {
        if (infoType.charAt(0) != ';') {
            infoType = ";" + infoType + ".";
        }
        return infoList.indexOf(infoType) / 14;
    }

    public static boolean isFloatInfo(String infoType) {
        switch (Tensor.getInfoIndex(infoType)) {
            default: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
        }
        return true;
    }

    public Object getInfo(String infoType) {
        switch (Tensor.getInfoIndex(infoType)) {
            default: {
                Hashtable<Object, Object> info = new Hashtable<Object, Object>();
                Object[] s = PT.getTokens(PT.replaceWithCharacter(infoList, ";.", ' ').trim());
                Arrays.sort(s);
                for (int i = 0; i < s.length; ++i) {
                    Object o = this.getInfo((String)s[i]);
                    if (o == null) continue;
                    info.put(s[i], o);
                }
                return info;
            }
            case 1: {
                return this.eigenValues;
            }
            case 2: {
                P3[] list = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    list[i] = P3.newP(this.eigenVectors[i]);
                }
                return list;
            }
            case 3: {
                if (this.asymMatrix == null) {
                    return null;
                }
                float[] a = new float[9];
                int pt = 0;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        a[pt++] = (float)this.asymMatrix[i][j];
                    }
                }
                return M3.newA9(a);
            }
            case 4: {
                if (this.symMatrix == null) {
                    return null;
                }
                float[] b = new float[9];
                int p2 = 0;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        b[p2++] = (float)this.symMatrix[i][j];
                    }
                }
                return M3.newA9(b);
            }
            case 5: {
                return Float.valueOf(this.eigenValues[2]);
            }
            case 6: {
                return Float.valueOf(this.isotropy());
            }
            case 7: {
                return Float.valueOf(this.anisotropy());
            }
            case 8: {
                return Float.valueOf(this.asymmetry());
            }
            case 9: {
                return ((Quat)this.getInfo("quaternion")).getEulerZYZ();
            }
            case 10: {
                return ((Quat)this.getInfo("quaternion")).getEulerZXZ();
            }
            case 11: {
                return Quat.getQuaternionFrame(null, this.eigenVectors[0], this.eigenVectors[1]);
            }
            case 12: {
                return new int[]{this.modelIndex, this.atomIndex1, this.atomIndex2};
            }
            case 13: {
                return this.toString();
            }
            case 14: {
                return this.type;
            }
            case 15: {
                return this.id;
            }
            case 16: {
                return Float.valueOf(this.span());
            }
            case 17: 
        }
        return Float.valueOf(this.skew());
    }

    public float isotropy() {
        return (this.eigenValues[0] + this.eigenValues[1] + this.eigenValues[2]) / 3.0f;
    }

    public float span() {
        return Math.abs(this.eigenValues[2] - this.eigenValues[0]);
    }

    public float skew() {
        return this.span() == 0.0f ? 0.0f : 3.0f * (this.eigenValues[1] - this.isotropy()) / this.span();
    }

    public float anisotropy() {
        return this.eigenValues[2] - (this.eigenValues[0] + this.eigenValues[1]) / 2.0f;
    }

    public float reducedAnisotropy() {
        return this.anisotropy() * 2.0f / 3.0f;
    }

    public float asymmetry() {
        return this.span() == 0.0f ? 0.0f : (this.eigenValues[1] - this.eigenValues[0]) / this.reducedAnisotropy();
    }

    public Tensor copyTensor() {
        Tensor t = new Tensor();
        t.setType(this.type);
        t.eigenValues = this.eigenValues;
        t.eigenVectors = this.eigenVectors;
        t.asymMatrix = this.asymMatrix;
        t.symMatrix = this.symMatrix;
        t.eigenSignMask = this.eigenSignMask;
        t.modelIndex = this.modelIndex;
        t.atomIndex1 = this.atomIndex1;
        t.atomIndex2 = this.atomIndex2;
        t.parBorU = this.parBorU;
        t.id = this.id;
        return t;
    }

    public Tensor setFromAsymmetricTensor(double[][] asymmetricTensor, String type, String id) {
        double[][] a = new double[3][3];
        int i = 3;
        while (--i >= 0) {
            int j = 3;
            while (--j >= 0) {
                a[i][j] = asymmetricTensor[i][j];
            }
        }
        if (a[0][1] != a[1][0]) {
            double d = (a[0][1] + a[1][0]) / 2.0;
            a[1][0] = d;
            a[0][1] = d;
        }
        if (a[1][2] != a[2][1]) {
            double d = (a[1][2] + a[2][1]) / 2.0;
            a[2][1] = d;
            a[1][2] = d;
        }
        if (a[0][2] != a[2][0]) {
            double d = (a[0][2] + a[2][0]) / 2.0;
            a[2][0] = d;
            a[0][2] = d;
        }
        M3 m = new M3();
        float[] mm = new float[9];
        int p = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                mm[p++] = (float)a[i2][j];
            }
        }
        m.setA(mm);
        V3[] vectors = new V3[3];
        float[] values = new float[3];
        new Eigen().setM(a).fillFloatArrays(vectors, values);
        this.newTensorType(vectors, values, type, id);
        this.asymMatrix = asymmetricTensor;
        this.symMatrix = a;
        this.id = id;
        return this;
    }

    public Tensor setFromEigenVectors(T3[] eigenVectors, float[] eigenValues, String type, String id, Tensor t) {
        float[] values = new float[3];
        V3[] vectors = new V3[3];
        for (int i = 0; i < 3; ++i) {
            vectors[i] = V3.newV(eigenVectors[i]);
            values[i] = eigenValues[i];
        }
        this.newTensorType(vectors, values, type, id);
        if (t != null) {
            this.isModulated = t.isModulated;
            this.isUnmodulated = t.isUnmodulated;
            this.parBorU = t.parBorU;
        }
        return this;
    }

    public Tensor setFromAxes(V3[] axes) {
        this.eigenValues = new float[3];
        this.eigenVectors = new V3[3];
        for (int i = 0; i < 3; ++i) {
            this.eigenVectors[i] = V3.newV(axes[i]);
            this.eigenValues[i] = axes[i].length();
            if (this.eigenValues[i] == 0.0f) {
                return null;
            }
            this.eigenVectors[i].normalize();
        }
        if (Math.abs(this.eigenVectors[0].dot(this.eigenVectors[1])) > 1.0E-4f || Math.abs(this.eigenVectors[1].dot(this.eigenVectors[2])) > 1.0E-4f || Math.abs(this.eigenVectors[2].dot(this.eigenVectors[0])) > 1.0E-4f) {
            return null;
        }
        this.setType("other");
        this.sortAndNormalize();
        return this;
    }

    public Tensor setFromThermalEquation(double[] coefs, String id) {
        this.eigenValues = new float[3];
        this.eigenVectors = new V3[3];
        this.id = id == null ? "coefs=" + Escape.eAD(coefs) : id;
        double[][] mat = new double[3][3];
        mat[0][0] = coefs[0];
        mat[1][1] = coefs[1];
        mat[2][2] = coefs[2];
        double d = coefs[3] / 2.0;
        mat[1][0] = d;
        mat[0][1] = d;
        double d2 = coefs[4] / 2.0;
        mat[2][0] = d2;
        mat[0][2] = d2;
        double d3 = coefs[5] / 2.0;
        mat[2][1] = d3;
        mat[1][2] = d3;
        new Eigen().setM(mat).fillFloatArrays(this.eigenVectors, this.eigenValues);
        this.setType("adp");
        this.sortAndNormalize();
        return this;
    }

    public Tensor setType(String type) {
        if (this.type == null || type == null) {
            this.type = type;
        }
        if (type != null) {
            this.processType();
        }
        return this;
    }

    public float getFactoredValue(int i) {
        float f = Math.abs(this.eigenValues[i]);
        return (this.forThermalEllipsoid ? (float)Math.sqrt(f) : f) * this.typeFactor;
    }

    public void setAtomIndexes(int index1, int index2) {
        this.atomIndex1 = index1;
        this.atomIndex2 = index2;
    }

    public boolean isSelected(BS bsSelected, int iAtom) {
        return iAtom >= 0 ? this.atomIndex1 == iAtom || this.atomIndex2 == iAtom : bsSelected.get(this.atomIndex1) && (this.atomIndex2 < 0 || bsSelected.get(this.atomIndex2));
    }

    private void newTensorType(V3[] vectors, float[] values, String type, String id) {
        this.eigenValues = values;
        this.eigenVectors = vectors;
        for (int i = 0; i < 3; ++i) {
            this.eigenVectors[i].normalize();
        }
        this.setType(type);
        this.id = id;
        this.sortAndNormalize();
        this.eigenSignMask = (this.eigenValues[0] >= 0.0f ? 1 : 0) + (this.eigenValues[1] >= 0.0f ? 2 : 0) + (this.eigenValues[2] >= 0.0f ? 4 : 0);
    }

    private void processType() {
        this.forThermalEllipsoid = false;
        this.isIsotropic = false;
        this.altType = null;
        this.typeFactor = 1.0f;
        this.sortIso = false;
        this.iType = Tensor.getType(this.type);
        switch (this.iType) {
            case 0: {
                this.forThermalEllipsoid = true;
                this.isIsotropic = true;
                this.altType = "1";
                this.type = "adp";
                break;
            }
            case 1: {
                this.forThermalEllipsoid = true;
                this.typeFactor = ADP_FACTOR;
                this.altType = "1";
                break;
            }
            case 4: {
                this.sortIso = true;
                this.typeFactor = 0.01f;
                break;
            }
            case 5: {
                this.sortIso = true;
                break;
            }
            case 6: {
                this.sortIso = true;
                this.typeFactor = 0.04f;
                break;
            }
            case 3: {
                this.altType = "2";
                break;
            }
            case 2: {
                this.altType = "3";
                break;
            }
        }
    }

    private void sortAndNormalize() {
        int i;
        Object[] o = new Object[]{new Object[]{V3.newV(this.eigenVectors[0]), Float.valueOf(this.eigenValues[0])}, new Object[]{V3.newV(this.eigenVectors[1]), Float.valueOf(this.eigenValues[1])}, new Object[]{V3.newV(this.eigenVectors[2]), Float.valueOf(this.eigenValues[2])}};
        Arrays.sort(o, Tensor.getEigenSort());
        for (i = 0; i < 3; ++i) {
            int pt = i;
            this.eigenVectors[i] = (V3)((Object[])o[pt])[0];
            this.eigenValues[i] = ((Float)((Object[])o[pt])[1]).floatValue();
        }
        if (this.sortIso && this.eigenValues[2] - this.eigenValues[1] < this.eigenValues[1] - this.eigenValues[0]) {
            V3 vTemp = this.eigenVectors[0];
            this.eigenVectors[0] = this.eigenVectors[2];
            this.eigenVectors[2] = vTemp;
            float f = this.eigenValues[0];
            this.eigenValues[0] = this.eigenValues[2];
            this.eigenValues[2] = f;
        }
        for (i = 0; i < 3; ++i) {
            this.eigenVectors[i].normalize();
        }
    }

    public boolean isEquiv(Tensor t) {
        if (t.iType != this.iType) {
            return false;
        }
        float f = Math.abs(this.eigenValues[0] + this.eigenValues[1] + this.eigenValues[2]);
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(t.eigenValues[i] - this.eigenValues[i]) / f > 3.0E-4f)) continue;
            return false;
        }
        return true;
    }

    private static Comparator<? super Object> getEigenSort() {
        return tSort == null ? (tSort = new EigenSort()) : tSort;
    }

    public String toString() {
        return this.type + " " + this.modelIndex + " " + this.atomIndex1 + " " + this.atomIndex2 + "\n" + (this.eigenVectors == null ? "" + this.eigenValues[0] : this.eigenVectors[0] + "\t" + this.eigenValues[0] + "\t\n" + this.eigenVectors[1] + "\t" + this.eigenValues[1] + "\t\n" + this.eigenVectors[2] + "\t" + this.eigenValues[2] + "\t\n");
    }
}

