/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM NotificationEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "ExtendableEventBinding.h"
#include "NotificationEvent.h"
#include "NotificationEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Notification.h"
#include "mozilla/dom/NotificationEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(NotificationEvent)

NS_IMPL_ADDREF_INHERITED(NotificationEvent, ExtendableEvent)
NS_IMPL_RELEASE_INHERITED(NotificationEvent, ExtendableEvent)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(NotificationEvent, ExtendableEvent)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mNotification)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(NotificationEvent, ExtendableEvent)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(NotificationEvent, ExtendableEvent)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mNotification)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(NotificationEvent)
NS_INTERFACE_MAP_END_INHERITING(ExtendableEvent)

NotificationEvent::NotificationEvent(mozilla::dom::EventTarget* aOwner)
  : ExtendableEvent(aOwner)
{
}

NotificationEvent::~NotificationEvent()
{
}

NotificationEvent*
NotificationEvent::AsNotificationEvent()
{
  return this;
}

JSObject*
NotificationEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return NotificationEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<NotificationEvent>
NotificationEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const NotificationEventInit& aEventInitDict)
{
  RefPtr<NotificationEvent> e = new NotificationEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mNotification = aEventInitDict.mNotification;
  e->mAction = aEventInitDict.mAction;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<NotificationEvent>
NotificationEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const NotificationEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

Notification*
NotificationEvent::Notification_() const
{
  return mNotification;
}

void
NotificationEvent::GetAction(nsString& aRetVal) const
{
  aRetVal = mAction;
}


} // namespace mozilla::dom
