/* THIS FILE IS AUTOGENERATED FROM CSSColorValue.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "CSSColorValueBinding.h"
#include "CSSStyleValueBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_layout.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CSSColorValue.h"
#include "mozilla/dom/CSSKeywordValue.h"
#include "mozilla/dom/CSSNumericValue.h"
#include "mozilla/dom/CSSStyleValue.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCSSColorValueOrCSSStyleValue& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsCSSColorValue()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsCSSColorValue(), "mCSSColorValue", aFlags);
  } else if (aUnion.IsCSSStyleValue()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsCSSStyleValue(), "mCSSStyleValue", aFlags);
  }
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsCSSNumericValue()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsCSSNumericValue(), "mCSSNumericValue", aFlags);
  } else if (aUnion.IsCSSKeywordValue()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsCSSKeywordValue(), "mCSSKeywordValue", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningCSSColorValueOrCSSStyleValue& aUnion)
{
  aUnion.Uninit();
}


void
ImplCycleCollectionUnlink(OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue& aUnion)
{
  aUnion.Uninit();
}


bool
CSSColorValueOrCSSStyleValue::TrySetToCSSColorValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::CSSColorValue>& memberSlot = RawSetAsCSSColorValue();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSColorValue, mozilla::dom::CSSColorValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSColorValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
CSSColorValueOrCSSStyleValue::TrySetToCSSColorValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSColorValue(cx, value, tryNext, passedToJSImpl);
}







bool
CSSColorValueOrCSSStyleValue::TrySetToCSSStyleValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::CSSStyleValue>& memberSlot = RawSetAsCSSStyleValue();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSStyleValue, mozilla::dom::CSSStyleValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSStyleValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
CSSColorValueOrCSSStyleValue::TrySetToCSSStyleValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSStyleValue(cx, value, tryNext, passedToJSImpl);
}







bool
CSSColorValueOrCSSStyleValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSColorValue(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToCSSStyleValue(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSColorValue, CSSStyleValue");
    return false;
  }
  return true;
}

bool
CSSColorValueOrCSSStyleValue::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
CSSColorValueOrCSSStyleValue::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eCSSColorValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSColorValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eCSSStyleValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSStyleValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningCSSColorValueOrCSSStyleValue::OwningCSSColorValueOrCSSStyleValue(OwningCSSColorValueOrCSSStyleValue&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eCSSColorValue: {
      mType = eCSSColorValue;
      mValue.mCSSColorValue.SetValue(std::move(aOther.mValue.mCSSColorValue.Value()));
      break;
    }
    case eCSSStyleValue: {
      mType = eCSSStyleValue;
      mValue.mCSSStyleValue.SetValue(std::move(aOther.mValue.mCSSStyleValue.Value()));
      break;
    }
  }
}



bool
OwningCSSColorValueOrCSSStyleValue::TrySetToCSSColorValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::CSSColorValue>& memberSlot = RawSetAsCSSColorValue();
    static_assert(IsRefcounted<mozilla::dom::CSSColorValue>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSColorValue, mozilla::dom::CSSColorValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSColorValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningCSSColorValueOrCSSStyleValue::TrySetToCSSColorValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSColorValue(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSColorValue>&
OwningCSSColorValueOrCSSStyleValue::RawSetAsCSSColorValue()
{
  if (mType == eCSSColorValue) {
    return mValue.mCSSColorValue.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eCSSColorValue;
  return mValue.mCSSColorValue.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSColorValue>&
OwningCSSColorValueOrCSSStyleValue::SetAsCSSColorValue()
{
  if (mType == eCSSColorValue) {
    return mValue.mCSSColorValue.Value();
  }
  Uninit();
  mType = eCSSColorValue;
  return mValue.mCSSColorValue.SetValue();
}


void
OwningCSSColorValueOrCSSStyleValue::DestroyCSSColorValue()
{
  MOZ_RELEASE_ASSERT(IsCSSColorValue(), "Wrong type!");
  mValue.mCSSColorValue.Destroy();
  mType = eUninitialized;
}



bool
OwningCSSColorValueOrCSSStyleValue::TrySetToCSSStyleValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::CSSStyleValue>& memberSlot = RawSetAsCSSStyleValue();
    static_assert(IsRefcounted<mozilla::dom::CSSStyleValue>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSStyleValue, mozilla::dom::CSSStyleValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSStyleValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningCSSColorValueOrCSSStyleValue::TrySetToCSSStyleValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSStyleValue(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSStyleValue>&
OwningCSSColorValueOrCSSStyleValue::RawSetAsCSSStyleValue()
{
  if (mType == eCSSStyleValue) {
    return mValue.mCSSStyleValue.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eCSSStyleValue;
  return mValue.mCSSStyleValue.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSStyleValue>&
OwningCSSColorValueOrCSSStyleValue::SetAsCSSStyleValue()
{
  if (mType == eCSSStyleValue) {
    return mValue.mCSSStyleValue.Value();
  }
  Uninit();
  mType = eCSSStyleValue;
  return mValue.mCSSStyleValue.SetValue();
}


void
OwningCSSColorValueOrCSSStyleValue::DestroyCSSStyleValue()
{
  MOZ_RELEASE_ASSERT(IsCSSStyleValue(), "Wrong type!");
  mValue.mCSSStyleValue.Destroy();
  mType = eUninitialized;
}



bool
OwningCSSColorValueOrCSSStyleValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSColorValue(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToCSSStyleValue(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSColorValue, CSSStyleValue");
    return false;
  }
  return true;
}

bool
OwningCSSColorValueOrCSSStyleValue::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningCSSColorValueOrCSSStyleValue::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eCSSColorValue: {
      DestroyCSSColorValue();
      break;
    }
    case eCSSStyleValue: {
      DestroyCSSStyleValue();
      break;
    }
  }
}

bool
OwningCSSColorValueOrCSSStyleValue::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eCSSColorValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSColorValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eCSSStyleValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSStyleValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningCSSColorValueOrCSSStyleValue&
OwningCSSColorValueOrCSSStyleValue::operator=(OwningCSSColorValueOrCSSStyleValue&& aOther)
{
  this->~OwningCSSColorValueOrCSSStyleValue();
  new (this) OwningCSSColorValueOrCSSStyleValue (std::move(aOther));
  return *this;
}


OwningCSSColorValueOrCSSStyleValue&
OwningCSSColorValueOrCSSStyleValue::operator=(const OwningCSSColorValueOrCSSStyleValue& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eCSSColorValue: {
      SetAsCSSColorValue() = aOther.GetAsCSSColorValue();
      break;
    }
    case eCSSStyleValue: {
      SetAsCSSStyleValue() = aOther.GetAsCSSStyleValue();
      break;
    }
  }
  return *this;
}


bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    double& memberSlot = RawSetAsDouble();
    if (!ValueToPrimitive<double, eDefault>(cx, value, "Double branch of ((double or CSSNumericValue) or (USVString or CSSKeywordValue))", &memberSlot)) {
      return false;
    } else if (!std::isfinite(memberSlot)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("Double branch of ((double or CSSNumericValue) or (USVString or CSSKeywordValue))");
      return false;
    }
  }
  return true;
}

bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToDouble(cx, value, tryNext, passedToJSImpl);
}







bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSNumericValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::CSSNumericValue>& memberSlot = RawSetAsCSSNumericValue();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSNumericValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSNumericValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl);
}







bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char>& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSKeywordValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::CSSKeywordValue>& memberSlot = RawSetAsCSSKeywordValue();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSKeywordValue, mozilla::dom::CSSKeywordValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSKeywordValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSKeywordValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSKeywordValue(cx, value, tryNext, passedToJSImpl);
}







bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToCSSKeywordValue(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      if (value.isNumber()) {
        done = (failed = !TrySetToDouble(cx, value, tryNext)) || !tryNext;
        break;
      }
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSNumericValue, CSSKeywordValue");
    return false;
  }
  return true;
}

bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
DoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eDouble: {
      rval.set(JS_NumberValue(double(mValue.mDouble.Value())));
      return true;
    }
    case eCSSNumericValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSNumericValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eCSSKeywordValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSKeywordValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue(OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eDouble: {
      mType = eDouble;
      mValue.mDouble.SetValue(std::move(aOther.mValue.mDouble.Value()));
      break;
    }
    case eCSSNumericValue: {
      mType = eCSSNumericValue;
      mValue.mCSSNumericValue.SetValue(std::move(aOther.mValue.mCSSNumericValue.Value()));
      break;
    }
    case eUTF8String: {
      mType = eUTF8String;
      mValue.mUTF8String.SetValue(std::move(aOther.mValue.mUTF8String.Value()));
      break;
    }
    case eCSSKeywordValue: {
      mType = eCSSKeywordValue;
      mValue.mCSSKeywordValue.SetValue(std::move(aOther.mValue.mCSSKeywordValue.Value()));
      break;
    }
  }
}



bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    double& memberSlot = RawSetAsDouble();
    if (!ValueToPrimitive<double, eDefault>(cx, value, "Double branch of ((double or CSSNumericValue) or (USVString or CSSKeywordValue))", &memberSlot)) {
      return false;
    } else if (!std::isfinite(memberSlot)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("Double branch of ((double or CSSNumericValue) or (USVString or CSSKeywordValue))");
      return false;
    }
  }
  return true;
}

bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToDouble(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] double&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::RawSetAsDouble()
{
  if (mType == eDouble) {
    return mValue.mDouble.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eDouble;
  return mValue.mDouble.SetValue();
}

[[nodiscard]] double&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::SetAsDouble()
{
  if (mType == eDouble) {
    return mValue.mDouble.Value();
  }
  Uninit();
  mType = eDouble;
  return mValue.mDouble.SetValue();
}


void
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::DestroyDouble()
{
  MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
  mValue.mDouble.Destroy();
  mType = eUninitialized;
}



bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSNumericValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::CSSNumericValue>& memberSlot = RawSetAsCSSNumericValue();
    static_assert(IsRefcounted<mozilla::dom::CSSNumericValue>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSNumericValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSNumericValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSNumericValue>&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::RawSetAsCSSNumericValue()
{
  if (mType == eCSSNumericValue) {
    return mValue.mCSSNumericValue.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eCSSNumericValue;
  return mValue.mCSSNumericValue.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSNumericValue>&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::SetAsCSSNumericValue()
{
  if (mType == eCSSNumericValue) {
    return mValue.mCSSNumericValue.Value();
  }
  Uninit();
  mType = eCSSNumericValue;
  return mValue.mCSSNumericValue.SetValue();
}


void
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::DestroyCSSNumericValue()
{
  MOZ_RELEASE_ASSERT(IsCSSNumericValue(), "Wrong type!");
  mValue.mCSSNumericValue.Destroy();
  mType = eUninitialized;
}



bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsCString& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsCString&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::RawSetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}

[[nodiscard]] nsCString&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::SetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  Uninit();
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}



void
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::DestroyUTF8String()
{
  MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
  mValue.mUTF8String.Destroy();
  mType = eUninitialized;
}



bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSKeywordValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::CSSKeywordValue>& memberSlot = RawSetAsCSSKeywordValue();
    static_assert(IsRefcounted<mozilla::dom::CSSKeywordValue>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSKeywordValue, mozilla::dom::CSSKeywordValue>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSKeywordValue();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::TrySetToCSSKeywordValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSKeywordValue(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSKeywordValue>&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::RawSetAsCSSKeywordValue()
{
  if (mType == eCSSKeywordValue) {
    return mValue.mCSSKeywordValue.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eCSSKeywordValue;
  return mValue.mCSSKeywordValue.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::CSSKeywordValue>&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::SetAsCSSKeywordValue()
{
  if (mType == eCSSKeywordValue) {
    return mValue.mCSSKeywordValue.Value();
  }
  Uninit();
  mType = eCSSKeywordValue;
  return mValue.mCSSKeywordValue.SetValue();
}


void
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::DestroyCSSKeywordValue()
{
  MOZ_RELEASE_ASSERT(IsCSSKeywordValue(), "Wrong type!");
  mValue.mCSSKeywordValue.Destroy();
  mType = eUninitialized;
}



bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSNumericValue(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToCSSKeywordValue(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      if (value.isNumber()) {
        done = (failed = !TrySetToDouble(cx, value, tryNext)) || !tryNext;
        break;
      }
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSNumericValue, CSSKeywordValue");
    return false;
  }
  return true;
}

bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eDouble: {
      DestroyDouble();
      break;
    }
    case eCSSNumericValue: {
      DestroyCSSNumericValue();
      break;
    }
    case eUTF8String: {
      DestroyUTF8String();
      break;
    }
    case eCSSKeywordValue: {
      DestroyCSSKeywordValue();
      break;
    }
  }
}

bool
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eDouble: {
      rval.set(JS_NumberValue(double(mValue.mDouble.Value())));
      return true;
    }
    case eCSSNumericValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSNumericValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eCSSKeywordValue: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSKeywordValue.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::operator=(OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue&& aOther)
{
  this->~OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue();
  new (this) OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue (std::move(aOther));
  return *this;
}


OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue&
OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue::operator=(const OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eDouble: {
      SetAsDouble() = aOther.GetAsDouble();
      break;
    }
    case eCSSNumericValue: {
      SetAsCSSNumericValue() = aOther.GetAsCSSNumericValue();
      break;
    }
    case eUTF8String: {
      SetAsUTF8String() = aOther.GetAsUTF8String();
      break;
    }
    case eCSSKeywordValue: {
      SetAsCSSKeywordValue() = aOther.GetAsCSSKeywordValue();
      break;
    }
  }
  return *this;
}


namespace CSSColorValue_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<CSSStyleValue_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
parse(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColorValue", "parse", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSSColorValue.parse", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  OwningCSSColorValueOrCSSStyleValue result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::CSSColorValue::Parse(global, Constify(arg0), result, rv))>, "Should be returning void here");
  mozilla::dom::CSSColorValue::Parse(global, Constify(arg0), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSColorValue.parse"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::CSSColorValue* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::CSSColorValue>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::CSSColorValue>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("parse", parse, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sStaticMethods_disablers0 = {
  WebIDLPrefIndex::NoPref, GlobalNames::DedicatedWorkerGlobalScope | GlobalNames::PaintWorkletGlobalScope | GlobalNames::ServiceWorkerGlobalScope | GlobalNames::SharedWorkerGlobalScope, false, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { &sStaticMethods_disablers0, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::CSSColorValue,
  constructors::id::CSSColorValue,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  CSSStyleValue_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::CSSColorValue>::Depth,
  prototypes::id::CSSColorValue,
  true,
  0,
  "CSSColorValue",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "CSSColorValuePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::CSSColorValue,
  PrototypeTraits<prototypes::id::CSSColorValue>::Depth,
  &sNativePropertyHooks,
  CSSStyleValue_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::layout_css_typed_om_enabled();
}

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "CSSColorValue",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::CSSColorValue>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::CSSStyleValue, prototypes::id::CSSColorValue, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::CSSColorValue>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::CSSColorValue>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::CSSColorValue>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::CSSColorValue>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::CSSColorValue* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::CSSColorValue>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::CSSColorValue*>);
  MOZ_ASSERT(static_cast<mozilla::dom::CSSStyleValue*>(aObject) ==
             reinterpret_cast<mozilla::dom::CSSStyleValue*>(aObject),
             "Multiple inheritance for mozilla::dom::CSSStyleValue is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::CSSColorValue> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::CSSColorValue);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::CSSColorValue);

  JS::Handle<JSObject*> parentProto(CSSStyleValue_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(CSSStyleValue_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "CSSColorValue",
                              ShouldExpose<CSSColorValue_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::CSSColorValue,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JSObject*
GetProtoObject(JSContext* aCx)
{
  return GetProtoObjectHandle(aCx);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSColorValue,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace CSSColorValue_Binding



} // namespace mozilla::dom
