/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"
#line 12 "Document.bnd"

#include "utils/corestrings.h"
#include "utils/libdom.h"
#include "utils/utils.h"
#include "content/hlcache.h"
#include "html/private.h"
#include "content/urldb.h"

#define HANDLER_MAGIC MAGIC(HANDLER_MAP)
#line 53 "document.c"

void dukky_document___init(duk_context *ctx, document_private_t *priv, struct dom_document *document)
{
	dukky_node___init(ctx, &priv->parent, (struct dom_node *)document);
#line 25 "Document.bnd"
#line 59 "document.c"
}

void dukky_document___fini(duk_context *ctx, document_private_t *priv)
{
	dukky_node___fini(ctx, &priv->parent);
}

static duk_ret_t dukky_document___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	document_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_document___init(ctx, priv, duk_get_pointer(ctx, 1));
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_document___destructor(duk_context *ctx)
{
	document_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_document___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_document_getElementsByTagName(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 331 "Document.bnd"

	dom_nodelist *nodes;
	dom_exception err;
	duk_size_t text_len;
	const char *text = duk_safe_to_lstring(ctx, 0, &text_len);
	dom_string *tag;

	err = dom_string_create((uint8_t*)text, text_len, &tag);

	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	err = dom_document_get_elements_by_tag_name(((node_private_t *)priv)->node,
						    tag, &nodes);
	dom_string_unref(tag);
	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	if (nodes == NULL) return 0; /* coerced to undefined */

	dukky_push_generics(ctx, "makeListProxy");

	duk_push_pointer(ctx, nodes);
	dukky_create_object(ctx, PROTO_NAME(NODELIST), 1);
	dom_nodelist_unref(nodes);

	if (dukky_pcall(ctx, 1, false) != 0) {
		NSLOG(dukky, DEBUG, "Unable to construct nodelist?");
		return 0; /* coerced to undefined */
	}

	return 1; /* The Proxy(NodeList) wrapper */
#line 152 "document.c"
}

static duk_ret_t dukky_document_getElementsByTagNameNS(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_getElementsByClassName(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_createElement(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 122 "Document.bnd"

	dom_node *newnode;
	dom_exception err;
	duk_size_t text_len;
	const char *text = duk_safe_to_lstring(ctx, 0, &text_len);
	dom_string *text_str;

	err = dom_string_create((const uint8_t*)text, text_len, &text_str);
	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	err = dom_document_create_element_ns(priv->parent.node,
					     corestring_dom_html_namespace,
					     text_str,
					     &newnode);
	if (err != DOM_NO_ERR) {
		dom_string_unref(text_str);
		return 0; /* coerced to undefined */
	}

	dom_string_unref(text_str);

	dukky_push_node(ctx, newnode);

	dom_node_unref(newnode);

	return 1;
#line 277 "document.c"
}

static duk_ret_t dukky_document_createElementNS(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 151 "Document.bnd"

	dom_node *newnode;
	dom_exception err;
	duk_size_t text_len;
	duk_size_t ns_len;
	const char *ns = duk_safe_to_lstring(ctx, 0, &ns_len);
	const char *text = duk_safe_to_lstring(ctx, 0, &text_len);
	dom_string *text_str;
	dom_string *ns_str;

	err = dom_string_create((const uint8_t*)ns, ns_len, &ns_str);
	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	err = dom_string_create((const uint8_t*)text, text_len, &text_str);
	if (err != DOM_NO_ERR) {
		dom_string_unref(ns_str);
		return 0; /* coerced to undefined */
	}

	err = dom_document_create_element_ns(priv->parent.node,
					     ns_str,
					     text_str,
					     &newnode);
	if (err != DOM_NO_ERR) {
		dom_string_unref(ns_str);
		dom_string_unref(text_str);
		return 0; /* coerced to undefined */
	}

	dom_string_unref(text_str);
	dom_string_unref(ns_str);

	dukky_push_node(ctx, newnode);

	dom_node_unref(newnode);

	return 1;
#line 351 "document.c"
}

static duk_ret_t dukky_document_createDocumentFragment(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 191 "Document.bnd"

	struct dom_document_fragment *frag = NULL;
	dom_exception err;

	err = dom_document_create_document_fragment(priv->parent.node, &frag);

	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	dukky_push_node(ctx, (dom_node *)frag);

	dom_node_unref(frag); /* The pushed node holds the reference now */

	return 1;
#line 388 "document.c"
}

static duk_ret_t dukky_document_createTextNode(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 94 "Document.bnd"

	dom_node *newnode;
	dom_exception err;
	duk_size_t text_len;
	const char *text = duk_safe_to_lstring(ctx, 0, &text_len);
	dom_string *text_str;

	err = dom_string_create((const uint8_t*)text, text_len, &text_str);
	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	err = dom_document_create_text_node(priv->parent.node,
					    text_str,
					    &newnode);
	if (err != DOM_NO_ERR) {
		dom_string_unref(text_str);
		return 0; /* coerced to undefined */
	}

	dom_string_unref(text_str);

	dukky_push_node(ctx, newnode);

	dom_node_unref(newnode);

	return 1;
#line 445 "document.c"
}

static duk_ret_t dukky_document_createComment(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_createProcessingInstruction(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_importNode(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc == 1) {
		/* 1 optional arguments need adding */
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	if (dukky_argc > 1) {
		if (!duk_is_boolean(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 1, "deep");
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_adoptNode(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_createAttribute(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_createAttributeNS(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_createEvent(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 420 "Document.bnd"

	/* Create a new event, mark it untrusted since it's new from JS */
	dom_event *evt = NULL;
	dom_exception exc;

	exc = dom_event_create(&evt);
	if (exc != DOM_NO_ERR) return 0;
	exc = dom_event_set_is_trusted(evt, false);
	if (exc != DOM_NO_ERR) { dom_event_unref(evt); return 0; }

	dukky_push_event(ctx, evt);

	dom_event_unref(evt);
	return 1;
#line 691 "document.c"
}

static duk_ret_t dukky_document_createRange(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_createNodeIterator(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc == 1) {
		/* 2 optional arguments need adding */
		duk_push_int(ctx, 2147483647);
		duk_push_null(ctx);
	} else if (dukky_argc == 2) {
		/* 1 optional arguments need adding */
		duk_push_null(ctx);
	} else if (dukky_argc > 3) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 3);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "whatToShow");
		}
	}
	if (dukky_argc > 2) {
		/* unhandled type check */
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_createTreeWalker(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc == 1) {
		/* 2 optional arguments need adding */
		duk_push_int(ctx, 2147483647);
		duk_push_null(ctx);
	} else if (dukky_argc == 2) {
		/* 1 optional arguments need adding */
		duk_push_null(ctx);
	} else if (dukky_argc > 3) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 3);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "whatToShow");
		}
	}
	if (dukky_argc > 2) {
		/* unhandled type check */
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_getElementsByName(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_open(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_close(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_write(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 27 "Document.bnd"

	struct html_content *htmlc;
	duk_size_t text_len;
	dom_exception err;
	const char *text;

	for (int i = 0; i < duk_get_top(ctx); ++i) {
		duk_safe_to_string(ctx, i);
	}
	duk_concat(ctx, duk_get_top(ctx));
	text = duk_safe_to_lstring(ctx, 0, &text_len);
	NSLOG(netsurf, DEBUG, "Writing %*s", (int)text_len, text);

	err = dom_node_get_user_data(priv->parent.node,
				     corestring_dom___ns_key_html_content_data,
				     &htmlc);
	if ((err != DOM_NO_ERR) || (htmlc == NULL)) {
		NSLOG(netsurf, INFO,
		      "error getting htmlc. parent node:%p htmlc:%p",
		      priv->parent.node, htmlc);
		return 0;
	} else if (htmlc->parser == NULL) {
		NSLOG(netsurf, INFO, "error; no parser for htmlc: %p", htmlc);
		return 0;
	}

	dom_hubbub_parser_insert_chunk(htmlc->parser,
			(uint8_t *)text, text_len);

	return 0;
#line 901 "document.c"
}

static duk_ret_t dukky_document_writeln(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 60 "Document.bnd"

	const char nl[] = "\n";
	struct html_content *htmlc;
	duk_size_t text_len;
	const char *text;
	dom_exception err;

	for (int i = 0; i < duk_get_top(ctx); ++i) {
		duk_safe_to_string(ctx, i);
	}
	duk_concat(ctx, duk_get_top(ctx));
	text = duk_safe_to_lstring(ctx, 0, &text_len);

	NSLOG(netsurf, DEBUG, "Writeln %*s", (int)text_len, text);
	err = dom_node_get_user_data(priv->parent.node,
				     corestring_dom___ns_key_html_content_data,
				     &htmlc);
	if ((err != DOM_NO_ERR) || (htmlc == NULL)) {
		NSLOG(netsurf, INFO,
		      "error getting htmlc. parent node:%p htmlc:%p",
		      priv->parent.node, htmlc);
		return 0;
	} else if (htmlc->parser == NULL) {
		NSLOG(netsurf, INFO, "error; no parser for htmlc: %p", htmlc);
		return 0;
	}

	dom_hubbub_parser_insert_chunk(htmlc->parser, (uint8_t *)text, text_len);
	dom_hubbub_parser_insert_chunk(htmlc->parser, (uint8_t *)nl, SLEN(nl));

	return 0;
#line 948 "document.c"
}

static duk_ret_t dukky_document_hasFocus(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_execCommand(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc == 1) {
		/* 2 optional arguments need adding */
		duk_push_boolean(ctx, 0);
		duk_push_string(ctx, "");
	} else if (dukky_argc == 2) {
		/* 1 optional arguments need adding */
		duk_push_string(ctx, "");
	} else if (dukky_argc > 3) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 3);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_boolean(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 1, "showUI");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_string(ctx, 2)) {
			duk_to_string(ctx, 2);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_queryCommandEnabled(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_queryCommandIndeterm(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_queryCommandState(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_queryCommandSupported(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_queryCommandValue(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_clear(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_captureEvents(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_releaseEvents(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_enableStyleSheetsForSet(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_getElementById(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 280 "Document.bnd"

	dom_string *elementId_dom;
	dom_element *element;
	dom_exception exc;
	duk_size_t text_len;
	const char *text = duk_safe_to_lstring(ctx, 0, &text_len);

	exc = dom_string_create((uint8_t*)text, text_len, &elementId_dom);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	exc = dom_document_get_element_by_id(((node_private_t *)priv)->node,
					     elementId_dom, &element);
	dom_string_unref(elementId_dom);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	if (element != NULL) {
		dukky_push_node(ctx, (dom_node *)element);
		dom_node_unref(element);
		return 1;
	}

	return 0;
#line 1332 "document.c"
}

static duk_ret_t dukky_document_prepend(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_append(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_query(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_queryAll(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_querySelector(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_querySelectorAll(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_implementation_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 437 "Document.bnd"

	/* Create a new DOMImplementation instance */
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, MAGIC(DOMImplementation));
	if (duk_is_undefined(ctx, -1)) {
		duk_pop(ctx);

		if (dukky_create_object(ctx,
					PROTO_NAME(DOMIMPLEMENTATION),
					0) != DUK_EXEC_SUCCESS) {
			return duk_error(ctx,
				  DUK_ERR_ERROR,
				  "Unable to create dom implementation object");
		}
		duk_dup(ctx, -1);
		duk_put_prop_string(ctx, -3, MAGIC(DOMImplementation));
	}
	return 1;
#line 1520 "document.c"
}

static duk_ret_t dukky_document_URL_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_documentURI_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_origin_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_compatMode_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_characterSet_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_inputEncoding_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_contentType_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_doctype_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_documentElement_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 309 "Document.bnd"

	dom_exception exc;
	dom_element *element;

	exc = dom_document_get_document_element(((node_private_t *)priv)->node,
						&element);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	if (element == NULL) {
		return 0;
	}

	dukky_push_node(ctx, (dom_node *)element);
	dom_node_unref(element);

	return 1;

#line 1675 "document.c"
}

static duk_ret_t dukky_document_location_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 267 "Document.bnd"

	/* retrieve the location object from the root object (window) */
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, "location");
	if (duk_is_undefined(ctx, -1)) {
		duk_pop(ctx);
		return 0;
	}
	return 1;
#line 1700 "document.c"
}

static duk_ret_t dukky_document_location_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	duk_ret_t get_ret;

	get_ret = dukky_document_location_getter(ctx);
	if (get_ret != 1) {
		return 0;
	}

	/* parameter ... attribute */

	duk_dup(ctx, 0);
	/* ... attribute parameter */

	/* call the putforward */
	duk_put_prop_string(ctx, -2, "href");

	return 0;
}

static duk_ret_t dukky_document_domain_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_domain_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_referrer_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_cookie_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 364 "Document.bnd"

	char *cookie_str;
	struct html_content *htmlc;
	dom_exception err;

	err = dom_node_get_user_data(priv->parent.node,
				     corestring_dom___ns_key_html_content_data,
				     &htmlc);
	if ((err == DOM_NO_ERR) && (htmlc != NULL)) {
		cookie_str = urldb_get_cookie(llcache_handle_get_url(htmlc->base.llcache), false);
		if (cookie_str != NULL) {
			duk_push_string(ctx, cookie_str);
			free(cookie_str);
		} else {
			duk_push_string(ctx, "");
		}
		return 1;
	} else {
		NSLOG(netsurf, INFO,
		      "error getting htmlc. parent node:%p htmlc:%p",
		      priv->parent.node, htmlc);
	}
	return 0;
#line 1814 "document.c"
}

static duk_ret_t dukky_document_cookie_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 390 "Document.bnd"

	struct html_content *htmlc;
	dom_exception err;

	const char * cookie_str = duk_safe_to_string(ctx, 0);

	err = dom_node_get_user_data(priv->parent.node,
				     corestring_dom___ns_key_html_content_data,
				     &htmlc);
	if ((err == DOM_NO_ERR) && (htmlc != NULL)) {
		/* At this point we need to get the given cookie string parsed
		 * and inserted into the urldb
		 */
		bool ok = urldb_set_cookie(cookie_str, /* The cookie string to set */
					   /* The location to set the cookie for */
					   llcache_handle_get_url(htmlc->base.llcache),
					   NULL); /* The referer, which we trust */
		if (!ok) {
			NSLOG(netsurf, DEEPDEBUG, "unable to set cookie: %s", cookie_str);
			/* However there's no useful way to signal that to JS */
		}
	} else {
		NSLOG(netsurf, INFO,
		      "error getting htmlc. parent node:%p htmlc:%p",
		      priv->parent.node, htmlc);
	}
	return 0;
#line 1857 "document.c"
}

static duk_ret_t dukky_document_lastModified_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_readyState_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_title_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_title_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_dir_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_dir_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_body_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 235 "Document.bnd"

	struct dom_nodelist *nodes;
	struct dom_node *retnode;
	dom_exception err;
	err = dom_document_get_elements_by_tag_name(priv->parent.node,
						    corestring_dom_BODY,
						    &nodes);
	if (err != DOM_NO_ERR) {
		return 0; /* coerced to undefined */
	}

	err = dom_nodelist_item(nodes, 0, &retnode);

	if (err != DOM_NO_ERR) {
		dom_nodelist_unref(nodes);
		return 0; /* coerced to undefined */
	}

	dom_nodelist_unref(nodes);

	if (retnode != NULL) {
		dukky_push_node(ctx, retnode);

		dom_node_unref(retnode);

		return 1;
	}

	return 0; /* coerced to undefined */
#line 1992 "document.c"
}

static duk_ret_t dukky_document_body_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_head_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 207 "Document.bnd"

	struct dom_nodelist *nodes;
	struct dom_node *retnode;
	dom_exception err;
	err = dom_document_get_elements_by_tag_name(priv->parent.node,
						    corestring_dom_HEAD,
						    &nodes);
	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	err = dom_nodelist_item(nodes, 0, &retnode);

	if (err != DOM_NO_ERR) {
		dom_nodelist_unref(nodes);
		return 0; /* coerced to undefined */
	}

	dom_nodelist_unref(nodes);

	if (retnode == NULL) return 0; /* coerced to undefined */

	dukky_push_node(ctx, retnode);

	dom_node_unref(retnode);

	return 1;
#line 2048 "document.c"
}

static duk_ret_t dukky_document_images_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_embeds_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_plugins_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_links_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_forms_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_scripts_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_cssElementMap_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_currentScript_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_defaultView_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_activeElement_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_designMode_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_designMode_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_commands_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_onreadystatechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 550 "Document.bnd"
#line 2259 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"readystatechange", 16, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onreadystatechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 551 "Document.bnd"
#line 2293 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "readystatechange", 16);
	/* handlerfn this handlers readystatechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers readystatechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_readystatechange, false);
	return 0;
}

static duk_ret_t dukky_document_fgColor_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_fgColor_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_linkColor_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_linkColor_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_vlinkColor_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_vlinkColor_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_alinkColor_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_alinkColor_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_bgColor_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_bgColor_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_anchors_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_applets_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_all_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_styleSheets_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_selectedStyleSheetSet_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_selectedStyleSheetSet_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_lastStyleSheetSet_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_preferredStyleSheetSet_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_styleSheetSets_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_children_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_firstElementChild_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_lastElementChild_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_childElementCount_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_onabort_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 458 "Document.bnd"
#line 2669 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"abort", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onabort_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 459 "Document.bnd"
#line 2703 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "abort", 5);
	/* handlerfn this handlers abort */
	duk_dup(ctx, -4);
	/* handlerfn this handlers abort handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_abort, false);
	return 0;
}

static duk_ret_t dukky_document_onautocomplete_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 462 "Document.bnd"
#line 2734 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"autocomplete", 12, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onautocomplete_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 463 "Document.bnd"
#line 2768 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "autocomplete", 12);
	/* handlerfn this handlers autocomplete */
	duk_dup(ctx, -4);
	/* handlerfn this handlers autocomplete handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_autocomplete, false);
	return 0;
}

static duk_ret_t dukky_document_onautocompleteerror_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 460 "Document.bnd"
#line 2799 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"autocompleteerror", 17, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onautocompleteerror_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 461 "Document.bnd"
#line 2833 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "autocompleteerror", 17);
	/* handlerfn this handlers autocompleteerror */
	duk_dup(ctx, -4);
	/* handlerfn this handlers autocompleteerror handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_autocompleteerror, false);
	return 0;
}

static duk_ret_t dukky_document_onblur_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 464 "Document.bnd"
#line 2864 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"blur", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onblur_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 465 "Document.bnd"
#line 2898 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "blur", 4);
	/* handlerfn this handlers blur */
	duk_dup(ctx, -4);
	/* handlerfn this handlers blur handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_blur, false);
	return 0;
}

static duk_ret_t dukky_document_oncancel_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 466 "Document.bnd"
#line 2929 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"cancel", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_oncancel_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 467 "Document.bnd"
#line 2963 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "cancel", 6);
	/* handlerfn this handlers cancel */
	duk_dup(ctx, -4);
	/* handlerfn this handlers cancel handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_cancel, false);
	return 0;
}

static duk_ret_t dukky_document_oncanplay_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 470 "Document.bnd"
#line 2994 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"canplay", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_oncanplay_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 471 "Document.bnd"
#line 3028 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "canplay", 7);
	/* handlerfn this handlers canplay */
	duk_dup(ctx, -4);
	/* handlerfn this handlers canplay handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_canplay, false);
	return 0;
}

static duk_ret_t dukky_document_oncanplaythrough_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 468 "Document.bnd"
#line 3059 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"canplaythrough", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_oncanplaythrough_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 469 "Document.bnd"
#line 3093 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "canplaythrough", 14);
	/* handlerfn this handlers canplaythrough */
	duk_dup(ctx, -4);
	/* handlerfn this handlers canplaythrough handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_canplaythrough, false);
	return 0;
}

static duk_ret_t dukky_document_onchange_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 472 "Document.bnd"
#line 3124 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"change", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onchange_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 473 "Document.bnd"
#line 3158 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "change", 6);
	/* handlerfn this handlers change */
	duk_dup(ctx, -4);
	/* handlerfn this handlers change handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_change, false);
	return 0;
}

static duk_ret_t dukky_document_onclick_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 474 "Document.bnd"
#line 3189 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"click", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onclick_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 475 "Document.bnd"
#line 3223 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "click", 5);
	/* handlerfn this handlers click */
	duk_dup(ctx, -4);
	/* handlerfn this handlers click handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_click, false);
	return 0;
}

static duk_ret_t dukky_document_onclose_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 476 "Document.bnd"
#line 3254 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"close", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onclose_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 477 "Document.bnd"
#line 3288 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "close", 5);
	/* handlerfn this handlers close */
	duk_dup(ctx, -4);
	/* handlerfn this handlers close handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_close, false);
	return 0;
}

static duk_ret_t dukky_document_oncontextmenu_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 478 "Document.bnd"
#line 3319 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"contextmenu", 11, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_oncontextmenu_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 479 "Document.bnd"
#line 3353 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "contextmenu", 11);
	/* handlerfn this handlers contextmenu */
	duk_dup(ctx, -4);
	/* handlerfn this handlers contextmenu handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_contextmenu, false);
	return 0;
}

static duk_ret_t dukky_document_oncuechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 480 "Document.bnd"
#line 3384 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"cuechange", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_oncuechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 481 "Document.bnd"
#line 3418 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "cuechange", 9);
	/* handlerfn this handlers cuechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers cuechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_cuechange, false);
	return 0;
}

static duk_ret_t dukky_document_ondblclick_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 482 "Document.bnd"
#line 3449 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dblclick", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondblclick_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 483 "Document.bnd"
#line 3483 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dblclick", 8);
	/* handlerfn this handlers dblclick */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dblclick handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dblclick, false);
	return 0;
}

static duk_ret_t dukky_document_ondrag_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 496 "Document.bnd"
#line 3514 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"drag", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondrag_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 497 "Document.bnd"
#line 3548 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "drag", 4);
	/* handlerfn this handlers drag */
	duk_dup(ctx, -4);
	/* handlerfn this handlers drag handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_drag, false);
	return 0;
}

static duk_ret_t dukky_document_ondragend_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 484 "Document.bnd"
#line 3579 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragend", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondragend_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 485 "Document.bnd"
#line 3613 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragend", 7);
	/* handlerfn this handlers dragend */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragend handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragend, false);
	return 0;
}

static duk_ret_t dukky_document_ondragenter_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 486 "Document.bnd"
#line 3644 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragenter", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondragenter_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 487 "Document.bnd"
#line 3678 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragenter", 9);
	/* handlerfn this handlers dragenter */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragenter handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragenter, false);
	return 0;
}

static duk_ret_t dukky_document_ondragexit_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 488 "Document.bnd"
#line 3709 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragexit", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondragexit_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 489 "Document.bnd"
#line 3743 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragexit", 8);
	/* handlerfn this handlers dragexit */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragexit handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragexit, false);
	return 0;
}

static duk_ret_t dukky_document_ondragleave_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 490 "Document.bnd"
#line 3774 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragleave", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondragleave_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 491 "Document.bnd"
#line 3808 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragleave", 9);
	/* handlerfn this handlers dragleave */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragleave handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragleave, false);
	return 0;
}

static duk_ret_t dukky_document_ondragover_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 492 "Document.bnd"
#line 3839 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragover", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondragover_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 493 "Document.bnd"
#line 3873 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragover", 8);
	/* handlerfn this handlers dragover */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragover handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragover, false);
	return 0;
}

static duk_ret_t dukky_document_ondragstart_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 494 "Document.bnd"
#line 3904 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragstart", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondragstart_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 495 "Document.bnd"
#line 3938 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragstart", 9);
	/* handlerfn this handlers dragstart */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragstart handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragstart, false);
	return 0;
}

static duk_ret_t dukky_document_ondrop_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 498 "Document.bnd"
#line 3969 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"drop", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondrop_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 499 "Document.bnd"
#line 4003 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "drop", 4);
	/* handlerfn this handlers drop */
	duk_dup(ctx, -4);
	/* handlerfn this handlers drop handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_drop, false);
	return 0;
}

static duk_ret_t dukky_document_ondurationchange_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 500 "Document.bnd"
#line 4034 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"durationchange", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ondurationchange_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 501 "Document.bnd"
#line 4068 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "durationchange", 14);
	/* handlerfn this handlers durationchange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers durationchange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_durationchange, false);
	return 0;
}

static duk_ret_t dukky_document_onemptied_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 502 "Document.bnd"
#line 4099 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"emptied", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onemptied_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 503 "Document.bnd"
#line 4133 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "emptied", 7);
	/* handlerfn this handlers emptied */
	duk_dup(ctx, -4);
	/* handlerfn this handlers emptied handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_emptied, false);
	return 0;
}

static duk_ret_t dukky_document_onended_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 504 "Document.bnd"
#line 4164 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"ended", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onended_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 505 "Document.bnd"
#line 4198 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "ended", 5);
	/* handlerfn this handlers ended */
	duk_dup(ctx, -4);
	/* handlerfn this handlers ended handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_ended, false);
	return 0;
}

static duk_ret_t dukky_document_onerror_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_onerror_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_document_onfocus_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 506 "Document.bnd"
#line 4259 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"focus", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onfocus_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 507 "Document.bnd"
#line 4293 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "focus", 5);
	/* handlerfn this handlers focus */
	duk_dup(ctx, -4);
	/* handlerfn this handlers focus handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_focus, false);
	return 0;
}

static duk_ret_t dukky_document_oninput_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 508 "Document.bnd"
#line 4324 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"input", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_oninput_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 509 "Document.bnd"
#line 4358 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "input", 5);
	/* handlerfn this handlers input */
	duk_dup(ctx, -4);
	/* handlerfn this handlers input handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_input, false);
	return 0;
}

static duk_ret_t dukky_document_oninvalid_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 510 "Document.bnd"
#line 4389 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"invalid", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_oninvalid_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 511 "Document.bnd"
#line 4423 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "invalid", 7);
	/* handlerfn this handlers invalid */
	duk_dup(ctx, -4);
	/* handlerfn this handlers invalid handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_invalid, false);
	return 0;
}

static duk_ret_t dukky_document_onkeydown_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 512 "Document.bnd"
#line 4454 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keydown", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onkeydown_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 513 "Document.bnd"
#line 4488 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keydown", 7);
	/* handlerfn this handlers keydown */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keydown handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keydown, false);
	return 0;
}

static duk_ret_t dukky_document_onkeypress_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 514 "Document.bnd"
#line 4519 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keypress", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onkeypress_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 515 "Document.bnd"
#line 4553 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keypress", 8);
	/* handlerfn this handlers keypress */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keypress handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keypress, false);
	return 0;
}

static duk_ret_t dukky_document_onkeyup_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 516 "Document.bnd"
#line 4584 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keyup", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onkeyup_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 517 "Document.bnd"
#line 4618 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keyup", 5);
	/* handlerfn this handlers keyup */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keyup handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keyup, false);
	return 0;
}

static duk_ret_t dukky_document_onload_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 524 "Document.bnd"
#line 4649 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"load", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onload_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 525 "Document.bnd"
#line 4683 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "load", 4);
	/* handlerfn this handlers load */
	duk_dup(ctx, -4);
	/* handlerfn this handlers load handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_load, false);
	return 0;
}

static duk_ret_t dukky_document_onloadeddata_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 518 "Document.bnd"
#line 4714 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadeddata", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onloadeddata_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 519 "Document.bnd"
#line 4748 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadeddata", 10);
	/* handlerfn this handlers loadeddata */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadeddata handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadeddata, false);
	return 0;
}

static duk_ret_t dukky_document_onloadedmetadata_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 520 "Document.bnd"
#line 4779 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadedmetadata", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onloadedmetadata_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 521 "Document.bnd"
#line 4813 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadedmetadata", 14);
	/* handlerfn this handlers loadedmetadata */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadedmetadata handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadedmetadata, false);
	return 0;
}

static duk_ret_t dukky_document_onloadstart_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 522 "Document.bnd"
#line 4844 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadstart", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onloadstart_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 523 "Document.bnd"
#line 4878 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadstart", 9);
	/* handlerfn this handlers loadstart */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadstart handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadstart, false);
	return 0;
}

static duk_ret_t dukky_document_onmousedown_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 526 "Document.bnd"
#line 4909 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mousedown", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onmousedown_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 527 "Document.bnd"
#line 4943 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mousedown", 9);
	/* handlerfn this handlers mousedown */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mousedown handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mousedown, false);
	return 0;
}

static duk_ret_t dukky_document_onmouseenter_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 528 "Document.bnd"
#line 4974 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseenter", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onmouseenter_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 529 "Document.bnd"
#line 5008 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseenter", 10);
	/* handlerfn this handlers mouseenter */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseenter handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseenter, false);
	return 0;
}

static duk_ret_t dukky_document_onmouseleave_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 530 "Document.bnd"
#line 5039 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseleave", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onmouseleave_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 531 "Document.bnd"
#line 5073 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseleave", 10);
	/* handlerfn this handlers mouseleave */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseleave handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseleave, false);
	return 0;
}

static duk_ret_t dukky_document_onmousemove_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 532 "Document.bnd"
#line 5104 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mousemove", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onmousemove_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 533 "Document.bnd"
#line 5138 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mousemove", 9);
	/* handlerfn this handlers mousemove */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mousemove handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mousemove, false);
	return 0;
}

static duk_ret_t dukky_document_onmouseout_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 534 "Document.bnd"
#line 5169 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseout", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onmouseout_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 535 "Document.bnd"
#line 5203 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseout", 8);
	/* handlerfn this handlers mouseout */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseout handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseout, false);
	return 0;
}

static duk_ret_t dukky_document_onmouseover_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 536 "Document.bnd"
#line 5234 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseover", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onmouseover_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 537 "Document.bnd"
#line 5268 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseover", 9);
	/* handlerfn this handlers mouseover */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseover handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseover, false);
	return 0;
}

static duk_ret_t dukky_document_onmouseup_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 538 "Document.bnd"
#line 5299 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseup", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onmouseup_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 539 "Document.bnd"
#line 5333 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseup", 7);
	/* handlerfn this handlers mouseup */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseup handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseup, false);
	return 0;
}

static duk_ret_t dukky_document_onwheel_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 582 "Document.bnd"
#line 5364 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"wheel", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onwheel_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 583 "Document.bnd"
#line 5398 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "wheel", 5);
	/* handlerfn this handlers wheel */
	duk_dup(ctx, -4);
	/* handlerfn this handlers wheel handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_wheel, false);
	return 0;
}

static duk_ret_t dukky_document_onpause_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 540 "Document.bnd"
#line 5429 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"pause", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onpause_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 541 "Document.bnd"
#line 5463 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "pause", 5);
	/* handlerfn this handlers pause */
	duk_dup(ctx, -4);
	/* handlerfn this handlers pause handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_pause, false);
	return 0;
}

static duk_ret_t dukky_document_onplay_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 544 "Document.bnd"
#line 5494 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"play", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onplay_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 545 "Document.bnd"
#line 5528 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "play", 4);
	/* handlerfn this handlers play */
	duk_dup(ctx, -4);
	/* handlerfn this handlers play handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_play, false);
	return 0;
}

static duk_ret_t dukky_document_onplaying_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 542 "Document.bnd"
#line 5559 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"playing", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onplaying_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 543 "Document.bnd"
#line 5593 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "playing", 7);
	/* handlerfn this handlers playing */
	duk_dup(ctx, -4);
	/* handlerfn this handlers playing handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_playing, false);
	return 0;
}

static duk_ret_t dukky_document_onprogress_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 546 "Document.bnd"
#line 5624 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"progress", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onprogress_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 547 "Document.bnd"
#line 5658 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "progress", 8);
	/* handlerfn this handlers progress */
	duk_dup(ctx, -4);
	/* handlerfn this handlers progress handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_progress, false);
	return 0;
}

static duk_ret_t dukky_document_onratechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 548 "Document.bnd"
#line 5689 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"ratechange", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onratechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 549 "Document.bnd"
#line 5723 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "ratechange", 10);
	/* handlerfn this handlers ratechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers ratechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_ratechange, false);
	return 0;
}

static duk_ret_t dukky_document_onreset_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 552 "Document.bnd"
#line 5754 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"reset", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onreset_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 553 "Document.bnd"
#line 5788 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "reset", 5);
	/* handlerfn this handlers reset */
	duk_dup(ctx, -4);
	/* handlerfn this handlers reset handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_reset, false);
	return 0;
}

static duk_ret_t dukky_document_onresize_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 554 "Document.bnd"
#line 5819 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"resize", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onresize_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 555 "Document.bnd"
#line 5853 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "resize", 6);
	/* handlerfn this handlers resize */
	duk_dup(ctx, -4);
	/* handlerfn this handlers resize handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_resize, false);
	return 0;
}

static duk_ret_t dukky_document_onscroll_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 556 "Document.bnd"
#line 5884 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"scroll", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onscroll_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 557 "Document.bnd"
#line 5918 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "scroll", 6);
	/* handlerfn this handlers scroll */
	duk_dup(ctx, -4);
	/* handlerfn this handlers scroll handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_scroll, false);
	return 0;
}

static duk_ret_t dukky_document_onseeked_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 558 "Document.bnd"
#line 5949 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"seeked", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onseeked_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 559 "Document.bnd"
#line 5983 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "seeked", 6);
	/* handlerfn this handlers seeked */
	duk_dup(ctx, -4);
	/* handlerfn this handlers seeked handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_seeked, false);
	return 0;
}

static duk_ret_t dukky_document_onseeking_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 560 "Document.bnd"
#line 6014 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"seeking", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onseeking_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 561 "Document.bnd"
#line 6048 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "seeking", 7);
	/* handlerfn this handlers seeking */
	duk_dup(ctx, -4);
	/* handlerfn this handlers seeking handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_seeking, false);
	return 0;
}

static duk_ret_t dukky_document_onselect_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 562 "Document.bnd"
#line 6079 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"select", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onselect_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 563 "Document.bnd"
#line 6113 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "select", 6);
	/* handlerfn this handlers select */
	duk_dup(ctx, -4);
	/* handlerfn this handlers select handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_select, false);
	return 0;
}

static duk_ret_t dukky_document_onshow_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 564 "Document.bnd"
#line 6144 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"show", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onshow_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 565 "Document.bnd"
#line 6178 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "show", 4);
	/* handlerfn this handlers show */
	duk_dup(ctx, -4);
	/* handlerfn this handlers show handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_show, false);
	return 0;
}

static duk_ret_t dukky_document_onsort_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 566 "Document.bnd"
#line 6209 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"sort", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onsort_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 567 "Document.bnd"
#line 6243 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "sort", 4);
	/* handlerfn this handlers sort */
	duk_dup(ctx, -4);
	/* handlerfn this handlers sort handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_sort, false);
	return 0;
}

static duk_ret_t dukky_document_onstalled_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 568 "Document.bnd"
#line 6274 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"stalled", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onstalled_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 569 "Document.bnd"
#line 6308 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "stalled", 7);
	/* handlerfn this handlers stalled */
	duk_dup(ctx, -4);
	/* handlerfn this handlers stalled handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_stalled, false);
	return 0;
}

static duk_ret_t dukky_document_onsubmit_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 570 "Document.bnd"
#line 6339 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"submit", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onsubmit_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 571 "Document.bnd"
#line 6373 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "submit", 6);
	/* handlerfn this handlers submit */
	duk_dup(ctx, -4);
	/* handlerfn this handlers submit handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_submit, false);
	return 0;
}

static duk_ret_t dukky_document_onsuspend_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 572 "Document.bnd"
#line 6404 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"suspend", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onsuspend_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 573 "Document.bnd"
#line 6438 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "suspend", 7);
	/* handlerfn this handlers suspend */
	duk_dup(ctx, -4);
	/* handlerfn this handlers suspend handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_suspend, false);
	return 0;
}

static duk_ret_t dukky_document_ontimeupdate_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 574 "Document.bnd"
#line 6469 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"timeupdate", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ontimeupdate_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 575 "Document.bnd"
#line 6503 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "timeupdate", 10);
	/* handlerfn this handlers timeupdate */
	duk_dup(ctx, -4);
	/* handlerfn this handlers timeupdate handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_timeupdate, false);
	return 0;
}

static duk_ret_t dukky_document_ontoggle_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 576 "Document.bnd"
#line 6534 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"toggle", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_ontoggle_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 577 "Document.bnd"
#line 6568 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "toggle", 6);
	/* handlerfn this handlers toggle */
	duk_dup(ctx, -4);
	/* handlerfn this handlers toggle handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_toggle, false);
	return 0;
}

static duk_ret_t dukky_document_onvolumechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 578 "Document.bnd"
#line 6599 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"volumechange", 12, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onvolumechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 579 "Document.bnd"
#line 6633 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "volumechange", 12);
	/* handlerfn this handlers volumechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers volumechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_volumechange, false);
	return 0;
}

static duk_ret_t dukky_document_onwaiting_getter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 580 "Document.bnd"
#line 6664 "document.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"waiting", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_document_onwaiting_setter(duk_context *ctx)
{
	/* Get private data for method */
	document_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 581 "Document.bnd"
#line 6698 "document.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "waiting", 7);
	/* handlerfn this handlers waiting */
	duk_dup(ctx, -4);
	/* handlerfn this handlers waiting handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_waiting, false);
	return 0;
}

duk_ret_t dukky_document___proto(duk_context *ctx, void *udata)
{
	/* Set this prototype's prototype (left-parent) */
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_NODE");
	duk_replace(ctx, -2);
	duk_set_prototype(ctx, 0);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getElementsByTagName");
	duk_push_c_function(ctx, dukky_document_getElementsByTagName, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getElementsByTagNameNS");
	duk_push_c_function(ctx, dukky_document_getElementsByTagNameNS, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getElementsByClassName");
	duk_push_c_function(ctx, dukky_document_getElementsByClassName, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createElement");
	duk_push_c_function(ctx, dukky_document_createElement, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createElementNS");
	duk_push_c_function(ctx, dukky_document_createElementNS, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createDocumentFragment");
	duk_push_c_function(ctx, dukky_document_createDocumentFragment, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createTextNode");
	duk_push_c_function(ctx, dukky_document_createTextNode, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createComment");
	duk_push_c_function(ctx, dukky_document_createComment, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createProcessingInstruction");
	duk_push_c_function(ctx, dukky_document_createProcessingInstruction, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "importNode");
	duk_push_c_function(ctx, dukky_document_importNode, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "adoptNode");
	duk_push_c_function(ctx, dukky_document_adoptNode, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createAttribute");
	duk_push_c_function(ctx, dukky_document_createAttribute, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createAttributeNS");
	duk_push_c_function(ctx, dukky_document_createAttributeNS, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createEvent");
	duk_push_c_function(ctx, dukky_document_createEvent, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createRange");
	duk_push_c_function(ctx, dukky_document_createRange, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createNodeIterator");
	duk_push_c_function(ctx, dukky_document_createNodeIterator, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createTreeWalker");
	duk_push_c_function(ctx, dukky_document_createTreeWalker, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getElementsByName");
	duk_push_c_function(ctx, dukky_document_getElementsByName, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "open");
	duk_push_c_function(ctx, dukky_document_open, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "close");
	duk_push_c_function(ctx, dukky_document_close, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "write");
	duk_push_c_function(ctx, dukky_document_write, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "writeln");
	duk_push_c_function(ctx, dukky_document_writeln, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "hasFocus");
	duk_push_c_function(ctx, dukky_document_hasFocus, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "execCommand");
	duk_push_c_function(ctx, dukky_document_execCommand, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "queryCommandEnabled");
	duk_push_c_function(ctx, dukky_document_queryCommandEnabled, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "queryCommandIndeterm");
	duk_push_c_function(ctx, dukky_document_queryCommandIndeterm, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "queryCommandState");
	duk_push_c_function(ctx, dukky_document_queryCommandState, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "queryCommandSupported");
	duk_push_c_function(ctx, dukky_document_queryCommandSupported, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "queryCommandValue");
	duk_push_c_function(ctx, dukky_document_queryCommandValue, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "clear");
	duk_push_c_function(ctx, dukky_document_clear, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "captureEvents");
	duk_push_c_function(ctx, dukky_document_captureEvents, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "releaseEvents");
	duk_push_c_function(ctx, dukky_document_releaseEvents, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "enableStyleSheetsForSet");
	duk_push_c_function(ctx, dukky_document_enableStyleSheetsForSet, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getElementById");
	duk_push_c_function(ctx, dukky_document_getElementById, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "prepend");
	duk_push_c_function(ctx, dukky_document_prepend, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "append");
	duk_push_c_function(ctx, dukky_document_append, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "query");
	duk_push_c_function(ctx, dukky_document_query, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "queryAll");
	duk_push_c_function(ctx, dukky_document_queryAll, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "querySelector");
	duk_push_c_function(ctx, dukky_document_querySelector, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "querySelectorAll");
	duk_push_c_function(ctx, dukky_document_querySelectorAll, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "implementation");
	duk_push_c_function(ctx, dukky_document_implementation_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "URL");
	duk_push_c_function(ctx, dukky_document_URL_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "documentURI");
	duk_push_c_function(ctx, dukky_document_documentURI_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "origin");
	duk_push_c_function(ctx, dukky_document_origin_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "compatMode");
	duk_push_c_function(ctx, dukky_document_compatMode_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "characterSet");
	duk_push_c_function(ctx, dukky_document_characterSet_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "inputEncoding");
	duk_push_c_function(ctx, dukky_document_inputEncoding_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "contentType");
	duk_push_c_function(ctx, dukky_document_contentType_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "doctype");
	duk_push_c_function(ctx, dukky_document_doctype_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "documentElement");
	duk_push_c_function(ctx, dukky_document_documentElement_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "location");
	duk_push_c_function(ctx, dukky_document_location_getter, 0);
	duk_push_c_function(ctx, dukky_document_location_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "domain");
	duk_push_c_function(ctx, dukky_document_domain_getter, 0);
	duk_push_c_function(ctx, dukky_document_domain_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "referrer");
	duk_push_c_function(ctx, dukky_document_referrer_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "cookie");
	duk_push_c_function(ctx, dukky_document_cookie_getter, 0);
	duk_push_c_function(ctx, dukky_document_cookie_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lastModified");
	duk_push_c_function(ctx, dukky_document_lastModified_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "readyState");
	duk_push_c_function(ctx, dukky_document_readyState_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "title");
	duk_push_c_function(ctx, dukky_document_title_getter, 0);
	duk_push_c_function(ctx, dukky_document_title_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "dir");
	duk_push_c_function(ctx, dukky_document_dir_getter, 0);
	duk_push_c_function(ctx, dukky_document_dir_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "body");
	duk_push_c_function(ctx, dukky_document_body_getter, 0);
	duk_push_c_function(ctx, dukky_document_body_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "head");
	duk_push_c_function(ctx, dukky_document_head_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "images");
	duk_push_c_function(ctx, dukky_document_images_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "embeds");
	duk_push_c_function(ctx, dukky_document_embeds_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "plugins");
	duk_push_c_function(ctx, dukky_document_plugins_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "links");
	duk_push_c_function(ctx, dukky_document_links_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "forms");
	duk_push_c_function(ctx, dukky_document_forms_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "scripts");
	duk_push_c_function(ctx, dukky_document_scripts_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "cssElementMap");
	duk_push_c_function(ctx, dukky_document_cssElementMap_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "currentScript");
	duk_push_c_function(ctx, dukky_document_currentScript_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "defaultView");
	duk_push_c_function(ctx, dukky_document_defaultView_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "activeElement");
	duk_push_c_function(ctx, dukky_document_activeElement_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "designMode");
	duk_push_c_function(ctx, dukky_document_designMode_getter, 0);
	duk_push_c_function(ctx, dukky_document_designMode_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commands");
	duk_push_c_function(ctx, dukky_document_commands_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onreadystatechange");
	duk_push_c_function(ctx, dukky_document_onreadystatechange_getter, 0);
	duk_push_c_function(ctx, dukky_document_onreadystatechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "fgColor");
	duk_push_c_function(ctx, dukky_document_fgColor_getter, 0);
	duk_push_c_function(ctx, dukky_document_fgColor_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "linkColor");
	duk_push_c_function(ctx, dukky_document_linkColor_getter, 0);
	duk_push_c_function(ctx, dukky_document_linkColor_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "vlinkColor");
	duk_push_c_function(ctx, dukky_document_vlinkColor_getter, 0);
	duk_push_c_function(ctx, dukky_document_vlinkColor_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "alinkColor");
	duk_push_c_function(ctx, dukky_document_alinkColor_getter, 0);
	duk_push_c_function(ctx, dukky_document_alinkColor_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "bgColor");
	duk_push_c_function(ctx, dukky_document_bgColor_getter, 0);
	duk_push_c_function(ctx, dukky_document_bgColor_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "anchors");
	duk_push_c_function(ctx, dukky_document_anchors_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "applets");
	duk_push_c_function(ctx, dukky_document_applets_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "all");
	duk_push_c_function(ctx, dukky_document_all_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "styleSheets");
	duk_push_c_function(ctx, dukky_document_styleSheets_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "selectedStyleSheetSet");
	duk_push_c_function(ctx, dukky_document_selectedStyleSheetSet_getter, 0);
	duk_push_c_function(ctx, dukky_document_selectedStyleSheetSet_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lastStyleSheetSet");
	duk_push_c_function(ctx, dukky_document_lastStyleSheetSet_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "preferredStyleSheetSet");
	duk_push_c_function(ctx, dukky_document_preferredStyleSheetSet_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "styleSheetSets");
	duk_push_c_function(ctx, dukky_document_styleSheetSets_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "children");
	duk_push_c_function(ctx, dukky_document_children_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "firstElementChild");
	duk_push_c_function(ctx, dukky_document_firstElementChild_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lastElementChild");
	duk_push_c_function(ctx, dukky_document_lastElementChild_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "childElementCount");
	duk_push_c_function(ctx, dukky_document_childElementCount_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onabort");
	duk_push_c_function(ctx, dukky_document_onabort_getter, 0);
	duk_push_c_function(ctx, dukky_document_onabort_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onautocomplete");
	duk_push_c_function(ctx, dukky_document_onautocomplete_getter, 0);
	duk_push_c_function(ctx, dukky_document_onautocomplete_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onautocompleteerror");
	duk_push_c_function(ctx, dukky_document_onautocompleteerror_getter, 0);
	duk_push_c_function(ctx, dukky_document_onautocompleteerror_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onblur");
	duk_push_c_function(ctx, dukky_document_onblur_getter, 0);
	duk_push_c_function(ctx, dukky_document_onblur_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncancel");
	duk_push_c_function(ctx, dukky_document_oncancel_getter, 0);
	duk_push_c_function(ctx, dukky_document_oncancel_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncanplay");
	duk_push_c_function(ctx, dukky_document_oncanplay_getter, 0);
	duk_push_c_function(ctx, dukky_document_oncanplay_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncanplaythrough");
	duk_push_c_function(ctx, dukky_document_oncanplaythrough_getter, 0);
	duk_push_c_function(ctx, dukky_document_oncanplaythrough_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onchange");
	duk_push_c_function(ctx, dukky_document_onchange_getter, 0);
	duk_push_c_function(ctx, dukky_document_onchange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onclick");
	duk_push_c_function(ctx, dukky_document_onclick_getter, 0);
	duk_push_c_function(ctx, dukky_document_onclick_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onclose");
	duk_push_c_function(ctx, dukky_document_onclose_getter, 0);
	duk_push_c_function(ctx, dukky_document_onclose_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncontextmenu");
	duk_push_c_function(ctx, dukky_document_oncontextmenu_getter, 0);
	duk_push_c_function(ctx, dukky_document_oncontextmenu_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncuechange");
	duk_push_c_function(ctx, dukky_document_oncuechange_getter, 0);
	duk_push_c_function(ctx, dukky_document_oncuechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondblclick");
	duk_push_c_function(ctx, dukky_document_ondblclick_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondblclick_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondrag");
	duk_push_c_function(ctx, dukky_document_ondrag_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondrag_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragend");
	duk_push_c_function(ctx, dukky_document_ondragend_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondragend_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragenter");
	duk_push_c_function(ctx, dukky_document_ondragenter_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondragenter_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragexit");
	duk_push_c_function(ctx, dukky_document_ondragexit_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondragexit_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragleave");
	duk_push_c_function(ctx, dukky_document_ondragleave_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondragleave_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragover");
	duk_push_c_function(ctx, dukky_document_ondragover_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondragover_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragstart");
	duk_push_c_function(ctx, dukky_document_ondragstart_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondragstart_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondrop");
	duk_push_c_function(ctx, dukky_document_ondrop_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondrop_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondurationchange");
	duk_push_c_function(ctx, dukky_document_ondurationchange_getter, 0);
	duk_push_c_function(ctx, dukky_document_ondurationchange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onemptied");
	duk_push_c_function(ctx, dukky_document_onemptied_getter, 0);
	duk_push_c_function(ctx, dukky_document_onemptied_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onended");
	duk_push_c_function(ctx, dukky_document_onended_getter, 0);
	duk_push_c_function(ctx, dukky_document_onended_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onerror");
	duk_push_c_function(ctx, dukky_document_onerror_getter, 0);
	duk_push_c_function(ctx, dukky_document_onerror_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onfocus");
	duk_push_c_function(ctx, dukky_document_onfocus_getter, 0);
	duk_push_c_function(ctx, dukky_document_onfocus_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oninput");
	duk_push_c_function(ctx, dukky_document_oninput_getter, 0);
	duk_push_c_function(ctx, dukky_document_oninput_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oninvalid");
	duk_push_c_function(ctx, dukky_document_oninvalid_getter, 0);
	duk_push_c_function(ctx, dukky_document_oninvalid_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeydown");
	duk_push_c_function(ctx, dukky_document_onkeydown_getter, 0);
	duk_push_c_function(ctx, dukky_document_onkeydown_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeypress");
	duk_push_c_function(ctx, dukky_document_onkeypress_getter, 0);
	duk_push_c_function(ctx, dukky_document_onkeypress_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeyup");
	duk_push_c_function(ctx, dukky_document_onkeyup_getter, 0);
	duk_push_c_function(ctx, dukky_document_onkeyup_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onload");
	duk_push_c_function(ctx, dukky_document_onload_getter, 0);
	duk_push_c_function(ctx, dukky_document_onload_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadeddata");
	duk_push_c_function(ctx, dukky_document_onloadeddata_getter, 0);
	duk_push_c_function(ctx, dukky_document_onloadeddata_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadedmetadata");
	duk_push_c_function(ctx, dukky_document_onloadedmetadata_getter, 0);
	duk_push_c_function(ctx, dukky_document_onloadedmetadata_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadstart");
	duk_push_c_function(ctx, dukky_document_onloadstart_getter, 0);
	duk_push_c_function(ctx, dukky_document_onloadstart_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmousedown");
	duk_push_c_function(ctx, dukky_document_onmousedown_getter, 0);
	duk_push_c_function(ctx, dukky_document_onmousedown_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseenter");
	duk_push_c_function(ctx, dukky_document_onmouseenter_getter, 0);
	duk_push_c_function(ctx, dukky_document_onmouseenter_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseleave");
	duk_push_c_function(ctx, dukky_document_onmouseleave_getter, 0);
	duk_push_c_function(ctx, dukky_document_onmouseleave_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmousemove");
	duk_push_c_function(ctx, dukky_document_onmousemove_getter, 0);
	duk_push_c_function(ctx, dukky_document_onmousemove_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseout");
	duk_push_c_function(ctx, dukky_document_onmouseout_getter, 0);
	duk_push_c_function(ctx, dukky_document_onmouseout_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseover");
	duk_push_c_function(ctx, dukky_document_onmouseover_getter, 0);
	duk_push_c_function(ctx, dukky_document_onmouseover_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseup");
	duk_push_c_function(ctx, dukky_document_onmouseup_getter, 0);
	duk_push_c_function(ctx, dukky_document_onmouseup_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onwheel");
	duk_push_c_function(ctx, dukky_document_onwheel_getter, 0);
	duk_push_c_function(ctx, dukky_document_onwheel_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onpause");
	duk_push_c_function(ctx, dukky_document_onpause_getter, 0);
	duk_push_c_function(ctx, dukky_document_onpause_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onplay");
	duk_push_c_function(ctx, dukky_document_onplay_getter, 0);
	duk_push_c_function(ctx, dukky_document_onplay_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onplaying");
	duk_push_c_function(ctx, dukky_document_onplaying_getter, 0);
	duk_push_c_function(ctx, dukky_document_onplaying_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onprogress");
	duk_push_c_function(ctx, dukky_document_onprogress_getter, 0);
	duk_push_c_function(ctx, dukky_document_onprogress_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onratechange");
	duk_push_c_function(ctx, dukky_document_onratechange_getter, 0);
	duk_push_c_function(ctx, dukky_document_onratechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onreset");
	duk_push_c_function(ctx, dukky_document_onreset_getter, 0);
	duk_push_c_function(ctx, dukky_document_onreset_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onresize");
	duk_push_c_function(ctx, dukky_document_onresize_getter, 0);
	duk_push_c_function(ctx, dukky_document_onresize_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onscroll");
	duk_push_c_function(ctx, dukky_document_onscroll_getter, 0);
	duk_push_c_function(ctx, dukky_document_onscroll_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onseeked");
	duk_push_c_function(ctx, dukky_document_onseeked_getter, 0);
	duk_push_c_function(ctx, dukky_document_onseeked_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onseeking");
	duk_push_c_function(ctx, dukky_document_onseeking_getter, 0);
	duk_push_c_function(ctx, dukky_document_onseeking_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onselect");
	duk_push_c_function(ctx, dukky_document_onselect_getter, 0);
	duk_push_c_function(ctx, dukky_document_onselect_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onshow");
	duk_push_c_function(ctx, dukky_document_onshow_getter, 0);
	duk_push_c_function(ctx, dukky_document_onshow_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsort");
	duk_push_c_function(ctx, dukky_document_onsort_getter, 0);
	duk_push_c_function(ctx, dukky_document_onsort_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onstalled");
	duk_push_c_function(ctx, dukky_document_onstalled_getter, 0);
	duk_push_c_function(ctx, dukky_document_onstalled_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsubmit");
	duk_push_c_function(ctx, dukky_document_onsubmit_getter, 0);
	duk_push_c_function(ctx, dukky_document_onsubmit_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsuspend");
	duk_push_c_function(ctx, dukky_document_onsuspend_getter, 0);
	duk_push_c_function(ctx, dukky_document_onsuspend_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ontimeupdate");
	duk_push_c_function(ctx, dukky_document_ontimeupdate_getter, 0);
	duk_push_c_function(ctx, dukky_document_ontimeupdate_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ontoggle");
	duk_push_c_function(ctx, dukky_document_ontoggle_getter, 0);
	duk_push_c_function(ctx, dukky_document_ontoggle_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onvolumechange");
	duk_push_c_function(ctx, dukky_document_onvolumechange_getter, 0);
	duk_push_c_function(ctx, dukky_document_onvolumechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onwaiting");
	duk_push_c_function(ctx, dukky_document_onwaiting_getter, 0);
	duk_push_c_function(ctx, dukky_document_onwaiting_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_document___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_document___constructor, 2);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


