/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;

public class SingleLineJavadocCheck
extends AbstractJavadocCheck {
    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public void visitJavadocToken(DetailNode aAst) {
        if (this.isSingleLineJavadoc() && (this.hasJavadocTags(aAst) || this.hasJavadocInlineTags(aAst))) {
            this.log(aAst.getLineNumber(), "singleline.javadoc", new Object[0]);
        }
    }

    private boolean isSingleLineJavadoc() {
        DetailAST blockCommentStart = this.getBlockCommentAst();
        DetailAST blockCommentEnd = blockCommentStart.getLastChild();
        return blockCommentStart.getLineNo() == blockCommentEnd.getLineNo();
    }

    private boolean hasJavadocTags(DetailNode aJavadocRoot) {
        DetailNode javadocTagSection = JavadocUtils.findFirstToken(aJavadocRoot, 10071);
        return javadocTagSection != null;
    }

    private boolean hasJavadocInlineTags(DetailNode aJavadocRoot) {
        return JavadocUtils.branchContains(aJavadocRoot, 10072);
    }
}

