/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.dijkstra;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xmlgraphics.util.dijkstra.EdgeDirectory;
import org.apache.xmlgraphics.util.dijkstra.Vertex;

public class DijkstraAlgorithm {
    public static final int INFINITE = Integer.MAX_VALUE;
    private final Comparator penaltyComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n;
            int n2 = DijkstraAlgorithm.this.getLowestPenalty((Vertex)object);
            if (n2 < (n = DijkstraAlgorithm.this.getLowestPenalty((Vertex)object2))) {
                return -1;
            }
            if (n2 == n) {
                return ((Comparable)object).compareTo(object2);
            }
            return 1;
        }
    };
    private EdgeDirectory edgeDirectory;
    private TreeSet priorityQueue = new TreeSet(this.penaltyComparator);
    private Set finishedVertices = new HashSet();
    private Map lowestPenalties = new HashMap();
    private Map predecessors = new HashMap();

    public DijkstraAlgorithm(EdgeDirectory edgeDirectory) {
        this.edgeDirectory = edgeDirectory;
    }

    protected int getPenalty(Vertex vertex, Vertex vertex2) {
        return this.edgeDirectory.getPenalty(vertex, vertex2);
    }

    protected Iterator getDestinations(Vertex vertex) {
        return this.edgeDirectory.getDestinations(vertex);
    }

    private void reset() {
        this.finishedVertices.clear();
        this.priorityQueue.clear();
        this.lowestPenalties.clear();
        this.predecessors.clear();
    }

    public void execute(Vertex vertex, Vertex vertex2) {
        if (vertex == null || vertex2 == null) {
            throw new NullPointerException("start and destination may not be null");
        }
        this.reset();
        this.setShortestDistance(vertex, 0);
        this.priorityQueue.add(vertex);
        while (this.priorityQueue.size() > 0) {
            Vertex vertex3 = (Vertex)this.priorityQueue.first();
            this.priorityQueue.remove(vertex3);
            if (vertex2.equals(vertex3)) break;
            this.finishedVertices.add(vertex3);
            this.relax(vertex3);
        }
    }

    private void relax(Vertex vertex) {
        Iterator iterator = this.getDestinations(vertex);
        while (iterator.hasNext()) {
            int n;
            Vertex vertex2 = (Vertex)iterator.next();
            if (this.isFinished(vertex2) || (n = this.getLowestPenalty(vertex) + this.getPenalty(vertex, vertex2)) >= this.getLowestPenalty(vertex2)) continue;
            this.setShortestDistance(vertex2, n);
            this.setPredecessor(vertex2, vertex);
        }
    }

    private void setPredecessor(Vertex vertex, Vertex vertex2) {
        this.predecessors.put(vertex, vertex2);
    }

    private boolean isFinished(Vertex vertex) {
        return this.finishedVertices.contains(vertex);
    }

    private void setShortestDistance(Vertex vertex, int n) {
        this.priorityQueue.remove(vertex);
        this.lowestPenalties.put(vertex, n);
        this.priorityQueue.add(vertex);
    }

    public int getLowestPenalty(Vertex vertex) {
        Integer n = (Integer)this.lowestPenalties.get(vertex);
        return n == null ? Integer.MAX_VALUE : n;
    }

    public Vertex getPredecessor(Vertex vertex) {
        return (Vertex)this.predecessors.get(vertex);
    }
}

